/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ClinicalImpressionStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class ClinicalImpression
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ClinicalImpressionStatus", strength=BindingStrength.Value.REQUIRED, description="The workflow state of a clinical impression.", valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-status|4.0.1")
    @Required
    private final ClinicalImpressionStatus status;
    @Binding(bindingName="ClinicalImpressionStatusReason", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying the reason for the current state of a clinical impression.")
    private final CodeableConcept statusReason;
    @Summary
    @Binding(bindingName="ClinicalImpressionCode", strength=BindingStrength.Value.EXAMPLE, description="Identifies categories of clinical impressions.  This is a place-holder only.  It may be removed.")
    private final CodeableConcept code;
    @Summary
    private final String description;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element effective;
    @Summary
    private final DateTime date;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference assessor;
    @ReferenceTarget(value={"ClinicalImpression"})
    private final Reference previous;
    @Summary
    @ReferenceTarget(value={"Condition", "AllergyIntolerance"})
    private final List<Reference> problem;
    private final List<Investigation> investigation;
    private final List<Uri> protocol;
    private final String summary;
    private final List<Finding> finding;
    @Binding(bindingName="ClinicalImpressionPrognosis", strength=BindingStrength.Value.EXAMPLE, description="Prognosis or outlook findings.", valueSet="http://hl7.org/fhir/ValueSet/clinicalimpression-prognosis")
    private final List<CodeableConcept> prognosisCodeableConcept;
    @ReferenceTarget(value={"RiskAssessment"})
    private final List<Reference> prognosisReference;
    private final List<Reference> supportingInfo;
    private final List<Annotation> note;

    private ClinicalImpression(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.code = builder.code;
        this.description = builder.description;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.effective = builder.effective;
        this.date = builder.date;
        this.assessor = builder.assessor;
        this.previous = builder.previous;
        this.problem = Collections.unmodifiableList(builder.problem);
        this.investigation = Collections.unmodifiableList(builder.investigation);
        this.protocol = Collections.unmodifiableList(builder.protocol);
        this.summary = builder.summary;
        this.finding = Collections.unmodifiableList(builder.finding);
        this.prognosisCodeableConcept = Collections.unmodifiableList(builder.prognosisCodeableConcept);
        this.prognosisReference = Collections.unmodifiableList(builder.prognosisReference);
        this.supportingInfo = Collections.unmodifiableList(builder.supportingInfo);
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ClinicalImpressionStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getEffective() {
        return this.effective;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Reference getAssessor() {
        return this.assessor;
    }

    public Reference getPrevious() {
        return this.previous;
    }

    public List<Reference> getProblem() {
        return this.problem;
    }

    public List<Investigation> getInvestigation() {
        return this.investigation;
    }

    public List<Uri> getProtocol() {
        return this.protocol;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<Finding> getFinding() {
        return this.finding;
    }

    public List<CodeableConcept> getPrognosisCodeableConcept() {
        return this.prognosisCodeableConcept;
    }

    public List<Reference> getPrognosisReference() {
        return this.prognosisReference;
    }

    public List<Reference> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.statusReason != null || this.code != null || this.description != null || this.subject != null || this.encounter != null || this.effective != null || this.date != null || this.assessor != null || this.previous != null || !this.problem.isEmpty() || !this.investigation.isEmpty() || !this.protocol.isEmpty() || this.summary != null || !this.finding.isEmpty() || !this.prognosisCodeableConcept.isEmpty() || !this.prognosisReference.isEmpty() || !this.supportingInfo.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.effective, "effective", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.assessor, "assessor", visitor);
                this.accept(this.previous, "previous", visitor);
                this.accept(this.problem, "problem", visitor, Reference.class);
                this.accept(this.investigation, "investigation", visitor, Investigation.class);
                this.accept(this.protocol, "protocol", visitor, Uri.class);
                this.accept(this.summary, "summary", visitor);
                this.accept(this.finding, "finding", visitor, Finding.class);
                this.accept(this.prognosisCodeableConcept, "prognosisCodeableConcept", visitor, CodeableConcept.class);
                this.accept(this.prognosisReference, "prognosisReference", visitor, Reference.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClinicalImpression other = (ClinicalImpression)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.effective, other.effective) && Objects.equals(this.date, other.date) && Objects.equals(this.assessor, other.assessor) && Objects.equals(this.previous, other.previous) && Objects.equals(this.problem, other.problem) && Objects.equals(this.investigation, other.investigation) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.summary, other.summary) && Objects.equals(this.finding, other.finding) && Objects.equals(this.prognosisCodeableConcept, other.prognosisCodeableConcept) && Objects.equals(this.prognosisReference, other.prognosisReference) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.statusReason, this.code, this.description, this.subject, this.encounter, this.effective, this.date, this.assessor, this.previous, this.problem, this.investigation, this.protocol, this.summary, this.finding, this.prognosisCodeableConcept, this.prognosisReference, this.supportingInfo, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Finding
    extends BackboneElement {
        @Binding(bindingName="ConditionKind", strength=BindingStrength.Value.EXAMPLE, description="Identification of the Condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        private final CodeableConcept itemCodeableConcept;
        @ReferenceTarget(value={"Condition", "Observation", "Media"})
        private final Reference itemReference;
        private final String basis;

        private Finding(Builder builder) {
            super(builder);
            this.itemCodeableConcept = builder.itemCodeableConcept;
            this.itemReference = builder.itemReference;
            this.basis = builder.basis;
        }

        public CodeableConcept getItemCodeableConcept() {
            return this.itemCodeableConcept;
        }

        public Reference getItemReference() {
            return this.itemReference;
        }

        public String getBasis() {
            return this.basis;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.itemCodeableConcept != null || this.itemReference != null || this.basis != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.itemCodeableConcept, "itemCodeableConcept", visitor);
                    this.accept(this.itemReference, "itemReference", visitor);
                    this.accept(this.basis, "basis", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Finding other = (Finding)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.itemCodeableConcept, other.itemCodeableConcept) && Objects.equals(this.itemReference, other.itemReference) && Objects.equals(this.basis, other.basis);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.itemCodeableConcept, this.itemReference, this.basis);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept itemCodeableConcept;
            private Reference itemReference;
            private String basis;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder itemCodeableConcept(CodeableConcept itemCodeableConcept) {
                this.itemCodeableConcept = itemCodeableConcept;
                return this;
            }

            public Builder itemReference(Reference itemReference) {
                this.itemReference = itemReference;
                return this;
            }

            public Builder basis(java.lang.String basis) {
                this.basis = basis == null ? null : String.of(basis);
                return this;
            }

            public Builder basis(String basis) {
                this.basis = basis;
                return this;
            }

            @Override
            public Finding build() {
                Finding finding = new Finding(this);
                if (this.validating) {
                    this.validate(finding);
                }
                return finding;
            }

            protected void validate(Finding finding) {
                super.validate(finding);
                ValidationSupport.checkReferenceType(finding.itemReference, "itemReference", "Condition", "Observation", "Media");
                ValidationSupport.requireValueOrChildren(finding);
            }

            protected Builder from(Finding finding) {
                super.from(finding);
                this.itemCodeableConcept = finding.itemCodeableConcept;
                this.itemReference = finding.itemReference;
                this.basis = finding.basis;
                return this;
            }
        }
    }

    public static class Investigation
    extends BackboneElement {
        @Binding(bindingName="InvestigationGroupType", strength=BindingStrength.Value.EXAMPLE, description="A name/code for a set of investigations.", valueSet="http://hl7.org/fhir/ValueSet/investigation-sets")
        @Required
        private final CodeableConcept code;
        @ReferenceTarget(value={"Observation", "QuestionnaireResponse", "FamilyMemberHistory", "DiagnosticReport", "RiskAssessment", "ImagingStudy", "Media"})
        private final List<Reference> item;

        private Investigation(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.item = Collections.unmodifiableList(builder.item);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public List<Reference> getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.item.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.item, "item", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Investigation other = (Investigation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private List<Reference> item = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder item(Reference ... item) {
                for (Reference value : item) {
                    this.item.add(value);
                }
                return this;
            }

            public Builder item(Collection<Reference> item) {
                this.item = new ArrayList<Reference>(item);
                return this;
            }

            @Override
            public Investigation build() {
                Investigation investigation = new Investigation(this);
                if (this.validating) {
                    this.validate(investigation);
                }
                return investigation;
            }

            protected void validate(Investigation investigation) {
                super.validate(investigation);
                ValidationSupport.requireNonNull(investigation.code, "code");
                ValidationSupport.checkList(investigation.item, "item", Reference.class);
                ValidationSupport.checkReferenceType(investigation.item, "item", "Observation", "QuestionnaireResponse", "FamilyMemberHistory", "DiagnosticReport", "RiskAssessment", "ImagingStudy", "Media");
                ValidationSupport.requireValueOrChildren(investigation);
            }

            protected Builder from(Investigation investigation) {
                super.from(investigation);
                this.code = investigation.code;
                this.item.addAll(investigation.item);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ClinicalImpressionStatus status;
        private CodeableConcept statusReason;
        private CodeableConcept code;
        private String description;
        private Reference subject;
        private Reference encounter;
        private Element effective;
        private DateTime date;
        private Reference assessor;
        private Reference previous;
        private List<Reference> problem = new ArrayList<Reference>();
        private List<Investigation> investigation = new ArrayList<Investigation>();
        private List<Uri> protocol = new ArrayList<Uri>();
        private String summary;
        private List<Finding> finding = new ArrayList<Finding>();
        private List<CodeableConcept> prognosisCodeableConcept = new ArrayList<CodeableConcept>();
        private List<Reference> prognosisReference = new ArrayList<Reference>();
        private List<Reference> supportingInfo = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ClinicalImpressionStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder effective(Element effective) {
            this.effective = effective;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder assessor(Reference assessor) {
            this.assessor = assessor;
            return this;
        }

        public Builder previous(Reference previous) {
            this.previous = previous;
            return this;
        }

        public Builder problem(Reference ... problem) {
            for (Reference value : problem) {
                this.problem.add(value);
            }
            return this;
        }

        public Builder problem(Collection<Reference> problem) {
            this.problem = new ArrayList<Reference>(problem);
            return this;
        }

        public Builder investigation(Investigation ... investigation) {
            for (Investigation value : investigation) {
                this.investigation.add(value);
            }
            return this;
        }

        public Builder investigation(Collection<Investigation> investigation) {
            this.investigation = new ArrayList<Investigation>(investigation);
            return this;
        }

        public Builder protocol(Uri ... protocol) {
            for (Uri value : protocol) {
                this.protocol.add(value);
            }
            return this;
        }

        public Builder protocol(Collection<Uri> protocol) {
            this.protocol = new ArrayList<Uri>(protocol);
            return this;
        }

        public Builder summary(java.lang.String summary) {
            this.summary = summary == null ? null : String.of(summary);
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder finding(Finding ... finding) {
            for (Finding value : finding) {
                this.finding.add(value);
            }
            return this;
        }

        public Builder finding(Collection<Finding> finding) {
            this.finding = new ArrayList<Finding>(finding);
            return this;
        }

        public Builder prognosisCodeableConcept(CodeableConcept ... prognosisCodeableConcept) {
            for (CodeableConcept value : prognosisCodeableConcept) {
                this.prognosisCodeableConcept.add(value);
            }
            return this;
        }

        public Builder prognosisCodeableConcept(Collection<CodeableConcept> prognosisCodeableConcept) {
            this.prognosisCodeableConcept = new ArrayList<CodeableConcept>(prognosisCodeableConcept);
            return this;
        }

        public Builder prognosisReference(Reference ... prognosisReference) {
            for (Reference value : prognosisReference) {
                this.prognosisReference.add(value);
            }
            return this;
        }

        public Builder prognosisReference(Collection<Reference> prognosisReference) {
            this.prognosisReference = new ArrayList<Reference>(prognosisReference);
            return this;
        }

        public Builder supportingInfo(Reference ... supportingInfo) {
            for (Reference value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<Reference> supportingInfo) {
            this.supportingInfo = new ArrayList<Reference>(supportingInfo);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public ClinicalImpression build() {
            ClinicalImpression clinicalImpression = new ClinicalImpression(this);
            if (this.validating) {
                this.validate(clinicalImpression);
            }
            return clinicalImpression;
        }

        protected void validate(ClinicalImpression clinicalImpression) {
            super.validate(clinicalImpression);
            ValidationSupport.checkList(clinicalImpression.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(clinicalImpression.status, "status");
            ValidationSupport.requireNonNull(clinicalImpression.subject, "subject");
            ValidationSupport.choiceElement(clinicalImpression.effective, "effective", DateTime.class, Period.class);
            ValidationSupport.checkList(clinicalImpression.problem, "problem", Reference.class);
            ValidationSupport.checkList(clinicalImpression.investigation, "investigation", Investigation.class);
            ValidationSupport.checkList(clinicalImpression.protocol, "protocol", Uri.class);
            ValidationSupport.checkList(clinicalImpression.finding, "finding", Finding.class);
            ValidationSupport.checkList(clinicalImpression.prognosisCodeableConcept, "prognosisCodeableConcept", CodeableConcept.class);
            ValidationSupport.checkList(clinicalImpression.prognosisReference, "prognosisReference", Reference.class);
            ValidationSupport.checkList(clinicalImpression.supportingInfo, "supportingInfo", Reference.class);
            ValidationSupport.checkList(clinicalImpression.note, "note", Annotation.class);
            ValidationSupport.checkReferenceType(clinicalImpression.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(clinicalImpression.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(clinicalImpression.assessor, "assessor", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(clinicalImpression.previous, "previous", "ClinicalImpression");
            ValidationSupport.checkReferenceType(clinicalImpression.problem, "problem", "Condition", "AllergyIntolerance");
            ValidationSupport.checkReferenceType(clinicalImpression.prognosisReference, "prognosisReference", "RiskAssessment");
        }

        protected Builder from(ClinicalImpression clinicalImpression) {
            super.from(clinicalImpression);
            this.identifier.addAll(clinicalImpression.identifier);
            this.status = clinicalImpression.status;
            this.statusReason = clinicalImpression.statusReason;
            this.code = clinicalImpression.code;
            this.description = clinicalImpression.description;
            this.subject = clinicalImpression.subject;
            this.encounter = clinicalImpression.encounter;
            this.effective = clinicalImpression.effective;
            this.date = clinicalImpression.date;
            this.assessor = clinicalImpression.assessor;
            this.previous = clinicalImpression.previous;
            this.problem.addAll(clinicalImpression.problem);
            this.investigation.addAll(clinicalImpression.investigation);
            this.protocol.addAll(clinicalImpression.protocol);
            this.summary = clinicalImpression.summary;
            this.finding.addAll(clinicalImpression.finding);
            this.prognosisCodeableConcept.addAll(clinicalImpression.prognosisCodeableConcept);
            this.prognosisReference.addAll(clinicalImpression.prognosisReference);
            this.supportingInfo.addAll(clinicalImpression.supportingInfo);
            this.note.addAll(clinicalImpression.note);
            return this;
        }
    }
}

