/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ConceptMapEquivalence;
import com.ibm.fhir.model.type.code.ConceptMapGroupUnmappedMode;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cmd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ConceptMap"), @Constraint(id="cmd-1", level="Rule", location="ConceptMap.group.element.target", description="If the map is narrower or inexact, there SHALL be some comments", expression="comment.exists() or equivalence.empty() or ((equivalence != 'narrower') and (equivalence != 'inexact'))", source="http://hl7.org/fhir/StructureDefinition/ConceptMap"), @Constraint(id="cmd-2", level="Rule", location="ConceptMap.group.unmapped", description="If the mode is 'fixed', a code must be provided", expression="(mode = 'fixed') implies code.exists()", source="http://hl7.org/fhir/StructureDefinition/ConceptMap"), @Constraint(id="cmd-3", level="Rule", location="ConceptMap.group.unmapped", description="If the mode is 'other-map', a url must be provided", expression="(mode = 'other-map') implies url.exists()", source="http://hl7.org/fhir/StructureDefinition/ConceptMap"), @Constraint(id="conceptMap-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ConceptMap", generated=true)})
public class ConceptMap
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final Identifier identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    @Choice(value={Uri.class, Canonical.class})
    private final Element source;
    @Summary
    @Choice(value={Uri.class, Canonical.class})
    private final Element target;
    private final List<Group> group;

    private ConceptMap(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = builder.identifier;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.source = builder.source;
        this.target = builder.target;
        this.group = Collections.unmodifiableList(builder.group);
    }

    public Uri getUrl() {
        return this.url;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Element getSource() {
        return this.source;
    }

    public Element getTarget() {
        return this.target;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.identifier != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.source != null || this.target != null || !this.group.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.target, "target", visitor);
                this.accept(this.group, "group", visitor, Group.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptMap other = (ConceptMap)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target) && Objects.equals(this.group, other.group);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.source, this.target, this.group);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Group
    extends BackboneElement {
        private final Uri source;
        private final String sourceVersion;
        private final Uri target;
        private final String targetVersion;
        @Required
        private final List<Element> element;
        private final Unmapped unmapped;

        private Group(Builder builder) {
            super(builder);
            this.source = builder.source;
            this.sourceVersion = builder.sourceVersion;
            this.target = builder.target;
            this.targetVersion = builder.targetVersion;
            this.element = Collections.unmodifiableList(builder.element);
            this.unmapped = builder.unmapped;
        }

        public Uri getSource() {
            return this.source;
        }

        public String getSourceVersion() {
            return this.sourceVersion;
        }

        public Uri getTarget() {
            return this.target;
        }

        public String getTargetVersion() {
            return this.targetVersion;
        }

        public List<Element> getElement() {
            return this.element;
        }

        public Unmapped getUnmapped() {
            return this.unmapped;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.source != null || this.sourceVersion != null || this.target != null || this.targetVersion != null || !this.element.isEmpty() || this.unmapped != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.source, "source", visitor);
                    this.accept(this.sourceVersion, "sourceVersion", visitor);
                    this.accept(this.target, "target", visitor);
                    this.accept(this.targetVersion, "targetVersion", visitor);
                    this.accept(this.element, "element", visitor, Element.class);
                    this.accept(this.unmapped, "unmapped", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceVersion, other.sourceVersion) && Objects.equals(this.target, other.target) && Objects.equals(this.targetVersion, other.targetVersion) && Objects.equals(this.element, other.element) && Objects.equals(this.unmapped, other.unmapped);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.source, this.sourceVersion, this.target, this.targetVersion, this.element, this.unmapped);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Unmapped
        extends BackboneElement {
            @Binding(bindingName="ConceptMapGroupUnmappedMode", strength=BindingStrength.Value.REQUIRED, description="Defines which action to take if there is no match in the group.", valueSet="http://hl7.org/fhir/ValueSet/conceptmap-unmapped-mode|4.0.1")
            @Required
            private final ConceptMapGroupUnmappedMode mode;
            private final Code code;
            private final String display;
            private final Canonical url;

            private Unmapped(Builder builder) {
                super(builder);
                this.mode = builder.mode;
                this.code = builder.code;
                this.display = builder.display;
                this.url = builder.url;
            }

            public ConceptMapGroupUnmappedMode getMode() {
                return this.mode;
            }

            public Code getCode() {
                return this.code;
            }

            public String getDisplay() {
                return this.display;
            }

            public Canonical getUrl() {
                return this.url;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.mode != null || this.code != null || this.display != null || this.url != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.mode, "mode", visitor);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.display, "display", visitor);
                        this.accept(this.url, "url", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Unmapped other = (Unmapped)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.url, other.url);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.code, this.display, this.url);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ConceptMapGroupUnmappedMode mode;
                private Code code;
                private String display;
                private Canonical url;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder mode(ConceptMapGroupUnmappedMode mode) {
                    this.mode = mode;
                    return this;
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder display(java.lang.String display) {
                    this.display = display == null ? null : String.of(display);
                    return this;
                }

                public Builder display(String display) {
                    this.display = display;
                    return this;
                }

                public Builder url(Canonical url) {
                    this.url = url;
                    return this;
                }

                @Override
                public Unmapped build() {
                    Unmapped unmapped = new Unmapped(this);
                    if (this.validating) {
                        this.validate(unmapped);
                    }
                    return unmapped;
                }

                protected void validate(Unmapped unmapped) {
                    super.validate(unmapped);
                    ValidationSupport.requireNonNull(unmapped.mode, "mode");
                    ValidationSupport.requireValueOrChildren(unmapped);
                }

                protected Builder from(Unmapped unmapped) {
                    super.from(unmapped);
                    this.mode = unmapped.mode;
                    this.code = unmapped.code;
                    this.display = unmapped.display;
                    this.url = unmapped.url;
                    return this;
                }
            }
        }

        public static class Element
        extends BackboneElement {
            private final Code code;
            private final String display;
            private final List<Target> target;

            private Element(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.display = builder.display;
                this.target = Collections.unmodifiableList(builder.target);
            }

            public Code getCode() {
                return this.code;
            }

            public String getDisplay() {
                return this.display;
            }

            public List<Target> getTarget() {
                return this.target;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.display != null || !this.target.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.display, "display", visitor);
                        this.accept(this.target, "target", visitor, Target.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Element other = (Element)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.target, other.target);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.display, this.target);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Target
            extends BackboneElement {
                private final Code code;
                private final String display;
                @Binding(bindingName="ConceptMapEquivalence", strength=BindingStrength.Value.REQUIRED, description="The degree of equivalence between concepts.", valueSet="http://hl7.org/fhir/ValueSet/concept-map-equivalence|4.0.1")
                @Required
                private final ConceptMapEquivalence equivalence;
                private final String comment;
                private final List<DependsOn> dependsOn;
                private final List<DependsOn> product;

                private Target(Builder builder) {
                    super(builder);
                    this.code = builder.code;
                    this.display = builder.display;
                    this.equivalence = builder.equivalence;
                    this.comment = builder.comment;
                    this.dependsOn = Collections.unmodifiableList(builder.dependsOn);
                    this.product = Collections.unmodifiableList(builder.product);
                }

                public Code getCode() {
                    return this.code;
                }

                public String getDisplay() {
                    return this.display;
                }

                public ConceptMapEquivalence getEquivalence() {
                    return this.equivalence;
                }

                public String getComment() {
                    return this.comment;
                }

                public List<DependsOn> getDependsOn() {
                    return this.dependsOn;
                }

                public List<DependsOn> getProduct() {
                    return this.product;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.code != null || this.display != null || this.equivalence != null || this.comment != null || !this.dependsOn.isEmpty() || !this.product.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.display, "display", visitor);
                            this.accept(this.equivalence, "equivalence", visitor);
                            this.accept(this.comment, "comment", visitor);
                            this.accept(this.dependsOn, "dependsOn", visitor, DependsOn.class);
                            this.accept(this.product, "product", visitor, DependsOn.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Target other = (Target)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.equivalence, other.equivalence) && Objects.equals(this.comment, other.comment) && Objects.equals(this.dependsOn, other.dependsOn) && Objects.equals(this.product, other.product);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.display, this.equivalence, this.comment, this.dependsOn, this.product);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class DependsOn
                extends BackboneElement {
                    @Required
                    private final Uri property;
                    private final Canonical system;
                    @Required
                    private final String value;
                    private final String display;

                    private DependsOn(Builder builder) {
                        super(builder);
                        this.property = builder.property;
                        this.system = builder.system;
                        this.value = builder.value;
                        this.display = builder.display;
                    }

                    public Uri getProperty() {
                        return this.property;
                    }

                    public Canonical getSystem() {
                        return this.system;
                    }

                    public String getValue() {
                        return this.value;
                    }

                    public String getDisplay() {
                        return this.display;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.property != null || this.system != null || this.value != null || this.display != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.property, "property", visitor);
                                this.accept(this.system, "system", visitor);
                                this.accept(this.value, "value", visitor);
                                this.accept(this.display, "display", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        DependsOn other = (DependsOn)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.property, other.property) && Objects.equals(this.system, other.system) && Objects.equals(this.value, other.value) && Objects.equals(this.display, other.display);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.property, this.system, this.value, this.display);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private Uri property;
                        private Canonical system;
                        private String value;
                        private String display;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder property(Uri property) {
                            this.property = property;
                            return this;
                        }

                        public Builder system(Canonical system) {
                            this.system = system;
                            return this;
                        }

                        public Builder value(java.lang.String value) {
                            this.value = value == null ? null : String.of(value);
                            return this;
                        }

                        public Builder value(String value) {
                            this.value = value;
                            return this;
                        }

                        public Builder display(java.lang.String display) {
                            this.display = display == null ? null : String.of(display);
                            return this;
                        }

                        public Builder display(String display) {
                            this.display = display;
                            return this;
                        }

                        @Override
                        public DependsOn build() {
                            DependsOn dependsOn = new DependsOn(this);
                            if (this.validating) {
                                this.validate(dependsOn);
                            }
                            return dependsOn;
                        }

                        protected void validate(DependsOn dependsOn) {
                            super.validate(dependsOn);
                            ValidationSupport.requireNonNull(dependsOn.property, "property");
                            ValidationSupport.requireNonNull(dependsOn.value, "value");
                            ValidationSupport.requireValueOrChildren(dependsOn);
                        }

                        protected Builder from(DependsOn dependsOn) {
                            super.from(dependsOn);
                            this.property = dependsOn.property;
                            this.system = dependsOn.system;
                            this.value = dependsOn.value;
                            this.display = dependsOn.display;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Code code;
                    private String display;
                    private ConceptMapEquivalence equivalence;
                    private String comment;
                    private List<DependsOn> dependsOn = new ArrayList<DependsOn>();
                    private List<DependsOn> product = new ArrayList<DependsOn>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder code(Code code) {
                        this.code = code;
                        return this;
                    }

                    public Builder display(java.lang.String display) {
                        this.display = display == null ? null : String.of(display);
                        return this;
                    }

                    public Builder display(String display) {
                        this.display = display;
                        return this;
                    }

                    public Builder equivalence(ConceptMapEquivalence equivalence) {
                        this.equivalence = equivalence;
                        return this;
                    }

                    public Builder comment(java.lang.String comment) {
                        this.comment = comment == null ? null : String.of(comment);
                        return this;
                    }

                    public Builder comment(String comment) {
                        this.comment = comment;
                        return this;
                    }

                    public Builder dependsOn(DependsOn ... dependsOn) {
                        for (DependsOn value : dependsOn) {
                            this.dependsOn.add(value);
                        }
                        return this;
                    }

                    public Builder dependsOn(Collection<DependsOn> dependsOn) {
                        this.dependsOn = new ArrayList<DependsOn>(dependsOn);
                        return this;
                    }

                    public Builder product(DependsOn ... product) {
                        for (DependsOn value : product) {
                            this.product.add(value);
                        }
                        return this;
                    }

                    public Builder product(Collection<DependsOn> product) {
                        this.product = new ArrayList<DependsOn>(product);
                        return this;
                    }

                    @Override
                    public Target build() {
                        Target target = new Target(this);
                        if (this.validating) {
                            this.validate(target);
                        }
                        return target;
                    }

                    protected void validate(Target target) {
                        super.validate(target);
                        ValidationSupport.requireNonNull(target.equivalence, "equivalence");
                        ValidationSupport.checkList(target.dependsOn, "dependsOn", DependsOn.class);
                        ValidationSupport.checkList(target.product, "product", DependsOn.class);
                        ValidationSupport.requireValueOrChildren(target);
                    }

                    protected Builder from(Target target) {
                        super.from(target);
                        this.code = target.code;
                        this.display = target.display;
                        this.equivalence = target.equivalence;
                        this.comment = target.comment;
                        this.dependsOn.addAll(target.dependsOn);
                        this.product.addAll(target.product);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code code;
                private String display;
                private List<Target> target = new ArrayList<Target>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder display(java.lang.String display) {
                    this.display = display == null ? null : String.of(display);
                    return this;
                }

                public Builder display(String display) {
                    this.display = display;
                    return this;
                }

                public Builder target(Target ... target) {
                    for (Target value : target) {
                        this.target.add(value);
                    }
                    return this;
                }

                public Builder target(Collection<Target> target) {
                    this.target = new ArrayList<Target>(target);
                    return this;
                }

                @Override
                public Element build() {
                    Element element = new Element(this);
                    if (this.validating) {
                        this.validate(element);
                    }
                    return element;
                }

                protected void validate(Element element) {
                    super.validate(element);
                    ValidationSupport.checkList(element.target, "target", Target.class);
                    ValidationSupport.requireValueOrChildren(element);
                }

                protected Builder from(Element element) {
                    super.from(element);
                    this.code = element.code;
                    this.display = element.display;
                    this.target.addAll(element.target);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Uri source;
            private String sourceVersion;
            private Uri target;
            private String targetVersion;
            private List<Element> element = new ArrayList<Element>();
            private Unmapped unmapped;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder source(Uri source) {
                this.source = source;
                return this;
            }

            public Builder sourceVersion(java.lang.String sourceVersion) {
                this.sourceVersion = sourceVersion == null ? null : String.of(sourceVersion);
                return this;
            }

            public Builder sourceVersion(String sourceVersion) {
                this.sourceVersion = sourceVersion;
                return this;
            }

            public Builder target(Uri target) {
                this.target = target;
                return this;
            }

            public Builder targetVersion(java.lang.String targetVersion) {
                this.targetVersion = targetVersion == null ? null : String.of(targetVersion);
                return this;
            }

            public Builder targetVersion(String targetVersion) {
                this.targetVersion = targetVersion;
                return this;
            }

            public Builder element(Element ... element) {
                for (Element value : element) {
                    this.element.add(value);
                }
                return this;
            }

            public Builder element(Collection<Element> element) {
                this.element = new ArrayList<Element>(element);
                return this;
            }

            public Builder unmapped(Unmapped unmapped) {
                this.unmapped = unmapped;
                return this;
            }

            @Override
            public Group build() {
                Group group = new Group(this);
                if (this.validating) {
                    this.validate(group);
                }
                return group;
            }

            protected void validate(Group group) {
                super.validate(group);
                ValidationSupport.checkNonEmptyList(group.element, "element", Element.class);
                ValidationSupport.requireValueOrChildren(group);
            }

            protected Builder from(Group group) {
                super.from(group);
                this.source = group.source;
                this.sourceVersion = group.sourceVersion;
                this.target = group.target;
                this.targetVersion = group.targetVersion;
                this.element.addAll(group.element);
                this.unmapped = group.unmapped;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private Identifier identifier;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Element source;
        private Element target;
        private List<Group> group = new ArrayList<Group>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder source(Element source) {
            this.source = source;
            return this;
        }

        public Builder target(Element target) {
            this.target = target;
            return this;
        }

        public Builder group(Group ... group) {
            for (Group value : group) {
                this.group.add(value);
            }
            return this;
        }

        public Builder group(Collection<Group> group) {
            this.group = new ArrayList<Group>(group);
            return this;
        }

        @Override
        public ConceptMap build() {
            ConceptMap conceptMap = new ConceptMap(this);
            if (this.validating) {
                this.validate(conceptMap);
            }
            return conceptMap;
        }

        protected void validate(ConceptMap conceptMap) {
            super.validate(conceptMap);
            ValidationSupport.requireNonNull(conceptMap.status, "status");
            ValidationSupport.checkList(conceptMap.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(conceptMap.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(conceptMap.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.choiceElement(conceptMap.source, "source", Uri.class, Canonical.class);
            ValidationSupport.choiceElement(conceptMap.target, "target", Uri.class, Canonical.class);
            ValidationSupport.checkList(conceptMap.group, "group", Group.class);
        }

        protected Builder from(ConceptMap conceptMap) {
            super.from(conceptMap);
            this.url = conceptMap.url;
            this.identifier = conceptMap.identifier;
            this.version = conceptMap.version;
            this.name = conceptMap.name;
            this.title = conceptMap.title;
            this.status = conceptMap.status;
            this.experimental = conceptMap.experimental;
            this.date = conceptMap.date;
            this.publisher = conceptMap.publisher;
            this.contact.addAll(conceptMap.contact);
            this.description = conceptMap.description;
            this.useContext.addAll(conceptMap.useContext);
            this.jurisdiction.addAll(conceptMap.jurisdiction);
            this.purpose = conceptMap.purpose;
            this.copyright = conceptMap.copyright;
            this.source = conceptMap.source;
            this.target = conceptMap.target;
            this.group.addAll(conceptMap.group);
            return this;
        }
    }
}

