/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EligibilityResponsePurpose;
import com.ibm.fhir.model.type.code.EligibilityResponseStatus;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="ces-1", level="Rule", location="CoverageEligibilityResponse.insurance.item", description="SHALL contain a category or a billcode but not both.", expression="category.exists() xor productOrService.exists()", source="http://hl7.org/fhir/StructureDefinition/CoverageEligibilityResponse")
public class CoverageEligibilityResponse
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EligibilityResponseStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final EligibilityResponseStatus status;
    @Summary
    @Binding(bindingName="EligibilityResponsePurpose", strength=BindingStrength.Value.REQUIRED, description="A code specifying the types of information being requested.", valueSet="http://hl7.org/fhir/ValueSet/eligibilityresponse-purpose|4.0.1")
    @Required
    private final List<EligibilityResponsePurpose> purpose;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Choice(value={Date.class, Period.class})
    private final Element serviced;
    @Summary
    @Required
    private final DateTime created;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference requestor;
    @Summary
    @ReferenceTarget(value={"CoverageEligibilityRequest"})
    @Required
    private final Reference request;
    @Summary
    @Binding(bindingName="RemittanceOutcome", strength=BindingStrength.Value.REQUIRED, description="The outcome of the processing.", valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome|4.0.1")
    @Required
    private final RemittanceOutcome outcome;
    private final String disposition;
    @Summary
    @ReferenceTarget(value={"Organization"})
    @Required
    private final Reference insurer;
    private final List<Insurance> insurance;
    private final String preAuthRef;
    @Binding(bindingName="Forms", strength=BindingStrength.Value.EXAMPLE, description="The forms codes.", valueSet="http://hl7.org/fhir/ValueSet/forms")
    private final CodeableConcept form;
    private final List<Error> error;

    private CoverageEligibilityResponse(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.purpose = Collections.unmodifiableList(builder.purpose);
        this.patient = builder.patient;
        this.serviced = builder.serviced;
        this.created = builder.created;
        this.requestor = builder.requestor;
        this.request = builder.request;
        this.outcome = builder.outcome;
        this.disposition = builder.disposition;
        this.insurer = builder.insurer;
        this.insurance = Collections.unmodifiableList(builder.insurance);
        this.preAuthRef = builder.preAuthRef;
        this.form = builder.form;
        this.error = Collections.unmodifiableList(builder.error);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EligibilityResponseStatus getStatus() {
        return this.status;
    }

    public List<EligibilityResponsePurpose> getPurpose() {
        return this.purpose;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Element getServiced() {
        return this.serviced;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getRequestor() {
        return this.requestor;
    }

    public Reference getRequest() {
        return this.request;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public Reference getInsurer() {
        return this.insurer;
    }

    public List<Insurance> getInsurance() {
        return this.insurance;
    }

    public String getPreAuthRef() {
        return this.preAuthRef;
    }

    public CodeableConcept getForm() {
        return this.form;
    }

    public List<Error> getError() {
        return this.error;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.purpose.isEmpty() || this.patient != null || this.serviced != null || this.created != null || this.requestor != null || this.request != null || this.outcome != null || this.disposition != null || this.insurer != null || !this.insurance.isEmpty() || this.preAuthRef != null || this.form != null || !this.error.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.purpose, "purpose", visitor, EligibilityResponsePurpose.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.serviced, "serviced", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.requestor, "requestor", visitor);
                this.accept(this.request, "request", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.disposition, "disposition", visitor);
                this.accept(this.insurer, "insurer", visitor);
                this.accept(this.insurance, "insurance", visitor, Insurance.class);
                this.accept(this.preAuthRef, "preAuthRef", visitor);
                this.accept(this.form, "form", visitor);
                this.accept(this.error, "error", visitor, Error.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverageEligibilityResponse other = (CoverageEligibilityResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.patient, other.patient) && Objects.equals(this.serviced, other.serviced) && Objects.equals(this.created, other.created) && Objects.equals(this.requestor, other.requestor) && Objects.equals(this.request, other.request) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.disposition, other.disposition) && Objects.equals(this.insurer, other.insurer) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.preAuthRef, other.preAuthRef) && Objects.equals(this.form, other.form) && Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.purpose, this.patient, this.serviced, this.created, this.requestor, this.request, this.outcome, this.disposition, this.insurer, this.insurance, this.preAuthRef, this.form, this.error);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Error
    extends BackboneElement {
        @Binding(bindingName="AdjudicationError", strength=BindingStrength.Value.EXAMPLE, description="The error codes for adjudication processing.", valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        @Required
        private final CodeableConcept code;

        private Error(Builder builder) {
            super(builder);
            this.code = builder.code;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            @Override
            public Error build() {
                Error error = new Error(this);
                if (this.validating) {
                    this.validate(error);
                }
                return error;
            }

            protected void validate(Error error) {
                super.validate(error);
                ValidationSupport.requireNonNull(error.code, "code");
                ValidationSupport.requireValueOrChildren(error);
            }

            protected Builder from(Error error) {
                super.from(error);
                this.code = error.code;
                return this;
            }
        }
    }

    public static class Insurance
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Coverage"})
        @Required
        private final Reference coverage;
        private final Boolean inforce;
        private final Period benefitPeriod;
        private final List<Item> item;

        private Insurance(Builder builder) {
            super(builder);
            this.coverage = builder.coverage;
            this.inforce = builder.inforce;
            this.benefitPeriod = builder.benefitPeriod;
            this.item = Collections.unmodifiableList(builder.item);
        }

        public Reference getCoverage() {
            return this.coverage;
        }

        public Boolean getInforce() {
            return this.inforce;
        }

        public Period getBenefitPeriod() {
            return this.benefitPeriod;
        }

        public List<Item> getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.coverage != null || this.inforce != null || this.benefitPeriod != null || !this.item.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.coverage, "coverage", visitor);
                    this.accept(this.inforce, "inforce", visitor);
                    this.accept(this.benefitPeriod, "benefitPeriod", visitor);
                    this.accept(this.item, "item", visitor, Item.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Insurance other = (Insurance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.inforce, other.inforce) && Objects.equals(this.benefitPeriod, other.benefitPeriod) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.coverage, this.inforce, this.benefitPeriod, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Item
        extends BackboneElement {
            @Binding(bindingName="BenefitCategory", strength=BindingStrength.Value.EXAMPLE, description="Benefit categories such as: oral, medical, vision etc.", valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
            private final CodeableConcept category;
            @Binding(bindingName="ServiceProduct", strength=BindingStrength.Value.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
            private final CodeableConcept productOrService;
            @Binding(bindingName="Modifiers", strength=BindingStrength.Value.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
            private final List<CodeableConcept> modifier;
            @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
            private final Reference provider;
            private final Boolean excluded;
            private final String name;
            private final String description;
            @Binding(bindingName="BenefitNetwork", strength=BindingStrength.Value.EXAMPLE, description="Code to classify in or out of network services.", valueSet="http://hl7.org/fhir/ValueSet/benefit-network")
            private final CodeableConcept network;
            @Binding(bindingName="BenefitUnit", strength=BindingStrength.Value.EXAMPLE, description="Unit covered/serviced - individual or family.", valueSet="http://hl7.org/fhir/ValueSet/benefit-unit")
            private final CodeableConcept unit;
            @Binding(bindingName="BenefitTerm", strength=BindingStrength.Value.EXAMPLE, description="Coverage unit - annual, lifetime.", valueSet="http://hl7.org/fhir/ValueSet/benefit-term")
            private final CodeableConcept term;
            private final List<Benefit> benefit;
            private final Boolean authorizationRequired;
            @Binding(bindingName="AuthSupporting", strength=BindingStrength.Value.EXAMPLE, description="Type of supporting information to provide with a preauthorization.", valueSet="http://hl7.org/fhir/ValueSet/coverageeligibilityresponse-ex-auth-support")
            private final List<CodeableConcept> authorizationSupporting;
            private final Uri authorizationUrl;

            private Item(Builder builder) {
                super(builder);
                this.category = builder.category;
                this.productOrService = builder.productOrService;
                this.modifier = Collections.unmodifiableList(builder.modifier);
                this.provider = builder.provider;
                this.excluded = builder.excluded;
                this.name = builder.name;
                this.description = builder.description;
                this.network = builder.network;
                this.unit = builder.unit;
                this.term = builder.term;
                this.benefit = Collections.unmodifiableList(builder.benefit);
                this.authorizationRequired = builder.authorizationRequired;
                this.authorizationSupporting = Collections.unmodifiableList(builder.authorizationSupporting);
                this.authorizationUrl = builder.authorizationUrl;
            }

            public CodeableConcept getCategory() {
                return this.category;
            }

            public CodeableConcept getProductOrService() {
                return this.productOrService;
            }

            public List<CodeableConcept> getModifier() {
                return this.modifier;
            }

            public Reference getProvider() {
                return this.provider;
            }

            public Boolean getExcluded() {
                return this.excluded;
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public CodeableConcept getNetwork() {
                return this.network;
            }

            public CodeableConcept getUnit() {
                return this.unit;
            }

            public CodeableConcept getTerm() {
                return this.term;
            }

            public List<Benefit> getBenefit() {
                return this.benefit;
            }

            public Boolean getAuthorizationRequired() {
                return this.authorizationRequired;
            }

            public List<CodeableConcept> getAuthorizationSupporting() {
                return this.authorizationSupporting;
            }

            public Uri getAuthorizationUrl() {
                return this.authorizationUrl;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.category != null || this.productOrService != null || !this.modifier.isEmpty() || this.provider != null || this.excluded != null || this.name != null || this.description != null || this.network != null || this.unit != null || this.term != null || !this.benefit.isEmpty() || this.authorizationRequired != null || !this.authorizationSupporting.isEmpty() || this.authorizationUrl != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.category, "category", visitor);
                        this.accept(this.productOrService, "productOrService", visitor);
                        this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                        this.accept(this.provider, "provider", visitor);
                        this.accept(this.excluded, "excluded", visitor);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.network, "network", visitor);
                        this.accept(this.unit, "unit", visitor);
                        this.accept(this.term, "term", visitor);
                        this.accept(this.benefit, "benefit", visitor, Benefit.class);
                        this.accept(this.authorizationRequired, "authorizationRequired", visitor);
                        this.accept(this.authorizationSupporting, "authorizationSupporting", visitor, CodeableConcept.class);
                        this.accept(this.authorizationUrl, "authorizationUrl", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Item other = (Item)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.provider, other.provider) && Objects.equals(this.excluded, other.excluded) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.network, other.network) && Objects.equals(this.unit, other.unit) && Objects.equals(this.term, other.term) && Objects.equals(this.benefit, other.benefit) && Objects.equals(this.authorizationRequired, other.authorizationRequired) && Objects.equals(this.authorizationSupporting, other.authorizationSupporting) && Objects.equals(this.authorizationUrl, other.authorizationUrl);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.productOrService, this.modifier, this.provider, this.excluded, this.name, this.description, this.network, this.unit, this.term, this.benefit, this.authorizationRequired, this.authorizationSupporting, this.authorizationUrl);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Benefit
            extends BackboneElement {
                @Binding(bindingName="BenefitType", strength=BindingStrength.Value.EXAMPLE, description="Deductable, visits, co-pay, etc.", valueSet="http://hl7.org/fhir/ValueSet/benefit-type")
                @Required
                private final CodeableConcept type;
                @Choice(value={UnsignedInt.class, String.class, Money.class})
                private final Element allowed;
                @Choice(value={UnsignedInt.class, String.class, Money.class})
                private final Element used;

                private Benefit(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.allowed = builder.allowed;
                    this.used = builder.used;
                }

                public CodeableConcept getType() {
                    return this.type;
                }

                public Element getAllowed() {
                    return this.allowed;
                }

                public Element getUsed() {
                    return this.used;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || this.allowed != null || this.used != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.allowed, "allowed", visitor);
                            this.accept(this.used, "used", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Benefit other = (Benefit)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.allowed, other.allowed) && Objects.equals(this.used, other.used);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.allowed, this.used);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept type;
                    private Element allowed;
                    private Element used;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(CodeableConcept type) {
                        this.type = type;
                        return this;
                    }

                    public Builder allowed(java.lang.String allowed) {
                        this.allowed = allowed == null ? null : String.of(allowed);
                        return this;
                    }

                    public Builder allowed(Element allowed) {
                        this.allowed = allowed;
                        return this;
                    }

                    public Builder used(java.lang.String used) {
                        this.used = used == null ? null : String.of(used);
                        return this;
                    }

                    public Builder used(Element used) {
                        this.used = used;
                        return this;
                    }

                    @Override
                    public Benefit build() {
                        Benefit benefit = new Benefit(this);
                        if (this.validating) {
                            this.validate(benefit);
                        }
                        return benefit;
                    }

                    protected void validate(Benefit benefit) {
                        super.validate(benefit);
                        ValidationSupport.requireNonNull(benefit.type, "type");
                        ValidationSupport.choiceElement(benefit.allowed, "allowed", UnsignedInt.class, String.class, Money.class);
                        ValidationSupport.choiceElement(benefit.used, "used", UnsignedInt.class, String.class, Money.class);
                        ValidationSupport.requireValueOrChildren(benefit);
                    }

                    protected Builder from(Benefit benefit) {
                        super.from(benefit);
                        this.type = benefit.type;
                        this.allowed = benefit.allowed;
                        this.used = benefit.used;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept category;
                private CodeableConcept productOrService;
                private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
                private Reference provider;
                private Boolean excluded;
                private String name;
                private String description;
                private CodeableConcept network;
                private CodeableConcept unit;
                private CodeableConcept term;
                private List<Benefit> benefit = new ArrayList<Benefit>();
                private Boolean authorizationRequired;
                private List<CodeableConcept> authorizationSupporting = new ArrayList<CodeableConcept>();
                private Uri authorizationUrl;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder category(CodeableConcept category) {
                    this.category = category;
                    return this;
                }

                public Builder productOrService(CodeableConcept productOrService) {
                    this.productOrService = productOrService;
                    return this;
                }

                public Builder modifier(CodeableConcept ... modifier) {
                    for (CodeableConcept value : modifier) {
                        this.modifier.add(value);
                    }
                    return this;
                }

                public Builder modifier(Collection<CodeableConcept> modifier) {
                    this.modifier = new ArrayList<CodeableConcept>(modifier);
                    return this;
                }

                public Builder provider(Reference provider) {
                    this.provider = provider;
                    return this;
                }

                public Builder excluded(java.lang.Boolean excluded) {
                    this.excluded = excluded == null ? null : Boolean.of(excluded);
                    return this;
                }

                public Builder excluded(Boolean excluded) {
                    this.excluded = excluded;
                    return this;
                }

                public Builder name(java.lang.String name) {
                    this.name = name == null ? null : String.of(name);
                    return this;
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder description(java.lang.String description) {
                    this.description = description == null ? null : String.of(description);
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                public Builder network(CodeableConcept network) {
                    this.network = network;
                    return this;
                }

                public Builder unit(CodeableConcept unit) {
                    this.unit = unit;
                    return this;
                }

                public Builder term(CodeableConcept term) {
                    this.term = term;
                    return this;
                }

                public Builder benefit(Benefit ... benefit) {
                    for (Benefit value : benefit) {
                        this.benefit.add(value);
                    }
                    return this;
                }

                public Builder benefit(Collection<Benefit> benefit) {
                    this.benefit = new ArrayList<Benefit>(benefit);
                    return this;
                }

                public Builder authorizationRequired(java.lang.Boolean authorizationRequired) {
                    this.authorizationRequired = authorizationRequired == null ? null : Boolean.of(authorizationRequired);
                    return this;
                }

                public Builder authorizationRequired(Boolean authorizationRequired) {
                    this.authorizationRequired = authorizationRequired;
                    return this;
                }

                public Builder authorizationSupporting(CodeableConcept ... authorizationSupporting) {
                    for (CodeableConcept value : authorizationSupporting) {
                        this.authorizationSupporting.add(value);
                    }
                    return this;
                }

                public Builder authorizationSupporting(Collection<CodeableConcept> authorizationSupporting) {
                    this.authorizationSupporting = new ArrayList<CodeableConcept>(authorizationSupporting);
                    return this;
                }

                public Builder authorizationUrl(Uri authorizationUrl) {
                    this.authorizationUrl = authorizationUrl;
                    return this;
                }

                @Override
                public Item build() {
                    Item item = new Item(this);
                    if (this.validating) {
                        this.validate(item);
                    }
                    return item;
                }

                protected void validate(Item item) {
                    super.validate(item);
                    ValidationSupport.checkList(item.modifier, "modifier", CodeableConcept.class);
                    ValidationSupport.checkList(item.benefit, "benefit", Benefit.class);
                    ValidationSupport.checkList(item.authorizationSupporting, "authorizationSupporting", CodeableConcept.class);
                    ValidationSupport.checkReferenceType(item.provider, "provider", "Practitioner", "PractitionerRole");
                    ValidationSupport.requireValueOrChildren(item);
                }

                protected Builder from(Item item) {
                    super.from(item);
                    this.category = item.category;
                    this.productOrService = item.productOrService;
                    this.modifier.addAll(item.modifier);
                    this.provider = item.provider;
                    this.excluded = item.excluded;
                    this.name = item.name;
                    this.description = item.description;
                    this.network = item.network;
                    this.unit = item.unit;
                    this.term = item.term;
                    this.benefit.addAll(item.benefit);
                    this.authorizationRequired = item.authorizationRequired;
                    this.authorizationSupporting.addAll(item.authorizationSupporting);
                    this.authorizationUrl = item.authorizationUrl;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference coverage;
            private Boolean inforce;
            private Period benefitPeriod;
            private List<Item> item = new ArrayList<Item>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder coverage(Reference coverage) {
                this.coverage = coverage;
                return this;
            }

            public Builder inforce(java.lang.Boolean inforce) {
                this.inforce = inforce == null ? null : Boolean.of(inforce);
                return this;
            }

            public Builder inforce(Boolean inforce) {
                this.inforce = inforce;
                return this;
            }

            public Builder benefitPeriod(Period benefitPeriod) {
                this.benefitPeriod = benefitPeriod;
                return this;
            }

            public Builder item(Item ... item) {
                for (Item value : item) {
                    this.item.add(value);
                }
                return this;
            }

            public Builder item(Collection<Item> item) {
                this.item = new ArrayList<Item>(item);
                return this;
            }

            @Override
            public Insurance build() {
                Insurance insurance = new Insurance(this);
                if (this.validating) {
                    this.validate(insurance);
                }
                return insurance;
            }

            protected void validate(Insurance insurance) {
                super.validate(insurance);
                ValidationSupport.requireNonNull(insurance.coverage, "coverage");
                ValidationSupport.checkList(insurance.item, "item", Item.class);
                ValidationSupport.checkReferenceType(insurance.coverage, "coverage", "Coverage");
                ValidationSupport.requireValueOrChildren(insurance);
            }

            protected Builder from(Insurance insurance) {
                super.from(insurance);
                this.coverage = insurance.coverage;
                this.inforce = insurance.inforce;
                this.benefitPeriod = insurance.benefitPeriod;
                this.item.addAll(insurance.item);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EligibilityResponseStatus status;
        private List<EligibilityResponsePurpose> purpose = new ArrayList<EligibilityResponsePurpose>();
        private Reference patient;
        private Element serviced;
        private DateTime created;
        private Reference requestor;
        private Reference request;
        private RemittanceOutcome outcome;
        private String disposition;
        private Reference insurer;
        private List<Insurance> insurance = new ArrayList<Insurance>();
        private String preAuthRef;
        private CodeableConcept form;
        private List<Error> error = new ArrayList<Error>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EligibilityResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder purpose(EligibilityResponsePurpose ... purpose) {
            for (EligibilityResponsePurpose value : purpose) {
                this.purpose.add(value);
            }
            return this;
        }

        public Builder purpose(Collection<EligibilityResponsePurpose> purpose) {
            this.purpose = new ArrayList<EligibilityResponsePurpose>(purpose);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder serviced(LocalDate serviced) {
            this.serviced = serviced == null ? null : Date.of(serviced);
            return this;
        }

        public Builder serviced(Element serviced) {
            this.serviced = serviced;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder requestor(Reference requestor) {
            this.requestor = requestor;
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder outcome(RemittanceOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder disposition(java.lang.String disposition) {
            this.disposition = disposition == null ? null : String.of(disposition);
            return this;
        }

        public Builder disposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder insurer(Reference insurer) {
            this.insurer = insurer;
            return this;
        }

        public Builder insurance(Insurance ... insurance) {
            for (Insurance value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Insurance> insurance) {
            this.insurance = new ArrayList<Insurance>(insurance);
            return this;
        }

        public Builder preAuthRef(java.lang.String preAuthRef) {
            this.preAuthRef = preAuthRef == null ? null : String.of(preAuthRef);
            return this;
        }

        public Builder preAuthRef(String preAuthRef) {
            this.preAuthRef = preAuthRef;
            return this;
        }

        public Builder form(CodeableConcept form) {
            this.form = form;
            return this;
        }

        public Builder error(Error ... error) {
            for (Error value : error) {
                this.error.add(value);
            }
            return this;
        }

        public Builder error(Collection<Error> error) {
            this.error = new ArrayList<Error>(error);
            return this;
        }

        @Override
        public CoverageEligibilityResponse build() {
            CoverageEligibilityResponse coverageEligibilityResponse = new CoverageEligibilityResponse(this);
            if (this.validating) {
                this.validate(coverageEligibilityResponse);
            }
            return coverageEligibilityResponse;
        }

        protected void validate(CoverageEligibilityResponse coverageEligibilityResponse) {
            super.validate(coverageEligibilityResponse);
            ValidationSupport.checkList(coverageEligibilityResponse.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(coverageEligibilityResponse.status, "status");
            ValidationSupport.checkNonEmptyList(coverageEligibilityResponse.purpose, "purpose", EligibilityResponsePurpose.class);
            ValidationSupport.requireNonNull(coverageEligibilityResponse.patient, "patient");
            ValidationSupport.choiceElement(coverageEligibilityResponse.serviced, "serviced", Date.class, Period.class);
            ValidationSupport.requireNonNull(coverageEligibilityResponse.created, "created");
            ValidationSupport.requireNonNull(coverageEligibilityResponse.request, "request");
            ValidationSupport.requireNonNull(coverageEligibilityResponse.outcome, "outcome");
            ValidationSupport.requireNonNull(coverageEligibilityResponse.insurer, "insurer");
            ValidationSupport.checkList(coverageEligibilityResponse.insurance, "insurance", Insurance.class);
            ValidationSupport.checkList(coverageEligibilityResponse.error, "error", Error.class);
            ValidationSupport.checkReferenceType(coverageEligibilityResponse.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(coverageEligibilityResponse.requestor, "requestor", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(coverageEligibilityResponse.request, "request", "CoverageEligibilityRequest");
            ValidationSupport.checkReferenceType(coverageEligibilityResponse.insurer, "insurer", "Organization");
        }

        protected Builder from(CoverageEligibilityResponse coverageEligibilityResponse) {
            super.from(coverageEligibilityResponse);
            this.identifier.addAll(coverageEligibilityResponse.identifier);
            this.status = coverageEligibilityResponse.status;
            this.purpose.addAll(coverageEligibilityResponse.purpose);
            this.patient = coverageEligibilityResponse.patient;
            this.serviced = coverageEligibilityResponse.serviced;
            this.created = coverageEligibilityResponse.created;
            this.requestor = coverageEligibilityResponse.requestor;
            this.request = coverageEligibilityResponse.request;
            this.outcome = coverageEligibilityResponse.outcome;
            this.disposition = coverageEligibilityResponse.disposition;
            this.insurer = coverageEligibilityResponse.insurer;
            this.insurance.addAll(coverageEligibilityResponse.insurance);
            this.preAuthRef = coverageEligibilityResponse.preAuthRef;
            this.form = coverageEligibilityResponse.form;
            this.error.addAll(coverageEligibilityResponse.error);
            return this;
        }
    }
}

