/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DocumentReferenceStatus;
import com.ibm.fhir.model.type.code.DocumentRelationshipType;
import com.ibm.fhir.model.type.code.ReferredDocumentStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="documentReference-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-doc-typecodes", expression="type.exists() implies (type.memberOf('http://hl7.org/fhir/ValueSet/c80-doc-typecodes', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/DocumentReference", generated=true), @Constraint(id="documentReference-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/security-labels", expression="securityLabel.exists() implies (securityLabel.all(memberOf('http://hl7.org/fhir/ValueSet/security-labels', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/DocumentReference", generated=true), @Constraint(id="documentReference-2", level="Warning", location="content.format", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/formatcodes", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/formatcodes', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/DocumentReference", generated=true)})
public class DocumentReference
extends DomainResource {
    @Summary
    private final Identifier masterIdentifier;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="DocumentReferenceStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the document reference.", valueSet="http://hl7.org/fhir/ValueSet/document-reference-status|4.0.1")
    @Required
    private final DocumentReferenceStatus status;
    @Summary
    @Binding(bindingName="ReferredDocumentStatus", strength=BindingStrength.Value.REQUIRED, description="Status of the underlying document.", valueSet="http://hl7.org/fhir/ValueSet/composition-status|4.0.1")
    private final ReferredDocumentStatus docStatus;
    @Summary
    @Binding(bindingName="DocumentC80Type", strength=BindingStrength.Value.PREFERRED, description="Precise type of clinical document.", valueSet="http://hl7.org/fhir/ValueSet/c80-doc-typecodes")
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="DocumentC80Class", strength=BindingStrength.Value.EXAMPLE, description="High-level kind of a clinical document at a macro level.", valueSet="http://hl7.org/fhir/ValueSet/document-classcodes")
    private final List<CodeableConcept> category;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "Group", "Device"})
    private final Reference subject;
    @Summary
    private final Instant date;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Device", "Patient", "RelatedPerson"})
    private final List<Reference> author;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference authenticator;
    @ReferenceTarget(value={"Organization"})
    private final Reference custodian;
    @Summary
    private final List<RelatesTo> relatesTo;
    @Summary
    private final String description;
    @Summary
    @Binding(bindingName="SecurityLabels", strength=BindingStrength.Value.EXTENSIBLE, description="Security Labels from the Healthcare Privacy and Security Classification System.", valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    private final List<CodeableConcept> securityLabel;
    @Summary
    @Required
    private final List<Content> content;
    @Summary
    private final Context context;

    private DocumentReference(Builder builder) {
        super(builder);
        this.masterIdentifier = builder.masterIdentifier;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.docStatus = builder.docStatus;
        this.type = builder.type;
        this.category = Collections.unmodifiableList(builder.category);
        this.subject = builder.subject;
        this.date = builder.date;
        this.author = Collections.unmodifiableList(builder.author);
        this.authenticator = builder.authenticator;
        this.custodian = builder.custodian;
        this.relatesTo = Collections.unmodifiableList(builder.relatesTo);
        this.description = builder.description;
        this.securityLabel = Collections.unmodifiableList(builder.securityLabel);
        this.content = Collections.unmodifiableList(builder.content);
        this.context = builder.context;
    }

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status;
    }

    public ReferredDocumentStatus getDocStatus() {
        return this.docStatus;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Instant getDate() {
        return this.date;
    }

    public List<Reference> getAuthor() {
        return this.author;
    }

    public Reference getAuthenticator() {
        return this.authenticator;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public List<RelatesTo> getRelatesTo() {
        return this.relatesTo;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CodeableConcept> getSecurityLabel() {
        return this.securityLabel;
    }

    public List<Content> getContent() {
        return this.content;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.masterIdentifier != null || !this.identifier.isEmpty() || this.status != null || this.docStatus != null || this.type != null || !this.category.isEmpty() || this.subject != null || this.date != null || !this.author.isEmpty() || this.authenticator != null || this.custodian != null || !this.relatesTo.isEmpty() || this.description != null || !this.securityLabel.isEmpty() || !this.content.isEmpty() || this.context != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.masterIdentifier, "masterIdentifier", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.docStatus, "docStatus", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.author, "author", visitor, Reference.class);
                this.accept(this.authenticator, "authenticator", visitor);
                this.accept(this.custodian, "custodian", visitor);
                this.accept(this.relatesTo, "relatesTo", visitor, RelatesTo.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.securityLabel, "securityLabel", visitor, CodeableConcept.class);
                this.accept(this.content, "content", visitor, Content.class);
                this.accept(this.context, "context", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentReference other = (DocumentReference)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.masterIdentifier, other.masterIdentifier) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.docStatus, other.docStatus) && Objects.equals(this.type, other.type) && Objects.equals(this.category, other.category) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.author, other.author) && Objects.equals(this.authenticator, other.authenticator) && Objects.equals(this.custodian, other.custodian) && Objects.equals(this.relatesTo, other.relatesTo) && Objects.equals(this.description, other.description) && Objects.equals(this.securityLabel, other.securityLabel) && Objects.equals(this.content, other.content) && Objects.equals(this.context, other.context);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.masterIdentifier, this.identifier, this.status, this.docStatus, this.type, this.category, this.subject, this.date, this.author, this.authenticator, this.custodian, this.relatesTo, this.description, this.securityLabel, this.content, this.context);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Context
    extends BackboneElement {
        @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
        private final List<Reference> encounter;
        @Binding(bindingName="DocumentEventType", strength=BindingStrength.Value.EXAMPLE, description="This list of codes represents the main clinical acts being documented.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
        private final List<CodeableConcept> event;
        @Summary
        private final Period period;
        @Binding(bindingName="DocumentC80FacilityType", strength=BindingStrength.Value.EXAMPLE, description="XDS Facility Type.", valueSet="http://hl7.org/fhir/ValueSet/c80-facilitycodes")
        private final CodeableConcept facilityType;
        @Binding(bindingName="DocumentC80PracticeSetting", strength=BindingStrength.Value.EXAMPLE, description="Additional details about where the content was created (e.g. clinical specialty).", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
        private final CodeableConcept practiceSetting;
        @ReferenceTarget(value={"Patient"})
        private final Reference sourcePatientInfo;
        private final List<Reference> related;

        private Context(Builder builder) {
            super(builder);
            this.encounter = Collections.unmodifiableList(builder.encounter);
            this.event = Collections.unmodifiableList(builder.event);
            this.period = builder.period;
            this.facilityType = builder.facilityType;
            this.practiceSetting = builder.practiceSetting;
            this.sourcePatientInfo = builder.sourcePatientInfo;
            this.related = Collections.unmodifiableList(builder.related);
        }

        public List<Reference> getEncounter() {
            return this.encounter;
        }

        public List<CodeableConcept> getEvent() {
            return this.event;
        }

        public Period getPeriod() {
            return this.period;
        }

        public CodeableConcept getFacilityType() {
            return this.facilityType;
        }

        public CodeableConcept getPracticeSetting() {
            return this.practiceSetting;
        }

        public Reference getSourcePatientInfo() {
            return this.sourcePatientInfo;
        }

        public List<Reference> getRelated() {
            return this.related;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.encounter.isEmpty() || !this.event.isEmpty() || this.period != null || this.facilityType != null || this.practiceSetting != null || this.sourcePatientInfo != null || !this.related.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.encounter, "encounter", visitor, Reference.class);
                    this.accept(this.event, "event", visitor, CodeableConcept.class);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.facilityType, "facilityType", visitor);
                    this.accept(this.practiceSetting, "practiceSetting", visitor);
                    this.accept(this.sourcePatientInfo, "sourcePatientInfo", visitor);
                    this.accept(this.related, "related", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.event, other.event) && Objects.equals(this.period, other.period) && Objects.equals(this.facilityType, other.facilityType) && Objects.equals(this.practiceSetting, other.practiceSetting) && Objects.equals(this.sourcePatientInfo, other.sourcePatientInfo) && Objects.equals(this.related, other.related);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.encounter, this.event, this.period, this.facilityType, this.practiceSetting, this.sourcePatientInfo, this.related);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Reference> encounter = new ArrayList<Reference>();
            private List<CodeableConcept> event = new ArrayList<CodeableConcept>();
            private Period period;
            private CodeableConcept facilityType;
            private CodeableConcept practiceSetting;
            private Reference sourcePatientInfo;
            private List<Reference> related = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder encounter(Reference ... encounter) {
                for (Reference value : encounter) {
                    this.encounter.add(value);
                }
                return this;
            }

            public Builder encounter(Collection<Reference> encounter) {
                this.encounter = new ArrayList<Reference>(encounter);
                return this;
            }

            public Builder event(CodeableConcept ... event) {
                for (CodeableConcept value : event) {
                    this.event.add(value);
                }
                return this;
            }

            public Builder event(Collection<CodeableConcept> event) {
                this.event = new ArrayList<CodeableConcept>(event);
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder facilityType(CodeableConcept facilityType) {
                this.facilityType = facilityType;
                return this;
            }

            public Builder practiceSetting(CodeableConcept practiceSetting) {
                this.practiceSetting = practiceSetting;
                return this;
            }

            public Builder sourcePatientInfo(Reference sourcePatientInfo) {
                this.sourcePatientInfo = sourcePatientInfo;
                return this;
            }

            public Builder related(Reference ... related) {
                for (Reference value : related) {
                    this.related.add(value);
                }
                return this;
            }

            public Builder related(Collection<Reference> related) {
                this.related = new ArrayList<Reference>(related);
                return this;
            }

            @Override
            public Context build() {
                Context context = new Context(this);
                if (this.validating) {
                    this.validate(context);
                }
                return context;
            }

            protected void validate(Context context) {
                super.validate(context);
                ValidationSupport.checkList(context.encounter, "encounter", Reference.class);
                ValidationSupport.checkList(context.event, "event", CodeableConcept.class);
                ValidationSupport.checkList(context.related, "related", Reference.class);
                ValidationSupport.checkReferenceType(context.encounter, "encounter", "Encounter", "EpisodeOfCare");
                ValidationSupport.checkReferenceType(context.sourcePatientInfo, "sourcePatientInfo", "Patient");
                ValidationSupport.requireValueOrChildren(context);
            }

            protected Builder from(Context context) {
                super.from(context);
                this.encounter.addAll(context.encounter);
                this.event.addAll(context.event);
                this.period = context.period;
                this.facilityType = context.facilityType;
                this.practiceSetting = context.practiceSetting;
                this.sourcePatientInfo = context.sourcePatientInfo;
                this.related.addAll(context.related);
                return this;
            }
        }
    }

    public static class Content
    extends BackboneElement {
        @Summary
        @Required
        private final Attachment attachment;
        @Summary
        @Binding(bindingName="DocumentFormat", strength=BindingStrength.Value.PREFERRED, description="Document Format Codes.", valueSet="http://hl7.org/fhir/ValueSet/formatcodes")
        private final Coding format;

        private Content(Builder builder) {
            super(builder);
            this.attachment = builder.attachment;
            this.format = builder.format;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public Coding getFormat() {
            return this.format;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.attachment != null || this.format != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.attachment, "attachment", visitor);
                    this.accept(this.format, "format", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Content other = (Content)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.attachment, other.attachment) && Objects.equals(this.format, other.format);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.attachment, this.format);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Attachment attachment;
            private Coding format;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder attachment(Attachment attachment) {
                this.attachment = attachment;
                return this;
            }

            public Builder format(Coding format) {
                this.format = format;
                return this;
            }

            @Override
            public Content build() {
                Content content = new Content(this);
                if (this.validating) {
                    this.validate(content);
                }
                return content;
            }

            protected void validate(Content content) {
                super.validate(content);
                ValidationSupport.requireNonNull(content.attachment, "attachment");
                ValidationSupport.requireValueOrChildren(content);
            }

            protected Builder from(Content content) {
                super.from(content);
                this.attachment = content.attachment;
                this.format = content.format;
                return this;
            }
        }
    }

    public static class RelatesTo
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DocumentRelationshipType", strength=BindingStrength.Value.REQUIRED, description="The type of relationship between documents.", valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type|4.0.1")
        @Required
        private final DocumentRelationshipType code;
        @Summary
        @ReferenceTarget(value={"DocumentReference"})
        @Required
        private final Reference target;

        private RelatesTo(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.target = builder.target;
        }

        public DocumentRelationshipType getCode() {
            return this.code;
        }

        public Reference getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.target != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.target, "target", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatesTo other = (RelatesTo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private DocumentRelationshipType code;
            private Reference target;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(DocumentRelationshipType code) {
                this.code = code;
                return this;
            }

            public Builder target(Reference target) {
                this.target = target;
                return this;
            }

            @Override
            public RelatesTo build() {
                RelatesTo relatesTo = new RelatesTo(this);
                if (this.validating) {
                    this.validate(relatesTo);
                }
                return relatesTo;
            }

            protected void validate(RelatesTo relatesTo) {
                super.validate(relatesTo);
                ValidationSupport.requireNonNull(relatesTo.code, "code");
                ValidationSupport.requireNonNull(relatesTo.target, "target");
                ValidationSupport.checkReferenceType(relatesTo.target, "target", "DocumentReference");
                ValidationSupport.requireValueOrChildren(relatesTo);
            }

            protected Builder from(RelatesTo relatesTo) {
                super.from(relatesTo);
                this.code = relatesTo.code;
                this.target = relatesTo.target;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier masterIdentifier;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private DocumentReferenceStatus status;
        private ReferredDocumentStatus docStatus;
        private CodeableConcept type;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private Reference subject;
        private Instant date;
        private List<Reference> author = new ArrayList<Reference>();
        private Reference authenticator;
        private Reference custodian;
        private List<RelatesTo> relatesTo = new ArrayList<RelatesTo>();
        private String description;
        private List<CodeableConcept> securityLabel = new ArrayList<CodeableConcept>();
        private List<Content> content = new ArrayList<Content>();
        private Context context;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder masterIdentifier(Identifier masterIdentifier) {
            this.masterIdentifier = masterIdentifier;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(DocumentReferenceStatus status) {
            this.status = status;
            return this;
        }

        public Builder docStatus(ReferredDocumentStatus docStatus) {
            this.docStatus = docStatus;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(ZonedDateTime date) {
            this.date = date == null ? null : Instant.of(date);
            return this;
        }

        public Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public Builder author(Reference ... author) {
            for (Reference value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<Reference> author) {
            this.author = new ArrayList<Reference>(author);
            return this;
        }

        public Builder authenticator(Reference authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public Builder custodian(Reference custodian) {
            this.custodian = custodian;
            return this;
        }

        public Builder relatesTo(RelatesTo ... relatesTo) {
            for (RelatesTo value : relatesTo) {
                this.relatesTo.add(value);
            }
            return this;
        }

        public Builder relatesTo(Collection<RelatesTo> relatesTo) {
            this.relatesTo = new ArrayList<RelatesTo>(relatesTo);
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder securityLabel(CodeableConcept ... securityLabel) {
            for (CodeableConcept value : securityLabel) {
                this.securityLabel.add(value);
            }
            return this;
        }

        public Builder securityLabel(Collection<CodeableConcept> securityLabel) {
            this.securityLabel = new ArrayList<CodeableConcept>(securityLabel);
            return this;
        }

        public Builder content(Content ... content) {
            for (Content value : content) {
                this.content.add(value);
            }
            return this;
        }

        public Builder content(Collection<Content> content) {
            this.content = new ArrayList<Content>(content);
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        @Override
        public DocumentReference build() {
            DocumentReference documentReference = new DocumentReference(this);
            if (this.validating) {
                this.validate(documentReference);
            }
            return documentReference;
        }

        protected void validate(DocumentReference documentReference) {
            super.validate(documentReference);
            ValidationSupport.checkList(documentReference.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(documentReference.status, "status");
            ValidationSupport.checkList(documentReference.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(documentReference.author, "author", Reference.class);
            ValidationSupport.checkList(documentReference.relatesTo, "relatesTo", RelatesTo.class);
            ValidationSupport.checkList(documentReference.securityLabel, "securityLabel", CodeableConcept.class);
            ValidationSupport.checkNonEmptyList(documentReference.content, "content", Content.class);
            ValidationSupport.checkReferenceType(documentReference.subject, "subject", "Patient", "Practitioner", "Group", "Device");
            ValidationSupport.checkReferenceType(documentReference.author, "author", "Practitioner", "PractitionerRole", "Organization", "Device", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(documentReference.authenticator, "authenticator", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(documentReference.custodian, "custodian", "Organization");
        }

        protected Builder from(DocumentReference documentReference) {
            super.from(documentReference);
            this.masterIdentifier = documentReference.masterIdentifier;
            this.identifier.addAll(documentReference.identifier);
            this.status = documentReference.status;
            this.docStatus = documentReference.docStatus;
            this.type = documentReference.type;
            this.category.addAll(documentReference.category);
            this.subject = documentReference.subject;
            this.date = documentReference.date;
            this.author.addAll(documentReference.author);
            this.authenticator = documentReference.authenticator;
            this.custodian = documentReference.custodian;
            this.relatesTo.addAll(documentReference.relatesTo);
            this.description = documentReference.description;
            this.securityLabel.addAll(documentReference.securityLabel);
            this.content.addAll(documentReference.content);
            this.context = documentReference.context;
            return this;
        }
    }
}

