/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="dom-2", level="Rule", location="(base)", description="If the resource is contained in another resource, it SHALL NOT contain nested Resources", expression="contained.contained.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-3", level="Rule", location="(base)", description="If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource", expression="contained.where((('#'+id in (%resource.descendants().reference | %resource.descendants().as(canonical) | %resource.descendants().as(uri) | %resource.descendants().as(url))) or descendants().where(reference = '#').exists() or descendants().where(as(canonical) = '#').exists() or descendants().where(as(canonical) = '#').exists()).not()).trace('unmatched', id).empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-4", level="Rule", location="(base)", description="If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated", expression="contained.meta.versionId.empty() and contained.meta.lastUpdated.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-5", level="Rule", location="(base)", description="If a resource is contained in another resource, it SHALL NOT have a security label", expression="contained.meta.security.empty()", source="http://hl7.org/fhir/StructureDefinition/DomainResource"), @Constraint(id="dom-6", level="Warning", location="(base)", description="A resource should have narrative for robust management", expression="text.`div`.exists()", source="http://hl7.org/fhir/StructureDefinition/DomainResource")})
public abstract class DomainResource
extends Resource {
    protected final Narrative text;
    protected final List<Resource> contained;
    protected final List<Extension> extension;
    protected final List<Extension> modifierExtension;

    protected DomainResource(Builder builder) {
        super(builder);
        this.text = builder.text;
        this.contained = Collections.unmodifiableList(builder.contained);
        this.extension = Collections.unmodifiableList(builder.extension);
        this.modifierExtension = Collections.unmodifiableList(builder.modifierExtension);
    }

    public Narrative getText() {
        return this.text;
    }

    public List<Resource> getContained() {
        return this.contained;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public List<Extension> getModifierExtension() {
        return this.modifierExtension;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.text != null || !this.contained.isEmpty() || !this.extension.isEmpty() || !this.modifierExtension.isEmpty();
    }

    @Override
    public abstract Builder toBuilder();

    public static abstract class Builder
    extends Resource.Builder {
        protected Narrative text;
        protected List<Resource> contained = new ArrayList<Resource>();
        protected List<Extension> extension = new ArrayList<Extension>();
        protected List<Extension> modifierExtension = new ArrayList<Extension>();

        protected Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        public Builder text(Narrative text) {
            this.text = text;
            return this;
        }

        public Builder contained(Resource ... contained) {
            for (Resource value : contained) {
                this.contained.add(value);
            }
            return this;
        }

        public Builder contained(Collection<Resource> contained) {
            this.contained = new ArrayList<Resource>(contained);
            return this;
        }

        public Builder extension(Extension ... extension) {
            for (Extension value : extension) {
                this.extension.add(value);
            }
            return this;
        }

        public Builder extension(Collection<Extension> extension) {
            this.extension = new ArrayList<Extension>(extension);
            return this;
        }

        public Builder modifierExtension(Extension ... modifierExtension) {
            for (Extension value : modifierExtension) {
                this.modifierExtension.add(value);
            }
            return this;
        }

        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            this.modifierExtension = new ArrayList<Extension>(modifierExtension);
            return this;
        }

        @Override
        public abstract DomainResource build();

        protected void validate(DomainResource domainResource) {
            super.validate(domainResource);
            ValidationSupport.checkList(domainResource.contained, "contained", Resource.class);
            ValidationSupport.checkList(domainResource.extension, "extension", Extension.class);
            ValidationSupport.checkList(domainResource.modifierExtension, "modifierExtension", Extension.class);
        }

        protected Builder from(DomainResource domainResource) {
            super.from(domainResource);
            this.text = domainResource.text;
            this.contained.addAll(domainResource.contained);
            this.extension.addAll(domainResource.extension);
            this.modifierExtension.addAll(domainResource.modifierExtension);
            return this;
        }
    }
}

