/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ImmunizationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="imm-1", level="Rule", location="Immunization.education", description="One of documentType or reference SHALL be present", expression="documentType.exists() or reference.exists()", source="http://hl7.org/fhir/StructureDefinition/Immunization"), @Constraint(id="immunization-2", level="Warning", location="performer.function", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/immunization-function", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/immunization-function', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Immunization", generated=true)})
public class Immunization
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ImmunizationStatus", strength=BindingStrength.Value.REQUIRED, description="A set of codes indicating the current status of an Immunization.", valueSet="http://hl7.org/fhir/ValueSet/immunization-status|4.0.1")
    @Required
    private final ImmunizationStatus status;
    @Binding(bindingName="ImmunizationStatusReason", strength=BindingStrength.Value.EXAMPLE, description="The reason why a vaccine was not administered.", valueSet="http://hl7.org/fhir/ValueSet/immunization-status-reason")
    private final CodeableConcept statusReason;
    @Summary
    @Binding(bindingName="VaccineCode", strength=BindingStrength.Value.EXAMPLE, description="The code for vaccine product administered.", valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
    @Required
    private final CodeableConcept vaccineCode;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, String.class})
    @Required
    private final Element occurrence;
    private final DateTime recorded;
    @Summary
    private final Boolean primarySource;
    @Binding(bindingName="ImmunizationReportOrigin", strength=BindingStrength.Value.EXAMPLE, description="The source of the data for a record which is not from a primary source.", valueSet="http://hl7.org/fhir/ValueSet/immunization-origin")
    private final CodeableConcept reportOrigin;
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @ReferenceTarget(value={"Organization"})
    private final Reference manufacturer;
    private final String lotNumber;
    private final Date expirationDate;
    @Binding(bindingName="ImmunizationSite", strength=BindingStrength.Value.EXAMPLE, description="The site at which the vaccine was administered.", valueSet="http://hl7.org/fhir/ValueSet/immunization-site")
    private final CodeableConcept site;
    @Binding(bindingName="ImmunizationRoute", strength=BindingStrength.Value.EXAMPLE, description="The route by which the vaccine was administered.", valueSet="http://hl7.org/fhir/ValueSet/immunization-route")
    private final CodeableConcept route;
    private final SimpleQuantity doseQuantity;
    @Summary
    private final List<Performer> performer;
    @Summary
    private final List<Annotation> note;
    @Binding(bindingName="ImmunizationReason", strength=BindingStrength.Value.EXAMPLE, description="The reason why a vaccine was administered.", valueSet="http://hl7.org/fhir/ValueSet/immunization-reason")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport"})
    private final List<Reference> reasonReference;
    @Summary
    private final Boolean isSubpotent;
    @Binding(bindingName="SubpotentReason", strength=BindingStrength.Value.EXAMPLE, description="The reason why a dose is considered to be subpotent.", valueSet="http://hl7.org/fhir/ValueSet/immunization-subpotent-reason")
    private final List<CodeableConcept> subpotentReason;
    private final List<Education> education;
    @Binding(bindingName="ProgramEligibility", strength=BindingStrength.Value.EXAMPLE, description="The patient's eligibility for a vaccation program.", valueSet="http://hl7.org/fhir/ValueSet/immunization-program-eligibility")
    private final List<CodeableConcept> programEligibility;
    @Binding(bindingName="FundingSource", strength=BindingStrength.Value.EXAMPLE, description="The source of funding used to purchase the vaccine administered.", valueSet="http://hl7.org/fhir/ValueSet/immunization-funding-source")
    private final CodeableConcept fundingSource;
    private final List<Reaction> reaction;
    private final List<ProtocolApplied> protocolApplied;

    private Immunization(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.vaccineCode = builder.vaccineCode;
        this.patient = builder.patient;
        this.encounter = builder.encounter;
        this.occurrence = builder.occurrence;
        this.recorded = builder.recorded;
        this.primarySource = builder.primarySource;
        this.reportOrigin = builder.reportOrigin;
        this.location = builder.location;
        this.manufacturer = builder.manufacturer;
        this.lotNumber = builder.lotNumber;
        this.expirationDate = builder.expirationDate;
        this.site = builder.site;
        this.route = builder.route;
        this.doseQuantity = builder.doseQuantity;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.note = Collections.unmodifiableList(builder.note);
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.isSubpotent = builder.isSubpotent;
        this.subpotentReason = Collections.unmodifiableList(builder.subpotentReason);
        this.education = Collections.unmodifiableList(builder.education);
        this.programEligibility = Collections.unmodifiableList(builder.programEligibility);
        this.fundingSource = builder.fundingSource;
        this.reaction = Collections.unmodifiableList(builder.reaction);
        this.protocolApplied = Collections.unmodifiableList(builder.protocolApplied);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ImmunizationStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getVaccineCode() {
        return this.vaccineCode;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public DateTime getRecorded() {
        return this.recorded;
    }

    public Boolean getPrimarySource() {
        return this.primarySource;
    }

    public CodeableConcept getReportOrigin() {
        return this.reportOrigin;
    }

    public Reference getLocation() {
        return this.location;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public CodeableConcept getSite() {
        return this.site;
    }

    public CodeableConcept getRoute() {
        return this.route;
    }

    public SimpleQuantity getDoseQuantity() {
        return this.doseQuantity;
    }

    public List<Performer> getPerformer() {
        return this.performer;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public Boolean getIsSubpotent() {
        return this.isSubpotent;
    }

    public List<CodeableConcept> getSubpotentReason() {
        return this.subpotentReason;
    }

    public List<Education> getEducation() {
        return this.education;
    }

    public List<CodeableConcept> getProgramEligibility() {
        return this.programEligibility;
    }

    public CodeableConcept getFundingSource() {
        return this.fundingSource;
    }

    public List<Reaction> getReaction() {
        return this.reaction;
    }

    public List<ProtocolApplied> getProtocolApplied() {
        return this.protocolApplied;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.statusReason != null || this.vaccineCode != null || this.patient != null || this.encounter != null || this.occurrence != null || this.recorded != null || this.primarySource != null || this.reportOrigin != null || this.location != null || this.manufacturer != null || this.lotNumber != null || this.expirationDate != null || this.site != null || this.route != null || this.doseQuantity != null || !this.performer.isEmpty() || !this.note.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || this.isSubpotent != null || !this.subpotentReason.isEmpty() || !this.education.isEmpty() || !this.programEligibility.isEmpty() || this.fundingSource != null || !this.reaction.isEmpty() || !this.protocolApplied.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.vaccineCode, "vaccineCode", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.recorded, "recorded", visitor);
                this.accept(this.primarySource, "primarySource", visitor);
                this.accept(this.reportOrigin, "reportOrigin", visitor);
                this.accept(this.location, "location", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor);
                this.accept(this.lotNumber, "lotNumber", visitor);
                this.accept(this.expirationDate, "expirationDate", visitor);
                this.accept(this.site, "site", visitor);
                this.accept(this.route, "route", visitor);
                this.accept(this.doseQuantity, "doseQuantity", visitor);
                this.accept(this.performer, "performer", visitor, Performer.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.isSubpotent, "isSubpotent", visitor);
                this.accept(this.subpotentReason, "subpotentReason", visitor, CodeableConcept.class);
                this.accept(this.education, "education", visitor, Education.class);
                this.accept(this.programEligibility, "programEligibility", visitor, CodeableConcept.class);
                this.accept(this.fundingSource, "fundingSource", visitor);
                this.accept(this.reaction, "reaction", visitor, Reaction.class);
                this.accept(this.protocolApplied, "protocolApplied", visitor, ProtocolApplied.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Immunization other = (Immunization)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.vaccineCode, other.vaccineCode) && Objects.equals(this.patient, other.patient) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.recorded, other.recorded) && Objects.equals(this.primarySource, other.primarySource) && Objects.equals(this.reportOrigin, other.reportOrigin) && Objects.equals(this.location, other.location) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.lotNumber, other.lotNumber) && Objects.equals(this.expirationDate, other.expirationDate) && Objects.equals(this.site, other.site) && Objects.equals(this.route, other.route) && Objects.equals(this.doseQuantity, other.doseQuantity) && Objects.equals(this.performer, other.performer) && Objects.equals(this.note, other.note) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.isSubpotent, other.isSubpotent) && Objects.equals(this.subpotentReason, other.subpotentReason) && Objects.equals(this.education, other.education) && Objects.equals(this.programEligibility, other.programEligibility) && Objects.equals(this.fundingSource, other.fundingSource) && Objects.equals(this.reaction, other.reaction) && Objects.equals(this.protocolApplied, other.protocolApplied);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.statusReason, this.vaccineCode, this.patient, this.encounter, this.occurrence, this.recorded, this.primarySource, this.reportOrigin, this.location, this.manufacturer, this.lotNumber, this.expirationDate, this.site, this.route, this.doseQuantity, this.performer, this.note, this.reasonCode, this.reasonReference, this.isSubpotent, this.subpotentReason, this.education, this.programEligibility, this.fundingSource, this.reaction, this.protocolApplied);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ProtocolApplied
    extends BackboneElement {
        private final String series;
        @ReferenceTarget(value={"Organization"})
        private final Reference authority;
        @Binding(bindingName="TargetDisease", strength=BindingStrength.Value.EXAMPLE, description="The vaccine preventable disease the dose is being administered for.", valueSet="http://hl7.org/fhir/ValueSet/immunization-target-disease")
        private final List<CodeableConcept> targetDisease;
        @Choice(value={PositiveInt.class, String.class})
        @Required
        private final Element doseNumber;
        @Choice(value={PositiveInt.class, String.class})
        private final Element seriesDoses;

        private ProtocolApplied(Builder builder) {
            super(builder);
            this.series = builder.series;
            this.authority = builder.authority;
            this.targetDisease = Collections.unmodifiableList(builder.targetDisease);
            this.doseNumber = builder.doseNumber;
            this.seriesDoses = builder.seriesDoses;
        }

        public String getSeries() {
            return this.series;
        }

        public Reference getAuthority() {
            return this.authority;
        }

        public List<CodeableConcept> getTargetDisease() {
            return this.targetDisease;
        }

        public Element getDoseNumber() {
            return this.doseNumber;
        }

        public Element getSeriesDoses() {
            return this.seriesDoses;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.series != null || this.authority != null || !this.targetDisease.isEmpty() || this.doseNumber != null || this.seriesDoses != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.series, "series", visitor);
                    this.accept(this.authority, "authority", visitor);
                    this.accept(this.targetDisease, "targetDisease", visitor, CodeableConcept.class);
                    this.accept(this.doseNumber, "doseNumber", visitor);
                    this.accept(this.seriesDoses, "seriesDoses", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProtocolApplied other = (ProtocolApplied)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.series, other.series) && Objects.equals(this.authority, other.authority) && Objects.equals(this.targetDisease, other.targetDisease) && Objects.equals(this.doseNumber, other.doseNumber) && Objects.equals(this.seriesDoses, other.seriesDoses);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.series, this.authority, this.targetDisease, this.doseNumber, this.seriesDoses);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String series;
            private Reference authority;
            private List<CodeableConcept> targetDisease = new ArrayList<CodeableConcept>();
            private Element doseNumber;
            private Element seriesDoses;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder series(java.lang.String series) {
                this.series = series == null ? null : String.of(series);
                return this;
            }

            public Builder series(String series) {
                this.series = series;
                return this;
            }

            public Builder authority(Reference authority) {
                this.authority = authority;
                return this;
            }

            public Builder targetDisease(CodeableConcept ... targetDisease) {
                for (CodeableConcept value : targetDisease) {
                    this.targetDisease.add(value);
                }
                return this;
            }

            public Builder targetDisease(Collection<CodeableConcept> targetDisease) {
                this.targetDisease = new ArrayList<CodeableConcept>(targetDisease);
                return this;
            }

            public Builder doseNumber(java.lang.String doseNumber) {
                this.doseNumber = doseNumber == null ? null : String.of(doseNumber);
                return this;
            }

            public Builder doseNumber(Element doseNumber) {
                this.doseNumber = doseNumber;
                return this;
            }

            public Builder seriesDoses(java.lang.String seriesDoses) {
                this.seriesDoses = seriesDoses == null ? null : String.of(seriesDoses);
                return this;
            }

            public Builder seriesDoses(Element seriesDoses) {
                this.seriesDoses = seriesDoses;
                return this;
            }

            @Override
            public ProtocolApplied build() {
                ProtocolApplied protocolApplied = new ProtocolApplied(this);
                if (this.validating) {
                    this.validate(protocolApplied);
                }
                return protocolApplied;
            }

            protected void validate(ProtocolApplied protocolApplied) {
                super.validate(protocolApplied);
                ValidationSupport.checkList(protocolApplied.targetDisease, "targetDisease", CodeableConcept.class);
                ValidationSupport.requireChoiceElement(protocolApplied.doseNumber, "doseNumber", PositiveInt.class, String.class);
                ValidationSupport.choiceElement(protocolApplied.seriesDoses, "seriesDoses", PositiveInt.class, String.class);
                ValidationSupport.checkReferenceType(protocolApplied.authority, "authority", "Organization");
                ValidationSupport.requireValueOrChildren(protocolApplied);
            }

            protected Builder from(ProtocolApplied protocolApplied) {
                super.from(protocolApplied);
                this.series = protocolApplied.series;
                this.authority = protocolApplied.authority;
                this.targetDisease.addAll(protocolApplied.targetDisease);
                this.doseNumber = protocolApplied.doseNumber;
                this.seriesDoses = protocolApplied.seriesDoses;
                return this;
            }
        }
    }

    public static class Reaction
    extends BackboneElement {
        private final DateTime date;
        @ReferenceTarget(value={"Observation"})
        private final Reference detail;
        private final Boolean reported;

        private Reaction(Builder builder) {
            super(builder);
            this.date = builder.date;
            this.detail = builder.detail;
            this.reported = builder.reported;
        }

        public DateTime getDate() {
            return this.date;
        }

        public Reference getDetail() {
            return this.detail;
        }

        public Boolean getReported() {
            return this.reported;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.date != null || this.detail != null || this.reported != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.detail, "detail", visitor);
                    this.accept(this.reported, "reported", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Reaction other = (Reaction)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.date, other.date) && Objects.equals(this.detail, other.detail) && Objects.equals(this.reported, other.reported);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.date, this.detail, this.reported);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private DateTime date;
            private Reference detail;
            private Boolean reported;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder date(DateTime date) {
                this.date = date;
                return this;
            }

            public Builder detail(Reference detail) {
                this.detail = detail;
                return this;
            }

            public Builder reported(java.lang.Boolean reported) {
                this.reported = reported == null ? null : Boolean.of(reported);
                return this;
            }

            public Builder reported(Boolean reported) {
                this.reported = reported;
                return this;
            }

            @Override
            public Reaction build() {
                Reaction reaction = new Reaction(this);
                if (this.validating) {
                    this.validate(reaction);
                }
                return reaction;
            }

            protected void validate(Reaction reaction) {
                super.validate(reaction);
                ValidationSupport.checkReferenceType(reaction.detail, "detail", "Observation");
                ValidationSupport.requireValueOrChildren(reaction);
            }

            protected Builder from(Reaction reaction) {
                super.from(reaction);
                this.date = reaction.date;
                this.detail = reaction.detail;
                this.reported = reaction.reported;
                return this;
            }
        }
    }

    public static class Education
    extends BackboneElement {
        private final String documentType;
        private final Uri reference;
        private final DateTime publicationDate;
        private final DateTime presentationDate;

        private Education(Builder builder) {
            super(builder);
            this.documentType = builder.documentType;
            this.reference = builder.reference;
            this.publicationDate = builder.publicationDate;
            this.presentationDate = builder.presentationDate;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public Uri getReference() {
            return this.reference;
        }

        public DateTime getPublicationDate() {
            return this.publicationDate;
        }

        public DateTime getPresentationDate() {
            return this.presentationDate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.documentType != null || this.reference != null || this.publicationDate != null || this.presentationDate != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.documentType, "documentType", visitor);
                    this.accept(this.reference, "reference", visitor);
                    this.accept(this.publicationDate, "publicationDate", visitor);
                    this.accept(this.presentationDate, "presentationDate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Education other = (Education)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.reference, other.reference) && Objects.equals(this.publicationDate, other.publicationDate) && Objects.equals(this.presentationDate, other.presentationDate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.documentType, this.reference, this.publicationDate, this.presentationDate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String documentType;
            private Uri reference;
            private DateTime publicationDate;
            private DateTime presentationDate;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder documentType(java.lang.String documentType) {
                this.documentType = documentType == null ? null : String.of(documentType);
                return this;
            }

            public Builder documentType(String documentType) {
                this.documentType = documentType;
                return this;
            }

            public Builder reference(Uri reference) {
                this.reference = reference;
                return this;
            }

            public Builder publicationDate(DateTime publicationDate) {
                this.publicationDate = publicationDate;
                return this;
            }

            public Builder presentationDate(DateTime presentationDate) {
                this.presentationDate = presentationDate;
                return this;
            }

            @Override
            public Education build() {
                Education education = new Education(this);
                if (this.validating) {
                    this.validate(education);
                }
                return education;
            }

            protected void validate(Education education) {
                super.validate(education);
                ValidationSupport.requireValueOrChildren(education);
            }

            protected Builder from(Education education) {
                super.from(education);
                this.documentType = education.documentType;
                this.reference = education.reference;
                this.publicationDate = education.publicationDate;
                this.presentationDate = education.presentationDate;
                return this;
            }
        }
    }

    public static class Performer
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ImmunizationFunction", strength=BindingStrength.Value.EXTENSIBLE, description="The role a practitioner or organization plays in the immunization event.", valueSet="http://hl7.org/fhir/ValueSet/immunization-function")
        private final CodeableConcept function;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        @Required
        private final Reference actor;

        private Performer(Builder builder) {
            super(builder);
            this.function = builder.function;
            this.actor = builder.actor;
        }

        public CodeableConcept getFunction() {
            return this.function;
        }

        public Reference getActor() {
            return this.actor;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.function != null || this.actor != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.function, "function", visitor);
                    this.accept(this.actor, "actor", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Performer other = (Performer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept function;
            private Reference actor;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder function(CodeableConcept function) {
                this.function = function;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            @Override
            public Performer build() {
                Performer performer = new Performer(this);
                if (this.validating) {
                    this.validate(performer);
                }
                return performer;
            }

            protected void validate(Performer performer) {
                super.validate(performer);
                ValidationSupport.requireNonNull(performer.actor, "actor");
                ValidationSupport.checkReferenceType(performer.actor, "actor", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(performer);
            }

            protected Builder from(Performer performer) {
                super.from(performer);
                this.function = performer.function;
                this.actor = performer.actor;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ImmunizationStatus status;
        private CodeableConcept statusReason;
        private CodeableConcept vaccineCode;
        private Reference patient;
        private Reference encounter;
        private Element occurrence;
        private DateTime recorded;
        private Boolean primarySource;
        private CodeableConcept reportOrigin;
        private Reference location;
        private Reference manufacturer;
        private String lotNumber;
        private Date expirationDate;
        private CodeableConcept site;
        private CodeableConcept route;
        private SimpleQuantity doseQuantity;
        private List<Performer> performer = new ArrayList<Performer>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private Boolean isSubpotent;
        private List<CodeableConcept> subpotentReason = new ArrayList<CodeableConcept>();
        private List<Education> education = new ArrayList<Education>();
        private List<CodeableConcept> programEligibility = new ArrayList<CodeableConcept>();
        private CodeableConcept fundingSource;
        private List<Reaction> reaction = new ArrayList<Reaction>();
        private List<ProtocolApplied> protocolApplied = new ArrayList<ProtocolApplied>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ImmunizationStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder vaccineCode(CodeableConcept vaccineCode) {
            this.vaccineCode = vaccineCode;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder occurrence(java.lang.String occurrence) {
            this.occurrence = occurrence == null ? null : String.of(occurrence);
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder recorded(DateTime recorded) {
            this.recorded = recorded;
            return this;
        }

        public Builder primarySource(java.lang.Boolean primarySource) {
            this.primarySource = primarySource == null ? null : Boolean.of(primarySource);
            return this;
        }

        public Builder primarySource(Boolean primarySource) {
            this.primarySource = primarySource;
            return this;
        }

        public Builder reportOrigin(CodeableConcept reportOrigin) {
            this.reportOrigin = reportOrigin;
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder manufacturer(Reference manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder lotNumber(java.lang.String lotNumber) {
            this.lotNumber = lotNumber == null ? null : String.of(lotNumber);
            return this;
        }

        public Builder lotNumber(String lotNumber) {
            this.lotNumber = lotNumber;
            return this;
        }

        public Builder expirationDate(LocalDate expirationDate) {
            this.expirationDate = expirationDate == null ? null : Date.of(expirationDate);
            return this;
        }

        public Builder expirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public Builder site(CodeableConcept site) {
            this.site = site;
            return this;
        }

        public Builder route(CodeableConcept route) {
            this.route = route;
            return this;
        }

        public Builder doseQuantity(SimpleQuantity doseQuantity) {
            this.doseQuantity = doseQuantity;
            return this;
        }

        public Builder performer(Performer ... performer) {
            for (Performer value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Performer> performer) {
            this.performer = new ArrayList<Performer>(performer);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder isSubpotent(java.lang.Boolean isSubpotent) {
            this.isSubpotent = isSubpotent == null ? null : Boolean.of(isSubpotent);
            return this;
        }

        public Builder isSubpotent(Boolean isSubpotent) {
            this.isSubpotent = isSubpotent;
            return this;
        }

        public Builder subpotentReason(CodeableConcept ... subpotentReason) {
            for (CodeableConcept value : subpotentReason) {
                this.subpotentReason.add(value);
            }
            return this;
        }

        public Builder subpotentReason(Collection<CodeableConcept> subpotentReason) {
            this.subpotentReason = new ArrayList<CodeableConcept>(subpotentReason);
            return this;
        }

        public Builder education(Education ... education) {
            for (Education value : education) {
                this.education.add(value);
            }
            return this;
        }

        public Builder education(Collection<Education> education) {
            this.education = new ArrayList<Education>(education);
            return this;
        }

        public Builder programEligibility(CodeableConcept ... programEligibility) {
            for (CodeableConcept value : programEligibility) {
                this.programEligibility.add(value);
            }
            return this;
        }

        public Builder programEligibility(Collection<CodeableConcept> programEligibility) {
            this.programEligibility = new ArrayList<CodeableConcept>(programEligibility);
            return this;
        }

        public Builder fundingSource(CodeableConcept fundingSource) {
            this.fundingSource = fundingSource;
            return this;
        }

        public Builder reaction(Reaction ... reaction) {
            for (Reaction value : reaction) {
                this.reaction.add(value);
            }
            return this;
        }

        public Builder reaction(Collection<Reaction> reaction) {
            this.reaction = new ArrayList<Reaction>(reaction);
            return this;
        }

        public Builder protocolApplied(ProtocolApplied ... protocolApplied) {
            for (ProtocolApplied value : protocolApplied) {
                this.protocolApplied.add(value);
            }
            return this;
        }

        public Builder protocolApplied(Collection<ProtocolApplied> protocolApplied) {
            this.protocolApplied = new ArrayList<ProtocolApplied>(protocolApplied);
            return this;
        }

        @Override
        public Immunization build() {
            Immunization immunization = new Immunization(this);
            if (this.validating) {
                this.validate(immunization);
            }
            return immunization;
        }

        protected void validate(Immunization immunization) {
            super.validate(immunization);
            ValidationSupport.checkList(immunization.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(immunization.status, "status");
            ValidationSupport.requireNonNull(immunization.vaccineCode, "vaccineCode");
            ValidationSupport.requireNonNull(immunization.patient, "patient");
            ValidationSupport.requireChoiceElement(immunization.occurrence, "occurrence", DateTime.class, String.class);
            ValidationSupport.checkList(immunization.performer, "performer", Performer.class);
            ValidationSupport.checkList(immunization.note, "note", Annotation.class);
            ValidationSupport.checkList(immunization.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(immunization.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(immunization.subpotentReason, "subpotentReason", CodeableConcept.class);
            ValidationSupport.checkList(immunization.education, "education", Education.class);
            ValidationSupport.checkList(immunization.programEligibility, "programEligibility", CodeableConcept.class);
            ValidationSupport.checkList(immunization.reaction, "reaction", Reaction.class);
            ValidationSupport.checkList(immunization.protocolApplied, "protocolApplied", ProtocolApplied.class);
            ValidationSupport.checkReferenceType(immunization.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(immunization.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(immunization.location, "location", "Location");
            ValidationSupport.checkReferenceType(immunization.manufacturer, "manufacturer", "Organization");
            ValidationSupport.checkReferenceType(immunization.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport");
        }

        protected Builder from(Immunization immunization) {
            super.from(immunization);
            this.identifier.addAll(immunization.identifier);
            this.status = immunization.status;
            this.statusReason = immunization.statusReason;
            this.vaccineCode = immunization.vaccineCode;
            this.patient = immunization.patient;
            this.encounter = immunization.encounter;
            this.occurrence = immunization.occurrence;
            this.recorded = immunization.recorded;
            this.primarySource = immunization.primarySource;
            this.reportOrigin = immunization.reportOrigin;
            this.location = immunization.location;
            this.manufacturer = immunization.manufacturer;
            this.lotNumber = immunization.lotNumber;
            this.expirationDate = immunization.expirationDate;
            this.site = immunization.site;
            this.route = immunization.route;
            this.doseQuantity = immunization.doseQuantity;
            this.performer.addAll(immunization.performer);
            this.note.addAll(immunization.note);
            this.reasonCode.addAll(immunization.reasonCode);
            this.reasonReference.addAll(immunization.reasonReference);
            this.isSubpotent = immunization.isSubpotent;
            this.subpotentReason.addAll(immunization.subpotentReason);
            this.education.addAll(immunization.education);
            this.programEligibility.addAll(immunization.programEligibility);
            this.fundingSource = immunization.fundingSource;
            this.reaction.addAll(immunization.reaction);
            this.protocolApplied.addAll(immunization.protocolApplied);
            return this;
        }
    }
}

