/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ImmunizationEvaluationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class ImmunizationEvaluation
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ImmunizationEvaluationStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the evaluation being done.", valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-status|4.0.1")
    @Required
    private final ImmunizationEvaluationStatus status;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    private final DateTime date;
    @ReferenceTarget(value={"Organization"})
    private final Reference authority;
    @Summary
    @Binding(bindingName="EvaluationTargetDisease", strength=BindingStrength.Value.EXAMPLE, description="The vaccine preventable disease the dose is being evaluated against.", valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-target-disease")
    @Required
    private final CodeableConcept targetDisease;
    @Summary
    @ReferenceTarget(value={"Immunization"})
    @Required
    private final Reference immunizationEvent;
    @Summary
    @Binding(bindingName="EvaluationDoseStatus", strength=BindingStrength.Value.EXAMPLE, description="The status of the administered dose relative to the published recommendations for the target disease.", valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status")
    @Required
    private final CodeableConcept doseStatus;
    @Binding(bindingName="EvaluationDoseStatusReason", strength=BindingStrength.Value.EXAMPLE, description="The reason the dose status was assigned.", valueSet="http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status-reason")
    private final List<CodeableConcept> doseStatusReason;
    private final String description;
    private final String series;
    @Choice(value={PositiveInt.class, String.class})
    private final Element doseNumber;
    @Choice(value={PositiveInt.class, String.class})
    private final Element seriesDoses;

    private ImmunizationEvaluation(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.patient = builder.patient;
        this.date = builder.date;
        this.authority = builder.authority;
        this.targetDisease = builder.targetDisease;
        this.immunizationEvent = builder.immunizationEvent;
        this.doseStatus = builder.doseStatus;
        this.doseStatusReason = Collections.unmodifiableList(builder.doseStatusReason);
        this.description = builder.description;
        this.series = builder.series;
        this.doseNumber = builder.doseNumber;
        this.seriesDoses = builder.seriesDoses;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ImmunizationEvaluationStatus getStatus() {
        return this.status;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Reference getAuthority() {
        return this.authority;
    }

    public CodeableConcept getTargetDisease() {
        return this.targetDisease;
    }

    public Reference getImmunizationEvent() {
        return this.immunizationEvent;
    }

    public CodeableConcept getDoseStatus() {
        return this.doseStatus;
    }

    public List<CodeableConcept> getDoseStatusReason() {
        return this.doseStatusReason;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeries() {
        return this.series;
    }

    public Element getDoseNumber() {
        return this.doseNumber;
    }

    public Element getSeriesDoses() {
        return this.seriesDoses;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.patient != null || this.date != null || this.authority != null || this.targetDisease != null || this.immunizationEvent != null || this.doseStatus != null || !this.doseStatusReason.isEmpty() || this.description != null || this.series != null || this.doseNumber != null || this.seriesDoses != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.authority, "authority", visitor);
                this.accept(this.targetDisease, "targetDisease", visitor);
                this.accept(this.immunizationEvent, "immunizationEvent", visitor);
                this.accept(this.doseStatus, "doseStatus", visitor);
                this.accept(this.doseStatusReason, "doseStatusReason", visitor, CodeableConcept.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.series, "series", visitor);
                this.accept(this.doseNumber, "doseNumber", visitor);
                this.accept(this.seriesDoses, "seriesDoses", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmunizationEvaluation other = (ImmunizationEvaluation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.patient, other.patient) && Objects.equals(this.date, other.date) && Objects.equals(this.authority, other.authority) && Objects.equals(this.targetDisease, other.targetDisease) && Objects.equals(this.immunizationEvent, other.immunizationEvent) && Objects.equals(this.doseStatus, other.doseStatus) && Objects.equals(this.doseStatusReason, other.doseStatusReason) && Objects.equals(this.description, other.description) && Objects.equals(this.series, other.series) && Objects.equals(this.doseNumber, other.doseNumber) && Objects.equals(this.seriesDoses, other.seriesDoses);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.patient, this.date, this.authority, this.targetDisease, this.immunizationEvent, this.doseStatus, this.doseStatusReason, this.description, this.series, this.doseNumber, this.seriesDoses);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ImmunizationEvaluationStatus status;
        private Reference patient;
        private DateTime date;
        private Reference authority;
        private CodeableConcept targetDisease;
        private Reference immunizationEvent;
        private CodeableConcept doseStatus;
        private List<CodeableConcept> doseStatusReason = new ArrayList<CodeableConcept>();
        private String description;
        private String series;
        private Element doseNumber;
        private Element seriesDoses;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ImmunizationEvaluationStatus status) {
            this.status = status;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder authority(Reference authority) {
            this.authority = authority;
            return this;
        }

        public Builder targetDisease(CodeableConcept targetDisease) {
            this.targetDisease = targetDisease;
            return this;
        }

        public Builder immunizationEvent(Reference immunizationEvent) {
            this.immunizationEvent = immunizationEvent;
            return this;
        }

        public Builder doseStatus(CodeableConcept doseStatus) {
            this.doseStatus = doseStatus;
            return this;
        }

        public Builder doseStatusReason(CodeableConcept ... doseStatusReason) {
            for (CodeableConcept value : doseStatusReason) {
                this.doseStatusReason.add(value);
            }
            return this;
        }

        public Builder doseStatusReason(Collection<CodeableConcept> doseStatusReason) {
            this.doseStatusReason = new ArrayList<CodeableConcept>(doseStatusReason);
            return this;
        }

        public Builder description(java.lang.String description) {
            this.description = description == null ? null : String.of(description);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder series(java.lang.String series) {
            this.series = series == null ? null : String.of(series);
            return this;
        }

        public Builder series(String series) {
            this.series = series;
            return this;
        }

        public Builder doseNumber(java.lang.String doseNumber) {
            this.doseNumber = doseNumber == null ? null : String.of(doseNumber);
            return this;
        }

        public Builder doseNumber(Element doseNumber) {
            this.doseNumber = doseNumber;
            return this;
        }

        public Builder seriesDoses(java.lang.String seriesDoses) {
            this.seriesDoses = seriesDoses == null ? null : String.of(seriesDoses);
            return this;
        }

        public Builder seriesDoses(Element seriesDoses) {
            this.seriesDoses = seriesDoses;
            return this;
        }

        @Override
        public ImmunizationEvaluation build() {
            ImmunizationEvaluation immunizationEvaluation = new ImmunizationEvaluation(this);
            if (this.validating) {
                this.validate(immunizationEvaluation);
            }
            return immunizationEvaluation;
        }

        protected void validate(ImmunizationEvaluation immunizationEvaluation) {
            super.validate(immunizationEvaluation);
            ValidationSupport.checkList(immunizationEvaluation.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(immunizationEvaluation.status, "status");
            ValidationSupport.requireNonNull(immunizationEvaluation.patient, "patient");
            ValidationSupport.requireNonNull(immunizationEvaluation.targetDisease, "targetDisease");
            ValidationSupport.requireNonNull(immunizationEvaluation.immunizationEvent, "immunizationEvent");
            ValidationSupport.requireNonNull(immunizationEvaluation.doseStatus, "doseStatus");
            ValidationSupport.checkList(immunizationEvaluation.doseStatusReason, "doseStatusReason", CodeableConcept.class);
            ValidationSupport.choiceElement(immunizationEvaluation.doseNumber, "doseNumber", PositiveInt.class, String.class);
            ValidationSupport.choiceElement(immunizationEvaluation.seriesDoses, "seriesDoses", PositiveInt.class, String.class);
            ValidationSupport.checkReferenceType(immunizationEvaluation.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(immunizationEvaluation.authority, "authority", "Organization");
            ValidationSupport.checkReferenceType(immunizationEvaluation.immunizationEvent, "immunizationEvent", "Immunization");
        }

        protected Builder from(ImmunizationEvaluation immunizationEvaluation) {
            super.from(immunizationEvaluation);
            this.identifier.addAll(immunizationEvaluation.identifier);
            this.status = immunizationEvaluation.status;
            this.patient = immunizationEvaluation.patient;
            this.date = immunizationEvaluation.date;
            this.authority = immunizationEvaluation.authority;
            this.targetDisease = immunizationEvaluation.targetDisease;
            this.immunizationEvent = immunizationEvaluation.immunizationEvent;
            this.doseStatus = immunizationEvaluation.doseStatus;
            this.doseStatusReason.addAll(immunizationEvaluation.doseStatusReason);
            this.description = immunizationEvaluation.description;
            this.series = immunizationEvaluation.series;
            this.doseNumber = immunizationEvaluation.doseNumber;
            this.seriesDoses = immunizationEvaluation.seriesDoses;
            return this;
        }
    }
}

