/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="imr-1", level="Rule", location="ImmunizationRecommendation.recommendation", description="One of vaccineCode or targetDisease SHALL be present", expression="vaccineCode.exists() or targetDisease.exists()", source="http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation")
public class ImmunizationRecommendation
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    @Required
    private final DateTime date;
    @ReferenceTarget(value={"Organization"})
    private final Reference authority;
    @Summary
    @Required
    private final List<Recommendation> recommendation;

    private ImmunizationRecommendation(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.patient = builder.patient;
        this.date = builder.date;
        this.authority = builder.authority;
        this.recommendation = Collections.unmodifiableList(builder.recommendation);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Reference getAuthority() {
        return this.authority;
    }

    public List<Recommendation> getRecommendation() {
        return this.recommendation;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.patient != null || this.date != null || this.authority != null || !this.recommendation.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.authority, "authority", visitor);
                this.accept(this.recommendation, "recommendation", visitor, Recommendation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmunizationRecommendation other = (ImmunizationRecommendation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.patient, other.patient) && Objects.equals(this.date, other.date) && Objects.equals(this.authority, other.authority) && Objects.equals(this.recommendation, other.recommendation);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.patient, this.date, this.authority, this.recommendation);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Recommendation
    extends BackboneElement {
        @Summary
        @Binding(bindingName="VaccineCode", strength=BindingStrength.Value.EXAMPLE, description="The type of vaccine administered.", valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        private final List<CodeableConcept> vaccineCode;
        @Summary
        @Binding(bindingName="TargetDisease", strength=BindingStrength.Value.EXAMPLE, description="The disease that the recommended vaccination targets.", valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-target-disease")
        private final CodeableConcept targetDisease;
        @Summary
        @Binding(bindingName="VaccineCode", strength=BindingStrength.Value.EXAMPLE, description="The type of vaccine administered.", valueSet="http://hl7.org/fhir/ValueSet/vaccine-code")
        private final List<CodeableConcept> contraindicatedVaccineCode;
        @Summary
        @Binding(bindingName="ImmunizationRecommendationStatus", strength=BindingStrength.Value.EXAMPLE, description="The patient's status with respect to a vaccination protocol.", valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-status")
        @Required
        private final CodeableConcept forecastStatus;
        @Summary
        @Binding(bindingName="ImmunizationRecommendationReason", strength=BindingStrength.Value.EXAMPLE, description="The reason for the patient's status with respect to a vaccination protocol.", valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-reason")
        private final List<CodeableConcept> forecastReason;
        private final List<DateCriterion> dateCriterion;
        private final String description;
        private final String series;
        @Summary
        @Choice(value={PositiveInt.class, String.class})
        private final Element doseNumber;
        @Choice(value={PositiveInt.class, String.class})
        private final Element seriesDoses;
        @ReferenceTarget(value={"Immunization", "ImmunizationEvaluation"})
        private final List<Reference> supportingImmunization;
        private final List<Reference> supportingPatientInformation;

        private Recommendation(Builder builder) {
            super(builder);
            this.vaccineCode = Collections.unmodifiableList(builder.vaccineCode);
            this.targetDisease = builder.targetDisease;
            this.contraindicatedVaccineCode = Collections.unmodifiableList(builder.contraindicatedVaccineCode);
            this.forecastStatus = builder.forecastStatus;
            this.forecastReason = Collections.unmodifiableList(builder.forecastReason);
            this.dateCriterion = Collections.unmodifiableList(builder.dateCriterion);
            this.description = builder.description;
            this.series = builder.series;
            this.doseNumber = builder.doseNumber;
            this.seriesDoses = builder.seriesDoses;
            this.supportingImmunization = Collections.unmodifiableList(builder.supportingImmunization);
            this.supportingPatientInformation = Collections.unmodifiableList(builder.supportingPatientInformation);
        }

        public List<CodeableConcept> getVaccineCode() {
            return this.vaccineCode;
        }

        public CodeableConcept getTargetDisease() {
            return this.targetDisease;
        }

        public List<CodeableConcept> getContraindicatedVaccineCode() {
            return this.contraindicatedVaccineCode;
        }

        public CodeableConcept getForecastStatus() {
            return this.forecastStatus;
        }

        public List<CodeableConcept> getForecastReason() {
            return this.forecastReason;
        }

        public List<DateCriterion> getDateCriterion() {
            return this.dateCriterion;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSeries() {
            return this.series;
        }

        public Element getDoseNumber() {
            return this.doseNumber;
        }

        public Element getSeriesDoses() {
            return this.seriesDoses;
        }

        public List<Reference> getSupportingImmunization() {
            return this.supportingImmunization;
        }

        public List<Reference> getSupportingPatientInformation() {
            return this.supportingPatientInformation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.vaccineCode.isEmpty() || this.targetDisease != null || !this.contraindicatedVaccineCode.isEmpty() || this.forecastStatus != null || !this.forecastReason.isEmpty() || !this.dateCriterion.isEmpty() || this.description != null || this.series != null || this.doseNumber != null || this.seriesDoses != null || !this.supportingImmunization.isEmpty() || !this.supportingPatientInformation.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.vaccineCode, "vaccineCode", visitor, CodeableConcept.class);
                    this.accept(this.targetDisease, "targetDisease", visitor);
                    this.accept(this.contraindicatedVaccineCode, "contraindicatedVaccineCode", visitor, CodeableConcept.class);
                    this.accept(this.forecastStatus, "forecastStatus", visitor);
                    this.accept(this.forecastReason, "forecastReason", visitor, CodeableConcept.class);
                    this.accept(this.dateCriterion, "dateCriterion", visitor, DateCriterion.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.series, "series", visitor);
                    this.accept(this.doseNumber, "doseNumber", visitor);
                    this.accept(this.seriesDoses, "seriesDoses", visitor);
                    this.accept(this.supportingImmunization, "supportingImmunization", visitor, Reference.class);
                    this.accept(this.supportingPatientInformation, "supportingPatientInformation", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Recommendation other = (Recommendation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.vaccineCode, other.vaccineCode) && Objects.equals(this.targetDisease, other.targetDisease) && Objects.equals(this.contraindicatedVaccineCode, other.contraindicatedVaccineCode) && Objects.equals(this.forecastStatus, other.forecastStatus) && Objects.equals(this.forecastReason, other.forecastReason) && Objects.equals(this.dateCriterion, other.dateCriterion) && Objects.equals(this.description, other.description) && Objects.equals(this.series, other.series) && Objects.equals(this.doseNumber, other.doseNumber) && Objects.equals(this.seriesDoses, other.seriesDoses) && Objects.equals(this.supportingImmunization, other.supportingImmunization) && Objects.equals(this.supportingPatientInformation, other.supportingPatientInformation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.vaccineCode, this.targetDisease, this.contraindicatedVaccineCode, this.forecastStatus, this.forecastReason, this.dateCriterion, this.description, this.series, this.doseNumber, this.seriesDoses, this.supportingImmunization, this.supportingPatientInformation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class DateCriterion
        extends BackboneElement {
            @Binding(bindingName="ImmunizationRecommendationDateCriterion", strength=BindingStrength.Value.EXAMPLE, description="Classifies date criterion with respect to conveying information about a patient's vaccination status (e.g. due date, latest to give date, etc.).", valueSet="http://hl7.org/fhir/ValueSet/immunization-recommendation-date-criterion")
            @Required
            private final CodeableConcept code;
            @Required
            private final DateTime value;

            private DateCriterion(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.value = builder.value;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public DateTime getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.value != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DateCriterion other = (DateCriterion)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private DateTime value;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder value(DateTime value) {
                    this.value = value;
                    return this;
                }

                @Override
                public DateCriterion build() {
                    DateCriterion dateCriterion = new DateCriterion(this);
                    if (this.validating) {
                        this.validate(dateCriterion);
                    }
                    return dateCriterion;
                }

                protected void validate(DateCriterion dateCriterion) {
                    super.validate(dateCriterion);
                    ValidationSupport.requireNonNull(dateCriterion.code, "code");
                    ValidationSupport.requireNonNull(dateCriterion.value, "value");
                    ValidationSupport.requireValueOrChildren(dateCriterion);
                }

                protected Builder from(DateCriterion dateCriterion) {
                    super.from(dateCriterion);
                    this.code = dateCriterion.code;
                    this.value = dateCriterion.value;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> vaccineCode = new ArrayList<CodeableConcept>();
            private CodeableConcept targetDisease;
            private List<CodeableConcept> contraindicatedVaccineCode = new ArrayList<CodeableConcept>();
            private CodeableConcept forecastStatus;
            private List<CodeableConcept> forecastReason = new ArrayList<CodeableConcept>();
            private List<DateCriterion> dateCriterion = new ArrayList<DateCriterion>();
            private String description;
            private String series;
            private Element doseNumber;
            private Element seriesDoses;
            private List<Reference> supportingImmunization = new ArrayList<Reference>();
            private List<Reference> supportingPatientInformation = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder vaccineCode(CodeableConcept ... vaccineCode) {
                for (CodeableConcept value : vaccineCode) {
                    this.vaccineCode.add(value);
                }
                return this;
            }

            public Builder vaccineCode(Collection<CodeableConcept> vaccineCode) {
                this.vaccineCode = new ArrayList<CodeableConcept>(vaccineCode);
                return this;
            }

            public Builder targetDisease(CodeableConcept targetDisease) {
                this.targetDisease = targetDisease;
                return this;
            }

            public Builder contraindicatedVaccineCode(CodeableConcept ... contraindicatedVaccineCode) {
                for (CodeableConcept value : contraindicatedVaccineCode) {
                    this.contraindicatedVaccineCode.add(value);
                }
                return this;
            }

            public Builder contraindicatedVaccineCode(Collection<CodeableConcept> contraindicatedVaccineCode) {
                this.contraindicatedVaccineCode = new ArrayList<CodeableConcept>(contraindicatedVaccineCode);
                return this;
            }

            public Builder forecastStatus(CodeableConcept forecastStatus) {
                this.forecastStatus = forecastStatus;
                return this;
            }

            public Builder forecastReason(CodeableConcept ... forecastReason) {
                for (CodeableConcept value : forecastReason) {
                    this.forecastReason.add(value);
                }
                return this;
            }

            public Builder forecastReason(Collection<CodeableConcept> forecastReason) {
                this.forecastReason = new ArrayList<CodeableConcept>(forecastReason);
                return this;
            }

            public Builder dateCriterion(DateCriterion ... dateCriterion) {
                for (DateCriterion value : dateCriterion) {
                    this.dateCriterion.add(value);
                }
                return this;
            }

            public Builder dateCriterion(Collection<DateCriterion> dateCriterion) {
                this.dateCriterion = new ArrayList<DateCriterion>(dateCriterion);
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder series(java.lang.String series) {
                this.series = series == null ? null : String.of(series);
                return this;
            }

            public Builder series(String series) {
                this.series = series;
                return this;
            }

            public Builder doseNumber(java.lang.String doseNumber) {
                this.doseNumber = doseNumber == null ? null : String.of(doseNumber);
                return this;
            }

            public Builder doseNumber(Element doseNumber) {
                this.doseNumber = doseNumber;
                return this;
            }

            public Builder seriesDoses(java.lang.String seriesDoses) {
                this.seriesDoses = seriesDoses == null ? null : String.of(seriesDoses);
                return this;
            }

            public Builder seriesDoses(Element seriesDoses) {
                this.seriesDoses = seriesDoses;
                return this;
            }

            public Builder supportingImmunization(Reference ... supportingImmunization) {
                for (Reference value : supportingImmunization) {
                    this.supportingImmunization.add(value);
                }
                return this;
            }

            public Builder supportingImmunization(Collection<Reference> supportingImmunization) {
                this.supportingImmunization = new ArrayList<Reference>(supportingImmunization);
                return this;
            }

            public Builder supportingPatientInformation(Reference ... supportingPatientInformation) {
                for (Reference value : supportingPatientInformation) {
                    this.supportingPatientInformation.add(value);
                }
                return this;
            }

            public Builder supportingPatientInformation(Collection<Reference> supportingPatientInformation) {
                this.supportingPatientInformation = new ArrayList<Reference>(supportingPatientInformation);
                return this;
            }

            @Override
            public Recommendation build() {
                Recommendation recommendation = new Recommendation(this);
                if (this.validating) {
                    this.validate(recommendation);
                }
                return recommendation;
            }

            protected void validate(Recommendation recommendation) {
                super.validate(recommendation);
                ValidationSupport.checkList(recommendation.vaccineCode, "vaccineCode", CodeableConcept.class);
                ValidationSupport.checkList(recommendation.contraindicatedVaccineCode, "contraindicatedVaccineCode", CodeableConcept.class);
                ValidationSupport.requireNonNull(recommendation.forecastStatus, "forecastStatus");
                ValidationSupport.checkList(recommendation.forecastReason, "forecastReason", CodeableConcept.class);
                ValidationSupport.checkList(recommendation.dateCriterion, "dateCriterion", DateCriterion.class);
                ValidationSupport.choiceElement(recommendation.doseNumber, "doseNumber", PositiveInt.class, String.class);
                ValidationSupport.choiceElement(recommendation.seriesDoses, "seriesDoses", PositiveInt.class, String.class);
                ValidationSupport.checkList(recommendation.supportingImmunization, "supportingImmunization", Reference.class);
                ValidationSupport.checkList(recommendation.supportingPatientInformation, "supportingPatientInformation", Reference.class);
                ValidationSupport.checkReferenceType(recommendation.supportingImmunization, "supportingImmunization", "Immunization", "ImmunizationEvaluation");
                ValidationSupport.requireValueOrChildren(recommendation);
            }

            protected Builder from(Recommendation recommendation) {
                super.from(recommendation);
                this.vaccineCode.addAll(recommendation.vaccineCode);
                this.targetDisease = recommendation.targetDisease;
                this.contraindicatedVaccineCode.addAll(recommendation.contraindicatedVaccineCode);
                this.forecastStatus = recommendation.forecastStatus;
                this.forecastReason.addAll(recommendation.forecastReason);
                this.dateCriterion.addAll(recommendation.dateCriterion);
                this.description = recommendation.description;
                this.series = recommendation.series;
                this.doseNumber = recommendation.doseNumber;
                this.seriesDoses = recommendation.seriesDoses;
                this.supportingImmunization.addAll(recommendation.supportingImmunization);
                this.supportingPatientInformation.addAll(recommendation.supportingPatientInformation);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Reference patient;
        private DateTime date;
        private Reference authority;
        private List<Recommendation> recommendation = new ArrayList<Recommendation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder authority(Reference authority) {
            this.authority = authority;
            return this;
        }

        public Builder recommendation(Recommendation ... recommendation) {
            for (Recommendation value : recommendation) {
                this.recommendation.add(value);
            }
            return this;
        }

        public Builder recommendation(Collection<Recommendation> recommendation) {
            this.recommendation = new ArrayList<Recommendation>(recommendation);
            return this;
        }

        @Override
        public ImmunizationRecommendation build() {
            ImmunizationRecommendation immunizationRecommendation = new ImmunizationRecommendation(this);
            if (this.validating) {
                this.validate(immunizationRecommendation);
            }
            return immunizationRecommendation;
        }

        protected void validate(ImmunizationRecommendation immunizationRecommendation) {
            super.validate(immunizationRecommendation);
            ValidationSupport.checkList(immunizationRecommendation.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(immunizationRecommendation.patient, "patient");
            ValidationSupport.requireNonNull(immunizationRecommendation.date, "date");
            ValidationSupport.checkNonEmptyList(immunizationRecommendation.recommendation, "recommendation", Recommendation.class);
            ValidationSupport.checkReferenceType(immunizationRecommendation.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(immunizationRecommendation.authority, "authority", "Organization");
        }

        protected Builder from(ImmunizationRecommendation immunizationRecommendation) {
            super.from(immunizationRecommendation);
            this.identifier.addAll(immunizationRecommendation.identifier);
            this.patient = immunizationRecommendation.patient;
            this.date = immunizationRecommendation.date;
            this.authority = immunizationRecommendation.authority;
            this.recommendation.addAll(immunizationRecommendation.recommendation);
            return this;
        }
    }
}

