/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ListMode;
import com.ibm.fhir.model.type.code.ListStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="lst-1", level="Rule", location="(base)", description="A list can only have an emptyReason if it is empty", expression="emptyReason.empty() or entry.empty()", source="http://hl7.org/fhir/StructureDefinition/List"), @Constraint(id="lst-2", level="Rule", location="(base)", description="The deleted flag can only be used if the mode of the list is \"changes\"", expression="mode = 'changes' or entry.deleted.empty()", source="http://hl7.org/fhir/StructureDefinition/List"), @Constraint(id="lst-3", level="Rule", location="(base)", description="An entry date can only be used if the mode of the list is \"working\"", expression="mode = 'working' or entry.date.empty()", source="http://hl7.org/fhir/StructureDefinition/List"), @Constraint(id="list-4", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-order", expression="orderedBy.exists() implies (orderedBy.memberOf('http://hl7.org/fhir/ValueSet/list-order', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/List", generated=true), @Constraint(id="list-5", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-empty-reason", expression="emptyReason.exists() implies (emptyReason.memberOf('http://hl7.org/fhir/ValueSet/list-empty-reason', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/List", generated=true)})
public class List
extends DomainResource {
    private final java.util.List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ListStatus", strength=BindingStrength.Value.REQUIRED, description="The current state of the list.", valueSet="http://hl7.org/fhir/ValueSet/list-status|4.0.1")
    @Required
    private final ListStatus status;
    @Summary
    @Binding(bindingName="ListMode", strength=BindingStrength.Value.REQUIRED, description="The processing mode that applies to this list.", valueSet="http://hl7.org/fhir/ValueSet/list-mode|4.0.1")
    @Required
    private final ListMode mode;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="ListPurpose", strength=BindingStrength.Value.EXAMPLE, description="What the purpose of a list is.", valueSet="http://hl7.org/fhir/ValueSet/list-example-codes")
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Device", "Location"})
    private final Reference subject;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final DateTime date;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Patient", "Device"})
    private final Reference source;
    @Binding(bindingName="ListOrder", strength=BindingStrength.Value.PREFERRED, description="What order applies to the items in a list.", valueSet="http://hl7.org/fhir/ValueSet/list-order")
    private final CodeableConcept orderedBy;
    private final java.util.List<Annotation> note;
    private final java.util.List<Entry> entry;
    @Binding(bindingName="ListEmptyReason", strength=BindingStrength.Value.PREFERRED, description="If a list is empty, why it is empty.", valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
    private final CodeableConcept emptyReason;

    private List(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.mode = builder.mode;
        this.title = builder.title;
        this.code = builder.code;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.date = builder.date;
        this.source = builder.source;
        this.orderedBy = builder.orderedBy;
        this.note = Collections.unmodifiableList(builder.note);
        this.entry = Collections.unmodifiableList(builder.entry);
        this.emptyReason = builder.emptyReason;
    }

    public java.util.List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ListStatus getStatus() {
        return this.status;
    }

    public ListMode getMode() {
        return this.mode;
    }

    public String getTitle() {
        return this.title;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Reference getSource() {
        return this.source;
    }

    public CodeableConcept getOrderedBy() {
        return this.orderedBy;
    }

    public java.util.List<Annotation> getNote() {
        return this.note;
    }

    public java.util.List<Entry> getEntry() {
        return this.entry;
    }

    public CodeableConcept getEmptyReason() {
        return this.emptyReason;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.mode != null || this.title != null || this.code != null || this.subject != null || this.encounter != null || this.date != null || this.source != null || this.orderedBy != null || !this.note.isEmpty() || !this.entry.isEmpty() || this.emptyReason != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.mode, "mode", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.orderedBy, "orderedBy", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.entry, "entry", visitor, Entry.class);
                this.accept(this.emptyReason, "emptyReason", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        List other = (List)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.mode, other.mode) && Objects.equals(this.title, other.title) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.date, other.date) && Objects.equals(this.source, other.source) && Objects.equals(this.orderedBy, other.orderedBy) && Objects.equals(this.note, other.note) && Objects.equals(this.entry, other.entry) && Objects.equals(this.emptyReason, other.emptyReason);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.mode, this.title, this.code, this.subject, this.encounter, this.date, this.source, this.orderedBy, this.note, this.entry, this.emptyReason);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Entry
    extends BackboneElement {
        @Binding(bindingName="ListItemFlag", strength=BindingStrength.Value.EXAMPLE, description="Codes that provide further information about the reason and meaning of the item in the list.", valueSet="http://hl7.org/fhir/ValueSet/list-item-flag")
        private final CodeableConcept flag;
        private final Boolean deleted;
        private final DateTime date;
        @Required
        private final Reference item;

        private Entry(Builder builder) {
            super(builder);
            this.flag = builder.flag;
            this.deleted = builder.deleted;
            this.date = builder.date;
            this.item = builder.item;
        }

        public CodeableConcept getFlag() {
            return this.flag;
        }

        public Boolean getDeleted() {
            return this.deleted;
        }

        public DateTime getDate() {
            return this.date;
        }

        public Reference getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.flag != null || this.deleted != null || this.date != null || this.item != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.flag, "flag", visitor);
                    this.accept(this.deleted, "deleted", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.item, "item", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.flag, other.flag) && Objects.equals(this.deleted, other.deleted) && Objects.equals(this.date, other.date) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.flag, this.deleted, this.date, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept flag;
            private Boolean deleted;
            private DateTime date;
            private Reference item;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder flag(CodeableConcept flag) {
                this.flag = flag;
                return this;
            }

            public Builder deleted(java.lang.Boolean deleted) {
                this.deleted = deleted == null ? null : Boolean.of(deleted);
                return this;
            }

            public Builder deleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            public Builder date(DateTime date) {
                this.date = date;
                return this;
            }

            public Builder item(Reference item) {
                this.item = item;
                return this;
            }

            @Override
            public Entry build() {
                Entry entry = new Entry(this);
                if (this.validating) {
                    this.validate(entry);
                }
                return entry;
            }

            protected void validate(Entry entry) {
                super.validate(entry);
                ValidationSupport.requireNonNull(entry.item, "item");
                ValidationSupport.requireValueOrChildren(entry);
            }

            protected Builder from(Entry entry) {
                super.from(entry);
                this.flag = entry.flag;
                this.deleted = entry.deleted;
                this.date = entry.date;
                this.item = entry.item;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private java.util.List<Identifier> identifier = new ArrayList<Identifier>();
        private ListStatus status;
        private ListMode mode;
        private String title;
        private CodeableConcept code;
        private Reference subject;
        private Reference encounter;
        private DateTime date;
        private Reference source;
        private CodeableConcept orderedBy;
        private java.util.List<Annotation> note = new ArrayList<Annotation>();
        private java.util.List<Entry> entry = new ArrayList<Entry>();
        private CodeableConcept emptyReason;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ListStatus status) {
            this.status = status;
            return this;
        }

        public Builder mode(ListMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder source(Reference source) {
            this.source = source;
            return this;
        }

        public Builder orderedBy(CodeableConcept orderedBy) {
            this.orderedBy = orderedBy;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder entry(Entry ... entry) {
            for (Entry value : entry) {
                this.entry.add(value);
            }
            return this;
        }

        public Builder entry(Collection<Entry> entry) {
            this.entry = new ArrayList<Entry>(entry);
            return this;
        }

        public Builder emptyReason(CodeableConcept emptyReason) {
            this.emptyReason = emptyReason;
            return this;
        }

        @Override
        public List build() {
            List list = new List(this);
            if (this.validating) {
                this.validate(list);
            }
            return list;
        }

        protected void validate(List list) {
            super.validate(list);
            ValidationSupport.checkList(list.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(list.status, "status");
            ValidationSupport.requireNonNull(list.mode, "mode");
            ValidationSupport.checkList(list.note, "note", Annotation.class);
            ValidationSupport.checkList(list.entry, "entry", Entry.class);
            ValidationSupport.checkReferenceType(list.subject, "subject", "Patient", "Group", "Device", "Location");
            ValidationSupport.checkReferenceType(list.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(list.source, "source", "Practitioner", "PractitionerRole", "Patient", "Device");
        }

        protected Builder from(List list) {
            super.from(list);
            this.identifier.addAll(list.identifier);
            this.status = list.status;
            this.mode = list.mode;
            this.title = list.title;
            this.code = list.code;
            this.subject = list.subject;
            this.encounter = list.encounter;
            this.date = list.date;
            this.source = list.source;
            this.orderedBy = list.orderedBy;
            this.note.addAll(list.note);
            this.entry.addAll(list.entry);
            this.emptyReason = list.emptyReason;
            return this;
        }
    }
}

