/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductContraindication
extends DomainResource {
    @Summary
    @ReferenceTarget(value={"MedicinalProduct", "Medication"})
    private final List<Reference> subject;
    @Summary
    private final CodeableConcept disease;
    @Summary
    private final CodeableConcept diseaseStatus;
    @Summary
    private final List<CodeableConcept> comorbidity;
    @Summary
    @ReferenceTarget(value={"MedicinalProductIndication"})
    private final List<Reference> therapeuticIndication;
    @Summary
    private final List<OtherTherapy> otherTherapy;
    @Summary
    private final List<Population> population;

    private MedicinalProductContraindication(Builder builder) {
        super(builder);
        this.subject = Collections.unmodifiableList(builder.subject);
        this.disease = builder.disease;
        this.diseaseStatus = builder.diseaseStatus;
        this.comorbidity = Collections.unmodifiableList(builder.comorbidity);
        this.therapeuticIndication = Collections.unmodifiableList(builder.therapeuticIndication);
        this.otherTherapy = Collections.unmodifiableList(builder.otherTherapy);
        this.population = Collections.unmodifiableList(builder.population);
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public CodeableConcept getDisease() {
        return this.disease;
    }

    public CodeableConcept getDiseaseStatus() {
        return this.diseaseStatus;
    }

    public List<CodeableConcept> getComorbidity() {
        return this.comorbidity;
    }

    public List<Reference> getTherapeuticIndication() {
        return this.therapeuticIndication;
    }

    public List<OtherTherapy> getOtherTherapy() {
        return this.otherTherapy;
    }

    public List<Population> getPopulation() {
        return this.population;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.subject.isEmpty() || this.disease != null || this.diseaseStatus != null || !this.comorbidity.isEmpty() || !this.therapeuticIndication.isEmpty() || !this.otherTherapy.isEmpty() || !this.population.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.disease, "disease", visitor);
                this.accept(this.diseaseStatus, "diseaseStatus", visitor);
                this.accept(this.comorbidity, "comorbidity", visitor, CodeableConcept.class);
                this.accept(this.therapeuticIndication, "therapeuticIndication", visitor, Reference.class);
                this.accept(this.otherTherapy, "otherTherapy", visitor, OtherTherapy.class);
                this.accept(this.population, "population", visitor, Population.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductContraindication other = (MedicinalProductContraindication)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subject, other.subject) && Objects.equals(this.disease, other.disease) && Objects.equals(this.diseaseStatus, other.diseaseStatus) && Objects.equals(this.comorbidity, other.comorbidity) && Objects.equals(this.therapeuticIndication, other.therapeuticIndication) && Objects.equals(this.otherTherapy, other.otherTherapy) && Objects.equals(this.population, other.population);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.subject, this.disease, this.diseaseStatus, this.comorbidity, this.therapeuticIndication, this.otherTherapy, this.population);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class OtherTherapy
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept therapyRelationshipType;
        @Summary
        @ReferenceTarget(value={"MedicinalProduct", "Medication", "Substance", "SubstanceSpecification"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Required
        private final Element medication;

        private OtherTherapy(Builder builder) {
            super(builder);
            this.therapyRelationshipType = builder.therapyRelationshipType;
            this.medication = builder.medication;
        }

        public CodeableConcept getTherapyRelationshipType() {
            return this.therapyRelationshipType;
        }

        public Element getMedication() {
            return this.medication;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.therapyRelationshipType != null || this.medication != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.therapyRelationshipType, "therapyRelationshipType", visitor);
                    this.accept(this.medication, "medication", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OtherTherapy other = (OtherTherapy)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.therapyRelationshipType, other.therapyRelationshipType) && Objects.equals(this.medication, other.medication);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.therapyRelationshipType, this.medication);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept therapyRelationshipType;
            private Element medication;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder therapyRelationshipType(CodeableConcept therapyRelationshipType) {
                this.therapyRelationshipType = therapyRelationshipType;
                return this;
            }

            public Builder medication(Element medication) {
                this.medication = medication;
                return this;
            }

            @Override
            public OtherTherapy build() {
                OtherTherapy otherTherapy = new OtherTherapy(this);
                if (this.validating) {
                    this.validate(otherTherapy);
                }
                return otherTherapy;
            }

            protected void validate(OtherTherapy otherTherapy) {
                super.validate(otherTherapy);
                ValidationSupport.requireNonNull(otherTherapy.therapyRelationshipType, "therapyRelationshipType");
                ValidationSupport.requireChoiceElement(otherTherapy.medication, "medication", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(otherTherapy.medication, "medication", "MedicinalProduct", "Medication", "Substance", "SubstanceSpecification");
                ValidationSupport.requireValueOrChildren(otherTherapy);
            }

            protected Builder from(OtherTherapy otherTherapy) {
                super.from(otherTherapy);
                this.therapyRelationshipType = otherTherapy.therapyRelationshipType;
                this.medication = otherTherapy.medication;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> subject = new ArrayList<Reference>();
        private CodeableConcept disease;
        private CodeableConcept diseaseStatus;
        private List<CodeableConcept> comorbidity = new ArrayList<CodeableConcept>();
        private List<Reference> therapeuticIndication = new ArrayList<Reference>();
        private List<OtherTherapy> otherTherapy = new ArrayList<OtherTherapy>();
        private List<Population> population = new ArrayList<Population>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder disease(CodeableConcept disease) {
            this.disease = disease;
            return this;
        }

        public Builder diseaseStatus(CodeableConcept diseaseStatus) {
            this.diseaseStatus = diseaseStatus;
            return this;
        }

        public Builder comorbidity(CodeableConcept ... comorbidity) {
            for (CodeableConcept value : comorbidity) {
                this.comorbidity.add(value);
            }
            return this;
        }

        public Builder comorbidity(Collection<CodeableConcept> comorbidity) {
            this.comorbidity = new ArrayList<CodeableConcept>(comorbidity);
            return this;
        }

        public Builder therapeuticIndication(Reference ... therapeuticIndication) {
            for (Reference value : therapeuticIndication) {
                this.therapeuticIndication.add(value);
            }
            return this;
        }

        public Builder therapeuticIndication(Collection<Reference> therapeuticIndication) {
            this.therapeuticIndication = new ArrayList<Reference>(therapeuticIndication);
            return this;
        }

        public Builder otherTherapy(OtherTherapy ... otherTherapy) {
            for (OtherTherapy value : otherTherapy) {
                this.otherTherapy.add(value);
            }
            return this;
        }

        public Builder otherTherapy(Collection<OtherTherapy> otherTherapy) {
            this.otherTherapy = new ArrayList<OtherTherapy>(otherTherapy);
            return this;
        }

        public Builder population(Population ... population) {
            for (Population value : population) {
                this.population.add(value);
            }
            return this;
        }

        public Builder population(Collection<Population> population) {
            this.population = new ArrayList<Population>(population);
            return this;
        }

        @Override
        public MedicinalProductContraindication build() {
            MedicinalProductContraindication medicinalProductContraindication = new MedicinalProductContraindication(this);
            if (this.validating) {
                this.validate(medicinalProductContraindication);
            }
            return medicinalProductContraindication;
        }

        protected void validate(MedicinalProductContraindication medicinalProductContraindication) {
            super.validate(medicinalProductContraindication);
            ValidationSupport.checkList(medicinalProductContraindication.subject, "subject", Reference.class);
            ValidationSupport.checkList(medicinalProductContraindication.comorbidity, "comorbidity", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProductContraindication.therapeuticIndication, "therapeuticIndication", Reference.class);
            ValidationSupport.checkList(medicinalProductContraindication.otherTherapy, "otherTherapy", OtherTherapy.class);
            ValidationSupport.checkList(medicinalProductContraindication.population, "population", Population.class);
            ValidationSupport.checkReferenceType(medicinalProductContraindication.subject, "subject", "MedicinalProduct", "Medication");
            ValidationSupport.checkReferenceType(medicinalProductContraindication.therapeuticIndication, "therapeuticIndication", "MedicinalProductIndication");
        }

        protected Builder from(MedicinalProductContraindication medicinalProductContraindication) {
            super.from(medicinalProductContraindication);
            this.subject.addAll(medicinalProductContraindication.subject);
            this.disease = medicinalProductContraindication.disease;
            this.diseaseStatus = medicinalProductContraindication.diseaseStatus;
            this.comorbidity.addAll(medicinalProductContraindication.comorbidity);
            this.therapeuticIndication.addAll(medicinalProductContraindication.therapeuticIndication);
            this.otherTherapy.addAll(medicinalProductContraindication.otherTherapy);
            this.population.addAll(medicinalProductContraindication.population);
            return this;
        }
    }
}

