/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductIngredient
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Required
    private final CodeableConcept role;
    @Summary
    private final Boolean allergenicIndicator;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    private final List<SpecifiedSubstance> specifiedSubstance;
    @Summary
    private final Substance substance;

    private MedicinalProductIngredient(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.role = builder.role;
        this.allergenicIndicator = builder.allergenicIndicator;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.specifiedSubstance = Collections.unmodifiableList(builder.specifiedSubstance);
        this.substance = builder.substance;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getRole() {
        return this.role;
    }

    public Boolean getAllergenicIndicator() {
        return this.allergenicIndicator;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<SpecifiedSubstance> getSpecifiedSubstance() {
        return this.specifiedSubstance;
    }

    public Substance getSubstance() {
        return this.substance;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.role != null || this.allergenicIndicator != null || !this.manufacturer.isEmpty() || !this.specifiedSubstance.isEmpty() || this.substance != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.role, "role", visitor);
                this.accept(this.allergenicIndicator, "allergenicIndicator", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.specifiedSubstance, "specifiedSubstance", visitor, SpecifiedSubstance.class);
                this.accept(this.substance, "substance", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductIngredient other = (MedicinalProductIngredient)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.role, other.role) && Objects.equals(this.allergenicIndicator, other.allergenicIndicator) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.specifiedSubstance, other.specifiedSubstance) && Objects.equals(this.substance, other.substance);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.role, this.allergenicIndicator, this.manufacturer, this.specifiedSubstance, this.substance);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Substance
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept code;
        @Summary
        private final List<SpecifiedSubstance.Strength> strength;

        private Substance(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.strength = Collections.unmodifiableList(builder.strength);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public List<SpecifiedSubstance.Strength> getStrength() {
            return this.strength;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.strength.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.strength, "strength", visitor, SpecifiedSubstance.Strength.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Substance other = (Substance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.strength, other.strength);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.strength);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private List<SpecifiedSubstance.Strength> strength = new ArrayList<SpecifiedSubstance.Strength>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder strength(SpecifiedSubstance.Strength ... strength) {
                for (SpecifiedSubstance.Strength value : strength) {
                    this.strength.add(value);
                }
                return this;
            }

            public Builder strength(Collection<SpecifiedSubstance.Strength> strength) {
                this.strength = new ArrayList<SpecifiedSubstance.Strength>(strength);
                return this;
            }

            @Override
            public Substance build() {
                Substance substance = new Substance(this);
                if (this.validating) {
                    this.validate(substance);
                }
                return substance;
            }

            protected void validate(Substance substance) {
                super.validate(substance);
                ValidationSupport.requireNonNull(substance.code, "code");
                ValidationSupport.checkList(substance.strength, "strength", SpecifiedSubstance.Strength.class);
                ValidationSupport.requireValueOrChildren(substance);
            }

            protected Builder from(Substance substance) {
                super.from(substance);
                this.code = substance.code;
                this.strength.addAll(substance.strength);
                return this;
            }
        }
    }

    public static class SpecifiedSubstance
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept code;
        @Summary
        @Required
        private final CodeableConcept group;
        @Summary
        private final CodeableConcept confidentiality;
        @Summary
        private final List<Strength> strength;

        private SpecifiedSubstance(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.group = builder.group;
            this.confidentiality = builder.confidentiality;
            this.strength = Collections.unmodifiableList(builder.strength);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getGroup() {
            return this.group;
        }

        public CodeableConcept getConfidentiality() {
            return this.confidentiality;
        }

        public List<Strength> getStrength() {
            return this.strength;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.group != null || this.confidentiality != null || !this.strength.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.group, "group", visitor);
                    this.accept(this.confidentiality, "confidentiality", visitor);
                    this.accept(this.strength, "strength", visitor, Strength.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpecifiedSubstance other = (SpecifiedSubstance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.group, other.group) && Objects.equals(this.confidentiality, other.confidentiality) && Objects.equals(this.strength, other.strength);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.group, this.confidentiality, this.strength);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Strength
        extends BackboneElement {
            @Summary
            @Required
            private final Ratio presentation;
            @Summary
            private final Ratio presentationLowLimit;
            @Summary
            private final Ratio concentration;
            @Summary
            private final Ratio concentrationLowLimit;
            @Summary
            private final String measurementPoint;
            @Summary
            private final List<CodeableConcept> country;
            @Summary
            private final List<ReferenceStrength> referenceStrength;

            private Strength(Builder builder) {
                super(builder);
                this.presentation = builder.presentation;
                this.presentationLowLimit = builder.presentationLowLimit;
                this.concentration = builder.concentration;
                this.concentrationLowLimit = builder.concentrationLowLimit;
                this.measurementPoint = builder.measurementPoint;
                this.country = Collections.unmodifiableList(builder.country);
                this.referenceStrength = Collections.unmodifiableList(builder.referenceStrength);
            }

            public Ratio getPresentation() {
                return this.presentation;
            }

            public Ratio getPresentationLowLimit() {
                return this.presentationLowLimit;
            }

            public Ratio getConcentration() {
                return this.concentration;
            }

            public Ratio getConcentrationLowLimit() {
                return this.concentrationLowLimit;
            }

            public String getMeasurementPoint() {
                return this.measurementPoint;
            }

            public List<CodeableConcept> getCountry() {
                return this.country;
            }

            public List<ReferenceStrength> getReferenceStrength() {
                return this.referenceStrength;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.presentation != null || this.presentationLowLimit != null || this.concentration != null || this.concentrationLowLimit != null || this.measurementPoint != null || !this.country.isEmpty() || !this.referenceStrength.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.presentation, "presentation", visitor);
                        this.accept(this.presentationLowLimit, "presentationLowLimit", visitor);
                        this.accept(this.concentration, "concentration", visitor);
                        this.accept(this.concentrationLowLimit, "concentrationLowLimit", visitor);
                        this.accept(this.measurementPoint, "measurementPoint", visitor);
                        this.accept(this.country, "country", visitor, CodeableConcept.class);
                        this.accept(this.referenceStrength, "referenceStrength", visitor, ReferenceStrength.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Strength other = (Strength)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.presentation, other.presentation) && Objects.equals(this.presentationLowLimit, other.presentationLowLimit) && Objects.equals(this.concentration, other.concentration) && Objects.equals(this.concentrationLowLimit, other.concentrationLowLimit) && Objects.equals(this.measurementPoint, other.measurementPoint) && Objects.equals(this.country, other.country) && Objects.equals(this.referenceStrength, other.referenceStrength);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.presentation, this.presentationLowLimit, this.concentration, this.concentrationLowLimit, this.measurementPoint, this.country, this.referenceStrength);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class ReferenceStrength
            extends BackboneElement {
                @Summary
                private final CodeableConcept substance;
                @Summary
                @Required
                private final Ratio strength;
                @Summary
                private final Ratio strengthLowLimit;
                @Summary
                private final String measurementPoint;
                @Summary
                private final List<CodeableConcept> country;

                private ReferenceStrength(Builder builder) {
                    super(builder);
                    this.substance = builder.substance;
                    this.strength = builder.strength;
                    this.strengthLowLimit = builder.strengthLowLimit;
                    this.measurementPoint = builder.measurementPoint;
                    this.country = Collections.unmodifiableList(builder.country);
                }

                public CodeableConcept getSubstance() {
                    return this.substance;
                }

                public Ratio getStrength() {
                    return this.strength;
                }

                public Ratio getStrengthLowLimit() {
                    return this.strengthLowLimit;
                }

                public String getMeasurementPoint() {
                    return this.measurementPoint;
                }

                public List<CodeableConcept> getCountry() {
                    return this.country;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.substance != null || this.strength != null || this.strengthLowLimit != null || this.measurementPoint != null || !this.country.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.substance, "substance", visitor);
                            this.accept(this.strength, "strength", visitor);
                            this.accept(this.strengthLowLimit, "strengthLowLimit", visitor);
                            this.accept(this.measurementPoint, "measurementPoint", visitor);
                            this.accept(this.country, "country", visitor, CodeableConcept.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ReferenceStrength other = (ReferenceStrength)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substance, other.substance) && Objects.equals(this.strength, other.strength) && Objects.equals(this.strengthLowLimit, other.strengthLowLimit) && Objects.equals(this.measurementPoint, other.measurementPoint) && Objects.equals(this.country, other.country);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substance, this.strength, this.strengthLowLimit, this.measurementPoint, this.country);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept substance;
                    private Ratio strength;
                    private Ratio strengthLowLimit;
                    private String measurementPoint;
                    private List<CodeableConcept> country = new ArrayList<CodeableConcept>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder substance(CodeableConcept substance) {
                        this.substance = substance;
                        return this;
                    }

                    public Builder strength(Ratio strength) {
                        this.strength = strength;
                        return this;
                    }

                    public Builder strengthLowLimit(Ratio strengthLowLimit) {
                        this.strengthLowLimit = strengthLowLimit;
                        return this;
                    }

                    public Builder measurementPoint(java.lang.String measurementPoint) {
                        this.measurementPoint = measurementPoint == null ? null : String.of(measurementPoint);
                        return this;
                    }

                    public Builder measurementPoint(String measurementPoint) {
                        this.measurementPoint = measurementPoint;
                        return this;
                    }

                    public Builder country(CodeableConcept ... country) {
                        for (CodeableConcept value : country) {
                            this.country.add(value);
                        }
                        return this;
                    }

                    public Builder country(Collection<CodeableConcept> country) {
                        this.country = new ArrayList<CodeableConcept>(country);
                        return this;
                    }

                    @Override
                    public ReferenceStrength build() {
                        ReferenceStrength referenceStrength = new ReferenceStrength(this);
                        if (this.validating) {
                            this.validate(referenceStrength);
                        }
                        return referenceStrength;
                    }

                    protected void validate(ReferenceStrength referenceStrength) {
                        super.validate(referenceStrength);
                        ValidationSupport.requireNonNull(referenceStrength.strength, "strength");
                        ValidationSupport.checkList(referenceStrength.country, "country", CodeableConcept.class);
                        ValidationSupport.requireValueOrChildren(referenceStrength);
                    }

                    protected Builder from(ReferenceStrength referenceStrength) {
                        super.from(referenceStrength);
                        this.substance = referenceStrength.substance;
                        this.strength = referenceStrength.strength;
                        this.strengthLowLimit = referenceStrength.strengthLowLimit;
                        this.measurementPoint = referenceStrength.measurementPoint;
                        this.country.addAll(referenceStrength.country);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Ratio presentation;
                private Ratio presentationLowLimit;
                private Ratio concentration;
                private Ratio concentrationLowLimit;
                private String measurementPoint;
                private List<CodeableConcept> country = new ArrayList<CodeableConcept>();
                private List<ReferenceStrength> referenceStrength = new ArrayList<ReferenceStrength>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder presentation(Ratio presentation) {
                    this.presentation = presentation;
                    return this;
                }

                public Builder presentationLowLimit(Ratio presentationLowLimit) {
                    this.presentationLowLimit = presentationLowLimit;
                    return this;
                }

                public Builder concentration(Ratio concentration) {
                    this.concentration = concentration;
                    return this;
                }

                public Builder concentrationLowLimit(Ratio concentrationLowLimit) {
                    this.concentrationLowLimit = concentrationLowLimit;
                    return this;
                }

                public Builder measurementPoint(java.lang.String measurementPoint) {
                    this.measurementPoint = measurementPoint == null ? null : String.of(measurementPoint);
                    return this;
                }

                public Builder measurementPoint(String measurementPoint) {
                    this.measurementPoint = measurementPoint;
                    return this;
                }

                public Builder country(CodeableConcept ... country) {
                    for (CodeableConcept value : country) {
                        this.country.add(value);
                    }
                    return this;
                }

                public Builder country(Collection<CodeableConcept> country) {
                    this.country = new ArrayList<CodeableConcept>(country);
                    return this;
                }

                public Builder referenceStrength(ReferenceStrength ... referenceStrength) {
                    for (ReferenceStrength value : referenceStrength) {
                        this.referenceStrength.add(value);
                    }
                    return this;
                }

                public Builder referenceStrength(Collection<ReferenceStrength> referenceStrength) {
                    this.referenceStrength = new ArrayList<ReferenceStrength>(referenceStrength);
                    return this;
                }

                @Override
                public Strength build() {
                    Strength strength = new Strength(this);
                    if (this.validating) {
                        this.validate(strength);
                    }
                    return strength;
                }

                protected void validate(Strength strength) {
                    super.validate(strength);
                    ValidationSupport.requireNonNull(strength.presentation, "presentation");
                    ValidationSupport.checkList(strength.country, "country", CodeableConcept.class);
                    ValidationSupport.checkList(strength.referenceStrength, "referenceStrength", ReferenceStrength.class);
                    ValidationSupport.requireValueOrChildren(strength);
                }

                protected Builder from(Strength strength) {
                    super.from(strength);
                    this.presentation = strength.presentation;
                    this.presentationLowLimit = strength.presentationLowLimit;
                    this.concentration = strength.concentration;
                    this.concentrationLowLimit = strength.concentrationLowLimit;
                    this.measurementPoint = strength.measurementPoint;
                    this.country.addAll(strength.country);
                    this.referenceStrength.addAll(strength.referenceStrength);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept group;
            private CodeableConcept confidentiality;
            private List<Strength> strength = new ArrayList<Strength>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder group(CodeableConcept group) {
                this.group = group;
                return this;
            }

            public Builder confidentiality(CodeableConcept confidentiality) {
                this.confidentiality = confidentiality;
                return this;
            }

            public Builder strength(Strength ... strength) {
                for (Strength value : strength) {
                    this.strength.add(value);
                }
                return this;
            }

            public Builder strength(Collection<Strength> strength) {
                this.strength = new ArrayList<Strength>(strength);
                return this;
            }

            @Override
            public SpecifiedSubstance build() {
                SpecifiedSubstance specifiedSubstance = new SpecifiedSubstance(this);
                if (this.validating) {
                    this.validate(specifiedSubstance);
                }
                return specifiedSubstance;
            }

            protected void validate(SpecifiedSubstance specifiedSubstance) {
                super.validate(specifiedSubstance);
                ValidationSupport.requireNonNull(specifiedSubstance.code, "code");
                ValidationSupport.requireNonNull(specifiedSubstance.group, "group");
                ValidationSupport.checkList(specifiedSubstance.strength, "strength", Strength.class);
                ValidationSupport.requireValueOrChildren(specifiedSubstance);
            }

            protected Builder from(SpecifiedSubstance specifiedSubstance) {
                super.from(specifiedSubstance);
                this.code = specifiedSubstance.code;
                this.group = specifiedSubstance.group;
                this.confidentiality = specifiedSubstance.confidentiality;
                this.strength.addAll(specifiedSubstance.strength);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private CodeableConcept role;
        private Boolean allergenicIndicator;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<SpecifiedSubstance> specifiedSubstance = new ArrayList<SpecifiedSubstance>();
        private Substance substance;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder role(CodeableConcept role) {
            this.role = role;
            return this;
        }

        public Builder allergenicIndicator(java.lang.Boolean allergenicIndicator) {
            this.allergenicIndicator = allergenicIndicator == null ? null : Boolean.of(allergenicIndicator);
            return this;
        }

        public Builder allergenicIndicator(Boolean allergenicIndicator) {
            this.allergenicIndicator = allergenicIndicator;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder specifiedSubstance(SpecifiedSubstance ... specifiedSubstance) {
            for (SpecifiedSubstance value : specifiedSubstance) {
                this.specifiedSubstance.add(value);
            }
            return this;
        }

        public Builder specifiedSubstance(Collection<SpecifiedSubstance> specifiedSubstance) {
            this.specifiedSubstance = new ArrayList<SpecifiedSubstance>(specifiedSubstance);
            return this;
        }

        public Builder substance(Substance substance) {
            this.substance = substance;
            return this;
        }

        @Override
        public MedicinalProductIngredient build() {
            MedicinalProductIngredient medicinalProductIngredient = new MedicinalProductIngredient(this);
            if (this.validating) {
                this.validate(medicinalProductIngredient);
            }
            return medicinalProductIngredient;
        }

        protected void validate(MedicinalProductIngredient medicinalProductIngredient) {
            super.validate(medicinalProductIngredient);
            ValidationSupport.requireNonNull(medicinalProductIngredient.role, "role");
            ValidationSupport.checkList(medicinalProductIngredient.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkList(medicinalProductIngredient.specifiedSubstance, "specifiedSubstance", SpecifiedSubstance.class);
            ValidationSupport.checkReferenceType(medicinalProductIngredient.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(MedicinalProductIngredient medicinalProductIngredient) {
            super.from(medicinalProductIngredient);
            this.identifier = medicinalProductIngredient.identifier;
            this.role = medicinalProductIngredient.role;
            this.allergenicIndicator = medicinalProductIngredient.allergenicIndicator;
            this.manufacturer.addAll(medicinalProductIngredient.manufacturer);
            this.specifiedSubstance.addAll(medicinalProductIngredient.specifiedSubstance);
            this.substance = medicinalProductIngredient.substance;
            return this;
        }
    }
}

