/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MessageHeaderResponseRequest;
import com.ibm.fhir.model.type.code.MessageSignificanceCategory;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="msd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/MessageDefinition"), @Constraint(id="md-1", level="Rule", location="MessageDefinition.focus", description="Max must be postive int or *", expression="max='*' or (max.toInteger() > 0)", source="http://hl7.org/fhir/StructureDefinition/MessageDefinition"), @Constraint(id="messageDefinition-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/MessageDefinition", generated=true)})
public class MessageDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    private final List<Canonical> replaces;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    @Required
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    @Summary
    private final Markdown purpose;
    private final Markdown copyright;
    @Summary
    private final Canonical base;
    @Summary
    private final List<Canonical> parent;
    @Summary
    @Choice(value={Coding.class, Uri.class})
    @Binding(bindingName="MessageEvent", strength=BindingStrength.Value.EXAMPLE, description="One of the message events defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/message-events")
    @Required
    private final Element event;
    @Summary
    @Binding(bindingName="MessageSignificanceCategory", strength=BindingStrength.Value.REQUIRED, description="The impact of the content of a message.", valueSet="http://hl7.org/fhir/ValueSet/message-significance-category|4.0.1")
    private final MessageSignificanceCategory category;
    @Summary
    private final List<Focus> focus;
    @Binding(bindingName="messageheader-response-request", strength=BindingStrength.Value.REQUIRED, description="HL7-defined table of codes which identify conditions under which acknowledgments are required to be returned in response to a message.", valueSet="http://hl7.org/fhir/ValueSet/messageheader-response-request|4.0.1")
    private final MessageHeaderResponseRequest responseRequired;
    private final List<AllowedResponse> allowedResponse;
    private final List<Canonical> graph;

    private MessageDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.replaces = Collections.unmodifiableList(builder.replaces);
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.base = builder.base;
        this.parent = Collections.unmodifiableList(builder.parent);
        this.event = builder.event;
        this.category = builder.category;
        this.focus = Collections.unmodifiableList(builder.focus);
        this.responseRequired = builder.responseRequired;
        this.allowedResponse = Collections.unmodifiableList(builder.allowedResponse);
        this.graph = Collections.unmodifiableList(builder.graph);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Canonical> getReplaces() {
        return this.replaces;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Canonical getBase() {
        return this.base;
    }

    public List<Canonical> getParent() {
        return this.parent;
    }

    public Element getEvent() {
        return this.event;
    }

    public MessageSignificanceCategory getCategory() {
        return this.category;
    }

    public List<Focus> getFocus() {
        return this.focus;
    }

    public MessageHeaderResponseRequest getResponseRequired() {
        return this.responseRequired;
    }

    public List<AllowedResponse> getAllowedResponse() {
        return this.allowedResponse;
    }

    public List<Canonical> getGraph() {
        return this.graph;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || !this.replaces.isEmpty() || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.base != null || !this.parent.isEmpty() || this.event != null || this.category != null || !this.focus.isEmpty() || this.responseRequired != null || !this.allowedResponse.isEmpty() || !this.graph.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.replaces, "replaces", visitor, Canonical.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.base, "base", visitor);
                this.accept(this.parent, "parent", visitor, Canonical.class);
                this.accept(this.event, "event", visitor);
                this.accept(this.category, "category", visitor);
                this.accept(this.focus, "focus", visitor, Focus.class);
                this.accept(this.responseRequired, "responseRequired", visitor);
                this.accept(this.allowedResponse, "allowedResponse", visitor, AllowedResponse.class);
                this.accept(this.graph, "graph", visitor, Canonical.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageDefinition other = (MessageDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.base, other.base) && Objects.equals(this.parent, other.parent) && Objects.equals(this.event, other.event) && Objects.equals(this.category, other.category) && Objects.equals(this.focus, other.focus) && Objects.equals(this.responseRequired, other.responseRequired) && Objects.equals(this.allowedResponse, other.allowedResponse) && Objects.equals(this.graph, other.graph);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.replaces, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.base, this.parent, this.event, this.category, this.focus, this.responseRequired, this.allowedResponse, this.graph);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class AllowedResponse
    extends BackboneElement {
        @Required
        private final Canonical message;
        private final Markdown situation;

        private AllowedResponse(Builder builder) {
            super(builder);
            this.message = builder.message;
            this.situation = builder.situation;
        }

        public Canonical getMessage() {
            return this.message;
        }

        public Markdown getSituation() {
            return this.situation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.message != null || this.situation != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.message, "message", visitor);
                    this.accept(this.situation, "situation", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AllowedResponse other = (AllowedResponse)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.message, other.message) && Objects.equals(this.situation, other.situation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.message, this.situation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical message;
            private Markdown situation;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder message(Canonical message) {
                this.message = message;
                return this;
            }

            public Builder situation(Markdown situation) {
                this.situation = situation;
                return this;
            }

            @Override
            public AllowedResponse build() {
                AllowedResponse allowedResponse = new AllowedResponse(this);
                if (this.validating) {
                    this.validate(allowedResponse);
                }
                return allowedResponse;
            }

            protected void validate(AllowedResponse allowedResponse) {
                super.validate(allowedResponse);
                ValidationSupport.requireNonNull(allowedResponse.message, "message");
                ValidationSupport.requireValueOrChildren(allowedResponse);
            }

            protected Builder from(AllowedResponse allowedResponse) {
                super.from(allowedResponse);
                this.message = allowedResponse.message;
                this.situation = allowedResponse.situation;
                return this;
            }
        }
    }

    public static class Focus
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ResourceType", strength=BindingStrength.Value.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
        @Required
        private final ResourceType code;
        private final Canonical profile;
        @Summary
        @Required
        private final UnsignedInt min;
        private final String max;

        private Focus(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.profile = builder.profile;
            this.min = builder.min;
            this.max = builder.max;
        }

        public ResourceType getCode() {
            return this.code;
        }

        public Canonical getProfile() {
            return this.profile;
        }

        public UnsignedInt getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.profile != null || this.min != null || this.max != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.profile, "profile", visitor);
                    this.accept(this.min, "min", visitor);
                    this.accept(this.max, "max", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Focus other = (Focus)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.profile, other.profile) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.profile, this.min, this.max);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ResourceType code;
            private Canonical profile;
            private UnsignedInt min;
            private String max;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(ResourceType code) {
                this.code = code;
                return this;
            }

            public Builder profile(Canonical profile) {
                this.profile = profile;
                return this;
            }

            public Builder min(UnsignedInt min) {
                this.min = min;
                return this;
            }

            public Builder max(java.lang.String max) {
                this.max = max == null ? null : String.of(max);
                return this;
            }

            public Builder max(String max) {
                this.max = max;
                return this;
            }

            @Override
            public Focus build() {
                Focus focus = new Focus(this);
                if (this.validating) {
                    this.validate(focus);
                }
                return focus;
            }

            protected void validate(Focus focus) {
                super.validate(focus);
                ValidationSupport.requireNonNull(focus.code, "code");
                ValidationSupport.requireNonNull(focus.min, "min");
                ValidationSupport.requireValueOrChildren(focus);
            }

            protected Builder from(Focus focus) {
                super.from(focus);
                this.code = focus.code;
                this.profile = focus.profile;
                this.min = focus.min;
                this.max = focus.max;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private List<Canonical> replaces = new ArrayList<Canonical>();
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Canonical base;
        private List<Canonical> parent = new ArrayList<Canonical>();
        private Element event;
        private MessageSignificanceCategory category;
        private List<Focus> focus = new ArrayList<Focus>();
        private MessageHeaderResponseRequest responseRequired;
        private List<AllowedResponse> allowedResponse = new ArrayList<AllowedResponse>();
        private List<Canonical> graph = new ArrayList<Canonical>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder replaces(Canonical ... replaces) {
            for (Canonical value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Canonical> replaces) {
            this.replaces = new ArrayList<Canonical>(replaces);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder base(Canonical base) {
            this.base = base;
            return this;
        }

        public Builder parent(Canonical ... parent) {
            for (Canonical value : parent) {
                this.parent.add(value);
            }
            return this;
        }

        public Builder parent(Collection<Canonical> parent) {
            this.parent = new ArrayList<Canonical>(parent);
            return this;
        }

        public Builder event(Element event) {
            this.event = event;
            return this;
        }

        public Builder category(MessageSignificanceCategory category) {
            this.category = category;
            return this;
        }

        public Builder focus(Focus ... focus) {
            for (Focus value : focus) {
                this.focus.add(value);
            }
            return this;
        }

        public Builder focus(Collection<Focus> focus) {
            this.focus = new ArrayList<Focus>(focus);
            return this;
        }

        public Builder responseRequired(MessageHeaderResponseRequest responseRequired) {
            this.responseRequired = responseRequired;
            return this;
        }

        public Builder allowedResponse(AllowedResponse ... allowedResponse) {
            for (AllowedResponse value : allowedResponse) {
                this.allowedResponse.add(value);
            }
            return this;
        }

        public Builder allowedResponse(Collection<AllowedResponse> allowedResponse) {
            this.allowedResponse = new ArrayList<AllowedResponse>(allowedResponse);
            return this;
        }

        public Builder graph(Canonical ... graph) {
            for (Canonical value : graph) {
                this.graph.add(value);
            }
            return this;
        }

        public Builder graph(Collection<Canonical> graph) {
            this.graph = new ArrayList<Canonical>(graph);
            return this;
        }

        @Override
        public MessageDefinition build() {
            MessageDefinition messageDefinition = new MessageDefinition(this);
            if (this.validating) {
                this.validate(messageDefinition);
            }
            return messageDefinition;
        }

        protected void validate(MessageDefinition messageDefinition) {
            super.validate(messageDefinition);
            ValidationSupport.checkList(messageDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(messageDefinition.replaces, "replaces", Canonical.class);
            ValidationSupport.requireNonNull(messageDefinition.status, "status");
            ValidationSupport.requireNonNull(messageDefinition.date, "date");
            ValidationSupport.checkList(messageDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(messageDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(messageDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(messageDefinition.parent, "parent", Canonical.class);
            ValidationSupport.requireChoiceElement(messageDefinition.event, "event", Coding.class, Uri.class);
            ValidationSupport.checkList(messageDefinition.focus, "focus", Focus.class);
            ValidationSupport.checkList(messageDefinition.allowedResponse, "allowedResponse", AllowedResponse.class);
            ValidationSupport.checkList(messageDefinition.graph, "graph", Canonical.class);
        }

        protected Builder from(MessageDefinition messageDefinition) {
            super.from(messageDefinition);
            this.url = messageDefinition.url;
            this.identifier.addAll(messageDefinition.identifier);
            this.version = messageDefinition.version;
            this.name = messageDefinition.name;
            this.title = messageDefinition.title;
            this.replaces.addAll(messageDefinition.replaces);
            this.status = messageDefinition.status;
            this.experimental = messageDefinition.experimental;
            this.date = messageDefinition.date;
            this.publisher = messageDefinition.publisher;
            this.contact.addAll(messageDefinition.contact);
            this.description = messageDefinition.description;
            this.useContext.addAll(messageDefinition.useContext);
            this.jurisdiction.addAll(messageDefinition.jurisdiction);
            this.purpose = messageDefinition.purpose;
            this.copyright = messageDefinition.copyright;
            this.base = messageDefinition.base;
            this.parent.addAll(messageDefinition.parent);
            this.event = messageDefinition.event;
            this.category = messageDefinition.category;
            this.focus.addAll(messageDefinition.focus);
            this.responseRequired = messageDefinition.responseRequired;
            this.allowedResponse.addAll(messageDefinition.allowedResponse);
            this.graph.addAll(messageDefinition.graph);
            return this;
        }
    }
}

