/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.OrientationType;
import com.ibm.fhir.model.type.code.QualityType;
import com.ibm.fhir.model.type.code.RepositoryType;
import com.ibm.fhir.model.type.code.SequenceType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.StrandType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="msq-3", level="Rule", location="(base)", description="Only 0 and 1 are valid for coordinateSystem", expression="coordinateSystem = 1 or coordinateSystem = 0", source="http://hl7.org/fhir/StructureDefinition/MolecularSequence"), @Constraint(id="msq-5", level="Rule", location="MolecularSequence.referenceSeq", description="GenomeBuild and chromosome must be both contained if either one of them is contained", expression="(chromosome.empty() and genomeBuild.empty()) or (chromosome.exists() and genomeBuild.exists())", source="http://hl7.org/fhir/StructureDefinition/MolecularSequence"), @Constraint(id="msq-6", level="Rule", location="MolecularSequence.referenceSeq", description="Have and only have one of the following elements in referenceSeq : 1. genomeBuild ; 2 referenceSeqId; 3. referenceSeqPointer;  4. referenceSeqString;", expression="(genomeBuild.count()+referenceSeqId.count()+ referenceSeqPointer.count()+ referenceSeqString.count()) = 1", source="http://hl7.org/fhir/StructureDefinition/MolecularSequence")})
public class MolecularSequence
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="sequenceType", strength=BindingStrength.Value.REQUIRED, description="Type if a sequence -- DNA, RNA, or amino acid sequence.", valueSet="http://hl7.org/fhir/ValueSet/sequence-type|4.0.1")
    private final SequenceType type;
    @Summary
    @Required
    private final Integer coordinateSystem;
    @Summary
    @ReferenceTarget(value={"Patient"})
    private final Reference patient;
    @Summary
    @ReferenceTarget(value={"Specimen"})
    private final Reference specimen;
    @Summary
    @ReferenceTarget(value={"Device"})
    private final Reference device;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference performer;
    @Summary
    private final Quantity quantity;
    @Summary
    private final ReferenceSeq referenceSeq;
    @Summary
    private final List<Variant> variant;
    @Summary
    private final String observedSeq;
    @Summary
    private final List<Quality> quality;
    @Summary
    private final Integer readCoverage;
    @Summary
    private final List<Repository> repository;
    @Summary
    @ReferenceTarget(value={"MolecularSequence"})
    private final List<Reference> pointer;
    @Summary
    private final List<StructureVariant> structureVariant;

    private MolecularSequence(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.type = builder.type;
        this.coordinateSystem = builder.coordinateSystem;
        this.patient = builder.patient;
        this.specimen = builder.specimen;
        this.device = builder.device;
        this.performer = builder.performer;
        this.quantity = builder.quantity;
        this.referenceSeq = builder.referenceSeq;
        this.variant = Collections.unmodifiableList(builder.variant);
        this.observedSeq = builder.observedSeq;
        this.quality = Collections.unmodifiableList(builder.quality);
        this.readCoverage = builder.readCoverage;
        this.repository = Collections.unmodifiableList(builder.repository);
        this.pointer = Collections.unmodifiableList(builder.pointer);
        this.structureVariant = Collections.unmodifiableList(builder.structureVariant);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public SequenceType getType() {
        return this.type;
    }

    public Integer getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getSpecimen() {
        return this.specimen;
    }

    public Reference getDevice() {
        return this.device;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public ReferenceSeq getReferenceSeq() {
        return this.referenceSeq;
    }

    public List<Variant> getVariant() {
        return this.variant;
    }

    public String getObservedSeq() {
        return this.observedSeq;
    }

    public List<Quality> getQuality() {
        return this.quality;
    }

    public Integer getReadCoverage() {
        return this.readCoverage;
    }

    public List<Repository> getRepository() {
        return this.repository;
    }

    public List<Reference> getPointer() {
        return this.pointer;
    }

    public List<StructureVariant> getStructureVariant() {
        return this.structureVariant;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.coordinateSystem != null || this.patient != null || this.specimen != null || this.device != null || this.performer != null || this.quantity != null || this.referenceSeq != null || !this.variant.isEmpty() || this.observedSeq != null || !this.quality.isEmpty() || this.readCoverage != null || !this.repository.isEmpty() || !this.pointer.isEmpty() || !this.structureVariant.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.coordinateSystem, "coordinateSystem", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.specimen, "specimen", visitor);
                this.accept(this.device, "device", visitor);
                this.accept(this.performer, "performer", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.referenceSeq, "referenceSeq", visitor);
                this.accept(this.variant, "variant", visitor, Variant.class);
                this.accept(this.observedSeq, "observedSeq", visitor);
                this.accept(this.quality, "quality", visitor, Quality.class);
                this.accept(this.readCoverage, "readCoverage", visitor);
                this.accept(this.repository, "repository", visitor, Repository.class);
                this.accept(this.pointer, "pointer", visitor, Reference.class);
                this.accept(this.structureVariant, "structureVariant", visitor, StructureVariant.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MolecularSequence other = (MolecularSequence)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.coordinateSystem, other.coordinateSystem) && Objects.equals(this.patient, other.patient) && Objects.equals(this.specimen, other.specimen) && Objects.equals(this.device, other.device) && Objects.equals(this.performer, other.performer) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.referenceSeq, other.referenceSeq) && Objects.equals(this.variant, other.variant) && Objects.equals(this.observedSeq, other.observedSeq) && Objects.equals(this.quality, other.quality) && Objects.equals(this.readCoverage, other.readCoverage) && Objects.equals(this.repository, other.repository) && Objects.equals(this.pointer, other.pointer) && Objects.equals(this.structureVariant, other.structureVariant);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.coordinateSystem, this.patient, this.specimen, this.device, this.performer, this.quantity, this.referenceSeq, this.variant, this.observedSeq, this.quality, this.readCoverage, this.repository, this.pointer, this.structureVariant);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class StructureVariant
    extends BackboneElement {
        @Summary
        @Binding(bindingName="LOINC LL379-9 answerlist", strength=BindingStrength.Value.REQUIRED, description="DNA change type.", valueSet="http://loinc.org/vs/LL379-9|4.0.1")
        private final CodeableConcept variantType;
        @Summary
        private final Boolean exact;
        @Summary
        private final Integer length;
        @Summary
        private final Outer outer;
        @Summary
        private final Inner inner;

        private StructureVariant(Builder builder) {
            super(builder);
            this.variantType = builder.variantType;
            this.exact = builder.exact;
            this.length = builder.length;
            this.outer = builder.outer;
            this.inner = builder.inner;
        }

        public CodeableConcept getVariantType() {
            return this.variantType;
        }

        public Boolean getExact() {
            return this.exact;
        }

        public Integer getLength() {
            return this.length;
        }

        public Outer getOuter() {
            return this.outer;
        }

        public Inner getInner() {
            return this.inner;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.variantType != null || this.exact != null || this.length != null || this.outer != null || this.inner != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.variantType, "variantType", visitor);
                    this.accept(this.exact, "exact", visitor);
                    this.accept(this.length, "length", visitor);
                    this.accept(this.outer, "outer", visitor);
                    this.accept(this.inner, "inner", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StructureVariant other = (StructureVariant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.variantType, other.variantType) && Objects.equals(this.exact, other.exact) && Objects.equals(this.length, other.length) && Objects.equals(this.outer, other.outer) && Objects.equals(this.inner, other.inner);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.variantType, this.exact, this.length, this.outer, this.inner);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Inner
        extends BackboneElement {
            @Summary
            private final Integer start;
            @Summary
            private final Integer end;

            private Inner(Builder builder) {
                super(builder);
                this.start = builder.start;
                this.end = builder.end;
            }

            public Integer getStart() {
                return this.start;
            }

            public Integer getEnd() {
                return this.end;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.start != null || this.end != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.start, "start", visitor);
                        this.accept(this.end, "end", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Inner other = (Inner)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.start, this.end);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Integer start;
                private Integer end;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder start(java.lang.Integer start) {
                    this.start = start == null ? null : Integer.of(start);
                    return this;
                }

                public Builder start(Integer start) {
                    this.start = start;
                    return this;
                }

                public Builder end(java.lang.Integer end) {
                    this.end = end == null ? null : Integer.of(end);
                    return this;
                }

                public Builder end(Integer end) {
                    this.end = end;
                    return this;
                }

                @Override
                public Inner build() {
                    Inner inner = new Inner(this);
                    if (this.validating) {
                        this.validate(inner);
                    }
                    return inner;
                }

                protected void validate(Inner inner) {
                    super.validate(inner);
                    ValidationSupport.requireValueOrChildren(inner);
                }

                protected Builder from(Inner inner) {
                    super.from(inner);
                    this.start = inner.start;
                    this.end = inner.end;
                    return this;
                }
            }
        }

        public static class Outer
        extends BackboneElement {
            @Summary
            private final Integer start;
            @Summary
            private final Integer end;

            private Outer(Builder builder) {
                super(builder);
                this.start = builder.start;
                this.end = builder.end;
            }

            public Integer getStart() {
                return this.start;
            }

            public Integer getEnd() {
                return this.end;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.start != null || this.end != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.start, "start", visitor);
                        this.accept(this.end, "end", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Outer other = (Outer)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.start, this.end);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Integer start;
                private Integer end;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder start(java.lang.Integer start) {
                    this.start = start == null ? null : Integer.of(start);
                    return this;
                }

                public Builder start(Integer start) {
                    this.start = start;
                    return this;
                }

                public Builder end(java.lang.Integer end) {
                    this.end = end == null ? null : Integer.of(end);
                    return this;
                }

                public Builder end(Integer end) {
                    this.end = end;
                    return this;
                }

                @Override
                public Outer build() {
                    Outer outer = new Outer(this);
                    if (this.validating) {
                        this.validate(outer);
                    }
                    return outer;
                }

                protected void validate(Outer outer) {
                    super.validate(outer);
                    ValidationSupport.requireValueOrChildren(outer);
                }

                protected Builder from(Outer outer) {
                    super.from(outer);
                    this.start = outer.start;
                    this.end = outer.end;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept variantType;
            private Boolean exact;
            private Integer length;
            private Outer outer;
            private Inner inner;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder variantType(CodeableConcept variantType) {
                this.variantType = variantType;
                return this;
            }

            public Builder exact(java.lang.Boolean exact) {
                this.exact = exact == null ? null : Boolean.of(exact);
                return this;
            }

            public Builder exact(Boolean exact) {
                this.exact = exact;
                return this;
            }

            public Builder length(java.lang.Integer length) {
                this.length = length == null ? null : Integer.of(length);
                return this;
            }

            public Builder length(Integer length) {
                this.length = length;
                return this;
            }

            public Builder outer(Outer outer) {
                this.outer = outer;
                return this;
            }

            public Builder inner(Inner inner) {
                this.inner = inner;
                return this;
            }

            @Override
            public StructureVariant build() {
                StructureVariant structureVariant = new StructureVariant(this);
                if (this.validating) {
                    this.validate(structureVariant);
                }
                return structureVariant;
            }

            protected void validate(StructureVariant structureVariant) {
                super.validate(structureVariant);
                ValidationSupport.requireValueOrChildren(structureVariant);
            }

            protected Builder from(StructureVariant structureVariant) {
                super.from(structureVariant);
                this.variantType = structureVariant.variantType;
                this.exact = structureVariant.exact;
                this.length = structureVariant.length;
                this.outer = structureVariant.outer;
                this.inner = structureVariant.inner;
                return this;
            }
        }
    }

    public static class Repository
    extends BackboneElement {
        @Summary
        @Binding(bindingName="repositoryType", strength=BindingStrength.Value.REQUIRED, description="Type for access of external URI.", valueSet="http://hl7.org/fhir/ValueSet/repository-type|4.0.1")
        @Required
        private final RepositoryType type;
        @Summary
        private final Uri url;
        @Summary
        private final String name;
        @Summary
        private final String datasetId;
        @Summary
        private final String variantsetId;
        @Summary
        private final String readsetId;

        private Repository(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.url = builder.url;
            this.name = builder.name;
            this.datasetId = builder.datasetId;
            this.variantsetId = builder.variantsetId;
            this.readsetId = builder.readsetId;
        }

        public RepositoryType getType() {
            return this.type;
        }

        public Uri getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getDatasetId() {
            return this.datasetId;
        }

        public String getVariantsetId() {
            return this.variantsetId;
        }

        public String getReadsetId() {
            return this.readsetId;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.url != null || this.name != null || this.datasetId != null || this.variantsetId != null || this.readsetId != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.url, "url", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.datasetId, "datasetId", visitor);
                    this.accept(this.variantsetId, "variantsetId", visitor);
                    this.accept(this.readsetId, "readsetId", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repository other = (Repository)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.url, other.url) && Objects.equals(this.name, other.name) && Objects.equals(this.datasetId, other.datasetId) && Objects.equals(this.variantsetId, other.variantsetId) && Objects.equals(this.readsetId, other.readsetId);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.url, this.name, this.datasetId, this.variantsetId, this.readsetId);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private RepositoryType type;
            private Uri url;
            private String name;
            private String datasetId;
            private String variantsetId;
            private String readsetId;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(RepositoryType type) {
                this.type = type;
                return this;
            }

            public Builder url(Uri url) {
                this.url = url;
                return this;
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder datasetId(java.lang.String datasetId) {
                this.datasetId = datasetId == null ? null : String.of(datasetId);
                return this;
            }

            public Builder datasetId(String datasetId) {
                this.datasetId = datasetId;
                return this;
            }

            public Builder variantsetId(java.lang.String variantsetId) {
                this.variantsetId = variantsetId == null ? null : String.of(variantsetId);
                return this;
            }

            public Builder variantsetId(String variantsetId) {
                this.variantsetId = variantsetId;
                return this;
            }

            public Builder readsetId(java.lang.String readsetId) {
                this.readsetId = readsetId == null ? null : String.of(readsetId);
                return this;
            }

            public Builder readsetId(String readsetId) {
                this.readsetId = readsetId;
                return this;
            }

            @Override
            public Repository build() {
                Repository repository = new Repository(this);
                if (this.validating) {
                    this.validate(repository);
                }
                return repository;
            }

            protected void validate(Repository repository) {
                super.validate(repository);
                ValidationSupport.requireNonNull(repository.type, "type");
                ValidationSupport.requireValueOrChildren(repository);
            }

            protected Builder from(Repository repository) {
                super.from(repository);
                this.type = repository.type;
                this.url = repository.url;
                this.name = repository.name;
                this.datasetId = repository.datasetId;
                this.variantsetId = repository.variantsetId;
                this.readsetId = repository.readsetId;
                return this;
            }
        }
    }

    public static class Quality
    extends BackboneElement {
        @Summary
        @Binding(bindingName="qualityType", strength=BindingStrength.Value.REQUIRED, description="Type for quality report.", valueSet="http://hl7.org/fhir/ValueSet/quality-type|4.0.1")
        @Required
        private final QualityType type;
        @Summary
        @Binding(bindingName="qualityStandardSequence", strength=BindingStrength.Value.EXAMPLE, description="Reference identifier of the sequence that used to mark the quality of tested samples.", valueSet="http://hl7.org/fhir/ValueSet/sequence-quality-standardSequence")
        private final CodeableConcept standardSequence;
        @Summary
        private final Integer start;
        @Summary
        private final Integer end;
        @Summary
        private final Quantity score;
        @Summary
        @Binding(bindingName="qualityMethod", strength=BindingStrength.Value.EXAMPLE, description="The method used to evaluate the numerical quality of the observed sequence.", valueSet="http://hl7.org/fhir/ValueSet/sequence-quality-method")
        private final CodeableConcept method;
        @Summary
        private final Decimal truthTP;
        @Summary
        private final Decimal queryTP;
        @Summary
        private final Decimal truthFN;
        @Summary
        private final Decimal queryFP;
        @Summary
        private final Decimal gtFP;
        @Summary
        private final Decimal precision;
        @Summary
        private final Decimal recall;
        @Summary
        private final Decimal fScore;
        @Summary
        private final Roc roc;

        private Quality(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.standardSequence = builder.standardSequence;
            this.start = builder.start;
            this.end = builder.end;
            this.score = builder.score;
            this.method = builder.method;
            this.truthTP = builder.truthTP;
            this.queryTP = builder.queryTP;
            this.truthFN = builder.truthFN;
            this.queryFP = builder.queryFP;
            this.gtFP = builder.gtFP;
            this.precision = builder.precision;
            this.recall = builder.recall;
            this.fScore = builder.fScore;
            this.roc = builder.roc;
        }

        public QualityType getType() {
            return this.type;
        }

        public CodeableConcept getStandardSequence() {
            return this.standardSequence;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public Quantity getScore() {
            return this.score;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public Decimal getTruthTP() {
            return this.truthTP;
        }

        public Decimal getQueryTP() {
            return this.queryTP;
        }

        public Decimal getTruthFN() {
            return this.truthFN;
        }

        public Decimal getQueryFP() {
            return this.queryFP;
        }

        public Decimal getGtFP() {
            return this.gtFP;
        }

        public Decimal getPrecision() {
            return this.precision;
        }

        public Decimal getRecall() {
            return this.recall;
        }

        public Decimal getFScore() {
            return this.fScore;
        }

        public Roc getRoc() {
            return this.roc;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.standardSequence != null || this.start != null || this.end != null || this.score != null || this.method != null || this.truthTP != null || this.queryTP != null || this.truthFN != null || this.queryFP != null || this.gtFP != null || this.precision != null || this.recall != null || this.fScore != null || this.roc != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.standardSequence, "standardSequence", visitor);
                    this.accept(this.start, "start", visitor);
                    this.accept(this.end, "end", visitor);
                    this.accept(this.score, "score", visitor);
                    this.accept(this.method, "method", visitor);
                    this.accept(this.truthTP, "truthTP", visitor);
                    this.accept(this.queryTP, "queryTP", visitor);
                    this.accept(this.truthFN, "truthFN", visitor);
                    this.accept(this.queryFP, "queryFP", visitor);
                    this.accept(this.gtFP, "gtFP", visitor);
                    this.accept(this.precision, "precision", visitor);
                    this.accept(this.recall, "recall", visitor);
                    this.accept(this.fScore, "fScore", visitor);
                    this.accept(this.roc, "roc", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Quality other = (Quality)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.standardSequence, other.standardSequence) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.score, other.score) && Objects.equals(this.method, other.method) && Objects.equals(this.truthTP, other.truthTP) && Objects.equals(this.queryTP, other.queryTP) && Objects.equals(this.truthFN, other.truthFN) && Objects.equals(this.queryFP, other.queryFP) && Objects.equals(this.gtFP, other.gtFP) && Objects.equals(this.precision, other.precision) && Objects.equals(this.recall, other.recall) && Objects.equals(this.fScore, other.fScore) && Objects.equals(this.roc, other.roc);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.standardSequence, this.start, this.end, this.score, this.method, this.truthTP, this.queryTP, this.truthFN, this.queryFP, this.gtFP, this.precision, this.recall, this.fScore, this.roc);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Roc
        extends BackboneElement {
            @Summary
            private final List<Integer> score;
            @Summary
            private final List<Integer> numTP;
            @Summary
            private final List<Integer> numFP;
            @Summary
            private final List<Integer> numFN;
            @Summary
            private final List<Decimal> precision;
            @Summary
            private final List<Decimal> sensitivity;
            @Summary
            private final List<Decimal> fMeasure;

            private Roc(Builder builder) {
                super(builder);
                this.score = Collections.unmodifiableList(builder.score);
                this.numTP = Collections.unmodifiableList(builder.numTP);
                this.numFP = Collections.unmodifiableList(builder.numFP);
                this.numFN = Collections.unmodifiableList(builder.numFN);
                this.precision = Collections.unmodifiableList(builder.precision);
                this.sensitivity = Collections.unmodifiableList(builder.sensitivity);
                this.fMeasure = Collections.unmodifiableList(builder.fMeasure);
            }

            public List<Integer> getScore() {
                return this.score;
            }

            public List<Integer> getNumTP() {
                return this.numTP;
            }

            public List<Integer> getNumFP() {
                return this.numFP;
            }

            public List<Integer> getNumFN() {
                return this.numFN;
            }

            public List<Decimal> getPrecision() {
                return this.precision;
            }

            public List<Decimal> getSensitivity() {
                return this.sensitivity;
            }

            public List<Decimal> getFMeasure() {
                return this.fMeasure;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.score.isEmpty() || !this.numTP.isEmpty() || !this.numFP.isEmpty() || !this.numFN.isEmpty() || !this.precision.isEmpty() || !this.sensitivity.isEmpty() || !this.fMeasure.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.score, "score", visitor, Integer.class);
                        this.accept(this.numTP, "numTP", visitor, Integer.class);
                        this.accept(this.numFP, "numFP", visitor, Integer.class);
                        this.accept(this.numFN, "numFN", visitor, Integer.class);
                        this.accept(this.precision, "precision", visitor, Decimal.class);
                        this.accept(this.sensitivity, "sensitivity", visitor, Decimal.class);
                        this.accept(this.fMeasure, "fMeasure", visitor, Decimal.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Roc other = (Roc)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.score, other.score) && Objects.equals(this.numTP, other.numTP) && Objects.equals(this.numFP, other.numFP) && Objects.equals(this.numFN, other.numFN) && Objects.equals(this.precision, other.precision) && Objects.equals(this.sensitivity, other.sensitivity) && Objects.equals(this.fMeasure, other.fMeasure);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.score, this.numTP, this.numFP, this.numFN, this.precision, this.sensitivity, this.fMeasure);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<Integer> score = new ArrayList<Integer>();
                private List<Integer> numTP = new ArrayList<Integer>();
                private List<Integer> numFP = new ArrayList<Integer>();
                private List<Integer> numFN = new ArrayList<Integer>();
                private List<Decimal> precision = new ArrayList<Decimal>();
                private List<Decimal> sensitivity = new ArrayList<Decimal>();
                private List<Decimal> fMeasure = new ArrayList<Decimal>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder score(java.lang.Integer ... score) {
                    for (java.lang.Integer value : score) {
                        this.score.add(value == null ? null : Integer.of(value));
                    }
                    return this;
                }

                public Builder score(Integer ... score) {
                    for (Integer value : score) {
                        this.score.add(value);
                    }
                    return this;
                }

                public Builder score(Collection<Integer> score) {
                    this.score = new ArrayList<Integer>(score);
                    return this;
                }

                public Builder numTP(java.lang.Integer ... numTP) {
                    for (java.lang.Integer value : numTP) {
                        this.numTP.add(value == null ? null : Integer.of(value));
                    }
                    return this;
                }

                public Builder numTP(Integer ... numTP) {
                    for (Integer value : numTP) {
                        this.numTP.add(value);
                    }
                    return this;
                }

                public Builder numTP(Collection<Integer> numTP) {
                    this.numTP = new ArrayList<Integer>(numTP);
                    return this;
                }

                public Builder numFP(java.lang.Integer ... numFP) {
                    for (java.lang.Integer value : numFP) {
                        this.numFP.add(value == null ? null : Integer.of(value));
                    }
                    return this;
                }

                public Builder numFP(Integer ... numFP) {
                    for (Integer value : numFP) {
                        this.numFP.add(value);
                    }
                    return this;
                }

                public Builder numFP(Collection<Integer> numFP) {
                    this.numFP = new ArrayList<Integer>(numFP);
                    return this;
                }

                public Builder numFN(java.lang.Integer ... numFN) {
                    for (java.lang.Integer value : numFN) {
                        this.numFN.add(value == null ? null : Integer.of(value));
                    }
                    return this;
                }

                public Builder numFN(Integer ... numFN) {
                    for (Integer value : numFN) {
                        this.numFN.add(value);
                    }
                    return this;
                }

                public Builder numFN(Collection<Integer> numFN) {
                    this.numFN = new ArrayList<Integer>(numFN);
                    return this;
                }

                public Builder precision(Decimal ... precision) {
                    for (Decimal value : precision) {
                        this.precision.add(value);
                    }
                    return this;
                }

                public Builder precision(Collection<Decimal> precision) {
                    this.precision = new ArrayList<Decimal>(precision);
                    return this;
                }

                public Builder sensitivity(Decimal ... sensitivity) {
                    for (Decimal value : sensitivity) {
                        this.sensitivity.add(value);
                    }
                    return this;
                }

                public Builder sensitivity(Collection<Decimal> sensitivity) {
                    this.sensitivity = new ArrayList<Decimal>(sensitivity);
                    return this;
                }

                public Builder fMeasure(Decimal ... fMeasure) {
                    for (Decimal value : fMeasure) {
                        this.fMeasure.add(value);
                    }
                    return this;
                }

                public Builder fMeasure(Collection<Decimal> fMeasure) {
                    this.fMeasure = new ArrayList<Decimal>(fMeasure);
                    return this;
                }

                @Override
                public Roc build() {
                    Roc roc = new Roc(this);
                    if (this.validating) {
                        this.validate(roc);
                    }
                    return roc;
                }

                protected void validate(Roc roc) {
                    super.validate(roc);
                    ValidationSupport.checkList(roc.score, "score", Integer.class);
                    ValidationSupport.checkList(roc.numTP, "numTP", Integer.class);
                    ValidationSupport.checkList(roc.numFP, "numFP", Integer.class);
                    ValidationSupport.checkList(roc.numFN, "numFN", Integer.class);
                    ValidationSupport.checkList(roc.precision, "precision", Decimal.class);
                    ValidationSupport.checkList(roc.sensitivity, "sensitivity", Decimal.class);
                    ValidationSupport.checkList(roc.fMeasure, "fMeasure", Decimal.class);
                    ValidationSupport.requireValueOrChildren(roc);
                }

                protected Builder from(Roc roc) {
                    super.from(roc);
                    this.score.addAll(roc.score);
                    this.numTP.addAll(roc.numTP);
                    this.numFP.addAll(roc.numFP);
                    this.numFN.addAll(roc.numFN);
                    this.precision.addAll(roc.precision);
                    this.sensitivity.addAll(roc.sensitivity);
                    this.fMeasure.addAll(roc.fMeasure);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private QualityType type;
            private CodeableConcept standardSequence;
            private Integer start;
            private Integer end;
            private Quantity score;
            private CodeableConcept method;
            private Decimal truthTP;
            private Decimal queryTP;
            private Decimal truthFN;
            private Decimal queryFP;
            private Decimal gtFP;
            private Decimal precision;
            private Decimal recall;
            private Decimal fScore;
            private Roc roc;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(QualityType type) {
                this.type = type;
                return this;
            }

            public Builder standardSequence(CodeableConcept standardSequence) {
                this.standardSequence = standardSequence;
                return this;
            }

            public Builder start(java.lang.Integer start) {
                this.start = start == null ? null : Integer.of(start);
                return this;
            }

            public Builder start(Integer start) {
                this.start = start;
                return this;
            }

            public Builder end(java.lang.Integer end) {
                this.end = end == null ? null : Integer.of(end);
                return this;
            }

            public Builder end(Integer end) {
                this.end = end;
                return this;
            }

            public Builder score(Quantity score) {
                this.score = score;
                return this;
            }

            public Builder method(CodeableConcept method) {
                this.method = method;
                return this;
            }

            public Builder truthTP(Decimal truthTP) {
                this.truthTP = truthTP;
                return this;
            }

            public Builder queryTP(Decimal queryTP) {
                this.queryTP = queryTP;
                return this;
            }

            public Builder truthFN(Decimal truthFN) {
                this.truthFN = truthFN;
                return this;
            }

            public Builder queryFP(Decimal queryFP) {
                this.queryFP = queryFP;
                return this;
            }

            public Builder gtFP(Decimal gtFP) {
                this.gtFP = gtFP;
                return this;
            }

            public Builder precision(Decimal precision) {
                this.precision = precision;
                return this;
            }

            public Builder recall(Decimal recall) {
                this.recall = recall;
                return this;
            }

            public Builder fScore(Decimal fScore) {
                this.fScore = fScore;
                return this;
            }

            public Builder roc(Roc roc) {
                this.roc = roc;
                return this;
            }

            @Override
            public Quality build() {
                Quality quality = new Quality(this);
                if (this.validating) {
                    this.validate(quality);
                }
                return quality;
            }

            protected void validate(Quality quality) {
                super.validate(quality);
                ValidationSupport.requireNonNull(quality.type, "type");
                ValidationSupport.requireValueOrChildren(quality);
            }

            protected Builder from(Quality quality) {
                super.from(quality);
                this.type = quality.type;
                this.standardSequence = quality.standardSequence;
                this.start = quality.start;
                this.end = quality.end;
                this.score = quality.score;
                this.method = quality.method;
                this.truthTP = quality.truthTP;
                this.queryTP = quality.queryTP;
                this.truthFN = quality.truthFN;
                this.queryFP = quality.queryFP;
                this.gtFP = quality.gtFP;
                this.precision = quality.precision;
                this.recall = quality.recall;
                this.fScore = quality.fScore;
                this.roc = quality.roc;
                return this;
            }
        }
    }

    public static class Variant
    extends BackboneElement {
        @Summary
        private final Integer start;
        @Summary
        private final Integer end;
        @Summary
        private final String observedAllele;
        @Summary
        private final String referenceAllele;
        @Summary
        private final String cigar;
        @Summary
        @ReferenceTarget(value={"Observation"})
        private final Reference variantPointer;

        private Variant(Builder builder) {
            super(builder);
            this.start = builder.start;
            this.end = builder.end;
            this.observedAllele = builder.observedAllele;
            this.referenceAllele = builder.referenceAllele;
            this.cigar = builder.cigar;
            this.variantPointer = builder.variantPointer;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public String getObservedAllele() {
            return this.observedAllele;
        }

        public String getReferenceAllele() {
            return this.referenceAllele;
        }

        public String getCigar() {
            return this.cigar;
        }

        public Reference getVariantPointer() {
            return this.variantPointer;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.start != null || this.end != null || this.observedAllele != null || this.referenceAllele != null || this.cigar != null || this.variantPointer != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.start, "start", visitor);
                    this.accept(this.end, "end", visitor);
                    this.accept(this.observedAllele, "observedAllele", visitor);
                    this.accept(this.referenceAllele, "referenceAllele", visitor);
                    this.accept(this.cigar, "cigar", visitor);
                    this.accept(this.variantPointer, "variantPointer", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variant other = (Variant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.observedAllele, other.observedAllele) && Objects.equals(this.referenceAllele, other.referenceAllele) && Objects.equals(this.cigar, other.cigar) && Objects.equals(this.variantPointer, other.variantPointer);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.start, this.end, this.observedAllele, this.referenceAllele, this.cigar, this.variantPointer);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer start;
            private Integer end;
            private String observedAllele;
            private String referenceAllele;
            private String cigar;
            private Reference variantPointer;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder start(java.lang.Integer start) {
                this.start = start == null ? null : Integer.of(start);
                return this;
            }

            public Builder start(Integer start) {
                this.start = start;
                return this;
            }

            public Builder end(java.lang.Integer end) {
                this.end = end == null ? null : Integer.of(end);
                return this;
            }

            public Builder end(Integer end) {
                this.end = end;
                return this;
            }

            public Builder observedAllele(java.lang.String observedAllele) {
                this.observedAllele = observedAllele == null ? null : String.of(observedAllele);
                return this;
            }

            public Builder observedAllele(String observedAllele) {
                this.observedAllele = observedAllele;
                return this;
            }

            public Builder referenceAllele(java.lang.String referenceAllele) {
                this.referenceAllele = referenceAllele == null ? null : String.of(referenceAllele);
                return this;
            }

            public Builder referenceAllele(String referenceAllele) {
                this.referenceAllele = referenceAllele;
                return this;
            }

            public Builder cigar(java.lang.String cigar) {
                this.cigar = cigar == null ? null : String.of(cigar);
                return this;
            }

            public Builder cigar(String cigar) {
                this.cigar = cigar;
                return this;
            }

            public Builder variantPointer(Reference variantPointer) {
                this.variantPointer = variantPointer;
                return this;
            }

            @Override
            public Variant build() {
                Variant variant = new Variant(this);
                if (this.validating) {
                    this.validate(variant);
                }
                return variant;
            }

            protected void validate(Variant variant) {
                super.validate(variant);
                ValidationSupport.checkReferenceType(variant.variantPointer, "variantPointer", "Observation");
                ValidationSupport.requireValueOrChildren(variant);
            }

            protected Builder from(Variant variant) {
                super.from(variant);
                this.start = variant.start;
                this.end = variant.end;
                this.observedAllele = variant.observedAllele;
                this.referenceAllele = variant.referenceAllele;
                this.cigar = variant.cigar;
                this.variantPointer = variant.variantPointer;
                return this;
            }
        }
    }

    public static class ReferenceSeq
    extends BackboneElement {
        @Summary
        @Binding(bindingName="chromosome-human", strength=BindingStrength.Value.EXAMPLE, description="Chromosome number for human.", valueSet="http://hl7.org/fhir/ValueSet/chromosome-human")
        private final CodeableConcept chromosome;
        @Summary
        private final String genomeBuild;
        @Summary
        @Binding(bindingName="orientationType", strength=BindingStrength.Value.REQUIRED, description="Type for orientation.", valueSet="http://hl7.org/fhir/ValueSet/orientation-type|4.0.1")
        private final OrientationType orientation;
        @Summary
        @Binding(bindingName="sequenceReference", strength=BindingStrength.Value.EXAMPLE, description="Reference identifier.", valueSet="http://hl7.org/fhir/ValueSet/sequence-referenceSeq")
        private final CodeableConcept referenceSeqId;
        @Summary
        @ReferenceTarget(value={"MolecularSequence"})
        private final Reference referenceSeqPointer;
        @Summary
        private final String referenceSeqString;
        @Summary
        @Binding(bindingName="strandType", strength=BindingStrength.Value.REQUIRED, description="Type for strand.", valueSet="http://hl7.org/fhir/ValueSet/strand-type|4.0.1")
        private final StrandType strand;
        @Summary
        private final Integer windowStart;
        @Summary
        private final Integer windowEnd;

        private ReferenceSeq(Builder builder) {
            super(builder);
            this.chromosome = builder.chromosome;
            this.genomeBuild = builder.genomeBuild;
            this.orientation = builder.orientation;
            this.referenceSeqId = builder.referenceSeqId;
            this.referenceSeqPointer = builder.referenceSeqPointer;
            this.referenceSeqString = builder.referenceSeqString;
            this.strand = builder.strand;
            this.windowStart = builder.windowStart;
            this.windowEnd = builder.windowEnd;
        }

        public CodeableConcept getChromosome() {
            return this.chromosome;
        }

        public String getGenomeBuild() {
            return this.genomeBuild;
        }

        public OrientationType getOrientation() {
            return this.orientation;
        }

        public CodeableConcept getReferenceSeqId() {
            return this.referenceSeqId;
        }

        public Reference getReferenceSeqPointer() {
            return this.referenceSeqPointer;
        }

        public String getReferenceSeqString() {
            return this.referenceSeqString;
        }

        public StrandType getStrand() {
            return this.strand;
        }

        public Integer getWindowStart() {
            return this.windowStart;
        }

        public Integer getWindowEnd() {
            return this.windowEnd;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.chromosome != null || this.genomeBuild != null || this.orientation != null || this.referenceSeqId != null || this.referenceSeqPointer != null || this.referenceSeqString != null || this.strand != null || this.windowStart != null || this.windowEnd != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.chromosome, "chromosome", visitor);
                    this.accept(this.genomeBuild, "genomeBuild", visitor);
                    this.accept(this.orientation, "orientation", visitor);
                    this.accept(this.referenceSeqId, "referenceSeqId", visitor);
                    this.accept(this.referenceSeqPointer, "referenceSeqPointer", visitor);
                    this.accept(this.referenceSeqString, "referenceSeqString", visitor);
                    this.accept(this.strand, "strand", visitor);
                    this.accept(this.windowStart, "windowStart", visitor);
                    this.accept(this.windowEnd, "windowEnd", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceSeq other = (ReferenceSeq)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.chromosome, other.chromosome) && Objects.equals(this.genomeBuild, other.genomeBuild) && Objects.equals(this.orientation, other.orientation) && Objects.equals(this.referenceSeqId, other.referenceSeqId) && Objects.equals(this.referenceSeqPointer, other.referenceSeqPointer) && Objects.equals(this.referenceSeqString, other.referenceSeqString) && Objects.equals(this.strand, other.strand) && Objects.equals(this.windowStart, other.windowStart) && Objects.equals(this.windowEnd, other.windowEnd);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.chromosome, this.genomeBuild, this.orientation, this.referenceSeqId, this.referenceSeqPointer, this.referenceSeqString, this.strand, this.windowStart, this.windowEnd);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept chromosome;
            private String genomeBuild;
            private OrientationType orientation;
            private CodeableConcept referenceSeqId;
            private Reference referenceSeqPointer;
            private String referenceSeqString;
            private StrandType strand;
            private Integer windowStart;
            private Integer windowEnd;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder chromosome(CodeableConcept chromosome) {
                this.chromosome = chromosome;
                return this;
            }

            public Builder genomeBuild(java.lang.String genomeBuild) {
                this.genomeBuild = genomeBuild == null ? null : String.of(genomeBuild);
                return this;
            }

            public Builder genomeBuild(String genomeBuild) {
                this.genomeBuild = genomeBuild;
                return this;
            }

            public Builder orientation(OrientationType orientation) {
                this.orientation = orientation;
                return this;
            }

            public Builder referenceSeqId(CodeableConcept referenceSeqId) {
                this.referenceSeqId = referenceSeqId;
                return this;
            }

            public Builder referenceSeqPointer(Reference referenceSeqPointer) {
                this.referenceSeqPointer = referenceSeqPointer;
                return this;
            }

            public Builder referenceSeqString(java.lang.String referenceSeqString) {
                this.referenceSeqString = referenceSeqString == null ? null : String.of(referenceSeqString);
                return this;
            }

            public Builder referenceSeqString(String referenceSeqString) {
                this.referenceSeqString = referenceSeqString;
                return this;
            }

            public Builder strand(StrandType strand) {
                this.strand = strand;
                return this;
            }

            public Builder windowStart(java.lang.Integer windowStart) {
                this.windowStart = windowStart == null ? null : Integer.of(windowStart);
                return this;
            }

            public Builder windowStart(Integer windowStart) {
                this.windowStart = windowStart;
                return this;
            }

            public Builder windowEnd(java.lang.Integer windowEnd) {
                this.windowEnd = windowEnd == null ? null : Integer.of(windowEnd);
                return this;
            }

            public Builder windowEnd(Integer windowEnd) {
                this.windowEnd = windowEnd;
                return this;
            }

            @Override
            public ReferenceSeq build() {
                ReferenceSeq referenceSeq = new ReferenceSeq(this);
                if (this.validating) {
                    this.validate(referenceSeq);
                }
                return referenceSeq;
            }

            protected void validate(ReferenceSeq referenceSeq) {
                super.validate(referenceSeq);
                ValidationSupport.checkReferenceType(referenceSeq.referenceSeqPointer, "referenceSeqPointer", "MolecularSequence");
                ValidationSupport.requireValueOrChildren(referenceSeq);
            }

            protected Builder from(ReferenceSeq referenceSeq) {
                super.from(referenceSeq);
                this.chromosome = referenceSeq.chromosome;
                this.genomeBuild = referenceSeq.genomeBuild;
                this.orientation = referenceSeq.orientation;
                this.referenceSeqId = referenceSeq.referenceSeqId;
                this.referenceSeqPointer = referenceSeq.referenceSeqPointer;
                this.referenceSeqString = referenceSeq.referenceSeqString;
                this.strand = referenceSeq.strand;
                this.windowStart = referenceSeq.windowStart;
                this.windowEnd = referenceSeq.windowEnd;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private SequenceType type;
        private Integer coordinateSystem;
        private Reference patient;
        private Reference specimen;
        private Reference device;
        private Reference performer;
        private Quantity quantity;
        private ReferenceSeq referenceSeq;
        private List<Variant> variant = new ArrayList<Variant>();
        private String observedSeq;
        private List<Quality> quality = new ArrayList<Quality>();
        private Integer readCoverage;
        private List<Repository> repository = new ArrayList<Repository>();
        private List<Reference> pointer = new ArrayList<Reference>();
        private List<StructureVariant> structureVariant = new ArrayList<StructureVariant>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(SequenceType type) {
            this.type = type;
            return this;
        }

        public Builder coordinateSystem(java.lang.Integer coordinateSystem) {
            this.coordinateSystem = coordinateSystem == null ? null : Integer.of(coordinateSystem);
            return this;
        }

        public Builder coordinateSystem(Integer coordinateSystem) {
            this.coordinateSystem = coordinateSystem;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder specimen(Reference specimen) {
            this.specimen = specimen;
            return this;
        }

        public Builder device(Reference device) {
            this.device = device;
            return this;
        }

        public Builder performer(Reference performer) {
            this.performer = performer;
            return this;
        }

        public Builder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder referenceSeq(ReferenceSeq referenceSeq) {
            this.referenceSeq = referenceSeq;
            return this;
        }

        public Builder variant(Variant ... variant) {
            for (Variant value : variant) {
                this.variant.add(value);
            }
            return this;
        }

        public Builder variant(Collection<Variant> variant) {
            this.variant = new ArrayList<Variant>(variant);
            return this;
        }

        public Builder observedSeq(java.lang.String observedSeq) {
            this.observedSeq = observedSeq == null ? null : String.of(observedSeq);
            return this;
        }

        public Builder observedSeq(String observedSeq) {
            this.observedSeq = observedSeq;
            return this;
        }

        public Builder quality(Quality ... quality) {
            for (Quality value : quality) {
                this.quality.add(value);
            }
            return this;
        }

        public Builder quality(Collection<Quality> quality) {
            this.quality = new ArrayList<Quality>(quality);
            return this;
        }

        public Builder readCoverage(java.lang.Integer readCoverage) {
            this.readCoverage = readCoverage == null ? null : Integer.of(readCoverage);
            return this;
        }

        public Builder readCoverage(Integer readCoverage) {
            this.readCoverage = readCoverage;
            return this;
        }

        public Builder repository(Repository ... repository) {
            for (Repository value : repository) {
                this.repository.add(value);
            }
            return this;
        }

        public Builder repository(Collection<Repository> repository) {
            this.repository = new ArrayList<Repository>(repository);
            return this;
        }

        public Builder pointer(Reference ... pointer) {
            for (Reference value : pointer) {
                this.pointer.add(value);
            }
            return this;
        }

        public Builder pointer(Collection<Reference> pointer) {
            this.pointer = new ArrayList<Reference>(pointer);
            return this;
        }

        public Builder structureVariant(StructureVariant ... structureVariant) {
            for (StructureVariant value : structureVariant) {
                this.structureVariant.add(value);
            }
            return this;
        }

        public Builder structureVariant(Collection<StructureVariant> structureVariant) {
            this.structureVariant = new ArrayList<StructureVariant>(structureVariant);
            return this;
        }

        @Override
        public MolecularSequence build() {
            MolecularSequence molecularSequence = new MolecularSequence(this);
            if (this.validating) {
                this.validate(molecularSequence);
            }
            return molecularSequence;
        }

        protected void validate(MolecularSequence molecularSequence) {
            super.validate(molecularSequence);
            ValidationSupport.checkList(molecularSequence.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(molecularSequence.coordinateSystem, "coordinateSystem");
            ValidationSupport.checkList(molecularSequence.variant, "variant", Variant.class);
            ValidationSupport.checkList(molecularSequence.quality, "quality", Quality.class);
            ValidationSupport.checkList(molecularSequence.repository, "repository", Repository.class);
            ValidationSupport.checkList(molecularSequence.pointer, "pointer", Reference.class);
            ValidationSupport.checkList(molecularSequence.structureVariant, "structureVariant", StructureVariant.class);
            ValidationSupport.checkReferenceType(molecularSequence.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(molecularSequence.specimen, "specimen", "Specimen");
            ValidationSupport.checkReferenceType(molecularSequence.device, "device", "Device");
            ValidationSupport.checkReferenceType(molecularSequence.performer, "performer", "Organization");
            ValidationSupport.checkReferenceType(molecularSequence.pointer, "pointer", "MolecularSequence");
        }

        protected Builder from(MolecularSequence molecularSequence) {
            super.from(molecularSequence);
            this.identifier.addAll(molecularSequence.identifier);
            this.type = molecularSequence.type;
            this.coordinateSystem = molecularSequence.coordinateSystem;
            this.patient = molecularSequence.patient;
            this.specimen = molecularSequence.specimen;
            this.device = molecularSequence.device;
            this.performer = molecularSequence.performer;
            this.quantity = molecularSequence.quantity;
            this.referenceSeq = molecularSequence.referenceSeq;
            this.variant.addAll(molecularSequence.variant);
            this.observedSeq = molecularSequence.observedSeq;
            this.quality.addAll(molecularSequence.quality);
            this.readCoverage = molecularSequence.readCoverage;
            this.repository.addAll(molecularSequence.repository);
            this.pointer.addAll(molecularSequence.pointer);
            this.structureVariant.addAll(molecularSequence.structureVariant);
            return this;
        }
    }
}

