/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FHIRAllTypes;
import com.ibm.fhir.model.type.code.OperationKind;
import com.ibm.fhir.model.type.code.OperationParameterUse;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="opd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/OperationDefinition"), @Constraint(id="opd-1", level="Rule", location="OperationDefinition.parameter", description="Either a type must be provided, or parts", expression="type.exists() or part.exists()", source="http://hl7.org/fhir/StructureDefinition/OperationDefinition"), @Constraint(id="opd-2", level="Rule", location="OperationDefinition.parameter", description="A search type can only be specified for parameters of type string", expression="searchType.exists() implies type = 'string'", source="http://hl7.org/fhir/StructureDefinition/OperationDefinition"), @Constraint(id="opd-3", level="Rule", location="OperationDefinition.parameter", description="A targetProfile can only be specified for parameters of type Reference or Canonical", expression="targetProfile.exists() implies (type = 'Reference' or type = 'canonical')", source="http://hl7.org/fhir/StructureDefinition/OperationDefinition"), @Constraint(id="operationDefinition-4", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/OperationDefinition", generated=true)})
public class OperationDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    @Binding(bindingName="OperationKind", strength=BindingStrength.Value.REQUIRED, description="Whether an operation is a normal operation or a query.", valueSet="http://hl7.org/fhir/ValueSet/operation-kind|4.0.1")
    @Required
    private final OperationKind kind;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    @Summary
    private final Boolean affectsState;
    @Summary
    @Required
    private final Code code;
    private final Markdown comment;
    @Summary
    private final Canonical base;
    @Summary
    @Binding(bindingName="ResourceType", strength=BindingStrength.Value.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
    private final List<ResourceType> resource;
    @Summary
    @Required
    private final Boolean system;
    @Summary
    @Required
    private final Boolean type;
    @Summary
    @Required
    private final Boolean instance;
    private final Canonical inputProfile;
    private final Canonical outputProfile;
    private final List<Parameter> parameter;
    private final List<Overload> overload;

    private OperationDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.kind = builder.kind;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.affectsState = builder.affectsState;
        this.code = builder.code;
        this.comment = builder.comment;
        this.base = builder.base;
        this.resource = Collections.unmodifiableList(builder.resource);
        this.system = builder.system;
        this.type = builder.type;
        this.instance = builder.instance;
        this.inputProfile = builder.inputProfile;
        this.outputProfile = builder.outputProfile;
        this.parameter = Collections.unmodifiableList(builder.parameter);
        this.overload = Collections.unmodifiableList(builder.overload);
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Boolean getAffectsState() {
        return this.affectsState;
    }

    public Code getCode() {
        return this.code;
    }

    public Markdown getComment() {
        return this.comment;
    }

    public Canonical getBase() {
        return this.base;
    }

    public List<ResourceType> getResource() {
        return this.resource;
    }

    public Boolean getSystem() {
        return this.system;
    }

    public Boolean getType() {
        return this.type;
    }

    public Boolean getInstance() {
        return this.instance;
    }

    public Canonical getInputProfile() {
        return this.inputProfile;
    }

    public Canonical getOutputProfile() {
        return this.outputProfile;
    }

    public List<Parameter> getParameter() {
        return this.parameter;
    }

    public List<Overload> getOverload() {
        return this.overload;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.title != null || this.status != null || this.kind != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.affectsState != null || this.code != null || this.comment != null || this.base != null || !this.resource.isEmpty() || this.system != null || this.type != null || this.instance != null || this.inputProfile != null || this.outputProfile != null || !this.parameter.isEmpty() || !this.overload.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.kind, "kind", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.affectsState, "affectsState", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.comment, "comment", visitor);
                this.accept(this.base, "base", visitor);
                this.accept(this.resource, "resource", visitor, ResourceType.class);
                this.accept(this.system, "system", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.instance, "instance", visitor);
                this.accept(this.inputProfile, "inputProfile", visitor);
                this.accept(this.outputProfile, "outputProfile", visitor);
                this.accept(this.parameter, "parameter", visitor, Parameter.class);
                this.accept(this.overload, "overload", visitor, Overload.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationDefinition other = (OperationDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.kind, other.kind) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.affectsState, other.affectsState) && Objects.equals(this.code, other.code) && Objects.equals(this.comment, other.comment) && Objects.equals(this.base, other.base) && Objects.equals(this.resource, other.resource) && Objects.equals(this.system, other.system) && Objects.equals(this.type, other.type) && Objects.equals(this.instance, other.instance) && Objects.equals(this.inputProfile, other.inputProfile) && Objects.equals(this.outputProfile, other.outputProfile) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.overload, other.overload);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.title, this.status, this.kind, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.affectsState, this.code, this.comment, this.base, this.resource, this.system, this.type, this.instance, this.inputProfile, this.outputProfile, this.parameter, this.overload);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Overload
    extends BackboneElement {
        private final List<String> parameterName;
        private final String comment;

        private Overload(Builder builder) {
            super(builder);
            this.parameterName = Collections.unmodifiableList(builder.parameterName);
            this.comment = builder.comment;
        }

        public List<String> getParameterName() {
            return this.parameterName;
        }

        public String getComment() {
            return this.comment;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.parameterName.isEmpty() || this.comment != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.parameterName, "parameterName", visitor, String.class);
                    this.accept(this.comment, "comment", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Overload other = (Overload)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.parameterName, other.parameterName) && Objects.equals(this.comment, other.comment);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.parameterName, this.comment);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<String> parameterName = new ArrayList<String>();
            private String comment;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder parameterName(java.lang.String ... parameterName) {
                for (java.lang.String value : parameterName) {
                    this.parameterName.add(value == null ? null : String.of(value));
                }
                return this;
            }

            public Builder parameterName(String ... parameterName) {
                for (String value : parameterName) {
                    this.parameterName.add(value);
                }
                return this;
            }

            public Builder parameterName(Collection<String> parameterName) {
                this.parameterName = new ArrayList<String>(parameterName);
                return this;
            }

            public Builder comment(java.lang.String comment) {
                this.comment = comment == null ? null : String.of(comment);
                return this;
            }

            public Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public Overload build() {
                Overload overload = new Overload(this);
                if (this.validating) {
                    this.validate(overload);
                }
                return overload;
            }

            protected void validate(Overload overload) {
                super.validate(overload);
                ValidationSupport.checkList(overload.parameterName, "parameterName", String.class);
                ValidationSupport.requireValueOrChildren(overload);
            }

            protected Builder from(Overload overload) {
                super.from(overload);
                this.parameterName.addAll(overload.parameterName);
                this.comment = overload.comment;
                return this;
            }
        }
    }

    public static class Parameter
    extends BackboneElement {
        @Required
        private final Code name;
        @com.ibm.fhir.model.annotation.Binding(bindingName="OperationParameterUse", strength=BindingStrength.Value.REQUIRED, description="Whether an operation parameter is an input or an output parameter.", valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use|4.0.1")
        @Required
        private final OperationParameterUse use;
        @Required
        private final Integer min;
        @Required
        private final String max;
        private final String documentation;
        @com.ibm.fhir.model.annotation.Binding(bindingName="FHIRAllTypes", strength=BindingStrength.Value.REQUIRED, description="A list of all the concrete types defined in this version of the FHIR specification - Abstract Types, Data Types and Resource Types.", valueSet="http://hl7.org/fhir/ValueSet/all-types|4.0.1")
        private final FHIRAllTypes type;
        private final List<Canonical> targetProfile;
        @com.ibm.fhir.model.annotation.Binding(bindingName="SearchParamType", strength=BindingStrength.Value.REQUIRED, description="Data types allowed to be used for search parameters.", valueSet="http://hl7.org/fhir/ValueSet/search-param-type|4.0.1")
        private final SearchParamType searchType;
        private final Binding binding;
        private final List<ReferencedFrom> referencedFrom;
        private final List<Parameter> part;

        private Parameter(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.use = builder.use;
            this.min = builder.min;
            this.max = builder.max;
            this.documentation = builder.documentation;
            this.type = builder.type;
            this.targetProfile = Collections.unmodifiableList(builder.targetProfile);
            this.searchType = builder.searchType;
            this.binding = builder.binding;
            this.referencedFrom = Collections.unmodifiableList(builder.referencedFrom);
            this.part = Collections.unmodifiableList(builder.part);
        }

        public Code getName() {
            return this.name;
        }

        public OperationParameterUse getUse() {
            return this.use;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public FHIRAllTypes getType() {
            return this.type;
        }

        public List<Canonical> getTargetProfile() {
            return this.targetProfile;
        }

        public SearchParamType getSearchType() {
            return this.searchType;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public List<ReferencedFrom> getReferencedFrom() {
            return this.referencedFrom;
        }

        public List<Parameter> getPart() {
            return this.part;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.use != null || this.min != null || this.max != null || this.documentation != null || this.type != null || !this.targetProfile.isEmpty() || this.searchType != null || this.binding != null || !this.referencedFrom.isEmpty() || !this.part.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.use, "use", visitor);
                    this.accept(this.min, "min", visitor);
                    this.accept(this.max, "max", visitor);
                    this.accept(this.documentation, "documentation", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.targetProfile, "targetProfile", visitor, Canonical.class);
                    this.accept(this.searchType, "searchType", visitor);
                    this.accept(this.binding, "binding", visitor);
                    this.accept(this.referencedFrom, "referencedFrom", visitor, ReferencedFrom.class);
                    this.accept(this.part, "part", visitor, Parameter.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.use, other.use) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max) && Objects.equals(this.documentation, other.documentation) && Objects.equals(this.type, other.type) && Objects.equals(this.targetProfile, other.targetProfile) && Objects.equals(this.searchType, other.searchType) && Objects.equals(this.binding, other.binding) && Objects.equals(this.referencedFrom, other.referencedFrom) && Objects.equals(this.part, other.part);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.use, this.min, this.max, this.documentation, this.type, this.targetProfile, this.searchType, this.binding, this.referencedFrom, this.part);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class ReferencedFrom
        extends BackboneElement {
            @Required
            private final String source;
            private final String sourceId;

            private ReferencedFrom(Builder builder) {
                super(builder);
                this.source = builder.source;
                this.sourceId = builder.sourceId;
            }

            public String getSource() {
                return this.source;
            }

            public String getSourceId() {
                return this.sourceId;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.source != null || this.sourceId != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.source, "source", visitor);
                        this.accept(this.sourceId, "sourceId", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ReferencedFrom other = (ReferencedFrom)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceId, other.sourceId);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.source, this.sourceId);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String source;
                private String sourceId;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder source(java.lang.String source) {
                    this.source = source == null ? null : String.of(source);
                    return this;
                }

                public Builder source(String source) {
                    this.source = source;
                    return this;
                }

                public Builder sourceId(java.lang.String sourceId) {
                    this.sourceId = sourceId == null ? null : String.of(sourceId);
                    return this;
                }

                public Builder sourceId(String sourceId) {
                    this.sourceId = sourceId;
                    return this;
                }

                @Override
                public ReferencedFrom build() {
                    ReferencedFrom referencedFrom = new ReferencedFrom(this);
                    if (this.validating) {
                        this.validate(referencedFrom);
                    }
                    return referencedFrom;
                }

                protected void validate(ReferencedFrom referencedFrom) {
                    super.validate(referencedFrom);
                    ValidationSupport.requireNonNull(referencedFrom.source, "source");
                    ValidationSupport.requireValueOrChildren(referencedFrom);
                }

                protected Builder from(ReferencedFrom referencedFrom) {
                    super.from(referencedFrom);
                    this.source = referencedFrom.source;
                    this.sourceId = referencedFrom.sourceId;
                    return this;
                }
            }
        }

        public static class Binding
        extends BackboneElement {
            @com.ibm.fhir.model.annotation.Binding(bindingName="BindingStrength", strength=BindingStrength.Value.REQUIRED, description="Indication of the degree of conformance expectations associated with a binding.", valueSet="http://hl7.org/fhir/ValueSet/binding-strength|4.0.1")
            @Required
            private final BindingStrength strength;
            @Required
            private final Canonical valueSet;

            private Binding(Builder builder) {
                super(builder);
                this.strength = builder.strength;
                this.valueSet = builder.valueSet;
            }

            public BindingStrength getStrength() {
                return this.strength;
            }

            public Canonical getValueSet() {
                return this.valueSet;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.strength != null || this.valueSet != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.strength, "strength", visitor);
                        this.accept(this.valueSet, "valueSet", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Binding other = (Binding)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.strength, other.strength) && Objects.equals(this.valueSet, other.valueSet);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.strength, this.valueSet);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private BindingStrength strength;
                private Canonical valueSet;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder strength(BindingStrength strength) {
                    this.strength = strength;
                    return this;
                }

                public Builder valueSet(Canonical valueSet) {
                    this.valueSet = valueSet;
                    return this;
                }

                @Override
                public Binding build() {
                    Binding binding = new Binding(this);
                    if (this.validating) {
                        this.validate(binding);
                    }
                    return binding;
                }

                protected void validate(Binding binding) {
                    super.validate(binding);
                    ValidationSupport.requireNonNull(binding.strength, "strength");
                    ValidationSupport.requireNonNull(binding.valueSet, "valueSet");
                    ValidationSupport.requireValueOrChildren(binding);
                }

                protected Builder from(Binding binding) {
                    super.from(binding);
                    this.strength = binding.strength;
                    this.valueSet = binding.valueSet;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Code name;
            private OperationParameterUse use;
            private Integer min;
            private String max;
            private String documentation;
            private FHIRAllTypes type;
            private List<Canonical> targetProfile = new ArrayList<Canonical>();
            private SearchParamType searchType;
            private Binding binding;
            private List<ReferencedFrom> referencedFrom = new ArrayList<ReferencedFrom>();
            private List<Parameter> part = new ArrayList<Parameter>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(Code name) {
                this.name = name;
                return this;
            }

            public Builder use(OperationParameterUse use) {
                this.use = use;
                return this;
            }

            public Builder min(java.lang.Integer min) {
                this.min = min == null ? null : Integer.of(min);
                return this;
            }

            public Builder min(Integer min) {
                this.min = min;
                return this;
            }

            public Builder max(java.lang.String max) {
                this.max = max == null ? null : String.of(max);
                return this;
            }

            public Builder max(String max) {
                this.max = max;
                return this;
            }

            public Builder documentation(java.lang.String documentation) {
                this.documentation = documentation == null ? null : String.of(documentation);
                return this;
            }

            public Builder documentation(String documentation) {
                this.documentation = documentation;
                return this;
            }

            public Builder type(FHIRAllTypes type) {
                this.type = type;
                return this;
            }

            public Builder targetProfile(Canonical ... targetProfile) {
                for (Canonical value : targetProfile) {
                    this.targetProfile.add(value);
                }
                return this;
            }

            public Builder targetProfile(Collection<Canonical> targetProfile) {
                this.targetProfile = new ArrayList<Canonical>(targetProfile);
                return this;
            }

            public Builder searchType(SearchParamType searchType) {
                this.searchType = searchType;
                return this;
            }

            public Builder binding(Binding binding) {
                this.binding = binding;
                return this;
            }

            public Builder referencedFrom(ReferencedFrom ... referencedFrom) {
                for (ReferencedFrom value : referencedFrom) {
                    this.referencedFrom.add(value);
                }
                return this;
            }

            public Builder referencedFrom(Collection<ReferencedFrom> referencedFrom) {
                this.referencedFrom = new ArrayList<ReferencedFrom>(referencedFrom);
                return this;
            }

            public Builder part(Parameter ... part) {
                for (Parameter value : part) {
                    this.part.add(value);
                }
                return this;
            }

            public Builder part(Collection<Parameter> part) {
                this.part = new ArrayList<Parameter>(part);
                return this;
            }

            @Override
            public Parameter build() {
                Parameter parameter = new Parameter(this);
                if (this.validating) {
                    this.validate(parameter);
                }
                return parameter;
            }

            protected void validate(Parameter parameter) {
                super.validate(parameter);
                ValidationSupport.requireNonNull(parameter.name, "name");
                ValidationSupport.requireNonNull(parameter.use, "use");
                ValidationSupport.requireNonNull(parameter.min, "min");
                ValidationSupport.requireNonNull(parameter.max, "max");
                ValidationSupport.checkList(parameter.targetProfile, "targetProfile", Canonical.class);
                ValidationSupport.checkList(parameter.referencedFrom, "referencedFrom", ReferencedFrom.class);
                ValidationSupport.checkList(parameter.part, "part", Parameter.class);
                ValidationSupport.requireValueOrChildren(parameter);
            }

            protected Builder from(Parameter parameter) {
                super.from(parameter);
                this.name = parameter.name;
                this.use = parameter.use;
                this.min = parameter.min;
                this.max = parameter.max;
                this.documentation = parameter.documentation;
                this.type = parameter.type;
                this.targetProfile.addAll(parameter.targetProfile);
                this.searchType = parameter.searchType;
                this.binding = parameter.binding;
                this.referencedFrom.addAll(parameter.referencedFrom);
                this.part.addAll(parameter.part);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private OperationKind kind;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Boolean affectsState;
        private Code code;
        private Markdown comment;
        private Canonical base;
        private List<ResourceType> resource = new ArrayList<ResourceType>();
        private Boolean system;
        private Boolean type;
        private Boolean instance;
        private Canonical inputProfile;
        private Canonical outputProfile;
        private List<Parameter> parameter = new ArrayList<Parameter>();
        private List<Overload> overload = new ArrayList<Overload>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder kind(OperationKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder affectsState(java.lang.Boolean affectsState) {
            this.affectsState = affectsState == null ? null : Boolean.of(affectsState);
            return this;
        }

        public Builder affectsState(Boolean affectsState) {
            this.affectsState = affectsState;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        public Builder comment(Markdown comment) {
            this.comment = comment;
            return this;
        }

        public Builder base(Canonical base) {
            this.base = base;
            return this;
        }

        public Builder resource(ResourceType ... resource) {
            for (ResourceType value : resource) {
                this.resource.add(value);
            }
            return this;
        }

        public Builder resource(Collection<ResourceType> resource) {
            this.resource = new ArrayList<ResourceType>(resource);
            return this;
        }

        public Builder system(java.lang.Boolean system) {
            this.system = system == null ? null : Boolean.of(system);
            return this;
        }

        public Builder system(Boolean system) {
            this.system = system;
            return this;
        }

        public Builder type(java.lang.Boolean type) {
            this.type = type == null ? null : Boolean.of(type);
            return this;
        }

        public Builder type(Boolean type) {
            this.type = type;
            return this;
        }

        public Builder instance(java.lang.Boolean instance) {
            this.instance = instance == null ? null : Boolean.of(instance);
            return this;
        }

        public Builder instance(Boolean instance) {
            this.instance = instance;
            return this;
        }

        public Builder inputProfile(Canonical inputProfile) {
            this.inputProfile = inputProfile;
            return this;
        }

        public Builder outputProfile(Canonical outputProfile) {
            this.outputProfile = outputProfile;
            return this;
        }

        public Builder parameter(Parameter ... parameter) {
            for (Parameter value : parameter) {
                this.parameter.add(value);
            }
            return this;
        }

        public Builder parameter(Collection<Parameter> parameter) {
            this.parameter = new ArrayList<Parameter>(parameter);
            return this;
        }

        public Builder overload(Overload ... overload) {
            for (Overload value : overload) {
                this.overload.add(value);
            }
            return this;
        }

        public Builder overload(Collection<Overload> overload) {
            this.overload = new ArrayList<Overload>(overload);
            return this;
        }

        @Override
        public OperationDefinition build() {
            OperationDefinition operationDefinition = new OperationDefinition(this);
            if (this.validating) {
                this.validate(operationDefinition);
            }
            return operationDefinition;
        }

        protected void validate(OperationDefinition operationDefinition) {
            super.validate(operationDefinition);
            ValidationSupport.requireNonNull(operationDefinition.name, "name");
            ValidationSupport.requireNonNull(operationDefinition.status, "status");
            ValidationSupport.requireNonNull(operationDefinition.kind, "kind");
            ValidationSupport.checkList(operationDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(operationDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(operationDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.requireNonNull(operationDefinition.code, "code");
            ValidationSupport.checkList(operationDefinition.resource, "resource", ResourceType.class);
            ValidationSupport.requireNonNull(operationDefinition.system, "system");
            ValidationSupport.requireNonNull(operationDefinition.type, "type");
            ValidationSupport.requireNonNull(operationDefinition.instance, "instance");
            ValidationSupport.checkList(operationDefinition.parameter, "parameter", Parameter.class);
            ValidationSupport.checkList(operationDefinition.overload, "overload", Overload.class);
        }

        protected Builder from(OperationDefinition operationDefinition) {
            super.from(operationDefinition);
            this.url = operationDefinition.url;
            this.version = operationDefinition.version;
            this.name = operationDefinition.name;
            this.title = operationDefinition.title;
            this.status = operationDefinition.status;
            this.kind = operationDefinition.kind;
            this.experimental = operationDefinition.experimental;
            this.date = operationDefinition.date;
            this.publisher = operationDefinition.publisher;
            this.contact.addAll(operationDefinition.contact);
            this.description = operationDefinition.description;
            this.useContext.addAll(operationDefinition.useContext);
            this.jurisdiction.addAll(operationDefinition.jurisdiction);
            this.purpose = operationDefinition.purpose;
            this.affectsState = operationDefinition.affectsState;
            this.code = operationDefinition.code;
            this.comment = operationDefinition.comment;
            this.base = operationDefinition.base;
            this.resource.addAll(operationDefinition.resource);
            this.system = operationDefinition.system;
            this.type = operationDefinition.type;
            this.instance = operationDefinition.instance;
            this.inputProfile = operationDefinition.inputProfile;
            this.outputProfile = operationDefinition.outputProfile;
            this.parameter.addAll(operationDefinition.parameter);
            this.overload.addAll(operationDefinition.overload);
            return this;
        }
    }
}

