/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="organizationAffiliation-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/OrganizationAffiliation", generated=true)
public class OrganizationAffiliation
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference organization;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference participatingOrganization;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> network;
    @Summary
    @Binding(bindingName="OrganizationAffiliation", strength=BindingStrength.Value.EXAMPLE, description="The role the participating organization providing services to the primary organization.", valueSet="http://hl7.org/fhir/ValueSet/organization-role")
    private final List<CodeableConcept> code;
    @Summary
    @Binding(bindingName="OrganizationSpecialty", strength=BindingStrength.Value.PREFERRED, description="Specific specialty associated with the participating organization.", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> location;
    @ReferenceTarget(value={"HealthcareService"})
    private final List<Reference> healthcareService;
    @Summary
    private final List<ContactPoint> telecom;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;

    private OrganizationAffiliation(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.period = builder.period;
        this.organization = builder.organization;
        this.participatingOrganization = builder.participatingOrganization;
        this.network = Collections.unmodifiableList(builder.network);
        this.code = Collections.unmodifiableList(builder.code);
        this.specialty = Collections.unmodifiableList(builder.specialty);
        this.location = Collections.unmodifiableList(builder.location);
        this.healthcareService = Collections.unmodifiableList(builder.healthcareService);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.endpoint = Collections.unmodifiableList(builder.endpoint);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public Reference getParticipatingOrganization() {
        return this.participatingOrganization;
    }

    public List<Reference> getNetwork() {
        return this.network;
    }

    public List<CodeableConcept> getCode() {
        return this.code;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public List<Reference> getLocation() {
        return this.location;
    }

    public List<Reference> getHealthcareService() {
        return this.healthcareService;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || this.period != null || this.organization != null || this.participatingOrganization != null || !this.network.isEmpty() || !this.code.isEmpty() || !this.specialty.isEmpty() || !this.location.isEmpty() || !this.healthcareService.isEmpty() || !this.telecom.isEmpty() || !this.endpoint.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.organization, "organization", visitor);
                this.accept(this.participatingOrganization, "participatingOrganization", visitor);
                this.accept(this.network, "network", visitor, Reference.class);
                this.accept(this.code, "code", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.location, "location", visitor, Reference.class);
                this.accept(this.healthcareService, "healthcareService", visitor, Reference.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrganizationAffiliation other = (OrganizationAffiliation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.period, other.period) && Objects.equals(this.organization, other.organization) && Objects.equals(this.participatingOrganization, other.participatingOrganization) && Objects.equals(this.network, other.network) && Objects.equals(this.code, other.code) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.location, other.location) && Objects.equals(this.healthcareService, other.healthcareService) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.endpoint, other.endpoint);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.period, this.organization, this.participatingOrganization, this.network, this.code, this.specialty, this.location, this.healthcareService, this.telecom, this.endpoint);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private Period period;
        private Reference organization;
        private Reference participatingOrganization;
        private List<Reference> network = new ArrayList<Reference>();
        private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private List<Reference> location = new ArrayList<Reference>();
        private List<Reference> healthcareService = new ArrayList<Reference>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<Reference> endpoint = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(java.lang.Boolean active) {
            this.active = active == null ? null : Boolean.of(active);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder organization(Reference organization) {
            this.organization = organization;
            return this;
        }

        public Builder participatingOrganization(Reference participatingOrganization) {
            this.participatingOrganization = participatingOrganization;
            return this;
        }

        public Builder network(Reference ... network) {
            for (Reference value : network) {
                this.network.add(value);
            }
            return this;
        }

        public Builder network(Collection<Reference> network) {
            this.network = new ArrayList<Reference>(network);
            return this;
        }

        public Builder code(CodeableConcept ... code) {
            for (CodeableConcept value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<CodeableConcept> code) {
            this.code = new ArrayList<CodeableConcept>(code);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder location(Reference ... location) {
            for (Reference value : location) {
                this.location.add(value);
            }
            return this;
        }

        public Builder location(Collection<Reference> location) {
            this.location = new ArrayList<Reference>(location);
            return this;
        }

        public Builder healthcareService(Reference ... healthcareService) {
            for (Reference value : healthcareService) {
                this.healthcareService.add(value);
            }
            return this;
        }

        public Builder healthcareService(Collection<Reference> healthcareService) {
            this.healthcareService = new ArrayList<Reference>(healthcareService);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        @Override
        public OrganizationAffiliation build() {
            OrganizationAffiliation organizationAffiliation = new OrganizationAffiliation(this);
            if (this.validating) {
                this.validate(organizationAffiliation);
            }
            return organizationAffiliation;
        }

        protected void validate(OrganizationAffiliation organizationAffiliation) {
            super.validate(organizationAffiliation);
            ValidationSupport.checkList(organizationAffiliation.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(organizationAffiliation.network, "network", Reference.class);
            ValidationSupport.checkList(organizationAffiliation.code, "code", CodeableConcept.class);
            ValidationSupport.checkList(organizationAffiliation.specialty, "specialty", CodeableConcept.class);
            ValidationSupport.checkList(organizationAffiliation.location, "location", Reference.class);
            ValidationSupport.checkList(organizationAffiliation.healthcareService, "healthcareService", Reference.class);
            ValidationSupport.checkList(organizationAffiliation.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(organizationAffiliation.endpoint, "endpoint", Reference.class);
            ValidationSupport.checkReferenceType(organizationAffiliation.organization, "organization", "Organization");
            ValidationSupport.checkReferenceType(organizationAffiliation.participatingOrganization, "participatingOrganization", "Organization");
            ValidationSupport.checkReferenceType(organizationAffiliation.network, "network", "Organization");
            ValidationSupport.checkReferenceType(organizationAffiliation.location, "location", "Location");
            ValidationSupport.checkReferenceType(organizationAffiliation.healthcareService, "healthcareService", "HealthcareService");
            ValidationSupport.checkReferenceType(organizationAffiliation.endpoint, "endpoint", "Endpoint");
        }

        protected Builder from(OrganizationAffiliation organizationAffiliation) {
            super.from(organizationAffiliation);
            this.identifier.addAll(organizationAffiliation.identifier);
            this.active = organizationAffiliation.active;
            this.period = organizationAffiliation.period;
            this.organization = organizationAffiliation.organization;
            this.participatingOrganization = organizationAffiliation.participatingOrganization;
            this.network.addAll(organizationAffiliation.network);
            this.code.addAll(organizationAffiliation.code);
            this.specialty.addAll(organizationAffiliation.specialty);
            this.location.addAll(organizationAffiliation.location);
            this.healthcareService.addAll(organizationAffiliation.healthcareService);
            this.telecom.addAll(organizationAffiliation.telecom);
            this.endpoint.addAll(organizationAffiliation.endpoint);
            return this;
        }
    }
}

