/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ResearchStudyStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="researchStudy-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/research-study-prim-purp-type", expression="primaryPurposeType.exists() implies (primaryPurposeType.memberOf('http://hl7.org/fhir/ValueSet/research-study-prim-purp-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/ResearchStudy", generated=true), @Constraint(id="researchStudy-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="location.exists() implies (location.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ResearchStudy", generated=true), @Constraint(id="researchStudy-2", level="Warning", location="objective.type", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/research-study-objective-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/research-study-objective-type', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/ResearchStudy", generated=true)})
public class ResearchStudy
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String title;
    @Summary
    @ReferenceTarget(value={"PlanDefinition"})
    private final List<Reference> protocol;
    @Summary
    @ReferenceTarget(value={"ResearchStudy"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="ResearchStudyStatus", strength=BindingStrength.Value.REQUIRED, description="Codes that convey the current status of the research study.", valueSet="http://hl7.org/fhir/ValueSet/research-study-status|4.0.1")
    @Required
    private final ResearchStudyStatus status;
    @Summary
    @Binding(bindingName="ResearchStudyPrimaryPurposeType", strength=BindingStrength.Value.EXTENSIBLE, description="Codes for the main intent of the study.", valueSet="http://hl7.org/fhir/ValueSet/research-study-prim-purp-type")
    private final CodeableConcept primaryPurposeType;
    @Summary
    @Binding(bindingName="ResearchStudyPhase", strength=BindingStrength.Value.EXAMPLE, description="Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation.", valueSet="http://hl7.org/fhir/ValueSet/research-study-phase")
    private final CodeableConcept phase;
    @Summary
    @Binding(bindingName="ResearchStudyCategory", strength=BindingStrength.Value.EXAMPLE, description="Codes that describe the type of research study.  E.g. Study phase, Interventional/Observational, blinding type, etc.")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="ResearchStudyFocus", strength=BindingStrength.Value.EXAMPLE, description="Codes for medications, devices and other interventions.")
    private final List<CodeableConcept> focus;
    @Summary
    @Binding(bindingName="ConditionCode", strength=BindingStrength.Value.EXAMPLE, description="Identification of the condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final List<CodeableConcept> condition;
    @Summary
    private final List<ContactDetail> contact;
    private final List<RelatedArtifact> relatedArtifact;
    @Summary
    @Binding(bindingName="ResearchStudyKeyword", strength=BindingStrength.Value.EXAMPLE, description="Words associated with the study that may be useful in discovery.")
    private final List<CodeableConcept> keyword;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> location;
    private final Markdown description;
    @Summary
    @ReferenceTarget(value={"Group"})
    private final List<Reference> enrollment;
    @Summary
    private final Period period;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference sponsor;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference principalInvestigator;
    @Summary
    @ReferenceTarget(value={"Location"})
    private final List<Reference> site;
    @Summary
    @Binding(bindingName="ResearchStudyReasonStopped", strength=BindingStrength.Value.EXAMPLE, description="Codes for why the study ended prematurely.", valueSet="http://hl7.org/fhir/ValueSet/research-study-reason-stopped")
    private final CodeableConcept reasonStopped;
    private final List<Annotation> note;
    private final List<Arm> arm;
    private final List<Objective> objective;

    private ResearchStudy(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.title = builder.title;
        this.protocol = Collections.unmodifiableList(builder.protocol);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.status = builder.status;
        this.primaryPurposeType = builder.primaryPurposeType;
        this.phase = builder.phase;
        this.category = Collections.unmodifiableList(builder.category);
        this.focus = Collections.unmodifiableList(builder.focus);
        this.condition = Collections.unmodifiableList(builder.condition);
        this.contact = Collections.unmodifiableList(builder.contact);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.keyword = Collections.unmodifiableList(builder.keyword);
        this.location = Collections.unmodifiableList(builder.location);
        this.description = builder.description;
        this.enrollment = Collections.unmodifiableList(builder.enrollment);
        this.period = builder.period;
        this.sponsor = builder.sponsor;
        this.principalInvestigator = builder.principalInvestigator;
        this.site = Collections.unmodifiableList(builder.site);
        this.reasonStopped = builder.reasonStopped;
        this.note = Collections.unmodifiableList(builder.note);
        this.arm = Collections.unmodifiableList(builder.arm);
        this.objective = Collections.unmodifiableList(builder.objective);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Reference> getProtocol() {
        return this.protocol;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public ResearchStudyStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getPrimaryPurposeType() {
        return this.primaryPurposeType;
    }

    public CodeableConcept getPhase() {
        return this.phase;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public List<CodeableConcept> getFocus() {
        return this.focus;
    }

    public List<CodeableConcept> getCondition() {
        return this.condition;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<CodeableConcept> getKeyword() {
        return this.keyword;
    }

    public List<CodeableConcept> getLocation() {
        return this.location;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<Reference> getEnrollment() {
        return this.enrollment;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Reference getSponsor() {
        return this.sponsor;
    }

    public Reference getPrincipalInvestigator() {
        return this.principalInvestigator;
    }

    public List<Reference> getSite() {
        return this.site;
    }

    public CodeableConcept getReasonStopped() {
        return this.reasonStopped;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Arm> getArm() {
        return this.arm;
    }

    public List<Objective> getObjective() {
        return this.objective;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.title != null || !this.protocol.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.primaryPurposeType != null || this.phase != null || !this.category.isEmpty() || !this.focus.isEmpty() || !this.condition.isEmpty() || !this.contact.isEmpty() || !this.relatedArtifact.isEmpty() || !this.keyword.isEmpty() || !this.location.isEmpty() || this.description != null || !this.enrollment.isEmpty() || this.period != null || this.sponsor != null || this.principalInvestigator != null || !this.site.isEmpty() || this.reasonStopped != null || !this.note.isEmpty() || !this.arm.isEmpty() || !this.objective.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.title, "title", visitor);
                this.accept(this.protocol, "protocol", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.primaryPurposeType, "primaryPurposeType", visitor);
                this.accept(this.phase, "phase", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.focus, "focus", visitor, CodeableConcept.class);
                this.accept(this.condition, "condition", visitor, CodeableConcept.class);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.keyword, "keyword", visitor, CodeableConcept.class);
                this.accept(this.location, "location", visitor, CodeableConcept.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.enrollment, "enrollment", visitor, Reference.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.sponsor, "sponsor", visitor);
                this.accept(this.principalInvestigator, "principalInvestigator", visitor);
                this.accept(this.site, "site", visitor, Reference.class);
                this.accept(this.reasonStopped, "reasonStopped", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.arm, "arm", visitor, Arm.class);
                this.accept(this.objective, "objective", visitor, Objective.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchStudy other = (ResearchStudy)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.title, other.title) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.primaryPurposeType, other.primaryPurposeType) && Objects.equals(this.phase, other.phase) && Objects.equals(this.category, other.category) && Objects.equals(this.focus, other.focus) && Objects.equals(this.condition, other.condition) && Objects.equals(this.contact, other.contact) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.keyword, other.keyword) && Objects.equals(this.location, other.location) && Objects.equals(this.description, other.description) && Objects.equals(this.enrollment, other.enrollment) && Objects.equals(this.period, other.period) && Objects.equals(this.sponsor, other.sponsor) && Objects.equals(this.principalInvestigator, other.principalInvestigator) && Objects.equals(this.site, other.site) && Objects.equals(this.reasonStopped, other.reasonStopped) && Objects.equals(this.note, other.note) && Objects.equals(this.arm, other.arm) && Objects.equals(this.objective, other.objective);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.title, this.protocol, this.partOf, this.status, this.primaryPurposeType, this.phase, this.category, this.focus, this.condition, this.contact, this.relatedArtifact, this.keyword, this.location, this.description, this.enrollment, this.period, this.sponsor, this.principalInvestigator, this.site, this.reasonStopped, this.note, this.arm, this.objective);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Objective
    extends BackboneElement {
        private final String name;
        @Binding(bindingName="ResearchStudyObjectiveType", strength=BindingStrength.Value.PREFERRED, description="Codes for the kind of study objective.", valueSet="http://hl7.org/fhir/ValueSet/research-study-objective-type")
        private final CodeableConcept type;

        private Objective(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.type = builder.type;
        }

        public String getName() {
            return this.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Objective other = (Objective)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private CodeableConcept type;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            @Override
            public Objective build() {
                Objective objective = new Objective(this);
                if (this.validating) {
                    this.validate(objective);
                }
                return objective;
            }

            protected void validate(Objective objective) {
                super.validate(objective);
                ValidationSupport.requireValueOrChildren(objective);
            }

            protected Builder from(Objective objective) {
                super.from(objective);
                this.name = objective.name;
                this.type = objective.type;
                return this;
            }
        }
    }

    public static class Arm
    extends BackboneElement {
        @Required
        private final String name;
        private final CodeableConcept type;
        private final String description;

        private Arm(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.type = builder.type;
            this.description = builder.description;
        }

        public String getName() {
            return this.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null || this.description != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.description, "description", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Arm other = (Arm)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.description, other.description);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type, this.description);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private CodeableConcept type;
            private String description;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            @Override
            public Arm build() {
                Arm arm = new Arm(this);
                if (this.validating) {
                    this.validate(arm);
                }
                return arm;
            }

            protected void validate(Arm arm) {
                super.validate(arm);
                ValidationSupport.requireNonNull(arm.name, "name");
                ValidationSupport.requireValueOrChildren(arm);
            }

            protected Builder from(Arm arm) {
                super.from(arm);
                this.name = arm.name;
                this.type = arm.type;
                this.description = arm.description;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String title;
        private List<Reference> protocol = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private ResearchStudyStatus status;
        private CodeableConcept primaryPurposeType;
        private CodeableConcept phase;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> focus = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> condition = new ArrayList<CodeableConcept>();
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<CodeableConcept> keyword = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> location = new ArrayList<CodeableConcept>();
        private Markdown description;
        private List<Reference> enrollment = new ArrayList<Reference>();
        private Period period;
        private Reference sponsor;
        private Reference principalInvestigator;
        private List<Reference> site = new ArrayList<Reference>();
        private CodeableConcept reasonStopped;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Arm> arm = new ArrayList<Arm>();
        private List<Objective> objective = new ArrayList<Objective>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder protocol(Reference ... protocol) {
            for (Reference value : protocol) {
                this.protocol.add(value);
            }
            return this;
        }

        public Builder protocol(Collection<Reference> protocol) {
            this.protocol = new ArrayList<Reference>(protocol);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(ResearchStudyStatus status) {
            this.status = status;
            return this;
        }

        public Builder primaryPurposeType(CodeableConcept primaryPurposeType) {
            this.primaryPurposeType = primaryPurposeType;
            return this;
        }

        public Builder phase(CodeableConcept phase) {
            this.phase = phase;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder focus(CodeableConcept ... focus) {
            for (CodeableConcept value : focus) {
                this.focus.add(value);
            }
            return this;
        }

        public Builder focus(Collection<CodeableConcept> focus) {
            this.focus = new ArrayList<CodeableConcept>(focus);
            return this;
        }

        public Builder condition(CodeableConcept ... condition) {
            for (CodeableConcept value : condition) {
                this.condition.add(value);
            }
            return this;
        }

        public Builder condition(Collection<CodeableConcept> condition) {
            this.condition = new ArrayList<CodeableConcept>(condition);
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder keyword(CodeableConcept ... keyword) {
            for (CodeableConcept value : keyword) {
                this.keyword.add(value);
            }
            return this;
        }

        public Builder keyword(Collection<CodeableConcept> keyword) {
            this.keyword = new ArrayList<CodeableConcept>(keyword);
            return this;
        }

        public Builder location(CodeableConcept ... location) {
            for (CodeableConcept value : location) {
                this.location.add(value);
            }
            return this;
        }

        public Builder location(Collection<CodeableConcept> location) {
            this.location = new ArrayList<CodeableConcept>(location);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder enrollment(Reference ... enrollment) {
            for (Reference value : enrollment) {
                this.enrollment.add(value);
            }
            return this;
        }

        public Builder enrollment(Collection<Reference> enrollment) {
            this.enrollment = new ArrayList<Reference>(enrollment);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder sponsor(Reference sponsor) {
            this.sponsor = sponsor;
            return this;
        }

        public Builder principalInvestigator(Reference principalInvestigator) {
            this.principalInvestigator = principalInvestigator;
            return this;
        }

        public Builder site(Reference ... site) {
            for (Reference value : site) {
                this.site.add(value);
            }
            return this;
        }

        public Builder site(Collection<Reference> site) {
            this.site = new ArrayList<Reference>(site);
            return this;
        }

        public Builder reasonStopped(CodeableConcept reasonStopped) {
            this.reasonStopped = reasonStopped;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder arm(Arm ... arm) {
            for (Arm value : arm) {
                this.arm.add(value);
            }
            return this;
        }

        public Builder arm(Collection<Arm> arm) {
            this.arm = new ArrayList<Arm>(arm);
            return this;
        }

        public Builder objective(Objective ... objective) {
            for (Objective value : objective) {
                this.objective.add(value);
            }
            return this;
        }

        public Builder objective(Collection<Objective> objective) {
            this.objective = new ArrayList<Objective>(objective);
            return this;
        }

        @Override
        public ResearchStudy build() {
            ResearchStudy researchStudy = new ResearchStudy(this);
            if (this.validating) {
                this.validate(researchStudy);
            }
            return researchStudy;
        }

        protected void validate(ResearchStudy researchStudy) {
            super.validate(researchStudy);
            ValidationSupport.checkList(researchStudy.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(researchStudy.protocol, "protocol", Reference.class);
            ValidationSupport.checkList(researchStudy.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(researchStudy.status, "status");
            ValidationSupport.checkList(researchStudy.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(researchStudy.focus, "focus", CodeableConcept.class);
            ValidationSupport.checkList(researchStudy.condition, "condition", CodeableConcept.class);
            ValidationSupport.checkList(researchStudy.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(researchStudy.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(researchStudy.keyword, "keyword", CodeableConcept.class);
            ValidationSupport.checkList(researchStudy.location, "location", CodeableConcept.class);
            ValidationSupport.checkList(researchStudy.enrollment, "enrollment", Reference.class);
            ValidationSupport.checkList(researchStudy.site, "site", Reference.class);
            ValidationSupport.checkList(researchStudy.note, "note", Annotation.class);
            ValidationSupport.checkList(researchStudy.arm, "arm", Arm.class);
            ValidationSupport.checkList(researchStudy.objective, "objective", Objective.class);
            ValidationSupport.checkReferenceType(researchStudy.protocol, "protocol", "PlanDefinition");
            ValidationSupport.checkReferenceType(researchStudy.partOf, "partOf", "ResearchStudy");
            ValidationSupport.checkReferenceType(researchStudy.enrollment, "enrollment", "Group");
            ValidationSupport.checkReferenceType(researchStudy.sponsor, "sponsor", "Organization");
            ValidationSupport.checkReferenceType(researchStudy.principalInvestigator, "principalInvestigator", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(researchStudy.site, "site", "Location");
        }

        protected Builder from(ResearchStudy researchStudy) {
            super.from(researchStudy);
            this.identifier.addAll(researchStudy.identifier);
            this.title = researchStudy.title;
            this.protocol.addAll(researchStudy.protocol);
            this.partOf.addAll(researchStudy.partOf);
            this.status = researchStudy.status;
            this.primaryPurposeType = researchStudy.primaryPurposeType;
            this.phase = researchStudy.phase;
            this.category.addAll(researchStudy.category);
            this.focus.addAll(researchStudy.focus);
            this.condition.addAll(researchStudy.condition);
            this.contact.addAll(researchStudy.contact);
            this.relatedArtifact.addAll(researchStudy.relatedArtifact);
            this.keyword.addAll(researchStudy.keyword);
            this.location.addAll(researchStudy.location);
            this.description = researchStudy.description;
            this.enrollment.addAll(researchStudy.enrollment);
            this.period = researchStudy.period;
            this.sponsor = researchStudy.sponsor;
            this.principalInvestigator = researchStudy.principalInvestigator;
            this.site.addAll(researchStudy.site);
            this.reasonStopped = researchStudy.reasonStopped;
            this.note.addAll(researchStudy.note);
            this.arm.addAll(researchStudy.arm);
            this.objective.addAll(researchStudy.objective);
            return this;
        }
    }
}

