/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CapabilityStatementKind;
import com.ibm.fhir.model.type.code.CodeSearchSupport;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="tcp-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="tcp-1", level="Rule", location="TerminologyCapabilities.codeSystem", description="If there is more than one version, a version code must be defined", expression="version.count() > 1 implies version.all(code.exists())", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="tcp-2", level="Rule", location="(base)", description="A Capability Statement SHALL have at least one of description, software, or implementation element.", expression="(description.count() + software.count() + implementation.count()) > 0", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="tcp-3", level="Rule", location="(base)", description="If kind = instance, implementation must be present and software may be present", expression="(kind != 'instance') or implementation.exists()", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="tcp-4", level="Rule", location="(base)", description="If kind = capability, implementation must be absent, software must be present", expression="(kind != 'capability') or (implementation.exists().not() and software.exists())", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="tcp-5", level="Rule", location="(base)", description="If kind = requirements, implementation and software must be absent", expression="(kind!='requirements') or (implementation.exists().not() and software.exists().not())", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities"), @Constraint(id="terminologyCapabilities-6", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/TerminologyCapabilities", generated=true)})
public class TerminologyCapabilities
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    @Required
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    @Summary
    private final Markdown copyright;
    @Summary
    @Binding(bindingName="CapabilityStatementKind", strength=BindingStrength.Value.REQUIRED, description="How a capability statement is intended to be used.", valueSet="http://hl7.org/fhir/ValueSet/capability-statement-kind|4.0.1")
    @Required
    private final CapabilityStatementKind kind;
    @Summary
    private final Software software;
    @Summary
    private final Implementation implementation;
    @Summary
    private final Boolean lockedDate;
    private final List<CodeSystem> codeSystem;
    private final Expansion expansion;
    @Binding(bindingName="CodeSearchSupport", strength=BindingStrength.Value.REQUIRED, description="The degree to which the server supports the code search parameter on ValueSet, if it is supported.", valueSet="http://hl7.org/fhir/ValueSet/code-search-support|4.0.1")
    private final CodeSearchSupport codeSearch;
    private final ValidateCode validateCode;
    private final Translation translation;
    private final Closure closure;

    private TerminologyCapabilities(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.kind = builder.kind;
        this.software = builder.software;
        this.implementation = builder.implementation;
        this.lockedDate = builder.lockedDate;
        this.codeSystem = Collections.unmodifiableList(builder.codeSystem);
        this.expansion = builder.expansion;
        this.codeSearch = builder.codeSearch;
        this.validateCode = builder.validateCode;
        this.translation = builder.translation;
        this.closure = builder.closure;
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public CapabilityStatementKind getKind() {
        return this.kind;
    }

    public Software getSoftware() {
        return this.software;
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    public Boolean getLockedDate() {
        return this.lockedDate;
    }

    public List<CodeSystem> getCodeSystem() {
        return this.codeSystem;
    }

    public Expansion getExpansion() {
        return this.expansion;
    }

    public CodeSearchSupport getCodeSearch() {
        return this.codeSearch;
    }

    public ValidateCode getValidateCode() {
        return this.validateCode;
    }

    public Translation getTranslation() {
        return this.translation;
    }

    public Closure getClosure() {
        return this.closure;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.kind != null || this.software != null || this.implementation != null || this.lockedDate != null || !this.codeSystem.isEmpty() || this.expansion != null || this.codeSearch != null || this.validateCode != null || this.translation != null || this.closure != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.kind, "kind", visitor);
                this.accept(this.software, "software", visitor);
                this.accept(this.implementation, "implementation", visitor);
                this.accept(this.lockedDate, "lockedDate", visitor);
                this.accept(this.codeSystem, "codeSystem", visitor, CodeSystem.class);
                this.accept(this.expansion, "expansion", visitor);
                this.accept(this.codeSearch, "codeSearch", visitor);
                this.accept(this.validateCode, "validateCode", visitor);
                this.accept(this.translation, "translation", visitor);
                this.accept(this.closure, "closure", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminologyCapabilities other = (TerminologyCapabilities)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.kind, other.kind) && Objects.equals(this.software, other.software) && Objects.equals(this.implementation, other.implementation) && Objects.equals(this.lockedDate, other.lockedDate) && Objects.equals(this.codeSystem, other.codeSystem) && Objects.equals(this.expansion, other.expansion) && Objects.equals(this.codeSearch, other.codeSearch) && Objects.equals(this.validateCode, other.validateCode) && Objects.equals(this.translation, other.translation) && Objects.equals(this.closure, other.closure);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.kind, this.software, this.implementation, this.lockedDate, this.codeSystem, this.expansion, this.codeSearch, this.validateCode, this.translation, this.closure);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Closure
    extends BackboneElement {
        private final Boolean translation;

        private Closure(Builder builder) {
            super(builder);
            this.translation = builder.translation;
        }

        public Boolean getTranslation() {
            return this.translation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.translation != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.translation, "translation", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Closure other = (Closure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.translation, other.translation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.translation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean translation;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder translation(java.lang.Boolean translation) {
                this.translation = translation == null ? null : Boolean.of(translation);
                return this;
            }

            public Builder translation(Boolean translation) {
                this.translation = translation;
                return this;
            }

            @Override
            public Closure build() {
                Closure closure = new Closure(this);
                if (this.validating) {
                    this.validate(closure);
                }
                return closure;
            }

            protected void validate(Closure closure) {
                super.validate(closure);
                ValidationSupport.requireValueOrChildren(closure);
            }

            protected Builder from(Closure closure) {
                super.from(closure);
                this.translation = closure.translation;
                return this;
            }
        }
    }

    public static class Translation
    extends BackboneElement {
        @Required
        private final Boolean needsMap;

        private Translation(Builder builder) {
            super(builder);
            this.needsMap = builder.needsMap;
        }

        public Boolean getNeedsMap() {
            return this.needsMap;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.needsMap != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.needsMap, "needsMap", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Translation other = (Translation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.needsMap, other.needsMap);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.needsMap);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean needsMap;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder needsMap(java.lang.Boolean needsMap) {
                this.needsMap = needsMap == null ? null : Boolean.of(needsMap);
                return this;
            }

            public Builder needsMap(Boolean needsMap) {
                this.needsMap = needsMap;
                return this;
            }

            @Override
            public Translation build() {
                Translation translation = new Translation(this);
                if (this.validating) {
                    this.validate(translation);
                }
                return translation;
            }

            protected void validate(Translation translation) {
                super.validate(translation);
                ValidationSupport.requireNonNull(translation.needsMap, "needsMap");
                ValidationSupport.requireValueOrChildren(translation);
            }

            protected Builder from(Translation translation) {
                super.from(translation);
                this.needsMap = translation.needsMap;
                return this;
            }
        }
    }

    public static class ValidateCode
    extends BackboneElement {
        @Required
        private final Boolean translations;

        private ValidateCode(Builder builder) {
            super(builder);
            this.translations = builder.translations;
        }

        public Boolean getTranslations() {
            return this.translations;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.translations != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.translations, "translations", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidateCode other = (ValidateCode)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.translations, other.translations);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.translations);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean translations;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder translations(java.lang.Boolean translations) {
                this.translations = translations == null ? null : Boolean.of(translations);
                return this;
            }

            public Builder translations(Boolean translations) {
                this.translations = translations;
                return this;
            }

            @Override
            public ValidateCode build() {
                ValidateCode validateCode = new ValidateCode(this);
                if (this.validating) {
                    this.validate(validateCode);
                }
                return validateCode;
            }

            protected void validate(ValidateCode validateCode) {
                super.validate(validateCode);
                ValidationSupport.requireNonNull(validateCode.translations, "translations");
                ValidationSupport.requireValueOrChildren(validateCode);
            }

            protected Builder from(ValidateCode validateCode) {
                super.from(validateCode);
                this.translations = validateCode.translations;
                return this;
            }
        }
    }

    public static class Expansion
    extends BackboneElement {
        private final Boolean hierarchical;
        private final Boolean paging;
        private final Boolean incomplete;
        private final List<Parameter> parameter;
        private final Markdown textFilter;

        private Expansion(Builder builder) {
            super(builder);
            this.hierarchical = builder.hierarchical;
            this.paging = builder.paging;
            this.incomplete = builder.incomplete;
            this.parameter = Collections.unmodifiableList(builder.parameter);
            this.textFilter = builder.textFilter;
        }

        public Boolean getHierarchical() {
            return this.hierarchical;
        }

        public Boolean getPaging() {
            return this.paging;
        }

        public Boolean getIncomplete() {
            return this.incomplete;
        }

        public List<Parameter> getParameter() {
            return this.parameter;
        }

        public Markdown getTextFilter() {
            return this.textFilter;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.hierarchical != null || this.paging != null || this.incomplete != null || !this.parameter.isEmpty() || this.textFilter != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.hierarchical, "hierarchical", visitor);
                    this.accept(this.paging, "paging", visitor);
                    this.accept(this.incomplete, "incomplete", visitor);
                    this.accept(this.parameter, "parameter", visitor, Parameter.class);
                    this.accept(this.textFilter, "textFilter", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Expansion other = (Expansion)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.hierarchical, other.hierarchical) && Objects.equals(this.paging, other.paging) && Objects.equals(this.incomplete, other.incomplete) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.textFilter, other.textFilter);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.hierarchical, this.paging, this.incomplete, this.parameter, this.textFilter);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Parameter
        extends BackboneElement {
            @Required
            private final Code name;
            private final String documentation;

            private Parameter(Builder builder) {
                super(builder);
                this.name = builder.name;
                this.documentation = builder.documentation;
            }

            public Code getName() {
                return this.name;
            }

            public String getDocumentation() {
                return this.documentation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.documentation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.documentation, "documentation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Parameter other = (Parameter)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.documentation, other.documentation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.documentation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Code name;
                private String documentation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(Code name) {
                    this.name = name;
                    return this;
                }

                public Builder documentation(java.lang.String documentation) {
                    this.documentation = documentation == null ? null : String.of(documentation);
                    return this;
                }

                public Builder documentation(String documentation) {
                    this.documentation = documentation;
                    return this;
                }

                @Override
                public Parameter build() {
                    Parameter parameter = new Parameter(this);
                    if (this.validating) {
                        this.validate(parameter);
                    }
                    return parameter;
                }

                protected void validate(Parameter parameter) {
                    super.validate(parameter);
                    ValidationSupport.requireNonNull(parameter.name, "name");
                    ValidationSupport.requireValueOrChildren(parameter);
                }

                protected Builder from(Parameter parameter) {
                    super.from(parameter);
                    this.name = parameter.name;
                    this.documentation = parameter.documentation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean hierarchical;
            private Boolean paging;
            private Boolean incomplete;
            private List<Parameter> parameter = new ArrayList<Parameter>();
            private Markdown textFilter;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder hierarchical(java.lang.Boolean hierarchical) {
                this.hierarchical = hierarchical == null ? null : Boolean.of(hierarchical);
                return this;
            }

            public Builder hierarchical(Boolean hierarchical) {
                this.hierarchical = hierarchical;
                return this;
            }

            public Builder paging(java.lang.Boolean paging) {
                this.paging = paging == null ? null : Boolean.of(paging);
                return this;
            }

            public Builder paging(Boolean paging) {
                this.paging = paging;
                return this;
            }

            public Builder incomplete(java.lang.Boolean incomplete) {
                this.incomplete = incomplete == null ? null : Boolean.of(incomplete);
                return this;
            }

            public Builder incomplete(Boolean incomplete) {
                this.incomplete = incomplete;
                return this;
            }

            public Builder parameter(Parameter ... parameter) {
                for (Parameter value : parameter) {
                    this.parameter.add(value);
                }
                return this;
            }

            public Builder parameter(Collection<Parameter> parameter) {
                this.parameter = new ArrayList<Parameter>(parameter);
                return this;
            }

            public Builder textFilter(Markdown textFilter) {
                this.textFilter = textFilter;
                return this;
            }

            @Override
            public Expansion build() {
                Expansion expansion = new Expansion(this);
                if (this.validating) {
                    this.validate(expansion);
                }
                return expansion;
            }

            protected void validate(Expansion expansion) {
                super.validate(expansion);
                ValidationSupport.checkList(expansion.parameter, "parameter", Parameter.class);
                ValidationSupport.requireValueOrChildren(expansion);
            }

            protected Builder from(Expansion expansion) {
                super.from(expansion);
                this.hierarchical = expansion.hierarchical;
                this.paging = expansion.paging;
                this.incomplete = expansion.incomplete;
                this.parameter.addAll(expansion.parameter);
                this.textFilter = expansion.textFilter;
                return this;
            }
        }
    }

    public static class CodeSystem
    extends BackboneElement {
        private final Canonical uri;
        private final List<Version> version;
        private final Boolean subsumption;

        private CodeSystem(Builder builder) {
            super(builder);
            this.uri = builder.uri;
            this.version = Collections.unmodifiableList(builder.version);
            this.subsumption = builder.subsumption;
        }

        public Canonical getUri() {
            return this.uri;
        }

        public List<Version> getVersion() {
            return this.version;
        }

        public Boolean getSubsumption() {
            return this.subsumption;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.uri != null || !this.version.isEmpty() || this.subsumption != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.uri, "uri", visitor);
                    this.accept(this.version, "version", visitor, Version.class);
                    this.accept(this.subsumption, "subsumption", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodeSystem other = (CodeSystem)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.uri, other.uri) && Objects.equals(this.version, other.version) && Objects.equals(this.subsumption, other.subsumption);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.uri, this.version, this.subsumption);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Version
        extends BackboneElement {
            @Summary
            private final String code;
            @Summary
            private final Boolean isDefault;
            private final Boolean compositional;
            private final List<Code> language;
            private final List<Filter> filter;
            private final List<Code> property;

            private Version(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.isDefault = builder.isDefault;
                this.compositional = builder.compositional;
                this.language = Collections.unmodifiableList(builder.language);
                this.filter = Collections.unmodifiableList(builder.filter);
                this.property = Collections.unmodifiableList(builder.property);
            }

            public String getCode() {
                return this.code;
            }

            public Boolean getIsDefault() {
                return this.isDefault;
            }

            public Boolean getCompositional() {
                return this.compositional;
            }

            public List<Code> getLanguage() {
                return this.language;
            }

            public List<Filter> getFilter() {
                return this.filter;
            }

            public List<Code> getProperty() {
                return this.property;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.isDefault != null || this.compositional != null || !this.language.isEmpty() || !this.filter.isEmpty() || !this.property.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.isDefault, "isDefault", visitor);
                        this.accept(this.compositional, "compositional", visitor);
                        this.accept(this.language, "language", visitor, Code.class);
                        this.accept(this.filter, "filter", visitor, Filter.class);
                        this.accept(this.property, "property", visitor, Code.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Version other = (Version)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.compositional, other.compositional) && Objects.equals(this.language, other.language) && Objects.equals(this.filter, other.filter) && Objects.equals(this.property, other.property);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.isDefault, this.compositional, this.language, this.filter, this.property);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Filter
            extends BackboneElement {
                @Required
                private final Code code;
                @Required
                private final List<Code> op;

                private Filter(Builder builder) {
                    super(builder);
                    this.code = builder.code;
                    this.op = Collections.unmodifiableList(builder.op);
                }

                public Code getCode() {
                    return this.code;
                }

                public List<Code> getOp() {
                    return this.op;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.code != null || !this.op.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.op, "op", visitor, Code.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Filter other = (Filter)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.op, other.op);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.op);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Code code;
                    private List<Code> op = new ArrayList<Code>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder code(Code code) {
                        this.code = code;
                        return this;
                    }

                    public Builder op(Code ... op) {
                        for (Code value : op) {
                            this.op.add(value);
                        }
                        return this;
                    }

                    public Builder op(Collection<Code> op) {
                        this.op = new ArrayList<Code>(op);
                        return this;
                    }

                    @Override
                    public Filter build() {
                        Filter filter = new Filter(this);
                        if (this.validating) {
                            this.validate(filter);
                        }
                        return filter;
                    }

                    protected void validate(Filter filter) {
                        super.validate(filter);
                        ValidationSupport.requireNonNull(filter.code, "code");
                        ValidationSupport.checkNonEmptyList(filter.op, "op", Code.class);
                        ValidationSupport.requireValueOrChildren(filter);
                    }

                    protected Builder from(Filter filter) {
                        super.from(filter);
                        this.code = filter.code;
                        this.op.addAll(filter.op);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String code;
                private Boolean isDefault;
                private Boolean compositional;
                private List<Code> language = new ArrayList<Code>();
                private List<Filter> filter = new ArrayList<Filter>();
                private List<Code> property = new ArrayList<Code>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(java.lang.String code) {
                    this.code = code == null ? null : String.of(code);
                    return this;
                }

                public Builder code(String code) {
                    this.code = code;
                    return this;
                }

                public Builder isDefault(java.lang.Boolean isDefault) {
                    this.isDefault = isDefault == null ? null : Boolean.of(isDefault);
                    return this;
                }

                public Builder isDefault(Boolean isDefault) {
                    this.isDefault = isDefault;
                    return this;
                }

                public Builder compositional(java.lang.Boolean compositional) {
                    this.compositional = compositional == null ? null : Boolean.of(compositional);
                    return this;
                }

                public Builder compositional(Boolean compositional) {
                    this.compositional = compositional;
                    return this;
                }

                public Builder language(Code ... language) {
                    for (Code value : language) {
                        this.language.add(value);
                    }
                    return this;
                }

                public Builder language(Collection<Code> language) {
                    this.language = new ArrayList<Code>(language);
                    return this;
                }

                public Builder filter(Filter ... filter) {
                    for (Filter value : filter) {
                        this.filter.add(value);
                    }
                    return this;
                }

                public Builder filter(Collection<Filter> filter) {
                    this.filter = new ArrayList<Filter>(filter);
                    return this;
                }

                public Builder property(Code ... property) {
                    for (Code value : property) {
                        this.property.add(value);
                    }
                    return this;
                }

                public Builder property(Collection<Code> property) {
                    this.property = new ArrayList<Code>(property);
                    return this;
                }

                @Override
                public Version build() {
                    Version version = new Version(this);
                    if (this.validating) {
                        this.validate(version);
                    }
                    return version;
                }

                protected void validate(Version version) {
                    super.validate(version);
                    ValidationSupport.checkList(version.language, "language", Code.class);
                    ValidationSupport.checkList(version.filter, "filter", Filter.class);
                    ValidationSupport.checkList(version.property, "property", Code.class);
                    ValidationSupport.requireValueOrChildren(version);
                }

                protected Builder from(Version version) {
                    super.from(version);
                    this.code = version.code;
                    this.isDefault = version.isDefault;
                    this.compositional = version.compositional;
                    this.language.addAll(version.language);
                    this.filter.addAll(version.filter);
                    this.property.addAll(version.property);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Canonical uri;
            private List<Version> version = new ArrayList<Version>();
            private Boolean subsumption;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder uri(Canonical uri) {
                this.uri = uri;
                return this;
            }

            public Builder version(Version ... version) {
                for (Version value : version) {
                    this.version.add(value);
                }
                return this;
            }

            public Builder version(Collection<Version> version) {
                this.version = new ArrayList<Version>(version);
                return this;
            }

            public Builder subsumption(java.lang.Boolean subsumption) {
                this.subsumption = subsumption == null ? null : Boolean.of(subsumption);
                return this;
            }

            public Builder subsumption(Boolean subsumption) {
                this.subsumption = subsumption;
                return this;
            }

            @Override
            public CodeSystem build() {
                CodeSystem codeSystem = new CodeSystem(this);
                if (this.validating) {
                    this.validate(codeSystem);
                }
                return codeSystem;
            }

            protected void validate(CodeSystem codeSystem) {
                super.validate(codeSystem);
                ValidationSupport.checkList(codeSystem.version, "version", Version.class);
                ValidationSupport.requireValueOrChildren(codeSystem);
            }

            protected Builder from(CodeSystem codeSystem) {
                super.from(codeSystem);
                this.uri = codeSystem.uri;
                this.version.addAll(codeSystem.version);
                this.subsumption = codeSystem.subsumption;
                return this;
            }
        }
    }

    public static class Implementation
    extends BackboneElement {
        @Summary
        @Required
        private final String description;
        @Summary
        private final Url url;

        private Implementation(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.url = builder.url;
        }

        public String getDescription() {
            return this.description;
        }

        public Url getUrl() {
            return this.url;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.url != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.url, "url", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Implementation other = (Implementation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.url, other.url);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.url);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Url url;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(java.lang.String description) {
                this.description = description == null ? null : String.of(description);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder url(Url url) {
                this.url = url;
                return this;
            }

            @Override
            public Implementation build() {
                Implementation implementation = new Implementation(this);
                if (this.validating) {
                    this.validate(implementation);
                }
                return implementation;
            }

            protected void validate(Implementation implementation) {
                super.validate(implementation);
                ValidationSupport.requireNonNull(implementation.description, "description");
                ValidationSupport.requireValueOrChildren(implementation);
            }

            protected Builder from(Implementation implementation) {
                super.from(implementation);
                this.description = implementation.description;
                this.url = implementation.url;
                return this;
            }
        }
    }

    public static class Software
    extends BackboneElement {
        @Summary
        @Required
        private final String name;
        @Summary
        private final String version;

        private Software(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.version = builder.version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.version != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.version, "version", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Software other = (Software)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.version);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private String version;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(java.lang.String name) {
                this.name = name == null ? null : String.of(name);
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(java.lang.String version) {
                this.version = version == null ? null : String.of(version);
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            @Override
            public Software build() {
                Software software = new Software(this);
                if (this.validating) {
                    this.validate(software);
                }
                return software;
            }

            protected void validate(Software software) {
                super.validate(software);
                ValidationSupport.requireNonNull(software.name, "name");
                ValidationSupport.requireValueOrChildren(software);
            }

            protected Builder from(Software software) {
                super.from(software);
                this.name = software.name;
                this.version = software.version;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private CapabilityStatementKind kind;
        private Software software;
        private Implementation implementation;
        private Boolean lockedDate;
        private List<CodeSystem> codeSystem = new ArrayList<CodeSystem>();
        private Expansion expansion;
        private CodeSearchSupport codeSearch;
        private ValidateCode validateCode;
        private Translation translation;
        private Closure closure;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(java.lang.String title) {
            this.title = title == null ? null : String.of(title);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(java.lang.Boolean experimental) {
            this.experimental = experimental == null ? null : Boolean.of(experimental);
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(java.lang.String publisher) {
            this.publisher = publisher == null ? null : String.of(publisher);
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder kind(CapabilityStatementKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder software(Software software) {
            this.software = software;
            return this;
        }

        public Builder implementation(Implementation implementation) {
            this.implementation = implementation;
            return this;
        }

        public Builder lockedDate(java.lang.Boolean lockedDate) {
            this.lockedDate = lockedDate == null ? null : Boolean.of(lockedDate);
            return this;
        }

        public Builder lockedDate(Boolean lockedDate) {
            this.lockedDate = lockedDate;
            return this;
        }

        public Builder codeSystem(CodeSystem ... codeSystem) {
            for (CodeSystem value : codeSystem) {
                this.codeSystem.add(value);
            }
            return this;
        }

        public Builder codeSystem(Collection<CodeSystem> codeSystem) {
            this.codeSystem = new ArrayList<CodeSystem>(codeSystem);
            return this;
        }

        public Builder expansion(Expansion expansion) {
            this.expansion = expansion;
            return this;
        }

        public Builder codeSearch(CodeSearchSupport codeSearch) {
            this.codeSearch = codeSearch;
            return this;
        }

        public Builder validateCode(ValidateCode validateCode) {
            this.validateCode = validateCode;
            return this;
        }

        public Builder translation(Translation translation) {
            this.translation = translation;
            return this;
        }

        public Builder closure(Closure closure) {
            this.closure = closure;
            return this;
        }

        @Override
        public TerminologyCapabilities build() {
            TerminologyCapabilities terminologyCapabilities = new TerminologyCapabilities(this);
            if (this.validating) {
                this.validate(terminologyCapabilities);
            }
            return terminologyCapabilities;
        }

        protected void validate(TerminologyCapabilities terminologyCapabilities) {
            super.validate(terminologyCapabilities);
            ValidationSupport.requireNonNull(terminologyCapabilities.status, "status");
            ValidationSupport.requireNonNull(terminologyCapabilities.date, "date");
            ValidationSupport.checkList(terminologyCapabilities.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(terminologyCapabilities.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(terminologyCapabilities.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.requireNonNull(terminologyCapabilities.kind, "kind");
            ValidationSupport.checkList(terminologyCapabilities.codeSystem, "codeSystem", CodeSystem.class);
        }

        protected Builder from(TerminologyCapabilities terminologyCapabilities) {
            super.from(terminologyCapabilities);
            this.url = terminologyCapabilities.url;
            this.version = terminologyCapabilities.version;
            this.name = terminologyCapabilities.name;
            this.title = terminologyCapabilities.title;
            this.status = terminologyCapabilities.status;
            this.experimental = terminologyCapabilities.experimental;
            this.date = terminologyCapabilities.date;
            this.publisher = terminologyCapabilities.publisher;
            this.contact.addAll(terminologyCapabilities.contact);
            this.description = terminologyCapabilities.description;
            this.useContext.addAll(terminologyCapabilities.useContext);
            this.jurisdiction.addAll(terminologyCapabilities.jurisdiction);
            this.purpose = terminologyCapabilities.purpose;
            this.copyright = terminologyCapabilities.copyright;
            this.kind = terminologyCapabilities.kind;
            this.software = terminologyCapabilities.software;
            this.implementation = terminologyCapabilities.implementation;
            this.lockedDate = terminologyCapabilities.lockedDate;
            this.codeSystem.addAll(terminologyCapabilities.codeSystem);
            this.expansion = terminologyCapabilities.expansion;
            this.codeSearch = terminologyCapabilities.codeSearch;
            this.validateCode = terminologyCapabilities.validateCode;
            this.translation = terminologyCapabilities.translation;
            this.closure = terminologyCapabilities.closure;
            return this;
        }
    }
}

