/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraints(value={@Constraint(id="age-1", level="Rule", location="(base)", description="There SHALL be a code if there is a value and it SHALL be an expression of time.  If system is present, it SHALL be UCUM.  If value is present, it SHALL be positive.", expression="(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value.hasValue().not() or value > 0)", source="http://hl7.org/fhir/StructureDefinition/Age"), @Constraint(id="age-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/age-units", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/age-units', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Age", generated=true)})
@Binding(bindingName="AgeUnits", strength=BindingStrength.Value.EXTENSIBLE, description="Appropriate units for Age.", valueSet="http://hl7.org/fhir/ValueSet/age-units", maxValueSet="http://hl7.org/fhir/ValueSet/all-time-units")
public class Age
extends Quantity {
    private Age(Builder builder) {
        super(builder);
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.comparator, "comparator", visitor);
                this.accept(this.unit, "unit", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.code, "code", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Age other = (Age)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.unit, other.unit) && Objects.equals(this.system, other.system) && Objects.equals(this.code, other.code);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value, this.comparator, this.unit, this.system, this.code);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Quantity.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(Decimal value) {
            return (Builder)super.value(value);
        }

        @Override
        public Builder comparator(QuantityComparator comparator) {
            return (Builder)super.comparator(comparator);
        }

        @Override
        public Builder unit(java.lang.String unit) {
            return (Builder)super.unit(unit);
        }

        @Override
        public Builder unit(String unit) {
            return (Builder)super.unit(unit);
        }

        @Override
        public Builder system(Uri system) {
            return (Builder)super.system(system);
        }

        @Override
        public Builder code(Code code) {
            return (Builder)super.code(code);
        }

        @Override
        public Age build() {
            Age age = new Age(this);
            if (this.validating) {
                this.validate(age);
            }
            return age;
        }

        protected void validate(Age age) {
            super.validate(age);
        }

        protected Builder from(Age age) {
            super.from(age);
            return this;
        }
    }
}

