/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class Coding
extends Element {
    @Summary
    private final Uri system;
    @Summary
    private final String version;
    @Summary
    private final Code code;
    @Summary
    private final String display;
    @Summary
    private final Boolean userSelected;

    private Coding(Builder builder) {
        super(builder);
        this.system = builder.system;
        this.version = builder.version;
        this.code = builder.code;
        this.display = builder.display;
        this.userSelected = builder.userSelected;
    }

    public Uri getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public Code getCode() {
        return this.code;
    }

    public String getDisplay() {
        return this.display;
    }

    public Boolean getUserSelected() {
        return this.userSelected;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.system != null || this.version != null || this.code != null || this.display != null || this.userSelected != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.system, "system", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.display, "display", visitor);
                this.accept(this.userSelected, "userSelected", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coding other = (Coding)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.system, other.system) && Objects.equals(this.version, other.version) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.userSelected, other.userSelected);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.system, this.version, this.code, this.display, this.userSelected);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Uri system;
        private String version;
        private Code code;
        private String display;
        private Boolean userSelected;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder system(Uri system) {
            this.system = system;
            return this;
        }

        public Builder version(java.lang.String version) {
            this.version = version == null ? null : String.of(version);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        public Builder display(java.lang.String display) {
            this.display = display == null ? null : String.of(display);
            return this;
        }

        public Builder display(String display) {
            this.display = display;
            return this;
        }

        public Builder userSelected(java.lang.Boolean userSelected) {
            this.userSelected = userSelected == null ? null : Boolean.of(userSelected);
            return this;
        }

        public Builder userSelected(Boolean userSelected) {
            this.userSelected = userSelected;
            return this;
        }

        @Override
        public Coding build() {
            Coding coding = new Coding(this);
            if (this.validating) {
                this.validate(coding);
            }
            return coding;
        }

        protected void validate(Coding coding) {
            super.validate(coding);
            ValidationSupport.requireValueOrChildren(coding);
        }

        protected Builder from(Coding coding) {
            super.from(coding);
            this.system = coding.system;
            this.version = coding.version;
            this.code = coding.code;
            this.display = coding.display;
            this.userSelected = coding.userSelected;
            return this;
        }
    }
}

