/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Dosage
extends BackboneElement {
    @Summary
    private final Integer sequence;
    @Summary
    private final String text;
    @Summary
    @Binding(bindingName="AdditionalInstruction", strength=BindingStrength.Value.EXAMPLE, description="A coded concept identifying additional instructions such as \"take with water\" or \"avoid operating heavy machinery\".", valueSet="http://hl7.org/fhir/ValueSet/additional-instruction-codes")
    private final List<CodeableConcept> additionalInstruction;
    @Summary
    private final String patientInstruction;
    @Summary
    private final Timing timing;
    @Summary
    @Choice(value={Boolean.class, CodeableConcept.class})
    @Binding(bindingName="MedicationAsNeededReason", strength=BindingStrength.Value.EXAMPLE, description="A coded concept identifying the precondition that should be met or evaluated prior to consuming or administering a medication dose.  For example \"pain\", \"30 minutes prior to sexual intercourse\", \"on flare-up\" etc.", valueSet="http://hl7.org/fhir/ValueSet/medication-as-needed-reason")
    private final Element asNeeded;
    @Summary
    @Binding(bindingName="MedicationAdministrationSite", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the site location the medicine enters into or onto the body.", valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
    private final CodeableConcept site;
    @Summary
    @Binding(bindingName="RouteOfAdministration", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the route or physiological path of administration of a therapeutic agent into or onto the body of a subject.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    private final CodeableConcept route;
    @Summary
    @Binding(bindingName="MedicationAdministrationMethod", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the technique by which the medicine is administered.", valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
    private final CodeableConcept method;
    @Summary
    private final List<DoseAndRate> doseAndRate;
    @Summary
    private final Ratio maxDosePerPeriod;
    @Summary
    private final SimpleQuantity maxDosePerAdministration;
    @Summary
    private final SimpleQuantity maxDosePerLifetime;

    private Dosage(Builder builder) {
        super(builder);
        this.sequence = builder.sequence;
        this.text = builder.text;
        this.additionalInstruction = Collections.unmodifiableList(builder.additionalInstruction);
        this.patientInstruction = builder.patientInstruction;
        this.timing = builder.timing;
        this.asNeeded = builder.asNeeded;
        this.site = builder.site;
        this.route = builder.route;
        this.method = builder.method;
        this.doseAndRate = Collections.unmodifiableList(builder.doseAndRate);
        this.maxDosePerPeriod = builder.maxDosePerPeriod;
        this.maxDosePerAdministration = builder.maxDosePerAdministration;
        this.maxDosePerLifetime = builder.maxDosePerLifetime;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public String getText() {
        return this.text;
    }

    public List<CodeableConcept> getAdditionalInstruction() {
        return this.additionalInstruction;
    }

    public String getPatientInstruction() {
        return this.patientInstruction;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public Element getAsNeeded() {
        return this.asNeeded;
    }

    public CodeableConcept getSite() {
        return this.site;
    }

    public CodeableConcept getRoute() {
        return this.route;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public List<DoseAndRate> getDoseAndRate() {
        return this.doseAndRate;
    }

    public Ratio getMaxDosePerPeriod() {
        return this.maxDosePerPeriod;
    }

    public SimpleQuantity getMaxDosePerAdministration() {
        return this.maxDosePerAdministration;
    }

    public SimpleQuantity getMaxDosePerLifetime() {
        return this.maxDosePerLifetime;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.sequence != null || this.text != null || !this.additionalInstruction.isEmpty() || this.patientInstruction != null || this.timing != null || this.asNeeded != null || this.site != null || this.route != null || this.method != null || !this.doseAndRate.isEmpty() || this.maxDosePerPeriod != null || this.maxDosePerAdministration != null || this.maxDosePerLifetime != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.sequence, "sequence", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.additionalInstruction, "additionalInstruction", visitor, CodeableConcept.class);
                this.accept(this.patientInstruction, "patientInstruction", visitor);
                this.accept(this.timing, "timing", visitor);
                this.accept(this.asNeeded, "asNeeded", visitor);
                this.accept(this.site, "site", visitor);
                this.accept(this.route, "route", visitor);
                this.accept(this.method, "method", visitor);
                this.accept(this.doseAndRate, "doseAndRate", visitor, DoseAndRate.class);
                this.accept(this.maxDosePerPeriod, "maxDosePerPeriod", visitor);
                this.accept(this.maxDosePerAdministration, "maxDosePerAdministration", visitor);
                this.accept(this.maxDosePerLifetime, "maxDosePerLifetime", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dosage other = (Dosage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.text, other.text) && Objects.equals(this.additionalInstruction, other.additionalInstruction) && Objects.equals(this.patientInstruction, other.patientInstruction) && Objects.equals(this.timing, other.timing) && Objects.equals(this.asNeeded, other.asNeeded) && Objects.equals(this.site, other.site) && Objects.equals(this.route, other.route) && Objects.equals(this.method, other.method) && Objects.equals(this.doseAndRate, other.doseAndRate) && Objects.equals(this.maxDosePerPeriod, other.maxDosePerPeriod) && Objects.equals(this.maxDosePerAdministration, other.maxDosePerAdministration) && Objects.equals(this.maxDosePerLifetime, other.maxDosePerLifetime);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.text, this.additionalInstruction, this.patientInstruction, this.timing, this.asNeeded, this.site, this.route, this.method, this.doseAndRate, this.maxDosePerPeriod, this.maxDosePerAdministration, this.maxDosePerLifetime);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DoseAndRate
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DoseAndRateType", strength=BindingStrength.Value.EXAMPLE, description="The kind of dose or rate specified.", valueSet="http://hl7.org/fhir/ValueSet/dose-rate-type")
        private final CodeableConcept type;
        @Summary
        @Choice(value={Range.class, SimpleQuantity.class})
        private final Element dose;
        @Summary
        @Choice(value={Ratio.class, Range.class, SimpleQuantity.class})
        private final Element rate;

        private DoseAndRate(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.dose = builder.dose;
            this.rate = builder.rate;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getDose() {
            return this.dose;
        }

        public Element getRate() {
            return this.rate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.dose != null || this.rate != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.dose, "dose", visitor);
                    this.accept(this.rate, "rate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DoseAndRate other = (DoseAndRate)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.dose, other.dose) && Objects.equals(this.rate, other.rate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.dose, this.rate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element dose;
            private Element rate;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder dose(Element dose) {
                this.dose = dose;
                return this;
            }

            public Builder rate(Element rate) {
                this.rate = rate;
                return this;
            }

            @Override
            public DoseAndRate build() {
                DoseAndRate doseAndRate = new DoseAndRate(this);
                if (this.validating) {
                    this.validate(doseAndRate);
                }
                return doseAndRate;
            }

            protected void validate(DoseAndRate doseAndRate) {
                super.validate(doseAndRate);
                ValidationSupport.choiceElement(doseAndRate.dose, "dose", Range.class, SimpleQuantity.class);
                ValidationSupport.choiceElement(doseAndRate.rate, "rate", Ratio.class, Range.class, SimpleQuantity.class);
                ValidationSupport.requireValueOrChildren(doseAndRate);
            }

            protected Builder from(DoseAndRate doseAndRate) {
                super.from(doseAndRate);
                this.type = doseAndRate.type;
                this.dose = doseAndRate.dose;
                this.rate = doseAndRate.rate;
                return this;
            }
        }
    }

    public static class Builder
    extends BackboneElement.Builder {
        private Integer sequence;
        private String text;
        private List<CodeableConcept> additionalInstruction = new ArrayList<CodeableConcept>();
        private String patientInstruction;
        private Timing timing;
        private Element asNeeded;
        private CodeableConcept site;
        private CodeableConcept route;
        private CodeableConcept method;
        private List<DoseAndRate> doseAndRate = new ArrayList<DoseAndRate>();
        private Ratio maxDosePerPeriod;
        private SimpleQuantity maxDosePerAdministration;
        private SimpleQuantity maxDosePerLifetime;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder sequence(java.lang.Integer sequence) {
            this.sequence = sequence == null ? null : Integer.of(sequence);
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder text(java.lang.String text) {
            this.text = text == null ? null : String.of(text);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder additionalInstruction(CodeableConcept ... additionalInstruction) {
            for (CodeableConcept value : additionalInstruction) {
                this.additionalInstruction.add(value);
            }
            return this;
        }

        public Builder additionalInstruction(Collection<CodeableConcept> additionalInstruction) {
            this.additionalInstruction = new ArrayList<CodeableConcept>(additionalInstruction);
            return this;
        }

        public Builder patientInstruction(java.lang.String patientInstruction) {
            this.patientInstruction = patientInstruction == null ? null : String.of(patientInstruction);
            return this;
        }

        public Builder patientInstruction(String patientInstruction) {
            this.patientInstruction = patientInstruction;
            return this;
        }

        public Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public Builder asNeeded(java.lang.Boolean asNeeded) {
            this.asNeeded = asNeeded == null ? null : Boolean.of(asNeeded);
            return this;
        }

        public Builder asNeeded(Element asNeeded) {
            this.asNeeded = asNeeded;
            return this;
        }

        public Builder site(CodeableConcept site) {
            this.site = site;
            return this;
        }

        public Builder route(CodeableConcept route) {
            this.route = route;
            return this;
        }

        public Builder method(CodeableConcept method) {
            this.method = method;
            return this;
        }

        public Builder doseAndRate(DoseAndRate ... doseAndRate) {
            for (DoseAndRate value : doseAndRate) {
                this.doseAndRate.add(value);
            }
            return this;
        }

        public Builder doseAndRate(Collection<DoseAndRate> doseAndRate) {
            this.doseAndRate = new ArrayList<DoseAndRate>(doseAndRate);
            return this;
        }

        public Builder maxDosePerPeriod(Ratio maxDosePerPeriod) {
            this.maxDosePerPeriod = maxDosePerPeriod;
            return this;
        }

        public Builder maxDosePerAdministration(SimpleQuantity maxDosePerAdministration) {
            this.maxDosePerAdministration = maxDosePerAdministration;
            return this;
        }

        public Builder maxDosePerLifetime(SimpleQuantity maxDosePerLifetime) {
            this.maxDosePerLifetime = maxDosePerLifetime;
            return this;
        }

        @Override
        public Dosage build() {
            Dosage dosage = new Dosage(this);
            if (this.validating) {
                this.validate(dosage);
            }
            return dosage;
        }

        protected void validate(Dosage dosage) {
            super.validate(dosage);
            ValidationSupport.checkList(dosage.additionalInstruction, "additionalInstruction", CodeableConcept.class);
            ValidationSupport.choiceElement(dosage.asNeeded, "asNeeded", Boolean.class, CodeableConcept.class);
            ValidationSupport.checkList(dosage.doseAndRate, "doseAndRate", DoseAndRate.class);
            ValidationSupport.requireValueOrChildren(dosage);
        }

        protected Builder from(Dosage dosage) {
            super.from(dosage);
            this.sequence = dosage.sequence;
            this.text = dosage.text;
            this.additionalInstruction.addAll(dosage.additionalInstruction);
            this.patientInstruction = dosage.patientInstruction;
            this.timing = dosage.timing;
            this.asNeeded = dosage.asNeeded;
            this.site = dosage.site;
            this.route = dosage.route;
            this.method = dosage.method;
            this.doseAndRate.addAll(dosage.doseAndRate);
            this.maxDosePerPeriod = dosage.maxDosePerPeriod;
            this.maxDosePerAdministration = dosage.maxDosePerAdministration;
            this.maxDosePerLifetime = dosage.maxDosePerLifetime;
            return this;
        }
    }
}

