/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class MarketingStatus
extends BackboneElement {
    @Summary
    @Required
    private final CodeableConcept country;
    @Summary
    private final CodeableConcept jurisdiction;
    @Summary
    @Required
    private final CodeableConcept status;
    @Summary
    @Required
    private final Period dateRange;
    @Summary
    private final DateTime restoreDate;

    private MarketingStatus(Builder builder) {
        super(builder);
        this.country = builder.country;
        this.jurisdiction = builder.jurisdiction;
        this.status = builder.status;
        this.dateRange = builder.dateRange;
        this.restoreDate = builder.restoreDate;
    }

    public CodeableConcept getCountry() {
        return this.country;
    }

    public CodeableConcept getJurisdiction() {
        return this.jurisdiction;
    }

    public CodeableConcept getStatus() {
        return this.status;
    }

    public Period getDateRange() {
        return this.dateRange;
    }

    public DateTime getRestoreDate() {
        return this.restoreDate;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.country != null || this.jurisdiction != null || this.status != null || this.dateRange != null || this.restoreDate != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.country, "country", visitor);
                this.accept(this.jurisdiction, "jurisdiction", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.dateRange, "dateRange", visitor);
                this.accept(this.restoreDate, "restoreDate", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarketingStatus other = (MarketingStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.country, other.country) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.status, other.status) && Objects.equals(this.dateRange, other.dateRange) && Objects.equals(this.restoreDate, other.restoreDate);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.country, this.jurisdiction, this.status, this.dateRange, this.restoreDate);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BackboneElement.Builder {
        private CodeableConcept country;
        private CodeableConcept jurisdiction;
        private CodeableConcept status;
        private Period dateRange;
        private DateTime restoreDate;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder country(CodeableConcept country) {
            this.country = country;
            return this;
        }

        public Builder jurisdiction(CodeableConcept jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        public Builder status(CodeableConcept status) {
            this.status = status;
            return this;
        }

        public Builder dateRange(Period dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public Builder restoreDate(DateTime restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        @Override
        public MarketingStatus build() {
            MarketingStatus marketingStatus = new MarketingStatus(this);
            if (this.validating) {
                this.validate(marketingStatus);
            }
            return marketingStatus;
        }

        protected void validate(MarketingStatus marketingStatus) {
            super.validate(marketingStatus);
            ValidationSupport.requireNonNull(marketingStatus.country, "country");
            ValidationSupport.requireNonNull(marketingStatus.status, "status");
            ValidationSupport.requireNonNull(marketingStatus.dateRange, "dateRange");
            ValidationSupport.requireValueOrChildren(marketingStatus);
        }

        protected Builder from(MarketingStatus marketingStatus) {
            super.from(marketingStatus);
            this.country = marketingStatus.country;
            this.jurisdiction = marketingStatus.jurisdiction;
            this.status = marketingStatus.status;
            this.dateRange = marketingStatus.dateRange;
            this.restoreDate = marketingStatus.restoreDate;
            return this;
        }
    }
}

