/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

public class Oid
extends Uri {
    private static final Pattern PATTERN = Pattern.compile("urn:oid:[0-2](\\.(0|[1-9][0-9]*))+");

    private Oid(Builder builder) {
        super(builder);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    public static Oid of(String value) {
        Objects.requireNonNull(value, "value");
        return Oid.builder().value(value).build();
    }

    public static Uri uri(String value) {
        Objects.requireNonNull(value, "value");
        return Oid.builder().value(value).build();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Oid other = (Oid)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Uri.Builder {
        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(String value) {
            return (Builder)super.value(value);
        }

        @Override
        public Oid build() {
            Oid oid = new Oid(this);
            if (this.validating) {
                this.validate(oid);
            }
            return oid;
        }

        protected void validate(Oid oid) {
            super.validate(oid);
            ValidationSupport.checkValue(oid.value, PATTERN);
        }

        protected Builder from(Oid oid) {
            super.from(oid);
            return this;
        }
    }
}

