/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.TriggerType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Constraints(value={@Constraint(id="trd-1", level="Rule", location="(base)", description="Either timing, or a data requirement, but not both", expression="data.empty() or timing.empty()", source="http://hl7.org/fhir/StructureDefinition/TriggerDefinition"), @Constraint(id="trd-2", level="Rule", location="(base)", description="A condition only if there is a data requirement", expression="condition.exists() implies data.exists()", source="http://hl7.org/fhir/StructureDefinition/TriggerDefinition"), @Constraint(id="trd-3", level="Rule", location="(base)", description="A named event requires a name, a periodic event requires timing, and a data event requires data", expression="(type = 'named-event' implies name.exists()) and (type = 'periodic' implies timing.exists()) and (type.startsWith('data-') implies data.exists())", source="http://hl7.org/fhir/StructureDefinition/TriggerDefinition")})
public class TriggerDefinition
extends Element {
    @Summary
    @Binding(bindingName="TriggerType", strength=BindingStrength.Value.REQUIRED, description="The type of trigger.", valueSet="http://hl7.org/fhir/ValueSet/trigger-type|4.0.1")
    @Required
    private final TriggerType type;
    @Summary
    private final String name;
    @Summary
    @ReferenceTarget(value={"Schedule"})
    @Choice(value={Timing.class, Reference.class, Date.class, DateTime.class})
    private final Element timing;
    @Summary
    private final List<DataRequirement> data;
    @Summary
    private final Expression condition;

    private TriggerDefinition(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.timing = builder.timing;
        this.data = Collections.unmodifiableList(builder.data);
        this.condition = builder.condition;
    }

    public TriggerType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Element getTiming() {
        return this.timing;
    }

    public List<DataRequirement> getData() {
        return this.data;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.type != null || this.name != null || this.timing != null || !this.data.isEmpty() || this.condition != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.timing, "timing", visitor);
                this.accept(this.data, "data", visitor, DataRequirement.class);
                this.accept(this.condition, "condition", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggerDefinition other = (TriggerDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.timing, other.timing) && Objects.equals(this.data, other.data) && Objects.equals(this.condition, other.condition);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.type, this.name, this.timing, this.data, this.condition);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private TriggerType type;
        private String name;
        private Element timing;
        private List<DataRequirement> data = new ArrayList<DataRequirement>();
        private Expression condition;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder type(TriggerType type) {
            this.type = type;
            return this;
        }

        public Builder name(java.lang.String name) {
            this.name = name == null ? null : String.of(name);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timing(LocalDate timing) {
            this.timing = timing == null ? null : Date.of(timing);
            return this;
        }

        public Builder timing(Element timing) {
            this.timing = timing;
            return this;
        }

        public Builder data(DataRequirement ... data) {
            for (DataRequirement value : data) {
                this.data.add(value);
            }
            return this;
        }

        public Builder data(Collection<DataRequirement> data) {
            this.data = new ArrayList<DataRequirement>(data);
            return this;
        }

        public Builder condition(Expression condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public TriggerDefinition build() {
            TriggerDefinition triggerDefinition = new TriggerDefinition(this);
            if (this.validating) {
                this.validate(triggerDefinition);
            }
            return triggerDefinition;
        }

        protected void validate(TriggerDefinition triggerDefinition) {
            super.validate(triggerDefinition);
            ValidationSupport.requireNonNull(triggerDefinition.type, "type");
            ValidationSupport.choiceElement(triggerDefinition.timing, "timing", Timing.class, Reference.class, Date.class, DateTime.class);
            ValidationSupport.checkList(triggerDefinition.data, "data", DataRequirement.class);
            ValidationSupport.checkReferenceType(triggerDefinition.timing, "timing", "Schedule");
            ValidationSupport.requireValueOrChildren(triggerDefinition);
        }

        protected Builder from(TriggerDefinition triggerDefinition) {
            super.from(triggerDefinition);
            this.type = triggerDefinition.type;
            this.name = triggerDefinition.name;
            this.timing = triggerDefinition.timing;
            this.data.addAll(triggerDefinition.data);
            this.condition = triggerDefinition.condition;
            return this;
        }
    }
}

