/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/action-condition-kind")
public class ActionConditionKind
extends Code {
    public static final ActionConditionKind APPLICABILITY = ActionConditionKind.builder().value(Value.APPLICABILITY).build();
    public static final ActionConditionKind START = ActionConditionKind.builder().value(Value.START).build();
    public static final ActionConditionKind STOP = ActionConditionKind.builder().value(Value.STOP).build();
    private volatile int hashCode;

    private ActionConditionKind(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ActionConditionKind of(Value value) {
        switch (value) {
            case APPLICABILITY: {
                return APPLICABILITY;
            }
            case START: {
                return START;
            }
            case STOP: {
                return STOP;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActionConditionKind of(java.lang.String value) {
        return ActionConditionKind.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ActionConditionKind.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ActionConditionKind.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionConditionKind other = (ActionConditionKind)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        APPLICABILITY("applicability"),
        START("start"),
        STOP("stop");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "applicability": {
                    return APPLICABILITY;
                }
                case "start": {
                    return START;
                }
                case "stop": {
                    return STOP;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ActionConditionKind build() {
            ActionConditionKind actionConditionKind = new ActionConditionKind(this);
            if (this.validating) {
                this.validate(actionConditionKind);
            }
            return actionConditionKind;
        }

        protected void validate(ActionConditionKind actionConditionKind) {
            super.validate(actionConditionKind);
        }

        protected Builder from(ActionConditionKind actionConditionKind) {
            super.from(actionConditionKind);
            return this;
        }
    }
}

