/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/appointmentstatus")
public class AppointmentStatus
extends Code {
    public static final AppointmentStatus PROPOSED = AppointmentStatus.builder().value(Value.PROPOSED).build();
    public static final AppointmentStatus PENDING = AppointmentStatus.builder().value(Value.PENDING).build();
    public static final AppointmentStatus BOOKED = AppointmentStatus.builder().value(Value.BOOKED).build();
    public static final AppointmentStatus ARRIVED = AppointmentStatus.builder().value(Value.ARRIVED).build();
    public static final AppointmentStatus FULFILLED = AppointmentStatus.builder().value(Value.FULFILLED).build();
    public static final AppointmentStatus CANCELLED = AppointmentStatus.builder().value(Value.CANCELLED).build();
    public static final AppointmentStatus NOSHOW = AppointmentStatus.builder().value(Value.NOSHOW).build();
    public static final AppointmentStatus ENTERED_IN_ERROR = AppointmentStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final AppointmentStatus CHECKED_IN = AppointmentStatus.builder().value(Value.CHECKED_IN).build();
    public static final AppointmentStatus WAITLIST = AppointmentStatus.builder().value(Value.WAITLIST).build();
    private volatile int hashCode;

    private AppointmentStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static AppointmentStatus of(Value value) {
        switch (value) {
            case PROPOSED: {
                return PROPOSED;
            }
            case PENDING: {
                return PENDING;
            }
            case BOOKED: {
                return BOOKED;
            }
            case ARRIVED: {
                return ARRIVED;
            }
            case FULFILLED: {
                return FULFILLED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case NOSHOW: {
                return NOSHOW;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case CHECKED_IN: {
                return CHECKED_IN;
            }
            case WAITLIST: {
                return WAITLIST;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AppointmentStatus of(java.lang.String value) {
        return AppointmentStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AppointmentStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AppointmentStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppointmentStatus other = (AppointmentStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PROPOSED("proposed"),
        PENDING("pending"),
        BOOKED("booked"),
        ARRIVED("arrived"),
        FULFILLED("fulfilled"),
        CANCELLED("cancelled"),
        NOSHOW("noshow"),
        ENTERED_IN_ERROR("entered-in-error"),
        CHECKED_IN("checked-in"),
        WAITLIST("waitlist");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "proposed": {
                    return PROPOSED;
                }
                case "pending": {
                    return PENDING;
                }
                case "booked": {
                    return BOOKED;
                }
                case "arrived": {
                    return ARRIVED;
                }
                case "fulfilled": {
                    return FULFILLED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "noshow": {
                    return NOSHOW;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "checked-in": {
                    return CHECKED_IN;
                }
                case "waitlist": {
                    return WAITLIST;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AppointmentStatus build() {
            AppointmentStatus appointmentStatus = new AppointmentStatus(this);
            if (this.validating) {
                this.validate(appointmentStatus);
            }
            return appointmentStatus;
        }

        protected void validate(AppointmentStatus appointmentStatus) {
            super.validate(appointmentStatus);
        }

        protected Builder from(AppointmentStatus appointmentStatus) {
            super.from(appointmentStatus);
            return this;
        }
    }
}

