/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/codesystem-hierarchy-meaning")
public class CodeSystemHierarchyMeaning
extends Code {
    public static final CodeSystemHierarchyMeaning GROUPED_BY = CodeSystemHierarchyMeaning.builder().value(Value.GROUPED_BY).build();
    public static final CodeSystemHierarchyMeaning IS_A = CodeSystemHierarchyMeaning.builder().value(Value.IS_A).build();
    public static final CodeSystemHierarchyMeaning PART_OF = CodeSystemHierarchyMeaning.builder().value(Value.PART_OF).build();
    public static final CodeSystemHierarchyMeaning CLASSIFIED_WITH = CodeSystemHierarchyMeaning.builder().value(Value.CLASSIFIED_WITH).build();
    private volatile int hashCode;

    private CodeSystemHierarchyMeaning(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CodeSystemHierarchyMeaning of(Value value) {
        switch (value) {
            case GROUPED_BY: {
                return GROUPED_BY;
            }
            case IS_A: {
                return IS_A;
            }
            case PART_OF: {
                return PART_OF;
            }
            case CLASSIFIED_WITH: {
                return CLASSIFIED_WITH;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CodeSystemHierarchyMeaning of(java.lang.String value) {
        return CodeSystemHierarchyMeaning.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CodeSystemHierarchyMeaning.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CodeSystemHierarchyMeaning.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeSystemHierarchyMeaning other = (CodeSystemHierarchyMeaning)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        GROUPED_BY("grouped-by"),
        IS_A("is-a"),
        PART_OF("part-of"),
        CLASSIFIED_WITH("classified-with");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "grouped-by": {
                    return GROUPED_BY;
                }
                case "is-a": {
                    return IS_A;
                }
                case "part-of": {
                    return PART_OF;
                }
                case "classified-with": {
                    return CLASSIFIED_WITH;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CodeSystemHierarchyMeaning build() {
            CodeSystemHierarchyMeaning codeSystemHierarchyMeaning = new CodeSystemHierarchyMeaning(this);
            if (this.validating) {
                this.validate(codeSystemHierarchyMeaning);
            }
            return codeSystemHierarchyMeaning;
        }

        protected void validate(CodeSystemHierarchyMeaning codeSystemHierarchyMeaning) {
            super.validate(codeSystemHierarchyMeaning);
        }

        protected Builder from(CodeSystemHierarchyMeaning codeSystemHierarchyMeaning) {
            super.from(codeSystemHierarchyMeaning);
            return this;
        }
    }
}

