/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/event-status")
public class CommunicationStatus
extends Code {
    public static final CommunicationStatus PREPARATION = CommunicationStatus.builder().value(Value.PREPARATION).build();
    public static final CommunicationStatus IN_PROGRESS = CommunicationStatus.builder().value(Value.IN_PROGRESS).build();
    public static final CommunicationStatus NOT_DONE = CommunicationStatus.builder().value(Value.NOT_DONE).build();
    public static final CommunicationStatus ON_HOLD = CommunicationStatus.builder().value(Value.ON_HOLD).build();
    public static final CommunicationStatus STOPPED = CommunicationStatus.builder().value(Value.STOPPED).build();
    public static final CommunicationStatus COMPLETED = CommunicationStatus.builder().value(Value.COMPLETED).build();
    public static final CommunicationStatus ENTERED_IN_ERROR = CommunicationStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final CommunicationStatus UNKNOWN = CommunicationStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private CommunicationStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static CommunicationStatus of(Value value) {
        switch (value) {
            case PREPARATION: {
                return PREPARATION;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case NOT_DONE: {
                return NOT_DONE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case STOPPED: {
                return STOPPED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static CommunicationStatus of(java.lang.String value) {
        return CommunicationStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return CommunicationStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return CommunicationStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicationStatus other = (CommunicationStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PREPARATION("preparation"),
        IN_PROGRESS("in-progress"),
        NOT_DONE("not-done"),
        ON_HOLD("on-hold"),
        STOPPED("stopped"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "preparation": {
                    return PREPARATION;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "not-done": {
                    return NOT_DONE;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "stopped": {
                    return STOPPED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public CommunicationStatus build() {
            CommunicationStatus communicationStatus = new CommunicationStatus(this);
            if (this.validating) {
                this.validate(communicationStatus);
            }
            return communicationStatus;
        }

        protected void validate(CommunicationStatus communicationStatus) {
            super.validate(communicationStatus);
        }

        protected Builder from(CommunicationStatus communicationStatus) {
            super.from(communicationStatus);
            return this;
        }
    }
}

