/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/contact-point-system")
public class ContactPointSystem
extends Code {
    public static final ContactPointSystem PHONE = ContactPointSystem.builder().value(Value.PHONE).build();
    public static final ContactPointSystem FAX = ContactPointSystem.builder().value(Value.FAX).build();
    public static final ContactPointSystem EMAIL = ContactPointSystem.builder().value(Value.EMAIL).build();
    public static final ContactPointSystem PAGER = ContactPointSystem.builder().value(Value.PAGER).build();
    public static final ContactPointSystem URL = ContactPointSystem.builder().value(Value.URL).build();
    public static final ContactPointSystem SMS = ContactPointSystem.builder().value(Value.SMS).build();
    public static final ContactPointSystem OTHER = ContactPointSystem.builder().value(Value.OTHER).build();
    private volatile int hashCode;

    private ContactPointSystem(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ContactPointSystem of(Value value) {
        switch (value) {
            case PHONE: {
                return PHONE;
            }
            case FAX: {
                return FAX;
            }
            case EMAIL: {
                return EMAIL;
            }
            case PAGER: {
                return PAGER;
            }
            case URL: {
                return URL;
            }
            case SMS: {
                return SMS;
            }
            case OTHER: {
                return OTHER;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ContactPointSystem of(java.lang.String value) {
        return ContactPointSystem.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ContactPointSystem.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ContactPointSystem.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactPointSystem other = (ContactPointSystem)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PHONE("phone"),
        FAX("fax"),
        EMAIL("email"),
        PAGER("pager"),
        URL("url"),
        SMS("sms"),
        OTHER("other");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "phone": {
                    return PHONE;
                }
                case "fax": {
                    return FAX;
                }
                case "email": {
                    return EMAIL;
                }
                case "pager": {
                    return PAGER;
                }
                case "url": {
                    return URL;
                }
                case "sms": {
                    return SMS;
                }
                case "other": {
                    return OTHER;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ContactPointSystem build() {
            ContactPointSystem contactPointSystem = new ContactPointSystem(this);
            if (this.validating) {
                this.validate(contactPointSystem);
            }
            return contactPointSystem;
        }

        protected void validate(ContactPointSystem contactPointSystem) {
            super.validate(contactPointSystem);
        }

        protected Builder from(ContactPointSystem contactPointSystem) {
            super.from(contactPointSystem);
            return this;
        }
    }
}

