/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/issue-type")
public class IssueType
extends Code {
    public static final IssueType INVALID = IssueType.builder().value(Value.INVALID).build();
    public static final IssueType STRUCTURE = IssueType.builder().value(Value.STRUCTURE).build();
    public static final IssueType REQUIRED = IssueType.builder().value(Value.REQUIRED).build();
    public static final IssueType VALUE = IssueType.builder().value(Value.VALUE).build();
    public static final IssueType INVARIANT = IssueType.builder().value(Value.INVARIANT).build();
    public static final IssueType SECURITY = IssueType.builder().value(Value.SECURITY).build();
    public static final IssueType LOGIN = IssueType.builder().value(Value.LOGIN).build();
    public static final IssueType UNKNOWN = IssueType.builder().value(Value.UNKNOWN).build();
    public static final IssueType EXPIRED = IssueType.builder().value(Value.EXPIRED).build();
    public static final IssueType FORBIDDEN = IssueType.builder().value(Value.FORBIDDEN).build();
    public static final IssueType SUPPRESSED = IssueType.builder().value(Value.SUPPRESSED).build();
    public static final IssueType PROCESSING = IssueType.builder().value(Value.PROCESSING).build();
    public static final IssueType NOT_SUPPORTED = IssueType.builder().value(Value.NOT_SUPPORTED).build();
    public static final IssueType DUPLICATE = IssueType.builder().value(Value.DUPLICATE).build();
    public static final IssueType MULTIPLE_MATCHES = IssueType.builder().value(Value.MULTIPLE_MATCHES).build();
    public static final IssueType NOT_FOUND = IssueType.builder().value(Value.NOT_FOUND).build();
    public static final IssueType DELETED = IssueType.builder().value(Value.DELETED).build();
    public static final IssueType TOO_LONG = IssueType.builder().value(Value.TOO_LONG).build();
    public static final IssueType CODE_INVALID = IssueType.builder().value(Value.CODE_INVALID).build();
    public static final IssueType EXTENSION = IssueType.builder().value(Value.EXTENSION).build();
    public static final IssueType TOO_COSTLY = IssueType.builder().value(Value.TOO_COSTLY).build();
    public static final IssueType BUSINESS_RULE = IssueType.builder().value(Value.BUSINESS_RULE).build();
    public static final IssueType CONFLICT = IssueType.builder().value(Value.CONFLICT).build();
    public static final IssueType TRANSIENT = IssueType.builder().value(Value.TRANSIENT).build();
    public static final IssueType LOCK_ERROR = IssueType.builder().value(Value.LOCK_ERROR).build();
    public static final IssueType NO_STORE = IssueType.builder().value(Value.NO_STORE).build();
    public static final IssueType EXCEPTION = IssueType.builder().value(Value.EXCEPTION).build();
    public static final IssueType TIMEOUT = IssueType.builder().value(Value.TIMEOUT).build();
    public static final IssueType INCOMPLETE = IssueType.builder().value(Value.INCOMPLETE).build();
    public static final IssueType THROTTLED = IssueType.builder().value(Value.THROTTLED).build();
    public static final IssueType INFORMATIONAL = IssueType.builder().value(Value.INFORMATIONAL).build();
    private volatile int hashCode;

    private IssueType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static IssueType of(Value value) {
        switch (value) {
            case INVALID: {
                return INVALID;
            }
            case STRUCTURE: {
                return STRUCTURE;
            }
            case REQUIRED: {
                return REQUIRED;
            }
            case VALUE: {
                return VALUE;
            }
            case INVARIANT: {
                return INVARIANT;
            }
            case SECURITY: {
                return SECURITY;
            }
            case LOGIN: {
                return LOGIN;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
            case EXPIRED: {
                return EXPIRED;
            }
            case FORBIDDEN: {
                return FORBIDDEN;
            }
            case SUPPRESSED: {
                return SUPPRESSED;
            }
            case PROCESSING: {
                return PROCESSING;
            }
            case NOT_SUPPORTED: {
                return NOT_SUPPORTED;
            }
            case DUPLICATE: {
                return DUPLICATE;
            }
            case MULTIPLE_MATCHES: {
                return MULTIPLE_MATCHES;
            }
            case NOT_FOUND: {
                return NOT_FOUND;
            }
            case DELETED: {
                return DELETED;
            }
            case TOO_LONG: {
                return TOO_LONG;
            }
            case CODE_INVALID: {
                return CODE_INVALID;
            }
            case EXTENSION: {
                return EXTENSION;
            }
            case TOO_COSTLY: {
                return TOO_COSTLY;
            }
            case BUSINESS_RULE: {
                return BUSINESS_RULE;
            }
            case CONFLICT: {
                return CONFLICT;
            }
            case TRANSIENT: {
                return TRANSIENT;
            }
            case LOCK_ERROR: {
                return LOCK_ERROR;
            }
            case NO_STORE: {
                return NO_STORE;
            }
            case EXCEPTION: {
                return EXCEPTION;
            }
            case TIMEOUT: {
                return TIMEOUT;
            }
            case INCOMPLETE: {
                return INCOMPLETE;
            }
            case THROTTLED: {
                return THROTTLED;
            }
            case INFORMATIONAL: {
                return INFORMATIONAL;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static IssueType of(java.lang.String value) {
        return IssueType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return IssueType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return IssueType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IssueType other = (IssueType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        INVALID("invalid"),
        STRUCTURE("structure"),
        REQUIRED("required"),
        VALUE("value"),
        INVARIANT("invariant"),
        SECURITY("security"),
        LOGIN("login"),
        UNKNOWN("unknown"),
        EXPIRED("expired"),
        FORBIDDEN("forbidden"),
        SUPPRESSED("suppressed"),
        PROCESSING("processing"),
        NOT_SUPPORTED("not-supported"),
        DUPLICATE("duplicate"),
        MULTIPLE_MATCHES("multiple-matches"),
        NOT_FOUND("not-found"),
        DELETED("deleted"),
        TOO_LONG("too-long"),
        CODE_INVALID("code-invalid"),
        EXTENSION("extension"),
        TOO_COSTLY("too-costly"),
        BUSINESS_RULE("business-rule"),
        CONFLICT("conflict"),
        TRANSIENT("transient"),
        LOCK_ERROR("lock-error"),
        NO_STORE("no-store"),
        EXCEPTION("exception"),
        TIMEOUT("timeout"),
        INCOMPLETE("incomplete"),
        THROTTLED("throttled"),
        INFORMATIONAL("informational");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "invalid": {
                    return INVALID;
                }
                case "structure": {
                    return STRUCTURE;
                }
                case "required": {
                    return REQUIRED;
                }
                case "value": {
                    return VALUE;
                }
                case "invariant": {
                    return INVARIANT;
                }
                case "security": {
                    return SECURITY;
                }
                case "login": {
                    return LOGIN;
                }
                case "unknown": {
                    return UNKNOWN;
                }
                case "expired": {
                    return EXPIRED;
                }
                case "forbidden": {
                    return FORBIDDEN;
                }
                case "suppressed": {
                    return SUPPRESSED;
                }
                case "processing": {
                    return PROCESSING;
                }
                case "not-supported": {
                    return NOT_SUPPORTED;
                }
                case "duplicate": {
                    return DUPLICATE;
                }
                case "multiple-matches": {
                    return MULTIPLE_MATCHES;
                }
                case "not-found": {
                    return NOT_FOUND;
                }
                case "deleted": {
                    return DELETED;
                }
                case "too-long": {
                    return TOO_LONG;
                }
                case "code-invalid": {
                    return CODE_INVALID;
                }
                case "extension": {
                    return EXTENSION;
                }
                case "too-costly": {
                    return TOO_COSTLY;
                }
                case "business-rule": {
                    return BUSINESS_RULE;
                }
                case "conflict": {
                    return CONFLICT;
                }
                case "transient": {
                    return TRANSIENT;
                }
                case "lock-error": {
                    return LOCK_ERROR;
                }
                case "no-store": {
                    return NO_STORE;
                }
                case "exception": {
                    return EXCEPTION;
                }
                case "timeout": {
                    return TIMEOUT;
                }
                case "incomplete": {
                    return INCOMPLETE;
                }
                case "throttled": {
                    return THROTTLED;
                }
                case "informational": {
                    return INFORMATIONAL;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public IssueType build() {
            IssueType issueType = new IssueType(this);
            if (this.validating) {
                this.validate(issueType);
            }
            return issueType;
        }

        protected void validate(IssueType issueType) {
            super.validate(issueType);
        }

        protected Builder from(IssueType issueType) {
            super.from(issueType);
            return this;
        }
    }
}

