/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/messageheader-response-request")
public class MessageHeaderResponseRequest
extends Code {
    public static final MessageHeaderResponseRequest ALWAYS = MessageHeaderResponseRequest.builder().value(Value.ALWAYS).build();
    public static final MessageHeaderResponseRequest ON_ERROR = MessageHeaderResponseRequest.builder().value(Value.ON_ERROR).build();
    public static final MessageHeaderResponseRequest NEVER = MessageHeaderResponseRequest.builder().value(Value.NEVER).build();
    public static final MessageHeaderResponseRequest ON_SUCCESS = MessageHeaderResponseRequest.builder().value(Value.ON_SUCCESS).build();
    private volatile int hashCode;

    private MessageHeaderResponseRequest(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static MessageHeaderResponseRequest of(Value value) {
        switch (value) {
            case ALWAYS: {
                return ALWAYS;
            }
            case ON_ERROR: {
                return ON_ERROR;
            }
            case NEVER: {
                return NEVER;
            }
            case ON_SUCCESS: {
                return ON_SUCCESS;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MessageHeaderResponseRequest of(java.lang.String value) {
        return MessageHeaderResponseRequest.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return MessageHeaderResponseRequest.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return MessageHeaderResponseRequest.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageHeaderResponseRequest other = (MessageHeaderResponseRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ALWAYS("always"),
        ON_ERROR("on-error"),
        NEVER("never"),
        ON_SUCCESS("on-success");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "always": {
                    return ALWAYS;
                }
                case "on-error": {
                    return ON_ERROR;
                }
                case "never": {
                    return NEVER;
                }
                case "on-success": {
                    return ON_SUCCESS;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MessageHeaderResponseRequest build() {
            MessageHeaderResponseRequest messageHeaderResponseRequest = new MessageHeaderResponseRequest(this);
            if (this.validating) {
                this.validate(messageHeaderResponseRequest);
            }
            return messageHeaderResponseRequest;
        }

        protected void validate(MessageHeaderResponseRequest messageHeaderResponseRequest) {
            super.validate(messageHeaderResponseRequest);
        }

        protected Builder from(MessageHeaderResponseRequest messageHeaderResponseRequest) {
            super.from(messageHeaderResponseRequest);
            return this;
        }
    }
}

