/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/request-status")
public class NutritionOrderStatus
extends Code {
    public static final NutritionOrderStatus DRAFT = NutritionOrderStatus.builder().value(Value.DRAFT).build();
    public static final NutritionOrderStatus ACTIVE = NutritionOrderStatus.builder().value(Value.ACTIVE).build();
    public static final NutritionOrderStatus ON_HOLD = NutritionOrderStatus.builder().value(Value.ON_HOLD).build();
    public static final NutritionOrderStatus REVOKED = NutritionOrderStatus.builder().value(Value.REVOKED).build();
    public static final NutritionOrderStatus COMPLETED = NutritionOrderStatus.builder().value(Value.COMPLETED).build();
    public static final NutritionOrderStatus ENTERED_IN_ERROR = NutritionOrderStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final NutritionOrderStatus UNKNOWN = NutritionOrderStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private NutritionOrderStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static NutritionOrderStatus of(Value value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case REVOKED: {
                return REVOKED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static NutritionOrderStatus of(java.lang.String value) {
        return NutritionOrderStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return NutritionOrderStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return NutritionOrderStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutritionOrderStatus other = (NutritionOrderStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DRAFT("draft"),
        ACTIVE("active"),
        ON_HOLD("on-hold"),
        REVOKED("revoked"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "draft": {
                    return DRAFT;
                }
                case "active": {
                    return ACTIVE;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "revoked": {
                    return REVOKED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public NutritionOrderStatus build() {
            NutritionOrderStatus nutritionOrderStatus = new NutritionOrderStatus(this);
            if (this.validating) {
                this.validate(nutritionOrderStatus);
            }
            return nutritionOrderStatus;
        }

        protected void validate(NutritionOrderStatus nutritionOrderStatus) {
            super.validate(nutritionOrderStatus);
        }

        protected Builder from(NutritionOrderStatus nutritionOrderStatus) {
            super.from(nutritionOrderStatus);
            return this;
        }
    }
}

