/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/map-source-list-mode")
public class StructureMapSourceListMode
extends Code {
    public static final StructureMapSourceListMode FIRST = StructureMapSourceListMode.builder().value(Value.FIRST).build();
    public static final StructureMapSourceListMode NOT_FIRST = StructureMapSourceListMode.builder().value(Value.NOT_FIRST).build();
    public static final StructureMapSourceListMode LAST = StructureMapSourceListMode.builder().value(Value.LAST).build();
    public static final StructureMapSourceListMode NOT_LAST = StructureMapSourceListMode.builder().value(Value.NOT_LAST).build();
    public static final StructureMapSourceListMode ONLY_ONE = StructureMapSourceListMode.builder().value(Value.ONLY_ONE).build();
    private volatile int hashCode;

    private StructureMapSourceListMode(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static StructureMapSourceListMode of(Value value) {
        switch (value) {
            case FIRST: {
                return FIRST;
            }
            case NOT_FIRST: {
                return NOT_FIRST;
            }
            case LAST: {
                return LAST;
            }
            case NOT_LAST: {
                return NOT_LAST;
            }
            case ONLY_ONE: {
                return ONLY_ONE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapSourceListMode of(java.lang.String value) {
        return StructureMapSourceListMode.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return StructureMapSourceListMode.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return StructureMapSourceListMode.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapSourceListMode other = (StructureMapSourceListMode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        FIRST("first"),
        NOT_FIRST("not_first"),
        LAST("last"),
        NOT_LAST("not_last"),
        ONLY_ONE("only_one");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "first": {
                    return FIRST;
                }
                case "not_first": {
                    return NOT_FIRST;
                }
                case "last": {
                    return LAST;
                }
                case "not_last": {
                    return NOT_LAST;
                }
                case "only_one": {
                    return ONLY_ONE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StructureMapSourceListMode build() {
            StructureMapSourceListMode structureMapSourceListMode = new StructureMapSourceListMode(this);
            if (this.validating) {
                this.validate(structureMapSourceListMode);
            }
            return structureMapSourceListMode;
        }

        protected void validate(StructureMapSourceListMode structureMapSourceListMode) {
            super.validate(structureMapSourceListMode);
        }

        protected Builder from(StructureMapSourceListMode structureMapSourceListMode) {
            super.from(structureMapSourceListMode);
            return this;
        }
    }
}

