/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/restful-interaction")
public class SystemRestfulInteraction
extends Code {
    public static final SystemRestfulInteraction TRANSACTION = SystemRestfulInteraction.builder().value(Value.TRANSACTION).build();
    public static final SystemRestfulInteraction BATCH = SystemRestfulInteraction.builder().value(Value.BATCH).build();
    public static final SystemRestfulInteraction SEARCH_SYSTEM = SystemRestfulInteraction.builder().value(Value.SEARCH_SYSTEM).build();
    public static final SystemRestfulInteraction HISTORY_SYSTEM = SystemRestfulInteraction.builder().value(Value.HISTORY_SYSTEM).build();
    private volatile int hashCode;

    private SystemRestfulInteraction(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SystemRestfulInteraction of(Value value) {
        switch (value) {
            case TRANSACTION: {
                return TRANSACTION;
            }
            case BATCH: {
                return BATCH;
            }
            case SEARCH_SYSTEM: {
                return SEARCH_SYSTEM;
            }
            case HISTORY_SYSTEM: {
                return HISTORY_SYSTEM;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SystemRestfulInteraction of(java.lang.String value) {
        return SystemRestfulInteraction.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SystemRestfulInteraction.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SystemRestfulInteraction.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemRestfulInteraction other = (SystemRestfulInteraction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        TRANSACTION("transaction"),
        BATCH("batch"),
        SEARCH_SYSTEM("search-system"),
        HISTORY_SYSTEM("history-system");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "transaction": {
                    return TRANSACTION;
                }
                case "batch": {
                    return BATCH;
                }
                case "search-system": {
                    return SEARCH_SYSTEM;
                }
                case "history-system": {
                    return HISTORY_SYSTEM;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SystemRestfulInteraction build() {
            SystemRestfulInteraction systemRestfulInteraction = new SystemRestfulInteraction(this);
            if (this.validating) {
                this.validate(systemRestfulInteraction);
            }
            return systemRestfulInteraction;
        }

        protected void validate(SystemRestfulInteraction systemRestfulInteraction) {
            super.validate(systemRestfulInteraction);
        }

        protected Builder from(SystemRestfulInteraction systemRestfulInteraction) {
            super.from(systemRestfulInteraction);
            return this;
        }
    }
}

