/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.model.visitor.DefaultVisitor;
import com.ibm.fhir.model.visitor.Visitable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CollectingVisitor<T>
extends DefaultVisitor {
    protected final List<T> result = new ArrayList<T>();
    protected final Class<T> type;

    public CollectingVisitor(Class<T> type) {
        super(true);
        this.type = type;
    }

    protected void collect(Object object) {
        if (this.type.isInstance(object)) {
            this.result.add(this.type.cast(object));
        }
    }

    public List<T> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    @Override
    public boolean visit(String elementName, int elementIndex, Visitable visitable) {
        this.collect(visitable);
        return true;
    }

    @Override
    public void visit(String elementName, byte[] value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, BigDecimal value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, Boolean value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, Integer value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, LocalDate value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, LocalTime value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, String value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, Year value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, YearMonth value) {
        this.collect(value);
    }

    @Override
    public void visit(String elementName, ZonedDateTime value) {
        this.collect(value);
    }
}

