/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.parser;

import com.ibm.fhir.model.parser.FHIRParser;
import com.ibm.fhir.model.parser.exception.FHIRParserException;
import com.ibm.fhir.model.resource.Resource;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class FHIRAbstractParser
implements FHIRParser {
    protected Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public abstract <T extends Resource> T parse(InputStream var1) throws FHIRParserException;

    @Override
    public abstract <T extends Resource> T parse(Reader var1) throws FHIRParserException;

    @Override
    public void setProperty(String name, Object value) {
        Objects.requireNonNull(name);
        if (!this.isPropertySupported(name)) {
            throw new IllegalArgumentException("Property: " + name + " is not supported.");
        }
        this.properties.put(name, Objects.requireNonNull(value));
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(Objects.requireNonNull(name));
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        return Objects.requireNonNull(type).cast(this.getProperty(name));
    }

    @Override
    public Object getPropertyOrDefault(String name, Object defaultValue) {
        return this.properties.getOrDefault(Objects.requireNonNull(name), Objects.requireNonNull(defaultValue));
    }

    @Override
    public <T> T getPropertyOrDefault(String name, T defaultValue, Class<T> type) {
        return Objects.requireNonNull(type).cast(this.getPropertyOrDefault(name, defaultValue));
    }

    @Override
    public boolean isPropertySupported(String name) {
        return false;
    }

    @Override
    public <T extends FHIRParser> T as(Class<T> parserClass) {
        return (T)((FHIRParser)parserClass.cast(this));
    }
}

