/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.parser;

import com.ibm.fhir.model.parser.FHIRAbstractParser;
import com.ibm.fhir.model.parser.exception.FHIRParserException;
import com.ibm.fhir.model.resource.Account;
import com.ibm.fhir.model.resource.ActivityDefinition;
import com.ibm.fhir.model.resource.AdverseEvent;
import com.ibm.fhir.model.resource.AllergyIntolerance;
import com.ibm.fhir.model.resource.Appointment;
import com.ibm.fhir.model.resource.AppointmentResponse;
import com.ibm.fhir.model.resource.AuditEvent;
import com.ibm.fhir.model.resource.Basic;
import com.ibm.fhir.model.resource.Binary;
import com.ibm.fhir.model.resource.BiologicallyDerivedProduct;
import com.ibm.fhir.model.resource.BodyStructure;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.CapabilityStatement;
import com.ibm.fhir.model.resource.CarePlan;
import com.ibm.fhir.model.resource.CareTeam;
import com.ibm.fhir.model.resource.CatalogEntry;
import com.ibm.fhir.model.resource.ChargeItem;
import com.ibm.fhir.model.resource.ChargeItemDefinition;
import com.ibm.fhir.model.resource.Claim;
import com.ibm.fhir.model.resource.ClaimResponse;
import com.ibm.fhir.model.resource.ClinicalImpression;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.Communication;
import com.ibm.fhir.model.resource.CommunicationRequest;
import com.ibm.fhir.model.resource.CompartmentDefinition;
import com.ibm.fhir.model.resource.Composition;
import com.ibm.fhir.model.resource.ConceptMap;
import com.ibm.fhir.model.resource.Condition;
import com.ibm.fhir.model.resource.Consent;
import com.ibm.fhir.model.resource.Contract;
import com.ibm.fhir.model.resource.Coverage;
import com.ibm.fhir.model.resource.CoverageEligibilityRequest;
import com.ibm.fhir.model.resource.CoverageEligibilityResponse;
import com.ibm.fhir.model.resource.DetectedIssue;
import com.ibm.fhir.model.resource.Device;
import com.ibm.fhir.model.resource.DeviceDefinition;
import com.ibm.fhir.model.resource.DeviceMetric;
import com.ibm.fhir.model.resource.DeviceRequest;
import com.ibm.fhir.model.resource.DeviceUseStatement;
import com.ibm.fhir.model.resource.DiagnosticReport;
import com.ibm.fhir.model.resource.DocumentManifest;
import com.ibm.fhir.model.resource.DocumentReference;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.EffectEvidenceSynthesis;
import com.ibm.fhir.model.resource.Encounter;
import com.ibm.fhir.model.resource.Endpoint;
import com.ibm.fhir.model.resource.EnrollmentRequest;
import com.ibm.fhir.model.resource.EnrollmentResponse;
import com.ibm.fhir.model.resource.EpisodeOfCare;
import com.ibm.fhir.model.resource.EventDefinition;
import com.ibm.fhir.model.resource.Evidence;
import com.ibm.fhir.model.resource.EvidenceVariable;
import com.ibm.fhir.model.resource.ExampleScenario;
import com.ibm.fhir.model.resource.ExplanationOfBenefit;
import com.ibm.fhir.model.resource.FamilyMemberHistory;
import com.ibm.fhir.model.resource.Flag;
import com.ibm.fhir.model.resource.Goal;
import com.ibm.fhir.model.resource.GraphDefinition;
import com.ibm.fhir.model.resource.Group;
import com.ibm.fhir.model.resource.GuidanceResponse;
import com.ibm.fhir.model.resource.HealthcareService;
import com.ibm.fhir.model.resource.ImagingStudy;
import com.ibm.fhir.model.resource.Immunization;
import com.ibm.fhir.model.resource.ImmunizationEvaluation;
import com.ibm.fhir.model.resource.ImmunizationRecommendation;
import com.ibm.fhir.model.resource.ImplementationGuide;
import com.ibm.fhir.model.resource.InsurancePlan;
import com.ibm.fhir.model.resource.Invoice;
import com.ibm.fhir.model.resource.Library;
import com.ibm.fhir.model.resource.Linkage;
import com.ibm.fhir.model.resource.List;
import com.ibm.fhir.model.resource.Location;
import com.ibm.fhir.model.resource.Measure;
import com.ibm.fhir.model.resource.MeasureReport;
import com.ibm.fhir.model.resource.Media;
import com.ibm.fhir.model.resource.Medication;
import com.ibm.fhir.model.resource.MedicationAdministration;
import com.ibm.fhir.model.resource.MedicationDispense;
import com.ibm.fhir.model.resource.MedicationKnowledge;
import com.ibm.fhir.model.resource.MedicationRequest;
import com.ibm.fhir.model.resource.MedicationStatement;
import com.ibm.fhir.model.resource.MedicinalProduct;
import com.ibm.fhir.model.resource.MedicinalProductAuthorization;
import com.ibm.fhir.model.resource.MedicinalProductContraindication;
import com.ibm.fhir.model.resource.MedicinalProductIndication;
import com.ibm.fhir.model.resource.MedicinalProductIngredient;
import com.ibm.fhir.model.resource.MedicinalProductInteraction;
import com.ibm.fhir.model.resource.MedicinalProductManufactured;
import com.ibm.fhir.model.resource.MedicinalProductPackaged;
import com.ibm.fhir.model.resource.MedicinalProductPharmaceutical;
import com.ibm.fhir.model.resource.MedicinalProductUndesirableEffect;
import com.ibm.fhir.model.resource.MessageDefinition;
import com.ibm.fhir.model.resource.MessageHeader;
import com.ibm.fhir.model.resource.MolecularSequence;
import com.ibm.fhir.model.resource.NamingSystem;
import com.ibm.fhir.model.resource.NutritionOrder;
import com.ibm.fhir.model.resource.Observation;
import com.ibm.fhir.model.resource.ObservationDefinition;
import com.ibm.fhir.model.resource.OperationDefinition;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.Organization;
import com.ibm.fhir.model.resource.OrganizationAffiliation;
import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.resource.Patient;
import com.ibm.fhir.model.resource.PaymentNotice;
import com.ibm.fhir.model.resource.PaymentReconciliation;
import com.ibm.fhir.model.resource.Person;
import com.ibm.fhir.model.resource.PlanDefinition;
import com.ibm.fhir.model.resource.Practitioner;
import com.ibm.fhir.model.resource.PractitionerRole;
import com.ibm.fhir.model.resource.Procedure;
import com.ibm.fhir.model.resource.Provenance;
import com.ibm.fhir.model.resource.Questionnaire;
import com.ibm.fhir.model.resource.QuestionnaireResponse;
import com.ibm.fhir.model.resource.RelatedPerson;
import com.ibm.fhir.model.resource.RequestGroup;
import com.ibm.fhir.model.resource.ResearchDefinition;
import com.ibm.fhir.model.resource.ResearchElementDefinition;
import com.ibm.fhir.model.resource.ResearchStudy;
import com.ibm.fhir.model.resource.ResearchSubject;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.RiskAssessment;
import com.ibm.fhir.model.resource.RiskEvidenceSynthesis;
import com.ibm.fhir.model.resource.Schedule;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.ServiceRequest;
import com.ibm.fhir.model.resource.Slot;
import com.ibm.fhir.model.resource.Specimen;
import com.ibm.fhir.model.resource.SpecimenDefinition;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.model.resource.StructureMap;
import com.ibm.fhir.model.resource.Subscription;
import com.ibm.fhir.model.resource.Substance;
import com.ibm.fhir.model.resource.SubstanceNucleicAcid;
import com.ibm.fhir.model.resource.SubstancePolymer;
import com.ibm.fhir.model.resource.SubstanceProtein;
import com.ibm.fhir.model.resource.SubstanceReferenceInformation;
import com.ibm.fhir.model.resource.SubstanceSourceMaterial;
import com.ibm.fhir.model.resource.SubstanceSpecification;
import com.ibm.fhir.model.resource.SupplyDelivery;
import com.ibm.fhir.model.resource.SupplyRequest;
import com.ibm.fhir.model.resource.Task;
import com.ibm.fhir.model.resource.TerminologyCapabilities;
import com.ibm.fhir.model.resource.TestReport;
import com.ibm.fhir.model.resource.TestScript;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.resource.VerificationResult;
import com.ibm.fhir.model.resource.VisionPrescription;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.ElementDefinition;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.MoneyQuantity;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.SubstanceAmount;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.Xhtml;
import com.ibm.fhir.model.type.code.AccountStatus;
import com.ibm.fhir.model.type.code.ActionCardinalityBehavior;
import com.ibm.fhir.model.type.code.ActionConditionKind;
import com.ibm.fhir.model.type.code.ActionGroupingBehavior;
import com.ibm.fhir.model.type.code.ActionParticipantType;
import com.ibm.fhir.model.type.code.ActionPrecheckBehavior;
import com.ibm.fhir.model.type.code.ActionRelationshipType;
import com.ibm.fhir.model.type.code.ActionRequiredBehavior;
import com.ibm.fhir.model.type.code.ActionSelectionBehavior;
import com.ibm.fhir.model.type.code.ActivityDefinitionKind;
import com.ibm.fhir.model.type.code.ActivityParticipantType;
import com.ibm.fhir.model.type.code.AddressType;
import com.ibm.fhir.model.type.code.AddressUse;
import com.ibm.fhir.model.type.code.AdministrativeGender;
import com.ibm.fhir.model.type.code.AdverseEventActuality;
import com.ibm.fhir.model.type.code.AggregationMode;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCategory;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCriticality;
import com.ibm.fhir.model.type.code.AllergyIntoleranceSeverity;
import com.ibm.fhir.model.type.code.AllergyIntoleranceType;
import com.ibm.fhir.model.type.code.AppointmentStatus;
import com.ibm.fhir.model.type.code.AssertionDirectionType;
import com.ibm.fhir.model.type.code.AssertionOperatorType;
import com.ibm.fhir.model.type.code.AssertionResponseTypes;
import com.ibm.fhir.model.type.code.AuditEventAction;
import com.ibm.fhir.model.type.code.AuditEventAgentNetworkType;
import com.ibm.fhir.model.type.code.AuditEventOutcome;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductCategory;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStatus;
import com.ibm.fhir.model.type.code.BiologicallyDerivedProductStorageScale;
import com.ibm.fhir.model.type.code.BundleType;
import com.ibm.fhir.model.type.code.CapabilityStatementKind;
import com.ibm.fhir.model.type.code.CarePlanActivityKind;
import com.ibm.fhir.model.type.code.CarePlanActivityStatus;
import com.ibm.fhir.model.type.code.CarePlanIntent;
import com.ibm.fhir.model.type.code.CarePlanStatus;
import com.ibm.fhir.model.type.code.CareTeamStatus;
import com.ibm.fhir.model.type.code.CatalogEntryRelationType;
import com.ibm.fhir.model.type.code.ChargeItemDefinitionPriceComponentType;
import com.ibm.fhir.model.type.code.ChargeItemStatus;
import com.ibm.fhir.model.type.code.ClaimResponseStatus;
import com.ibm.fhir.model.type.code.ClaimStatus;
import com.ibm.fhir.model.type.code.ClinicalImpressionStatus;
import com.ibm.fhir.model.type.code.CodeSearchSupport;
import com.ibm.fhir.model.type.code.CodeSystemContentMode;
import com.ibm.fhir.model.type.code.CodeSystemHierarchyMeaning;
import com.ibm.fhir.model.type.code.CommunicationPriority;
import com.ibm.fhir.model.type.code.CommunicationRequestStatus;
import com.ibm.fhir.model.type.code.CommunicationStatus;
import com.ibm.fhir.model.type.code.CompartmentCode;
import com.ibm.fhir.model.type.code.CompartmentType;
import com.ibm.fhir.model.type.code.CompositionAttestationMode;
import com.ibm.fhir.model.type.code.CompositionStatus;
import com.ibm.fhir.model.type.code.ConceptMapEquivalence;
import com.ibm.fhir.model.type.code.ConceptMapGroupUnmappedMode;
import com.ibm.fhir.model.type.code.ConditionalDeleteStatus;
import com.ibm.fhir.model.type.code.ConditionalReadStatus;
import com.ibm.fhir.model.type.code.ConsentDataMeaning;
import com.ibm.fhir.model.type.code.ConsentProvisionType;
import com.ibm.fhir.model.type.code.ConsentState;
import com.ibm.fhir.model.type.code.ConstraintSeverity;
import com.ibm.fhir.model.type.code.ContactPointSystem;
import com.ibm.fhir.model.type.code.ContactPointUse;
import com.ibm.fhir.model.type.code.ContractPublicationStatus;
import com.ibm.fhir.model.type.code.ContractStatus;
import com.ibm.fhir.model.type.code.ContributorType;
import com.ibm.fhir.model.type.code.CoverageStatus;
import com.ibm.fhir.model.type.code.DayOfWeek;
import com.ibm.fhir.model.type.code.DaysOfWeek;
import com.ibm.fhir.model.type.code.DetectedIssueSeverity;
import com.ibm.fhir.model.type.code.DetectedIssueStatus;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationState;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationType;
import com.ibm.fhir.model.type.code.DeviceMetricCategory;
import com.ibm.fhir.model.type.code.DeviceMetricColor;
import com.ibm.fhir.model.type.code.DeviceMetricOperationalStatus;
import com.ibm.fhir.model.type.code.DeviceNameType;
import com.ibm.fhir.model.type.code.DeviceRequestStatus;
import com.ibm.fhir.model.type.code.DeviceUseStatementStatus;
import com.ibm.fhir.model.type.code.DiagnosticReportStatus;
import com.ibm.fhir.model.type.code.DiscriminatorType;
import com.ibm.fhir.model.type.code.DocumentConfidentiality;
import com.ibm.fhir.model.type.code.DocumentMode;
import com.ibm.fhir.model.type.code.DocumentReferenceStatus;
import com.ibm.fhir.model.type.code.DocumentRelationshipType;
import com.ibm.fhir.model.type.code.EligibilityRequestPurpose;
import com.ibm.fhir.model.type.code.EligibilityRequestStatus;
import com.ibm.fhir.model.type.code.EligibilityResponsePurpose;
import com.ibm.fhir.model.type.code.EligibilityResponseStatus;
import com.ibm.fhir.model.type.code.EnableWhenBehavior;
import com.ibm.fhir.model.type.code.EncounterLocationStatus;
import com.ibm.fhir.model.type.code.EncounterStatus;
import com.ibm.fhir.model.type.code.EndpointStatus;
import com.ibm.fhir.model.type.code.EnrollmentRequestStatus;
import com.ibm.fhir.model.type.code.EnrollmentResponseStatus;
import com.ibm.fhir.model.type.code.EpisodeOfCareStatus;
import com.ibm.fhir.model.type.code.EventCapabilityMode;
import com.ibm.fhir.model.type.code.EventTiming;
import com.ibm.fhir.model.type.code.EvidenceVariableType;
import com.ibm.fhir.model.type.code.ExampleScenarioActorType;
import com.ibm.fhir.model.type.code.ExplanationOfBenefitStatus;
import com.ibm.fhir.model.type.code.ExposureState;
import com.ibm.fhir.model.type.code.ExtensionContextType;
import com.ibm.fhir.model.type.code.FHIRAllTypes;
import com.ibm.fhir.model.type.code.FHIRDefinedType;
import com.ibm.fhir.model.type.code.FHIRDeviceStatus;
import com.ibm.fhir.model.type.code.FHIRResourceType;
import com.ibm.fhir.model.type.code.FHIRSubstanceStatus;
import com.ibm.fhir.model.type.code.FHIRVersion;
import com.ibm.fhir.model.type.code.FamilyHistoryStatus;
import com.ibm.fhir.model.type.code.FilterOperator;
import com.ibm.fhir.model.type.code.FlagStatus;
import com.ibm.fhir.model.type.code.GoalLifecycleStatus;
import com.ibm.fhir.model.type.code.GraphCompartmentRule;
import com.ibm.fhir.model.type.code.GraphCompartmentUse;
import com.ibm.fhir.model.type.code.GroupMeasure;
import com.ibm.fhir.model.type.code.GroupType;
import com.ibm.fhir.model.type.code.GuidanceResponseStatus;
import com.ibm.fhir.model.type.code.GuidePageGeneration;
import com.ibm.fhir.model.type.code.GuideParameterCode;
import com.ibm.fhir.model.type.code.HTTPVerb;
import com.ibm.fhir.model.type.code.IdentifierUse;
import com.ibm.fhir.model.type.code.IdentityAssuranceLevel;
import com.ibm.fhir.model.type.code.ImagingStudyStatus;
import com.ibm.fhir.model.type.code.ImmunizationEvaluationStatus;
import com.ibm.fhir.model.type.code.ImmunizationStatus;
import com.ibm.fhir.model.type.code.InvoicePriceComponentType;
import com.ibm.fhir.model.type.code.InvoiceStatus;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.model.type.code.IssueType;
import com.ibm.fhir.model.type.code.LinkType;
import com.ibm.fhir.model.type.code.LinkageType;
import com.ibm.fhir.model.type.code.ListMode;
import com.ibm.fhir.model.type.code.ListStatus;
import com.ibm.fhir.model.type.code.LocationMode;
import com.ibm.fhir.model.type.code.LocationStatus;
import com.ibm.fhir.model.type.code.MeasureReportStatus;
import com.ibm.fhir.model.type.code.MeasureReportType;
import com.ibm.fhir.model.type.code.MediaStatus;
import com.ibm.fhir.model.type.code.MedicationAdministrationStatus;
import com.ibm.fhir.model.type.code.MedicationDispenseStatus;
import com.ibm.fhir.model.type.code.MedicationKnowledgeStatus;
import com.ibm.fhir.model.type.code.MedicationRequestIntent;
import com.ibm.fhir.model.type.code.MedicationRequestPriority;
import com.ibm.fhir.model.type.code.MedicationRequestStatus;
import com.ibm.fhir.model.type.code.MedicationStatementStatus;
import com.ibm.fhir.model.type.code.MedicationStatus;
import com.ibm.fhir.model.type.code.MessageHeaderResponseRequest;
import com.ibm.fhir.model.type.code.MessageSignificanceCategory;
import com.ibm.fhir.model.type.code.NameUse;
import com.ibm.fhir.model.type.code.NamingSystemIdentifierType;
import com.ibm.fhir.model.type.code.NamingSystemType;
import com.ibm.fhir.model.type.code.NarrativeStatus;
import com.ibm.fhir.model.type.code.NoteType;
import com.ibm.fhir.model.type.code.NutritionOrderIntent;
import com.ibm.fhir.model.type.code.NutritionOrderStatus;
import com.ibm.fhir.model.type.code.ObservationDataType;
import com.ibm.fhir.model.type.code.ObservationRangeCategory;
import com.ibm.fhir.model.type.code.ObservationStatus;
import com.ibm.fhir.model.type.code.OperationKind;
import com.ibm.fhir.model.type.code.OperationParameterUse;
import com.ibm.fhir.model.type.code.OrientationType;
import com.ibm.fhir.model.type.code.ParameterUse;
import com.ibm.fhir.model.type.code.ParticipantRequired;
import com.ibm.fhir.model.type.code.ParticipantStatus;
import com.ibm.fhir.model.type.code.ParticipationStatus;
import com.ibm.fhir.model.type.code.PaymentNoticeStatus;
import com.ibm.fhir.model.type.code.PaymentReconciliationStatus;
import com.ibm.fhir.model.type.code.ProcedureStatus;
import com.ibm.fhir.model.type.code.PropertyRepresentation;
import com.ibm.fhir.model.type.code.PropertyType;
import com.ibm.fhir.model.type.code.ProvenanceEntityRole;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.QualityType;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.type.code.QuestionnaireItemOperator;
import com.ibm.fhir.model.type.code.QuestionnaireItemType;
import com.ibm.fhir.model.type.code.QuestionnaireResponseStatus;
import com.ibm.fhir.model.type.code.ReferenceHandlingPolicy;
import com.ibm.fhir.model.type.code.ReferenceVersionRules;
import com.ibm.fhir.model.type.code.ReferredDocumentStatus;
import com.ibm.fhir.model.type.code.RelatedArtifactType;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.RepositoryType;
import com.ibm.fhir.model.type.code.RequestIntent;
import com.ibm.fhir.model.type.code.RequestPriority;
import com.ibm.fhir.model.type.code.RequestStatus;
import com.ibm.fhir.model.type.code.ResearchElementType;
import com.ibm.fhir.model.type.code.ResearchStudyStatus;
import com.ibm.fhir.model.type.code.ResearchSubjectStatus;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.ResourceVersionPolicy;
import com.ibm.fhir.model.type.code.ResponseType;
import com.ibm.fhir.model.type.code.RestfulCapabilityMode;
import com.ibm.fhir.model.type.code.RiskAssessmentStatus;
import com.ibm.fhir.model.type.code.SPDXLicense;
import com.ibm.fhir.model.type.code.SearchComparator;
import com.ibm.fhir.model.type.code.SearchEntryMode;
import com.ibm.fhir.model.type.code.SearchModifierCode;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.type.code.SectionMode;
import com.ibm.fhir.model.type.code.SequenceType;
import com.ibm.fhir.model.type.code.ServiceRequestIntent;
import com.ibm.fhir.model.type.code.ServiceRequestPriority;
import com.ibm.fhir.model.type.code.ServiceRequestStatus;
import com.ibm.fhir.model.type.code.SlicingRules;
import com.ibm.fhir.model.type.code.SlotStatus;
import com.ibm.fhir.model.type.code.SortDirection;
import com.ibm.fhir.model.type.code.SpecimenContainedPreference;
import com.ibm.fhir.model.type.code.SpecimenStatus;
import com.ibm.fhir.model.type.code.Status;
import com.ibm.fhir.model.type.code.StrandType;
import com.ibm.fhir.model.type.code.StructureDefinitionKind;
import com.ibm.fhir.model.type.code.StructureMapContextType;
import com.ibm.fhir.model.type.code.StructureMapGroupTypeMode;
import com.ibm.fhir.model.type.code.StructureMapInputMode;
import com.ibm.fhir.model.type.code.StructureMapModelMode;
import com.ibm.fhir.model.type.code.StructureMapSourceListMode;
import com.ibm.fhir.model.type.code.StructureMapTargetListMode;
import com.ibm.fhir.model.type.code.StructureMapTransform;
import com.ibm.fhir.model.type.code.SubscriptionChannelType;
import com.ibm.fhir.model.type.code.SubscriptionStatus;
import com.ibm.fhir.model.type.code.SupplyDeliveryStatus;
import com.ibm.fhir.model.type.code.SupplyRequestStatus;
import com.ibm.fhir.model.type.code.SystemRestfulInteraction;
import com.ibm.fhir.model.type.code.TaskIntent;
import com.ibm.fhir.model.type.code.TaskPriority;
import com.ibm.fhir.model.type.code.TaskStatus;
import com.ibm.fhir.model.type.code.TestReportActionResult;
import com.ibm.fhir.model.type.code.TestReportParticipantType;
import com.ibm.fhir.model.type.code.TestReportResult;
import com.ibm.fhir.model.type.code.TestReportStatus;
import com.ibm.fhir.model.type.code.TestScriptRequestMethodCode;
import com.ibm.fhir.model.type.code.TriggerType;
import com.ibm.fhir.model.type.code.TypeDerivationRule;
import com.ibm.fhir.model.type.code.TypeRestfulInteraction;
import com.ibm.fhir.model.type.code.UDIEntryType;
import com.ibm.fhir.model.type.code.UnitsOfTime;
import com.ibm.fhir.model.type.code.Use;
import com.ibm.fhir.model.type.code.VariableType;
import com.ibm.fhir.model.type.code.VisionBase;
import com.ibm.fhir.model.type.code.VisionEyes;
import com.ibm.fhir.model.type.code.VisionStatus;
import com.ibm.fhir.model.type.code.XPathUsageType;
import com.ibm.fhir.model.util.ElementFilter;
import com.ibm.fhir.model.util.JsonSupport;
import com.ibm.fhir.model.util.ModelSupport;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Stack;
import java.util.StringJoiner;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class FHIRJsonParser
extends FHIRAbstractParser {
    public static boolean DEBUG = false;
    private static final JsonReaderFactory JSON_READER_FACTORY = Json.createReaderFactory(null);
    private final Stack<String> stack = new Stack();

    FHIRJsonParser() {
    }

    @Override
    public <T extends Resource> T parse(InputStream in) throws FHIRParserException {
        return this.parseAndFilter(in, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Resource> T parseAndFilter(InputStream in, Collection<String> elementsToInclude) throws FHIRParserException {
        try (JsonReader jsonReader = JSON_READER_FACTORY.createReader(JsonSupport.nonClosingInputStream(in), StandardCharsets.UTF_8);){
            JsonObject jsonObject = jsonReader.readObject();
            T t = this.parseAndFilter(jsonObject, elementsToInclude);
            return t;
        }
        catch (FHIRParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    @Override
    public <T extends Resource> T parse(Reader reader) throws FHIRParserException {
        return this.parseAndFilter(reader, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Resource> T parseAndFilter(Reader reader, Collection<String> elementsToInclude) throws FHIRParserException {
        try (JsonReader jsonReader = JSON_READER_FACTORY.createReader(JsonSupport.nonClosingReader(reader));){
            JsonObject jsonObject = jsonReader.readObject();
            T t = this.parseAndFilter(jsonObject, elementsToInclude);
            return t;
        }
        catch (FHIRParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    public <T extends Resource> T parse(JsonObject jsonObject) throws FHIRParserException {
        return this.parseAndFilter(jsonObject, null);
    }

    public <T extends Resource> T parseAndFilter(JsonObject jsonObject, Collection<String> elementsToInclude) throws FHIRParserException {
        try {
            this.reset();
            Class<?> resourceType = JsonSupport.getResourceType(jsonObject);
            if (elementsToInclude != null) {
                ElementFilter elementFilter = new ElementFilter(resourceType, elementsToInclude);
                jsonObject = elementFilter.apply(jsonObject);
            }
            return (T)this.parseResource(resourceType.getSimpleName(), jsonObject, -1);
        }
        catch (Exception e) {
            throw new FHIRParserException(e.getMessage(), this.getPath(), e);
        }
    }

    private void reset() {
        this.stack.clear();
    }

    @Override
    public boolean isPropertySupported(String name) {
        return "com.ibm.fhir.model.parser.ignoreUnrecognizedElements".equals(name);
    }

    private Resource parseResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        Class<?> resourceType = JsonSupport.getResourceType(jsonObject);
        switch (resourceType.getSimpleName()) {
            case "Account": {
                return this.parseAccount(elementName, jsonObject, elementIndex);
            }
            case "ActivityDefinition": {
                return this.parseActivityDefinition(elementName, jsonObject, elementIndex);
            }
            case "AdverseEvent": {
                return this.parseAdverseEvent(elementName, jsonObject, elementIndex);
            }
            case "AllergyIntolerance": {
                return this.parseAllergyIntolerance(elementName, jsonObject, elementIndex);
            }
            case "Appointment": {
                return this.parseAppointment(elementName, jsonObject, elementIndex);
            }
            case "AppointmentResponse": {
                return this.parseAppointmentResponse(elementName, jsonObject, elementIndex);
            }
            case "AuditEvent": {
                return this.parseAuditEvent(elementName, jsonObject, elementIndex);
            }
            case "Basic": {
                return this.parseBasic(elementName, jsonObject, elementIndex);
            }
            case "Binary": {
                return this.parseBinary(elementName, jsonObject, elementIndex);
            }
            case "BiologicallyDerivedProduct": {
                return this.parseBiologicallyDerivedProduct(elementName, jsonObject, elementIndex);
            }
            case "BodyStructure": {
                return this.parseBodyStructure(elementName, jsonObject, elementIndex);
            }
            case "Bundle": {
                return this.parseBundle(elementName, jsonObject, elementIndex);
            }
            case "CapabilityStatement": {
                return this.parseCapabilityStatement(elementName, jsonObject, elementIndex);
            }
            case "CarePlan": {
                return this.parseCarePlan(elementName, jsonObject, elementIndex);
            }
            case "CareTeam": {
                return this.parseCareTeam(elementName, jsonObject, elementIndex);
            }
            case "CatalogEntry": {
                return this.parseCatalogEntry(elementName, jsonObject, elementIndex);
            }
            case "ChargeItem": {
                return this.parseChargeItem(elementName, jsonObject, elementIndex);
            }
            case "ChargeItemDefinition": {
                return this.parseChargeItemDefinition(elementName, jsonObject, elementIndex);
            }
            case "Claim": {
                return this.parseClaim(elementName, jsonObject, elementIndex);
            }
            case "ClaimResponse": {
                return this.parseClaimResponse(elementName, jsonObject, elementIndex);
            }
            case "ClinicalImpression": {
                return this.parseClinicalImpression(elementName, jsonObject, elementIndex);
            }
            case "CodeSystem": {
                return this.parseCodeSystem(elementName, jsonObject, elementIndex);
            }
            case "Communication": {
                return this.parseCommunication(elementName, jsonObject, elementIndex);
            }
            case "CommunicationRequest": {
                return this.parseCommunicationRequest(elementName, jsonObject, elementIndex);
            }
            case "CompartmentDefinition": {
                return this.parseCompartmentDefinition(elementName, jsonObject, elementIndex);
            }
            case "Composition": {
                return this.parseComposition(elementName, jsonObject, elementIndex);
            }
            case "ConceptMap": {
                return this.parseConceptMap(elementName, jsonObject, elementIndex);
            }
            case "Condition": {
                return this.parseCondition(elementName, jsonObject, elementIndex);
            }
            case "Consent": {
                return this.parseConsent(elementName, jsonObject, elementIndex);
            }
            case "Contract": {
                return this.parseContract(elementName, jsonObject, elementIndex);
            }
            case "Coverage": {
                return this.parseCoverage(elementName, jsonObject, elementIndex);
            }
            case "CoverageEligibilityRequest": {
                return this.parseCoverageEligibilityRequest(elementName, jsonObject, elementIndex);
            }
            case "CoverageEligibilityResponse": {
                return this.parseCoverageEligibilityResponse(elementName, jsonObject, elementIndex);
            }
            case "DetectedIssue": {
                return this.parseDetectedIssue(elementName, jsonObject, elementIndex);
            }
            case "Device": {
                return this.parseDevice(elementName, jsonObject, elementIndex);
            }
            case "DeviceDefinition": {
                return this.parseDeviceDefinition(elementName, jsonObject, elementIndex);
            }
            case "DeviceMetric": {
                return this.parseDeviceMetric(elementName, jsonObject, elementIndex);
            }
            case "DeviceRequest": {
                return this.parseDeviceRequest(elementName, jsonObject, elementIndex);
            }
            case "DeviceUseStatement": {
                return this.parseDeviceUseStatement(elementName, jsonObject, elementIndex);
            }
            case "DiagnosticReport": {
                return this.parseDiagnosticReport(elementName, jsonObject, elementIndex);
            }
            case "DocumentManifest": {
                return this.parseDocumentManifest(elementName, jsonObject, elementIndex);
            }
            case "DocumentReference": {
                return this.parseDocumentReference(elementName, jsonObject, elementIndex);
            }
            case "EffectEvidenceSynthesis": {
                return this.parseEffectEvidenceSynthesis(elementName, jsonObject, elementIndex);
            }
            case "Encounter": {
                return this.parseEncounter(elementName, jsonObject, elementIndex);
            }
            case "Endpoint": {
                return this.parseEndpoint(elementName, jsonObject, elementIndex);
            }
            case "EnrollmentRequest": {
                return this.parseEnrollmentRequest(elementName, jsonObject, elementIndex);
            }
            case "EnrollmentResponse": {
                return this.parseEnrollmentResponse(elementName, jsonObject, elementIndex);
            }
            case "EpisodeOfCare": {
                return this.parseEpisodeOfCare(elementName, jsonObject, elementIndex);
            }
            case "EventDefinition": {
                return this.parseEventDefinition(elementName, jsonObject, elementIndex);
            }
            case "Evidence": {
                return this.parseEvidence(elementName, jsonObject, elementIndex);
            }
            case "EvidenceVariable": {
                return this.parseEvidenceVariable(elementName, jsonObject, elementIndex);
            }
            case "ExampleScenario": {
                return this.parseExampleScenario(elementName, jsonObject, elementIndex);
            }
            case "ExplanationOfBenefit": {
                return this.parseExplanationOfBenefit(elementName, jsonObject, elementIndex);
            }
            case "FamilyMemberHistory": {
                return this.parseFamilyMemberHistory(elementName, jsonObject, elementIndex);
            }
            case "Flag": {
                return this.parseFlag(elementName, jsonObject, elementIndex);
            }
            case "Goal": {
                return this.parseGoal(elementName, jsonObject, elementIndex);
            }
            case "GraphDefinition": {
                return this.parseGraphDefinition(elementName, jsonObject, elementIndex);
            }
            case "Group": {
                return this.parseGroup(elementName, jsonObject, elementIndex);
            }
            case "GuidanceResponse": {
                return this.parseGuidanceResponse(elementName, jsonObject, elementIndex);
            }
            case "HealthcareService": {
                return this.parseHealthcareService(elementName, jsonObject, elementIndex);
            }
            case "ImagingStudy": {
                return this.parseImagingStudy(elementName, jsonObject, elementIndex);
            }
            case "Immunization": {
                return this.parseImmunization(elementName, jsonObject, elementIndex);
            }
            case "ImmunizationEvaluation": {
                return this.parseImmunizationEvaluation(elementName, jsonObject, elementIndex);
            }
            case "ImmunizationRecommendation": {
                return this.parseImmunizationRecommendation(elementName, jsonObject, elementIndex);
            }
            case "ImplementationGuide": {
                return this.parseImplementationGuide(elementName, jsonObject, elementIndex);
            }
            case "InsurancePlan": {
                return this.parseInsurancePlan(elementName, jsonObject, elementIndex);
            }
            case "Invoice": {
                return this.parseInvoice(elementName, jsonObject, elementIndex);
            }
            case "Library": {
                return this.parseLibrary(elementName, jsonObject, elementIndex);
            }
            case "Linkage": {
                return this.parseLinkage(elementName, jsonObject, elementIndex);
            }
            case "List": {
                return this.parseList(elementName, jsonObject, elementIndex);
            }
            case "Location": {
                return this.parseLocation(elementName, jsonObject, elementIndex);
            }
            case "Measure": {
                return this.parseMeasure(elementName, jsonObject, elementIndex);
            }
            case "MeasureReport": {
                return this.parseMeasureReport(elementName, jsonObject, elementIndex);
            }
            case "Media": {
                return this.parseMedia(elementName, jsonObject, elementIndex);
            }
            case "Medication": {
                return this.parseMedication(elementName, jsonObject, elementIndex);
            }
            case "MedicationAdministration": {
                return this.parseMedicationAdministration(elementName, jsonObject, elementIndex);
            }
            case "MedicationDispense": {
                return this.parseMedicationDispense(elementName, jsonObject, elementIndex);
            }
            case "MedicationKnowledge": {
                return this.parseMedicationKnowledge(elementName, jsonObject, elementIndex);
            }
            case "MedicationRequest": {
                return this.parseMedicationRequest(elementName, jsonObject, elementIndex);
            }
            case "MedicationStatement": {
                return this.parseMedicationStatement(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProduct": {
                return this.parseMedicinalProduct(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductAuthorization": {
                return this.parseMedicinalProductAuthorization(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductContraindication": {
                return this.parseMedicinalProductContraindication(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductIndication": {
                return this.parseMedicinalProductIndication(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductIngredient": {
                return this.parseMedicinalProductIngredient(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductInteraction": {
                return this.parseMedicinalProductInteraction(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductManufactured": {
                return this.parseMedicinalProductManufactured(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductPackaged": {
                return this.parseMedicinalProductPackaged(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductPharmaceutical": {
                return this.parseMedicinalProductPharmaceutical(elementName, jsonObject, elementIndex);
            }
            case "MedicinalProductUndesirableEffect": {
                return this.parseMedicinalProductUndesirableEffect(elementName, jsonObject, elementIndex);
            }
            case "MessageDefinition": {
                return this.parseMessageDefinition(elementName, jsonObject, elementIndex);
            }
            case "MessageHeader": {
                return this.parseMessageHeader(elementName, jsonObject, elementIndex);
            }
            case "MolecularSequence": {
                return this.parseMolecularSequence(elementName, jsonObject, elementIndex);
            }
            case "NamingSystem": {
                return this.parseNamingSystem(elementName, jsonObject, elementIndex);
            }
            case "NutritionOrder": {
                return this.parseNutritionOrder(elementName, jsonObject, elementIndex);
            }
            case "Observation": {
                return this.parseObservation(elementName, jsonObject, elementIndex);
            }
            case "ObservationDefinition": {
                return this.parseObservationDefinition(elementName, jsonObject, elementIndex);
            }
            case "OperationDefinition": {
                return this.parseOperationDefinition(elementName, jsonObject, elementIndex);
            }
            case "OperationOutcome": {
                return this.parseOperationOutcome(elementName, jsonObject, elementIndex);
            }
            case "Organization": {
                return this.parseOrganization(elementName, jsonObject, elementIndex);
            }
            case "OrganizationAffiliation": {
                return this.parseOrganizationAffiliation(elementName, jsonObject, elementIndex);
            }
            case "Parameters": {
                return this.parseParameters(elementName, jsonObject, elementIndex);
            }
            case "Patient": {
                return this.parsePatient(elementName, jsonObject, elementIndex);
            }
            case "PaymentNotice": {
                return this.parsePaymentNotice(elementName, jsonObject, elementIndex);
            }
            case "PaymentReconciliation": {
                return this.parsePaymentReconciliation(elementName, jsonObject, elementIndex);
            }
            case "Person": {
                return this.parsePerson(elementName, jsonObject, elementIndex);
            }
            case "PlanDefinition": {
                return this.parsePlanDefinition(elementName, jsonObject, elementIndex);
            }
            case "Practitioner": {
                return this.parsePractitioner(elementName, jsonObject, elementIndex);
            }
            case "PractitionerRole": {
                return this.parsePractitionerRole(elementName, jsonObject, elementIndex);
            }
            case "Procedure": {
                return this.parseProcedure(elementName, jsonObject, elementIndex);
            }
            case "Provenance": {
                return this.parseProvenance(elementName, jsonObject, elementIndex);
            }
            case "Questionnaire": {
                return this.parseQuestionnaire(elementName, jsonObject, elementIndex);
            }
            case "QuestionnaireResponse": {
                return this.parseQuestionnaireResponse(elementName, jsonObject, elementIndex);
            }
            case "RelatedPerson": {
                return this.parseRelatedPerson(elementName, jsonObject, elementIndex);
            }
            case "RequestGroup": {
                return this.parseRequestGroup(elementName, jsonObject, elementIndex);
            }
            case "ResearchDefinition": {
                return this.parseResearchDefinition(elementName, jsonObject, elementIndex);
            }
            case "ResearchElementDefinition": {
                return this.parseResearchElementDefinition(elementName, jsonObject, elementIndex);
            }
            case "ResearchStudy": {
                return this.parseResearchStudy(elementName, jsonObject, elementIndex);
            }
            case "ResearchSubject": {
                return this.parseResearchSubject(elementName, jsonObject, elementIndex);
            }
            case "RiskAssessment": {
                return this.parseRiskAssessment(elementName, jsonObject, elementIndex);
            }
            case "RiskEvidenceSynthesis": {
                return this.parseRiskEvidenceSynthesis(elementName, jsonObject, elementIndex);
            }
            case "Schedule": {
                return this.parseSchedule(elementName, jsonObject, elementIndex);
            }
            case "SearchParameter": {
                return this.parseSearchParameter(elementName, jsonObject, elementIndex);
            }
            case "ServiceRequest": {
                return this.parseServiceRequest(elementName, jsonObject, elementIndex);
            }
            case "Slot": {
                return this.parseSlot(elementName, jsonObject, elementIndex);
            }
            case "Specimen": {
                return this.parseSpecimen(elementName, jsonObject, elementIndex);
            }
            case "SpecimenDefinition": {
                return this.parseSpecimenDefinition(elementName, jsonObject, elementIndex);
            }
            case "StructureDefinition": {
                return this.parseStructureDefinition(elementName, jsonObject, elementIndex);
            }
            case "StructureMap": {
                return this.parseStructureMap(elementName, jsonObject, elementIndex);
            }
            case "Subscription": {
                return this.parseSubscription(elementName, jsonObject, elementIndex);
            }
            case "Substance": {
                return this.parseSubstance(elementName, jsonObject, elementIndex);
            }
            case "SubstanceNucleicAcid": {
                return this.parseSubstanceNucleicAcid(elementName, jsonObject, elementIndex);
            }
            case "SubstancePolymer": {
                return this.parseSubstancePolymer(elementName, jsonObject, elementIndex);
            }
            case "SubstanceProtein": {
                return this.parseSubstanceProtein(elementName, jsonObject, elementIndex);
            }
            case "SubstanceReferenceInformation": {
                return this.parseSubstanceReferenceInformation(elementName, jsonObject, elementIndex);
            }
            case "SubstanceSourceMaterial": {
                return this.parseSubstanceSourceMaterial(elementName, jsonObject, elementIndex);
            }
            case "SubstanceSpecification": {
                return this.parseSubstanceSpecification(elementName, jsonObject, elementIndex);
            }
            case "SupplyDelivery": {
                return this.parseSupplyDelivery(elementName, jsonObject, elementIndex);
            }
            case "SupplyRequest": {
                return this.parseSupplyRequest(elementName, jsonObject, elementIndex);
            }
            case "Task": {
                return this.parseTask(elementName, jsonObject, elementIndex);
            }
            case "TerminologyCapabilities": {
                return this.parseTerminologyCapabilities(elementName, jsonObject, elementIndex);
            }
            case "TestReport": {
                return this.parseTestReport(elementName, jsonObject, elementIndex);
            }
            case "TestScript": {
                return this.parseTestScript(elementName, jsonObject, elementIndex);
            }
            case "ValueSet": {
                return this.parseValueSet(elementName, jsonObject, elementIndex);
            }
            case "VerificationResult": {
                return this.parseVerificationResult(elementName, jsonObject, elementIndex);
            }
            case "VisionPrescription": {
                return this.parseVisionPrescription(elementName, jsonObject, elementIndex);
            }
        }
        return null;
    }

    private Account parseAccount(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Account.class, jsonObject);
        }
        Account.Builder builder = Account.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((AccountStatus)this.parseString(AccountStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i = 0; i < subjectArray.size(); ++i) {
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i), i));
            }
        }
        builder.servicePeriod(this.parsePeriod("servicePeriod", JsonSupport.getJsonValue(jsonObject, "servicePeriod", JsonObject.class), -1));
        JsonArray coverageArray = JsonSupport.getJsonArray(jsonObject, "coverage");
        if (coverageArray != null) {
            for (int i = 0; i < coverageArray.size(); ++i) {
                builder.coverage(this.parseAccountCoverage("coverage", coverageArray.getJsonObject(i), i));
            }
        }
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray guarantorArray = JsonSupport.getJsonArray(jsonObject, "guarantor");
        if (guarantorArray != null) {
            for (int i = 0; i < guarantorArray.size(); ++i) {
                builder.guarantor(this.parseAccountGuarantor("guarantor", guarantorArray.getJsonObject(i), i));
            }
        }
        builder.partOf(this.parseReference("partOf", JsonSupport.getJsonValue(jsonObject, "partOf", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Account.Coverage parseAccountCoverage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Account.Coverage.class, jsonObject);
        }
        Account.Coverage.Builder builder = Account.Coverage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.priority((PositiveInt)this.parseInteger(PositiveInt.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        this.stackPop();
        return builder.build();
    }

    private Account.Guarantor parseAccountGuarantor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Account.Guarantor.class, jsonObject);
        }
        Account.Guarantor.Builder builder = Account.Guarantor.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        builder.onHold(this.parseBoolean("onHold", JsonSupport.getJsonValue(jsonObject, "onHold", JsonValue.class), (JsonValue)jsonObject.get((Object)"_onHold"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition parseActivityDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray observationResultRequirementArray;
        JsonArray observationRequirementArray;
        JsonArray specimenRequirementArray;
        JsonArray bodySiteArray;
        int i;
        JsonArray libraryArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.class, jsonObject);
        }
        ActivityDefinition.Builder builder = ActivityDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i3 = 0; i3 < contactArray.size(); ++i3) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i3), i3));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i4 = 0; i4 < useContextArray.size(); ++i4) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i4), i4));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i5 = 0; i5 < jurisdictionArray.size(); ++i5) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i5), i5));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i6 = 0; i6 < topicArray.size(); ++i6) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i6), i6));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i7 = 0; i7 < authorArray.size(); ++i7) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i7), i7));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i8 = 0; i8 < editorArray.size(); ++i8) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i8), i8));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i9 = 0; i9 < reviewerArray.size(); ++i9) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i9), i9));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i10 = 0; i10 < endorserArray.size(); ++i10) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i10), i10));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i11 = 0; i11 < relatedArtifactArray.size(); ++i11) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i11), i11));
            }
        }
        if ((libraryArray = JsonSupport.getJsonArray(jsonObject, "library", true)) != null) {
            JsonArray _libraryArray = jsonObject.getJsonArray("_library");
            for (i = 0; i < libraryArray.size(); ++i) {
                builder.library((Canonical)this.parseUri(Canonical.builder(), "library", (JsonValue)libraryArray.get(i), JsonSupport.getJsonValue(_libraryArray, i), i));
            }
        }
        builder.kind((ActivityDefinitionKind)this.parseString(ActivityDefinitionKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Timing.class, DateTime.class, Age.class, Period.class, Range.class, Duration.class));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray participantArray = JsonSupport.getJsonArray(jsonObject, "participant");
        if (participantArray != null) {
            for (i = 0; i < participantArray.size(); ++i) {
                builder.participant(this.parseActivityDefinitionParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, Reference.class, CodeableConcept.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        JsonArray dosageArray = JsonSupport.getJsonArray(jsonObject, "dosage");
        if (dosageArray != null) {
            for (int i12 = 0; i12 < dosageArray.size(); ++i12) {
                builder.dosage(this.parseDosage("dosage", dosageArray.getJsonObject(i12), i12));
            }
        }
        if ((bodySiteArray = JsonSupport.getJsonArray(jsonObject, "bodySite")) != null) {
            for (int i13 = 0; i13 < bodySiteArray.size(); ++i13) {
                builder.bodySite(this.parseCodeableConcept("bodySite", bodySiteArray.getJsonObject(i13), i13));
            }
        }
        if ((specimenRequirementArray = JsonSupport.getJsonArray(jsonObject, "specimenRequirement")) != null) {
            for (int i14 = 0; i14 < specimenRequirementArray.size(); ++i14) {
                builder.specimenRequirement(this.parseReference("specimenRequirement", specimenRequirementArray.getJsonObject(i14), i14));
            }
        }
        if ((observationRequirementArray = JsonSupport.getJsonArray(jsonObject, "observationRequirement")) != null) {
            for (int i15 = 0; i15 < observationRequirementArray.size(); ++i15) {
                builder.observationRequirement(this.parseReference("observationRequirement", observationRequirementArray.getJsonObject(i15), i15));
            }
        }
        if ((observationResultRequirementArray = JsonSupport.getJsonArray(jsonObject, "observationResultRequirement")) != null) {
            for (int i16 = 0; i16 < observationResultRequirementArray.size(); ++i16) {
                builder.observationResultRequirement(this.parseReference("observationResultRequirement", observationResultRequirementArray.getJsonObject(i16), i16));
            }
        }
        builder.transform((Canonical)this.parseUri(Canonical.builder(), "transform", (JsonValue)JsonSupport.getJsonValue(jsonObject, "transform", JsonString.class), (JsonValue)jsonObject.get((Object)"_transform"), -1));
        JsonArray dynamicValueArray = JsonSupport.getJsonArray(jsonObject, "dynamicValue");
        if (dynamicValueArray != null) {
            for (int i17 = 0; i17 < dynamicValueArray.size(); ++i17) {
                builder.dynamicValue(this.parseActivityDefinitionDynamicValue("dynamicValue", dynamicValueArray.getJsonObject(i17), i17));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition.DynamicValue parseActivityDefinitionDynamicValue(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.DynamicValue.class, jsonObject);
        }
        ActivityDefinition.DynamicValue.Builder builder = ActivityDefinition.DynamicValue.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.expression(this.parseExpression("expression", JsonSupport.getJsonValue(jsonObject, "expression", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ActivityDefinition.Participant parseActivityDefinitionParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ActivityDefinition.Participant.class, jsonObject);
        }
        ActivityDefinition.Participant.Builder builder = ActivityDefinition.Participant.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ActivityParticipantType)this.parseString(ActivityParticipantType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Address parseAddress(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Address.class, jsonObject);
        }
        Address.Builder builder = Address.builder();
        this.parseElement(builder, jsonObject);
        builder.use((AddressUse)this.parseString(AddressUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.type((AddressType)this.parseString(AddressType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray lineArray = JsonSupport.getJsonArray(jsonObject, "line", true);
        if (lineArray != null) {
            JsonArray _lineArray = jsonObject.getJsonArray("_line");
            for (int i = 0; i < lineArray.size(); ++i) {
                builder.line(this.parseString("line", (JsonValue)lineArray.get(i), JsonSupport.getJsonValue(_lineArray, i), i));
            }
        }
        builder.city(this.parseString("city", (JsonValue)JsonSupport.getJsonValue(jsonObject, "city", JsonString.class), (JsonValue)jsonObject.get((Object)"_city"), -1));
        builder.district(this.parseString("district", (JsonValue)JsonSupport.getJsonValue(jsonObject, "district", JsonString.class), (JsonValue)jsonObject.get((Object)"_district"), -1));
        builder.state(this.parseString("state", (JsonValue)JsonSupport.getJsonValue(jsonObject, "state", JsonString.class), (JsonValue)jsonObject.get((Object)"_state"), -1));
        builder.postalCode(this.parseString("postalCode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "postalCode", JsonString.class), (JsonValue)jsonObject.get((Object)"_postalCode"), -1));
        builder.country(this.parseString("country", (JsonValue)JsonSupport.getJsonValue(jsonObject, "country", JsonString.class), (JsonValue)jsonObject.get((Object)"_country"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent parseAdverseEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray studyArray;
        JsonArray referenceDocumentArray;
        JsonArray subjectMedicalHistoryArray;
        JsonArray suspectEntityArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.class, jsonObject);
        }
        AdverseEvent.Builder builder = AdverseEvent.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.actuality((AdverseEventActuality)this.parseString(AdverseEventActuality.builder(), "actuality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "actuality", JsonString.class), (JsonValue)jsonObject.get((Object)"_actuality"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.event(this.parseCodeableConcept("event", JsonSupport.getJsonValue(jsonObject, "event", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.detected(this.parseDateTime("detected", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detected", JsonString.class), (JsonValue)jsonObject.get((Object)"_detected"), -1));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        JsonArray resultingConditionArray = JsonSupport.getJsonArray(jsonObject, "resultingCondition");
        if (resultingConditionArray != null) {
            for (int i = 0; i < resultingConditionArray.size(); ++i) {
                builder.resultingCondition(this.parseReference("resultingCondition", resultingConditionArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.seriousness(this.parseCodeableConcept("seriousness", JsonSupport.getJsonValue(jsonObject, "seriousness", JsonObject.class), -1));
        builder.severity(this.parseCodeableConcept("severity", JsonSupport.getJsonValue(jsonObject, "severity", JsonObject.class), -1));
        builder.outcome(this.parseCodeableConcept("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        JsonArray contributorArray = JsonSupport.getJsonArray(jsonObject, "contributor");
        if (contributorArray != null) {
            for (int i = 0; i < contributorArray.size(); ++i) {
                builder.contributor(this.parseReference("contributor", contributorArray.getJsonObject(i), i));
            }
        }
        if ((suspectEntityArray = JsonSupport.getJsonArray(jsonObject, "suspectEntity")) != null) {
            for (int i = 0; i < suspectEntityArray.size(); ++i) {
                builder.suspectEntity(this.parseAdverseEventSuspectEntity("suspectEntity", suspectEntityArray.getJsonObject(i), i));
            }
        }
        if ((subjectMedicalHistoryArray = JsonSupport.getJsonArray(jsonObject, "subjectMedicalHistory")) != null) {
            for (int i = 0; i < subjectMedicalHistoryArray.size(); ++i) {
                builder.subjectMedicalHistory(this.parseReference("subjectMedicalHistory", subjectMedicalHistoryArray.getJsonObject(i), i));
            }
        }
        if ((referenceDocumentArray = JsonSupport.getJsonArray(jsonObject, "referenceDocument")) != null) {
            for (int i = 0; i < referenceDocumentArray.size(); ++i) {
                builder.referenceDocument(this.parseReference("referenceDocument", referenceDocumentArray.getJsonObject(i), i));
            }
        }
        if ((studyArray = JsonSupport.getJsonArray(jsonObject, "study")) != null) {
            for (int i = 0; i < studyArray.size(); ++i) {
                builder.study(this.parseReference("study", studyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent.SuspectEntity parseAdverseEventSuspectEntity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.SuspectEntity.class, jsonObject);
        }
        AdverseEvent.SuspectEntity.Builder builder = AdverseEvent.SuspectEntity.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.instance(this.parseReference("instance", JsonSupport.getJsonValue(jsonObject, "instance", JsonObject.class), -1));
        JsonArray causalityArray = JsonSupport.getJsonArray(jsonObject, "causality");
        if (causalityArray != null) {
            for (int i = 0; i < causalityArray.size(); ++i) {
                builder.causality(this.parseAdverseEventSuspectEntityCausality("causality", causalityArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AdverseEvent.SuspectEntity.Causality parseAdverseEventSuspectEntityCausality(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AdverseEvent.SuspectEntity.Causality.class, jsonObject);
        }
        AdverseEvent.SuspectEntity.Causality.Builder builder = AdverseEvent.SuspectEntity.Causality.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.assessment(this.parseCodeableConcept("assessment", JsonSupport.getJsonValue(jsonObject, "assessment", JsonObject.class), -1));
        builder.productRelatedness(this.parseString("productRelatedness", (JsonValue)JsonSupport.getJsonValue(jsonObject, "productRelatedness", JsonString.class), (JsonValue)jsonObject.get((Object)"_productRelatedness"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AllergyIntolerance parseAllergyIntolerance(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray reactionArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AllergyIntolerance.class, jsonObject);
        }
        AllergyIntolerance.Builder builder = AllergyIntolerance.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", JsonSupport.getJsonValue(jsonObject, "clinicalStatus", JsonObject.class), -1));
        builder.verificationStatus(this.parseCodeableConcept("verificationStatus", JsonSupport.getJsonValue(jsonObject, "verificationStatus", JsonObject.class), -1));
        builder.type((AllergyIntoleranceType)this.parseString(AllergyIntoleranceType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category", true);
        if (categoryArray != null) {
            JsonArray _categoryArray = jsonObject.getJsonArray("_category");
            for (i = 0; i < categoryArray.size(); ++i) {
                builder.category((AllergyIntoleranceCategory)this.parseString(AllergyIntoleranceCategory.builder(), "category", (JsonValue)categoryArray.get(i), JsonSupport.getJsonValue(_categoryArray, i), i));
            }
        }
        builder.criticality((AllergyIntoleranceCriticality)this.parseString(AllergyIntoleranceCriticality.builder(), "criticality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "criticality", JsonString.class), (JsonValue)jsonObject.get((Object)"_criticality"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, DateTime.class, Age.class, Period.class, Range.class, com.ibm.fhir.model.type.String.class));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        builder.asserter(this.parseReference("asserter", JsonSupport.getJsonValue(jsonObject, "asserter", JsonObject.class), -1));
        builder.lastOccurrence(this.parseDateTime("lastOccurrence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastOccurrence", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastOccurrence"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((reactionArray = JsonSupport.getJsonArray(jsonObject, "reaction")) != null) {
            for (int i3 = 0; i3 < reactionArray.size(); ++i3) {
                builder.reaction(this.parseAllergyIntoleranceReaction("reaction", reactionArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AllergyIntolerance.Reaction parseAllergyIntoleranceReaction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AllergyIntolerance.Reaction.class, jsonObject);
        }
        AllergyIntolerance.Reaction.Builder builder = AllergyIntolerance.Reaction.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.substance(this.parseCodeableConcept("substance", JsonSupport.getJsonValue(jsonObject, "substance", JsonObject.class), -1));
        JsonArray manifestationArray = JsonSupport.getJsonArray(jsonObject, "manifestation");
        if (manifestationArray != null) {
            for (int i = 0; i < manifestationArray.size(); ++i) {
                builder.manifestation(this.parseCodeableConcept("manifestation", manifestationArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.onset(this.parseDateTime("onset", (JsonValue)JsonSupport.getJsonValue(jsonObject, "onset", JsonString.class), (JsonValue)jsonObject.get((Object)"_onset"), -1));
        builder.severity((AllergyIntoleranceSeverity)this.parseString(AllergyIntoleranceSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.exposureRoute(this.parseCodeableConcept("exposureRoute", JsonSupport.getJsonValue(jsonObject, "exposureRoute", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Annotation parseAnnotation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Annotation.class, jsonObject);
        }
        Annotation.Builder builder = Annotation.builder();
        this.parseElement(builder, jsonObject);
        builder.author(this.parseChoiceElement("author", jsonObject, Reference.class, com.ibm.fhir.model.type.String.class));
        builder.time(this.parseDateTime("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        builder.text((Markdown)this.parseString(Markdown.builder(), "text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Appointment parseAppointment(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray requestedPeriodArray;
        JsonArray participantArray;
        JsonArray reasonReferenceArray;
        JsonArray specialtyArray;
        JsonArray serviceTypeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Appointment.class, jsonObject);
        }
        Appointment.Builder builder = Appointment.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((AppointmentStatus)this.parseString(AppointmentStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.cancelationReason(this.parseCodeableConcept("cancelationReason", JsonSupport.getJsonValue(jsonObject, "cancelationReason", JsonObject.class), -1));
        JsonArray serviceCategoryArray = JsonSupport.getJsonArray(jsonObject, "serviceCategory");
        if (serviceCategoryArray != null) {
            for (int i = 0; i < serviceCategoryArray.size(); ++i) {
                builder.serviceCategory(this.parseCodeableConcept("serviceCategory", serviceCategoryArray.getJsonObject(i), i));
            }
        }
        if ((serviceTypeArray = JsonSupport.getJsonArray(jsonObject, "serviceType")) != null) {
            for (int i = 0; i < serviceTypeArray.size(); ++i) {
                builder.serviceType(this.parseCodeableConcept("serviceType", serviceTypeArray.getJsonObject(i), i));
            }
        }
        if ((specialtyArray = JsonSupport.getJsonArray(jsonObject, "specialty")) != null) {
            for (int i = 0; i < specialtyArray.size(); ++i) {
                builder.specialty(this.parseCodeableConcept("specialty", specialtyArray.getJsonObject(i), i));
            }
        }
        builder.appointmentType(this.parseCodeableConcept("appointmentType", JsonSupport.getJsonValue(jsonObject, "appointmentType", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        builder.priority((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation");
        if (supportingInformationArray != null) {
            for (int i = 0; i < supportingInformationArray.size(); ++i) {
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i), i));
            }
        }
        builder.start(this.parseInstant("start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.end(this.parseInstant("end", (JsonValue)JsonSupport.getJsonValue(jsonObject, "end", JsonString.class), (JsonValue)jsonObject.get((Object)"_end"), -1));
        builder.minutesDuration((PositiveInt)this.parseInteger(PositiveInt.builder(), "minutesDuration", (JsonValue)JsonSupport.getJsonValue(jsonObject, "minutesDuration", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_minutesDuration"), -1));
        JsonArray slotArray = JsonSupport.getJsonArray(jsonObject, "slot");
        if (slotArray != null) {
            for (int i = 0; i < slotArray.size(); ++i) {
                builder.slot(this.parseReference("slot", slotArray.getJsonObject(i), i));
            }
        }
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.patientInstruction(this.parseString("patientInstruction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "patientInstruction", JsonString.class), (JsonValue)jsonObject.get((Object)"_patientInstruction"), -1));
        JsonArray basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn");
        if (basedOnArray != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((participantArray = JsonSupport.getJsonArray(jsonObject, "participant")) != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                builder.participant(this.parseAppointmentParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((requestedPeriodArray = JsonSupport.getJsonArray(jsonObject, "requestedPeriod")) != null) {
            for (int i = 0; i < requestedPeriodArray.size(); ++i) {
                builder.requestedPeriod(this.parsePeriod("requestedPeriod", requestedPeriodArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Appointment.Participant parseAppointmentParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Appointment.Participant.class, jsonObject);
        }
        Appointment.Participant.Builder builder = Appointment.Participant.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        builder.required((ParticipantRequired)this.parseString(ParticipantRequired.builder(), "required", (JsonValue)JsonSupport.getJsonValue(jsonObject, "required", JsonString.class), (JsonValue)jsonObject.get((Object)"_required"), -1));
        builder.status((ParticipationStatus)this.parseString(ParticipationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private AppointmentResponse parseAppointmentResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AppointmentResponse.class, jsonObject);
        }
        AppointmentResponse.Builder builder = AppointmentResponse.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.appointment(this.parseReference("appointment", JsonSupport.getJsonValue(jsonObject, "appointment", JsonObject.class), -1));
        builder.start(this.parseInstant("start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.end(this.parseInstant("end", (JsonValue)JsonSupport.getJsonValue(jsonObject, "end", JsonString.class), (JsonValue)jsonObject.get((Object)"_end"), -1));
        JsonArray participantTypeArray = JsonSupport.getJsonArray(jsonObject, "participantType");
        if (participantTypeArray != null) {
            for (int i = 0; i < participantTypeArray.size(); ++i) {
                builder.participantType(this.parseCodeableConcept("participantType", participantTypeArray.getJsonObject(i), i));
            }
        }
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        builder.participantStatus((ParticipantStatus)this.parseString(ParticipantStatus.builder(), "participantStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "participantStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_participantStatus"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private Attachment parseAttachment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Attachment.class, jsonObject);
        }
        Attachment.Builder builder = Attachment.builder();
        this.parseElement(builder, jsonObject);
        builder.contentType((Code)this.parseString(Code.builder(), "contentType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentType", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentType"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.data(this.parseBase64Binary("data", (JsonValue)JsonSupport.getJsonValue(jsonObject, "data", JsonString.class), (JsonValue)jsonObject.get((Object)"_data"), -1));
        builder.url((Url)this.parseUri(Url.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.size((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "size", (JsonValue)JsonSupport.getJsonValue(jsonObject, "size", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_size"), -1));
        builder.hash(this.parseBase64Binary("hash", (JsonValue)JsonSupport.getJsonValue(jsonObject, "hash", JsonString.class), (JsonValue)jsonObject.get((Object)"_hash"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.creation(this.parseDateTime("creation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "creation", JsonString.class), (JsonValue)jsonObject.get((Object)"_creation"), -1));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent parseAuditEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray agentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.class, jsonObject);
        }
        AuditEvent.Builder builder = AuditEvent.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subtypeArray = JsonSupport.getJsonArray(jsonObject, "subtype");
        if (subtypeArray != null) {
            for (int i = 0; i < subtypeArray.size(); ++i) {
                builder.subtype(this.parseCoding("subtype", subtypeArray.getJsonObject(i), i));
            }
        }
        builder.action((AuditEventAction)this.parseString(AuditEventAction.builder(), "action", (JsonValue)JsonSupport.getJsonValue(jsonObject, "action", JsonString.class), (JsonValue)jsonObject.get((Object)"_action"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.recorded(this.parseInstant("recorded", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recorded", JsonString.class), (JsonValue)jsonObject.get((Object)"_recorded"), -1));
        builder.outcome((AuditEventOutcome)this.parseString(AuditEventOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.outcomeDesc(this.parseString("outcomeDesc", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcomeDesc", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcomeDesc"), -1));
        JsonArray purposeOfEventArray = JsonSupport.getJsonArray(jsonObject, "purposeOfEvent");
        if (purposeOfEventArray != null) {
            for (int i = 0; i < purposeOfEventArray.size(); ++i) {
                builder.purposeOfEvent(this.parseCodeableConcept("purposeOfEvent", purposeOfEventArray.getJsonObject(i), i));
            }
        }
        if ((agentArray = JsonSupport.getJsonArray(jsonObject, "agent")) != null) {
            for (int i = 0; i < agentArray.size(); ++i) {
                builder.agent(this.parseAuditEventAgent("agent", agentArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseAuditEventSource("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        JsonArray entityArray = JsonSupport.getJsonArray(jsonObject, "entity");
        if (entityArray != null) {
            for (int i = 0; i < entityArray.size(); ++i) {
                builder.entity(this.parseAuditEventEntity("entity", entityArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Agent parseAuditEventAgent(String elementName, JsonObject jsonObject, int elementIndex) {
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Agent.class, jsonObject);
        }
        AuditEvent.Agent.Builder builder = AuditEvent.Agent.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray roleArray = JsonSupport.getJsonArray(jsonObject, "role");
        if (roleArray != null) {
            for (int i2 = 0; i2 < roleArray.size(); ++i2) {
                builder.role(this.parseCodeableConcept("role", roleArray.getJsonObject(i2), i2));
            }
        }
        builder.who(this.parseReference("who", JsonSupport.getJsonValue(jsonObject, "who", JsonObject.class), -1));
        builder.altId(this.parseString("altId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "altId", JsonString.class), (JsonValue)jsonObject.get((Object)"_altId"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.requestor(this.parseBoolean("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonValue.class), (JsonValue)jsonObject.get((Object)"_requestor"), -1));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray policyArray = JsonSupport.getJsonArray(jsonObject, "policy", true);
        if (policyArray != null) {
            JsonArray _policyArray = jsonObject.getJsonArray("_policy");
            for (i = 0; i < policyArray.size(); ++i) {
                builder.policy(this.parseUri("policy", (JsonValue)policyArray.get(i), JsonSupport.getJsonValue(_policyArray, i), i));
            }
        }
        builder.media(this.parseCoding("media", JsonSupport.getJsonValue(jsonObject, "media", JsonObject.class), -1));
        builder.network(this.parseAuditEventAgentNetwork("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        JsonArray purposeOfUseArray = JsonSupport.getJsonArray(jsonObject, "purposeOfUse");
        if (purposeOfUseArray != null) {
            for (i = 0; i < purposeOfUseArray.size(); ++i) {
                builder.purposeOfUse(this.parseCodeableConcept("purposeOfUse", purposeOfUseArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Agent.Network parseAuditEventAgentNetwork(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Agent.Network.class, jsonObject);
        }
        AuditEvent.Agent.Network.Builder builder = AuditEvent.Agent.Network.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.address(this.parseString("address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        builder.type((AuditEventAgentNetworkType)this.parseString(AuditEventAgentNetworkType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Entity parseAuditEventEntity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Entity.class, jsonObject);
        }
        AuditEvent.Entity.Builder builder = AuditEvent.Entity.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.what(this.parseReference("what", JsonSupport.getJsonValue(jsonObject, "what", JsonObject.class), -1));
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.role(this.parseCoding("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.lifecycle(this.parseCoding("lifecycle", JsonSupport.getJsonValue(jsonObject, "lifecycle", JsonObject.class), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                builder.securityLabel(this.parseCoding("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.query(this.parseBase64Binary("query", (JsonValue)JsonSupport.getJsonValue(jsonObject, "query", JsonString.class), (JsonValue)jsonObject.get((Object)"_query"), -1));
        JsonArray detailArray = JsonSupport.getJsonArray(jsonObject, "detail");
        if (detailArray != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                builder.detail(this.parseAuditEventEntityDetail("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Entity.Detail parseAuditEventEntityDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Entity.Detail.class, jsonObject);
        }
        AuditEvent.Entity.Detail.Builder builder = AuditEvent.Entity.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseString("type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, com.ibm.fhir.model.type.String.class, Base64Binary.class));
        this.stackPop();
        return builder.build();
    }

    private AuditEvent.Source parseAuditEventSource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(AuditEvent.Source.class, jsonObject);
        }
        AuditEvent.Source.Builder builder = AuditEvent.Source.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.site(this.parseString("site", (JsonValue)JsonSupport.getJsonValue(jsonObject, "site", JsonString.class), (JsonValue)jsonObject.get((Object)"_site"), -1));
        builder.observer(this.parseReference("observer", JsonSupport.getJsonValue(jsonObject, "observer", JsonObject.class), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCoding("type", typeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private void parseBackboneElement(BackboneElement.Builder builder, JsonObject jsonObject) {
        this.parseElement(builder, jsonObject);
        JsonArray modifierExtensionArray = JsonSupport.getJsonArray(jsonObject, "modifierExtension");
        if (modifierExtensionArray != null) {
            for (int i = 0; i < modifierExtensionArray.size(); ++i) {
                builder.modifierExtension(this.parseExtension("modifierExtension", modifierExtensionArray.getJsonObject(i), i));
            }
        }
    }

    private Base64Binary parseBase64Binary(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Base64Binary.Builder builder = Base64Binary.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Basic parseBasic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Basic.class, jsonObject);
        }
        Basic.Builder builder = Basic.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.created(this.parseDate("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Binary parseBinary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Binary.class, jsonObject);
        }
        Binary.Builder builder = Binary.builder();
        this.parseResource(builder, jsonObject);
        builder.contentType((Code)this.parseString(Code.builder(), "contentType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentType", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentType"), -1));
        builder.securityContext(this.parseReference("securityContext", JsonSupport.getJsonValue(jsonObject, "securityContext", JsonObject.class), -1));
        builder.data(this.parseBase64Binary("data", (JsonValue)JsonSupport.getJsonValue(jsonObject, "data", JsonString.class), (JsonValue)jsonObject.get((Object)"_data"), -1));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct parseBiologicallyDerivedProduct(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.class, jsonObject);
        }
        BiologicallyDerivedProduct.Builder builder = BiologicallyDerivedProduct.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.productCategory((BiologicallyDerivedProductCategory)this.parseString(BiologicallyDerivedProductCategory.builder(), "productCategory", (JsonValue)JsonSupport.getJsonValue(jsonObject, "productCategory", JsonString.class), (JsonValue)jsonObject.get((Object)"_productCategory"), -1));
        builder.productCode(this.parseCodeableConcept("productCode", JsonSupport.getJsonValue(jsonObject, "productCode", JsonObject.class), -1));
        builder.status((BiologicallyDerivedProductStatus)this.parseString(BiologicallyDerivedProductStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray requestArray = JsonSupport.getJsonArray(jsonObject, "request");
        if (requestArray != null) {
            for (int i = 0; i < requestArray.size(); ++i) {
                builder.request(this.parseReference("request", requestArray.getJsonObject(i), i));
            }
        }
        builder.quantity(this.parseInteger("quantity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "quantity", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_quantity"), -1));
        JsonArray parentArray = JsonSupport.getJsonArray(jsonObject, "parent");
        if (parentArray != null) {
            for (int i = 0; i < parentArray.size(); ++i) {
                builder.parent(this.parseReference("parent", parentArray.getJsonObject(i), i));
            }
        }
        builder.collection(this.parseBiologicallyDerivedProductCollection("collection", JsonSupport.getJsonValue(jsonObject, "collection", JsonObject.class), -1));
        JsonArray processingArray = JsonSupport.getJsonArray(jsonObject, "processing");
        if (processingArray != null) {
            for (int i = 0; i < processingArray.size(); ++i) {
                builder.processing(this.parseBiologicallyDerivedProductProcessing("processing", processingArray.getJsonObject(i), i));
            }
        }
        builder.manipulation(this.parseBiologicallyDerivedProductManipulation("manipulation", JsonSupport.getJsonValue(jsonObject, "manipulation", JsonObject.class), -1));
        JsonArray storageArray = JsonSupport.getJsonArray(jsonObject, "storage");
        if (storageArray != null) {
            for (int i = 0; i < storageArray.size(); ++i) {
                builder.storage(this.parseBiologicallyDerivedProductStorage("storage", storageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Collection parseBiologicallyDerivedProductCollection(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Collection.class, jsonObject);
        }
        BiologicallyDerivedProduct.Collection.Builder builder = BiologicallyDerivedProduct.Collection.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.collector(this.parseReference("collector", JsonSupport.getJsonValue(jsonObject, "collector", JsonObject.class), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.collected(this.parseChoiceElement("collected", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Manipulation parseBiologicallyDerivedProductManipulation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Manipulation.class, jsonObject);
        }
        BiologicallyDerivedProduct.Manipulation.Builder builder = BiologicallyDerivedProduct.Manipulation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.time(this.parseChoiceElement("time", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Processing parseBiologicallyDerivedProductProcessing(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Processing.class, jsonObject);
        }
        BiologicallyDerivedProduct.Processing.Builder builder = BiologicallyDerivedProduct.Processing.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.procedure(this.parseCodeableConcept("procedure", JsonSupport.getJsonValue(jsonObject, "procedure", JsonObject.class), -1));
        builder.additive(this.parseReference("additive", JsonSupport.getJsonValue(jsonObject, "additive", JsonObject.class), -1));
        builder.time(this.parseChoiceElement("time", jsonObject, DateTime.class, Period.class));
        this.stackPop();
        return builder.build();
    }

    private BiologicallyDerivedProduct.Storage parseBiologicallyDerivedProductStorage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BiologicallyDerivedProduct.Storage.class, jsonObject);
        }
        BiologicallyDerivedProduct.Storage.Builder builder = BiologicallyDerivedProduct.Storage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.temperature(this.parseDecimal("temperature", (JsonValue)JsonSupport.getJsonValue(jsonObject, "temperature", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_temperature"), -1));
        builder.scale((BiologicallyDerivedProductStorageScale)this.parseString(BiologicallyDerivedProductStorageScale.builder(), "scale", (JsonValue)JsonSupport.getJsonValue(jsonObject, "scale", JsonString.class), (JsonValue)jsonObject.get((Object)"_scale"), -1));
        builder.duration(this.parsePeriod("duration", JsonSupport.getJsonValue(jsonObject, "duration", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private BodyStructure parseBodyStructure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(BodyStructure.class, jsonObject);
        }
        BodyStructure.Builder builder = BodyStructure.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.morphology(this.parseCodeableConcept("morphology", JsonSupport.getJsonValue(jsonObject, "morphology", JsonObject.class), -1));
        builder.location(this.parseCodeableConcept("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray locationQualifierArray = JsonSupport.getJsonArray(jsonObject, "locationQualifier");
        if (locationQualifierArray != null) {
            for (int i = 0; i < locationQualifierArray.size(); ++i) {
                builder.locationQualifier(this.parseCodeableConcept("locationQualifier", locationQualifierArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray imageArray = JsonSupport.getJsonArray(jsonObject, "image");
        if (imageArray != null) {
            for (int i = 0; i < imageArray.size(); ++i) {
                builder.image(this.parseAttachment("image", imageArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Boolean parseBoolean(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Boolean.Builder builder = Boolean.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (JsonValue.TRUE.equals(jsonValue) || JsonValue.FALSE.equals(jsonValue)) {
            builder.value(JsonValue.TRUE.equals(jsonValue) ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE);
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: TRUE or FALSE but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Bundle parseBundle(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray entryArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.class, jsonObject);
        }
        Bundle.Builder builder = Bundle.builder();
        this.parseResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.type((BundleType)this.parseString(BundleType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.timestamp(this.parseInstant("timestamp", (JsonValue)JsonSupport.getJsonValue(jsonObject, "timestamp", JsonString.class), (JsonValue)jsonObject.get((Object)"_timestamp"), -1));
        builder.total((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "total", (JsonValue)JsonSupport.getJsonValue(jsonObject, "total", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_total"), -1));
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                builder.link(this.parseBundleLink("link", linkArray.getJsonObject(i), i));
            }
        }
        if ((entryArray = JsonSupport.getJsonArray(jsonObject, "entry")) != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                builder.entry(this.parseBundleEntry("entry", entryArray.getJsonObject(i), i));
            }
        }
        builder.signature(this.parseSignature("signature", JsonSupport.getJsonValue(jsonObject, "signature", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry parseBundleEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.class, jsonObject);
        }
        Bundle.Entry.Builder builder = Bundle.Entry.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                builder.link(this.parseBundleLink("link", linkArray.getJsonObject(i), i));
            }
        }
        builder.fullUrl(this.parseUri("fullUrl", (JsonValue)JsonSupport.getJsonValue(jsonObject, "fullUrl", JsonString.class), (JsonValue)jsonObject.get((Object)"_fullUrl"), -1));
        builder.resource(this.parseResource("resource", JsonSupport.getJsonValue(jsonObject, "resource", JsonObject.class), -1));
        builder.search(this.parseBundleEntrySearch("search", JsonSupport.getJsonValue(jsonObject, "search", JsonObject.class), -1));
        builder.request(this.parseBundleEntryRequest("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.response(this.parseBundleEntryResponse("response", JsonSupport.getJsonValue(jsonObject, "response", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Request parseBundleEntryRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Request.class, jsonObject);
        }
        Bundle.Entry.Request.Builder builder = Bundle.Entry.Request.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.method((HTTPVerb)this.parseString(HTTPVerb.builder(), "method", (JsonValue)JsonSupport.getJsonValue(jsonObject, "method", JsonString.class), (JsonValue)jsonObject.get((Object)"_method"), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.ifNoneMatch(this.parseString("ifNoneMatch", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifNoneMatch", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifNoneMatch"), -1));
        builder.ifModifiedSince(this.parseInstant("ifModifiedSince", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifModifiedSince", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifModifiedSince"), -1));
        builder.ifMatch(this.parseString("ifMatch", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifMatch", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifMatch"), -1));
        builder.ifNoneExist(this.parseString("ifNoneExist", (JsonValue)JsonSupport.getJsonValue(jsonObject, "ifNoneExist", JsonString.class), (JsonValue)jsonObject.get((Object)"_ifNoneExist"), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Response parseBundleEntryResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Response.class, jsonObject);
        }
        Bundle.Entry.Response.Builder builder = Bundle.Entry.Response.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.status(this.parseString("status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.location(this.parseUri("location", (JsonValue)JsonSupport.getJsonValue(jsonObject, "location", JsonString.class), (JsonValue)jsonObject.get((Object)"_location"), -1));
        builder.etag(this.parseString("etag", (JsonValue)JsonSupport.getJsonValue(jsonObject, "etag", JsonString.class), (JsonValue)jsonObject.get((Object)"_etag"), -1));
        builder.lastModified(this.parseInstant("lastModified", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastModified", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastModified"), -1));
        builder.outcome(this.parseResource("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Entry.Search parseBundleEntrySearch(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Entry.Search.class, jsonObject);
        }
        Bundle.Entry.Search.Builder builder = Bundle.Entry.Search.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((SearchEntryMode)this.parseString(SearchEntryMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.score(this.parseDecimal("score", (JsonValue)JsonSupport.getJsonValue(jsonObject, "score", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_score"), -1));
        this.stackPop();
        return builder.build();
    }

    private Bundle.Link parseBundleLink(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Bundle.Link.class, jsonObject);
        }
        Bundle.Link.Builder builder = Bundle.Link.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.relation(this.parseString("relation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "relation", JsonString.class), (JsonValue)jsonObject.get((Object)"_relation"), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement parseCapabilityStatement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray documentArray;
        JsonArray messagingArray;
        JsonArray restArray;
        int i;
        JsonArray implementationGuideArray;
        JsonArray patchFormatArray;
        JsonArray importsArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.class, jsonObject);
        }
        CapabilityStatement.Builder builder = CapabilityStatement.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i2 = 0; i2 < contactArray.size(); ++i2) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i2), i2));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i3 = 0; i3 < useContextArray.size(); ++i3) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i3), i3));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i4 = 0; i4 < jurisdictionArray.size(); ++i4) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i4), i4));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.kind((CapabilityStatementKind)this.parseString(CapabilityStatementKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        JsonArray instantiatesArray = JsonSupport.getJsonArray(jsonObject, "instantiates", true);
        if (instantiatesArray != null) {
            JsonArray _instantiatesArray = jsonObject.getJsonArray("_instantiates");
            for (int i5 = 0; i5 < instantiatesArray.size(); ++i5) {
                builder.instantiates((Canonical)this.parseUri(Canonical.builder(), "instantiates", (JsonValue)instantiatesArray.get(i5), JsonSupport.getJsonValue(_instantiatesArray, i5), i5));
            }
        }
        if ((importsArray = JsonSupport.getJsonArray(jsonObject, "imports", true)) != null) {
            JsonArray _importsArray = jsonObject.getJsonArray("_imports");
            for (int i6 = 0; i6 < importsArray.size(); ++i6) {
                builder.imports((Canonical)this.parseUri(Canonical.builder(), "imports", (JsonValue)importsArray.get(i6), JsonSupport.getJsonValue(_importsArray, i6), i6));
            }
        }
        builder.software(this.parseCapabilityStatementSoftware("software", JsonSupport.getJsonValue(jsonObject, "software", JsonObject.class), -1));
        builder.implementation(this.parseCapabilityStatementImplementation("implementation", JsonSupport.getJsonValue(jsonObject, "implementation", JsonObject.class), -1));
        builder.fhirVersion((FHIRVersion)this.parseString(FHIRVersion.builder(), "fhirVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "fhirVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_fhirVersion"), -1));
        JsonArray formatArray = JsonSupport.getJsonArray(jsonObject, "format", true);
        if (formatArray != null) {
            JsonArray _formatArray = jsonObject.getJsonArray("_format");
            for (int i7 = 0; i7 < formatArray.size(); ++i7) {
                builder.format((Code)this.parseString(Code.builder(), "format", (JsonValue)formatArray.get(i7), JsonSupport.getJsonValue(_formatArray, i7), i7));
            }
        }
        if ((patchFormatArray = JsonSupport.getJsonArray(jsonObject, "patchFormat", true)) != null) {
            JsonArray _patchFormatArray = jsonObject.getJsonArray("_patchFormat");
            for (int i8 = 0; i8 < patchFormatArray.size(); ++i8) {
                builder.patchFormat((Code)this.parseString(Code.builder(), "patchFormat", (JsonValue)patchFormatArray.get(i8), JsonSupport.getJsonValue(_patchFormatArray, i8), i8));
            }
        }
        if ((implementationGuideArray = JsonSupport.getJsonArray(jsonObject, "implementationGuide", true)) != null) {
            JsonArray _implementationGuideArray = jsonObject.getJsonArray("_implementationGuide");
            for (i = 0; i < implementationGuideArray.size(); ++i) {
                builder.implementationGuide((Canonical)this.parseUri(Canonical.builder(), "implementationGuide", (JsonValue)implementationGuideArray.get(i), JsonSupport.getJsonValue(_implementationGuideArray, i), i));
            }
        }
        if ((restArray = JsonSupport.getJsonArray(jsonObject, "rest")) != null) {
            for (i = 0; i < restArray.size(); ++i) {
                builder.rest(this.parseCapabilityStatementRest("rest", restArray.getJsonObject(i), i));
            }
        }
        if ((messagingArray = JsonSupport.getJsonArray(jsonObject, "messaging")) != null) {
            for (int i9 = 0; i9 < messagingArray.size(); ++i9) {
                builder.messaging(this.parseCapabilityStatementMessaging("messaging", messagingArray.getJsonObject(i9), i9));
            }
        }
        if ((documentArray = JsonSupport.getJsonArray(jsonObject, "document")) != null) {
            for (int i10 = 0; i10 < documentArray.size(); ++i10) {
                builder.document(this.parseCapabilityStatementDocument("document", documentArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Document parseCapabilityStatementDocument(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Document.class, jsonObject);
        }
        CapabilityStatement.Document.Builder builder = CapabilityStatement.Document.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((DocumentMode)this.parseString(DocumentMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Implementation parseCapabilityStatementImplementation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Implementation.class, jsonObject);
        }
        CapabilityStatement.Implementation.Builder builder = CapabilityStatement.Implementation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.url((Url)this.parseUri(Url.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging parseCapabilityStatementMessaging(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.class, jsonObject);
        }
        CapabilityStatement.Messaging.Builder builder = CapabilityStatement.Messaging.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint");
        if (endpointArray != null) {
            for (int i = 0; i < endpointArray.size(); ++i) {
                builder.endpoint(this.parseCapabilityStatementMessagingEndpoint("endpoint", endpointArray.getJsonObject(i), i));
            }
        }
        builder.reliableCache((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "reliableCache", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reliableCache", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_reliableCache"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        JsonArray supportedMessageArray = JsonSupport.getJsonArray(jsonObject, "supportedMessage");
        if (supportedMessageArray != null) {
            for (int i = 0; i < supportedMessageArray.size(); ++i) {
                builder.supportedMessage(this.parseCapabilityStatementMessagingSupportedMessage("supportedMessage", supportedMessageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging.Endpoint parseCapabilityStatementMessagingEndpoint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.Endpoint.class, jsonObject);
        }
        CapabilityStatement.Messaging.Endpoint.Builder builder = CapabilityStatement.Messaging.Endpoint.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.protocol(this.parseCoding("protocol", JsonSupport.getJsonValue(jsonObject, "protocol", JsonObject.class), -1));
        builder.address((Url)this.parseUri(Url.builder(), "address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Messaging.SupportedMessage parseCapabilityStatementMessagingSupportedMessage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Messaging.SupportedMessage.class, jsonObject);
        }
        CapabilityStatement.Messaging.SupportedMessage.Builder builder = CapabilityStatement.Messaging.SupportedMessage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((EventCapabilityMode)this.parseString(EventCapabilityMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest parseCapabilityStatementRest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray compartmentArray;
        JsonArray operationArray;
        JsonArray searchParamArray;
        JsonArray interactionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.class, jsonObject);
        }
        CapabilityStatement.Rest.Builder builder = CapabilityStatement.Rest.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((RestfulCapabilityMode)this.parseString(RestfulCapabilityMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        builder.security(this.parseCapabilityStatementRestSecurity("security", JsonSupport.getJsonValue(jsonObject, "security", JsonObject.class), -1));
        JsonArray resourceArray = JsonSupport.getJsonArray(jsonObject, "resource");
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                builder.resource(this.parseCapabilityStatementRestResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        if ((interactionArray = JsonSupport.getJsonArray(jsonObject, "interaction")) != null) {
            for (int i = 0; i < interactionArray.size(); ++i) {
                builder.interaction(this.parseCapabilityStatementRestInteraction("interaction", interactionArray.getJsonObject(i), i));
            }
        }
        if ((searchParamArray = JsonSupport.getJsonArray(jsonObject, "searchParam")) != null) {
            for (int i = 0; i < searchParamArray.size(); ++i) {
                builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", searchParamArray.getJsonObject(i), i));
            }
        }
        if ((operationArray = JsonSupport.getJsonArray(jsonObject, "operation")) != null) {
            for (int i = 0; i < operationArray.size(); ++i) {
                builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", operationArray.getJsonObject(i), i));
            }
        }
        if ((compartmentArray = JsonSupport.getJsonArray(jsonObject, "compartment", true)) != null) {
            JsonArray _compartmentArray = jsonObject.getJsonArray("_compartment");
            for (int i = 0; i < compartmentArray.size(); ++i) {
                builder.compartment((Canonical)this.parseUri(Canonical.builder(), "compartment", (JsonValue)compartmentArray.get(i), JsonSupport.getJsonValue(_compartmentArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Interaction parseCapabilityStatementRestInteraction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Interaction.class, jsonObject);
        }
        CapabilityStatement.Rest.Interaction.Builder builder = CapabilityStatement.Rest.Interaction.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((SystemRestfulInteraction)this.parseString(SystemRestfulInteraction.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource parseCapabilityStatementRestResource(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray operationArray;
        JsonArray searchParamArray;
        int i;
        JsonArray searchRevIncludeArray;
        JsonArray searchIncludeArray;
        int i2;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Builder builder = CapabilityStatement.Rest.Resource.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ResourceType)this.parseString(ResourceType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray supportedProfileArray = JsonSupport.getJsonArray(jsonObject, "supportedProfile", true);
        if (supportedProfileArray != null) {
            JsonArray _supportedProfileArray = jsonObject.getJsonArray("_supportedProfile");
            for (i2 = 0; i2 < supportedProfileArray.size(); ++i2) {
                builder.supportedProfile((Canonical)this.parseUri(Canonical.builder(), "supportedProfile", (JsonValue)supportedProfileArray.get(i2), JsonSupport.getJsonValue(_supportedProfileArray, i2), i2));
            }
        }
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        JsonArray interactionArray = JsonSupport.getJsonArray(jsonObject, "interaction");
        if (interactionArray != null) {
            for (i2 = 0; i2 < interactionArray.size(); ++i2) {
                builder.interaction(this.parseCapabilityStatementRestResourceInteraction("interaction", interactionArray.getJsonObject(i2), i2));
            }
        }
        builder.versioning((ResourceVersionPolicy)this.parseString(ResourceVersionPolicy.builder(), "versioning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versioning", JsonString.class), (JsonValue)jsonObject.get((Object)"_versioning"), -1));
        builder.readHistory(this.parseBoolean("readHistory", JsonSupport.getJsonValue(jsonObject, "readHistory", JsonValue.class), (JsonValue)jsonObject.get((Object)"_readHistory"), -1));
        builder.updateCreate(this.parseBoolean("updateCreate", JsonSupport.getJsonValue(jsonObject, "updateCreate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_updateCreate"), -1));
        builder.conditionalCreate(this.parseBoolean("conditionalCreate", JsonSupport.getJsonValue(jsonObject, "conditionalCreate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_conditionalCreate"), -1));
        builder.conditionalRead((ConditionalReadStatus)this.parseString(ConditionalReadStatus.builder(), "conditionalRead", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conditionalRead", JsonString.class), (JsonValue)jsonObject.get((Object)"_conditionalRead"), -1));
        builder.conditionalUpdate(this.parseBoolean("conditionalUpdate", JsonSupport.getJsonValue(jsonObject, "conditionalUpdate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_conditionalUpdate"), -1));
        builder.conditionalDelete((ConditionalDeleteStatus)this.parseString(ConditionalDeleteStatus.builder(), "conditionalDelete", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conditionalDelete", JsonString.class), (JsonValue)jsonObject.get((Object)"_conditionalDelete"), -1));
        JsonArray referencePolicyArray = JsonSupport.getJsonArray(jsonObject, "referencePolicy", true);
        if (referencePolicyArray != null) {
            JsonArray _referencePolicyArray = jsonObject.getJsonArray("_referencePolicy");
            for (int i3 = 0; i3 < referencePolicyArray.size(); ++i3) {
                builder.referencePolicy((ReferenceHandlingPolicy)this.parseString(ReferenceHandlingPolicy.builder(), "referencePolicy", (JsonValue)referencePolicyArray.get(i3), JsonSupport.getJsonValue(_referencePolicyArray, i3), i3));
            }
        }
        if ((searchIncludeArray = JsonSupport.getJsonArray(jsonObject, "searchInclude", true)) != null) {
            JsonArray _searchIncludeArray = jsonObject.getJsonArray("_searchInclude");
            for (int i4 = 0; i4 < searchIncludeArray.size(); ++i4) {
                builder.searchInclude(this.parseString("searchInclude", (JsonValue)searchIncludeArray.get(i4), JsonSupport.getJsonValue(_searchIncludeArray, i4), i4));
            }
        }
        if ((searchRevIncludeArray = JsonSupport.getJsonArray(jsonObject, "searchRevInclude", true)) != null) {
            JsonArray _searchRevIncludeArray = jsonObject.getJsonArray("_searchRevInclude");
            for (i = 0; i < searchRevIncludeArray.size(); ++i) {
                builder.searchRevInclude(this.parseString("searchRevInclude", (JsonValue)searchRevIncludeArray.get(i), JsonSupport.getJsonValue(_searchRevIncludeArray, i), i));
            }
        }
        if ((searchParamArray = JsonSupport.getJsonArray(jsonObject, "searchParam")) != null) {
            for (i = 0; i < searchParamArray.size(); ++i) {
                builder.searchParam(this.parseCapabilityStatementRestResourceSearchParam("searchParam", searchParamArray.getJsonObject(i), i));
            }
        }
        if ((operationArray = JsonSupport.getJsonArray(jsonObject, "operation")) != null) {
            for (int i5 = 0; i5 < operationArray.size(); ++i5) {
                builder.operation(this.parseCapabilityStatementRestResourceOperation("operation", operationArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.Interaction parseCapabilityStatementRestResourceInteraction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.Interaction.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Interaction.Builder builder = CapabilityStatement.Rest.Resource.Interaction.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((TypeRestfulInteraction)this.parseString(TypeRestfulInteraction.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.Operation parseCapabilityStatementRestResourceOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.Operation.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.Operation.Builder builder = CapabilityStatement.Rest.Resource.Operation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Resource.SearchParam parseCapabilityStatementRestResourceSearchParam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Resource.SearchParam.class, jsonObject);
        }
        CapabilityStatement.Rest.Resource.SearchParam.Builder builder = CapabilityStatement.Rest.Resource.SearchParam.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.definition((Canonical)this.parseUri(Canonical.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.type((SearchParamType)this.parseString(SearchParamType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.documentation((Markdown)this.parseString(Markdown.builder(), "documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Rest.Security parseCapabilityStatementRestSecurity(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Rest.Security.class, jsonObject);
        }
        CapabilityStatement.Rest.Security.Builder builder = CapabilityStatement.Rest.Security.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.cors(this.parseBoolean("cors", JsonSupport.getJsonValue(jsonObject, "cors", JsonValue.class), (JsonValue)jsonObject.get((Object)"_cors"), -1));
        JsonArray serviceArray = JsonSupport.getJsonArray(jsonObject, "service");
        if (serviceArray != null) {
            for (int i = 0; i < serviceArray.size(); ++i) {
                builder.service(this.parseCodeableConcept("service", serviceArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private CapabilityStatement.Software parseCapabilityStatementSoftware(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CapabilityStatement.Software.class, jsonObject);
        }
        CapabilityStatement.Software.Builder builder = CapabilityStatement.Software.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.releaseDate(this.parseDateTime("releaseDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "releaseDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_releaseDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private CarePlan parseCarePlan(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray activityArray;
        JsonArray goalArray;
        JsonArray supportingInfoArray;
        JsonArray addressesArray;
        JsonArray careTeamArray;
        JsonArray partOfArray;
        JsonArray replacesArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.class, jsonObject);
        }
        CarePlan.Builder builder = CarePlan.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces")) != null) {
            for (int i4 = 0; i4 < replacesArray.size(); ++i4) {
                builder.replaces(this.parseReference("replaces", replacesArray.getJsonObject(i4), i4));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i5 = 0; i5 < partOfArray.size(); ++i5) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i5), i5));
            }
        }
        builder.status((CarePlanStatus)this.parseString(CarePlanStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.intent((CarePlanIntent)this.parseString(CarePlanIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i6 = 0; i6 < categoryArray.size(); ++i6) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i6), i6));
            }
        }
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        JsonArray contributorArray = JsonSupport.getJsonArray(jsonObject, "contributor");
        if (contributorArray != null) {
            for (int i7 = 0; i7 < contributorArray.size(); ++i7) {
                builder.contributor(this.parseReference("contributor", contributorArray.getJsonObject(i7), i7));
            }
        }
        if ((careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam")) != null) {
            for (int i8 = 0; i8 < careTeamArray.size(); ++i8) {
                builder.careTeam(this.parseReference("careTeam", careTeamArray.getJsonObject(i8), i8));
            }
        }
        if ((addressesArray = JsonSupport.getJsonArray(jsonObject, "addresses")) != null) {
            for (int i9 = 0; i9 < addressesArray.size(); ++i9) {
                builder.addresses(this.parseReference("addresses", addressesArray.getJsonObject(i9), i9));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i10 = 0; i10 < supportingInfoArray.size(); ++i10) {
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i10), i10));
            }
        }
        if ((goalArray = JsonSupport.getJsonArray(jsonObject, "goal")) != null) {
            for (int i11 = 0; i11 < goalArray.size(); ++i11) {
                builder.goal(this.parseReference("goal", goalArray.getJsonObject(i11), i11));
            }
        }
        if ((activityArray = JsonSupport.getJsonArray(jsonObject, "activity")) != null) {
            for (int i12 = 0; i12 < activityArray.size(); ++i12) {
                builder.activity(this.parseCarePlanActivity("activity", activityArray.getJsonObject(i12), i12));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i13 = 0; i13 < noteArray.size(); ++i13) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CarePlan.Activity parseCarePlanActivity(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray progressArray;
        JsonArray outcomeReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.Activity.class, jsonObject);
        }
        CarePlan.Activity.Builder builder = CarePlan.Activity.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray outcomeCodeableConceptArray = JsonSupport.getJsonArray(jsonObject, "outcomeCodeableConcept");
        if (outcomeCodeableConceptArray != null) {
            for (int i = 0; i < outcomeCodeableConceptArray.size(); ++i) {
                builder.outcomeCodeableConcept(this.parseCodeableConcept("outcomeCodeableConcept", outcomeCodeableConceptArray.getJsonObject(i), i));
            }
        }
        if ((outcomeReferenceArray = JsonSupport.getJsonArray(jsonObject, "outcomeReference")) != null) {
            for (int i = 0; i < outcomeReferenceArray.size(); ++i) {
                builder.outcomeReference(this.parseReference("outcomeReference", outcomeReferenceArray.getJsonObject(i), i));
            }
        }
        if ((progressArray = JsonSupport.getJsonArray(jsonObject, "progress")) != null) {
            for (int i = 0; i < progressArray.size(); ++i) {
                builder.progress(this.parseAnnotation("progress", progressArray.getJsonObject(i), i));
            }
        }
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        builder.detail(this.parseCarePlanActivityDetail("detail", JsonSupport.getJsonValue(jsonObject, "detail", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CarePlan.Activity.Detail parseCarePlanActivityDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray goalArray;
        JsonArray reasonReferenceArray;
        int i;
        JsonArray instantiatesUriArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CarePlan.Activity.Detail.class, jsonObject);
        }
        CarePlan.Activity.Detail.Builder builder = CarePlan.Activity.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.kind((CarePlanActivityKind)this.parseString(CarePlanActivityKind.builder(), "kind", (JsonValue)JsonSupport.getJsonValue(jsonObject, "kind", JsonString.class), (JsonValue)jsonObject.get((Object)"_kind"), -1));
        JsonArray instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true);
        if (instantiatesCanonicalArray != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i2 = 0; i2 < instantiatesCanonicalArray.size(); ++i2) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i2), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i2), i2));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i3 = 0; i3 < reasonReferenceArray.size(); ++i3) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i3), i3));
            }
        }
        if ((goalArray = JsonSupport.getJsonArray(jsonObject, "goal")) != null) {
            for (int i4 = 0; i4 < goalArray.size(); ++i4) {
                builder.goal(this.parseReference("goal", goalArray.getJsonObject(i4), i4));
            }
        }
        builder.status((CarePlanActivityStatus)this.parseString(CarePlanActivityStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.scheduled(this.parseChoiceElement("scheduled", jsonObject, Timing.class, Period.class, com.ibm.fhir.model.type.String.class));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i5 = 0; i5 < performerArray.size(); ++i5) {
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i5), i5));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, CodeableConcept.class, Reference.class));
        builder.dailyAmount((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "dailyAmount", JsonSupport.getJsonValue(jsonObject, "dailyAmount", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private CareTeam parseCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray telecomArray;
        JsonArray managingOrganizationArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CareTeam.class, jsonObject);
        }
        CareTeam.Builder builder = CareTeam.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((CareTeamStatus)this.parseString(CareTeamStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray participantArray = JsonSupport.getJsonArray(jsonObject, "participant");
        if (participantArray != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                builder.participant(this.parseCareTeamParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((managingOrganizationArray = JsonSupport.getJsonArray(jsonObject, "managingOrganization")) != null) {
            for (int i = 0; i < managingOrganizationArray.size(); ++i) {
                builder.managingOrganization(this.parseReference("managingOrganization", managingOrganizationArray.getJsonObject(i), i));
            }
        }
        if ((telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom")) != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CareTeam.Participant parseCareTeamParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CareTeam.Participant.class, jsonObject);
        }
        CareTeam.Participant.Builder builder = CareTeam.Participant.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray roleArray = JsonSupport.getJsonArray(jsonObject, "role");
        if (roleArray != null) {
            for (int i = 0; i < roleArray.size(); ++i) {
                builder.role(this.parseCodeableConcept("role", roleArray.getJsonObject(i), i));
            }
        }
        builder.member(this.parseReference("member", JsonSupport.getJsonValue(jsonObject, "member", JsonObject.class), -1));
        builder.onBehalfOf(this.parseReference("onBehalfOf", JsonSupport.getJsonValue(jsonObject, "onBehalfOf", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CatalogEntry parseCatalogEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedEntryArray;
        JsonArray additionalClassificationArray;
        JsonArray classificationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CatalogEntry.class, jsonObject);
        }
        CatalogEntry.Builder builder = CatalogEntry.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.orderable(this.parseBoolean("orderable", JsonSupport.getJsonValue(jsonObject, "orderable", JsonValue.class), (JsonValue)jsonObject.get((Object)"_orderable"), -1));
        builder.referencedItem(this.parseReference("referencedItem", JsonSupport.getJsonValue(jsonObject, "referencedItem", JsonObject.class), -1));
        JsonArray additionalIdentifierArray = JsonSupport.getJsonArray(jsonObject, "additionalIdentifier");
        if (additionalIdentifierArray != null) {
            for (int i = 0; i < additionalIdentifierArray.size(); ++i) {
                builder.additionalIdentifier(this.parseIdentifier("additionalIdentifier", additionalIdentifierArray.getJsonObject(i), i));
            }
        }
        if ((classificationArray = JsonSupport.getJsonArray(jsonObject, "classification")) != null) {
            for (int i = 0; i < classificationArray.size(); ++i) {
                builder.classification(this.parseCodeableConcept("classification", classificationArray.getJsonObject(i), i));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.validityPeriod(this.parsePeriod("validityPeriod", JsonSupport.getJsonValue(jsonObject, "validityPeriod", JsonObject.class), -1));
        builder.validTo(this.parseDateTime("validTo", (JsonValue)JsonSupport.getJsonValue(jsonObject, "validTo", JsonString.class), (JsonValue)jsonObject.get((Object)"_validTo"), -1));
        builder.lastUpdated(this.parseDateTime("lastUpdated", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastUpdated", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastUpdated"), -1));
        JsonArray additionalCharacteristicArray = JsonSupport.getJsonArray(jsonObject, "additionalCharacteristic");
        if (additionalCharacteristicArray != null) {
            for (int i = 0; i < additionalCharacteristicArray.size(); ++i) {
                builder.additionalCharacteristic(this.parseCodeableConcept("additionalCharacteristic", additionalCharacteristicArray.getJsonObject(i), i));
            }
        }
        if ((additionalClassificationArray = JsonSupport.getJsonArray(jsonObject, "additionalClassification")) != null) {
            for (int i = 0; i < additionalClassificationArray.size(); ++i) {
                builder.additionalClassification(this.parseCodeableConcept("additionalClassification", additionalClassificationArray.getJsonObject(i), i));
            }
        }
        if ((relatedEntryArray = JsonSupport.getJsonArray(jsonObject, "relatedEntry")) != null) {
            for (int i = 0; i < relatedEntryArray.size(); ++i) {
                builder.relatedEntry(this.parseCatalogEntryRelatedEntry("relatedEntry", relatedEntryArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CatalogEntry.RelatedEntry parseCatalogEntryRelatedEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CatalogEntry.RelatedEntry.class, jsonObject);
        }
        CatalogEntry.RelatedEntry.Builder builder = CatalogEntry.RelatedEntry.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.relationtype((CatalogEntryRelationType)this.parseString(CatalogEntryRelationType.builder(), "relationtype", (JsonValue)JsonSupport.getJsonValue(jsonObject, "relationtype", JsonString.class), (JsonValue)jsonObject.get((Object)"_relationtype"), -1));
        builder.item(this.parseReference("item", JsonSupport.getJsonValue(jsonObject, "item", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItem parseChargeItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray supportingInformationArray;
        JsonArray noteArray;
        JsonArray serviceArray;
        int i;
        JsonArray definitionCanonicalArray;
        JsonArray definitionUriArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItem.class, jsonObject);
        }
        ChargeItem.Builder builder = ChargeItem.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((definitionUriArray = JsonSupport.getJsonArray(jsonObject, "definitionUri", true)) != null) {
            JsonArray _definitionUriArray = jsonObject.getJsonArray("_definitionUri");
            for (int i3 = 0; i3 < definitionUriArray.size(); ++i3) {
                builder.definitionUri(this.parseUri("definitionUri", (JsonValue)definitionUriArray.get(i3), JsonSupport.getJsonValue(_definitionUriArray, i3), i3));
            }
        }
        if ((definitionCanonicalArray = JsonSupport.getJsonArray(jsonObject, "definitionCanonical", true)) != null) {
            JsonArray _definitionCanonicalArray = jsonObject.getJsonArray("_definitionCanonical");
            for (i = 0; i < definitionCanonicalArray.size(); ++i) {
                builder.definitionCanonical((Canonical)this.parseUri(Canonical.builder(), "definitionCanonical", (JsonValue)definitionCanonicalArray.get(i), JsonSupport.getJsonValue(_definitionCanonicalArray, i), i));
            }
        }
        builder.status((ChargeItemStatus)this.parseString(ChargeItemStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf");
        if (partOfArray != null) {
            for (i = 0; i < partOfArray.size(); ++i) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i4 = 0; i4 < performerArray.size(); ++i4) {
                builder.performer(this.parseChargeItemPerformer("performer", performerArray.getJsonObject(i4), i4));
            }
        }
        builder.performingOrganization(this.parseReference("performingOrganization", JsonSupport.getJsonValue(jsonObject, "performingOrganization", JsonObject.class), -1));
        builder.requestingOrganization(this.parseReference("requestingOrganization", JsonSupport.getJsonValue(jsonObject, "requestingOrganization", JsonObject.class), -1));
        builder.costCenter(this.parseReference("costCenter", JsonSupport.getJsonValue(jsonObject, "costCenter", JsonObject.class), -1));
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        JsonArray bodysiteArray = JsonSupport.getJsonArray(jsonObject, "bodysite");
        if (bodysiteArray != null) {
            for (int i5 = 0; i5 < bodysiteArray.size(); ++i5) {
                builder.bodysite(this.parseCodeableConcept("bodysite", bodysiteArray.getJsonObject(i5), i5));
            }
        }
        builder.factorOverride(this.parseDecimal("factorOverride", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factorOverride", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factorOverride"), -1));
        builder.priceOverride(this.parseMoney("priceOverride", JsonSupport.getJsonValue(jsonObject, "priceOverride", JsonObject.class), -1));
        builder.overrideReason(this.parseString("overrideReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "overrideReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_overrideReason"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.enteredDate(this.parseDateTime("enteredDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "enteredDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_enteredDate"), -1));
        JsonArray reasonArray = JsonSupport.getJsonArray(jsonObject, "reason");
        if (reasonArray != null) {
            for (int i6 = 0; i6 < reasonArray.size(); ++i6) {
                builder.reason(this.parseCodeableConcept("reason", reasonArray.getJsonObject(i6), i6));
            }
        }
        if ((serviceArray = JsonSupport.getJsonArray(jsonObject, "service")) != null) {
            for (int i7 = 0; i7 < serviceArray.size(); ++i7) {
                builder.service(this.parseReference("service", serviceArray.getJsonObject(i7), i7));
            }
        }
        builder.product(this.parseChoiceElement("product", jsonObject, Reference.class, CodeableConcept.class));
        JsonArray accountArray = JsonSupport.getJsonArray(jsonObject, "account");
        if (accountArray != null) {
            for (int i8 = 0; i8 < accountArray.size(); ++i8) {
                builder.account(this.parseReference("account", accountArray.getJsonObject(i8), i8));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i9 = 0; i9 < noteArray.size(); ++i9) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i9), i9));
            }
        }
        if ((supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation")) != null) {
            for (int i10 = 0; i10 < supportingInformationArray.size(); ++i10) {
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItem.Performer parseChargeItemPerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItem.Performer.class, jsonObject);
        }
        ChargeItem.Performer.Builder builder = ChargeItem.Performer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition parseChargeItemDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray propertyGroupArray;
        JsonArray applicabilityArray;
        JsonArray jurisdictionArray;
        int i;
        JsonArray replacesArray;
        JsonArray partOfArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.class, jsonObject);
        }
        ChargeItemDefinition.Builder builder = ChargeItemDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        JsonArray derivedFromUriArray = JsonSupport.getJsonArray(jsonObject, "derivedFromUri", true);
        if (derivedFromUriArray != null) {
            JsonArray _derivedFromUriArray = jsonObject.getJsonArray("_derivedFromUri");
            for (int i3 = 0; i3 < derivedFromUriArray.size(); ++i3) {
                builder.derivedFromUri(this.parseUri("derivedFromUri", (JsonValue)derivedFromUriArray.get(i3), JsonSupport.getJsonValue(_derivedFromUriArray, i3), i3));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf", true)) != null) {
            JsonArray _partOfArray = jsonObject.getJsonArray("_partOf");
            for (int i4 = 0; i4 < partOfArray.size(); ++i4) {
                builder.partOf((Canonical)this.parseUri(Canonical.builder(), "partOf", (JsonValue)partOfArray.get(i4), JsonSupport.getJsonValue(_partOfArray, i4), i4));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces", true)) != null) {
            JsonArray _replacesArray = jsonObject.getJsonArray("_replaces");
            for (i = 0; i < replacesArray.size(); ++i) {
                builder.replaces((Canonical)this.parseUri(Canonical.builder(), "replaces", (JsonValue)replacesArray.get(i), JsonSupport.getJsonValue(_replacesArray, i), i));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i5 = 0; i5 < useContextArray.size(); ++i5) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i5), i5));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i6 = 0; i6 < jurisdictionArray.size(); ++i6) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i6), i6));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray instanceArray = JsonSupport.getJsonArray(jsonObject, "instance");
        if (instanceArray != null) {
            for (int i7 = 0; i7 < instanceArray.size(); ++i7) {
                builder.instance(this.parseReference("instance", instanceArray.getJsonObject(i7), i7));
            }
        }
        if ((applicabilityArray = JsonSupport.getJsonArray(jsonObject, "applicability")) != null) {
            for (int i8 = 0; i8 < applicabilityArray.size(); ++i8) {
                builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", applicabilityArray.getJsonObject(i8), i8));
            }
        }
        if ((propertyGroupArray = JsonSupport.getJsonArray(jsonObject, "propertyGroup")) != null) {
            for (int i9 = 0; i9 < propertyGroupArray.size(); ++i9) {
                builder.propertyGroup(this.parseChargeItemDefinitionPropertyGroup("propertyGroup", propertyGroupArray.getJsonObject(i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.Applicability parseChargeItemDefinitionApplicability(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.Applicability.class, jsonObject);
        }
        ChargeItemDefinition.Applicability.Builder builder = ChargeItemDefinition.Applicability.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.language(this.parseString("language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.PropertyGroup parseChargeItemDefinitionPropertyGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray priceComponentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.PropertyGroup.class, jsonObject);
        }
        ChargeItemDefinition.PropertyGroup.Builder builder = ChargeItemDefinition.PropertyGroup.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray applicabilityArray = JsonSupport.getJsonArray(jsonObject, "applicability");
        if (applicabilityArray != null) {
            for (int i = 0; i < applicabilityArray.size(); ++i) {
                builder.applicability(this.parseChargeItemDefinitionApplicability("applicability", applicabilityArray.getJsonObject(i), i));
            }
        }
        if ((priceComponentArray = JsonSupport.getJsonArray(jsonObject, "priceComponent")) != null) {
            for (int i = 0; i < priceComponentArray.size(); ++i) {
                builder.priceComponent(this.parseChargeItemDefinitionPropertyGroupPriceComponent("priceComponent", priceComponentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ChargeItemDefinition.PropertyGroup.PriceComponent parseChargeItemDefinitionPropertyGroupPriceComponent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ChargeItemDefinition.PropertyGroup.PriceComponent.class, jsonObject);
        }
        ChargeItemDefinition.PropertyGroup.PriceComponent.Builder builder = ChargeItemDefinition.PropertyGroup.PriceComponent.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ChargeItemDefinitionPriceComponentType)this.parseString(ChargeItemDefinitionPriceComponentType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim parseClaim(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray insuranceArray;
        JsonArray procedureArray;
        JsonArray diagnosisArray;
        JsonArray supportingInfoArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.class, jsonObject);
        }
        Claim.Builder builder = Claim.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ClaimStatus)this.parseString(ClaimStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.billablePeriod(this.parsePeriod("billablePeriod", JsonSupport.getJsonValue(jsonObject, "billablePeriod", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                builder.related(this.parseClaimRelated("related", relatedArray.getJsonObject(i), i));
            }
        }
        builder.prescription(this.parseReference("prescription", JsonSupport.getJsonValue(jsonObject, "prescription", JsonObject.class), -1));
        builder.originalPrescription(this.parseReference("originalPrescription", JsonSupport.getJsonValue(jsonObject, "originalPrescription", JsonObject.class), -1));
        builder.payee(this.parseClaimPayee("payee", JsonSupport.getJsonValue(jsonObject, "payee", JsonObject.class), -1));
        builder.referral(this.parseReference("referral", JsonSupport.getJsonValue(jsonObject, "referral", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam");
        if (careTeamArray != null) {
            for (int i = 0; i < careTeamArray.size(); ++i) {
                builder.careTeam(this.parseClaimCareTeam("careTeam", careTeamArray.getJsonObject(i), i));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i = 0; i < supportingInfoArray.size(); ++i) {
                builder.supportingInfo(this.parseClaimSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                builder.diagnosis(this.parseClaimDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        if ((procedureArray = JsonSupport.getJsonArray(jsonObject, "procedure")) != null) {
            for (int i = 0; i < procedureArray.size(); ++i) {
                builder.procedure(this.parseClaimProcedure("procedure", procedureArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i = 0; i < insuranceArray.size(); ++i) {
                builder.insurance(this.parseClaimInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        builder.accident(this.parseClaimAccident("accident", JsonSupport.getJsonValue(jsonObject, "accident", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                builder.item(this.parseClaimItem("item", itemArray.getJsonObject(i), i));
            }
        }
        builder.total(this.parseMoney("total", JsonSupport.getJsonValue(jsonObject, "total", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Accident parseClaimAccident(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Accident.class, jsonObject);
        }
        Claim.Accident.Builder builder = Claim.Accident.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.location(this.parseChoiceElement("location", jsonObject, Address.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Claim.CareTeam parseClaimCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.CareTeam.class, jsonObject);
        }
        Claim.CareTeam.Builder builder = Claim.CareTeam.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.responsible(this.parseBoolean("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonValue.class), (JsonValue)jsonObject.get((Object)"_responsible"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.qualification(this.parseCodeableConcept("qualification", JsonSupport.getJsonValue(jsonObject, "qualification", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Diagnosis parseClaimDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Diagnosis.class, jsonObject);
        }
        Claim.Diagnosis.Builder builder = Claim.Diagnosis.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.onAdmission(this.parseCodeableConcept("onAdmission", JsonSupport.getJsonValue(jsonObject, "onAdmission", JsonObject.class), -1));
        builder.packageCode(this.parseCodeableConcept("packageCode", JsonSupport.getJsonValue(jsonObject, "packageCode", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Insurance parseClaimInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Insurance.class, jsonObject);
        }
        Claim.Insurance.Builder builder = Claim.Insurance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (int i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Item parseClaimItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray encounterArray;
        JsonArray programCodeArray;
        int i;
        JsonArray informationSequenceArray;
        JsonArray procedureSequenceArray;
        JsonArray diagnosisSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.class, jsonObject);
        }
        Claim.Item.Builder builder = Claim.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray careTeamSequenceArray = JsonSupport.getJsonArray(jsonObject, "careTeamSequence", true);
        if (careTeamSequenceArray != null) {
            JsonArray _careTeamSequenceArray = jsonObject.getJsonArray("_careTeamSequence");
            for (int i2 = 0; i2 < careTeamSequenceArray.size(); ++i2) {
                builder.careTeamSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "careTeamSequence", (JsonValue)careTeamSequenceArray.get(i2), JsonSupport.getJsonValue(_careTeamSequenceArray, i2), i2));
            }
        }
        if ((diagnosisSequenceArray = JsonSupport.getJsonArray(jsonObject, "diagnosisSequence", true)) != null) {
            JsonArray _diagnosisSequenceArray = jsonObject.getJsonArray("_diagnosisSequence");
            for (int i3 = 0; i3 < diagnosisSequenceArray.size(); ++i3) {
                builder.diagnosisSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "diagnosisSequence", (JsonValue)diagnosisSequenceArray.get(i3), JsonSupport.getJsonValue(_diagnosisSequenceArray, i3), i3));
            }
        }
        if ((procedureSequenceArray = JsonSupport.getJsonArray(jsonObject, "procedureSequence", true)) != null) {
            JsonArray _procedureSequenceArray = jsonObject.getJsonArray("_procedureSequence");
            for (int i4 = 0; i4 < procedureSequenceArray.size(); ++i4) {
                builder.procedureSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "procedureSequence", (JsonValue)procedureSequenceArray.get(i4), JsonSupport.getJsonValue(_procedureSequenceArray, i4), i4));
            }
        }
        if ((informationSequenceArray = JsonSupport.getJsonArray(jsonObject, "informationSequence", true)) != null) {
            JsonArray _informationSequenceArray = jsonObject.getJsonArray("_informationSequence");
            for (i = 0; i < informationSequenceArray.size(); ++i) {
                builder.informationSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "informationSequence", (JsonValue)informationSequenceArray.get(i), JsonSupport.getJsonValue(_informationSequenceArray, i), i));
            }
        }
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i = 0; i < modifierArray.size(); ++i) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i5 = 0; i5 < programCodeArray.size(); ++i5) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i5), i5));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i6 = 0; i6 < udiArray.size(); ++i6) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i6), i6));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter")) != null) {
            for (int i8 = 0; i8 < encounterArray.size(); ++i8) {
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i8), i8));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i9 = 0; i9 < detailArray.size(); ++i9) {
                builder.detail(this.parseClaimItemDetail("detail", detailArray.getJsonObject(i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Item.Detail parseClaimItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.Detail.class, jsonObject);
        }
        Claim.Item.Detail.Builder builder = Claim.Item.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i = 0; i < programCodeArray.size(); ++i) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i), i));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i = 0; i < subDetailArray.size(); ++i) {
                builder.subDetail(this.parseClaimItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Item.Detail.SubDetail parseClaimItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Item.Detail.SubDetail.class, jsonObject);
        }
        Claim.Item.Detail.SubDetail.Builder builder = Claim.Item.Detail.SubDetail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i = 0; i < programCodeArray.size(); ++i) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i), i));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Payee parseClaimPayee(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Payee.class, jsonObject);
        }
        Claim.Payee.Builder builder = Claim.Payee.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.Procedure parseClaimProcedure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Procedure.class, jsonObject);
        }
        Claim.Procedure.Builder builder = Claim.Procedure.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.procedure(this.parseChoiceElement("procedure", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Claim.Related parseClaimRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.Related.class, jsonObject);
        }
        Claim.Related.Builder builder = Claim.Related.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.reference(this.parseIdentifier("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Claim.SupportingInfo parseClaimSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Claim.SupportingInfo.class, jsonObject);
        }
        Claim.SupportingInfo.Builder builder = Claim.SupportingInfo.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Date.class, Period.class));
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, com.ibm.fhir.model.type.String.class, Quantity.class, Attachment.class, Reference.class));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse parseClaimResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray errorArray;
        JsonArray insuranceArray;
        JsonArray communicationRequestArray;
        JsonArray totalArray;
        JsonArray adjudicationArray;
        JsonArray addItemArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.class, jsonObject);
        }
        ClaimResponse.Builder builder = ClaimResponse.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ClaimResponseStatus)this.parseString(ClaimResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.requestor(this.parseReference("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonObject.class), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preAuthRef", JsonString.class), (JsonValue)jsonObject.get((Object)"_preAuthRef"), -1));
        builder.preAuthPeriod(this.parsePeriod("preAuthPeriod", JsonSupport.getJsonValue(jsonObject, "preAuthPeriod", JsonObject.class), -1));
        builder.payeeType(this.parseCodeableConcept("payeeType", JsonSupport.getJsonValue(jsonObject, "payeeType", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                builder.item(this.parseClaimResponseItem("item", itemArray.getJsonObject(i), i));
            }
        }
        if ((addItemArray = JsonSupport.getJsonArray(jsonObject, "addItem")) != null) {
            for (int i = 0; i < addItemArray.size(); ++i) {
                builder.addItem(this.parseClaimResponseAddItem("addItem", addItemArray.getJsonObject(i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (int i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((totalArray = JsonSupport.getJsonArray(jsonObject, "total")) != null) {
            for (int i = 0; i < totalArray.size(); ++i) {
                builder.total(this.parseClaimResponseTotal("total", totalArray.getJsonObject(i), i));
            }
        }
        builder.payment(this.parseClaimResponsePayment("payment", JsonSupport.getJsonValue(jsonObject, "payment", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        builder.formCode(this.parseCodeableConcept("formCode", JsonSupport.getJsonValue(jsonObject, "formCode", JsonObject.class), -1));
        builder.form(this.parseAttachment("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray processNoteArray = JsonSupport.getJsonArray(jsonObject, "processNote");
        if (processNoteArray != null) {
            for (int i = 0; i < processNoteArray.size(); ++i) {
                builder.processNote(this.parseClaimResponseProcessNote("processNote", processNoteArray.getJsonObject(i), i));
            }
        }
        if ((communicationRequestArray = JsonSupport.getJsonArray(jsonObject, "communicationRequest")) != null) {
            for (int i = 0; i < communicationRequestArray.size(); ++i) {
                builder.communicationRequest(this.parseReference("communicationRequest", communicationRequestArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i = 0; i < insuranceArray.size(); ++i) {
                builder.insurance(this.parseClaimResponseInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        if ((errorArray = JsonSupport.getJsonArray(jsonObject, "error")) != null) {
            for (int i = 0; i < errorArray.size(); ++i) {
                builder.error(this.parseClaimResponseError("error", errorArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem parseClaimResponseAddItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        JsonArray providerArray;
        int i2;
        JsonArray subdetailSequenceArray;
        JsonArray detailSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.class, jsonObject);
        }
        ClaimResponse.AddItem.Builder builder = ClaimResponse.AddItem.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray itemSequenceArray = JsonSupport.getJsonArray(jsonObject, "itemSequence", true);
        if (itemSequenceArray != null) {
            JsonArray _itemSequenceArray = jsonObject.getJsonArray("_itemSequence");
            for (int i3 = 0; i3 < itemSequenceArray.size(); ++i3) {
                builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)itemSequenceArray.get(i3), JsonSupport.getJsonValue(_itemSequenceArray, i3), i3));
            }
        }
        if ((detailSequenceArray = JsonSupport.getJsonArray(jsonObject, "detailSequence", true)) != null) {
            JsonArray _detailSequenceArray = jsonObject.getJsonArray("_detailSequence");
            for (int i4 = 0; i4 < detailSequenceArray.size(); ++i4) {
                builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)detailSequenceArray.get(i4), JsonSupport.getJsonValue(_detailSequenceArray, i4), i4));
            }
        }
        if ((subdetailSequenceArray = JsonSupport.getJsonArray(jsonObject, "subdetailSequence", true)) != null) {
            JsonArray _subdetailSequenceArray = jsonObject.getJsonArray("_subdetailSequence");
            for (i2 = 0; i2 < subdetailSequenceArray.size(); ++i2) {
                builder.subdetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subdetailSequence", (JsonValue)subdetailSequenceArray.get(i2), JsonSupport.getJsonValue(_subdetailSequenceArray, i2), i2));
            }
        }
        if ((providerArray = JsonSupport.getJsonArray(jsonObject, "provider")) != null) {
            for (i2 = 0; i2 < providerArray.size(); ++i2) {
                builder.provider(this.parseReference("provider", providerArray.getJsonObject(i2), i2));
            }
        }
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i5 = 0; i5 < modifierArray.size(); ++i5) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i5), i5));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i8 = 0; i8 < detailArray.size(); ++i8) {
                builder.detail(this.parseClaimResponseAddItemDetail("detail", detailArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem.Detail parseClaimResponseAddItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.Detail.class, jsonObject);
        }
        ClaimResponse.AddItem.Detail.Builder builder = ClaimResponse.AddItem.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i3 = 0; i3 < subDetailArray.size(); ++i3) {
                builder.subDetail(this.parseClaimResponseAddItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.AddItem.Detail.SubDetail parseClaimResponseAddItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.AddItem.Detail.SubDetail.class, jsonObject);
        }
        ClaimResponse.AddItem.Detail.SubDetail.Builder builder = ClaimResponse.AddItem.Detail.SubDetail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Error parseClaimResponseError(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Error.class, jsonObject);
        }
        ClaimResponse.Error.Builder builder = ClaimResponse.Error.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "itemSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_itemSequence"), -1));
        builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_detailSequence"), -1));
        builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subDetailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_subDetailSequence"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Insurance parseClaimResponseInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Insurance.class, jsonObject);
        }
        ClaimResponse.Insurance.Builder builder = ClaimResponse.Insurance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item parseClaimResponseItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.class, jsonObject);
        }
        ClaimResponse.Item.Builder builder = ClaimResponse.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "itemSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_itemSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i2 = 0; i2 < detailArray.size(); ++i2) {
                builder.detail(this.parseClaimResponseItemDetail("detail", detailArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Adjudication parseClaimResponseItemAdjudication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Adjudication.class, jsonObject);
        }
        ClaimResponse.Item.Adjudication.Builder builder = ClaimResponse.Item.Adjudication.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.value(this.parseDecimal("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Detail parseClaimResponseItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Detail.class, jsonObject);
        }
        ClaimResponse.Item.Detail.Builder builder = ClaimResponse.Item.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_detailSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i2 = 0; i2 < subDetailArray.size(); ++i2) {
                builder.subDetail(this.parseClaimResponseItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Item.Detail.SubDetail parseClaimResponseItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Item.Detail.SubDetail.class, jsonObject);
        }
        ClaimResponse.Item.Detail.SubDetail.Builder builder = ClaimResponse.Item.Detail.SubDetail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subDetailSequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_subDetailSequence"), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseClaimResponseItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Payment parseClaimResponsePayment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Payment.class, jsonObject);
        }
        ClaimResponse.Payment.Builder builder = ClaimResponse.Payment.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.adjustment(this.parseMoney("adjustment", JsonSupport.getJsonValue(jsonObject, "adjustment", JsonObject.class), -1));
        builder.adjustmentReason(this.parseCodeableConcept("adjustmentReason", JsonSupport.getJsonValue(jsonObject, "adjustmentReason", JsonObject.class), -1));
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.ProcessNote parseClaimResponseProcessNote(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.ProcessNote.class, jsonObject);
        }
        ClaimResponse.ProcessNote.Builder builder = ClaimResponse.ProcessNote.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.number((PositiveInt)this.parseInteger(PositiveInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type((NoteType)this.parseString(NoteType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClaimResponse.Total parseClaimResponseTotal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClaimResponse.Total.class, jsonObject);
        }
        ClaimResponse.Total.Builder builder = ClaimResponse.Total.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression parseClinicalImpression(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray supportingInfoArray;
        JsonArray prognosisReferenceArray;
        JsonArray prognosisCodeableConceptArray;
        int i;
        JsonArray protocolArray;
        JsonArray investigationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.class, jsonObject);
        }
        ClinicalImpression.Builder builder = ClinicalImpression.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((ClinicalImpressionStatus)this.parseString(ClinicalImpressionStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.assessor(this.parseReference("assessor", JsonSupport.getJsonValue(jsonObject, "assessor", JsonObject.class), -1));
        builder.previous(this.parseReference("previous", JsonSupport.getJsonValue(jsonObject, "previous", JsonObject.class), -1));
        JsonArray problemArray = JsonSupport.getJsonArray(jsonObject, "problem");
        if (problemArray != null) {
            for (int i3 = 0; i3 < problemArray.size(); ++i3) {
                builder.problem(this.parseReference("problem", problemArray.getJsonObject(i3), i3));
            }
        }
        if ((investigationArray = JsonSupport.getJsonArray(jsonObject, "investigation")) != null) {
            for (int i4 = 0; i4 < investigationArray.size(); ++i4) {
                builder.investigation(this.parseClinicalImpressionInvestigation("investigation", investigationArray.getJsonObject(i4), i4));
            }
        }
        if ((protocolArray = JsonSupport.getJsonArray(jsonObject, "protocol", true)) != null) {
            JsonArray _protocolArray = jsonObject.getJsonArray("_protocol");
            for (i = 0; i < protocolArray.size(); ++i) {
                builder.protocol(this.parseUri("protocol", (JsonValue)protocolArray.get(i), JsonSupport.getJsonValue(_protocolArray, i), i));
            }
        }
        builder.summary(this.parseString("summary", (JsonValue)JsonSupport.getJsonValue(jsonObject, "summary", JsonString.class), (JsonValue)jsonObject.get((Object)"_summary"), -1));
        JsonArray findingArray = JsonSupport.getJsonArray(jsonObject, "finding");
        if (findingArray != null) {
            for (i = 0; i < findingArray.size(); ++i) {
                builder.finding(this.parseClinicalImpressionFinding("finding", findingArray.getJsonObject(i), i));
            }
        }
        if ((prognosisCodeableConceptArray = JsonSupport.getJsonArray(jsonObject, "prognosisCodeableConcept")) != null) {
            for (int i5 = 0; i5 < prognosisCodeableConceptArray.size(); ++i5) {
                builder.prognosisCodeableConcept(this.parseCodeableConcept("prognosisCodeableConcept", prognosisCodeableConceptArray.getJsonObject(i5), i5));
            }
        }
        if ((prognosisReferenceArray = JsonSupport.getJsonArray(jsonObject, "prognosisReference")) != null) {
            for (int i6 = 0; i6 < prognosisReferenceArray.size(); ++i6) {
                builder.prognosisReference(this.parseReference("prognosisReference", prognosisReferenceArray.getJsonObject(i6), i6));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i7 = 0; i7 < supportingInfoArray.size(); ++i7) {
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i7), i7));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i8 = 0; i8 < noteArray.size(); ++i8) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression.Finding parseClinicalImpressionFinding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.Finding.class, jsonObject);
        }
        ClinicalImpression.Finding.Builder builder = ClinicalImpression.Finding.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.itemCodeableConcept(this.parseCodeableConcept("itemCodeableConcept", JsonSupport.getJsonValue(jsonObject, "itemCodeableConcept", JsonObject.class), -1));
        builder.itemReference(this.parseReference("itemReference", JsonSupport.getJsonValue(jsonObject, "itemReference", JsonObject.class), -1));
        builder.basis(this.parseString("basis", (JsonValue)JsonSupport.getJsonValue(jsonObject, "basis", JsonString.class), (JsonValue)jsonObject.get((Object)"_basis"), -1));
        this.stackPop();
        return builder.build();
    }

    private ClinicalImpression.Investigation parseClinicalImpressionInvestigation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ClinicalImpression.Investigation.class, jsonObject);
        }
        ClinicalImpression.Investigation.Builder builder = ClinicalImpression.Investigation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                builder.item(this.parseReference("item", itemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CodeSystem parseCodeSystem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conceptArray;
        JsonArray propertyArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.class, jsonObject);
        }
        CodeSystem.Builder builder = CodeSystem.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.caseSensitive(this.parseBoolean("caseSensitive", JsonSupport.getJsonValue(jsonObject, "caseSensitive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_caseSensitive"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        builder.hierarchyMeaning((CodeSystemHierarchyMeaning)this.parseString(CodeSystemHierarchyMeaning.builder(), "hierarchyMeaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "hierarchyMeaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_hierarchyMeaning"), -1));
        builder.compositional(this.parseBoolean("compositional", JsonSupport.getJsonValue(jsonObject, "compositional", JsonValue.class), (JsonValue)jsonObject.get((Object)"_compositional"), -1));
        builder.versionNeeded(this.parseBoolean("versionNeeded", JsonSupport.getJsonValue(jsonObject, "versionNeeded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_versionNeeded"), -1));
        builder.content((CodeSystemContentMode)this.parseString(CodeSystemContentMode.builder(), "content", (JsonValue)JsonSupport.getJsonValue(jsonObject, "content", JsonString.class), (JsonValue)jsonObject.get((Object)"_content"), -1));
        builder.supplements((Canonical)this.parseUri(Canonical.builder(), "supplements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "supplements", JsonString.class), (JsonValue)jsonObject.get((Object)"_supplements"), -1));
        builder.count((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "count", (JsonValue)JsonSupport.getJsonValue(jsonObject, "count", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_count"), -1));
        JsonArray filterArray = JsonSupport.getJsonArray(jsonObject, "filter");
        if (filterArray != null) {
            for (int i = 0; i < filterArray.size(); ++i) {
                builder.filter(this.parseCodeSystemFilter("filter", filterArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                builder.property(this.parseCodeSystemProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        if ((conceptArray = JsonSupport.getJsonArray(jsonObject, "concept")) != null) {
            for (int i = 0; i < conceptArray.size(); ++i) {
                builder.concept(this.parseCodeSystemConcept("concept", conceptArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept parseCodeSystemConcept(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conceptArray;
        JsonArray propertyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.class, jsonObject);
        }
        CodeSystem.Concept.Builder builder = CodeSystem.Concept.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.definition(this.parseString("definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        JsonArray designationArray = JsonSupport.getJsonArray(jsonObject, "designation");
        if (designationArray != null) {
            for (int i = 0; i < designationArray.size(); ++i) {
                builder.designation(this.parseCodeSystemConceptDesignation("designation", designationArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                builder.property(this.parseCodeSystemConceptProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        if ((conceptArray = JsonSupport.getJsonArray(jsonObject, "concept")) != null) {
            for (int i = 0; i < conceptArray.size(); ++i) {
                builder.concept(this.parseCodeSystemConcept("concept", conceptArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept.Designation parseCodeSystemConceptDesignation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.Designation.class, jsonObject);
        }
        CodeSystem.Concept.Designation.Builder builder = CodeSystem.Concept.Designation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.use(this.parseCoding("use", JsonSupport.getJsonValue(jsonObject, "use", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Concept.Property parseCodeSystemConceptProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Concept.Property.class, jsonObject);
        }
        CodeSystem.Concept.Property.Builder builder = CodeSystem.Concept.Property.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Code.class, Coding.class, com.ibm.fhir.model.type.String.class, Integer.class, Boolean.class, DateTime.class, Decimal.class));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Filter parseCodeSystemFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Filter.class, jsonObject);
        }
        CodeSystem.Filter.Builder builder = CodeSystem.Filter.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray operatorArray = JsonSupport.getJsonArray(jsonObject, "operator", true);
        if (operatorArray != null) {
            JsonArray _operatorArray = jsonObject.getJsonArray("_operator");
            for (int i = 0; i < operatorArray.size(); ++i) {
                builder.operator((FilterOperator)this.parseString(FilterOperator.builder(), "operator", (JsonValue)operatorArray.get(i), JsonSupport.getJsonValue(_operatorArray, i), i));
            }
        }
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeSystem.Property parseCodeSystemProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeSystem.Property.class, jsonObject);
        }
        CodeSystem.Property.Builder builder = CodeSystem.Property.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.uri(this.parseUri("uri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uri", JsonString.class), (JsonValue)jsonObject.get((Object)"_uri"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.type((PropertyType)this.parseString(PropertyType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private CodeableConcept parseCodeableConcept(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CodeableConcept.class, jsonObject);
        }
        CodeableConcept.Builder builder = CodeableConcept.builder();
        this.parseElement(builder, jsonObject);
        JsonArray codingArray = JsonSupport.getJsonArray(jsonObject, "coding");
        if (codingArray != null) {
            for (int i = 0; i < codingArray.size(); ++i) {
                builder.coding(this.parseCoding("coding", codingArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Coding parseCoding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Coding.class, jsonObject);
        }
        Coding.Builder builder = Coding.builder();
        this.parseElement(builder, jsonObject);
        builder.system(this.parseUri("system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.userSelected(this.parseBoolean("userSelected", JsonSupport.getJsonValue(jsonObject, "userSelected", JsonValue.class), (JsonValue)jsonObject.get((Object)"_userSelected"), -1));
        this.stackPop();
        return builder.build();
    }

    private Communication parseCommunication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray payloadArray;
        JsonArray reasonReferenceArray;
        JsonArray inResponseToArray;
        JsonArray partOfArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Communication.class, jsonObject);
        }
        Communication.Builder builder = Communication.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i4 = 0; i4 < partOfArray.size(); ++i4) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i4), i4));
            }
        }
        if ((inResponseToArray = JsonSupport.getJsonArray(jsonObject, "inResponseTo")) != null) {
            for (int i5 = 0; i5 < inResponseToArray.size(); ++i5) {
                builder.inResponseTo(this.parseReference("inResponseTo", inResponseToArray.getJsonObject(i5), i5));
            }
        }
        builder.status((CommunicationStatus)this.parseString(CommunicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i6 = 0; i6 < categoryArray.size(); ++i6) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i6), i6));
            }
        }
        builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        JsonArray mediumArray = JsonSupport.getJsonArray(jsonObject, "medium");
        if (mediumArray != null) {
            for (int i7 = 0; i7 < mediumArray.size(); ++i7) {
                builder.medium(this.parseCodeableConcept("medium", mediumArray.getJsonObject(i7), i7));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.topic(this.parseCodeableConcept("topic", JsonSupport.getJsonValue(jsonObject, "topic", JsonObject.class), -1));
        JsonArray aboutArray = JsonSupport.getJsonArray(jsonObject, "about");
        if (aboutArray != null) {
            for (int i8 = 0; i8 < aboutArray.size(); ++i8) {
                builder.about(this.parseReference("about", aboutArray.getJsonObject(i8), i8));
            }
        }
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.sent(this.parseDateTime("sent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sent", JsonString.class), (JsonValue)jsonObject.get((Object)"_sent"), -1));
        builder.received(this.parseDateTime("received", (JsonValue)JsonSupport.getJsonValue(jsonObject, "received", JsonString.class), (JsonValue)jsonObject.get((Object)"_received"), -1));
        JsonArray recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient");
        if (recipientArray != null) {
            for (int i9 = 0; i9 < recipientArray.size(); ++i9) {
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i9), i9));
            }
        }
        builder.sender(this.parseReference("sender", JsonSupport.getJsonValue(jsonObject, "sender", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i10 = 0; i10 < reasonCodeArray.size(); ++i10) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i10), i10));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i11 = 0; i11 < reasonReferenceArray.size(); ++i11) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i11), i11));
            }
        }
        if ((payloadArray = JsonSupport.getJsonArray(jsonObject, "payload")) != null) {
            for (int i12 = 0; i12 < payloadArray.size(); ++i12) {
                builder.payload(this.parseCommunicationPayload("payload", payloadArray.getJsonObject(i12), i12));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i13 = 0; i13 < noteArray.size(); ++i13) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Communication.Payload parseCommunicationPayload(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Communication.Payload.class, jsonObject);
        }
        Communication.Payload.Builder builder = Communication.Payload.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, com.ibm.fhir.model.type.String.class, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CommunicationRequest parseCommunicationRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        JsonArray replacesArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CommunicationRequest.class, jsonObject);
        }
        CommunicationRequest.Builder builder = CommunicationRequest.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((replacesArray = JsonSupport.getJsonArray(jsonObject, "replaces")) != null) {
            for (int i = 0; i < replacesArray.size(); ++i) {
                builder.replaces(this.parseReference("replaces", replacesArray.getJsonObject(i), i));
            }
        }
        builder.groupIdentifier(this.parseIdentifier("groupIdentifier", JsonSupport.getJsonValue(jsonObject, "groupIdentifier", JsonObject.class), -1));
        builder.status((CommunicationRequestStatus)this.parseString(CommunicationRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.priority((CommunicationPriority)this.parseString(CommunicationPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        JsonArray mediumArray = JsonSupport.getJsonArray(jsonObject, "medium");
        if (mediumArray != null) {
            for (int i = 0; i < mediumArray.size(); ++i) {
                builder.medium(this.parseCodeableConcept("medium", mediumArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray aboutArray = JsonSupport.getJsonArray(jsonObject, "about");
        if (aboutArray != null) {
            for (int i = 0; i < aboutArray.size(); ++i) {
                builder.about(this.parseReference("about", aboutArray.getJsonObject(i), i));
            }
        }
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        JsonArray payloadArray = JsonSupport.getJsonArray(jsonObject, "payload");
        if (payloadArray != null) {
            for (int i = 0; i < payloadArray.size(); ++i) {
                builder.payload(this.parseCommunicationRequestPayload("payload", payloadArray.getJsonObject(i), i));
            }
        }
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class));
        builder.authoredOn(this.parseDateTime("authoredOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authoredOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_authoredOn"), -1));
        builder.requester(this.parseReference("requester", JsonSupport.getJsonValue(jsonObject, "requester", JsonObject.class), -1));
        JsonArray recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient");
        if (recipientArray != null) {
            for (int i = 0; i < recipientArray.size(); ++i) {
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i), i));
            }
        }
        builder.sender(this.parseReference("sender", JsonSupport.getJsonValue(jsonObject, "sender", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CommunicationRequest.Payload parseCommunicationRequestPayload(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CommunicationRequest.Payload.class, jsonObject);
        }
        CommunicationRequest.Payload.Builder builder = CommunicationRequest.Payload.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, com.ibm.fhir.model.type.String.class, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CompartmentDefinition parseCompartmentDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CompartmentDefinition.class, jsonObject);
        }
        CompartmentDefinition.Builder builder = CompartmentDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.code((CompartmentType)this.parseString(CompartmentType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.search(this.parseBoolean("search", JsonSupport.getJsonValue(jsonObject, "search", JsonValue.class), (JsonValue)jsonObject.get((Object)"_search"), -1));
        JsonArray resourceArray = JsonSupport.getJsonArray(jsonObject, "resource");
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                builder.resource(this.parseCompartmentDefinitionResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CompartmentDefinition.Resource parseCompartmentDefinitionResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CompartmentDefinition.Resource.class, jsonObject);
        }
        CompartmentDefinition.Resource.Builder builder = CompartmentDefinition.Resource.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((ResourceType)this.parseString(ResourceType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        JsonArray paramArray = JsonSupport.getJsonArray(jsonObject, "param", true);
        if (paramArray != null) {
            JsonArray _paramArray = jsonObject.getJsonArray("_param");
            for (int i = 0; i < paramArray.size(); ++i) {
                builder.param(this.parseString("param", (JsonValue)paramArray.get(i), JsonSupport.getJsonValue(_paramArray, i), i));
            }
        }
        builder.documentation(this.parseString("documentation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentation", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentation"), -1));
        this.stackPop();
        return builder.build();
    }

    private Composition parseComposition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray sectionArray;
        JsonArray eventArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Composition.class, jsonObject);
        }
        Composition.Builder builder = Composition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.status((CompositionStatus)this.parseString(CompositionStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.confidentiality((DocumentConfidentiality)this.parseString(DocumentConfidentiality.builder(), "confidentiality", (JsonValue)JsonSupport.getJsonValue(jsonObject, "confidentiality", JsonString.class), (JsonValue)jsonObject.get((Object)"_confidentiality"), -1));
        JsonArray attesterArray = JsonSupport.getJsonArray(jsonObject, "attester");
        if (attesterArray != null) {
            for (int i = 0; i < attesterArray.size(); ++i) {
                builder.attester(this.parseCompositionAttester("attester", attesterArray.getJsonObject(i), i));
            }
        }
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        JsonArray relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo");
        if (relatesToArray != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                builder.relatesTo(this.parseCompositionRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        if ((eventArray = JsonSupport.getJsonArray(jsonObject, "event")) != null) {
            for (int i = 0; i < eventArray.size(); ++i) {
                builder.event(this.parseCompositionEvent("event", eventArray.getJsonObject(i), i));
            }
        }
        if ((sectionArray = JsonSupport.getJsonArray(jsonObject, "section")) != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                builder.section(this.parseCompositionSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Composition.Attester parseCompositionAttester(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Composition.Attester.class, jsonObject);
        }
        Composition.Attester.Builder builder = Composition.Attester.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((CompositionAttestationMode)this.parseString(CompositionAttestationMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.time(this.parseDateTime("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Composition.Event parseCompositionEvent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Composition.Event.class, jsonObject);
        }
        Composition.Event.Builder builder = Composition.Event.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray detailArray = JsonSupport.getJsonArray(jsonObject, "detail");
        if (detailArray != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Composition.RelatesTo parseCompositionRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Composition.RelatesTo.class, jsonObject);
        }
        Composition.RelatesTo.Builder builder = Composition.RelatesTo.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((DocumentRelationshipType)this.parseString(DocumentRelationshipType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.target(this.parseChoiceElement("target", jsonObject, Identifier.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Composition.Section parseCompositionSection(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Composition.Section.class, jsonObject);
        }
        Composition.Section.Builder builder = Composition.Section.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.focus(this.parseReference("focus", JsonSupport.getJsonValue(jsonObject, "focus", JsonObject.class), -1));
        builder.text(this.parseNarrative("text", JsonSupport.getJsonValue(jsonObject, "text", JsonObject.class), -1));
        builder.mode((SectionMode)this.parseString(SectionMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.orderedBy(this.parseCodeableConcept("orderedBy", JsonSupport.getJsonValue(jsonObject, "orderedBy", JsonObject.class), -1));
        JsonArray entryArray = JsonSupport.getJsonArray(jsonObject, "entry");
        if (entryArray != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                builder.entry(this.parseReference("entry", entryArray.getJsonObject(i), i));
            }
        }
        builder.emptyReason(this.parseCodeableConcept("emptyReason", JsonSupport.getJsonValue(jsonObject, "emptyReason", JsonObject.class), -1));
        JsonArray sectionArray = JsonSupport.getJsonArray(jsonObject, "section");
        if (sectionArray != null) {
            for (int i = 0; i < sectionArray.size(); ++i) {
                builder.section(this.parseCompositionSection("section", sectionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap parseConceptMap(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.class, jsonObject);
        }
        ConceptMap.Builder builder = ConceptMap.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.source(this.parseChoiceElement("source", jsonObject, Uri.class, Canonical.class));
        builder.target(this.parseChoiceElement("target", jsonObject, Uri.class, Canonical.class));
        JsonArray groupArray = JsonSupport.getJsonArray(jsonObject, "group");
        if (groupArray != null) {
            for (int i = 0; i < groupArray.size(); ++i) {
                builder.group(this.parseConceptMapGroup("group", groupArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group parseConceptMapGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.class, jsonObject);
        }
        ConceptMap.Group.Builder builder = ConceptMap.Group.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.source(this.parseUri("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.sourceVersion(this.parseString("sourceVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sourceVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_sourceVersion"), -1));
        builder.target(this.parseUri("target", (JsonValue)JsonSupport.getJsonValue(jsonObject, "target", JsonString.class), (JsonValue)jsonObject.get((Object)"_target"), -1));
        builder.targetVersion(this.parseString("targetVersion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "targetVersion", JsonString.class), (JsonValue)jsonObject.get((Object)"_targetVersion"), -1));
        JsonArray elementArray = JsonSupport.getJsonArray(jsonObject, "element");
        if (elementArray != null) {
            for (int i = 0; i < elementArray.size(); ++i) {
                builder.element(this.parseConceptMapGroupElement("element", elementArray.getJsonObject(i), i));
            }
        }
        builder.unmapped(this.parseConceptMapGroupUnmapped("unmapped", JsonSupport.getJsonValue(jsonObject, "unmapped", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element parseConceptMapGroupElement(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.class, jsonObject);
        }
        ConceptMap.Group.Element.Builder builder = ConceptMap.Group.Element.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                builder.target(this.parseConceptMapGroupElementTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element.Target parseConceptMapGroupElementTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray productArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.Target.class, jsonObject);
        }
        ConceptMap.Group.Element.Target.Builder builder = ConceptMap.Group.Element.Target.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.equivalence((ConceptMapEquivalence)this.parseString(ConceptMapEquivalence.builder(), "equivalence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "equivalence", JsonString.class), (JsonValue)jsonObject.get((Object)"_equivalence"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        JsonArray dependsOnArray = JsonSupport.getJsonArray(jsonObject, "dependsOn");
        if (dependsOnArray != null) {
            for (int i = 0; i < dependsOnArray.size(); ++i) {
                builder.dependsOn(this.parseConceptMapGroupElementTargetDependsOn("dependsOn", dependsOnArray.getJsonObject(i), i));
            }
        }
        if ((productArray = JsonSupport.getJsonArray(jsonObject, "product")) != null) {
            for (int i = 0; i < productArray.size(); ++i) {
                builder.product(this.parseConceptMapGroupElementTargetDependsOn("product", productArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Element.Target.DependsOn parseConceptMapGroupElementTargetDependsOn(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Element.Target.DependsOn.class, jsonObject);
        }
        ConceptMap.Group.Element.Target.DependsOn.Builder builder = ConceptMap.Group.Element.Target.DependsOn.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.property(this.parseUri("property", (JsonValue)JsonSupport.getJsonValue(jsonObject, "property", JsonString.class), (JsonValue)jsonObject.get((Object)"_property"), -1));
        builder.system((Canonical)this.parseUri(Canonical.builder(), "system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        this.stackPop();
        return builder.build();
    }

    private ConceptMap.Group.Unmapped parseConceptMapGroupUnmapped(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ConceptMap.Group.Unmapped.class, jsonObject);
        }
        ConceptMap.Group.Unmapped.Builder builder = ConceptMap.Group.Unmapped.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.mode((ConceptMapGroupUnmappedMode)this.parseString(ConceptMapGroupUnmappedMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.display(this.parseString("display", (JsonValue)JsonSupport.getJsonValue(jsonObject, "display", JsonString.class), (JsonValue)jsonObject.get((Object)"_display"), -1));
        builder.url((Canonical)this.parseUri(Canonical.builder(), "url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        this.stackPop();
        return builder.build();
    }

    private Condition parseCondition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray evidenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Condition.class, jsonObject);
        }
        Condition.Builder builder = Condition.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.clinicalStatus(this.parseCodeableConcept("clinicalStatus", JsonSupport.getJsonValue(jsonObject, "clinicalStatus", JsonObject.class), -1));
        builder.verificationStatus(this.parseCodeableConcept("verificationStatus", JsonSupport.getJsonValue(jsonObject, "verificationStatus", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.severity(this.parseCodeableConcept("severity", JsonSupport.getJsonValue(jsonObject, "severity", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray bodySiteArray = JsonSupport.getJsonArray(jsonObject, "bodySite");
        if (bodySiteArray != null) {
            for (int i = 0; i < bodySiteArray.size(); ++i) {
                builder.bodySite(this.parseCodeableConcept("bodySite", bodySiteArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, DateTime.class, Age.class, Period.class, Range.class, com.ibm.fhir.model.type.String.class));
        builder.abatement(this.parseChoiceElement("abatement", jsonObject, DateTime.class, Age.class, Period.class, Range.class, com.ibm.fhir.model.type.String.class));
        builder.recordedDate(this.parseDateTime("recordedDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedDate"), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        builder.asserter(this.parseReference("asserter", JsonSupport.getJsonValue(jsonObject, "asserter", JsonObject.class), -1));
        JsonArray stageArray = JsonSupport.getJsonArray(jsonObject, "stage");
        if (stageArray != null) {
            for (int i = 0; i < stageArray.size(); ++i) {
                builder.stage(this.parseConditionStage("stage", stageArray.getJsonObject(i), i));
            }
        }
        if ((evidenceArray = JsonSupport.getJsonArray(jsonObject, "evidence")) != null) {
            for (int i = 0; i < evidenceArray.size(); ++i) {
                builder.evidence(this.parseConditionEvidence("evidence", evidenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Condition.Evidence parseConditionEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Condition.Evidence.class, jsonObject);
        }
        Condition.Evidence.Builder builder = Condition.Evidence.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Condition.Stage parseConditionStage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Condition.Stage.class, jsonObject);
        }
        Condition.Stage.Builder builder = Condition.Stage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.summary(this.parseCodeableConcept("summary", JsonSupport.getJsonValue(jsonObject, "summary", JsonObject.class), -1));
        JsonArray assessmentArray = JsonSupport.getJsonArray(jsonObject, "assessment");
        if (assessmentArray != null) {
            for (int i = 0; i < assessmentArray.size(); ++i) {
                builder.assessment(this.parseReference("assessment", assessmentArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent parseConsent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray organizationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.class, jsonObject);
        }
        Consent.Builder builder = Consent.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ConsentState)this.parseString(ConsentState.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.dateTime(this.parseDateTime("dateTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dateTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_dateTime"), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((organizationArray = JsonSupport.getJsonArray(jsonObject, "organization")) != null) {
            for (int i = 0; i < organizationArray.size(); ++i) {
                builder.organization(this.parseReference("organization", organizationArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseChoiceElement("source", jsonObject, Attachment.class, Reference.class));
        JsonArray policyArray = JsonSupport.getJsonArray(jsonObject, "policy");
        if (policyArray != null) {
            for (int i = 0; i < policyArray.size(); ++i) {
                builder.policy(this.parseConsentPolicy("policy", policyArray.getJsonObject(i), i));
            }
        }
        builder.policyRule(this.parseCodeableConcept("policyRule", JsonSupport.getJsonValue(jsonObject, "policyRule", JsonObject.class), -1));
        JsonArray verificationArray = JsonSupport.getJsonArray(jsonObject, "verification");
        if (verificationArray != null) {
            for (int i = 0; i < verificationArray.size(); ++i) {
                builder.verification(this.parseConsentVerification("verification", verificationArray.getJsonObject(i), i));
            }
        }
        builder.provision(this.parseConsentProvision("provision", JsonSupport.getJsonValue(jsonObject, "provision", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Policy parseConsentPolicy(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.Policy.class, jsonObject);
        }
        Consent.Policy.Builder builder = Consent.Policy.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.authority(this.parseUri("authority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authority", JsonString.class), (JsonValue)jsonObject.get((Object)"_authority"), -1));
        builder.uri(this.parseUri("uri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uri", JsonString.class), (JsonValue)jsonObject.get((Object)"_uri"), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision parseConsentProvision(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray provisionArray;
        JsonArray codeArray;
        JsonArray classArray;
        JsonArray purposeArray;
        JsonArray securityLabelArray;
        JsonArray actionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.class, jsonObject);
        }
        Consent.Provision.Builder builder = Consent.Provision.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ConsentProvisionType)this.parseString(ConsentProvisionType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray actorArray = JsonSupport.getJsonArray(jsonObject, "actor");
        if (actorArray != null) {
            for (int i = 0; i < actorArray.size(); ++i) {
                builder.actor(this.parseConsentProvisionActor("actor", actorArray.getJsonObject(i), i));
            }
        }
        if ((actionArray = JsonSupport.getJsonArray(jsonObject, "action")) != null) {
            for (int i = 0; i < actionArray.size(); ++i) {
                builder.action(this.parseCodeableConcept("action", actionArray.getJsonObject(i), i));
            }
        }
        if ((securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel")) != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                builder.securityLabel(this.parseCoding("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        if ((purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose")) != null) {
            for (int i = 0; i < purposeArray.size(); ++i) {
                builder.purpose(this.parseCoding("purpose", purposeArray.getJsonObject(i), i));
            }
        }
        if ((classArray = JsonSupport.getJsonArray(jsonObject, "class")) != null) {
            for (int i = 0; i < classArray.size(); ++i) {
                builder.clazz(this.parseCoding("class", classArray.getJsonObject(i), i));
            }
        }
        if ((codeArray = JsonSupport.getJsonArray(jsonObject, "code")) != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.dataPeriod(this.parsePeriod("dataPeriod", JsonSupport.getJsonValue(jsonObject, "dataPeriod", JsonObject.class), -1));
        JsonArray dataArray = JsonSupport.getJsonArray(jsonObject, "data");
        if (dataArray != null) {
            for (int i = 0; i < dataArray.size(); ++i) {
                builder.data(this.parseConsentProvisionData("data", dataArray.getJsonObject(i), i));
            }
        }
        if ((provisionArray = JsonSupport.getJsonArray(jsonObject, "provision")) != null) {
            for (int i = 0; i < provisionArray.size(); ++i) {
                builder.provision(this.parseConsentProvision("provision", provisionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision.Actor parseConsentProvisionActor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.Actor.class, jsonObject);
        }
        Consent.Provision.Actor.Builder builder = Consent.Provision.Actor.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Provision.Data parseConsentProvisionData(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.Provision.Data.class, jsonObject);
        }
        Consent.Provision.Data.Builder builder = Consent.Provision.Data.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.meaning((ConsentDataMeaning)this.parseString(ConsentDataMeaning.builder(), "meaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "meaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_meaning"), -1));
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Consent.Verification parseConsentVerification(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Consent.Verification.class, jsonObject);
        }
        Consent.Verification.Builder builder = Consent.Verification.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.verified(this.parseBoolean("verified", JsonSupport.getJsonValue(jsonObject, "verified", JsonValue.class), (JsonValue)jsonObject.get((Object)"_verified"), -1));
        builder.verifiedWith(this.parseReference("verifiedWith", JsonSupport.getJsonValue(jsonObject, "verifiedWith", JsonObject.class), -1));
        builder.verificationDate(this.parseDateTime("verificationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "verificationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_verificationDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private ContactDetail parseContactDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ContactDetail.class, jsonObject);
        }
        ContactDetail.Builder builder = ContactDetail.builder();
        this.parseElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom");
        if (telecomArray != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ContactPoint parseContactPoint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ContactPoint.class, jsonObject);
        }
        ContactPoint.Builder builder = ContactPoint.builder();
        this.parseElement(builder, jsonObject);
        builder.system((ContactPointSystem)this.parseString(ContactPointSystem.builder(), "system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.use((ContactPointUse)this.parseString(ContactPointUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract parseContract(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray ruleArray;
        JsonArray legalArray;
        JsonArray friendlyArray;
        JsonArray signerArray;
        JsonArray relevantHistoryArray;
        JsonArray supportingInfoArray;
        int i;
        JsonArray siteArray;
        JsonArray domainArray;
        JsonArray authorityArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.class, jsonObject);
        }
        Contract.Builder builder = Contract.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.status((ContractStatus)this.parseString(ContractStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.legalState(this.parseCodeableConcept("legalState", JsonSupport.getJsonValue(jsonObject, "legalState", JsonObject.class), -1));
        builder.instantiatesCanonical(this.parseReference("instantiatesCanonical", JsonSupport.getJsonValue(jsonObject, "instantiatesCanonical", JsonObject.class), -1));
        builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "instantiatesUri", JsonString.class), (JsonValue)jsonObject.get((Object)"_instantiatesUri"), -1));
        builder.contentDerivative(this.parseCodeableConcept("contentDerivative", JsonSupport.getJsonValue(jsonObject, "contentDerivative", JsonObject.class), -1));
        builder.issued(this.parseDateTime("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        builder.applies(this.parsePeriod("applies", JsonSupport.getJsonValue(jsonObject, "applies", JsonObject.class), -1));
        builder.expirationType(this.parseCodeableConcept("expirationType", JsonSupport.getJsonValue(jsonObject, "expirationType", JsonObject.class), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i3 = 0; i3 < subjectArray.size(); ++i3) {
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i3), i3));
            }
        }
        if ((authorityArray = JsonSupport.getJsonArray(jsonObject, "authority")) != null) {
            for (int i4 = 0; i4 < authorityArray.size(); ++i4) {
                builder.authority(this.parseReference("authority", authorityArray.getJsonObject(i4), i4));
            }
        }
        if ((domainArray = JsonSupport.getJsonArray(jsonObject, "domain")) != null) {
            for (int i5 = 0; i5 < domainArray.size(); ++i5) {
                builder.domain(this.parseReference("domain", domainArray.getJsonObject(i5), i5));
            }
        }
        if ((siteArray = JsonSupport.getJsonArray(jsonObject, "site")) != null) {
            for (int i6 = 0; i6 < siteArray.size(); ++i6) {
                builder.site(this.parseReference("site", siteArray.getJsonObject(i6), i6));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i = 0; i < aliasArray.size(); ++i) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i), JsonSupport.getJsonValue(_aliasArray, i), i));
            }
        }
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        builder.topic(this.parseChoiceElement("topic", jsonObject, CodeableConcept.class, Reference.class));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subTypeArray = JsonSupport.getJsonArray(jsonObject, "subType");
        if (subTypeArray != null) {
            for (i = 0; i < subTypeArray.size(); ++i) {
                builder.subType(this.parseCodeableConcept("subType", subTypeArray.getJsonObject(i), i));
            }
        }
        builder.contentDefinition(this.parseContractContentDefinition("contentDefinition", JsonSupport.getJsonValue(jsonObject, "contentDefinition", JsonObject.class), -1));
        JsonArray termArray = JsonSupport.getJsonArray(jsonObject, "term");
        if (termArray != null) {
            for (int i7 = 0; i7 < termArray.size(); ++i7) {
                builder.term(this.parseContractTerm("term", termArray.getJsonObject(i7), i7));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i8 = 0; i8 < supportingInfoArray.size(); ++i8) {
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i8), i8));
            }
        }
        if ((relevantHistoryArray = JsonSupport.getJsonArray(jsonObject, "relevantHistory")) != null) {
            for (int i9 = 0; i9 < relevantHistoryArray.size(); ++i9) {
                builder.relevantHistory(this.parseReference("relevantHistory", relevantHistoryArray.getJsonObject(i9), i9));
            }
        }
        if ((signerArray = JsonSupport.getJsonArray(jsonObject, "signer")) != null) {
            for (int i10 = 0; i10 < signerArray.size(); ++i10) {
                builder.signer(this.parseContractSigner("signer", signerArray.getJsonObject(i10), i10));
            }
        }
        if ((friendlyArray = JsonSupport.getJsonArray(jsonObject, "friendly")) != null) {
            for (int i11 = 0; i11 < friendlyArray.size(); ++i11) {
                builder.friendly(this.parseContractFriendly("friendly", friendlyArray.getJsonObject(i11), i11));
            }
        }
        if ((legalArray = JsonSupport.getJsonArray(jsonObject, "legal")) != null) {
            for (int i12 = 0; i12 < legalArray.size(); ++i12) {
                builder.legal(this.parseContractLegal("legal", legalArray.getJsonObject(i12), i12));
            }
        }
        if ((ruleArray = JsonSupport.getJsonArray(jsonObject, "rule")) != null) {
            for (int i13 = 0; i13 < ruleArray.size(); ++i13) {
                builder.rule(this.parseContractRule("rule", ruleArray.getJsonObject(i13), i13));
            }
        }
        builder.legallyBinding(this.parseChoiceElement("legallyBinding", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.ContentDefinition parseContractContentDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.ContentDefinition.class, jsonObject);
        }
        Contract.ContentDefinition.Builder builder = Contract.ContentDefinition.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.publisher(this.parseReference("publisher", JsonSupport.getJsonValue(jsonObject, "publisher", JsonObject.class), -1));
        builder.publicationDate(this.parseDateTime("publicationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publicationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_publicationDate"), -1));
        builder.publicationStatus((ContractPublicationStatus)this.parseString(ContractPublicationStatus.builder(), "publicationStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publicationStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_publicationStatus"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Friendly parseContractFriendly(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Friendly.class, jsonObject);
        }
        Contract.Friendly.Builder builder = Contract.Friendly.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Legal parseContractLegal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Legal.class, jsonObject);
        }
        Contract.Legal.Builder builder = Contract.Legal.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Rule parseContractRule(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Rule.class, jsonObject);
        }
        Contract.Rule.Builder builder = Contract.Rule.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.content(this.parseChoiceElement("content", jsonObject, Attachment.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Signer parseContractSigner(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Signer.class, jsonObject);
        }
        Contract.Signer.Builder builder = Contract.Signer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        JsonArray signatureArray = JsonSupport.getJsonArray(jsonObject, "signature");
        if (signatureArray != null) {
            for (int i = 0; i < signatureArray.size(); ++i) {
                builder.signature(this.parseSignature("signature", signatureArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term parseContractTerm(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray groupArray;
        JsonArray actionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.class, jsonObject);
        }
        Contract.Term.Builder builder = Contract.Term.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.issued(this.parseDateTime("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        builder.applies(this.parsePeriod("applies", JsonSupport.getJsonValue(jsonObject, "applies", JsonObject.class), -1));
        builder.topic(this.parseChoiceElement("topic", jsonObject, CodeableConcept.class, Reference.class));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                builder.securityLabel(this.parseContractTermSecurityLabel("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        builder.offer(this.parseContractTermOffer("offer", JsonSupport.getJsonValue(jsonObject, "offer", JsonObject.class), -1));
        JsonArray assetArray = JsonSupport.getJsonArray(jsonObject, "asset");
        if (assetArray != null) {
            for (int i = 0; i < assetArray.size(); ++i) {
                builder.asset(this.parseContractTermAsset("asset", assetArray.getJsonObject(i), i));
            }
        }
        if ((actionArray = JsonSupport.getJsonArray(jsonObject, "action")) != null) {
            for (int i = 0; i < actionArray.size(); ++i) {
                builder.action(this.parseContractTermAction("action", actionArray.getJsonObject(i), i));
            }
        }
        if ((groupArray = JsonSupport.getJsonArray(jsonObject, "group")) != null) {
            for (int i = 0; i < groupArray.size(); ++i) {
                builder.group(this.parseContractTerm("group", groupArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Action parseContractTermAction(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        JsonArray noteArray;
        int i;
        JsonArray reasonLinkIdArray;
        JsonArray reasonArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        int i2;
        JsonArray performerTypeArray;
        int i3;
        JsonArray requesterLinkIdArray;
        int i4;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Action.class, jsonObject);
        }
        Contract.Term.Action.Builder builder = Contract.Term.Action.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i5 = 0; i5 < subjectArray.size(); ++i5) {
                builder.subject(this.parseContractTermActionSubject("subject", subjectArray.getJsonObject(i5), i5));
            }
        }
        builder.intent(this.parseCodeableConcept("intent", JsonSupport.getJsonValue(jsonObject, "intent", JsonObject.class), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i6 = 0; i6 < linkIdArray.size(); ++i6) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i6), JsonSupport.getJsonValue(_linkIdArray, i6), i6));
            }
        }
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        JsonArray contextLinkIdArray = JsonSupport.getJsonArray(jsonObject, "contextLinkId", true);
        if (contextLinkIdArray != null) {
            JsonArray _contextLinkIdArray = jsonObject.getJsonArray("_contextLinkId");
            for (i4 = 0; i4 < contextLinkIdArray.size(); ++i4) {
                builder.contextLinkId(this.parseString("contextLinkId", (JsonValue)contextLinkIdArray.get(i4), JsonSupport.getJsonValue(_contextLinkIdArray, i4), i4));
            }
        }
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        JsonArray requesterArray = JsonSupport.getJsonArray(jsonObject, "requester");
        if (requesterArray != null) {
            for (i4 = 0; i4 < requesterArray.size(); ++i4) {
                builder.requester(this.parseReference("requester", requesterArray.getJsonObject(i4), i4));
            }
        }
        if ((requesterLinkIdArray = JsonSupport.getJsonArray(jsonObject, "requesterLinkId", true)) != null) {
            JsonArray _requesterLinkIdArray = jsonObject.getJsonArray("_requesterLinkId");
            for (i3 = 0; i3 < requesterLinkIdArray.size(); ++i3) {
                builder.requesterLinkId(this.parseString("requesterLinkId", (JsonValue)requesterLinkIdArray.get(i3), JsonSupport.getJsonValue(_requesterLinkIdArray, i3), i3));
            }
        }
        if ((performerTypeArray = JsonSupport.getJsonArray(jsonObject, "performerType")) != null) {
            for (i3 = 0; i3 < performerTypeArray.size(); ++i3) {
                builder.performerType(this.parseCodeableConcept("performerType", performerTypeArray.getJsonObject(i3), i3));
            }
        }
        builder.performerRole(this.parseCodeableConcept("performerRole", JsonSupport.getJsonValue(jsonObject, "performerRole", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        JsonArray performerLinkIdArray = JsonSupport.getJsonArray(jsonObject, "performerLinkId", true);
        if (performerLinkIdArray != null) {
            JsonArray _performerLinkIdArray = jsonObject.getJsonArray("_performerLinkId");
            for (i2 = 0; i2 < performerLinkIdArray.size(); ++i2) {
                builder.performerLinkId(this.parseString("performerLinkId", (JsonValue)performerLinkIdArray.get(i2), JsonSupport.getJsonValue(_performerLinkIdArray, i2), i2));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (i2 = 0; i2 < reasonCodeArray.size(); ++i2) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i2), i2));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i7 = 0; i7 < reasonReferenceArray.size(); ++i7) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i7), i7));
            }
        }
        if ((reasonArray = JsonSupport.getJsonArray(jsonObject, "reason", true)) != null) {
            JsonArray _reasonArray = jsonObject.getJsonArray("_reason");
            for (int i8 = 0; i8 < reasonArray.size(); ++i8) {
                builder.reason(this.parseString("reason", (JsonValue)reasonArray.get(i8), JsonSupport.getJsonValue(_reasonArray, i8), i8));
            }
        }
        if ((reasonLinkIdArray = JsonSupport.getJsonArray(jsonObject, "reasonLinkId", true)) != null) {
            JsonArray _reasonLinkIdArray = jsonObject.getJsonArray("_reasonLinkId");
            for (i = 0; i < reasonLinkIdArray.size(); ++i) {
                builder.reasonLinkId(this.parseString("reasonLinkId", (JsonValue)reasonLinkIdArray.get(i), JsonSupport.getJsonValue(_reasonLinkIdArray, i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i9 = 0; i9 < securityLabelNumberArray.size(); ++i9) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i9), JsonSupport.getJsonValue(_securityLabelNumberArray, i9), i9));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Action.Subject parseContractTermActionSubject(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Action.Subject.class, jsonObject);
        }
        Contract.Term.Action.Subject.Builder builder = Contract.Term.Action.Subject.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray referenceArray = JsonSupport.getJsonArray(jsonObject, "reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                builder.reference(this.parseReference("reference", referenceArray.getJsonObject(i), i));
            }
        }
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset parseContractTermAsset(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valuedItemArray;
        int i;
        JsonArray securityLabelNumberArray;
        JsonArray answerArray;
        int i2;
        JsonArray usePeriodArray;
        JsonArray periodArray;
        JsonArray subtypeArray;
        JsonArray typeReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.class, jsonObject);
        }
        Contract.Term.Asset.Builder builder = Contract.Term.Asset.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.scope(this.parseCodeableConcept("scope", JsonSupport.getJsonValue(jsonObject, "scope", JsonObject.class), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i3 = 0; i3 < typeArray.size(); ++i3) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i3), i3));
            }
        }
        if ((typeReferenceArray = JsonSupport.getJsonArray(jsonObject, "typeReference")) != null) {
            for (int i4 = 0; i4 < typeReferenceArray.size(); ++i4) {
                builder.typeReference(this.parseReference("typeReference", typeReferenceArray.getJsonObject(i4), i4));
            }
        }
        if ((subtypeArray = JsonSupport.getJsonArray(jsonObject, "subtype")) != null) {
            for (int i5 = 0; i5 < subtypeArray.size(); ++i5) {
                builder.subtype(this.parseCodeableConcept("subtype", subtypeArray.getJsonObject(i5), i5));
            }
        }
        builder.relationship(this.parseCoding("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        JsonArray contextArray = JsonSupport.getJsonArray(jsonObject, "context");
        if (contextArray != null) {
            for (int i6 = 0; i6 < contextArray.size(); ++i6) {
                builder.context(this.parseContractTermAssetContext("context", contextArray.getJsonObject(i6), i6));
            }
        }
        builder.condition(this.parseString("condition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "condition", JsonString.class), (JsonValue)jsonObject.get((Object)"_condition"), -1));
        JsonArray periodTypeArray = JsonSupport.getJsonArray(jsonObject, "periodType");
        if (periodTypeArray != null) {
            for (int i7 = 0; i7 < periodTypeArray.size(); ++i7) {
                builder.periodType(this.parseCodeableConcept("periodType", periodTypeArray.getJsonObject(i7), i7));
            }
        }
        if ((periodArray = JsonSupport.getJsonArray(jsonObject, "period")) != null) {
            for (int i8 = 0; i8 < periodArray.size(); ++i8) {
                builder.period(this.parsePeriod("period", periodArray.getJsonObject(i8), i8));
            }
        }
        if ((usePeriodArray = JsonSupport.getJsonArray(jsonObject, "usePeriod")) != null) {
            for (int i9 = 0; i9 < usePeriodArray.size(); ++i9) {
                builder.usePeriod(this.parsePeriod("usePeriod", usePeriodArray.getJsonObject(i9), i9));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (i2 = 0; i2 < linkIdArray.size(); ++i2) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i2), JsonSupport.getJsonValue(_linkIdArray, i2), i2));
            }
        }
        if ((answerArray = JsonSupport.getJsonArray(jsonObject, "answer")) != null) {
            for (i2 = 0; i2 < answerArray.size(); ++i2) {
                builder.answer(this.parseContractTermOfferAnswer("answer", answerArray.getJsonObject(i2), i2));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        if ((valuedItemArray = JsonSupport.getJsonArray(jsonObject, "valuedItem")) != null) {
            for (i = 0; i < valuedItemArray.size(); ++i) {
                builder.valuedItem(this.parseContractTermAssetValuedItem("valuedItem", valuedItemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset.Context parseContractTermAssetContext(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.Context.class, jsonObject);
        }
        Contract.Term.Asset.Context.Builder builder = Contract.Term.Asset.Context.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Asset.ValuedItem parseContractTermAssetValuedItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Asset.ValuedItem.class, jsonObject);
        }
        Contract.Term.Asset.ValuedItem.Builder builder = Contract.Term.Asset.ValuedItem.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.entity(this.parseChoiceElement("entity", jsonObject, CodeableConcept.class, Reference.class));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.effectiveTime(this.parseDateTime("effectiveTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "effectiveTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_effectiveTime"), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.points(this.parseDecimal("points", (JsonValue)JsonSupport.getJsonValue(jsonObject, "points", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_points"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.payment(this.parseString("payment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "payment", JsonString.class), (JsonValue)jsonObject.get((Object)"_payment"), -1));
        builder.paymentDate(this.parseDateTime("paymentDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "paymentDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_paymentDate"), -1));
        builder.responsible(this.parseReference("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonObject.class), -1));
        builder.recipient(this.parseReference("recipient", JsonSupport.getJsonValue(jsonObject, "recipient", JsonObject.class), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i = 0; i < linkIdArray.size(); ++i) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i), JsonSupport.getJsonValue(_linkIdArray, i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer parseContractTermOffer(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray securityLabelNumberArray;
        JsonArray answerArray;
        JsonArray partyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.class, jsonObject);
        }
        Contract.Term.Offer.Builder builder = Contract.Term.Offer.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((partyArray = JsonSupport.getJsonArray(jsonObject, "party")) != null) {
            for (int i = 0; i < partyArray.size(); ++i) {
                builder.party(this.parseContractTermOfferParty("party", partyArray.getJsonObject(i), i));
            }
        }
        builder.topic(this.parseReference("topic", JsonSupport.getJsonValue(jsonObject, "topic", JsonObject.class), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.decision(this.parseCodeableConcept("decision", JsonSupport.getJsonValue(jsonObject, "decision", JsonObject.class), -1));
        JsonArray decisionModeArray = JsonSupport.getJsonArray(jsonObject, "decisionMode");
        if (decisionModeArray != null) {
            for (int i = 0; i < decisionModeArray.size(); ++i) {
                builder.decisionMode(this.parseCodeableConcept("decisionMode", decisionModeArray.getJsonObject(i), i));
            }
        }
        if ((answerArray = JsonSupport.getJsonArray(jsonObject, "answer")) != null) {
            for (int i = 0; i < answerArray.size(); ++i) {
                builder.answer(this.parseContractTermOfferAnswer("answer", answerArray.getJsonObject(i), i));
            }
        }
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray linkIdArray = JsonSupport.getJsonArray(jsonObject, "linkId", true);
        if (linkIdArray != null) {
            JsonArray _linkIdArray = jsonObject.getJsonArray("_linkId");
            for (int i = 0; i < linkIdArray.size(); ++i) {
                builder.linkId(this.parseString("linkId", (JsonValue)linkIdArray.get(i), JsonSupport.getJsonValue(_linkIdArray, i), i));
            }
        }
        if ((securityLabelNumberArray = JsonSupport.getJsonArray(jsonObject, "securityLabelNumber", true)) != null) {
            JsonArray _securityLabelNumberArray = jsonObject.getJsonArray("_securityLabelNumber");
            for (int i = 0; i < securityLabelNumberArray.size(); ++i) {
                builder.securityLabelNumber((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "securityLabelNumber", (JsonValue)securityLabelNumberArray.get(i), JsonSupport.getJsonValue(_securityLabelNumberArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer.Answer parseContractTermOfferAnswer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.Answer.class, jsonObject);
        }
        Contract.Term.Offer.Answer.Builder builder = Contract.Term.Offer.Answer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, com.ibm.fhir.model.type.String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.Offer.Party parseContractTermOfferParty(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.Offer.Party.class, jsonObject);
        }
        Contract.Term.Offer.Party.Builder builder = Contract.Term.Offer.Party.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray referenceArray = JsonSupport.getJsonArray(jsonObject, "reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                builder.reference(this.parseReference("reference", referenceArray.getJsonObject(i), i));
            }
        }
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Contract.Term.SecurityLabel parseContractTermSecurityLabel(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray controlArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contract.Term.SecurityLabel.class, jsonObject);
        }
        Contract.Term.SecurityLabel.Builder builder = Contract.Term.SecurityLabel.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray numberArray = JsonSupport.getJsonArray(jsonObject, "number", true);
        if (numberArray != null) {
            JsonArray _numberArray = jsonObject.getJsonArray("_number");
            for (i = 0; i < numberArray.size(); ++i) {
                builder.number((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "number", (JsonValue)numberArray.get(i), JsonSupport.getJsonValue(_numberArray, i), i));
            }
        }
        builder.classification(this.parseCoding("classification", JsonSupport.getJsonValue(jsonObject, "classification", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCoding("category", categoryArray.getJsonObject(i), i));
            }
        }
        if ((controlArray = JsonSupport.getJsonArray(jsonObject, "control")) != null) {
            for (int i2 = 0; i2 < controlArray.size(); ++i2) {
                builder.control(this.parseCoding("control", controlArray.getJsonObject(i2), i2));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Contributor parseContributor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Contributor.class, jsonObject);
        }
        Contributor.Builder builder = Contributor.builder();
        this.parseElement(builder, jsonObject);
        builder.type((ContributorType)this.parseString(ContributorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage parseCoverage(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray classArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Coverage.class, jsonObject);
        }
        Coverage.Builder builder = Coverage.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((CoverageStatus)this.parseString(CoverageStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.policyHolder(this.parseReference("policyHolder", JsonSupport.getJsonValue(jsonObject, "policyHolder", JsonObject.class), -1));
        builder.subscriber(this.parseReference("subscriber", JsonSupport.getJsonValue(jsonObject, "subscriber", JsonObject.class), -1));
        builder.subscriberId(this.parseString("subscriberId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subscriberId", JsonString.class), (JsonValue)jsonObject.get((Object)"_subscriberId"), -1));
        builder.beneficiary(this.parseReference("beneficiary", JsonSupport.getJsonValue(jsonObject, "beneficiary", JsonObject.class), -1));
        builder.dependent(this.parseString("dependent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dependent", JsonString.class), (JsonValue)jsonObject.get((Object)"_dependent"), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray payorArray = JsonSupport.getJsonArray(jsonObject, "payor");
        if (payorArray != null) {
            for (int i = 0; i < payorArray.size(); ++i) {
                builder.payor(this.parseReference("payor", payorArray.getJsonObject(i), i));
            }
        }
        if ((classArray = JsonSupport.getJsonArray(jsonObject, "class")) != null) {
            for (int i = 0; i < classArray.size(); ++i) {
                builder.clazz(this.parseCoverageClass("class", classArray.getJsonObject(i), i));
            }
        }
        builder.order((PositiveInt)this.parseInteger(PositiveInt.builder(), "order", (JsonValue)JsonSupport.getJsonValue(jsonObject, "order", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_order"), -1));
        builder.network(this.parseString("network", (JsonValue)JsonSupport.getJsonValue(jsonObject, "network", JsonString.class), (JsonValue)jsonObject.get((Object)"_network"), -1));
        JsonArray costToBeneficiaryArray = JsonSupport.getJsonArray(jsonObject, "costToBeneficiary");
        if (costToBeneficiaryArray != null) {
            for (int i = 0; i < costToBeneficiaryArray.size(); ++i) {
                builder.costToBeneficiary(this.parseCoverageCostToBeneficiary("costToBeneficiary", costToBeneficiaryArray.getJsonObject(i), i));
            }
        }
        builder.subrogation(this.parseBoolean("subrogation", JsonSupport.getJsonValue(jsonObject, "subrogation", JsonValue.class), (JsonValue)jsonObject.get((Object)"_subrogation"), -1));
        JsonArray contractArray = JsonSupport.getJsonArray(jsonObject, "contract");
        if (contractArray != null) {
            for (int i = 0; i < contractArray.size(); ++i) {
                builder.contract(this.parseReference("contract", contractArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage.Class parseCoverageClass(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Coverage.Class.class, jsonObject);
        }
        Coverage.Class.Builder builder = Coverage.Class.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        this.stackPop();
        return builder.build();
    }

    private Coverage.CostToBeneficiary parseCoverageCostToBeneficiary(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Coverage.CostToBeneficiary.class, jsonObject);
        }
        Coverage.CostToBeneficiary.Builder builder = Coverage.CostToBeneficiary.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, SimpleQuantity.class, Money.class));
        JsonArray exceptionArray = JsonSupport.getJsonArray(jsonObject, "exception");
        if (exceptionArray != null) {
            for (int i = 0; i < exceptionArray.size(); ++i) {
                builder.exception(this.parseCoverageCostToBeneficiaryException("exception", exceptionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Coverage.CostToBeneficiary.Exception parseCoverageCostToBeneficiaryException(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Coverage.CostToBeneficiary.Exception.class, jsonObject);
        }
        Coverage.CostToBeneficiary.Exception.Builder builder = Coverage.CostToBeneficiary.Exception.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest parseCoverageEligibilityRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray itemArray;
        JsonArray insuranceArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.class, jsonObject);
        }
        CoverageEligibilityRequest.Builder builder = CoverageEligibilityRequest.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((EligibilityRequestStatus)this.parseString(EligibilityRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        JsonArray purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose", true);
        if (purposeArray != null) {
            JsonArray _purposeArray = jsonObject.getJsonArray("_purpose");
            for (i = 0; i < purposeArray.size(); ++i) {
                builder.purpose((EligibilityRequestPurpose)this.parseString(EligibilityRequestPurpose.builder(), "purpose", (JsonValue)purposeArray.get(i), JsonSupport.getJsonValue(_purposeArray, i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo");
        if (supportingInfoArray != null) {
            for (i = 0; i < supportingInfoArray.size(); ++i) {
                builder.supportingInfo(this.parseCoverageEligibilityRequestSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i), i));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i3 = 0; i3 < insuranceArray.size(); ++i3) {
                builder.insurance(this.parseCoverageEligibilityRequestInsurance("insurance", insuranceArray.getJsonObject(i3), i3));
            }
        }
        if ((itemArray = JsonSupport.getJsonArray(jsonObject, "item")) != null) {
            for (int i4 = 0; i4 < itemArray.size(); ++i4) {
                builder.item(this.parseCoverageEligibilityRequestItem("item", itemArray.getJsonObject(i4), i4));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Insurance parseCoverageEligibilityRequestInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Insurance.class, jsonObject);
        }
        CoverageEligibilityRequest.Insurance.Builder builder = CoverageEligibilityRequest.Insurance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.businessArrangement(this.parseString("businessArrangement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "businessArrangement", JsonString.class), (JsonValue)jsonObject.get((Object)"_businessArrangement"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Item parseCoverageEligibilityRequestItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Item.class, jsonObject);
        }
        CoverageEligibilityRequest.Item.Builder builder = CoverageEligibilityRequest.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray supportingInfoSequenceArray = JsonSupport.getJsonArray(jsonObject, "supportingInfoSequence", true);
        if (supportingInfoSequenceArray != null) {
            JsonArray _supportingInfoSequenceArray = jsonObject.getJsonArray("_supportingInfoSequence");
            for (i = 0; i < supportingInfoSequenceArray.size(); ++i) {
                builder.supportingInfoSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "supportingInfoSequence", (JsonValue)supportingInfoSequenceArray.get(i), JsonSupport.getJsonValue(_supportingInfoSequenceArray, i), i));
            }
        }
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i = 0; i < modifierArray.size(); ++i) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        JsonArray diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis");
        if (diagnosisArray != null) {
            for (int i2 = 0; i2 < diagnosisArray.size(); ++i2) {
                builder.diagnosis(this.parseCoverageEligibilityRequestItemDiagnosis("diagnosis", diagnosisArray.getJsonObject(i2), i2));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i3 = 0; i3 < detailArray.size(); ++i3) {
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.Item.Diagnosis parseCoverageEligibilityRequestItemDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.Item.Diagnosis.class, jsonObject);
        }
        CoverageEligibilityRequest.Item.Diagnosis.Builder builder = CoverageEligibilityRequest.Item.Diagnosis.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityRequest.SupportingInfo parseCoverageEligibilityRequestSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityRequest.SupportingInfo.class, jsonObject);
        }
        CoverageEligibilityRequest.SupportingInfo.Builder builder = CoverageEligibilityRequest.SupportingInfo.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.information(this.parseReference("information", JsonSupport.getJsonValue(jsonObject, "information", JsonObject.class), -1));
        builder.appliesToAll(this.parseBoolean("appliesToAll", JsonSupport.getJsonValue(jsonObject, "appliesToAll", JsonValue.class), (JsonValue)jsonObject.get((Object)"_appliesToAll"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse parseCoverageEligibilityResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.class, jsonObject);
        }
        CoverageEligibilityResponse.Builder builder = CoverageEligibilityResponse.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((EligibilityResponseStatus)this.parseString(EligibilityResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray purposeArray = JsonSupport.getJsonArray(jsonObject, "purpose", true);
        if (purposeArray != null) {
            JsonArray _purposeArray = jsonObject.getJsonArray("_purpose");
            for (i = 0; i < purposeArray.size(); ++i) {
                builder.purpose((EligibilityResponsePurpose)this.parseString(EligibilityResponsePurpose.builder(), "purpose", (JsonValue)purposeArray.get(i), JsonSupport.getJsonValue(_purposeArray, i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.requestor(this.parseReference("requestor", JsonSupport.getJsonValue(jsonObject, "requestor", JsonObject.class), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        JsonArray insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance");
        if (insuranceArray != null) {
            for (i = 0; i < insuranceArray.size(); ++i) {
                builder.insurance(this.parseCoverageEligibilityResponseInsurance("insurance", insuranceArray.getJsonObject(i), i));
            }
        }
        builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preAuthRef", JsonString.class), (JsonValue)jsonObject.get((Object)"_preAuthRef"), -1));
        builder.form(this.parseCodeableConcept("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray errorArray = JsonSupport.getJsonArray(jsonObject, "error");
        if (errorArray != null) {
            for (int i3 = 0; i3 < errorArray.size(); ++i3) {
                builder.error(this.parseCoverageEligibilityResponseError("error", errorArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Error parseCoverageEligibilityResponseError(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Error.class, jsonObject);
        }
        CoverageEligibilityResponse.Error.Builder builder = CoverageEligibilityResponse.Error.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance parseCoverageEligibilityResponseInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Builder builder = CoverageEligibilityResponse.Insurance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        builder.inforce(this.parseBoolean("inforce", JsonSupport.getJsonValue(jsonObject, "inforce", JsonValue.class), (JsonValue)jsonObject.get((Object)"_inforce"), -1));
        builder.benefitPeriod(this.parsePeriod("benefitPeriod", JsonSupport.getJsonValue(jsonObject, "benefitPeriod", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                builder.item(this.parseCoverageEligibilityResponseInsuranceItem("item", itemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance.Item parseCoverageEligibilityResponseInsuranceItem(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.Item.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Item.Builder builder = CoverageEligibilityResponse.Insurance.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i = 0; i < modifierArray.size(); ++i) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i), i));
            }
        }
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.excluded(this.parseBoolean("excluded", JsonSupport.getJsonValue(jsonObject, "excluded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_excluded"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.network(this.parseCodeableConcept("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.term(this.parseCodeableConcept("term", JsonSupport.getJsonValue(jsonObject, "term", JsonObject.class), -1));
        JsonArray benefitArray = JsonSupport.getJsonArray(jsonObject, "benefit");
        if (benefitArray != null) {
            for (int i = 0; i < benefitArray.size(); ++i) {
                builder.benefit(this.parseCoverageEligibilityResponseInsuranceItemBenefit("benefit", benefitArray.getJsonObject(i), i));
            }
        }
        builder.authorizationRequired(this.parseBoolean("authorizationRequired", JsonSupport.getJsonValue(jsonObject, "authorizationRequired", JsonValue.class), (JsonValue)jsonObject.get((Object)"_authorizationRequired"), -1));
        JsonArray authorizationSupportingArray = JsonSupport.getJsonArray(jsonObject, "authorizationSupporting");
        if (authorizationSupportingArray != null) {
            for (int i = 0; i < authorizationSupportingArray.size(); ++i) {
                builder.authorizationSupporting(this.parseCodeableConcept("authorizationSupporting", authorizationSupportingArray.getJsonObject(i), i));
            }
        }
        builder.authorizationUrl(this.parseUri("authorizationUrl", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authorizationUrl", JsonString.class), (JsonValue)jsonObject.get((Object)"_authorizationUrl"), -1));
        this.stackPop();
        return builder.build();
    }

    private CoverageEligibilityResponse.Insurance.Item.Benefit parseCoverageEligibilityResponseInsuranceItemBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(CoverageEligibilityResponse.Insurance.Item.Benefit.class, jsonObject);
        }
        CoverageEligibilityResponse.Insurance.Item.Benefit.Builder builder = CoverageEligibilityResponse.Insurance.Item.Benefit.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.allowed(this.parseChoiceElement("allowed", jsonObject, UnsignedInt.class, com.ibm.fhir.model.type.String.class, Money.class));
        builder.used(this.parseChoiceElement("used", jsonObject, UnsignedInt.class, com.ibm.fhir.model.type.String.class, Money.class));
        this.stackPop();
        return builder.build();
    }

    private DataRequirement parseDataRequirement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray dateFilterArray;
        JsonArray codeFilterArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.class, jsonObject);
        }
        DataRequirement.Builder builder = DataRequirement.builder();
        this.parseElement(builder, jsonObject);
        builder.type((FHIRAllTypes)this.parseString(FHIRAllTypes.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray profileArray = JsonSupport.getJsonArray(jsonObject, "profile", true);
        if (profileArray != null) {
            JsonArray _profileArray = jsonObject.getJsonArray("_profile");
            for (int i2 = 0; i2 < profileArray.size(); ++i2) {
                builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)profileArray.get(i2), JsonSupport.getJsonValue(_profileArray, i2), i2));
            }
        }
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray mustSupportArray = JsonSupport.getJsonArray(jsonObject, "mustSupport", true);
        if (mustSupportArray != null) {
            JsonArray _mustSupportArray = jsonObject.getJsonArray("_mustSupport");
            for (i = 0; i < mustSupportArray.size(); ++i) {
                builder.mustSupport(this.parseString("mustSupport", (JsonValue)mustSupportArray.get(i), JsonSupport.getJsonValue(_mustSupportArray, i), i));
            }
        }
        if ((codeFilterArray = JsonSupport.getJsonArray(jsonObject, "codeFilter")) != null) {
            for (i = 0; i < codeFilterArray.size(); ++i) {
                builder.codeFilter(this.parseDataRequirementCodeFilter("codeFilter", codeFilterArray.getJsonObject(i), i));
            }
        }
        if ((dateFilterArray = JsonSupport.getJsonArray(jsonObject, "dateFilter")) != null) {
            for (int i3 = 0; i3 < dateFilterArray.size(); ++i3) {
                builder.dateFilter(this.parseDataRequirementDateFilter("dateFilter", dateFilterArray.getJsonObject(i3), i3));
            }
        }
        builder.limit((PositiveInt)this.parseInteger(PositiveInt.builder(), "limit", (JsonValue)JsonSupport.getJsonValue(jsonObject, "limit", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_limit"), -1));
        JsonArray sortArray = JsonSupport.getJsonArray(jsonObject, "sort");
        if (sortArray != null) {
            for (int i4 = 0; i4 < sortArray.size(); ++i4) {
                builder.sort(this.parseDataRequirementSort("sort", sortArray.getJsonObject(i4), i4));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.CodeFilter parseDataRequirementCodeFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.CodeFilter.class, jsonObject);
        }
        DataRequirement.CodeFilter.Builder builder = DataRequirement.CodeFilter.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.searchParam(this.parseString("searchParam", (JsonValue)JsonSupport.getJsonValue(jsonObject, "searchParam", JsonString.class), (JsonValue)jsonObject.get((Object)"_searchParam"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCoding("code", codeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.DateFilter parseDataRequirementDateFilter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.DateFilter.class, jsonObject);
        }
        DataRequirement.DateFilter.Builder builder = DataRequirement.DateFilter.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.searchParam(this.parseString("searchParam", (JsonValue)JsonSupport.getJsonValue(jsonObject, "searchParam", JsonString.class), (JsonValue)jsonObject.get((Object)"_searchParam"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, DateTime.class, Period.class, Duration.class));
        this.stackPop();
        return builder.build();
    }

    private DataRequirement.Sort parseDataRequirementSort(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DataRequirement.Sort.class, jsonObject);
        }
        DataRequirement.Sort.Builder builder = DataRequirement.Sort.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.direction((SortDirection)this.parseString(SortDirection.builder(), "direction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "direction", JsonString.class), (JsonValue)jsonObject.get((Object)"_direction"), -1));
        this.stackPop();
        return builder.build();
    }

    private Date parseDate(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Date.Builder builder = Date.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private DateTime parseDateTime(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        DateTime.Builder builder = DateTime.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Decimal parseDecimal(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Decimal.Builder builder = Decimal.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            builder.value(jsonNumber.bigDecimalValue());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: NUMBER but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue parseDetectedIssue(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray evidenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.class, jsonObject);
        }
        DetectedIssue.Builder builder = DetectedIssue.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DetectedIssueStatus)this.parseString(DetectedIssueStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.severity((DetectedIssueSeverity)this.parseString(DetectedIssueSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.identified(this.parseChoiceElement("identified", jsonObject, DateTime.class, Period.class));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        JsonArray implicatedArray = JsonSupport.getJsonArray(jsonObject, "implicated");
        if (implicatedArray != null) {
            for (int i = 0; i < implicatedArray.size(); ++i) {
                builder.implicated(this.parseReference("implicated", implicatedArray.getJsonObject(i), i));
            }
        }
        if ((evidenceArray = JsonSupport.getJsonArray(jsonObject, "evidence")) != null) {
            for (int i = 0; i < evidenceArray.size(); ++i) {
                builder.evidence(this.parseDetectedIssueEvidence("evidence", evidenceArray.getJsonObject(i), i));
            }
        }
        builder.detail(this.parseString("detail", (JsonValue)JsonSupport.getJsonValue(jsonObject, "detail", JsonString.class), (JsonValue)jsonObject.get((Object)"_detail"), -1));
        builder.reference(this.parseUri("reference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reference", JsonString.class), (JsonValue)jsonObject.get((Object)"_reference"), -1));
        JsonArray mitigationArray = JsonSupport.getJsonArray(jsonObject, "mitigation");
        if (mitigationArray != null) {
            for (int i = 0; i < mitigationArray.size(); ++i) {
                builder.mitigation(this.parseDetectedIssueMitigation("mitigation", mitigationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue.Evidence parseDetectedIssueEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.Evidence.class, jsonObject);
        }
        DetectedIssue.Evidence.Builder builder = DetectedIssue.Evidence.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i = 0; i < detailArray.size(); ++i) {
                builder.detail(this.parseReference("detail", detailArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DetectedIssue.Mitigation parseDetectedIssueMitigation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DetectedIssue.Mitigation.class, jsonObject);
        }
        DetectedIssue.Mitigation.Builder builder = DetectedIssue.Mitigation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.action(this.parseCodeableConcept("action", JsonSupport.getJsonValue(jsonObject, "action", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Device parseDevice(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray safetyArray;
        JsonArray propertyArray;
        JsonArray versionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.class, jsonObject);
        }
        Device.Builder builder = Device.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.definition(this.parseReference("definition", JsonSupport.getJsonValue(jsonObject, "definition", JsonObject.class), -1));
        JsonArray udiCarrierArray = JsonSupport.getJsonArray(jsonObject, "udiCarrier");
        if (udiCarrierArray != null) {
            for (int i = 0; i < udiCarrierArray.size(); ++i) {
                builder.udiCarrier(this.parseDeviceUdiCarrier("udiCarrier", udiCarrierArray.getJsonObject(i), i));
            }
        }
        builder.status((FHIRDeviceStatus)this.parseString(FHIRDeviceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusReasonArray = JsonSupport.getJsonArray(jsonObject, "statusReason");
        if (statusReasonArray != null) {
            for (int i = 0; i < statusReasonArray.size(); ++i) {
                builder.statusReason(this.parseCodeableConcept("statusReason", statusReasonArray.getJsonObject(i), i));
            }
        }
        builder.distinctIdentifier(this.parseString("distinctIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "distinctIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_distinctIdentifier"), -1));
        builder.manufacturer(this.parseString("manufacturer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "manufacturer", JsonString.class), (JsonValue)jsonObject.get((Object)"_manufacturer"), -1));
        builder.manufactureDate(this.parseDateTime("manufactureDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "manufactureDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_manufactureDate"), -1));
        builder.expirationDate(this.parseDateTime("expirationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expirationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_expirationDate"), -1));
        builder.lotNumber(this.parseString("lotNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lotNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_lotNumber"), -1));
        builder.serialNumber(this.parseString("serialNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "serialNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_serialNumber"), -1));
        JsonArray deviceNameArray = JsonSupport.getJsonArray(jsonObject, "deviceName");
        if (deviceNameArray != null) {
            for (int i = 0; i < deviceNameArray.size(); ++i) {
                builder.deviceName(this.parseDeviceDeviceName("deviceName", deviceNameArray.getJsonObject(i), i));
            }
        }
        builder.modelNumber(this.parseString("modelNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "modelNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_modelNumber"), -1));
        builder.partNumber(this.parseString("partNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "partNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_partNumber"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray specializationArray = JsonSupport.getJsonArray(jsonObject, "specialization");
        if (specializationArray != null) {
            for (int i = 0; i < specializationArray.size(); ++i) {
                builder.specialization(this.parseDeviceSpecialization("specialization", specializationArray.getJsonObject(i), i));
            }
        }
        if ((versionArray = JsonSupport.getJsonArray(jsonObject, "version")) != null) {
            for (int i = 0; i < versionArray.size(); ++i) {
                builder.version(this.parseDeviceVersion("version", versionArray.getJsonObject(i), i));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i = 0; i < propertyArray.size(); ++i) {
                builder.property(this.parseDeviceProperty("property", propertyArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((safetyArray = JsonSupport.getJsonArray(jsonObject, "safety")) != null) {
            for (int i = 0; i < safetyArray.size(); ++i) {
                builder.safety(this.parseCodeableConcept("safety", safetyArray.getJsonObject(i), i));
            }
        }
        builder.parent(this.parseReference("parent", JsonSupport.getJsonValue(jsonObject, "parent", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.DeviceName parseDeviceDeviceName(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.DeviceName.class, jsonObject);
        }
        Device.DeviceName.Builder builder = Device.DeviceName.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.Property parseDeviceProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valueCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.Property.class, jsonObject);
        }
        Device.Property.Builder builder = Device.Property.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray valueQuantityArray = JsonSupport.getJsonArray(jsonObject, "valueQuantity");
        if (valueQuantityArray != null) {
            for (int i = 0; i < valueQuantityArray.size(); ++i) {
                builder.valueQuantity(this.parseQuantity("valueQuantity", valueQuantityArray.getJsonObject(i), i));
            }
        }
        if ((valueCodeArray = JsonSupport.getJsonArray(jsonObject, "valueCode")) != null) {
            for (int i = 0; i < valueCodeArray.size(); ++i) {
                builder.valueCode(this.parseCodeableConcept("valueCode", valueCodeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Device.Specialization parseDeviceSpecialization(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.Specialization.class, jsonObject);
        }
        Device.Specialization.Builder builder = Device.Specialization.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.systemType(this.parseCodeableConcept("systemType", JsonSupport.getJsonValue(jsonObject, "systemType", JsonObject.class), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.UdiCarrier parseDeviceUdiCarrier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.UdiCarrier.class, jsonObject);
        }
        Device.UdiCarrier.Builder builder = Device.UdiCarrier.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.deviceIdentifier(this.parseString("deviceIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "deviceIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_deviceIdentifier"), -1));
        builder.issuer(this.parseUri("issuer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issuer", JsonString.class), (JsonValue)jsonObject.get((Object)"_issuer"), -1));
        builder.jurisdiction(this.parseUri("jurisdiction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonString.class), (JsonValue)jsonObject.get((Object)"_jurisdiction"), -1));
        builder.carrierAIDC(this.parseBase64Binary("carrierAIDC", (JsonValue)JsonSupport.getJsonValue(jsonObject, "carrierAIDC", JsonString.class), (JsonValue)jsonObject.get((Object)"_carrierAIDC"), -1));
        builder.carrierHRF(this.parseString("carrierHRF", (JsonValue)JsonSupport.getJsonValue(jsonObject, "carrierHRF", JsonString.class), (JsonValue)jsonObject.get((Object)"_carrierHRF"), -1));
        builder.entryType((UDIEntryType)this.parseString(UDIEntryType.builder(), "entryType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "entryType", JsonString.class), (JsonValue)jsonObject.get((Object)"_entryType"), -1));
        this.stackPop();
        return builder.build();
    }

    private Device.Version parseDeviceVersion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Device.Version.class, jsonObject);
        }
        Device.Version.Builder builder = Device.Version.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.component(this.parseIdentifier("component", JsonSupport.getJsonValue(jsonObject, "component", JsonObject.class), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition parseDeviceDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray propertyArray;
        JsonArray capabilityArray;
        JsonArray shelfLifeStorageArray;
        JsonArray safetyArray;
        int i;
        JsonArray versionArray;
        JsonArray udiDeviceIdentifierArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.class, jsonObject);
        }
        DeviceDefinition.Builder builder = DeviceDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((udiDeviceIdentifierArray = JsonSupport.getJsonArray(jsonObject, "udiDeviceIdentifier")) != null) {
            for (int i3 = 0; i3 < udiDeviceIdentifierArray.size(); ++i3) {
                builder.udiDeviceIdentifier(this.parseDeviceDefinitionUdiDeviceIdentifier("udiDeviceIdentifier", udiDeviceIdentifierArray.getJsonObject(i3), i3));
            }
        }
        builder.manufacturer(this.parseChoiceElement("manufacturer", jsonObject, com.ibm.fhir.model.type.String.class, Reference.class));
        JsonArray deviceNameArray = JsonSupport.getJsonArray(jsonObject, "deviceName");
        if (deviceNameArray != null) {
            for (int i4 = 0; i4 < deviceNameArray.size(); ++i4) {
                builder.deviceName(this.parseDeviceDefinitionDeviceName("deviceName", deviceNameArray.getJsonObject(i4), i4));
            }
        }
        builder.modelNumber(this.parseString("modelNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "modelNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_modelNumber"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray specializationArray = JsonSupport.getJsonArray(jsonObject, "specialization");
        if (specializationArray != null) {
            for (int i5 = 0; i5 < specializationArray.size(); ++i5) {
                builder.specialization(this.parseDeviceDefinitionSpecialization("specialization", specializationArray.getJsonObject(i5), i5));
            }
        }
        if ((versionArray = JsonSupport.getJsonArray(jsonObject, "version", true)) != null) {
            JsonArray _versionArray = jsonObject.getJsonArray("_version");
            for (i = 0; i < versionArray.size(); ++i) {
                builder.version(this.parseString("version", (JsonValue)versionArray.get(i), JsonSupport.getJsonValue(_versionArray, i), i));
            }
        }
        if ((safetyArray = JsonSupport.getJsonArray(jsonObject, "safety")) != null) {
            for (i = 0; i < safetyArray.size(); ++i) {
                builder.safety(this.parseCodeableConcept("safety", safetyArray.getJsonObject(i), i));
            }
        }
        if ((shelfLifeStorageArray = JsonSupport.getJsonArray(jsonObject, "shelfLifeStorage")) != null) {
            for (int i6 = 0; i6 < shelfLifeStorageArray.size(); ++i6) {
                builder.shelfLifeStorage(this.parseProductShelfLife("shelfLifeStorage", shelfLifeStorageArray.getJsonObject(i6), i6));
            }
        }
        builder.physicalCharacteristics(this.parseProdCharacteristic("physicalCharacteristics", JsonSupport.getJsonValue(jsonObject, "physicalCharacteristics", JsonObject.class), -1));
        JsonArray languageCodeArray = JsonSupport.getJsonArray(jsonObject, "languageCode");
        if (languageCodeArray != null) {
            for (int i7 = 0; i7 < languageCodeArray.size(); ++i7) {
                builder.languageCode(this.parseCodeableConcept("languageCode", languageCodeArray.getJsonObject(i7), i7));
            }
        }
        if ((capabilityArray = JsonSupport.getJsonArray(jsonObject, "capability")) != null) {
            for (int i8 = 0; i8 < capabilityArray.size(); ++i8) {
                builder.capability(this.parseDeviceDefinitionCapability("capability", capabilityArray.getJsonObject(i8), i8));
            }
        }
        if ((propertyArray = JsonSupport.getJsonArray(jsonObject, "property")) != null) {
            for (int i9 = 0; i9 < propertyArray.size(); ++i9) {
                builder.property(this.parseDeviceDefinitionProperty("property", propertyArray.getJsonObject(i9), i9));
            }
        }
        builder.owner(this.parseReference("owner", JsonSupport.getJsonValue(jsonObject, "owner", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i10 = 0; i10 < contactArray.size(); ++i10) {
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i10), i10));
            }
        }
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.onlineInformation(this.parseUri("onlineInformation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "onlineInformation", JsonString.class), (JsonValue)jsonObject.get((Object)"_onlineInformation"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i11 = 0; i11 < noteArray.size(); ++i11) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i11), i11));
            }
        }
        builder.quantity(this.parseQuantity("quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.parentDevice(this.parseReference("parentDevice", JsonSupport.getJsonValue(jsonObject, "parentDevice", JsonObject.class), -1));
        JsonArray materialArray = JsonSupport.getJsonArray(jsonObject, "material");
        if (materialArray != null) {
            for (int i12 = 0; i12 < materialArray.size(); ++i12) {
                builder.material(this.parseDeviceDefinitionMaterial("material", materialArray.getJsonObject(i12), i12));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Capability parseDeviceDefinitionCapability(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Capability.class, jsonObject);
        }
        DeviceDefinition.Capability.Builder builder = DeviceDefinition.Capability.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray descriptionArray = JsonSupport.getJsonArray(jsonObject, "description");
        if (descriptionArray != null) {
            for (int i = 0; i < descriptionArray.size(); ++i) {
                builder.description(this.parseCodeableConcept("description", descriptionArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.DeviceName parseDeviceDefinitionDeviceName(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.DeviceName.class, jsonObject);
        }
        DeviceDefinition.DeviceName.Builder builder = DeviceDefinition.DeviceName.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.type((DeviceNameType)this.parseString(DeviceNameType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Material parseDeviceDefinitionMaterial(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Material.class, jsonObject);
        }
        DeviceDefinition.Material.Builder builder = DeviceDefinition.Material.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.substance(this.parseCodeableConcept("substance", JsonSupport.getJsonValue(jsonObject, "substance", JsonObject.class), -1));
        builder.alternate(this.parseBoolean("alternate", JsonSupport.getJsonValue(jsonObject, "alternate", JsonValue.class), (JsonValue)jsonObject.get((Object)"_alternate"), -1));
        builder.allergenicIndicator(this.parseBoolean("allergenicIndicator", JsonSupport.getJsonValue(jsonObject, "allergenicIndicator", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allergenicIndicator"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Property parseDeviceDefinitionProperty(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray valueCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Property.class, jsonObject);
        }
        DeviceDefinition.Property.Builder builder = DeviceDefinition.Property.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray valueQuantityArray = JsonSupport.getJsonArray(jsonObject, "valueQuantity");
        if (valueQuantityArray != null) {
            for (int i = 0; i < valueQuantityArray.size(); ++i) {
                builder.valueQuantity(this.parseQuantity("valueQuantity", valueQuantityArray.getJsonObject(i), i));
            }
        }
        if ((valueCodeArray = JsonSupport.getJsonArray(jsonObject, "valueCode")) != null) {
            for (int i = 0; i < valueCodeArray.size(); ++i) {
                builder.valueCode(this.parseCodeableConcept("valueCode", valueCodeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.Specialization parseDeviceDefinitionSpecialization(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.Specialization.class, jsonObject);
        }
        DeviceDefinition.Specialization.Builder builder = DeviceDefinition.Specialization.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.systemType(this.parseString("systemType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "systemType", JsonString.class), (JsonValue)jsonObject.get((Object)"_systemType"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceDefinition.UdiDeviceIdentifier parseDeviceDefinitionUdiDeviceIdentifier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceDefinition.UdiDeviceIdentifier.class, jsonObject);
        }
        DeviceDefinition.UdiDeviceIdentifier.Builder builder = DeviceDefinition.UdiDeviceIdentifier.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.deviceIdentifier(this.parseString("deviceIdentifier", (JsonValue)JsonSupport.getJsonValue(jsonObject, "deviceIdentifier", JsonString.class), (JsonValue)jsonObject.get((Object)"_deviceIdentifier"), -1));
        builder.issuer(this.parseUri("issuer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issuer", JsonString.class), (JsonValue)jsonObject.get((Object)"_issuer"), -1));
        builder.jurisdiction(this.parseUri("jurisdiction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonString.class), (JsonValue)jsonObject.get((Object)"_jurisdiction"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceMetric parseDeviceMetric(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceMetric.class, jsonObject);
        }
        DeviceMetric.Builder builder = DeviceMetric.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.parent(this.parseReference("parent", JsonSupport.getJsonValue(jsonObject, "parent", JsonObject.class), -1));
        builder.operationalStatus((DeviceMetricOperationalStatus)this.parseString(DeviceMetricOperationalStatus.builder(), "operationalStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "operationalStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_operationalStatus"), -1));
        builder.color((DeviceMetricColor)this.parseString(DeviceMetricColor.builder(), "color", (JsonValue)JsonSupport.getJsonValue(jsonObject, "color", JsonString.class), (JsonValue)jsonObject.get((Object)"_color"), -1));
        builder.category((DeviceMetricCategory)this.parseString(DeviceMetricCategory.builder(), "category", (JsonValue)JsonSupport.getJsonValue(jsonObject, "category", JsonString.class), (JsonValue)jsonObject.get((Object)"_category"), -1));
        builder.measurementPeriod(this.parseTiming("measurementPeriod", JsonSupport.getJsonValue(jsonObject, "measurementPeriod", JsonObject.class), -1));
        JsonArray calibrationArray = JsonSupport.getJsonArray(jsonObject, "calibration");
        if (calibrationArray != null) {
            for (int i = 0; i < calibrationArray.size(); ++i) {
                builder.calibration(this.parseDeviceMetricCalibration("calibration", calibrationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceMetric.Calibration parseDeviceMetricCalibration(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceMetric.Calibration.class, jsonObject);
        }
        DeviceMetric.Calibration.Builder builder = DeviceMetric.Calibration.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((DeviceMetricCalibrationType)this.parseString(DeviceMetricCalibrationType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.state((DeviceMetricCalibrationState)this.parseString(DeviceMetricCalibrationState.builder(), "state", (JsonValue)JsonSupport.getJsonValue(jsonObject, "state", JsonString.class), (JsonValue)jsonObject.get((Object)"_state"), -1));
        builder.time(this.parseInstant("time", (JsonValue)JsonSupport.getJsonValue(jsonObject, "time", JsonString.class), (JsonValue)jsonObject.get((Object)"_time"), -1));
        this.stackPop();
        return builder.build();
    }

    private DeviceRequest parseDeviceRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relevantHistoryArray;
        JsonArray noteArray;
        JsonArray supportingInfoArray;
        JsonArray insuranceArray;
        JsonArray reasonReferenceArray;
        JsonArray priorRequestArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceRequest.class, jsonObject);
        }
        DeviceRequest.Builder builder = DeviceRequest.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((priorRequestArray = JsonSupport.getJsonArray(jsonObject, "priorRequest")) != null) {
            for (int i4 = 0; i4 < priorRequestArray.size(); ++i4) {
                builder.priorRequest(this.parseReference("priorRequest", priorRequestArray.getJsonObject(i4), i4));
            }
        }
        builder.groupIdentifier(this.parseIdentifier("groupIdentifier", JsonSupport.getJsonValue(jsonObject, "groupIdentifier", JsonObject.class), -1));
        builder.status((DeviceRequestStatus)this.parseString(DeviceRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.intent((RequestIntent)this.parseString(RequestIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        builder.priority((RequestPriority)this.parseString(RequestPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.code(this.parseChoiceElement("code", jsonObject, Reference.class, CodeableConcept.class));
        JsonArray parameterArray = JsonSupport.getJsonArray(jsonObject, "parameter");
        if (parameterArray != null) {
            for (int i5 = 0; i5 < parameterArray.size(); ++i5) {
                builder.parameter(this.parseDeviceRequestParameter("parameter", parameterArray.getJsonObject(i5), i5));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, Period.class, Timing.class));
        builder.authoredOn(this.parseDateTime("authoredOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authoredOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_authoredOn"), -1));
        builder.requester(this.parseReference("requester", JsonSupport.getJsonValue(jsonObject, "requester", JsonObject.class), -1));
        builder.performerType(this.parseCodeableConcept("performerType", JsonSupport.getJsonValue(jsonObject, "performerType", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i6 = 0; i6 < reasonCodeArray.size(); ++i6) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i6), i6));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i7 = 0; i7 < reasonReferenceArray.size(); ++i7) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i7), i7));
            }
        }
        if ((insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance")) != null) {
            for (int i8 = 0; i8 < insuranceArray.size(); ++i8) {
                builder.insurance(this.parseReference("insurance", insuranceArray.getJsonObject(i8), i8));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i9 = 0; i9 < supportingInfoArray.size(); ++i9) {
                builder.supportingInfo(this.parseReference("supportingInfo", supportingInfoArray.getJsonObject(i9), i9));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i10 = 0; i10 < noteArray.size(); ++i10) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i10), i10));
            }
        }
        if ((relevantHistoryArray = JsonSupport.getJsonArray(jsonObject, "relevantHistory")) != null) {
            for (int i11 = 0; i11 < relevantHistoryArray.size(); ++i11) {
                builder.relevantHistory(this.parseReference("relevantHistory", relevantHistoryArray.getJsonObject(i11), i11));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DeviceRequest.Parameter parseDeviceRequestParameter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceRequest.Parameter.class, jsonObject);
        }
        DeviceRequest.Parameter.Builder builder = DeviceRequest.Parameter.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Quantity.class, Range.class, Boolean.class));
        this.stackPop();
        return builder.build();
    }

    private DeviceUseStatement parseDeviceUseStatement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray reasonReferenceArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DeviceUseStatement.class, jsonObject);
        }
        DeviceUseStatement.Builder builder = DeviceUseStatement.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.status((DeviceUseStatementStatus)this.parseString(DeviceUseStatementStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray derivedFromArray = JsonSupport.getJsonArray(jsonObject, "derivedFrom");
        if (derivedFromArray != null) {
            for (int i = 0; i < derivedFromArray.size(); ++i) {
                builder.derivedFrom(this.parseReference("derivedFrom", derivedFromArray.getJsonObject(i), i));
            }
        }
        builder.timing(this.parseChoiceElement("timing", jsonObject, Timing.class, Period.class, DateTime.class));
        builder.recordedOn(this.parseDateTime("recordedOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recordedOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_recordedOn"), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.device(this.parseReference("device", JsonSupport.getJsonValue(jsonObject, "device", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DiagnosticReport parseDiagnosticReport(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray presentedFormArray;
        JsonArray mediaArray;
        JsonArray imagingStudyArray;
        JsonArray resultArray;
        JsonArray specimenArray;
        JsonArray resultsInterpreterArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DiagnosticReport.class, jsonObject);
        }
        DiagnosticReport.Builder builder = DiagnosticReport.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.status((DiagnosticReportStatus)this.parseString(DiagnosticReportStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        builder.issued(this.parseInstant("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                builder.performer(this.parseReference("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((resultsInterpreterArray = JsonSupport.getJsonArray(jsonObject, "resultsInterpreter")) != null) {
            for (int i = 0; i < resultsInterpreterArray.size(); ++i) {
                builder.resultsInterpreter(this.parseReference("resultsInterpreter", resultsInterpreterArray.getJsonObject(i), i));
            }
        }
        if ((specimenArray = JsonSupport.getJsonArray(jsonObject, "specimen")) != null) {
            for (int i = 0; i < specimenArray.size(); ++i) {
                builder.specimen(this.parseReference("specimen", specimenArray.getJsonObject(i), i));
            }
        }
        if ((resultArray = JsonSupport.getJsonArray(jsonObject, "result")) != null) {
            for (int i = 0; i < resultArray.size(); ++i) {
                builder.result(this.parseReference("result", resultArray.getJsonObject(i), i));
            }
        }
        if ((imagingStudyArray = JsonSupport.getJsonArray(jsonObject, "imagingStudy")) != null) {
            for (int i = 0; i < imagingStudyArray.size(); ++i) {
                builder.imagingStudy(this.parseReference("imagingStudy", imagingStudyArray.getJsonObject(i), i));
            }
        }
        if ((mediaArray = JsonSupport.getJsonArray(jsonObject, "media")) != null) {
            for (int i = 0; i < mediaArray.size(); ++i) {
                builder.media(this.parseDiagnosticReportMedia("media", mediaArray.getJsonObject(i), i));
            }
        }
        builder.conclusion(this.parseString("conclusion", (JsonValue)JsonSupport.getJsonValue(jsonObject, "conclusion", JsonString.class), (JsonValue)jsonObject.get((Object)"_conclusion"), -1));
        JsonArray conclusionCodeArray = JsonSupport.getJsonArray(jsonObject, "conclusionCode");
        if (conclusionCodeArray != null) {
            for (int i = 0; i < conclusionCodeArray.size(); ++i) {
                builder.conclusionCode(this.parseCodeableConcept("conclusionCode", conclusionCodeArray.getJsonObject(i), i));
            }
        }
        if ((presentedFormArray = JsonSupport.getJsonArray(jsonObject, "presentedForm")) != null) {
            for (int i = 0; i < presentedFormArray.size(); ++i) {
                builder.presentedForm(this.parseAttachment("presentedForm", presentedFormArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DiagnosticReport.Media parseDiagnosticReportMedia(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DiagnosticReport.Media.class, jsonObject);
        }
        DiagnosticReport.Media.Builder builder = DiagnosticReport.Media.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.link(this.parseReference("link", JsonSupport.getJsonValue(jsonObject, "link", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentManifest parseDocumentManifest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedArray;
        JsonArray recipientArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentManifest.class, jsonObject);
        }
        DocumentManifest.Builder builder = DocumentManifest.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.masterIdentifier(this.parseIdentifier("masterIdentifier", JsonSupport.getJsonValue(jsonObject, "masterIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DocumentReferenceStatus)this.parseString(DocumentReferenceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((recipientArray = JsonSupport.getJsonArray(jsonObject, "recipient")) != null) {
            for (int i = 0; i < recipientArray.size(); ++i) {
                builder.recipient(this.parseReference("recipient", recipientArray.getJsonObject(i), i));
            }
        }
        builder.source(this.parseUri("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray contentArray = JsonSupport.getJsonArray(jsonObject, "content");
        if (contentArray != null) {
            for (int i = 0; i < contentArray.size(); ++i) {
                builder.content(this.parseReference("content", contentArray.getJsonObject(i), i));
            }
        }
        if ((relatedArray = JsonSupport.getJsonArray(jsonObject, "related")) != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                builder.related(this.parseDocumentManifestRelated("related", relatedArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DocumentManifest.Related parseDocumentManifestRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentManifest.Related.class, jsonObject);
        }
        DocumentManifest.Related.Builder builder = DocumentManifest.Related.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.ref(this.parseReference("ref", JsonSupport.getJsonValue(jsonObject, "ref", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference parseDocumentReference(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray contentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.class, jsonObject);
        }
        DocumentReference.Builder builder = DocumentReference.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.masterIdentifier(this.parseIdentifier("masterIdentifier", JsonSupport.getJsonValue(jsonObject, "masterIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((DocumentReferenceStatus)this.parseString(DocumentReferenceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.docStatus((ReferredDocumentStatus)this.parseString(ReferredDocumentStatus.builder(), "docStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "docStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_docStatus"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.date(this.parseInstant("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray authorArray = JsonSupport.getJsonArray(jsonObject, "author");
        if (authorArray != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseReference("author", authorArray.getJsonObject(i), i));
            }
        }
        builder.authenticator(this.parseReference("authenticator", JsonSupport.getJsonValue(jsonObject, "authenticator", JsonObject.class), -1));
        builder.custodian(this.parseReference("custodian", JsonSupport.getJsonValue(jsonObject, "custodian", JsonObject.class), -1));
        JsonArray relatesToArray = JsonSupport.getJsonArray(jsonObject, "relatesTo");
        if (relatesToArray != null) {
            for (int i = 0; i < relatesToArray.size(); ++i) {
                builder.relatesTo(this.parseDocumentReferenceRelatesTo("relatesTo", relatesToArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray securityLabelArray = JsonSupport.getJsonArray(jsonObject, "securityLabel");
        if (securityLabelArray != null) {
            for (int i = 0; i < securityLabelArray.size(); ++i) {
                builder.securityLabel(this.parseCodeableConcept("securityLabel", securityLabelArray.getJsonObject(i), i));
            }
        }
        if ((contentArray = JsonSupport.getJsonArray(jsonObject, "content")) != null) {
            for (int i = 0; i < contentArray.size(); ++i) {
                builder.content(this.parseDocumentReferenceContent("content", contentArray.getJsonObject(i), i));
            }
        }
        builder.context(this.parseDocumentReferenceContext("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.Content parseDocumentReferenceContent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.Content.class, jsonObject);
        }
        DocumentReference.Content.Builder builder = DocumentReference.Content.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.attachment(this.parseAttachment("attachment", JsonSupport.getJsonValue(jsonObject, "attachment", JsonObject.class), -1));
        builder.format(this.parseCoding("format", JsonSupport.getJsonValue(jsonObject, "format", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.Context parseDocumentReferenceContext(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray eventArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.Context.class, jsonObject);
        }
        DocumentReference.Context.Builder builder = DocumentReference.Context.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter");
        if (encounterArray != null) {
            for (int i = 0; i < encounterArray.size(); ++i) {
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i), i));
            }
        }
        if ((eventArray = JsonSupport.getJsonArray(jsonObject, "event")) != null) {
            for (int i = 0; i < eventArray.size(); ++i) {
                builder.event(this.parseCodeableConcept("event", eventArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.facilityType(this.parseCodeableConcept("facilityType", JsonSupport.getJsonValue(jsonObject, "facilityType", JsonObject.class), -1));
        builder.practiceSetting(this.parseCodeableConcept("practiceSetting", JsonSupport.getJsonValue(jsonObject, "practiceSetting", JsonObject.class), -1));
        builder.sourcePatientInfo(this.parseReference("sourcePatientInfo", JsonSupport.getJsonValue(jsonObject, "sourcePatientInfo", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i = 0; i < relatedArray.size(); ++i) {
                builder.related(this.parseReference("related", relatedArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private DocumentReference.RelatesTo parseDocumentReferenceRelatesTo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(DocumentReference.RelatesTo.class, jsonObject);
        }
        DocumentReference.RelatesTo.Builder builder = DocumentReference.RelatesTo.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((DocumentRelationshipType)this.parseString(DocumentRelationshipType.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.target(this.parseReference("target", JsonSupport.getJsonValue(jsonObject, "target", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private void parseDomainResource(DomainResource.Builder builder, JsonObject jsonObject) {
        JsonArray modifierExtensionArray;
        JsonArray extensionArray;
        this.parseResource(builder, jsonObject);
        builder.text(this.parseNarrative("text", JsonSupport.getJsonValue(jsonObject, "text", JsonObject.class), -1));
        JsonArray containedArray = JsonSupport.getJsonArray(jsonObject, "contained");
        if (containedArray != null) {
            for (int i = 0; i < containedArray.size(); ++i) {
                builder.contained(this.parseResource("contained", containedArray.getJsonObject(i), i));
            }
        }
        if ((extensionArray = JsonSupport.getJsonArray(jsonObject, "extension")) != null) {
            for (int i = 0; i < extensionArray.size(); ++i) {
                builder.extension(this.parseExtension("extension", extensionArray.getJsonObject(i), i));
            }
        }
        if ((modifierExtensionArray = JsonSupport.getJsonArray(jsonObject, "modifierExtension")) != null) {
            for (int i = 0; i < modifierExtensionArray.size(); ++i) {
                builder.modifierExtension(this.parseExtension("modifierExtension", modifierExtensionArray.getJsonObject(i), i));
            }
        }
    }

    private Dosage parseDosage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Dosage.class, jsonObject);
        }
        Dosage.Builder builder = Dosage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence(this.parseInteger("sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        JsonArray additionalInstructionArray = JsonSupport.getJsonArray(jsonObject, "additionalInstruction");
        if (additionalInstructionArray != null) {
            for (int i = 0; i < additionalInstructionArray.size(); ++i) {
                builder.additionalInstruction(this.parseCodeableConcept("additionalInstruction", additionalInstructionArray.getJsonObject(i), i));
            }
        }
        builder.patientInstruction(this.parseString("patientInstruction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "patientInstruction", JsonString.class), (JsonValue)jsonObject.get((Object)"_patientInstruction"), -1));
        builder.timing(this.parseTiming("timing", JsonSupport.getJsonValue(jsonObject, "timing", JsonObject.class), -1));
        builder.asNeeded(this.parseChoiceElement("asNeeded", jsonObject, Boolean.class, CodeableConcept.class));
        builder.site(this.parseCodeableConcept("site", JsonSupport.getJsonValue(jsonObject, "site", JsonObject.class), -1));
        builder.route(this.parseCodeableConcept("route", JsonSupport.getJsonValue(jsonObject, "route", JsonObject.class), -1));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        JsonArray doseAndRateArray = JsonSupport.getJsonArray(jsonObject, "doseAndRate");
        if (doseAndRateArray != null) {
            for (int i = 0; i < doseAndRateArray.size(); ++i) {
                builder.doseAndRate(this.parseDosageDoseAndRate("doseAndRate", doseAndRateArray.getJsonObject(i), i));
            }
        }
        builder.maxDosePerPeriod(this.parseRatio("maxDosePerPeriod", JsonSupport.getJsonValue(jsonObject, "maxDosePerPeriod", JsonObject.class), -1));
        builder.maxDosePerAdministration((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "maxDosePerAdministration", JsonSupport.getJsonValue(jsonObject, "maxDosePerAdministration", JsonObject.class), -1));
        builder.maxDosePerLifetime((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "maxDosePerLifetime", JsonSupport.getJsonValue(jsonObject, "maxDosePerLifetime", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Dosage.DoseAndRate parseDosageDoseAndRate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Dosage.DoseAndRate.class, jsonObject);
        }
        Dosage.DoseAndRate.Builder builder = Dosage.DoseAndRate.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.dose(this.parseChoiceElement("dose", jsonObject, Range.class, SimpleQuantity.class));
        builder.rate(this.parseChoiceElement("rate", jsonObject, Ratio.class, Range.class, SimpleQuantity.class));
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis parseEffectEvidenceSynthesis(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray certaintyArray;
        JsonArray effectEstimateArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.class, jsonObject);
        }
        EffectEvidenceSynthesis.Builder builder = EffectEvidenceSynthesis.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.synthesisType(this.parseCodeableConcept("synthesisType", JsonSupport.getJsonValue(jsonObject, "synthesisType", JsonObject.class), -1));
        builder.studyType(this.parseCodeableConcept("studyType", JsonSupport.getJsonValue(jsonObject, "studyType", JsonObject.class), -1));
        builder.population(this.parseReference("population", JsonSupport.getJsonValue(jsonObject, "population", JsonObject.class), -1));
        builder.exposure(this.parseReference("exposure", JsonSupport.getJsonValue(jsonObject, "exposure", JsonObject.class), -1));
        builder.exposureAlternative(this.parseReference("exposureAlternative", JsonSupport.getJsonValue(jsonObject, "exposureAlternative", JsonObject.class), -1));
        builder.outcome(this.parseReference("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        builder.sampleSize(this.parseEffectEvidenceSynthesisSampleSize("sampleSize", JsonSupport.getJsonValue(jsonObject, "sampleSize", JsonObject.class), -1));
        JsonArray resultsByExposureArray = JsonSupport.getJsonArray(jsonObject, "resultsByExposure");
        if (resultsByExposureArray != null) {
            for (int i = 0; i < resultsByExposureArray.size(); ++i) {
                builder.resultsByExposure(this.parseEffectEvidenceSynthesisResultsByExposure("resultsByExposure", resultsByExposureArray.getJsonObject(i), i));
            }
        }
        if ((effectEstimateArray = JsonSupport.getJsonArray(jsonObject, "effectEstimate")) != null) {
            for (int i = 0; i < effectEstimateArray.size(); ++i) {
                builder.effectEstimate(this.parseEffectEvidenceSynthesisEffectEstimate("effectEstimate", effectEstimateArray.getJsonObject(i), i));
            }
        }
        if ((certaintyArray = JsonSupport.getJsonArray(jsonObject, "certainty")) != null) {
            for (int i = 0; i < certaintyArray.size(); ++i) {
                builder.certainty(this.parseEffectEvidenceSynthesisCertainty("certainty", certaintyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.Certainty parseEffectEvidenceSynthesisCertainty(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray certaintySubcomponentArray;
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.Certainty.class, jsonObject);
        }
        EffectEvidenceSynthesis.Certainty.Builder builder = EffectEvidenceSynthesis.Certainty.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray ratingArray = JsonSupport.getJsonArray(jsonObject, "rating");
        if (ratingArray != null) {
            for (int i = 0; i < ratingArray.size(); ++i) {
                builder.rating(this.parseCodeableConcept("rating", ratingArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((certaintySubcomponentArray = JsonSupport.getJsonArray(jsonObject, "certaintySubcomponent")) != null) {
            for (int i = 0; i < certaintySubcomponentArray.size(); ++i) {
                builder.certaintySubcomponent(this.parseEffectEvidenceSynthesisCertaintyCertaintySubcomponent("certaintySubcomponent", certaintySubcomponentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.Certainty.CertaintySubcomponent parseEffectEvidenceSynthesisCertaintyCertaintySubcomponent(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.Certainty.CertaintySubcomponent.class, jsonObject);
        }
        EffectEvidenceSynthesis.Certainty.CertaintySubcomponent.Builder builder = EffectEvidenceSynthesis.Certainty.CertaintySubcomponent.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray ratingArray = JsonSupport.getJsonArray(jsonObject, "rating");
        if (ratingArray != null) {
            for (int i = 0; i < ratingArray.size(); ++i) {
                builder.rating(this.parseCodeableConcept("rating", ratingArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.EffectEstimate parseEffectEvidenceSynthesisEffectEstimate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.EffectEstimate.class, jsonObject);
        }
        EffectEvidenceSynthesis.EffectEstimate.Builder builder = EffectEvidenceSynthesis.EffectEstimate.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.variantState(this.parseCodeableConcept("variantState", JsonSupport.getJsonValue(jsonObject, "variantState", JsonObject.class), -1));
        builder.value(this.parseDecimal("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.unitOfMeasure(this.parseCodeableConcept("unitOfMeasure", JsonSupport.getJsonValue(jsonObject, "unitOfMeasure", JsonObject.class), -1));
        JsonArray precisionEstimateArray = JsonSupport.getJsonArray(jsonObject, "precisionEstimate");
        if (precisionEstimateArray != null) {
            for (int i = 0; i < precisionEstimateArray.size(); ++i) {
                builder.precisionEstimate(this.parseEffectEvidenceSynthesisEffectEstimatePrecisionEstimate("precisionEstimate", precisionEstimateArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.EffectEstimate.PrecisionEstimate parseEffectEvidenceSynthesisEffectEstimatePrecisionEstimate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.EffectEstimate.PrecisionEstimate.class, jsonObject);
        }
        EffectEvidenceSynthesis.EffectEstimate.PrecisionEstimate.Builder builder = EffectEvidenceSynthesis.EffectEstimate.PrecisionEstimate.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.level(this.parseDecimal("level", (JsonValue)JsonSupport.getJsonValue(jsonObject, "level", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_level"), -1));
        builder.from(this.parseDecimal("from", (JsonValue)JsonSupport.getJsonValue(jsonObject, "from", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_from"), -1));
        builder.to(this.parseDecimal("to", (JsonValue)JsonSupport.getJsonValue(jsonObject, "to", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_to"), -1));
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.ResultsByExposure parseEffectEvidenceSynthesisResultsByExposure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.ResultsByExposure.class, jsonObject);
        }
        EffectEvidenceSynthesis.ResultsByExposure.Builder builder = EffectEvidenceSynthesis.ResultsByExposure.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.exposureState((ExposureState)this.parseString(ExposureState.builder(), "exposureState", (JsonValue)JsonSupport.getJsonValue(jsonObject, "exposureState", JsonString.class), (JsonValue)jsonObject.get((Object)"_exposureState"), -1));
        builder.variantState(this.parseCodeableConcept("variantState", JsonSupport.getJsonValue(jsonObject, "variantState", JsonObject.class), -1));
        builder.riskEvidenceSynthesis(this.parseReference("riskEvidenceSynthesis", JsonSupport.getJsonValue(jsonObject, "riskEvidenceSynthesis", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EffectEvidenceSynthesis.SampleSize parseEffectEvidenceSynthesisSampleSize(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EffectEvidenceSynthesis.SampleSize.class, jsonObject);
        }
        EffectEvidenceSynthesis.SampleSize.Builder builder = EffectEvidenceSynthesis.SampleSize.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.numberOfStudies(this.parseInteger("numberOfStudies", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfStudies", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfStudies"), -1));
        builder.numberOfParticipants(this.parseInteger("numberOfParticipants", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfParticipants", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfParticipants"), -1));
        this.stackPop();
        return builder.build();
    }

    private void parseElement(Element.Builder builder, JsonObject jsonObject) {
        builder.id(this.parseJavaString("id", JsonSupport.getJsonValue(jsonObject, "id", JsonString.class), -1));
        JsonArray extensionArray = JsonSupport.getJsonArray(jsonObject, "extension");
        if (extensionArray != null) {
            for (int i = 0; i < extensionArray.size(); ++i) {
                builder.extension(this.parseExtension("extension", extensionArray.getJsonObject(i), i));
            }
        }
    }

    private ElementDefinition parseElementDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray constraintArray;
        int i;
        int i2;
        int i3;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.class, jsonObject);
        }
        ElementDefinition.Builder builder = ElementDefinition.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        JsonArray representationArray = JsonSupport.getJsonArray(jsonObject, "representation", true);
        if (representationArray != null) {
            JsonArray _representationArray = jsonObject.getJsonArray("_representation");
            for (i3 = 0; i3 < representationArray.size(); ++i3) {
                builder.representation((PropertyRepresentation)this.parseString(PropertyRepresentation.builder(), "representation", (JsonValue)representationArray.get(i3), JsonSupport.getJsonValue(_representationArray, i3), i3));
            }
        }
        builder.sliceName(this.parseString("sliceName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sliceName", JsonString.class), (JsonValue)jsonObject.get((Object)"_sliceName"), -1));
        builder.sliceIsConstraining(this.parseBoolean("sliceIsConstraining", JsonSupport.getJsonValue(jsonObject, "sliceIsConstraining", JsonValue.class), (JsonValue)jsonObject.get((Object)"_sliceIsConstraining"), -1));
        builder.label(this.parseString("label", (JsonValue)JsonSupport.getJsonValue(jsonObject, "label", JsonString.class), (JsonValue)jsonObject.get((Object)"_label"), -1));
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (i3 = 0; i3 < codeArray.size(); ++i3) {
                builder.code(this.parseCoding("code", codeArray.getJsonObject(i3), i3));
            }
        }
        builder.slicing(this.parseElementDefinitionSlicing("slicing", JsonSupport.getJsonValue(jsonObject, "slicing", JsonObject.class), -1));
        builder._short(this.parseString("short", (JsonValue)JsonSupport.getJsonValue(jsonObject, "short", JsonString.class), (JsonValue)jsonObject.get((Object)"_short"), -1));
        builder.definition((Markdown)this.parseString(Markdown.builder(), "definition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "definition", JsonString.class), (JsonValue)jsonObject.get((Object)"_definition"), -1));
        builder.comment((Markdown)this.parseString(Markdown.builder(), "comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.requirements((Markdown)this.parseString(Markdown.builder(), "requirements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "requirements", JsonString.class), (JsonValue)jsonObject.get((Object)"_requirements"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i2 = 0; i2 < aliasArray.size(); ++i2) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i2), JsonSupport.getJsonValue(_aliasArray, i2), i2));
            }
        }
        builder.min((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        builder.base(this.parseElementDefinitionBase("base", JsonSupport.getJsonValue(jsonObject, "base", JsonObject.class), -1));
        builder.contentReference(this.parseUri("contentReference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "contentReference", JsonString.class), (JsonValue)jsonObject.get((Object)"_contentReference"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (i2 = 0; i2 < typeArray.size(); ++i2) {
                builder.type(this.parseElementDefinitionType("type", typeArray.getJsonObject(i2), i2));
            }
        }
        builder.defaultValue(this.parseChoiceElement("defaultValue", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, com.ibm.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
        builder.meaningWhenMissing((Markdown)this.parseString(Markdown.builder(), "meaningWhenMissing", (JsonValue)JsonSupport.getJsonValue(jsonObject, "meaningWhenMissing", JsonString.class), (JsonValue)jsonObject.get((Object)"_meaningWhenMissing"), -1));
        builder.orderMeaning(this.parseString("orderMeaning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "orderMeaning", JsonString.class), (JsonValue)jsonObject.get((Object)"_orderMeaning"), -1));
        builder.fixed(this.parseChoiceElement("fixed", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, com.ibm.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
        builder.pattern(this.parseChoiceElement("pattern", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, com.ibm.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
        JsonArray exampleArray = JsonSupport.getJsonArray(jsonObject, "example");
        if (exampleArray != null) {
            for (int i4 = 0; i4 < exampleArray.size(); ++i4) {
                builder.example(this.parseElementDefinitionExample("example", exampleArray.getJsonObject(i4), i4));
            }
        }
        builder.minValue(this.parseChoiceElement("minValue", jsonObject, Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class));
        builder.maxValue(this.parseChoiceElement("maxValue", jsonObject, Date.class, DateTime.class, Instant.class, Time.class, Decimal.class, Integer.class, PositiveInt.class, UnsignedInt.class, Quantity.class));
        builder.maxLength(this.parseInteger("maxLength", (JsonValue)JsonSupport.getJsonValue(jsonObject, "maxLength", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_maxLength"), -1));
        JsonArray conditionArray = JsonSupport.getJsonArray(jsonObject, "condition", true);
        if (conditionArray != null) {
            JsonArray _conditionArray = jsonObject.getJsonArray("_condition");
            for (i = 0; i < conditionArray.size(); ++i) {
                builder.condition((Id)this.parseString(Id.builder(), "condition", (JsonValue)conditionArray.get(i), JsonSupport.getJsonValue(_conditionArray, i), i));
            }
        }
        if ((constraintArray = JsonSupport.getJsonArray(jsonObject, "constraint")) != null) {
            for (i = 0; i < constraintArray.size(); ++i) {
                builder.constraint(this.parseElementDefinitionConstraint("constraint", constraintArray.getJsonObject(i), i));
            }
        }
        builder.mustSupport(this.parseBoolean("mustSupport", JsonSupport.getJsonValue(jsonObject, "mustSupport", JsonValue.class), (JsonValue)jsonObject.get((Object)"_mustSupport"), -1));
        builder.isModifier(this.parseBoolean("isModifier", JsonSupport.getJsonValue(jsonObject, "isModifier", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isModifier"), -1));
        builder.isModifierReason(this.parseString("isModifierReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "isModifierReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_isModifierReason"), -1));
        builder.isSummary(this.parseBoolean("isSummary", JsonSupport.getJsonValue(jsonObject, "isSummary", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isSummary"), -1));
        builder.binding(this.parseElementDefinitionBinding("binding", JsonSupport.getJsonValue(jsonObject, "binding", JsonObject.class), -1));
        JsonArray mappingArray = JsonSupport.getJsonArray(jsonObject, "mapping");
        if (mappingArray != null) {
            for (int i5 = 0; i5 < mappingArray.size(); ++i5) {
                builder.mapping(this.parseElementDefinitionMapping("mapping", mappingArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Base parseElementDefinitionBase(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Base.class, jsonObject);
        }
        ElementDefinition.Base.Builder builder = ElementDefinition.Base.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.min((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Binding parseElementDefinitionBinding(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Binding.class, jsonObject);
        }
        ElementDefinition.Binding.Builder builder = ElementDefinition.Binding.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.strength((BindingStrength)this.parseString(BindingStrength.builder(), "strength", (JsonValue)JsonSupport.getJsonValue(jsonObject, "strength", JsonString.class), (JsonValue)jsonObject.get((Object)"_strength"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.valueSet((Canonical)this.parseUri(Canonical.builder(), "valueSet", (JsonValue)JsonSupport.getJsonValue(jsonObject, "valueSet", JsonString.class), (JsonValue)jsonObject.get((Object)"_valueSet"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Constraint parseElementDefinitionConstraint(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Constraint.class, jsonObject);
        }
        ElementDefinition.Constraint.Builder builder = ElementDefinition.Constraint.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.key((Id)this.parseString(Id.builder(), "key", (JsonValue)JsonSupport.getJsonValue(jsonObject, "key", JsonString.class), (JsonValue)jsonObject.get((Object)"_key"), -1));
        builder.requirements(this.parseString("requirements", (JsonValue)JsonSupport.getJsonValue(jsonObject, "requirements", JsonString.class), (JsonValue)jsonObject.get((Object)"_requirements"), -1));
        builder.severity((ConstraintSeverity)this.parseString(ConstraintSeverity.builder(), "severity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "severity", JsonString.class), (JsonValue)jsonObject.get((Object)"_severity"), -1));
        builder.human(this.parseString("human", (JsonValue)JsonSupport.getJsonValue(jsonObject, "human", JsonString.class), (JsonValue)jsonObject.get((Object)"_human"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.xpath(this.parseString("xpath", (JsonValue)JsonSupport.getJsonValue(jsonObject, "xpath", JsonString.class), (JsonValue)jsonObject.get((Object)"_xpath"), -1));
        builder.source((Canonical)this.parseUri(Canonical.builder(), "source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Example parseElementDefinitionExample(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Example.class, jsonObject);
        }
        ElementDefinition.Example.Builder builder = ElementDefinition.Example.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.label(this.parseString("label", (JsonValue)JsonSupport.getJsonValue(jsonObject, "label", JsonString.class), (JsonValue)jsonObject.get((Object)"_label"), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, com.ibm.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Mapping parseElementDefinitionMapping(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Mapping.class, jsonObject);
        }
        ElementDefinition.Mapping.Builder builder = ElementDefinition.Mapping.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.identity((Id)this.parseString(Id.builder(), "identity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "identity", JsonString.class), (JsonValue)jsonObject.get((Object)"_identity"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.map(this.parseString("map", (JsonValue)JsonSupport.getJsonValue(jsonObject, "map", JsonString.class), (JsonValue)jsonObject.get((Object)"_map"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Slicing parseElementDefinitionSlicing(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Slicing.class, jsonObject);
        }
        ElementDefinition.Slicing.Builder builder = ElementDefinition.Slicing.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray discriminatorArray = JsonSupport.getJsonArray(jsonObject, "discriminator");
        if (discriminatorArray != null) {
            for (int i = 0; i < discriminatorArray.size(); ++i) {
                builder.discriminator(this.parseElementDefinitionSlicingDiscriminator("discriminator", discriminatorArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.ordered(this.parseBoolean("ordered", JsonSupport.getJsonValue(jsonObject, "ordered", JsonValue.class), (JsonValue)jsonObject.get((Object)"_ordered"), -1));
        builder.rules((SlicingRules)this.parseString(SlicingRules.builder(), "rules", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rules", JsonString.class), (JsonValue)jsonObject.get((Object)"_rules"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Slicing.Discriminator parseElementDefinitionSlicingDiscriminator(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Slicing.Discriminator.class, jsonObject);
        }
        ElementDefinition.Slicing.Discriminator.Builder builder = ElementDefinition.Slicing.Discriminator.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((DiscriminatorType)this.parseString(DiscriminatorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        this.stackPop();
        return builder.build();
    }

    private ElementDefinition.Type parseElementDefinitionType(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray aggregationArray;
        JsonArray targetProfileArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ElementDefinition.Type.class, jsonObject);
        }
        ElementDefinition.Type.Builder builder = ElementDefinition.Type.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseUri("code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        JsonArray profileArray = JsonSupport.getJsonArray(jsonObject, "profile", true);
        if (profileArray != null) {
            JsonArray _profileArray = jsonObject.getJsonArray("_profile");
            for (int i = 0; i < profileArray.size(); ++i) {
                builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)profileArray.get(i), JsonSupport.getJsonValue(_profileArray, i), i));
            }
        }
        if ((targetProfileArray = JsonSupport.getJsonArray(jsonObject, "targetProfile", true)) != null) {
            JsonArray _targetProfileArray = jsonObject.getJsonArray("_targetProfile");
            for (int i = 0; i < targetProfileArray.size(); ++i) {
                builder.targetProfile((Canonical)this.parseUri(Canonical.builder(), "targetProfile", (JsonValue)targetProfileArray.get(i), JsonSupport.getJsonValue(_targetProfileArray, i), i));
            }
        }
        if ((aggregationArray = JsonSupport.getJsonArray(jsonObject, "aggregation", true)) != null) {
            JsonArray _aggregationArray = jsonObject.getJsonArray("_aggregation");
            for (int i = 0; i < aggregationArray.size(); ++i) {
                builder.aggregation((AggregationMode)this.parseString(AggregationMode.builder(), "aggregation", (JsonValue)aggregationArray.get(i), JsonSupport.getJsonValue(_aggregationArray, i), i));
            }
        }
        builder.versioning((ReferenceVersionRules)this.parseString(ReferenceVersionRules.builder(), "versioning", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versioning", JsonString.class), (JsonValue)jsonObject.get((Object)"_versioning"), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter parseEncounter(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray accountArray;
        JsonArray diagnosisArray;
        JsonArray reasonReferenceArray;
        JsonArray appointmentArray;
        JsonArray participantArray;
        JsonArray basedOnArray;
        JsonArray typeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.class, jsonObject);
        }
        Encounter.Builder builder = Encounter.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EncounterStatus)this.parseString(EncounterStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusHistoryArray = JsonSupport.getJsonArray(jsonObject, "statusHistory");
        if (statusHistoryArray != null) {
            for (int i = 0; i < statusHistoryArray.size(); ++i) {
                builder.statusHistory(this.parseEncounterStatusHistory("statusHistory", statusHistoryArray.getJsonObject(i), i));
            }
        }
        builder.clazz(this.parseCoding("class", JsonSupport.getJsonValue(jsonObject, "class", JsonObject.class), -1));
        JsonArray classHistoryArray = JsonSupport.getJsonArray(jsonObject, "classHistory");
        if (classHistoryArray != null) {
            for (int i = 0; i < classHistoryArray.size(); ++i) {
                builder.classHistory(this.parseEncounterClassHistory("classHistory", classHistoryArray.getJsonObject(i), i));
            }
        }
        if ((typeArray = JsonSupport.getJsonArray(jsonObject, "type")) != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.serviceType(this.parseCodeableConcept("serviceType", JsonSupport.getJsonValue(jsonObject, "serviceType", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray episodeOfCareArray = JsonSupport.getJsonArray(jsonObject, "episodeOfCare");
        if (episodeOfCareArray != null) {
            for (int i = 0; i < episodeOfCareArray.size(); ++i) {
                builder.episodeOfCare(this.parseReference("episodeOfCare", episodeOfCareArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((participantArray = JsonSupport.getJsonArray(jsonObject, "participant")) != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                builder.participant(this.parseEncounterParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        if ((appointmentArray = JsonSupport.getJsonArray(jsonObject, "appointment")) != null) {
            for (int i = 0; i < appointmentArray.size(); ++i) {
                builder.appointment(this.parseReference("appointment", appointmentArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.length((Duration)this.parseQuantity(Duration.builder(), "length", JsonSupport.getJsonValue(jsonObject, "length", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                builder.diagnosis(this.parseEncounterDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        if ((accountArray = JsonSupport.getJsonArray(jsonObject, "account")) != null) {
            for (int i = 0; i < accountArray.size(); ++i) {
                builder.account(this.parseReference("account", accountArray.getJsonObject(i), i));
            }
        }
        builder.hospitalization(this.parseEncounterHospitalization("hospitalization", JsonSupport.getJsonValue(jsonObject, "hospitalization", JsonObject.class), -1));
        JsonArray locationArray = JsonSupport.getJsonArray(jsonObject, "location");
        if (locationArray != null) {
            for (int i = 0; i < locationArray.size(); ++i) {
                builder.location(this.parseEncounterLocation("location", locationArray.getJsonObject(i), i));
            }
        }
        builder.serviceProvider(this.parseReference("serviceProvider", JsonSupport.getJsonValue(jsonObject, "serviceProvider", JsonObject.class), -1));
        builder.partOf(this.parseReference("partOf", JsonSupport.getJsonValue(jsonObject, "partOf", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.ClassHistory parseEncounterClassHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.ClassHistory.class, jsonObject);
        }
        Encounter.ClassHistory.Builder builder = Encounter.ClassHistory.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.clazz(this.parseCoding("class", JsonSupport.getJsonValue(jsonObject, "class", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Diagnosis parseEncounterDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Diagnosis.class, jsonObject);
        }
        Encounter.Diagnosis.Builder builder = Encounter.Diagnosis.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.condition(this.parseReference("condition", JsonSupport.getJsonValue(jsonObject, "condition", JsonObject.class), -1));
        builder.use(this.parseCodeableConcept("use", JsonSupport.getJsonValue(jsonObject, "use", JsonObject.class), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Hospitalization parseEncounterHospitalization(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray specialArrangementArray;
        JsonArray specialCourtesyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Hospitalization.class, jsonObject);
        }
        Encounter.Hospitalization.Builder builder = Encounter.Hospitalization.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.preAdmissionIdentifier(this.parseIdentifier("preAdmissionIdentifier", JsonSupport.getJsonValue(jsonObject, "preAdmissionIdentifier", JsonObject.class), -1));
        builder.origin(this.parseReference("origin", JsonSupport.getJsonValue(jsonObject, "origin", JsonObject.class), -1));
        builder.admitSource(this.parseCodeableConcept("admitSource", JsonSupport.getJsonValue(jsonObject, "admitSource", JsonObject.class), -1));
        builder.reAdmission(this.parseCodeableConcept("reAdmission", JsonSupport.getJsonValue(jsonObject, "reAdmission", JsonObject.class), -1));
        JsonArray dietPreferenceArray = JsonSupport.getJsonArray(jsonObject, "dietPreference");
        if (dietPreferenceArray != null) {
            for (int i = 0; i < dietPreferenceArray.size(); ++i) {
                builder.dietPreference(this.parseCodeableConcept("dietPreference", dietPreferenceArray.getJsonObject(i), i));
            }
        }
        if ((specialCourtesyArray = JsonSupport.getJsonArray(jsonObject, "specialCourtesy")) != null) {
            for (int i = 0; i < specialCourtesyArray.size(); ++i) {
                builder.specialCourtesy(this.parseCodeableConcept("specialCourtesy", specialCourtesyArray.getJsonObject(i), i));
            }
        }
        if ((specialArrangementArray = JsonSupport.getJsonArray(jsonObject, "specialArrangement")) != null) {
            for (int i = 0; i < specialArrangementArray.size(); ++i) {
                builder.specialArrangement(this.parseCodeableConcept("specialArrangement", specialArrangementArray.getJsonObject(i), i));
            }
        }
        builder.destination(this.parseReference("destination", JsonSupport.getJsonValue(jsonObject, "destination", JsonObject.class), -1));
        builder.dischargeDisposition(this.parseCodeableConcept("dischargeDisposition", JsonSupport.getJsonValue(jsonObject, "dischargeDisposition", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Location parseEncounterLocation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Location.class, jsonObject);
        }
        Encounter.Location.Builder builder = Encounter.Location.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.status((EncounterLocationStatus)this.parseString(EncounterLocationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.physicalType(this.parseCodeableConcept("physicalType", JsonSupport.getJsonValue(jsonObject, "physicalType", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.Participant parseEncounterParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.Participant.class, jsonObject);
        }
        Encounter.Participant.Builder builder = Encounter.Participant.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.individual(this.parseReference("individual", JsonSupport.getJsonValue(jsonObject, "individual", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Encounter.StatusHistory parseEncounterStatusHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Encounter.StatusHistory.class, jsonObject);
        }
        Encounter.StatusHistory.Builder builder = Encounter.StatusHistory.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.status((EncounterStatus)this.parseString(EncounterStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Endpoint parseEndpoint(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray payloadMimeTypeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Endpoint.class, jsonObject);
        }
        Endpoint.Builder builder = Endpoint.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EndpointStatus)this.parseString(EndpointStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.connectionType(this.parseCoding("connectionType", JsonSupport.getJsonValue(jsonObject, "connectionType", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.managingOrganization(this.parseReference("managingOrganization", JsonSupport.getJsonValue(jsonObject, "managingOrganization", JsonObject.class), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactPoint("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray payloadTypeArray = JsonSupport.getJsonArray(jsonObject, "payloadType");
        if (payloadTypeArray != null) {
            for (int i = 0; i < payloadTypeArray.size(); ++i) {
                builder.payloadType(this.parseCodeableConcept("payloadType", payloadTypeArray.getJsonObject(i), i));
            }
        }
        if ((payloadMimeTypeArray = JsonSupport.getJsonArray(jsonObject, "payloadMimeType", true)) != null) {
            JsonArray _payloadMimeTypeArray = jsonObject.getJsonArray("_payloadMimeType");
            for (int i = 0; i < payloadMimeTypeArray.size(); ++i) {
                builder.payloadMimeType((Code)this.parseString(Code.builder(), "payloadMimeType", (JsonValue)payloadMimeTypeArray.get(i), JsonSupport.getJsonValue(_payloadMimeTypeArray, i), i));
            }
        }
        builder.address((Url)this.parseUri(Url.builder(), "address", (JsonValue)JsonSupport.getJsonValue(jsonObject, "address", JsonString.class), (JsonValue)jsonObject.get((Object)"_address"), -1));
        JsonArray headerArray = JsonSupport.getJsonArray(jsonObject, "header", true);
        if (headerArray != null) {
            JsonArray _headerArray = jsonObject.getJsonArray("_header");
            for (int i = 0; i < headerArray.size(); ++i) {
                builder.header(this.parseString("header", (JsonValue)headerArray.get(i), JsonSupport.getJsonValue(_headerArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EnrollmentRequest parseEnrollmentRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EnrollmentRequest.class, jsonObject);
        }
        EnrollmentRequest.Builder builder = EnrollmentRequest.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EnrollmentRequestStatus)this.parseString(EnrollmentRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.candidate(this.parseReference("candidate", JsonSupport.getJsonValue(jsonObject, "candidate", JsonObject.class), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EnrollmentResponse parseEnrollmentResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EnrollmentResponse.class, jsonObject);
        }
        EnrollmentResponse.Builder builder = EnrollmentResponse.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EnrollmentResponseStatus)this.parseString(EnrollmentResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.organization(this.parseReference("organization", JsonSupport.getJsonValue(jsonObject, "organization", JsonObject.class), -1));
        builder.requestProvider(this.parseReference("requestProvider", JsonSupport.getJsonValue(jsonObject, "requestProvider", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare parseEpisodeOfCare(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray accountArray;
        JsonArray diagnosisArray;
        JsonArray typeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.class, jsonObject);
        }
        EpisodeOfCare.Builder builder = EpisodeOfCare.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((EpisodeOfCareStatus)this.parseString(EpisodeOfCareStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusHistoryArray = JsonSupport.getJsonArray(jsonObject, "statusHistory");
        if (statusHistoryArray != null) {
            for (int i = 0; i < statusHistoryArray.size(); ++i) {
                builder.statusHistory(this.parseEpisodeOfCareStatusHistory("statusHistory", statusHistoryArray.getJsonObject(i), i));
            }
        }
        if ((typeArray = JsonSupport.getJsonArray(jsonObject, "type")) != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i = 0; i < diagnosisArray.size(); ++i) {
                builder.diagnosis(this.parseEpisodeOfCareDiagnosis("diagnosis", diagnosisArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.managingOrganization(this.parseReference("managingOrganization", JsonSupport.getJsonValue(jsonObject, "managingOrganization", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        JsonArray referralRequestArray = JsonSupport.getJsonArray(jsonObject, "referralRequest");
        if (referralRequestArray != null) {
            for (int i = 0; i < referralRequestArray.size(); ++i) {
                builder.referralRequest(this.parseReference("referralRequest", referralRequestArray.getJsonObject(i), i));
            }
        }
        builder.careManager(this.parseReference("careManager", JsonSupport.getJsonValue(jsonObject, "careManager", JsonObject.class), -1));
        JsonArray teamArray = JsonSupport.getJsonArray(jsonObject, "team");
        if (teamArray != null) {
            for (int i = 0; i < teamArray.size(); ++i) {
                builder.team(this.parseReference("team", teamArray.getJsonObject(i), i));
            }
        }
        if ((accountArray = JsonSupport.getJsonArray(jsonObject, "account")) != null) {
            for (int i = 0; i < accountArray.size(); ++i) {
                builder.account(this.parseReference("account", accountArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare.Diagnosis parseEpisodeOfCareDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.Diagnosis.class, jsonObject);
        }
        EpisodeOfCare.Diagnosis.Builder builder = EpisodeOfCare.Diagnosis.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.condition(this.parseReference("condition", JsonSupport.getJsonValue(jsonObject, "condition", JsonObject.class), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.rank((PositiveInt)this.parseInteger(PositiveInt.builder(), "rank", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rank", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_rank"), -1));
        this.stackPop();
        return builder.build();
    }

    private EpisodeOfCare.StatusHistory parseEpisodeOfCareStatusHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EpisodeOfCare.StatusHistory.class, jsonObject);
        }
        EpisodeOfCare.StatusHistory.Builder builder = EpisodeOfCare.StatusHistory.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.status((EpisodeOfCareStatus)this.parseString(EpisodeOfCareStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private EventDefinition parseEventDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray triggerArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EventDefinition.class, jsonObject);
        }
        EventDefinition.Builder builder = EventDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        if ((triggerArray = JsonSupport.getJsonArray(jsonObject, "trigger")) != null) {
            for (int i = 0; i < triggerArray.size(); ++i) {
                builder.trigger(this.parseTriggerDefinition("trigger", triggerArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Evidence parseEvidence(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray outcomeArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Evidence.class, jsonObject);
        }
        Evidence.Builder builder = Evidence.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.shortTitle(this.parseString("shortTitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "shortTitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_shortTitle"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.exposureBackground(this.parseReference("exposureBackground", JsonSupport.getJsonValue(jsonObject, "exposureBackground", JsonObject.class), -1));
        JsonArray exposureVariantArray = JsonSupport.getJsonArray(jsonObject, "exposureVariant");
        if (exposureVariantArray != null) {
            for (int i = 0; i < exposureVariantArray.size(); ++i) {
                builder.exposureVariant(this.parseReference("exposureVariant", exposureVariantArray.getJsonObject(i), i));
            }
        }
        if ((outcomeArray = JsonSupport.getJsonArray(jsonObject, "outcome")) != null) {
            for (int i = 0; i < outcomeArray.size(); ++i) {
                builder.outcome(this.parseReference("outcome", outcomeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable parseEvidenceVariable(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.class, jsonObject);
        }
        EvidenceVariable.Builder builder = EvidenceVariable.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.shortTitle(this.parseString("shortTitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "shortTitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_shortTitle"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        builder.type((EvidenceVariableType)this.parseString(EvidenceVariableType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        JsonArray characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic");
        if (characteristicArray != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                builder.characteristic(this.parseEvidenceVariableCharacteristic("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private EvidenceVariable.Characteristic parseEvidenceVariableCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(EvidenceVariable.Characteristic.class, jsonObject);
        }
        EvidenceVariable.Characteristic.Builder builder = EvidenceVariable.Characteristic.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.definition(this.parseChoiceElement("definition", jsonObject, Reference.class, Canonical.class, CodeableConcept.class, Expression.class, DataRequirement.class, TriggerDefinition.class));
        JsonArray usageContextArray = JsonSupport.getJsonArray(jsonObject, "usageContext");
        if (usageContextArray != null) {
            for (int i = 0; i < usageContextArray.size(); ++i) {
                builder.usageContext(this.parseUsageContext("usageContext", usageContextArray.getJsonObject(i), i));
            }
        }
        builder.exclude(this.parseBoolean("exclude", JsonSupport.getJsonValue(jsonObject, "exclude", JsonValue.class), (JsonValue)jsonObject.get((Object)"_exclude"), -1));
        builder.participantEffective(this.parseChoiceElement("participantEffective", jsonObject, DateTime.class, Period.class, Duration.class, Timing.class));
        builder.timeFromStart((Duration)this.parseQuantity(Duration.builder(), "timeFromStart", JsonSupport.getJsonValue(jsonObject, "timeFromStart", JsonObject.class), -1));
        builder.groupMeasure((GroupMeasure)this.parseString(GroupMeasure.builder(), "groupMeasure", (JsonValue)JsonSupport.getJsonValue(jsonObject, "groupMeasure", JsonString.class), (JsonValue)jsonObject.get((Object)"_groupMeasure"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario parseExampleScenario(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray workflowArray;
        JsonArray processArray;
        JsonArray instanceArray;
        JsonArray jurisdictionArray;
        JsonArray useContextArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.class, jsonObject);
        }
        ExampleScenario.Builder builder = ExampleScenario.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        if ((useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext")) != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        JsonArray actorArray = JsonSupport.getJsonArray(jsonObject, "actor");
        if (actorArray != null) {
            for (int i = 0; i < actorArray.size(); ++i) {
                builder.actor(this.parseExampleScenarioActor("actor", actorArray.getJsonObject(i), i));
            }
        }
        if ((instanceArray = JsonSupport.getJsonArray(jsonObject, "instance")) != null) {
            for (int i = 0; i < instanceArray.size(); ++i) {
                builder.instance(this.parseExampleScenarioInstance("instance", instanceArray.getJsonObject(i), i));
            }
        }
        if ((processArray = JsonSupport.getJsonArray(jsonObject, "process")) != null) {
            for (int i = 0; i < processArray.size(); ++i) {
                builder.process(this.parseExampleScenarioProcess("process", processArray.getJsonObject(i), i));
            }
        }
        if ((workflowArray = JsonSupport.getJsonArray(jsonObject, "workflow", true)) != null) {
            JsonArray _workflowArray = jsonObject.getJsonArray("_workflow");
            for (int i = 0; i < workflowArray.size(); ++i) {
                builder.workflow((Canonical)this.parseUri(Canonical.builder(), "workflow", (JsonValue)workflowArray.get(i), JsonSupport.getJsonValue(_workflowArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Actor parseExampleScenarioActor(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Actor.class, jsonObject);
        }
        ExampleScenario.Actor.Builder builder = ExampleScenario.Actor.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.actorId(this.parseString("actorId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "actorId", JsonString.class), (JsonValue)jsonObject.get((Object)"_actorId"), -1));
        builder.type((ExampleScenarioActorType)this.parseString(ExampleScenarioActorType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance parseExampleScenarioInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray containedInstanceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.class, jsonObject);
        }
        ExampleScenario.Instance.Builder builder = ExampleScenario.Instance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.resourceId(this.parseString("resourceId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceId", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceId"), -1));
        builder.resourceType((FHIRResourceType)this.parseString(FHIRResourceType.builder(), "resourceType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceType", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceType"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray versionArray = JsonSupport.getJsonArray(jsonObject, "version");
        if (versionArray != null) {
            for (int i = 0; i < versionArray.size(); ++i) {
                builder.version(this.parseExampleScenarioInstanceVersion("version", versionArray.getJsonObject(i), i));
            }
        }
        if ((containedInstanceArray = JsonSupport.getJsonArray(jsonObject, "containedInstance")) != null) {
            for (int i = 0; i < containedInstanceArray.size(); ++i) {
                builder.containedInstance(this.parseExampleScenarioInstanceContainedInstance("containedInstance", containedInstanceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance.ContainedInstance parseExampleScenarioInstanceContainedInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.ContainedInstance.class, jsonObject);
        }
        ExampleScenario.Instance.ContainedInstance.Builder builder = ExampleScenario.Instance.ContainedInstance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.resourceId(this.parseString("resourceId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "resourceId", JsonString.class), (JsonValue)jsonObject.get((Object)"_resourceId"), -1));
        builder.versionId(this.parseString("versionId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versionId", JsonString.class), (JsonValue)jsonObject.get((Object)"_versionId"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Instance.Version parseExampleScenarioInstanceVersion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Instance.Version.class, jsonObject);
        }
        ExampleScenario.Instance.Version.Builder builder = ExampleScenario.Instance.Version.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.versionId(this.parseString("versionId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "versionId", JsonString.class), (JsonValue)jsonObject.get((Object)"_versionId"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process parseExampleScenarioProcess(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.class, jsonObject);
        }
        ExampleScenario.Process.Builder builder = ExampleScenario.Process.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.preConditions((Markdown)this.parseString(Markdown.builder(), "preConditions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preConditions", JsonString.class), (JsonValue)jsonObject.get((Object)"_preConditions"), -1));
        builder.postConditions((Markdown)this.parseString(Markdown.builder(), "postConditions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "postConditions", JsonString.class), (JsonValue)jsonObject.get((Object)"_postConditions"), -1));
        JsonArray stepArray = JsonSupport.getJsonArray(jsonObject, "step");
        if (stepArray != null) {
            for (int i = 0; i < stepArray.size(); ++i) {
                builder.step(this.parseExampleScenarioProcessStep("step", stepArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step parseExampleScenarioProcessStep(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.class, jsonObject);
        }
        ExampleScenario.Process.Step.Builder builder = ExampleScenario.Process.Step.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray processArray = JsonSupport.getJsonArray(jsonObject, "process");
        if (processArray != null) {
            for (int i = 0; i < processArray.size(); ++i) {
                builder.process(this.parseExampleScenarioProcess("process", processArray.getJsonObject(i), i));
            }
        }
        builder.pause(this.parseBoolean("pause", JsonSupport.getJsonValue(jsonObject, "pause", JsonValue.class), (JsonValue)jsonObject.get((Object)"_pause"), -1));
        builder.operation(this.parseExampleScenarioProcessStepOperation("operation", JsonSupport.getJsonValue(jsonObject, "operation", JsonObject.class), -1));
        JsonArray alternativeArray = JsonSupport.getJsonArray(jsonObject, "alternative");
        if (alternativeArray != null) {
            for (int i = 0; i < alternativeArray.size(); ++i) {
                builder.alternative(this.parseExampleScenarioProcessStepAlternative("alternative", alternativeArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step.Alternative parseExampleScenarioProcessStepAlternative(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.Alternative.class, jsonObject);
        }
        ExampleScenario.Process.Step.Alternative.Builder builder = ExampleScenario.Process.Step.Alternative.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray stepArray = JsonSupport.getJsonArray(jsonObject, "step");
        if (stepArray != null) {
            for (int i = 0; i < stepArray.size(); ++i) {
                builder.step(this.parseExampleScenarioProcessStep("step", stepArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExampleScenario.Process.Step.Operation parseExampleScenarioProcessStepOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExampleScenario.Process.Step.Operation.class, jsonObject);
        }
        ExampleScenario.Process.Step.Operation.Builder builder = ExampleScenario.Process.Step.Operation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.number(this.parseString("number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonString.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type(this.parseString("type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.initiator(this.parseString("initiator", (JsonValue)JsonSupport.getJsonValue(jsonObject, "initiator", JsonString.class), (JsonValue)jsonObject.get((Object)"_initiator"), -1));
        builder.receiver(this.parseString("receiver", (JsonValue)JsonSupport.getJsonValue(jsonObject, "receiver", JsonString.class), (JsonValue)jsonObject.get((Object)"_receiver"), -1));
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.initiatorActive(this.parseBoolean("initiatorActive", JsonSupport.getJsonValue(jsonObject, "initiatorActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_initiatorActive"), -1));
        builder.receiverActive(this.parseBoolean("receiverActive", JsonSupport.getJsonValue(jsonObject, "receiverActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_receiverActive"), -1));
        builder.request(this.parseExampleScenarioInstanceContainedInstance("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        builder.response(this.parseExampleScenarioInstanceContainedInstance("response", JsonSupport.getJsonValue(jsonObject, "response", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit parseExplanationOfBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray totalArray;
        JsonArray adjudicationArray;
        JsonArray addItemArray;
        JsonArray procedureArray;
        JsonArray diagnosisArray;
        JsonArray supportingInfoArray;
        JsonArray careTeamArray;
        JsonArray preAuthRefPeriodArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.class, jsonObject);
        }
        ExplanationOfBenefit.Builder builder = ExplanationOfBenefit.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((ExplanationOfBenefitStatus)this.parseString(ExplanationOfBenefitStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subType(this.parseCodeableConcept("subType", JsonSupport.getJsonValue(jsonObject, "subType", JsonObject.class), -1));
        builder.use((Use)this.parseString(Use.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.billablePeriod(this.parsePeriod("billablePeriod", JsonSupport.getJsonValue(jsonObject, "billablePeriod", JsonObject.class), -1));
        builder.created(this.parseDateTime("created", (JsonValue)JsonSupport.getJsonValue(jsonObject, "created", JsonString.class), (JsonValue)jsonObject.get((Object)"_created"), -1));
        builder.enterer(this.parseReference("enterer", JsonSupport.getJsonValue(jsonObject, "enterer", JsonObject.class), -1));
        builder.insurer(this.parseReference("insurer", JsonSupport.getJsonValue(jsonObject, "insurer", JsonObject.class), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.fundsReserveRequested(this.parseCodeableConcept("fundsReserveRequested", JsonSupport.getJsonValue(jsonObject, "fundsReserveRequested", JsonObject.class), -1));
        builder.fundsReserve(this.parseCodeableConcept("fundsReserve", JsonSupport.getJsonValue(jsonObject, "fundsReserve", JsonObject.class), -1));
        JsonArray relatedArray = JsonSupport.getJsonArray(jsonObject, "related");
        if (relatedArray != null) {
            for (int i3 = 0; i3 < relatedArray.size(); ++i3) {
                builder.related(this.parseExplanationOfBenefitRelated("related", relatedArray.getJsonObject(i3), i3));
            }
        }
        builder.prescription(this.parseReference("prescription", JsonSupport.getJsonValue(jsonObject, "prescription", JsonObject.class), -1));
        builder.originalPrescription(this.parseReference("originalPrescription", JsonSupport.getJsonValue(jsonObject, "originalPrescription", JsonObject.class), -1));
        builder.payee(this.parseExplanationOfBenefitPayee("payee", JsonSupport.getJsonValue(jsonObject, "payee", JsonObject.class), -1));
        builder.referral(this.parseReference("referral", JsonSupport.getJsonValue(jsonObject, "referral", JsonObject.class), -1));
        builder.facility(this.parseReference("facility", JsonSupport.getJsonValue(jsonObject, "facility", JsonObject.class), -1));
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.claimResponse(this.parseReference("claimResponse", JsonSupport.getJsonValue(jsonObject, "claimResponse", JsonObject.class), -1));
        builder.outcome((RemittanceOutcome)this.parseString(RemittanceOutcome.builder(), "outcome", (JsonValue)JsonSupport.getJsonValue(jsonObject, "outcome", JsonString.class), (JsonValue)jsonObject.get((Object)"_outcome"), -1));
        builder.disposition(this.parseString("disposition", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disposition", JsonString.class), (JsonValue)jsonObject.get((Object)"_disposition"), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        if ((preAuthRefPeriodArray = JsonSupport.getJsonArray(jsonObject, "preAuthRefPeriod")) != null) {
            for (i = 0; i < preAuthRefPeriodArray.size(); ++i) {
                builder.preAuthRefPeriod(this.parsePeriod("preAuthRefPeriod", preAuthRefPeriodArray.getJsonObject(i), i));
            }
        }
        if ((careTeamArray = JsonSupport.getJsonArray(jsonObject, "careTeam")) != null) {
            for (int i4 = 0; i4 < careTeamArray.size(); ++i4) {
                builder.careTeam(this.parseExplanationOfBenefitCareTeam("careTeam", careTeamArray.getJsonObject(i4), i4));
            }
        }
        if ((supportingInfoArray = JsonSupport.getJsonArray(jsonObject, "supportingInfo")) != null) {
            for (int i5 = 0; i5 < supportingInfoArray.size(); ++i5) {
                builder.supportingInfo(this.parseExplanationOfBenefitSupportingInfo("supportingInfo", supportingInfoArray.getJsonObject(i5), i5));
            }
        }
        if ((diagnosisArray = JsonSupport.getJsonArray(jsonObject, "diagnosis")) != null) {
            for (int i6 = 0; i6 < diagnosisArray.size(); ++i6) {
                builder.diagnosis(this.parseExplanationOfBenefitDiagnosis("diagnosis", diagnosisArray.getJsonObject(i6), i6));
            }
        }
        if ((procedureArray = JsonSupport.getJsonArray(jsonObject, "procedure")) != null) {
            for (int i7 = 0; i7 < procedureArray.size(); ++i7) {
                builder.procedure(this.parseExplanationOfBenefitProcedure("procedure", procedureArray.getJsonObject(i7), i7));
            }
        }
        builder.precedence((PositiveInt)this.parseInteger(PositiveInt.builder(), "precedence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "precedence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_precedence"), -1));
        JsonArray insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance");
        if (insuranceArray != null) {
            for (int i8 = 0; i8 < insuranceArray.size(); ++i8) {
                builder.insurance(this.parseExplanationOfBenefitInsurance("insurance", insuranceArray.getJsonObject(i8), i8));
            }
        }
        builder.accident(this.parseExplanationOfBenefitAccident("accident", JsonSupport.getJsonValue(jsonObject, "accident", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i9 = 0; i9 < itemArray.size(); ++i9) {
                builder.item(this.parseExplanationOfBenefitItem("item", itemArray.getJsonObject(i9), i9));
            }
        }
        if ((addItemArray = JsonSupport.getJsonArray(jsonObject, "addItem")) != null) {
            for (int i10 = 0; i10 < addItemArray.size(); ++i10) {
                builder.addItem(this.parseExplanationOfBenefitAddItem("addItem", addItemArray.getJsonObject(i10), i10));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (int i11 = 0; i11 < adjudicationArray.size(); ++i11) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i11), i11));
            }
        }
        if ((totalArray = JsonSupport.getJsonArray(jsonObject, "total")) != null) {
            for (int i12 = 0; i12 < totalArray.size(); ++i12) {
                builder.total(this.parseExplanationOfBenefitTotal("total", totalArray.getJsonObject(i12), i12));
            }
        }
        builder.payment(this.parseExplanationOfBenefitPayment("payment", JsonSupport.getJsonValue(jsonObject, "payment", JsonObject.class), -1));
        builder.formCode(this.parseCodeableConcept("formCode", JsonSupport.getJsonValue(jsonObject, "formCode", JsonObject.class), -1));
        builder.form(this.parseAttachment("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        JsonArray processNoteArray = JsonSupport.getJsonArray(jsonObject, "processNote");
        if (processNoteArray != null) {
            for (int i13 = 0; i13 < processNoteArray.size(); ++i13) {
                builder.processNote(this.parseExplanationOfBenefitProcessNote("processNote", processNoteArray.getJsonObject(i13), i13));
            }
        }
        builder.benefitPeriod(this.parsePeriod("benefitPeriod", JsonSupport.getJsonValue(jsonObject, "benefitPeriod", JsonObject.class), -1));
        JsonArray benefitBalanceArray = JsonSupport.getJsonArray(jsonObject, "benefitBalance");
        if (benefitBalanceArray != null) {
            for (int i14 = 0; i14 < benefitBalanceArray.size(); ++i14) {
                builder.benefitBalance(this.parseExplanationOfBenefitBenefitBalance("benefitBalance", benefitBalanceArray.getJsonObject(i14), i14));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Accident parseExplanationOfBenefitAccident(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Accident.class, jsonObject);
        }
        ExplanationOfBenefit.Accident.Builder builder = ExplanationOfBenefit.Accident.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.location(this.parseChoiceElement("location", jsonObject, Address.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem parseExplanationOfBenefitAddItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        JsonArray providerArray;
        int i2;
        JsonArray subDetailSequenceArray;
        JsonArray detailSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Builder builder = ExplanationOfBenefit.AddItem.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray itemSequenceArray = JsonSupport.getJsonArray(jsonObject, "itemSequence", true);
        if (itemSequenceArray != null) {
            JsonArray _itemSequenceArray = jsonObject.getJsonArray("_itemSequence");
            for (int i3 = 0; i3 < itemSequenceArray.size(); ++i3) {
                builder.itemSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "itemSequence", (JsonValue)itemSequenceArray.get(i3), JsonSupport.getJsonValue(_itemSequenceArray, i3), i3));
            }
        }
        if ((detailSequenceArray = JsonSupport.getJsonArray(jsonObject, "detailSequence", true)) != null) {
            JsonArray _detailSequenceArray = jsonObject.getJsonArray("_detailSequence");
            for (int i4 = 0; i4 < detailSequenceArray.size(); ++i4) {
                builder.detailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "detailSequence", (JsonValue)detailSequenceArray.get(i4), JsonSupport.getJsonValue(_detailSequenceArray, i4), i4));
            }
        }
        if ((subDetailSequenceArray = JsonSupport.getJsonArray(jsonObject, "subDetailSequence", true)) != null) {
            JsonArray _subDetailSequenceArray = jsonObject.getJsonArray("_subDetailSequence");
            for (i2 = 0; i2 < subDetailSequenceArray.size(); ++i2) {
                builder.subDetailSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "subDetailSequence", (JsonValue)subDetailSequenceArray.get(i2), JsonSupport.getJsonValue(_subDetailSequenceArray, i2), i2));
            }
        }
        if ((providerArray = JsonSupport.getJsonArray(jsonObject, "provider")) != null) {
            for (i2 = 0; i2 < providerArray.size(); ++i2) {
                builder.provider(this.parseReference("provider", providerArray.getJsonObject(i2), i2));
            }
        }
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i5 = 0; i5 < modifierArray.size(); ++i5) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i5), i5));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i7 = 0; i7 < subSiteArray.size(); ++i7) {
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i7), i7));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i8 = 0; i8 < detailArray.size(); ++i8) {
                builder.detail(this.parseExplanationOfBenefitAddItemDetail("detail", detailArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem.Detail parseExplanationOfBenefitAddItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.Detail.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Detail.Builder builder = ExplanationOfBenefit.AddItem.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i3 = 0; i3 < subDetailArray.size(); ++i3) {
                builder.subDetail(this.parseExplanationOfBenefitAddItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i3), i3));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.AddItem.Detail.SubDetail parseExplanationOfBenefitAddItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.AddItem.Detail.SubDetail.class, jsonObject);
        }
        ExplanationOfBenefit.AddItem.Detail.SubDetail.Builder builder = ExplanationOfBenefit.AddItem.Detail.SubDetail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true);
        if (noteNumberArray != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.BenefitBalance parseExplanationOfBenefitBenefitBalance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.BenefitBalance.class, jsonObject);
        }
        ExplanationOfBenefit.BenefitBalance.Builder builder = ExplanationOfBenefit.BenefitBalance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.excluded(this.parseBoolean("excluded", JsonSupport.getJsonValue(jsonObject, "excluded", JsonValue.class), (JsonValue)jsonObject.get((Object)"_excluded"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.network(this.parseCodeableConcept("network", JsonSupport.getJsonValue(jsonObject, "network", JsonObject.class), -1));
        builder.unit(this.parseCodeableConcept("unit", JsonSupport.getJsonValue(jsonObject, "unit", JsonObject.class), -1));
        builder.term(this.parseCodeableConcept("term", JsonSupport.getJsonValue(jsonObject, "term", JsonObject.class), -1));
        JsonArray financialArray = JsonSupport.getJsonArray(jsonObject, "financial");
        if (financialArray != null) {
            for (int i = 0; i < financialArray.size(); ++i) {
                builder.financial(this.parseExplanationOfBenefitBenefitBalanceFinancial("financial", financialArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.BenefitBalance.Financial parseExplanationOfBenefitBenefitBalanceFinancial(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.BenefitBalance.Financial.class, jsonObject);
        }
        ExplanationOfBenefit.BenefitBalance.Financial.Builder builder = ExplanationOfBenefit.BenefitBalance.Financial.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.allowed(this.parseChoiceElement("allowed", jsonObject, UnsignedInt.class, com.ibm.fhir.model.type.String.class, Money.class));
        builder.used(this.parseChoiceElement("used", jsonObject, UnsignedInt.class, Money.class));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.CareTeam parseExplanationOfBenefitCareTeam(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.CareTeam.class, jsonObject);
        }
        ExplanationOfBenefit.CareTeam.Builder builder = ExplanationOfBenefit.CareTeam.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.provider(this.parseReference("provider", JsonSupport.getJsonValue(jsonObject, "provider", JsonObject.class), -1));
        builder.responsible(this.parseBoolean("responsible", JsonSupport.getJsonValue(jsonObject, "responsible", JsonValue.class), (JsonValue)jsonObject.get((Object)"_responsible"), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.qualification(this.parseCodeableConcept("qualification", JsonSupport.getJsonValue(jsonObject, "qualification", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Diagnosis parseExplanationOfBenefitDiagnosis(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Diagnosis.class, jsonObject);
        }
        ExplanationOfBenefit.Diagnosis.Builder builder = ExplanationOfBenefit.Diagnosis.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.diagnosis(this.parseChoiceElement("diagnosis", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.onAdmission(this.parseCodeableConcept("onAdmission", JsonSupport.getJsonValue(jsonObject, "onAdmission", JsonObject.class), -1));
        builder.packageCode(this.parseCodeableConcept("packageCode", JsonSupport.getJsonValue(jsonObject, "packageCode", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Insurance parseExplanationOfBenefitInsurance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Insurance.class, jsonObject);
        }
        ExplanationOfBenefit.Insurance.Builder builder = ExplanationOfBenefit.Insurance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.focal(this.parseBoolean("focal", JsonSupport.getJsonValue(jsonObject, "focal", JsonValue.class), (JsonValue)jsonObject.get((Object)"_focal"), -1));
        builder.coverage(this.parseReference("coverage", JsonSupport.getJsonValue(jsonObject, "coverage", JsonObject.class), -1));
        JsonArray preAuthRefArray = JsonSupport.getJsonArray(jsonObject, "preAuthRef", true);
        if (preAuthRefArray != null) {
            JsonArray _preAuthRefArray = jsonObject.getJsonArray("_preAuthRef");
            for (int i = 0; i < preAuthRefArray.size(); ++i) {
                builder.preAuthRef(this.parseString("preAuthRef", (JsonValue)preAuthRefArray.get(i), JsonSupport.getJsonValue(_preAuthRefArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item parseExplanationOfBenefitItem(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray detailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray encounterArray;
        JsonArray programCodeArray;
        int i2;
        JsonArray informationSequenceArray;
        JsonArray procedureSequenceArray;
        JsonArray diagnosisSequenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Builder builder = ExplanationOfBenefit.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray careTeamSequenceArray = JsonSupport.getJsonArray(jsonObject, "careTeamSequence", true);
        if (careTeamSequenceArray != null) {
            JsonArray _careTeamSequenceArray = jsonObject.getJsonArray("_careTeamSequence");
            for (int i3 = 0; i3 < careTeamSequenceArray.size(); ++i3) {
                builder.careTeamSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "careTeamSequence", (JsonValue)careTeamSequenceArray.get(i3), JsonSupport.getJsonValue(_careTeamSequenceArray, i3), i3));
            }
        }
        if ((diagnosisSequenceArray = JsonSupport.getJsonArray(jsonObject, "diagnosisSequence", true)) != null) {
            JsonArray _diagnosisSequenceArray = jsonObject.getJsonArray("_diagnosisSequence");
            for (int i4 = 0; i4 < diagnosisSequenceArray.size(); ++i4) {
                builder.diagnosisSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "diagnosisSequence", (JsonValue)diagnosisSequenceArray.get(i4), JsonSupport.getJsonValue(_diagnosisSequenceArray, i4), i4));
            }
        }
        if ((procedureSequenceArray = JsonSupport.getJsonArray(jsonObject, "procedureSequence", true)) != null) {
            JsonArray _procedureSequenceArray = jsonObject.getJsonArray("_procedureSequence");
            for (int i5 = 0; i5 < procedureSequenceArray.size(); ++i5) {
                builder.procedureSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "procedureSequence", (JsonValue)procedureSequenceArray.get(i5), JsonSupport.getJsonValue(_procedureSequenceArray, i5), i5));
            }
        }
        if ((informationSequenceArray = JsonSupport.getJsonArray(jsonObject, "informationSequence", true)) != null) {
            JsonArray _informationSequenceArray = jsonObject.getJsonArray("_informationSequence");
            for (i2 = 0; i2 < informationSequenceArray.size(); ++i2) {
                builder.informationSequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "informationSequence", (JsonValue)informationSequenceArray.get(i2), JsonSupport.getJsonValue(_informationSequenceArray, i2), i2));
            }
        }
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i6 = 0; i6 < programCodeArray.size(); ++i6) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i6), i6));
            }
        }
        builder.serviced(this.parseChoiceElement("serviced", jsonObject, Date.class, Period.class));
        builder.location(this.parseChoiceElement("location", jsonObject, CodeableConcept.class, Address.class, Reference.class));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i7 = 0; i7 < udiArray.size(); ++i7) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i7), i7));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        JsonArray subSiteArray = JsonSupport.getJsonArray(jsonObject, "subSite");
        if (subSiteArray != null) {
            for (int i8 = 0; i8 < subSiteArray.size(); ++i8) {
                builder.subSite(this.parseCodeableConcept("subSite", subSiteArray.getJsonObject(i8), i8));
            }
        }
        if ((encounterArray = JsonSupport.getJsonArray(jsonObject, "encounter")) != null) {
            for (int i9 = 0; i9 < encounterArray.size(); ++i9) {
                builder.encounter(this.parseReference("encounter", encounterArray.getJsonObject(i9), i9));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((detailArray = JsonSupport.getJsonArray(jsonObject, "detail")) != null) {
            for (int i10 = 0; i10 < detailArray.size(); ++i10) {
                builder.detail(this.parseExplanationOfBenefitItemDetail("detail", detailArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Adjudication parseExplanationOfBenefitItemAdjudication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Adjudication.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Adjudication.Builder builder = ExplanationOfBenefit.Item.Adjudication.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.value(this.parseDecimal("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Detail parseExplanationOfBenefitItemDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray subDetailArray;
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Detail.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Detail.Builder builder = ExplanationOfBenefit.Item.Detail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i3 = 0; i3 < programCodeArray.size(); ++i3) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i3), i3));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i4 = 0; i4 < udiArray.size(); ++i4) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i4), i4));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        if ((subDetailArray = JsonSupport.getJsonArray(jsonObject, "subDetail")) != null) {
            for (int i5 = 0; i5 < subDetailArray.size(); ++i5) {
                builder.subDetail(this.parseExplanationOfBenefitItemDetailSubDetail("subDetail", subDetailArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Item.Detail.SubDetail parseExplanationOfBenefitItemDetailSubDetail(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray adjudicationArray;
        int i;
        JsonArray noteNumberArray;
        JsonArray programCodeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Item.Detail.SubDetail.class, jsonObject);
        }
        ExplanationOfBenefit.Item.Detail.SubDetail.Builder builder = ExplanationOfBenefit.Item.Detail.SubDetail.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.revenue(this.parseCodeableConcept("revenue", JsonSupport.getJsonValue(jsonObject, "revenue", JsonObject.class), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.productOrService(this.parseCodeableConcept("productOrService", JsonSupport.getJsonValue(jsonObject, "productOrService", JsonObject.class), -1));
        JsonArray modifierArray = JsonSupport.getJsonArray(jsonObject, "modifier");
        if (modifierArray != null) {
            for (int i2 = 0; i2 < modifierArray.size(); ++i2) {
                builder.modifier(this.parseCodeableConcept("modifier", modifierArray.getJsonObject(i2), i2));
            }
        }
        if ((programCodeArray = JsonSupport.getJsonArray(jsonObject, "programCode")) != null) {
            for (int i3 = 0; i3 < programCodeArray.size(); ++i3) {
                builder.programCode(this.parseCodeableConcept("programCode", programCodeArray.getJsonObject(i3), i3));
            }
        }
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.unitPrice(this.parseMoney("unitPrice", JsonSupport.getJsonValue(jsonObject, "unitPrice", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.net(this.parseMoney("net", JsonSupport.getJsonValue(jsonObject, "net", JsonObject.class), -1));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i4 = 0; i4 < udiArray.size(); ++i4) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i4), i4));
            }
        }
        if ((noteNumberArray = JsonSupport.getJsonArray(jsonObject, "noteNumber", true)) != null) {
            JsonArray _noteNumberArray = jsonObject.getJsonArray("_noteNumber");
            for (i = 0; i < noteNumberArray.size(); ++i) {
                builder.noteNumber((PositiveInt)this.parseInteger(PositiveInt.builder(), "noteNumber", (JsonValue)noteNumberArray.get(i), JsonSupport.getJsonValue(_noteNumberArray, i), i));
            }
        }
        if ((adjudicationArray = JsonSupport.getJsonArray(jsonObject, "adjudication")) != null) {
            for (i = 0; i < adjudicationArray.size(); ++i) {
                builder.adjudication(this.parseExplanationOfBenefitItemAdjudication("adjudication", adjudicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Payee parseExplanationOfBenefitPayee(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Payee.class, jsonObject);
        }
        ExplanationOfBenefit.Payee.Builder builder = ExplanationOfBenefit.Payee.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.party(this.parseReference("party", JsonSupport.getJsonValue(jsonObject, "party", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Payment parseExplanationOfBenefitPayment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Payment.class, jsonObject);
        }
        ExplanationOfBenefit.Payment.Builder builder = ExplanationOfBenefit.Payment.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.adjustment(this.parseMoney("adjustment", JsonSupport.getJsonValue(jsonObject, "adjustment", JsonObject.class), -1));
        builder.adjustmentReason(this.parseCodeableConcept("adjustmentReason", JsonSupport.getJsonValue(jsonObject, "adjustmentReason", JsonObject.class), -1));
        builder.date(this.parseDate("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Procedure parseExplanationOfBenefitProcedure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Procedure.class, jsonObject);
        }
        ExplanationOfBenefit.Procedure.Builder builder = ExplanationOfBenefit.Procedure.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.procedure(this.parseChoiceElement("procedure", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray udiArray = JsonSupport.getJsonArray(jsonObject, "udi");
        if (udiArray != null) {
            for (int i = 0; i < udiArray.size(); ++i) {
                builder.udi(this.parseReference("udi", udiArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.ProcessNote parseExplanationOfBenefitProcessNote(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.ProcessNote.class, jsonObject);
        }
        ExplanationOfBenefit.ProcessNote.Builder builder = ExplanationOfBenefit.ProcessNote.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.number((PositiveInt)this.parseInteger(PositiveInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.type((NoteType)this.parseString(NoteType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Related parseExplanationOfBenefitRelated(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Related.class, jsonObject);
        }
        ExplanationOfBenefit.Related.Builder builder = ExplanationOfBenefit.Related.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.claim(this.parseReference("claim", JsonSupport.getJsonValue(jsonObject, "claim", JsonObject.class), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.reference(this.parseIdentifier("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.SupportingInfo parseExplanationOfBenefitSupportingInfo(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.SupportingInfo.class, jsonObject);
        }
        ExplanationOfBenefit.SupportingInfo.Builder builder = ExplanationOfBenefit.SupportingInfo.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.timing(this.parseChoiceElement("timing", jsonObject, Date.class, Period.class));
        builder.value(this.parseChoiceElement("value", jsonObject, Boolean.class, com.ibm.fhir.model.type.String.class, Quantity.class, Attachment.class, Reference.class));
        builder.reason(this.parseCoding("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ExplanationOfBenefit.Total parseExplanationOfBenefitTotal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ExplanationOfBenefit.Total.class, jsonObject);
        }
        ExplanationOfBenefit.Total.Builder builder = ExplanationOfBenefit.Total.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Expression parseExpression(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Expression.class, jsonObject);
        }
        Expression.Builder builder = Expression.builder();
        this.parseElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.name((Id)this.parseString(Id.builder(), "name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.language((Code)this.parseString(Code.builder(), "language", (JsonValue)JsonSupport.getJsonValue(jsonObject, "language", JsonString.class), (JsonValue)jsonObject.get((Object)"_language"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.reference(this.parseUri("reference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reference", JsonString.class), (JsonValue)jsonObject.get((Object)"_reference"), -1));
        this.stackPop();
        return builder.build();
    }

    private Extension parseExtension(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Extension.class, jsonObject);
        }
        Extension.Builder builder = Extension.builder();
        this.parseElement(builder, jsonObject);
        builder.url(this.parseJavaString("url", JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, com.ibm.fhir.model.type.String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
        this.stackPop();
        return builder.build();
    }

    private FamilyMemberHistory parseFamilyMemberHistory(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray conditionArray;
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(FamilyMemberHistory.class, jsonObject);
        }
        FamilyMemberHistory.Builder builder = FamilyMemberHistory.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i3 = 0; i3 < instantiatesCanonicalArray.size(); ++i3) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i3), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i3), i3));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        builder.status((FamilyHistoryStatus)this.parseString(FamilyHistoryStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.dataAbsentReason(this.parseCodeableConcept("dataAbsentReason", JsonSupport.getJsonValue(jsonObject, "dataAbsentReason", JsonObject.class), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.relationship(this.parseCodeableConcept("relationship", JsonSupport.getJsonValue(jsonObject, "relationship", JsonObject.class), -1));
        builder.sex(this.parseCodeableConcept("sex", JsonSupport.getJsonValue(jsonObject, "sex", JsonObject.class), -1));
        builder.born(this.parseChoiceElement("born", jsonObject, Period.class, Date.class, com.ibm.fhir.model.type.String.class));
        builder.age(this.parseChoiceElement("age", jsonObject, Age.class, Range.class, com.ibm.fhir.model.type.String.class));
        builder.estimatedAge(this.parseBoolean("estimatedAge", JsonSupport.getJsonValue(jsonObject, "estimatedAge", JsonValue.class), (JsonValue)jsonObject.get((Object)"_estimatedAge"), -1));
        builder.deceased(this.parseChoiceElement("deceased", jsonObject, Boolean.class, Age.class, Range.class, Date.class, com.ibm.fhir.model.type.String.class));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i4 = 0; i4 < reasonReferenceArray.size(); ++i4) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i4), i4));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i5 = 0; i5 < noteArray.size(); ++i5) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i5), i5));
            }
        }
        if ((conditionArray = JsonSupport.getJsonArray(jsonObject, "condition")) != null) {
            for (int i6 = 0; i6 < conditionArray.size(); ++i6) {
                builder.condition(this.parseFamilyMemberHistoryCondition("condition", conditionArray.getJsonObject(i6), i6));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private FamilyMemberHistory.Condition parseFamilyMemberHistoryCondition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(FamilyMemberHistory.Condition.class, jsonObject);
        }
        FamilyMemberHistory.Condition.Builder builder = FamilyMemberHistory.Condition.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.outcome(this.parseCodeableConcept("outcome", JsonSupport.getJsonValue(jsonObject, "outcome", JsonObject.class), -1));
        builder.contributedToDeath(this.parseBoolean("contributedToDeath", JsonSupport.getJsonValue(jsonObject, "contributedToDeath", JsonValue.class), (JsonValue)jsonObject.get((Object)"_contributedToDeath"), -1));
        builder.onset(this.parseChoiceElement("onset", jsonObject, Age.class, Range.class, Period.class, com.ibm.fhir.model.type.String.class));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Flag parseFlag(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Flag.class, jsonObject);
        }
        Flag.Builder builder = Flag.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((FlagStatus)this.parseString(FlagStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Goal parseGoal(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray outcomeReferenceArray;
        JsonArray outcomeCodeArray;
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Goal.class, jsonObject);
        }
        Goal.Builder builder = Goal.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.lifecycleStatus((GoalLifecycleStatus)this.parseString(GoalLifecycleStatus.builder(), "lifecycleStatus", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lifecycleStatus", JsonString.class), (JsonValue)jsonObject.get((Object)"_lifecycleStatus"), -1));
        builder.achievementStatus(this.parseCodeableConcept("achievementStatus", JsonSupport.getJsonValue(jsonObject, "achievementStatus", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        builder.priority(this.parseCodeableConcept("priority", JsonSupport.getJsonValue(jsonObject, "priority", JsonObject.class), -1));
        builder.description(this.parseCodeableConcept("description", JsonSupport.getJsonValue(jsonObject, "description", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.start(this.parseChoiceElement("start", jsonObject, Date.class, CodeableConcept.class));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                builder.target(this.parseGoalTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        builder.statusDate(this.parseDate("statusDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "statusDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_statusDate"), -1));
        builder.statusReason(this.parseString("statusReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "statusReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_statusReason"), -1));
        builder.expressedBy(this.parseReference("expressedBy", JsonSupport.getJsonValue(jsonObject, "expressedBy", JsonObject.class), -1));
        JsonArray addressesArray = JsonSupport.getJsonArray(jsonObject, "addresses");
        if (addressesArray != null) {
            for (int i = 0; i < addressesArray.size(); ++i) {
                builder.addresses(this.parseReference("addresses", addressesArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((outcomeCodeArray = JsonSupport.getJsonArray(jsonObject, "outcomeCode")) != null) {
            for (int i = 0; i < outcomeCodeArray.size(); ++i) {
                builder.outcomeCode(this.parseCodeableConcept("outcomeCode", outcomeCodeArray.getJsonObject(i), i));
            }
        }
        if ((outcomeReferenceArray = JsonSupport.getJsonArray(jsonObject, "outcomeReference")) != null) {
            for (int i = 0; i < outcomeReferenceArray.size(); ++i) {
                builder.outcomeReference(this.parseReference("outcomeReference", outcomeReferenceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Goal.Target parseGoalTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Goal.Target.class, jsonObject);
        }
        Goal.Target.Builder builder = Goal.Target.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.measure(this.parseCodeableConcept("measure", JsonSupport.getJsonValue(jsonObject, "measure", JsonObject.class), -1));
        builder.detail(this.parseChoiceElement("detail", jsonObject, Quantity.class, Range.class, CodeableConcept.class, com.ibm.fhir.model.type.String.class, Boolean.class, Integer.class, Ratio.class));
        builder.due(this.parseChoiceElement("due", jsonObject, Date.class, Duration.class));
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition parseGraphDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.class, jsonObject);
        }
        GraphDefinition.Builder builder = GraphDefinition.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.start((ResourceType)this.parseString(ResourceType.builder(), "start", (JsonValue)JsonSupport.getJsonValue(jsonObject, "start", JsonString.class), (JsonValue)jsonObject.get((Object)"_start"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray linkArray = JsonSupport.getJsonArray(jsonObject, "link");
        if (linkArray != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                builder.link(this.parseGraphDefinitionLink("link", linkArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link parseGraphDefinitionLink(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.class, jsonObject);
        }
        GraphDefinition.Link.Builder builder = GraphDefinition.Link.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.path(this.parseString("path", (JsonValue)JsonSupport.getJsonValue(jsonObject, "path", JsonString.class), (JsonValue)jsonObject.get((Object)"_path"), -1));
        builder.sliceName(this.parseString("sliceName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sliceName", JsonString.class), (JsonValue)jsonObject.get((Object)"_sliceName"), -1));
        builder.min(this.parseInteger("min", (JsonValue)JsonSupport.getJsonValue(jsonObject, "min", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_min"), -1));
        builder.max(this.parseString("max", (JsonValue)JsonSupport.getJsonValue(jsonObject, "max", JsonString.class), (JsonValue)jsonObject.get((Object)"_max"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray targetArray = JsonSupport.getJsonArray(jsonObject, "target");
        if (targetArray != null) {
            for (int i = 0; i < targetArray.size(); ++i) {
                builder.target(this.parseGraphDefinitionLinkTarget("target", targetArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link.Target parseGraphDefinitionLinkTarget(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray linkArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.Target.class, jsonObject);
        }
        GraphDefinition.Link.Target.Builder builder = GraphDefinition.Link.Target.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ResourceType)this.parseString(ResourceType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.params(this.parseString("params", (JsonValue)JsonSupport.getJsonValue(jsonObject, "params", JsonString.class), (JsonValue)jsonObject.get((Object)"_params"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        JsonArray compartmentArray = JsonSupport.getJsonArray(jsonObject, "compartment");
        if (compartmentArray != null) {
            for (int i = 0; i < compartmentArray.size(); ++i) {
                builder.compartment(this.parseGraphDefinitionLinkTargetCompartment("compartment", compartmentArray.getJsonObject(i), i));
            }
        }
        if ((linkArray = JsonSupport.getJsonArray(jsonObject, "link")) != null) {
            for (int i = 0; i < linkArray.size(); ++i) {
                builder.link(this.parseGraphDefinitionLink("link", linkArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private GraphDefinition.Link.Target.Compartment parseGraphDefinitionLinkTargetCompartment(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(GraphDefinition.Link.Target.Compartment.class, jsonObject);
        }
        GraphDefinition.Link.Target.Compartment.Builder builder = GraphDefinition.Link.Target.Compartment.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.use((GraphCompartmentUse)this.parseString(GraphCompartmentUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.code((CompartmentCode)this.parseString(CompartmentCode.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.rule((GraphCompartmentRule)this.parseString(GraphCompartmentRule.builder(), "rule", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rule", JsonString.class), (JsonValue)jsonObject.get((Object)"_rule"), -1));
        builder.expression(this.parseString("expression", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expression", JsonString.class), (JsonValue)jsonObject.get((Object)"_expression"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private Group parseGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray memberArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Group.class, jsonObject);
        }
        Group.Builder builder = Group.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.type((GroupType)this.parseString(GroupType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.actual(this.parseBoolean("actual", JsonSupport.getJsonValue(jsonObject, "actual", JsonValue.class), (JsonValue)jsonObject.get((Object)"_actual"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.quantity((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "quantity", (JsonValue)JsonSupport.getJsonValue(jsonObject, "quantity", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_quantity"), -1));
        builder.managingEntity(this.parseReference("managingEntity", JsonSupport.getJsonValue(jsonObject, "managingEntity", JsonObject.class), -1));
        JsonArray characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic");
        if (characteristicArray != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                builder.characteristic(this.parseGroupCharacteristic("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        if ((memberArray = JsonSupport.getJsonArray(jsonObject, "member")) != null) {
            for (int i = 0; i < memberArray.size(); ++i) {
                builder.member(this.parseGroupMember("member", memberArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Group.Characteristic parseGroupCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Group.Characteristic.class, jsonObject);
        }
        Group.Characteristic.Builder builder = Group.Characteristic.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, Boolean.class, Quantity.class, Range.class, Reference.class));
        builder.exclude(this.parseBoolean("exclude", JsonSupport.getJsonValue(jsonObject, "exclude", JsonValue.class), (JsonValue)jsonObject.get((Object)"_exclude"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Group.Member parseGroupMember(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Group.Member.class, jsonObject);
        }
        Group.Member.Builder builder = Group.Member.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.entity(this.parseReference("entity", JsonSupport.getJsonValue(jsonObject, "entity", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.inactive(this.parseBoolean("inactive", JsonSupport.getJsonValue(jsonObject, "inactive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_inactive"), -1));
        this.stackPop();
        return builder.build();
    }

    private GuidanceResponse parseGuidanceResponse(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray evaluationMessageArray;
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(GuidanceResponse.class, jsonObject);
        }
        GuidanceResponse.Builder builder = GuidanceResponse.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.requestIdentifier(this.parseIdentifier("requestIdentifier", JsonSupport.getJsonValue(jsonObject, "requestIdentifier", JsonObject.class), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.module(this.parseChoiceElement("module", jsonObject, Uri.class, Canonical.class, CodeableConcept.class));
        builder.status((GuidanceResponseStatus)this.parseString(GuidanceResponseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.occurrenceDateTime(this.parseDateTime("occurrenceDateTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "occurrenceDateTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_occurrenceDateTime"), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((evaluationMessageArray = JsonSupport.getJsonArray(jsonObject, "evaluationMessage")) != null) {
            for (int i = 0; i < evaluationMessageArray.size(); ++i) {
                builder.evaluationMessage(this.parseReference("evaluationMessage", evaluationMessageArray.getJsonObject(i), i));
            }
        }
        builder.outputParameters(this.parseReference("outputParameters", JsonSupport.getJsonValue(jsonObject, "outputParameters", JsonObject.class), -1));
        builder.result(this.parseReference("result", JsonSupport.getJsonValue(jsonObject, "result", JsonObject.class), -1));
        JsonArray dataRequirementArray = JsonSupport.getJsonArray(jsonObject, "dataRequirement");
        if (dataRequirementArray != null) {
            for (int i = 0; i < dataRequirementArray.size(); ++i) {
                builder.dataRequirement(this.parseDataRequirement("dataRequirement", dataRequirementArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private HealthcareService parseHealthcareService(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray notAvailableArray;
        JsonArray referralMethodArray;
        JsonArray communicationArray;
        JsonArray characteristicArray;
        JsonArray programArray;
        JsonArray eligibilityArray;
        JsonArray serviceProvisionCodeArray;
        JsonArray coverageAreaArray;
        JsonArray locationArray;
        JsonArray specialtyArray;
        JsonArray typeArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(HealthcareService.class, jsonObject);
        }
        HealthcareService.Builder builder = HealthcareService.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.providedBy(this.parseReference("providedBy", JsonSupport.getJsonValue(jsonObject, "providedBy", JsonObject.class), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i = 0; i < categoryArray.size(); ++i) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i), i));
            }
        }
        if ((typeArray = JsonSupport.getJsonArray(jsonObject, "type")) != null) {
            for (int i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        if ((specialtyArray = JsonSupport.getJsonArray(jsonObject, "specialty")) != null) {
            for (int i = 0; i < specialtyArray.size(); ++i) {
                builder.specialty(this.parseCodeableConcept("specialty", specialtyArray.getJsonObject(i), i));
            }
        }
        if ((locationArray = JsonSupport.getJsonArray(jsonObject, "location")) != null) {
            for (int i = 0; i < locationArray.size(); ++i) {
                builder.location(this.parseReference("location", locationArray.getJsonObject(i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        builder.extraDetails((Markdown)this.parseString(Markdown.builder(), "extraDetails", (JsonValue)JsonSupport.getJsonValue(jsonObject, "extraDetails", JsonString.class), (JsonValue)jsonObject.get((Object)"_extraDetails"), -1));
        builder.photo(this.parseAttachment("photo", JsonSupport.getJsonValue(jsonObject, "photo", JsonObject.class), -1));
        JsonArray telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom");
        if (telecomArray != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        if ((coverageAreaArray = JsonSupport.getJsonArray(jsonObject, "coverageArea")) != null) {
            for (int i = 0; i < coverageAreaArray.size(); ++i) {
                builder.coverageArea(this.parseReference("coverageArea", coverageAreaArray.getJsonObject(i), i));
            }
        }
        if ((serviceProvisionCodeArray = JsonSupport.getJsonArray(jsonObject, "serviceProvisionCode")) != null) {
            for (int i = 0; i < serviceProvisionCodeArray.size(); ++i) {
                builder.serviceProvisionCode(this.parseCodeableConcept("serviceProvisionCode", serviceProvisionCodeArray.getJsonObject(i), i));
            }
        }
        if ((eligibilityArray = JsonSupport.getJsonArray(jsonObject, "eligibility")) != null) {
            for (int i = 0; i < eligibilityArray.size(); ++i) {
                builder.eligibility(this.parseHealthcareServiceEligibility("eligibility", eligibilityArray.getJsonObject(i), i));
            }
        }
        if ((programArray = JsonSupport.getJsonArray(jsonObject, "program")) != null) {
            for (int i = 0; i < programArray.size(); ++i) {
                builder.program(this.parseCodeableConcept("program", programArray.getJsonObject(i), i));
            }
        }
        if ((characteristicArray = JsonSupport.getJsonArray(jsonObject, "characteristic")) != null) {
            for (int i = 0; i < characteristicArray.size(); ++i) {
                builder.characteristic(this.parseCodeableConcept("characteristic", characteristicArray.getJsonObject(i), i));
            }
        }
        if ((communicationArray = JsonSupport.getJsonArray(jsonObject, "communication")) != null) {
            for (int i = 0; i < communicationArray.size(); ++i) {
                builder.communication(this.parseCodeableConcept("communication", communicationArray.getJsonObject(i), i));
            }
        }
        if ((referralMethodArray = JsonSupport.getJsonArray(jsonObject, "referralMethod")) != null) {
            for (int i = 0; i < referralMethodArray.size(); ++i) {
                builder.referralMethod(this.parseCodeableConcept("referralMethod", referralMethodArray.getJsonObject(i), i));
            }
        }
        builder.appointmentRequired(this.parseBoolean("appointmentRequired", JsonSupport.getJsonValue(jsonObject, "appointmentRequired", JsonValue.class), (JsonValue)jsonObject.get((Object)"_appointmentRequired"), -1));
        JsonArray availableTimeArray = JsonSupport.getJsonArray(jsonObject, "availableTime");
        if (availableTimeArray != null) {
            for (int i = 0; i < availableTimeArray.size(); ++i) {
                builder.availableTime(this.parseHealthcareServiceAvailableTime("availableTime", availableTimeArray.getJsonObject(i), i));
            }
        }
        if ((notAvailableArray = JsonSupport.getJsonArray(jsonObject, "notAvailable")) != null) {
            for (int i = 0; i < notAvailableArray.size(); ++i) {
                builder.notAvailable(this.parseHealthcareServiceNotAvailable("notAvailable", notAvailableArray.getJsonObject(i), i));
            }
        }
        builder.availabilityExceptions(this.parseString("availabilityExceptions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "availabilityExceptions", JsonString.class), (JsonValue)jsonObject.get((Object)"_availabilityExceptions"), -1));
        JsonArray endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint");
        if (endpointArray != null) {
            for (int i = 0; i < endpointArray.size(); ++i) {
                builder.endpoint(this.parseReference("endpoint", endpointArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private HealthcareService.AvailableTime parseHealthcareServiceAvailableTime(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(HealthcareService.AvailableTime.class, jsonObject);
        }
        HealthcareService.AvailableTime.Builder builder = HealthcareService.AvailableTime.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray daysOfWeekArray = JsonSupport.getJsonArray(jsonObject, "daysOfWeek", true);
        if (daysOfWeekArray != null) {
            JsonArray _daysOfWeekArray = jsonObject.getJsonArray("_daysOfWeek");
            for (int i = 0; i < daysOfWeekArray.size(); ++i) {
                builder.daysOfWeek((DaysOfWeek)this.parseString(DaysOfWeek.builder(), "daysOfWeek", (JsonValue)daysOfWeekArray.get(i), JsonSupport.getJsonValue(_daysOfWeekArray, i), i));
            }
        }
        builder.allDay(this.parseBoolean("allDay", JsonSupport.getJsonValue(jsonObject, "allDay", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allDay"), -1));
        builder.availableStartTime(this.parseTime("availableStartTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "availableStartTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_availableStartTime"), -1));
        builder.availableEndTime(this.parseTime("availableEndTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "availableEndTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_availableEndTime"), -1));
        this.stackPop();
        return builder.build();
    }

    private HealthcareService.Eligibility parseHealthcareServiceEligibility(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(HealthcareService.Eligibility.class, jsonObject);
        }
        HealthcareService.Eligibility.Builder builder = HealthcareService.Eligibility.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.comment((Markdown)this.parseString(Markdown.builder(), "comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private HealthcareService.NotAvailable parseHealthcareServiceNotAvailable(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(HealthcareService.NotAvailable.class, jsonObject);
        }
        HealthcareService.NotAvailable.Builder builder = HealthcareService.NotAvailable.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.during(this.parsePeriod("during", JsonSupport.getJsonValue(jsonObject, "during", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private HumanName parseHumanName(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray suffixArray;
        JsonArray prefixArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(HumanName.class, jsonObject);
        }
        HumanName.Builder builder = HumanName.builder();
        this.parseElement(builder, jsonObject);
        builder.use((NameUse)this.parseString(NameUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.family(this.parseString("family", (JsonValue)JsonSupport.getJsonValue(jsonObject, "family", JsonString.class), (JsonValue)jsonObject.get((Object)"_family"), -1));
        JsonArray givenArray = JsonSupport.getJsonArray(jsonObject, "given", true);
        if (givenArray != null) {
            JsonArray _givenArray = jsonObject.getJsonArray("_given");
            for (int i = 0; i < givenArray.size(); ++i) {
                builder.given(this.parseString("given", (JsonValue)givenArray.get(i), JsonSupport.getJsonValue(_givenArray, i), i));
            }
        }
        if ((prefixArray = JsonSupport.getJsonArray(jsonObject, "prefix", true)) != null) {
            JsonArray _prefixArray = jsonObject.getJsonArray("_prefix");
            for (int i = 0; i < prefixArray.size(); ++i) {
                builder.prefix(this.parseString("prefix", (JsonValue)prefixArray.get(i), JsonSupport.getJsonValue(_prefixArray, i), i));
            }
        }
        if ((suffixArray = JsonSupport.getJsonArray(jsonObject, "suffix", true)) != null) {
            JsonArray _suffixArray = jsonObject.getJsonArray("_suffix");
            for (int i = 0; i < suffixArray.size(); ++i) {
                builder.suffix(this.parseString("suffix", (JsonValue)suffixArray.get(i), JsonSupport.getJsonValue(_suffixArray, i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Identifier parseIdentifier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Identifier.class, jsonObject);
        }
        Identifier.Builder builder = Identifier.builder();
        this.parseElement(builder, jsonObject);
        builder.use((IdentifierUse)this.parseString(IdentifierUse.builder(), "use", (JsonValue)JsonSupport.getJsonValue(jsonObject, "use", JsonString.class), (JsonValue)jsonObject.get((Object)"_use"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.system(this.parseUri("system", (JsonValue)JsonSupport.getJsonValue(jsonObject, "system", JsonString.class), (JsonValue)jsonObject.get((Object)"_system"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.assigner(this.parseReference("assigner", JsonSupport.getJsonValue(jsonObject, "assigner", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ImagingStudy parseImagingStudy(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        JsonArray endpointArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImagingStudy.class, jsonObject);
        }
        ImagingStudy.Builder builder = ImagingStudy.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ImagingStudyStatus)this.parseString(ImagingStudyStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray modalityArray = JsonSupport.getJsonArray(jsonObject, "modality");
        if (modalityArray != null) {
            for (int i = 0; i < modalityArray.size(); ++i) {
                builder.modality(this.parseCoding("modality", modalityArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.started(this.parseDateTime("started", (JsonValue)JsonSupport.getJsonValue(jsonObject, "started", JsonString.class), (JsonValue)jsonObject.get((Object)"_started"), -1));
        JsonArray basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn");
        if (basedOnArray != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.referrer(this.parseReference("referrer", JsonSupport.getJsonValue(jsonObject, "referrer", JsonObject.class), -1));
        JsonArray interpreterArray = JsonSupport.getJsonArray(jsonObject, "interpreter");
        if (interpreterArray != null) {
            for (int i = 0; i < interpreterArray.size(); ++i) {
                builder.interpreter(this.parseReference("interpreter", interpreterArray.getJsonObject(i), i));
            }
        }
        if ((endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint")) != null) {
            for (int i = 0; i < endpointArray.size(); ++i) {
                builder.endpoint(this.parseReference("endpoint", endpointArray.getJsonObject(i), i));
            }
        }
        builder.numberOfSeries((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfSeries", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfSeries", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfSeries"), -1));
        builder.numberOfInstances((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfInstances", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfInstances", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfInstances"), -1));
        builder.procedureReference(this.parseReference("procedureReference", JsonSupport.getJsonValue(jsonObject, "procedureReference", JsonObject.class), -1));
        JsonArray procedureCodeArray = JsonSupport.getJsonArray(jsonObject, "procedureCode");
        if (procedureCodeArray != null) {
            for (int i = 0; i < procedureCodeArray.size(); ++i) {
                builder.procedureCode(this.parseCodeableConcept("procedureCode", procedureCodeArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray seriesArray = JsonSupport.getJsonArray(jsonObject, "series");
        if (seriesArray != null) {
            for (int i = 0; i < seriesArray.size(); ++i) {
                builder.series(this.parseImagingStudySeries("series", seriesArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImagingStudy.Series parseImagingStudySeries(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray instanceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImagingStudy.Series.class, jsonObject);
        }
        ImagingStudy.Series.Builder builder = ImagingStudy.Series.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.uid((Id)this.parseString(Id.builder(), "uid", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uid", JsonString.class), (JsonValue)jsonObject.get((Object)"_uid"), -1));
        builder.number((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.modality(this.parseCoding("modality", JsonSupport.getJsonValue(jsonObject, "modality", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.numberOfInstances((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfInstances", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfInstances", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfInstances"), -1));
        JsonArray endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint");
        if (endpointArray != null) {
            for (int i = 0; i < endpointArray.size(); ++i) {
                builder.endpoint(this.parseReference("endpoint", endpointArray.getJsonObject(i), i));
            }
        }
        builder.bodySite(this.parseCoding("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        builder.laterality(this.parseCoding("laterality", JsonSupport.getJsonValue(jsonObject, "laterality", JsonObject.class), -1));
        JsonArray specimenArray = JsonSupport.getJsonArray(jsonObject, "specimen");
        if (specimenArray != null) {
            for (int i = 0; i < specimenArray.size(); ++i) {
                builder.specimen(this.parseReference("specimen", specimenArray.getJsonObject(i), i));
            }
        }
        builder.started(this.parseDateTime("started", (JsonValue)JsonSupport.getJsonValue(jsonObject, "started", JsonString.class), (JsonValue)jsonObject.get((Object)"_started"), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                builder.performer(this.parseImagingStudySeriesPerformer("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((instanceArray = JsonSupport.getJsonArray(jsonObject, "instance")) != null) {
            for (int i = 0; i < instanceArray.size(); ++i) {
                builder.instance(this.parseImagingStudySeriesInstance("instance", instanceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImagingStudy.Series.Instance parseImagingStudySeriesInstance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImagingStudy.Series.Instance.class, jsonObject);
        }
        ImagingStudy.Series.Instance.Builder builder = ImagingStudy.Series.Instance.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.uid((Id)this.parseString(Id.builder(), "uid", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uid", JsonString.class), (JsonValue)jsonObject.get((Object)"_uid"), -1));
        builder.sopClass(this.parseCoding("sopClass", JsonSupport.getJsonValue(jsonObject, "sopClass", JsonObject.class), -1));
        builder.number((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "number", (JsonValue)JsonSupport.getJsonValue(jsonObject, "number", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_number"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImagingStudy.Series.Performer parseImagingStudySeriesPerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImagingStudy.Series.Performer.class, jsonObject);
        }
        ImagingStudy.Series.Performer.Builder builder = ImagingStudy.Series.Performer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Immunization parseImmunization(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray protocolAppliedArray;
        JsonArray programEligibilityArray;
        JsonArray educationArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        JsonArray noteArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Immunization.class, jsonObject);
        }
        Immunization.Builder builder = Immunization.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ImmunizationStatus)this.parseString(ImmunizationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.vaccineCode(this.parseCodeableConcept("vaccineCode", JsonSupport.getJsonValue(jsonObject, "vaccineCode", JsonObject.class), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.occurrence(this.parseChoiceElement("occurrence", jsonObject, DateTime.class, com.ibm.fhir.model.type.String.class));
        builder.recorded(this.parseDateTime("recorded", (JsonValue)JsonSupport.getJsonValue(jsonObject, "recorded", JsonString.class), (JsonValue)jsonObject.get((Object)"_recorded"), -1));
        builder.primarySource(this.parseBoolean("primarySource", JsonSupport.getJsonValue(jsonObject, "primarySource", JsonValue.class), (JsonValue)jsonObject.get((Object)"_primarySource"), -1));
        builder.reportOrigin(this.parseCodeableConcept("reportOrigin", JsonSupport.getJsonValue(jsonObject, "reportOrigin", JsonObject.class), -1));
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        builder.manufacturer(this.parseReference("manufacturer", JsonSupport.getJsonValue(jsonObject, "manufacturer", JsonObject.class), -1));
        builder.lotNumber(this.parseString("lotNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lotNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_lotNumber"), -1));
        builder.expirationDate(this.parseDate("expirationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expirationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_expirationDate"), -1));
        builder.site(this.parseCodeableConcept("site", JsonSupport.getJsonValue(jsonObject, "site", JsonObject.class), -1));
        builder.route(this.parseCodeableConcept("route", JsonSupport.getJsonValue(jsonObject, "route", JsonObject.class), -1));
        builder.doseQuantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "doseQuantity", JsonSupport.getJsonValue(jsonObject, "doseQuantity", JsonObject.class), -1));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                builder.performer(this.parseImmunizationPerformer("performer", performerArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        builder.isSubpotent(this.parseBoolean("isSubpotent", JsonSupport.getJsonValue(jsonObject, "isSubpotent", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isSubpotent"), -1));
        JsonArray subpotentReasonArray = JsonSupport.getJsonArray(jsonObject, "subpotentReason");
        if (subpotentReasonArray != null) {
            for (int i = 0; i < subpotentReasonArray.size(); ++i) {
                builder.subpotentReason(this.parseCodeableConcept("subpotentReason", subpotentReasonArray.getJsonObject(i), i));
            }
        }
        if ((educationArray = JsonSupport.getJsonArray(jsonObject, "education")) != null) {
            for (int i = 0; i < educationArray.size(); ++i) {
                builder.education(this.parseImmunizationEducation("education", educationArray.getJsonObject(i), i));
            }
        }
        if ((programEligibilityArray = JsonSupport.getJsonArray(jsonObject, "programEligibility")) != null) {
            for (int i = 0; i < programEligibilityArray.size(); ++i) {
                builder.programEligibility(this.parseCodeableConcept("programEligibility", programEligibilityArray.getJsonObject(i), i));
            }
        }
        builder.fundingSource(this.parseCodeableConcept("fundingSource", JsonSupport.getJsonValue(jsonObject, "fundingSource", JsonObject.class), -1));
        JsonArray reactionArray = JsonSupport.getJsonArray(jsonObject, "reaction");
        if (reactionArray != null) {
            for (int i = 0; i < reactionArray.size(); ++i) {
                builder.reaction(this.parseImmunizationReaction("reaction", reactionArray.getJsonObject(i), i));
            }
        }
        if ((protocolAppliedArray = JsonSupport.getJsonArray(jsonObject, "protocolApplied")) != null) {
            for (int i = 0; i < protocolAppliedArray.size(); ++i) {
                builder.protocolApplied(this.parseImmunizationProtocolApplied("protocolApplied", protocolAppliedArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Immunization.Education parseImmunizationEducation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Immunization.Education.class, jsonObject);
        }
        Immunization.Education.Builder builder = Immunization.Education.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.documentType(this.parseString("documentType", (JsonValue)JsonSupport.getJsonValue(jsonObject, "documentType", JsonString.class), (JsonValue)jsonObject.get((Object)"_documentType"), -1));
        builder.reference(this.parseUri("reference", (JsonValue)JsonSupport.getJsonValue(jsonObject, "reference", JsonString.class), (JsonValue)jsonObject.get((Object)"_reference"), -1));
        builder.publicationDate(this.parseDateTime("publicationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publicationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_publicationDate"), -1));
        builder.presentationDate(this.parseDateTime("presentationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "presentationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_presentationDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private Immunization.Performer parseImmunizationPerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Immunization.Performer.class, jsonObject);
        }
        Immunization.Performer.Builder builder = Immunization.Performer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Immunization.ProtocolApplied parseImmunizationProtocolApplied(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Immunization.ProtocolApplied.class, jsonObject);
        }
        Immunization.ProtocolApplied.Builder builder = Immunization.ProtocolApplied.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.series(this.parseString("series", (JsonValue)JsonSupport.getJsonValue(jsonObject, "series", JsonString.class), (JsonValue)jsonObject.get((Object)"_series"), -1));
        builder.authority(this.parseReference("authority", JsonSupport.getJsonValue(jsonObject, "authority", JsonObject.class), -1));
        JsonArray targetDiseaseArray = JsonSupport.getJsonArray(jsonObject, "targetDisease");
        if (targetDiseaseArray != null) {
            for (int i = 0; i < targetDiseaseArray.size(); ++i) {
                builder.targetDisease(this.parseCodeableConcept("targetDisease", targetDiseaseArray.getJsonObject(i), i));
            }
        }
        builder.doseNumber(this.parseChoiceElement("doseNumber", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        builder.seriesDoses(this.parseChoiceElement("seriesDoses", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        this.stackPop();
        return builder.build();
    }

    private Immunization.Reaction parseImmunizationReaction(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Immunization.Reaction.class, jsonObject);
        }
        Immunization.Reaction.Builder builder = Immunization.Reaction.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.detail(this.parseReference("detail", JsonSupport.getJsonValue(jsonObject, "detail", JsonObject.class), -1));
        builder.reported(this.parseBoolean("reported", JsonSupport.getJsonValue(jsonObject, "reported", JsonValue.class), (JsonValue)jsonObject.get((Object)"_reported"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImmunizationEvaluation parseImmunizationEvaluation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImmunizationEvaluation.class, jsonObject);
        }
        ImmunizationEvaluation.Builder builder = ImmunizationEvaluation.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ImmunizationEvaluationStatus)this.parseString(ImmunizationEvaluationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.authority(this.parseReference("authority", JsonSupport.getJsonValue(jsonObject, "authority", JsonObject.class), -1));
        builder.targetDisease(this.parseCodeableConcept("targetDisease", JsonSupport.getJsonValue(jsonObject, "targetDisease", JsonObject.class), -1));
        builder.immunizationEvent(this.parseReference("immunizationEvent", JsonSupport.getJsonValue(jsonObject, "immunizationEvent", JsonObject.class), -1));
        builder.doseStatus(this.parseCodeableConcept("doseStatus", JsonSupport.getJsonValue(jsonObject, "doseStatus", JsonObject.class), -1));
        JsonArray doseStatusReasonArray = JsonSupport.getJsonArray(jsonObject, "doseStatusReason");
        if (doseStatusReasonArray != null) {
            for (int i = 0; i < doseStatusReasonArray.size(); ++i) {
                builder.doseStatusReason(this.parseCodeableConcept("doseStatusReason", doseStatusReasonArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.series(this.parseString("series", (JsonValue)JsonSupport.getJsonValue(jsonObject, "series", JsonString.class), (JsonValue)jsonObject.get((Object)"_series"), -1));
        builder.doseNumber(this.parseChoiceElement("doseNumber", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        builder.seriesDoses(this.parseChoiceElement("seriesDoses", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        this.stackPop();
        return builder.build();
    }

    private ImmunizationRecommendation parseImmunizationRecommendation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImmunizationRecommendation.class, jsonObject);
        }
        ImmunizationRecommendation.Builder builder = ImmunizationRecommendation.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.patient(this.parseReference("patient", JsonSupport.getJsonValue(jsonObject, "patient", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.authority(this.parseReference("authority", JsonSupport.getJsonValue(jsonObject, "authority", JsonObject.class), -1));
        JsonArray recommendationArray = JsonSupport.getJsonArray(jsonObject, "recommendation");
        if (recommendationArray != null) {
            for (int i = 0; i < recommendationArray.size(); ++i) {
                builder.recommendation(this.parseImmunizationRecommendationRecommendation("recommendation", recommendationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImmunizationRecommendation.Recommendation parseImmunizationRecommendationRecommendation(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray supportingPatientInformationArray;
        JsonArray dateCriterionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImmunizationRecommendation.Recommendation.class, jsonObject);
        }
        ImmunizationRecommendation.Recommendation.Builder builder = ImmunizationRecommendation.Recommendation.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray vaccineCodeArray = JsonSupport.getJsonArray(jsonObject, "vaccineCode");
        if (vaccineCodeArray != null) {
            for (int i = 0; i < vaccineCodeArray.size(); ++i) {
                builder.vaccineCode(this.parseCodeableConcept("vaccineCode", vaccineCodeArray.getJsonObject(i), i));
            }
        }
        builder.targetDisease(this.parseCodeableConcept("targetDisease", JsonSupport.getJsonValue(jsonObject, "targetDisease", JsonObject.class), -1));
        JsonArray contraindicatedVaccineCodeArray = JsonSupport.getJsonArray(jsonObject, "contraindicatedVaccineCode");
        if (contraindicatedVaccineCodeArray != null) {
            for (int i = 0; i < contraindicatedVaccineCodeArray.size(); ++i) {
                builder.contraindicatedVaccineCode(this.parseCodeableConcept("contraindicatedVaccineCode", contraindicatedVaccineCodeArray.getJsonObject(i), i));
            }
        }
        builder.forecastStatus(this.parseCodeableConcept("forecastStatus", JsonSupport.getJsonValue(jsonObject, "forecastStatus", JsonObject.class), -1));
        JsonArray forecastReasonArray = JsonSupport.getJsonArray(jsonObject, "forecastReason");
        if (forecastReasonArray != null) {
            for (int i = 0; i < forecastReasonArray.size(); ++i) {
                builder.forecastReason(this.parseCodeableConcept("forecastReason", forecastReasonArray.getJsonObject(i), i));
            }
        }
        if ((dateCriterionArray = JsonSupport.getJsonArray(jsonObject, "dateCriterion")) != null) {
            for (int i = 0; i < dateCriterionArray.size(); ++i) {
                builder.dateCriterion(this.parseImmunizationRecommendationRecommendationDateCriterion("dateCriterion", dateCriterionArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.series(this.parseString("series", (JsonValue)JsonSupport.getJsonValue(jsonObject, "series", JsonString.class), (JsonValue)jsonObject.get((Object)"_series"), -1));
        builder.doseNumber(this.parseChoiceElement("doseNumber", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        builder.seriesDoses(this.parseChoiceElement("seriesDoses", jsonObject, PositiveInt.class, com.ibm.fhir.model.type.String.class));
        JsonArray supportingImmunizationArray = JsonSupport.getJsonArray(jsonObject, "supportingImmunization");
        if (supportingImmunizationArray != null) {
            for (int i = 0; i < supportingImmunizationArray.size(); ++i) {
                builder.supportingImmunization(this.parseReference("supportingImmunization", supportingImmunizationArray.getJsonObject(i), i));
            }
        }
        if ((supportingPatientInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingPatientInformation")) != null) {
            for (int i = 0; i < supportingPatientInformationArray.size(); ++i) {
                builder.supportingPatientInformation(this.parseReference("supportingPatientInformation", supportingPatientInformationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImmunizationRecommendation.Recommendation.DateCriterion parseImmunizationRecommendationRecommendationDateCriterion(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImmunizationRecommendation.Recommendation.DateCriterion.class, jsonObject);
        }
        ImmunizationRecommendation.Recommendation.DateCriterion.Builder builder = ImmunizationRecommendation.Recommendation.DateCriterion.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseDateTime("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide parseImplementationGuide(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray globalArray;
        JsonArray dependsOnArray;
        int i;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.class, jsonObject);
        }
        ImplementationGuide.Builder builder = ImplementationGuide.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i2 = 0; i2 < contactArray.size(); ++i2) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i2), i2));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i3 = 0; i3 < useContextArray.size(); ++i3) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i3), i3));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i4 = 0; i4 < jurisdictionArray.size(); ++i4) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i4), i4));
            }
        }
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.packageId((Id)this.parseString(Id.builder(), "packageId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "packageId", JsonString.class), (JsonValue)jsonObject.get((Object)"_packageId"), -1));
        builder.license((SPDXLicense)this.parseString(SPDXLicense.builder(), "license", (JsonValue)JsonSupport.getJsonValue(jsonObject, "license", JsonString.class), (JsonValue)jsonObject.get((Object)"_license"), -1));
        JsonArray fhirVersionArray = JsonSupport.getJsonArray(jsonObject, "fhirVersion", true);
        if (fhirVersionArray != null) {
            JsonArray _fhirVersionArray = jsonObject.getJsonArray("_fhirVersion");
            for (i = 0; i < fhirVersionArray.size(); ++i) {
                builder.fhirVersion((FHIRVersion)this.parseString(FHIRVersion.builder(), "fhirVersion", (JsonValue)fhirVersionArray.get(i), JsonSupport.getJsonValue(_fhirVersionArray, i), i));
            }
        }
        if ((dependsOnArray = JsonSupport.getJsonArray(jsonObject, "dependsOn")) != null) {
            for (i = 0; i < dependsOnArray.size(); ++i) {
                builder.dependsOn(this.parseImplementationGuideDependsOn("dependsOn", dependsOnArray.getJsonObject(i), i));
            }
        }
        if ((globalArray = JsonSupport.getJsonArray(jsonObject, "global")) != null) {
            for (int i5 = 0; i5 < globalArray.size(); ++i5) {
                builder.global(this.parseImplementationGuideGlobal("global", globalArray.getJsonObject(i5), i5));
            }
        }
        builder.definition(this.parseImplementationGuideDefinition("definition", JsonSupport.getJsonValue(jsonObject, "definition", JsonObject.class), -1));
        builder.manifest(this.parseImplementationGuideManifest("manifest", JsonSupport.getJsonValue(jsonObject, "manifest", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition parseImplementationGuideDefinition(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray templateArray;
        JsonArray resourceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.class, jsonObject);
        }
        ImplementationGuide.Definition.Builder builder = ImplementationGuide.Definition.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray groupingArray = JsonSupport.getJsonArray(jsonObject, "grouping");
        if (groupingArray != null) {
            for (int i = 0; i < groupingArray.size(); ++i) {
                builder.grouping(this.parseImplementationGuideDefinitionGrouping("grouping", groupingArray.getJsonObject(i), i));
            }
        }
        if ((resourceArray = JsonSupport.getJsonArray(jsonObject, "resource")) != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                builder.resource(this.parseImplementationGuideDefinitionResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        builder.page(this.parseImplementationGuideDefinitionPage("page", JsonSupport.getJsonValue(jsonObject, "page", JsonObject.class), -1));
        JsonArray parameterArray = JsonSupport.getJsonArray(jsonObject, "parameter");
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.size(); ++i) {
                builder.parameter(this.parseImplementationGuideDefinitionParameter("parameter", parameterArray.getJsonObject(i), i));
            }
        }
        if ((templateArray = JsonSupport.getJsonArray(jsonObject, "template")) != null) {
            for (int i = 0; i < templateArray.size(); ++i) {
                builder.template(this.parseImplementationGuideDefinitionTemplate("template", templateArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition.Grouping parseImplementationGuideDefinitionGrouping(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.Grouping.class, jsonObject);
        }
        ImplementationGuide.Definition.Grouping.Builder builder = ImplementationGuide.Definition.Grouping.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition.Page parseImplementationGuideDefinitionPage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.Page.class, jsonObject);
        }
        ImplementationGuide.Definition.Page.Builder builder = ImplementationGuide.Definition.Page.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseChoiceElement("name", jsonObject, Url.class, Reference.class));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.generation((GuidePageGeneration)this.parseString(GuidePageGeneration.builder(), "generation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "generation", JsonString.class), (JsonValue)jsonObject.get((Object)"_generation"), -1));
        JsonArray pageArray = JsonSupport.getJsonArray(jsonObject, "page");
        if (pageArray != null) {
            for (int i = 0; i < pageArray.size(); ++i) {
                builder.page(this.parseImplementationGuideDefinitionPage("page", pageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition.Parameter parseImplementationGuideDefinitionParameter(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.Parameter.class, jsonObject);
        }
        ImplementationGuide.Definition.Parameter.Builder builder = ImplementationGuide.Definition.Parameter.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((GuideParameterCode)this.parseString(GuideParameterCode.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.value(this.parseString("value", (JsonValue)JsonSupport.getJsonValue(jsonObject, "value", JsonString.class), (JsonValue)jsonObject.get((Object)"_value"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition.Resource parseImplementationGuideDefinitionResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.Resource.class, jsonObject);
        }
        ImplementationGuide.Definition.Resource.Builder builder = ImplementationGuide.Definition.Resource.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        JsonArray fhirVersionArray = JsonSupport.getJsonArray(jsonObject, "fhirVersion", true);
        if (fhirVersionArray != null) {
            JsonArray _fhirVersionArray = jsonObject.getJsonArray("_fhirVersion");
            for (int i = 0; i < fhirVersionArray.size(); ++i) {
                builder.fhirVersion((FHIRVersion)this.parseString(FHIRVersion.builder(), "fhirVersion", (JsonValue)fhirVersionArray.get(i), JsonSupport.getJsonValue(_fhirVersionArray, i), i));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.example(this.parseChoiceElement("example", jsonObject, Boolean.class, Canonical.class));
        builder.groupingId((Id)this.parseString(Id.builder(), "groupingId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "groupingId", JsonString.class), (JsonValue)jsonObject.get((Object)"_groupingId"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Definition.Template parseImplementationGuideDefinitionTemplate(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Definition.Template.class, jsonObject);
        }
        ImplementationGuide.Definition.Template.Builder builder = ImplementationGuide.Definition.Template.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code((Code)this.parseString(Code.builder(), "code", (JsonValue)JsonSupport.getJsonValue(jsonObject, "code", JsonString.class), (JsonValue)jsonObject.get((Object)"_code"), -1));
        builder.source(this.parseString("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.scope(this.parseString("scope", (JsonValue)JsonSupport.getJsonValue(jsonObject, "scope", JsonString.class), (JsonValue)jsonObject.get((Object)"_scope"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.DependsOn parseImplementationGuideDependsOn(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.DependsOn.class, jsonObject);
        }
        ImplementationGuide.DependsOn.Builder builder = ImplementationGuide.DependsOn.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.uri((Canonical)this.parseUri(Canonical.builder(), "uri", (JsonValue)JsonSupport.getJsonValue(jsonObject, "uri", JsonString.class), (JsonValue)jsonObject.get((Object)"_uri"), -1));
        builder.packageId((Id)this.parseString(Id.builder(), "packageId", (JsonValue)JsonSupport.getJsonValue(jsonObject, "packageId", JsonString.class), (JsonValue)jsonObject.get((Object)"_packageId"), -1));
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Global parseImplementationGuideGlobal(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Global.class, jsonObject);
        }
        ImplementationGuide.Global.Builder builder = ImplementationGuide.Global.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((ResourceType)this.parseString(ResourceType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.profile((Canonical)this.parseUri(Canonical.builder(), "profile", (JsonValue)JsonSupport.getJsonValue(jsonObject, "profile", JsonString.class), (JsonValue)jsonObject.get((Object)"_profile"), -1));
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Manifest parseImplementationGuideManifest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray otherArray;
        JsonArray imageArray;
        JsonArray pageArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Manifest.class, jsonObject);
        }
        ImplementationGuide.Manifest.Builder builder = ImplementationGuide.Manifest.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.rendering((Url)this.parseUri(Url.builder(), "rendering", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rendering", JsonString.class), (JsonValue)jsonObject.get((Object)"_rendering"), -1));
        JsonArray resourceArray = JsonSupport.getJsonArray(jsonObject, "resource");
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.size(); ++i) {
                builder.resource(this.parseImplementationGuideManifestResource("resource", resourceArray.getJsonObject(i), i));
            }
        }
        if ((pageArray = JsonSupport.getJsonArray(jsonObject, "page")) != null) {
            for (int i = 0; i < pageArray.size(); ++i) {
                builder.page(this.parseImplementationGuideManifestPage("page", pageArray.getJsonObject(i), i));
            }
        }
        if ((imageArray = JsonSupport.getJsonArray(jsonObject, "image", true)) != null) {
            JsonArray _imageArray = jsonObject.getJsonArray("_image");
            for (int i = 0; i < imageArray.size(); ++i) {
                builder.image(this.parseString("image", (JsonValue)imageArray.get(i), JsonSupport.getJsonValue(_imageArray, i), i));
            }
        }
        if ((otherArray = JsonSupport.getJsonArray(jsonObject, "other", true)) != null) {
            JsonArray _otherArray = jsonObject.getJsonArray("_other");
            for (int i = 0; i < otherArray.size(); ++i) {
                builder.other(this.parseString("other", (JsonValue)otherArray.get(i), JsonSupport.getJsonValue(_otherArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Manifest.Page parseImplementationGuideManifestPage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Manifest.Page.class, jsonObject);
        }
        ImplementationGuide.Manifest.Page.Builder builder = ImplementationGuide.Manifest.Page.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        JsonArray anchorArray = JsonSupport.getJsonArray(jsonObject, "anchor", true);
        if (anchorArray != null) {
            JsonArray _anchorArray = jsonObject.getJsonArray("_anchor");
            for (int i = 0; i < anchorArray.size(); ++i) {
                builder.anchor(this.parseString("anchor", (JsonValue)anchorArray.get(i), JsonSupport.getJsonValue(_anchorArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private ImplementationGuide.Manifest.Resource parseImplementationGuideManifestResource(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(ImplementationGuide.Manifest.Resource.class, jsonObject);
        }
        ImplementationGuide.Manifest.Resource.Builder builder = ImplementationGuide.Manifest.Resource.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.reference(this.parseReference("reference", JsonSupport.getJsonValue(jsonObject, "reference", JsonObject.class), -1));
        builder.example(this.parseChoiceElement("example", jsonObject, Boolean.class, Canonical.class));
        builder.relativePath((Url)this.parseUri(Url.builder(), "relativePath", (JsonValue)JsonSupport.getJsonValue(jsonObject, "relativePath", JsonString.class), (JsonValue)jsonObject.get((Object)"_relativePath"), -1));
        this.stackPop();
        return builder.build();
    }

    private Instant parseInstant(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        Instant.Builder builder = Instant.builder();
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            JsonString jsonString = (JsonString)jsonValue;
            builder.value(jsonString.getString());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: STRING but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan parseInsurancePlan(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray planArray;
        JsonArray coverageArray;
        JsonArray networkArray;
        JsonArray endpointArray;
        JsonArray contactArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.class, jsonObject);
        }
        InsurancePlan.Builder builder = InsurancePlan.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (int i3 = 0; i3 < typeArray.size(); ++i3) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i3), i3));
            }
        }
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i = 0; i < aliasArray.size(); ++i) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i), JsonSupport.getJsonValue(_aliasArray, i), i));
            }
        }
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.ownedBy(this.parseReference("ownedBy", JsonSupport.getJsonValue(jsonObject, "ownedBy", JsonObject.class), -1));
        builder.administeredBy(this.parseReference("administeredBy", JsonSupport.getJsonValue(jsonObject, "administeredBy", JsonObject.class), -1));
        JsonArray coverageAreaArray = JsonSupport.getJsonArray(jsonObject, "coverageArea");
        if (coverageAreaArray != null) {
            for (i = 0; i < coverageAreaArray.size(); ++i) {
                builder.coverageArea(this.parseReference("coverageArea", coverageAreaArray.getJsonObject(i), i));
            }
        }
        if ((contactArray = JsonSupport.getJsonArray(jsonObject, "contact")) != null) {
            for (int i4 = 0; i4 < contactArray.size(); ++i4) {
                builder.contact(this.parseInsurancePlanContact("contact", contactArray.getJsonObject(i4), i4));
            }
        }
        if ((endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint")) != null) {
            for (int i5 = 0; i5 < endpointArray.size(); ++i5) {
                builder.endpoint(this.parseReference("endpoint", endpointArray.getJsonObject(i5), i5));
            }
        }
        if ((networkArray = JsonSupport.getJsonArray(jsonObject, "network")) != null) {
            for (int i6 = 0; i6 < networkArray.size(); ++i6) {
                builder.network(this.parseReference("network", networkArray.getJsonObject(i6), i6));
            }
        }
        if ((coverageArray = JsonSupport.getJsonArray(jsonObject, "coverage")) != null) {
            for (int i7 = 0; i7 < coverageArray.size(); ++i7) {
                builder.coverage(this.parseInsurancePlanCoverage("coverage", coverageArray.getJsonObject(i7), i7));
            }
        }
        if ((planArray = JsonSupport.getJsonArray(jsonObject, "plan")) != null) {
            for (int i8 = 0; i8 < planArray.size(); ++i8) {
                builder.plan(this.parseInsurancePlanPlan("plan", planArray.getJsonObject(i8), i8));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Contact parseInsurancePlanContact(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Contact.class, jsonObject);
        }
        InsurancePlan.Contact.Builder builder = InsurancePlan.Contact.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.purpose(this.parseCodeableConcept("purpose", JsonSupport.getJsonValue(jsonObject, "purpose", JsonObject.class), -1));
        builder.name(this.parseHumanName("name", JsonSupport.getJsonValue(jsonObject, "name", JsonObject.class), -1));
        JsonArray telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom");
        if (telecomArray != null) {
            for (int i = 0; i < telecomArray.size(); ++i) {
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i), i));
            }
        }
        builder.address(this.parseAddress("address", JsonSupport.getJsonValue(jsonObject, "address", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Coverage parseInsurancePlanCoverage(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray benefitArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Coverage.class, jsonObject);
        }
        InsurancePlan.Coverage.Builder builder = InsurancePlan.Coverage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray networkArray = JsonSupport.getJsonArray(jsonObject, "network");
        if (networkArray != null) {
            for (int i = 0; i < networkArray.size(); ++i) {
                builder.network(this.parseReference("network", networkArray.getJsonObject(i), i));
            }
        }
        if ((benefitArray = JsonSupport.getJsonArray(jsonObject, "benefit")) != null) {
            for (int i = 0; i < benefitArray.size(); ++i) {
                builder.benefit(this.parseInsurancePlanCoverageBenefit("benefit", benefitArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Coverage.Benefit parseInsurancePlanCoverageBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Coverage.Benefit.class, jsonObject);
        }
        InsurancePlan.Coverage.Benefit.Builder builder = InsurancePlan.Coverage.Benefit.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.requirement(this.parseString("requirement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "requirement", JsonString.class), (JsonValue)jsonObject.get((Object)"_requirement"), -1));
        JsonArray limitArray = JsonSupport.getJsonArray(jsonObject, "limit");
        if (limitArray != null) {
            for (int i = 0; i < limitArray.size(); ++i) {
                builder.limit(this.parseInsurancePlanCoverageBenefitLimit("limit", limitArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Coverage.Benefit.Limit parseInsurancePlanCoverageBenefitLimit(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Coverage.Benefit.Limit.class, jsonObject);
        }
        InsurancePlan.Coverage.Benefit.Limit.Builder builder = InsurancePlan.Coverage.Benefit.Limit.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.value(this.parseQuantity("value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Plan parseInsurancePlanPlan(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray specificCostArray;
        JsonArray generalCostArray;
        JsonArray networkArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Plan.class, jsonObject);
        }
        InsurancePlan.Plan.Builder builder = InsurancePlan.Plan.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray coverageAreaArray = JsonSupport.getJsonArray(jsonObject, "coverageArea");
        if (coverageAreaArray != null) {
            for (int i = 0; i < coverageAreaArray.size(); ++i) {
                builder.coverageArea(this.parseReference("coverageArea", coverageAreaArray.getJsonObject(i), i));
            }
        }
        if ((networkArray = JsonSupport.getJsonArray(jsonObject, "network")) != null) {
            for (int i = 0; i < networkArray.size(); ++i) {
                builder.network(this.parseReference("network", networkArray.getJsonObject(i), i));
            }
        }
        if ((generalCostArray = JsonSupport.getJsonArray(jsonObject, "generalCost")) != null) {
            for (int i = 0; i < generalCostArray.size(); ++i) {
                builder.generalCost(this.parseInsurancePlanPlanGeneralCost("generalCost", generalCostArray.getJsonObject(i), i));
            }
        }
        if ((specificCostArray = JsonSupport.getJsonArray(jsonObject, "specificCost")) != null) {
            for (int i = 0; i < specificCostArray.size(); ++i) {
                builder.specificCost(this.parseInsurancePlanPlanSpecificCost("specificCost", specificCostArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Plan.GeneralCost parseInsurancePlanPlanGeneralCost(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Plan.GeneralCost.class, jsonObject);
        }
        InsurancePlan.Plan.GeneralCost.Builder builder = InsurancePlan.Plan.GeneralCost.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.groupSize((PositiveInt)this.parseInteger(PositiveInt.builder(), "groupSize", (JsonValue)JsonSupport.getJsonValue(jsonObject, "groupSize", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_groupSize"), -1));
        builder.cost(this.parseMoney("cost", JsonSupport.getJsonValue(jsonObject, "cost", JsonObject.class), -1));
        builder.comment(this.parseString("comment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "comment", JsonString.class), (JsonValue)jsonObject.get((Object)"_comment"), -1));
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Plan.SpecificCost parseInsurancePlanPlanSpecificCost(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Plan.SpecificCost.class, jsonObject);
        }
        InsurancePlan.Plan.SpecificCost.Builder builder = InsurancePlan.Plan.SpecificCost.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        JsonArray benefitArray = JsonSupport.getJsonArray(jsonObject, "benefit");
        if (benefitArray != null) {
            for (int i = 0; i < benefitArray.size(); ++i) {
                builder.benefit(this.parseInsurancePlanPlanSpecificCostBenefit("benefit", benefitArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Plan.SpecificCost.Benefit parseInsurancePlanPlanSpecificCostBenefit(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Plan.SpecificCost.Benefit.class, jsonObject);
        }
        InsurancePlan.Plan.SpecificCost.Benefit.Builder builder = InsurancePlan.Plan.SpecificCost.Benefit.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray costArray = JsonSupport.getJsonArray(jsonObject, "cost");
        if (costArray != null) {
            for (int i = 0; i < costArray.size(); ++i) {
                builder.cost(this.parseInsurancePlanPlanSpecificCostBenefitCost("cost", costArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private InsurancePlan.Plan.SpecificCost.Benefit.Cost parseInsurancePlanPlanSpecificCostBenefitCost(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(InsurancePlan.Plan.SpecificCost.Benefit.Cost.class, jsonObject);
        }
        InsurancePlan.Plan.SpecificCost.Benefit.Cost.Builder builder = InsurancePlan.Plan.SpecificCost.Benefit.Cost.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.applicability(this.parseCodeableConcept("applicability", JsonSupport.getJsonValue(jsonObject, "applicability", JsonObject.class), -1));
        JsonArray qualifiersArray = JsonSupport.getJsonArray(jsonObject, "qualifiers");
        if (qualifiersArray != null) {
            for (int i = 0; i < qualifiersArray.size(); ++i) {
                builder.qualifiers(this.parseCodeableConcept("qualifiers", qualifiersArray.getJsonObject(i), i));
            }
        }
        builder.value(this.parseQuantity("value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Integer parseInteger(Integer.Builder builder, String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        if (jsonValue == null && _jsonValue == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (_jsonValue != null && _jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = (JsonObject)_jsonValue;
            if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
                JsonSupport.checkForUnrecognizedElements(Element.class, jsonObject);
            }
            this.parseElement(builder, jsonObject);
        } else if (_jsonValue != null && (_jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: OBJECT but found: " + _jsonValue.getValueType() + " for element: _" + elementName);
        }
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            builder.value(jsonNumber.intValueExact());
        } else if (jsonValue != null && (jsonValue.getValueType() != JsonValue.ValueType.NULL || elementIndex == -1)) {
            throw new IllegalArgumentException("Expected: NUMBER but found: " + jsonValue.getValueType() + " for element: " + elementName);
        }
        this.stackPop();
        return builder.build();
    }

    private Integer parseInteger(String elementName, JsonValue jsonValue, JsonValue _jsonValue, int elementIndex) {
        return this.parseInteger(Integer.builder(), elementName, jsonValue, _jsonValue, elementIndex);
    }

    private Invoice parseInvoice(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray totalPriceComponentArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Invoice.class, jsonObject);
        }
        Invoice.Builder builder = Invoice.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((InvoiceStatus)this.parseString(InvoiceStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.cancelledReason(this.parseString("cancelledReason", (JsonValue)JsonSupport.getJsonValue(jsonObject, "cancelledReason", JsonString.class), (JsonValue)jsonObject.get((Object)"_cancelledReason"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.recipient(this.parseReference("recipient", JsonSupport.getJsonValue(jsonObject, "recipient", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        JsonArray participantArray = JsonSupport.getJsonArray(jsonObject, "participant");
        if (participantArray != null) {
            for (int i = 0; i < participantArray.size(); ++i) {
                builder.participant(this.parseInvoiceParticipant("participant", participantArray.getJsonObject(i), i));
            }
        }
        builder.issuer(this.parseReference("issuer", JsonSupport.getJsonValue(jsonObject, "issuer", JsonObject.class), -1));
        builder.account(this.parseReference("account", JsonSupport.getJsonValue(jsonObject, "account", JsonObject.class), -1));
        JsonArray lineItemArray = JsonSupport.getJsonArray(jsonObject, "lineItem");
        if (lineItemArray != null) {
            for (int i = 0; i < lineItemArray.size(); ++i) {
                builder.lineItem(this.parseInvoiceLineItem("lineItem", lineItemArray.getJsonObject(i), i));
            }
        }
        if ((totalPriceComponentArray = JsonSupport.getJsonArray(jsonObject, "totalPriceComponent")) != null) {
            for (int i = 0; i < totalPriceComponentArray.size(); ++i) {
                builder.totalPriceComponent(this.parseInvoiceLineItemPriceComponent("totalPriceComponent", totalPriceComponentArray.getJsonObject(i), i));
            }
        }
        builder.totalNet(this.parseMoney("totalNet", JsonSupport.getJsonValue(jsonObject, "totalNet", JsonObject.class), -1));
        builder.totalGross(this.parseMoney("totalGross", JsonSupport.getJsonValue(jsonObject, "totalGross", JsonObject.class), -1));
        builder.paymentTerms((Markdown)this.parseString(Markdown.builder(), "paymentTerms", (JsonValue)JsonSupport.getJsonValue(jsonObject, "paymentTerms", JsonString.class), (JsonValue)jsonObject.get((Object)"_paymentTerms"), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Invoice.LineItem parseInvoiceLineItem(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Invoice.LineItem.class, jsonObject);
        }
        Invoice.LineItem.Builder builder = Invoice.LineItem.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.sequence((PositiveInt)this.parseInteger(PositiveInt.builder(), "sequence", (JsonValue)JsonSupport.getJsonValue(jsonObject, "sequence", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_sequence"), -1));
        builder.chargeItem(this.parseChoiceElement("chargeItem", jsonObject, Reference.class, CodeableConcept.class));
        JsonArray priceComponentArray = JsonSupport.getJsonArray(jsonObject, "priceComponent");
        if (priceComponentArray != null) {
            for (int i = 0; i < priceComponentArray.size(); ++i) {
                builder.priceComponent(this.parseInvoiceLineItemPriceComponent("priceComponent", priceComponentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Invoice.LineItem.PriceComponent parseInvoiceLineItemPriceComponent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Invoice.LineItem.PriceComponent.class, jsonObject);
        }
        Invoice.LineItem.PriceComponent.Builder builder = Invoice.LineItem.PriceComponent.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((InvoicePriceComponentType)this.parseString(InvoicePriceComponentType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.factor(this.parseDecimal("factor", (JsonValue)JsonSupport.getJsonValue(jsonObject, "factor", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_factor"), -1));
        builder.amount(this.parseMoney("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Invoice.Participant parseInvoiceParticipant(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Invoice.Participant.class, jsonObject);
        }
        Invoice.Participant.Builder builder = Invoice.Participant.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Library parseLibrary(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray contentArray;
        JsonArray dataRequirementArray;
        JsonArray parameterArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Library.class, jsonObject);
        }
        Library.Builder builder = Library.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i = 0; i < contactArray.size(); ++i) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i), i));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i = 0; i < useContextArray.size(); ++i) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i = 0; i < topicArray.size(); ++i) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i), i));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i = 0; i < authorArray.size(); ++i) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i), i));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i = 0; i < editorArray.size(); ++i) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i), i));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i = 0; i < reviewerArray.size(); ++i) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i), i));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i = 0; i < endorserArray.size(); ++i) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i), i));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i = 0; i < relatedArtifactArray.size(); ++i) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i), i));
            }
        }
        if ((parameterArray = JsonSupport.getJsonArray(jsonObject, "parameter")) != null) {
            for (int i = 0; i < parameterArray.size(); ++i) {
                builder.parameter(this.parseParameterDefinition("parameter", parameterArray.getJsonObject(i), i));
            }
        }
        if ((dataRequirementArray = JsonSupport.getJsonArray(jsonObject, "dataRequirement")) != null) {
            for (int i = 0; i < dataRequirementArray.size(); ++i) {
                builder.dataRequirement(this.parseDataRequirement("dataRequirement", dataRequirementArray.getJsonObject(i), i));
            }
        }
        if ((contentArray = JsonSupport.getJsonArray(jsonObject, "content")) != null) {
            for (int i = 0; i < contentArray.size(); ++i) {
                builder.content(this.parseAttachment("content", contentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Linkage parseLinkage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Linkage.class, jsonObject);
        }
        Linkage.Builder builder = Linkage.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.active(this.parseBoolean("active", JsonSupport.getJsonValue(jsonObject, "active", JsonValue.class), (JsonValue)jsonObject.get((Object)"_active"), -1));
        builder.author(this.parseReference("author", JsonSupport.getJsonValue(jsonObject, "author", JsonObject.class), -1));
        JsonArray itemArray = JsonSupport.getJsonArray(jsonObject, "item");
        if (itemArray != null) {
            for (int i = 0; i < itemArray.size(); ++i) {
                builder.item(this.parseLinkageItem("item", itemArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Linkage.Item parseLinkageItem(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Linkage.Item.class, jsonObject);
        }
        Linkage.Item.Builder builder = Linkage.Item.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type((LinkageType)this.parseString(LinkageType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.resource(this.parseReference("resource", JsonSupport.getJsonValue(jsonObject, "resource", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private List parseList(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray entryArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(List.class, jsonObject);
        }
        List.Builder builder = List.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((ListStatus)this.parseString(ListStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.mode((ListMode)this.parseString(ListMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        builder.orderedBy(this.parseCodeableConcept("orderedBy", JsonSupport.getJsonValue(jsonObject, "orderedBy", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((entryArray = JsonSupport.getJsonArray(jsonObject, "entry")) != null) {
            for (int i = 0; i < entryArray.size(); ++i) {
                builder.entry(this.parseListEntry("entry", entryArray.getJsonObject(i), i));
            }
        }
        builder.emptyReason(this.parseCodeableConcept("emptyReason", JsonSupport.getJsonValue(jsonObject, "emptyReason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private List.Entry parseListEntry(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(List.Entry.class, jsonObject);
        }
        List.Entry.Builder builder = List.Entry.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.flag(this.parseCodeableConcept("flag", JsonSupport.getJsonValue(jsonObject, "flag", JsonObject.class), -1));
        builder.deleted(this.parseBoolean("deleted", JsonSupport.getJsonValue(jsonObject, "deleted", JsonValue.class), (JsonValue)jsonObject.get((Object)"_deleted"), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.item(this.parseReference("item", JsonSupport.getJsonValue(jsonObject, "item", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Location parseLocation(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray telecomArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Location.class, jsonObject);
        }
        Location.Builder builder = Location.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((LocationStatus)this.parseString(LocationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.operationalStatus(this.parseCoding("operationalStatus", JsonSupport.getJsonValue(jsonObject, "operationalStatus", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        JsonArray aliasArray = JsonSupport.getJsonArray(jsonObject, "alias", true);
        if (aliasArray != null) {
            JsonArray _aliasArray = jsonObject.getJsonArray("_alias");
            for (i = 0; i < aliasArray.size(); ++i) {
                builder.alias(this.parseString("alias", (JsonValue)aliasArray.get(i), JsonSupport.getJsonValue(_aliasArray, i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.mode((LocationMode)this.parseString(LocationMode.builder(), "mode", (JsonValue)JsonSupport.getJsonValue(jsonObject, "mode", JsonString.class), (JsonValue)jsonObject.get((Object)"_mode"), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (i = 0; i < typeArray.size(); ++i) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i), i));
            }
        }
        if ((telecomArray = JsonSupport.getJsonArray(jsonObject, "telecom")) != null) {
            for (int i3 = 0; i3 < telecomArray.size(); ++i3) {
                builder.telecom(this.parseContactPoint("telecom", telecomArray.getJsonObject(i3), i3));
            }
        }
        builder.address(this.parseAddress("address", JsonSupport.getJsonValue(jsonObject, "address", JsonObject.class), -1));
        builder.physicalType(this.parseCodeableConcept("physicalType", JsonSupport.getJsonValue(jsonObject, "physicalType", JsonObject.class), -1));
        builder.position(this.parseLocationPosition("position", JsonSupport.getJsonValue(jsonObject, "position", JsonObject.class), -1));
        builder.managingOrganization(this.parseReference("managingOrganization", JsonSupport.getJsonValue(jsonObject, "managingOrganization", JsonObject.class), -1));
        builder.partOf(this.parseReference("partOf", JsonSupport.getJsonValue(jsonObject, "partOf", JsonObject.class), -1));
        JsonArray hoursOfOperationArray = JsonSupport.getJsonArray(jsonObject, "hoursOfOperation");
        if (hoursOfOperationArray != null) {
            for (int i4 = 0; i4 < hoursOfOperationArray.size(); ++i4) {
                builder.hoursOfOperation(this.parseLocationHoursOfOperation("hoursOfOperation", hoursOfOperationArray.getJsonObject(i4), i4));
            }
        }
        builder.availabilityExceptions(this.parseString("availabilityExceptions", (JsonValue)JsonSupport.getJsonValue(jsonObject, "availabilityExceptions", JsonString.class), (JsonValue)jsonObject.get((Object)"_availabilityExceptions"), -1));
        JsonArray endpointArray = JsonSupport.getJsonArray(jsonObject, "endpoint");
        if (endpointArray != null) {
            for (int i5 = 0; i5 < endpointArray.size(); ++i5) {
                builder.endpoint(this.parseReference("endpoint", endpointArray.getJsonObject(i5), i5));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Location.HoursOfOperation parseLocationHoursOfOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Location.HoursOfOperation.class, jsonObject);
        }
        Location.HoursOfOperation.Builder builder = Location.HoursOfOperation.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray daysOfWeekArray = JsonSupport.getJsonArray(jsonObject, "daysOfWeek", true);
        if (daysOfWeekArray != null) {
            JsonArray _daysOfWeekArray = jsonObject.getJsonArray("_daysOfWeek");
            for (int i = 0; i < daysOfWeekArray.size(); ++i) {
                builder.daysOfWeek((DaysOfWeek)this.parseString(DaysOfWeek.builder(), "daysOfWeek", (JsonValue)daysOfWeekArray.get(i), JsonSupport.getJsonValue(_daysOfWeekArray, i), i));
            }
        }
        builder.allDay(this.parseBoolean("allDay", JsonSupport.getJsonValue(jsonObject, "allDay", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allDay"), -1));
        builder.openingTime(this.parseTime("openingTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "openingTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_openingTime"), -1));
        builder.closingTime(this.parseTime("closingTime", (JsonValue)JsonSupport.getJsonValue(jsonObject, "closingTime", JsonString.class), (JsonValue)jsonObject.get((Object)"_closingTime"), -1));
        this.stackPop();
        return builder.build();
    }

    private Location.Position parseLocationPosition(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Location.Position.class, jsonObject);
        }
        Location.Position.Builder builder = Location.Position.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.longitude(this.parseDecimal("longitude", (JsonValue)JsonSupport.getJsonValue(jsonObject, "longitude", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_longitude"), -1));
        builder.latitude(this.parseDecimal("latitude", (JsonValue)JsonSupport.getJsonValue(jsonObject, "latitude", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_latitude"), -1));
        builder.altitude(this.parseDecimal("altitude", (JsonValue)JsonSupport.getJsonValue(jsonObject, "altitude", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_altitude"), -1));
        this.stackPop();
        return builder.build();
    }

    private MarketingStatus parseMarketingStatus(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MarketingStatus.class, jsonObject);
        }
        MarketingStatus.Builder builder = MarketingStatus.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.country(this.parseCodeableConcept("country", JsonSupport.getJsonValue(jsonObject, "country", JsonObject.class), -1));
        builder.jurisdiction(this.parseCodeableConcept("jurisdiction", JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonObject.class), -1));
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.dateRange(this.parsePeriod("dateRange", JsonSupport.getJsonValue(jsonObject, "dateRange", JsonObject.class), -1));
        builder.restoreDate(this.parseDateTime("restoreDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "restoreDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_restoreDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private Measure parseMeasure(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray supplementalDataArray;
        int i;
        int i2;
        JsonArray libraryArray;
        JsonArray relatedArtifactArray;
        JsonArray endorserArray;
        JsonArray reviewerArray;
        JsonArray editorArray;
        JsonArray authorArray;
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.class, jsonObject);
        }
        Measure.Builder builder = Measure.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.url(this.parseUri("url", (JsonValue)JsonSupport.getJsonValue(jsonObject, "url", JsonString.class), (JsonValue)jsonObject.get((Object)"_url"), -1));
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i3 = 0; i3 < identifierArray.size(); ++i3) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i3), i3));
            }
        }
        builder.version(this.parseString("version", (JsonValue)JsonSupport.getJsonValue(jsonObject, "version", JsonString.class), (JsonValue)jsonObject.get((Object)"_version"), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        builder.title(this.parseString("title", (JsonValue)JsonSupport.getJsonValue(jsonObject, "title", JsonString.class), (JsonValue)jsonObject.get((Object)"_title"), -1));
        builder.subtitle(this.parseString("subtitle", (JsonValue)JsonSupport.getJsonValue(jsonObject, "subtitle", JsonString.class), (JsonValue)jsonObject.get((Object)"_subtitle"), -1));
        builder.status((PublicationStatus)this.parseString(PublicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.experimental(this.parseBoolean("experimental", JsonSupport.getJsonValue(jsonObject, "experimental", JsonValue.class), (JsonValue)jsonObject.get((Object)"_experimental"), -1));
        builder.subject(this.parseChoiceElement("subject", jsonObject, CodeableConcept.class, Reference.class));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.publisher(this.parseString("publisher", (JsonValue)JsonSupport.getJsonValue(jsonObject, "publisher", JsonString.class), (JsonValue)jsonObject.get((Object)"_publisher"), -1));
        JsonArray contactArray = JsonSupport.getJsonArray(jsonObject, "contact");
        if (contactArray != null) {
            for (int i4 = 0; i4 < contactArray.size(); ++i4) {
                builder.contact(this.parseContactDetail("contact", contactArray.getJsonObject(i4), i4));
            }
        }
        builder.description((Markdown)this.parseString(Markdown.builder(), "description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray useContextArray = JsonSupport.getJsonArray(jsonObject, "useContext");
        if (useContextArray != null) {
            for (int i5 = 0; i5 < useContextArray.size(); ++i5) {
                builder.useContext(this.parseUsageContext("useContext", useContextArray.getJsonObject(i5), i5));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i6 = 0; i6 < jurisdictionArray.size(); ++i6) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i6), i6));
            }
        }
        builder.purpose((Markdown)this.parseString(Markdown.builder(), "purpose", (JsonValue)JsonSupport.getJsonValue(jsonObject, "purpose", JsonString.class), (JsonValue)jsonObject.get((Object)"_purpose"), -1));
        builder.usage(this.parseString("usage", (JsonValue)JsonSupport.getJsonValue(jsonObject, "usage", JsonString.class), (JsonValue)jsonObject.get((Object)"_usage"), -1));
        builder.copyright((Markdown)this.parseString(Markdown.builder(), "copyright", (JsonValue)JsonSupport.getJsonValue(jsonObject, "copyright", JsonString.class), (JsonValue)jsonObject.get((Object)"_copyright"), -1));
        builder.approvalDate(this.parseDate("approvalDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "approvalDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_approvalDate"), -1));
        builder.lastReviewDate(this.parseDate("lastReviewDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lastReviewDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_lastReviewDate"), -1));
        builder.effectivePeriod(this.parsePeriod("effectivePeriod", JsonSupport.getJsonValue(jsonObject, "effectivePeriod", JsonObject.class), -1));
        JsonArray topicArray = JsonSupport.getJsonArray(jsonObject, "topic");
        if (topicArray != null) {
            for (int i7 = 0; i7 < topicArray.size(); ++i7) {
                builder.topic(this.parseCodeableConcept("topic", topicArray.getJsonObject(i7), i7));
            }
        }
        if ((authorArray = JsonSupport.getJsonArray(jsonObject, "author")) != null) {
            for (int i8 = 0; i8 < authorArray.size(); ++i8) {
                builder.author(this.parseContactDetail("author", authorArray.getJsonObject(i8), i8));
            }
        }
        if ((editorArray = JsonSupport.getJsonArray(jsonObject, "editor")) != null) {
            for (int i9 = 0; i9 < editorArray.size(); ++i9) {
                builder.editor(this.parseContactDetail("editor", editorArray.getJsonObject(i9), i9));
            }
        }
        if ((reviewerArray = JsonSupport.getJsonArray(jsonObject, "reviewer")) != null) {
            for (int i10 = 0; i10 < reviewerArray.size(); ++i10) {
                builder.reviewer(this.parseContactDetail("reviewer", reviewerArray.getJsonObject(i10), i10));
            }
        }
        if ((endorserArray = JsonSupport.getJsonArray(jsonObject, "endorser")) != null) {
            for (int i11 = 0; i11 < endorserArray.size(); ++i11) {
                builder.endorser(this.parseContactDetail("endorser", endorserArray.getJsonObject(i11), i11));
            }
        }
        if ((relatedArtifactArray = JsonSupport.getJsonArray(jsonObject, "relatedArtifact")) != null) {
            for (int i12 = 0; i12 < relatedArtifactArray.size(); ++i12) {
                builder.relatedArtifact(this.parseRelatedArtifact("relatedArtifact", relatedArtifactArray.getJsonObject(i12), i12));
            }
        }
        if ((libraryArray = JsonSupport.getJsonArray(jsonObject, "library", true)) != null) {
            JsonArray _libraryArray = jsonObject.getJsonArray("_library");
            for (i2 = 0; i2 < libraryArray.size(); ++i2) {
                builder.library((Canonical)this.parseUri(Canonical.builder(), "library", (JsonValue)libraryArray.get(i2), JsonSupport.getJsonValue(_libraryArray, i2), i2));
            }
        }
        builder.disclaimer((Markdown)this.parseString(Markdown.builder(), "disclaimer", (JsonValue)JsonSupport.getJsonValue(jsonObject, "disclaimer", JsonString.class), (JsonValue)jsonObject.get((Object)"_disclaimer"), -1));
        builder.scoring(this.parseCodeableConcept("scoring", JsonSupport.getJsonValue(jsonObject, "scoring", JsonObject.class), -1));
        builder.compositeScoring(this.parseCodeableConcept("compositeScoring", JsonSupport.getJsonValue(jsonObject, "compositeScoring", JsonObject.class), -1));
        JsonArray typeArray = JsonSupport.getJsonArray(jsonObject, "type");
        if (typeArray != null) {
            for (i2 = 0; i2 < typeArray.size(); ++i2) {
                builder.type(this.parseCodeableConcept("type", typeArray.getJsonObject(i2), i2));
            }
        }
        builder.riskAdjustment(this.parseString("riskAdjustment", (JsonValue)JsonSupport.getJsonValue(jsonObject, "riskAdjustment", JsonString.class), (JsonValue)jsonObject.get((Object)"_riskAdjustment"), -1));
        builder.rateAggregation(this.parseString("rateAggregation", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rateAggregation", JsonString.class), (JsonValue)jsonObject.get((Object)"_rateAggregation"), -1));
        builder.rationale((Markdown)this.parseString(Markdown.builder(), "rationale", (JsonValue)JsonSupport.getJsonValue(jsonObject, "rationale", JsonString.class), (JsonValue)jsonObject.get((Object)"_rationale"), -1));
        builder.clinicalRecommendationStatement((Markdown)this.parseString(Markdown.builder(), "clinicalRecommendationStatement", (JsonValue)JsonSupport.getJsonValue(jsonObject, "clinicalRecommendationStatement", JsonString.class), (JsonValue)jsonObject.get((Object)"_clinicalRecommendationStatement"), -1));
        builder.improvementNotation(this.parseCodeableConcept("improvementNotation", JsonSupport.getJsonValue(jsonObject, "improvementNotation", JsonObject.class), -1));
        JsonArray definitionArray = JsonSupport.getJsonArray(jsonObject, "definition", true);
        if (definitionArray != null) {
            JsonArray _definitionArray = jsonObject.getJsonArray("_definition");
            for (i = 0; i < definitionArray.size(); ++i) {
                builder.definition((Markdown)this.parseString(Markdown.builder(), "definition", (JsonValue)definitionArray.get(i), JsonSupport.getJsonValue(_definitionArray, i), i));
            }
        }
        builder.guidance((Markdown)this.parseString(Markdown.builder(), "guidance", (JsonValue)JsonSupport.getJsonValue(jsonObject, "guidance", JsonString.class), (JsonValue)jsonObject.get((Object)"_guidance"), -1));
        JsonArray groupArray = JsonSupport.getJsonArray(jsonObject, "group");
        if (groupArray != null) {
            for (i = 0; i < groupArray.size(); ++i) {
                builder.group(this.parseMeasureGroup("group", groupArray.getJsonObject(i), i));
            }
        }
        if ((supplementalDataArray = JsonSupport.getJsonArray(jsonObject, "supplementalData")) != null) {
            for (int i13 = 0; i13 < supplementalDataArray.size(); ++i13) {
                builder.supplementalData(this.parseMeasureSupplementalData("supplementalData", supplementalDataArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Measure.Group parseMeasureGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray stratifierArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.Group.class, jsonObject);
        }
        Measure.Group.Builder builder = Measure.Group.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        JsonArray populationArray = JsonSupport.getJsonArray(jsonObject, "population");
        if (populationArray != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                builder.population(this.parseMeasureGroupPopulation("population", populationArray.getJsonObject(i), i));
            }
        }
        if ((stratifierArray = JsonSupport.getJsonArray(jsonObject, "stratifier")) != null) {
            for (int i = 0; i < stratifierArray.size(); ++i) {
                builder.stratifier(this.parseMeasureGroupStratifier("stratifier", stratifierArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Measure.Group.Population parseMeasureGroupPopulation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.Group.Population.class, jsonObject);
        }
        Measure.Group.Population.Builder builder = Measure.Group.Population.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.criteria(this.parseExpression("criteria", JsonSupport.getJsonValue(jsonObject, "criteria", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Measure.Group.Stratifier parseMeasureGroupStratifier(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.Group.Stratifier.class, jsonObject);
        }
        Measure.Group.Stratifier.Builder builder = Measure.Group.Stratifier.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.criteria(this.parseExpression("criteria", JsonSupport.getJsonValue(jsonObject, "criteria", JsonObject.class), -1));
        JsonArray componentArray = JsonSupport.getJsonArray(jsonObject, "component");
        if (componentArray != null) {
            for (int i = 0; i < componentArray.size(); ++i) {
                builder.component(this.parseMeasureGroupStratifierComponent("component", componentArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Measure.Group.Stratifier.Component parseMeasureGroupStratifierComponent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.Group.Stratifier.Component.class, jsonObject);
        }
        Measure.Group.Stratifier.Component.Builder builder = Measure.Group.Stratifier.Component.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.criteria(this.parseExpression("criteria", JsonSupport.getJsonValue(jsonObject, "criteria", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Measure.SupplementalData parseMeasureSupplementalData(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Measure.SupplementalData.class, jsonObject);
        }
        Measure.SupplementalData.Builder builder = Measure.SupplementalData.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray usageArray = JsonSupport.getJsonArray(jsonObject, "usage");
        if (usageArray != null) {
            for (int i = 0; i < usageArray.size(); ++i) {
                builder.usage(this.parseCodeableConcept("usage", usageArray.getJsonObject(i), i));
            }
        }
        builder.description(this.parseString("description", (JsonValue)JsonSupport.getJsonValue(jsonObject, "description", JsonString.class), (JsonValue)jsonObject.get((Object)"_description"), -1));
        builder.criteria(this.parseExpression("criteria", JsonSupport.getJsonValue(jsonObject, "criteria", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MeasureReport parseMeasureReport(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray evaluatedResourceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.class, jsonObject);
        }
        MeasureReport.Builder builder = MeasureReport.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.status((MeasureReportStatus)this.parseString(MeasureReportStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type((MeasureReportType)this.parseString(MeasureReportType.builder(), "type", (JsonValue)JsonSupport.getJsonValue(jsonObject, "type", JsonString.class), (JsonValue)jsonObject.get((Object)"_type"), -1));
        builder.measure((Canonical)this.parseUri(Canonical.builder(), "measure", (JsonValue)JsonSupport.getJsonValue(jsonObject, "measure", JsonString.class), (JsonValue)jsonObject.get((Object)"_measure"), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.reporter(this.parseReference("reporter", JsonSupport.getJsonValue(jsonObject, "reporter", JsonObject.class), -1));
        builder.period(this.parsePeriod("period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        builder.improvementNotation(this.parseCodeableConcept("improvementNotation", JsonSupport.getJsonValue(jsonObject, "improvementNotation", JsonObject.class), -1));
        JsonArray groupArray = JsonSupport.getJsonArray(jsonObject, "group");
        if (groupArray != null) {
            for (int i = 0; i < groupArray.size(); ++i) {
                builder.group(this.parseMeasureReportGroup("group", groupArray.getJsonObject(i), i));
            }
        }
        if ((evaluatedResourceArray = JsonSupport.getJsonArray(jsonObject, "evaluatedResource")) != null) {
            for (int i = 0; i < evaluatedResourceArray.size(); ++i) {
                builder.evaluatedResource(this.parseReference("evaluatedResource", evaluatedResourceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group parseMeasureReportGroup(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.class, jsonObject);
        }
        MeasureReport.Group.Builder builder = MeasureReport.Group.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        JsonArray populationArray = JsonSupport.getJsonArray(jsonObject, "population");
        if (populationArray != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                builder.population(this.parseMeasureReportGroupPopulation("population", populationArray.getJsonObject(i), i));
            }
        }
        builder.measureScore(this.parseQuantity("measureScore", JsonSupport.getJsonValue(jsonObject, "measureScore", JsonObject.class), -1));
        JsonArray stratifierArray = JsonSupport.getJsonArray(jsonObject, "stratifier");
        if (stratifierArray != null) {
            for (int i = 0; i < stratifierArray.size(); ++i) {
                builder.stratifier(this.parseMeasureReportGroupStratifier("stratifier", stratifierArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group.Population parseMeasureReportGroupPopulation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.Population.class, jsonObject);
        }
        MeasureReport.Group.Population.Builder builder = MeasureReport.Group.Population.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.count(this.parseInteger("count", (JsonValue)JsonSupport.getJsonValue(jsonObject, "count", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_count"), -1));
        builder.subjectResults(this.parseReference("subjectResults", JsonSupport.getJsonValue(jsonObject, "subjectResults", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group.Stratifier parseMeasureReportGroupStratifier(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray stratumArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.Stratifier.class, jsonObject);
        }
        MeasureReport.Group.Stratifier.Builder builder = MeasureReport.Group.Stratifier.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray codeArray = JsonSupport.getJsonArray(jsonObject, "code");
        if (codeArray != null) {
            for (int i = 0; i < codeArray.size(); ++i) {
                builder.code(this.parseCodeableConcept("code", codeArray.getJsonObject(i), i));
            }
        }
        if ((stratumArray = JsonSupport.getJsonArray(jsonObject, "stratum")) != null) {
            for (int i = 0; i < stratumArray.size(); ++i) {
                builder.stratum(this.parseMeasureReportGroupStratifierStratum("stratum", stratumArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group.Stratifier.Stratum parseMeasureReportGroupStratifierStratum(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray populationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.Stratifier.Stratum.class, jsonObject);
        }
        MeasureReport.Group.Stratifier.Stratum.Builder builder = MeasureReport.Group.Stratifier.Stratum.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.value(this.parseCodeableConcept("value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        JsonArray componentArray = JsonSupport.getJsonArray(jsonObject, "component");
        if (componentArray != null) {
            for (int i = 0; i < componentArray.size(); ++i) {
                builder.component(this.parseMeasureReportGroupStratifierStratumComponent("component", componentArray.getJsonObject(i), i));
            }
        }
        if ((populationArray = JsonSupport.getJsonArray(jsonObject, "population")) != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                builder.population(this.parseMeasureReportGroupStratifierStratumPopulation("population", populationArray.getJsonObject(i), i));
            }
        }
        builder.measureScore(this.parseQuantity("measureScore", JsonSupport.getJsonValue(jsonObject, "measureScore", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group.Stratifier.Stratum.Component parseMeasureReportGroupStratifierStratumComponent(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.Stratifier.Stratum.Component.class, jsonObject);
        }
        MeasureReport.Group.Stratifier.Stratum.Component.Builder builder = MeasureReport.Group.Stratifier.Stratum.Component.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.value(this.parseCodeableConcept("value", JsonSupport.getJsonValue(jsonObject, "value", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MeasureReport.Group.Stratifier.Stratum.Population parseMeasureReportGroupStratifierStratumPopulation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MeasureReport.Group.Stratifier.Stratum.Population.class, jsonObject);
        }
        MeasureReport.Group.Stratifier.Stratum.Population.Builder builder = MeasureReport.Group.Stratifier.Stratum.Population.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.count(this.parseInteger("count", (JsonValue)JsonSupport.getJsonValue(jsonObject, "count", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_count"), -1));
        builder.subjectResults(this.parseReference("subjectResults", JsonSupport.getJsonValue(jsonObject, "subjectResults", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Media parseMedia(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray partOfArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Media.class, jsonObject);
        }
        Media.Builder builder = Media.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i = 0; i < partOfArray.size(); ++i) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.status((MediaStatus)this.parseString(MediaStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.modality(this.parseCodeableConcept("modality", JsonSupport.getJsonValue(jsonObject, "modality", JsonObject.class), -1));
        builder.view(this.parseCodeableConcept("view", JsonSupport.getJsonValue(jsonObject, "view", JsonObject.class), -1));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        builder.created(this.parseChoiceElement("created", jsonObject, DateTime.class, Period.class));
        builder.issued(this.parseInstant("issued", (JsonValue)JsonSupport.getJsonValue(jsonObject, "issued", JsonString.class), (JsonValue)jsonObject.get((Object)"_issued"), -1));
        builder.operator(this.parseReference("operator", JsonSupport.getJsonValue(jsonObject, "operator", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        builder.bodySite(this.parseCodeableConcept("bodySite", JsonSupport.getJsonValue(jsonObject, "bodySite", JsonObject.class), -1));
        builder.deviceName(this.parseString("deviceName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "deviceName", JsonString.class), (JsonValue)jsonObject.get((Object)"_deviceName"), -1));
        builder.device(this.parseReference("device", JsonSupport.getJsonValue(jsonObject, "device", JsonObject.class), -1));
        builder.height((PositiveInt)this.parseInteger(PositiveInt.builder(), "height", (JsonValue)JsonSupport.getJsonValue(jsonObject, "height", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_height"), -1));
        builder.width((PositiveInt)this.parseInteger(PositiveInt.builder(), "width", (JsonValue)JsonSupport.getJsonValue(jsonObject, "width", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_width"), -1));
        builder.frames((PositiveInt)this.parseInteger(PositiveInt.builder(), "frames", (JsonValue)JsonSupport.getJsonValue(jsonObject, "frames", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_frames"), -1));
        builder.duration(this.parseDecimal("duration", (JsonValue)JsonSupport.getJsonValue(jsonObject, "duration", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_duration"), -1));
        builder.content(this.parseAttachment("content", JsonSupport.getJsonValue(jsonObject, "content", JsonObject.class), -1));
        JsonArray noteArray = JsonSupport.getJsonArray(jsonObject, "note");
        if (noteArray != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private Medication parseMedication(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Medication.class, jsonObject);
        }
        Medication.Builder builder = Medication.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.status((MedicationStatus)this.parseString(MedicationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.manufacturer(this.parseReference("manufacturer", JsonSupport.getJsonValue(jsonObject, "manufacturer", JsonObject.class), -1));
        builder.form(this.parseCodeableConcept("form", JsonSupport.getJsonValue(jsonObject, "form", JsonObject.class), -1));
        builder.amount(this.parseRatio("amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        JsonArray ingredientArray = JsonSupport.getJsonArray(jsonObject, "ingredient");
        if (ingredientArray != null) {
            for (int i = 0; i < ingredientArray.size(); ++i) {
                builder.ingredient(this.parseMedicationIngredient("ingredient", ingredientArray.getJsonObject(i), i));
            }
        }
        builder.batch(this.parseMedicationBatch("batch", JsonSupport.getJsonValue(jsonObject, "batch", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private Medication.Batch parseMedicationBatch(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Medication.Batch.class, jsonObject);
        }
        Medication.Batch.Builder builder = Medication.Batch.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.lotNumber(this.parseString("lotNumber", (JsonValue)JsonSupport.getJsonValue(jsonObject, "lotNumber", JsonString.class), (JsonValue)jsonObject.get((Object)"_lotNumber"), -1));
        builder.expirationDate(this.parseDateTime("expirationDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "expirationDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_expirationDate"), -1));
        this.stackPop();
        return builder.build();
    }

    private Medication.Ingredient parseMedicationIngredient(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(Medication.Ingredient.class, jsonObject);
        }
        Medication.Ingredient.Builder builder = Medication.Ingredient.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.item(this.parseChoiceElement("item", jsonObject, CodeableConcept.class, Reference.class));
        builder.isActive(this.parseBoolean("isActive", JsonSupport.getJsonValue(jsonObject, "isActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isActive"), -1));
        builder.strength(this.parseRatio("strength", JsonSupport.getJsonValue(jsonObject, "strength", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationAdministration parseMedicationAdministration(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        JsonArray partOfArray;
        int i;
        JsonArray instantiatesArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationAdministration.class, jsonObject);
        }
        MedicationAdministration.Builder builder = MedicationAdministration.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        if ((instantiatesArray = JsonSupport.getJsonArray(jsonObject, "instantiates", true)) != null) {
            JsonArray _instantiatesArray = jsonObject.getJsonArray("_instantiates");
            for (i = 0; i < instantiatesArray.size(); ++i) {
                builder.instantiates(this.parseUri("instantiates", (JsonValue)instantiatesArray.get(i), JsonSupport.getJsonValue(_instantiatesArray, i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (i = 0; i < partOfArray.size(); ++i) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.status((MedicationAdministrationStatus)this.parseString(MedicationAdministrationStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusReasonArray = JsonSupport.getJsonArray(jsonObject, "statusReason");
        if (statusReasonArray != null) {
            for (int i3 = 0; i3 < statusReasonArray.size(); ++i3) {
                builder.statusReason(this.parseCodeableConcept("statusReason", statusReasonArray.getJsonObject(i3), i3));
            }
        }
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        JsonArray supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation");
        if (supportingInformationArray != null) {
            for (int i4 = 0; i4 < supportingInformationArray.size(); ++i4) {
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i4), i4));
            }
        }
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        JsonArray performerArray = JsonSupport.getJsonArray(jsonObject, "performer");
        if (performerArray != null) {
            for (int i5 = 0; i5 < performerArray.size(); ++i5) {
                builder.performer(this.parseMedicationAdministrationPerformer("performer", performerArray.getJsonObject(i5), i5));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (int i6 = 0; i6 < reasonCodeArray.size(); ++i6) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i6), i6));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i7 = 0; i7 < reasonReferenceArray.size(); ++i7) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i7), i7));
            }
        }
        builder.request(this.parseReference("request", JsonSupport.getJsonValue(jsonObject, "request", JsonObject.class), -1));
        JsonArray deviceArray = JsonSupport.getJsonArray(jsonObject, "device");
        if (deviceArray != null) {
            for (int i8 = 0; i8 < deviceArray.size(); ++i8) {
                builder.device(this.parseReference("device", deviceArray.getJsonObject(i8), i8));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i9 = 0; i9 < noteArray.size(); ++i9) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i9), i9));
            }
        }
        builder.dosage(this.parseMedicationAdministrationDosage("dosage", JsonSupport.getJsonValue(jsonObject, "dosage", JsonObject.class), -1));
        JsonArray eventHistoryArray = JsonSupport.getJsonArray(jsonObject, "eventHistory");
        if (eventHistoryArray != null) {
            for (int i10 = 0; i10 < eventHistoryArray.size(); ++i10) {
                builder.eventHistory(this.parseReference("eventHistory", eventHistoryArray.getJsonObject(i10), i10));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationAdministration.Dosage parseMedicationAdministrationDosage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationAdministration.Dosage.class, jsonObject);
        }
        MedicationAdministration.Dosage.Builder builder = MedicationAdministration.Dosage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.text(this.parseString("text", (JsonValue)JsonSupport.getJsonValue(jsonObject, "text", JsonString.class), (JsonValue)jsonObject.get((Object)"_text"), -1));
        builder.site(this.parseCodeableConcept("site", JsonSupport.getJsonValue(jsonObject, "site", JsonObject.class), -1));
        builder.route(this.parseCodeableConcept("route", JsonSupport.getJsonValue(jsonObject, "route", JsonObject.class), -1));
        builder.method(this.parseCodeableConcept("method", JsonSupport.getJsonValue(jsonObject, "method", JsonObject.class), -1));
        builder.dose((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "dose", JsonSupport.getJsonValue(jsonObject, "dose", JsonObject.class), -1));
        builder.rate(this.parseChoiceElement("rate", jsonObject, Ratio.class, SimpleQuantity.class));
        this.stackPop();
        return builder.build();
    }

    private MedicationAdministration.Performer parseMedicationAdministrationPerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationAdministration.Performer.class, jsonObject);
        }
        MedicationAdministration.Performer.Builder builder = MedicationAdministration.Performer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationDispense parseMedicationDispense(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray eventHistoryArray;
        JsonArray dosageInstructionArray;
        JsonArray noteArray;
        JsonArray performerArray;
        JsonArray partOfArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationDispense.class, jsonObject);
        }
        MedicationDispense.Builder builder = MedicationDispense.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i = 0; i < partOfArray.size(); ++i) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.status((MedicationDispenseStatus)this.parseString(MedicationDispenseStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseChoiceElement("statusReason", jsonObject, CodeableConcept.class, Reference.class));
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        JsonArray supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation");
        if (supportingInformationArray != null) {
            for (int i = 0; i < supportingInformationArray.size(); ++i) {
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i), i));
            }
        }
        if ((performerArray = JsonSupport.getJsonArray(jsonObject, "performer")) != null) {
            for (int i = 0; i < performerArray.size(); ++i) {
                builder.performer(this.parseMedicationDispensePerformer("performer", performerArray.getJsonObject(i), i));
            }
        }
        builder.location(this.parseReference("location", JsonSupport.getJsonValue(jsonObject, "location", JsonObject.class), -1));
        JsonArray authorizingPrescriptionArray = JsonSupport.getJsonArray(jsonObject, "authorizingPrescription");
        if (authorizingPrescriptionArray != null) {
            for (int i = 0; i < authorizingPrescriptionArray.size(); ++i) {
                builder.authorizingPrescription(this.parseReference("authorizingPrescription", authorizingPrescriptionArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.daysSupply((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "daysSupply", JsonSupport.getJsonValue(jsonObject, "daysSupply", JsonObject.class), -1));
        builder.whenPrepared(this.parseDateTime("whenPrepared", (JsonValue)JsonSupport.getJsonValue(jsonObject, "whenPrepared", JsonString.class), (JsonValue)jsonObject.get((Object)"_whenPrepared"), -1));
        builder.whenHandedOver(this.parseDateTime("whenHandedOver", (JsonValue)JsonSupport.getJsonValue(jsonObject, "whenHandedOver", JsonString.class), (JsonValue)jsonObject.get((Object)"_whenHandedOver"), -1));
        builder.destination(this.parseReference("destination", JsonSupport.getJsonValue(jsonObject, "destination", JsonObject.class), -1));
        JsonArray receiverArray = JsonSupport.getJsonArray(jsonObject, "receiver");
        if (receiverArray != null) {
            for (int i = 0; i < receiverArray.size(); ++i) {
                builder.receiver(this.parseReference("receiver", receiverArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((dosageInstructionArray = JsonSupport.getJsonArray(jsonObject, "dosageInstruction")) != null) {
            for (int i = 0; i < dosageInstructionArray.size(); ++i) {
                builder.dosageInstruction(this.parseDosage("dosageInstruction", dosageInstructionArray.getJsonObject(i), i));
            }
        }
        builder.substitution(this.parseMedicationDispenseSubstitution("substitution", JsonSupport.getJsonValue(jsonObject, "substitution", JsonObject.class), -1));
        JsonArray detectedIssueArray = JsonSupport.getJsonArray(jsonObject, "detectedIssue");
        if (detectedIssueArray != null) {
            for (int i = 0; i < detectedIssueArray.size(); ++i) {
                builder.detectedIssue(this.parseReference("detectedIssue", detectedIssueArray.getJsonObject(i), i));
            }
        }
        if ((eventHistoryArray = JsonSupport.getJsonArray(jsonObject, "eventHistory")) != null) {
            for (int i = 0; i < eventHistoryArray.size(); ++i) {
                builder.eventHistory(this.parseReference("eventHistory", eventHistoryArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationDispense.Performer parseMedicationDispensePerformer(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationDispense.Performer.class, jsonObject);
        }
        MedicationDispense.Performer.Builder builder = MedicationDispense.Performer.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.function(this.parseCodeableConcept("function", JsonSupport.getJsonValue(jsonObject, "function", JsonObject.class), -1));
        builder.actor(this.parseReference("actor", JsonSupport.getJsonValue(jsonObject, "actor", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationDispense.Substitution parseMedicationDispenseSubstitution(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray responsiblePartyArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationDispense.Substitution.class, jsonObject);
        }
        MedicationDispense.Substitution.Builder builder = MedicationDispense.Substitution.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.wasSubstituted(this.parseBoolean("wasSubstituted", JsonSupport.getJsonValue(jsonObject, "wasSubstituted", JsonValue.class), (JsonValue)jsonObject.get((Object)"_wasSubstituted"), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray reasonArray = JsonSupport.getJsonArray(jsonObject, "reason");
        if (reasonArray != null) {
            for (int i = 0; i < reasonArray.size(); ++i) {
                builder.reason(this.parseCodeableConcept("reason", reasonArray.getJsonObject(i), i));
            }
        }
        if ((responsiblePartyArray = JsonSupport.getJsonArray(jsonObject, "responsibleParty")) != null) {
            for (int i = 0; i < responsiblePartyArray.size(); ++i) {
                builder.responsibleParty(this.parseReference("responsibleParty", responsiblePartyArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge parseMedicationKnowledge(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray kineticsArray;
        JsonArray regulatoryArray;
        JsonArray contraindicationArray;
        JsonArray medicineClassificationArray;
        JsonArray administrationGuidelinesArray;
        JsonArray monitoringProgramArray;
        JsonArray costArray;
        JsonArray ingredientArray;
        JsonArray monographArray;
        JsonArray productTypeArray;
        JsonArray associatedMedicationArray;
        JsonArray relatedMedicationKnowledgeArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.class, jsonObject);
        }
        MedicationKnowledge.Builder builder = MedicationKnowledge.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.code(this.parseCodeableConcept("code", JsonSupport.getJsonValue(jsonObject, "code", JsonObject.class), -1));
        builder.status((MedicationKnowledgeStatus)this.parseString(MedicationKnowledgeStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.manufacturer(this.parseReference("manufacturer", JsonSupport.getJsonValue(jsonObject, "manufacturer", JsonObject.class), -1));
        builder.doseForm(this.parseCodeableConcept("doseForm", JsonSupport.getJsonValue(jsonObject, "doseForm", JsonObject.class), -1));
        builder.amount((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "amount", JsonSupport.getJsonValue(jsonObject, "amount", JsonObject.class), -1));
        JsonArray synonymArray = JsonSupport.getJsonArray(jsonObject, "synonym", true);
        if (synonymArray != null) {
            JsonArray _synonymArray = jsonObject.getJsonArray("_synonym");
            for (i = 0; i < synonymArray.size(); ++i) {
                builder.synonym(this.parseString("synonym", (JsonValue)synonymArray.get(i), JsonSupport.getJsonValue(_synonymArray, i), i));
            }
        }
        if ((relatedMedicationKnowledgeArray = JsonSupport.getJsonArray(jsonObject, "relatedMedicationKnowledge")) != null) {
            for (i = 0; i < relatedMedicationKnowledgeArray.size(); ++i) {
                builder.relatedMedicationKnowledge(this.parseMedicationKnowledgeRelatedMedicationKnowledge("relatedMedicationKnowledge", relatedMedicationKnowledgeArray.getJsonObject(i), i));
            }
        }
        if ((associatedMedicationArray = JsonSupport.getJsonArray(jsonObject, "associatedMedication")) != null) {
            for (int i2 = 0; i2 < associatedMedicationArray.size(); ++i2) {
                builder.associatedMedication(this.parseReference("associatedMedication", associatedMedicationArray.getJsonObject(i2), i2));
            }
        }
        if ((productTypeArray = JsonSupport.getJsonArray(jsonObject, "productType")) != null) {
            for (int i3 = 0; i3 < productTypeArray.size(); ++i3) {
                builder.productType(this.parseCodeableConcept("productType", productTypeArray.getJsonObject(i3), i3));
            }
        }
        if ((monographArray = JsonSupport.getJsonArray(jsonObject, "monograph")) != null) {
            for (int i4 = 0; i4 < monographArray.size(); ++i4) {
                builder.monograph(this.parseMedicationKnowledgeMonograph("monograph", monographArray.getJsonObject(i4), i4));
            }
        }
        if ((ingredientArray = JsonSupport.getJsonArray(jsonObject, "ingredient")) != null) {
            for (int i5 = 0; i5 < ingredientArray.size(); ++i5) {
                builder.ingredient(this.parseMedicationKnowledgeIngredient("ingredient", ingredientArray.getJsonObject(i5), i5));
            }
        }
        builder.preparationInstruction((Markdown)this.parseString(Markdown.builder(), "preparationInstruction", (JsonValue)JsonSupport.getJsonValue(jsonObject, "preparationInstruction", JsonString.class), (JsonValue)jsonObject.get((Object)"_preparationInstruction"), -1));
        JsonArray intendedRouteArray = JsonSupport.getJsonArray(jsonObject, "intendedRoute");
        if (intendedRouteArray != null) {
            for (int i6 = 0; i6 < intendedRouteArray.size(); ++i6) {
                builder.intendedRoute(this.parseCodeableConcept("intendedRoute", intendedRouteArray.getJsonObject(i6), i6));
            }
        }
        if ((costArray = JsonSupport.getJsonArray(jsonObject, "cost")) != null) {
            for (int i7 = 0; i7 < costArray.size(); ++i7) {
                builder.cost(this.parseMedicationKnowledgeCost("cost", costArray.getJsonObject(i7), i7));
            }
        }
        if ((monitoringProgramArray = JsonSupport.getJsonArray(jsonObject, "monitoringProgram")) != null) {
            for (int i8 = 0; i8 < monitoringProgramArray.size(); ++i8) {
                builder.monitoringProgram(this.parseMedicationKnowledgeMonitoringProgram("monitoringProgram", monitoringProgramArray.getJsonObject(i8), i8));
            }
        }
        if ((administrationGuidelinesArray = JsonSupport.getJsonArray(jsonObject, "administrationGuidelines")) != null) {
            for (int i9 = 0; i9 < administrationGuidelinesArray.size(); ++i9) {
                builder.administrationGuidelines(this.parseMedicationKnowledgeAdministrationGuidelines("administrationGuidelines", administrationGuidelinesArray.getJsonObject(i9), i9));
            }
        }
        if ((medicineClassificationArray = JsonSupport.getJsonArray(jsonObject, "medicineClassification")) != null) {
            for (int i10 = 0; i10 < medicineClassificationArray.size(); ++i10) {
                builder.medicineClassification(this.parseMedicationKnowledgeMedicineClassification("medicineClassification", medicineClassificationArray.getJsonObject(i10), i10));
            }
        }
        builder.packaging(this.parseMedicationKnowledgePackaging("packaging", JsonSupport.getJsonValue(jsonObject, "packaging", JsonObject.class), -1));
        JsonArray drugCharacteristicArray = JsonSupport.getJsonArray(jsonObject, "drugCharacteristic");
        if (drugCharacteristicArray != null) {
            for (int i11 = 0; i11 < drugCharacteristicArray.size(); ++i11) {
                builder.drugCharacteristic(this.parseMedicationKnowledgeDrugCharacteristic("drugCharacteristic", drugCharacteristicArray.getJsonObject(i11), i11));
            }
        }
        if ((contraindicationArray = JsonSupport.getJsonArray(jsonObject, "contraindication")) != null) {
            for (int i12 = 0; i12 < contraindicationArray.size(); ++i12) {
                builder.contraindication(this.parseReference("contraindication", contraindicationArray.getJsonObject(i12), i12));
            }
        }
        if ((regulatoryArray = JsonSupport.getJsonArray(jsonObject, "regulatory")) != null) {
            for (int i13 = 0; i13 < regulatoryArray.size(); ++i13) {
                builder.regulatory(this.parseMedicationKnowledgeRegulatory("regulatory", regulatoryArray.getJsonObject(i13), i13));
            }
        }
        if ((kineticsArray = JsonSupport.getJsonArray(jsonObject, "kinetics")) != null) {
            for (int i14 = 0; i14 < kineticsArray.size(); ++i14) {
                builder.kinetics(this.parseMedicationKnowledgeKinetics("kinetics", kineticsArray.getJsonObject(i14), i14));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.AdministrationGuidelines parseMedicationKnowledgeAdministrationGuidelines(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.AdministrationGuidelines.class, jsonObject);
        }
        MedicationKnowledge.AdministrationGuidelines.Builder builder = MedicationKnowledge.AdministrationGuidelines.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray dosageArray = JsonSupport.getJsonArray(jsonObject, "dosage");
        if (dosageArray != null) {
            for (int i = 0; i < dosageArray.size(); ++i) {
                builder.dosage(this.parseMedicationKnowledgeAdministrationGuidelinesDosage("dosage", dosageArray.getJsonObject(i), i));
            }
        }
        builder.indication(this.parseChoiceElement("indication", jsonObject, CodeableConcept.class, Reference.class));
        JsonArray patientCharacteristicsArray = JsonSupport.getJsonArray(jsonObject, "patientCharacteristics");
        if (patientCharacteristicsArray != null) {
            for (int i = 0; i < patientCharacteristicsArray.size(); ++i) {
                builder.patientCharacteristics(this.parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristics("patientCharacteristics", patientCharacteristicsArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.AdministrationGuidelines.Dosage parseMedicationKnowledgeAdministrationGuidelinesDosage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.AdministrationGuidelines.Dosage.class, jsonObject);
        }
        MedicationKnowledge.AdministrationGuidelines.Dosage.Builder builder = MedicationKnowledge.AdministrationGuidelines.Dosage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray dosageArray = JsonSupport.getJsonArray(jsonObject, "dosage");
        if (dosageArray != null) {
            for (int i = 0; i < dosageArray.size(); ++i) {
                builder.dosage(this.parseDosage("dosage", dosageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.AdministrationGuidelines.PatientCharacteristics parseMedicationKnowledgeAdministrationGuidelinesPatientCharacteristics(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.AdministrationGuidelines.PatientCharacteristics.class, jsonObject);
        }
        MedicationKnowledge.AdministrationGuidelines.PatientCharacteristics.Builder builder = MedicationKnowledge.AdministrationGuidelines.PatientCharacteristics.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.characteristic(this.parseChoiceElement("characteristic", jsonObject, CodeableConcept.class, SimpleQuantity.class));
        JsonArray valueArray = JsonSupport.getJsonArray(jsonObject, "value", true);
        if (valueArray != null) {
            JsonArray _valueArray = jsonObject.getJsonArray("_value");
            for (int i = 0; i < valueArray.size(); ++i) {
                builder.value(this.parseString("value", (JsonValue)valueArray.get(i), JsonSupport.getJsonValue(_valueArray, i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Cost parseMedicationKnowledgeCost(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Cost.class, jsonObject);
        }
        MedicationKnowledge.Cost.Builder builder = MedicationKnowledge.Cost.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.source(this.parseString("source", (JsonValue)JsonSupport.getJsonValue(jsonObject, "source", JsonString.class), (JsonValue)jsonObject.get((Object)"_source"), -1));
        builder.cost(this.parseMoney("cost", JsonSupport.getJsonValue(jsonObject, "cost", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.DrugCharacteristic parseMedicationKnowledgeDrugCharacteristic(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.DrugCharacteristic.class, jsonObject);
        }
        MedicationKnowledge.DrugCharacteristic.Builder builder = MedicationKnowledge.DrugCharacteristic.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.value(this.parseChoiceElement("value", jsonObject, CodeableConcept.class, com.ibm.fhir.model.type.String.class, SimpleQuantity.class, Base64Binary.class));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Ingredient parseMedicationKnowledgeIngredient(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Ingredient.class, jsonObject);
        }
        MedicationKnowledge.Ingredient.Builder builder = MedicationKnowledge.Ingredient.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.item(this.parseChoiceElement("item", jsonObject, CodeableConcept.class, Reference.class));
        builder.isActive(this.parseBoolean("isActive", JsonSupport.getJsonValue(jsonObject, "isActive", JsonValue.class), (JsonValue)jsonObject.get((Object)"_isActive"), -1));
        builder.strength(this.parseRatio("strength", JsonSupport.getJsonValue(jsonObject, "strength", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Kinetics parseMedicationKnowledgeKinetics(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray lethalDose50Array;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Kinetics.class, jsonObject);
        }
        MedicationKnowledge.Kinetics.Builder builder = MedicationKnowledge.Kinetics.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray areaUnderCurveArray = JsonSupport.getJsonArray(jsonObject, "areaUnderCurve");
        if (areaUnderCurveArray != null) {
            for (int i = 0; i < areaUnderCurveArray.size(); ++i) {
                builder.areaUnderCurve((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "areaUnderCurve", areaUnderCurveArray.getJsonObject(i), i));
            }
        }
        if ((lethalDose50Array = JsonSupport.getJsonArray(jsonObject, "lethalDose50")) != null) {
            for (int i = 0; i < lethalDose50Array.size(); ++i) {
                builder.lethalDose50((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "lethalDose50", lethalDose50Array.getJsonObject(i), i));
            }
        }
        builder.halfLifePeriod((Duration)this.parseQuantity(Duration.builder(), "halfLifePeriod", JsonSupport.getJsonValue(jsonObject, "halfLifePeriod", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.MedicineClassification parseMedicationKnowledgeMedicineClassification(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.MedicineClassification.class, jsonObject);
        }
        MedicationKnowledge.MedicineClassification.Builder builder = MedicationKnowledge.MedicineClassification.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray classificationArray = JsonSupport.getJsonArray(jsonObject, "classification");
        if (classificationArray != null) {
            for (int i = 0; i < classificationArray.size(); ++i) {
                builder.classification(this.parseCodeableConcept("classification", classificationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.MonitoringProgram parseMedicationKnowledgeMonitoringProgram(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.MonitoringProgram.class, jsonObject);
        }
        MedicationKnowledge.MonitoringProgram.Builder builder = MedicationKnowledge.MonitoringProgram.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.name(this.parseString("name", (JsonValue)JsonSupport.getJsonValue(jsonObject, "name", JsonString.class), (JsonValue)jsonObject.get((Object)"_name"), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Monograph parseMedicationKnowledgeMonograph(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Monograph.class, jsonObject);
        }
        MedicationKnowledge.Monograph.Builder builder = MedicationKnowledge.Monograph.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.source(this.parseReference("source", JsonSupport.getJsonValue(jsonObject, "source", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Packaging parseMedicationKnowledgePackaging(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Packaging.class, jsonObject);
        }
        MedicationKnowledge.Packaging.Builder builder = MedicationKnowledge.Packaging.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Regulatory parseMedicationKnowledgeRegulatory(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray scheduleArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Regulatory.class, jsonObject);
        }
        MedicationKnowledge.Regulatory.Builder builder = MedicationKnowledge.Regulatory.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.regulatoryAuthority(this.parseReference("regulatoryAuthority", JsonSupport.getJsonValue(jsonObject, "regulatoryAuthority", JsonObject.class), -1));
        JsonArray substitutionArray = JsonSupport.getJsonArray(jsonObject, "substitution");
        if (substitutionArray != null) {
            for (int i = 0; i < substitutionArray.size(); ++i) {
                builder.substitution(this.parseMedicationKnowledgeRegulatorySubstitution("substitution", substitutionArray.getJsonObject(i), i));
            }
        }
        if ((scheduleArray = JsonSupport.getJsonArray(jsonObject, "schedule")) != null) {
            for (int i = 0; i < scheduleArray.size(); ++i) {
                builder.schedule(this.parseMedicationKnowledgeRegulatorySchedule("schedule", scheduleArray.getJsonObject(i), i));
            }
        }
        builder.maxDispense(this.parseMedicationKnowledgeRegulatoryMaxDispense("maxDispense", JsonSupport.getJsonValue(jsonObject, "maxDispense", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Regulatory.MaxDispense parseMedicationKnowledgeRegulatoryMaxDispense(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Regulatory.MaxDispense.class, jsonObject);
        }
        MedicationKnowledge.Regulatory.MaxDispense.Builder builder = MedicationKnowledge.Regulatory.MaxDispense.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.period((Duration)this.parseQuantity(Duration.builder(), "period", JsonSupport.getJsonValue(jsonObject, "period", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Regulatory.Schedule parseMedicationKnowledgeRegulatorySchedule(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Regulatory.Schedule.class, jsonObject);
        }
        MedicationKnowledge.Regulatory.Schedule.Builder builder = MedicationKnowledge.Regulatory.Schedule.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.schedule(this.parseCodeableConcept("schedule", JsonSupport.getJsonValue(jsonObject, "schedule", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.Regulatory.Substitution parseMedicationKnowledgeRegulatorySubstitution(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.Regulatory.Substitution.class, jsonObject);
        }
        MedicationKnowledge.Regulatory.Substitution.Builder builder = MedicationKnowledge.Regulatory.Substitution.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.allowed(this.parseBoolean("allowed", JsonSupport.getJsonValue(jsonObject, "allowed", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allowed"), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationKnowledge.RelatedMedicationKnowledge parseMedicationKnowledgeRelatedMedicationKnowledge(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationKnowledge.RelatedMedicationKnowledge.class, jsonObject);
        }
        MedicationKnowledge.RelatedMedicationKnowledge.Builder builder = MedicationKnowledge.RelatedMedicationKnowledge.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        JsonArray referenceArray = JsonSupport.getJsonArray(jsonObject, "reference");
        if (referenceArray != null) {
            for (int i = 0; i < referenceArray.size(); ++i) {
                builder.reference(this.parseReference("reference", referenceArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationRequest parseMedicationRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray eventHistoryArray;
        JsonArray dosageInstructionArray;
        JsonArray noteArray;
        JsonArray basedOnArray;
        int i;
        JsonArray instantiatesUriArray;
        JsonArray instantiatesCanonicalArray;
        JsonArray reasonReferenceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationRequest.class, jsonObject);
        }
        MedicationRequest.Builder builder = MedicationRequest.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.status((MedicationRequestStatus)this.parseString(MedicationRequestStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        builder.statusReason(this.parseCodeableConcept("statusReason", JsonSupport.getJsonValue(jsonObject, "statusReason", JsonObject.class), -1));
        builder.intent((MedicationRequestIntent)this.parseString(MedicationRequestIntent.builder(), "intent", (JsonValue)JsonSupport.getJsonValue(jsonObject, "intent", JsonString.class), (JsonValue)jsonObject.get((Object)"_intent"), -1));
        JsonArray categoryArray = JsonSupport.getJsonArray(jsonObject, "category");
        if (categoryArray != null) {
            for (int i3 = 0; i3 < categoryArray.size(); ++i3) {
                builder.category(this.parseCodeableConcept("category", categoryArray.getJsonObject(i3), i3));
            }
        }
        builder.priority((MedicationRequestPriority)this.parseString(MedicationRequestPriority.builder(), "priority", (JsonValue)JsonSupport.getJsonValue(jsonObject, "priority", JsonString.class), (JsonValue)jsonObject.get((Object)"_priority"), -1));
        builder.doNotPerform(this.parseBoolean("doNotPerform", JsonSupport.getJsonValue(jsonObject, "doNotPerform", JsonValue.class), (JsonValue)jsonObject.get((Object)"_doNotPerform"), -1));
        builder.reported(this.parseChoiceElement("reported", jsonObject, Boolean.class, Reference.class));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.encounter(this.parseReference("encounter", JsonSupport.getJsonValue(jsonObject, "encounter", JsonObject.class), -1));
        JsonArray supportingInformationArray = JsonSupport.getJsonArray(jsonObject, "supportingInformation");
        if (supportingInformationArray != null) {
            for (int i4 = 0; i4 < supportingInformationArray.size(); ++i4) {
                builder.supportingInformation(this.parseReference("supportingInformation", supportingInformationArray.getJsonObject(i4), i4));
            }
        }
        builder.authoredOn(this.parseDateTime("authoredOn", (JsonValue)JsonSupport.getJsonValue(jsonObject, "authoredOn", JsonString.class), (JsonValue)jsonObject.get((Object)"_authoredOn"), -1));
        builder.requester(this.parseReference("requester", JsonSupport.getJsonValue(jsonObject, "requester", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        builder.performerType(this.parseCodeableConcept("performerType", JsonSupport.getJsonValue(jsonObject, "performerType", JsonObject.class), -1));
        builder.recorder(this.parseReference("recorder", JsonSupport.getJsonValue(jsonObject, "recorder", JsonObject.class), -1));
        JsonArray reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode");
        if (reasonCodeArray != null) {
            for (int i5 = 0; i5 < reasonCodeArray.size(); ++i5) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i5), i5));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i6 = 0; i6 < reasonReferenceArray.size(); ++i6) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i6), i6));
            }
        }
        if ((instantiatesCanonicalArray = JsonSupport.getJsonArray(jsonObject, "instantiatesCanonical", true)) != null) {
            JsonArray _instantiatesCanonicalArray = jsonObject.getJsonArray("_instantiatesCanonical");
            for (int i7 = 0; i7 < instantiatesCanonicalArray.size(); ++i7) {
                builder.instantiatesCanonical((Canonical)this.parseUri(Canonical.builder(), "instantiatesCanonical", (JsonValue)instantiatesCanonicalArray.get(i7), JsonSupport.getJsonValue(_instantiatesCanonicalArray, i7), i7));
            }
        }
        if ((instantiatesUriArray = JsonSupport.getJsonArray(jsonObject, "instantiatesUri", true)) != null) {
            JsonArray _instantiatesUriArray = jsonObject.getJsonArray("_instantiatesUri");
            for (i = 0; i < instantiatesUriArray.size(); ++i) {
                builder.instantiatesUri(this.parseUri("instantiatesUri", (JsonValue)instantiatesUriArray.get(i), JsonSupport.getJsonValue(_instantiatesUriArray, i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        builder.groupIdentifier(this.parseIdentifier("groupIdentifier", JsonSupport.getJsonValue(jsonObject, "groupIdentifier", JsonObject.class), -1));
        builder.courseOfTherapyType(this.parseCodeableConcept("courseOfTherapyType", JsonSupport.getJsonValue(jsonObject, "courseOfTherapyType", JsonObject.class), -1));
        JsonArray insuranceArray = JsonSupport.getJsonArray(jsonObject, "insurance");
        if (insuranceArray != null) {
            for (int i8 = 0; i8 < insuranceArray.size(); ++i8) {
                builder.insurance(this.parseReference("insurance", insuranceArray.getJsonObject(i8), i8));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i9 = 0; i9 < noteArray.size(); ++i9) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i9), i9));
            }
        }
        if ((dosageInstructionArray = JsonSupport.getJsonArray(jsonObject, "dosageInstruction")) != null) {
            for (int i10 = 0; i10 < dosageInstructionArray.size(); ++i10) {
                builder.dosageInstruction(this.parseDosage("dosageInstruction", dosageInstructionArray.getJsonObject(i10), i10));
            }
        }
        builder.dispenseRequest(this.parseMedicationRequestDispenseRequest("dispenseRequest", JsonSupport.getJsonValue(jsonObject, "dispenseRequest", JsonObject.class), -1));
        builder.substitution(this.parseMedicationRequestSubstitution("substitution", JsonSupport.getJsonValue(jsonObject, "substitution", JsonObject.class), -1));
        builder.priorPrescription(this.parseReference("priorPrescription", JsonSupport.getJsonValue(jsonObject, "priorPrescription", JsonObject.class), -1));
        JsonArray detectedIssueArray = JsonSupport.getJsonArray(jsonObject, "detectedIssue");
        if (detectedIssueArray != null) {
            for (int i11 = 0; i11 < detectedIssueArray.size(); ++i11) {
                builder.detectedIssue(this.parseReference("detectedIssue", detectedIssueArray.getJsonObject(i11), i11));
            }
        }
        if ((eventHistoryArray = JsonSupport.getJsonArray(jsonObject, "eventHistory")) != null) {
            for (int i12 = 0; i12 < eventHistoryArray.size(); ++i12) {
                builder.eventHistory(this.parseReference("eventHistory", eventHistoryArray.getJsonObject(i12), i12));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicationRequest.DispenseRequest parseMedicationRequestDispenseRequest(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationRequest.DispenseRequest.class, jsonObject);
        }
        MedicationRequest.DispenseRequest.Builder builder = MedicationRequest.DispenseRequest.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.initialFill(this.parseMedicationRequestDispenseRequestInitialFill("initialFill", JsonSupport.getJsonValue(jsonObject, "initialFill", JsonObject.class), -1));
        builder.dispenseInterval((Duration)this.parseQuantity(Duration.builder(), "dispenseInterval", JsonSupport.getJsonValue(jsonObject, "dispenseInterval", JsonObject.class), -1));
        builder.validityPeriod(this.parsePeriod("validityPeriod", JsonSupport.getJsonValue(jsonObject, "validityPeriod", JsonObject.class), -1));
        builder.numberOfRepeatsAllowed((UnsignedInt)this.parseInteger(UnsignedInt.builder(), "numberOfRepeatsAllowed", (JsonValue)JsonSupport.getJsonValue(jsonObject, "numberOfRepeatsAllowed", JsonNumber.class), (JsonValue)jsonObject.get((Object)"_numberOfRepeatsAllowed"), -1));
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.expectedSupplyDuration((Duration)this.parseQuantity(Duration.builder(), "expectedSupplyDuration", JsonSupport.getJsonValue(jsonObject, "expectedSupplyDuration", JsonObject.class), -1));
        builder.performer(this.parseReference("performer", JsonSupport.getJsonValue(jsonObject, "performer", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationRequest.DispenseRequest.InitialFill parseMedicationRequestDispenseRequestInitialFill(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationRequest.DispenseRequest.InitialFill.class, jsonObject);
        }
        MedicationRequest.DispenseRequest.InitialFill.Builder builder = MedicationRequest.DispenseRequest.InitialFill.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.quantity((SimpleQuantity)this.parseQuantity(SimpleQuantity.builder(), "quantity", JsonSupport.getJsonValue(jsonObject, "quantity", JsonObject.class), -1));
        builder.duration((Duration)this.parseQuantity(Duration.builder(), "duration", JsonSupport.getJsonValue(jsonObject, "duration", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationRequest.Substitution parseMedicationRequestSubstitution(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationRequest.Substitution.class, jsonObject);
        }
        MedicationRequest.Substitution.Builder builder = MedicationRequest.Substitution.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.allowed(this.parseChoiceElement("allowed", jsonObject, Boolean.class, CodeableConcept.class));
        builder.reason(this.parseCodeableConcept("reason", JsonSupport.getJsonValue(jsonObject, "reason", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicationStatement parseMedicationStatement(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray dosageArray;
        JsonArray noteArray;
        JsonArray reasonReferenceArray;
        JsonArray reasonCodeArray;
        JsonArray partOfArray;
        JsonArray basedOnArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicationStatement.class, jsonObject);
        }
        MedicationStatement.Builder builder = MedicationStatement.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        if ((basedOnArray = JsonSupport.getJsonArray(jsonObject, "basedOn")) != null) {
            for (int i = 0; i < basedOnArray.size(); ++i) {
                builder.basedOn(this.parseReference("basedOn", basedOnArray.getJsonObject(i), i));
            }
        }
        if ((partOfArray = JsonSupport.getJsonArray(jsonObject, "partOf")) != null) {
            for (int i = 0; i < partOfArray.size(); ++i) {
                builder.partOf(this.parseReference("partOf", partOfArray.getJsonObject(i), i));
            }
        }
        builder.status((MedicationStatementStatus)this.parseString(MedicationStatementStatus.builder(), "status", (JsonValue)JsonSupport.getJsonValue(jsonObject, "status", JsonString.class), (JsonValue)jsonObject.get((Object)"_status"), -1));
        JsonArray statusReasonArray = JsonSupport.getJsonArray(jsonObject, "statusReason");
        if (statusReasonArray != null) {
            for (int i = 0; i < statusReasonArray.size(); ++i) {
                builder.statusReason(this.parseCodeableConcept("statusReason", statusReasonArray.getJsonObject(i), i));
            }
        }
        builder.category(this.parseCodeableConcept("category", JsonSupport.getJsonValue(jsonObject, "category", JsonObject.class), -1));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        builder.context(this.parseReference("context", JsonSupport.getJsonValue(jsonObject, "context", JsonObject.class), -1));
        builder.effective(this.parseChoiceElement("effective", jsonObject, DateTime.class, Period.class));
        builder.dateAsserted(this.parseDateTime("dateAsserted", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dateAsserted", JsonString.class), (JsonValue)jsonObject.get((Object)"_dateAsserted"), -1));
        builder.informationSource(this.parseReference("informationSource", JsonSupport.getJsonValue(jsonObject, "informationSource", JsonObject.class), -1));
        JsonArray derivedFromArray = JsonSupport.getJsonArray(jsonObject, "derivedFrom");
        if (derivedFromArray != null) {
            for (int i = 0; i < derivedFromArray.size(); ++i) {
                builder.derivedFrom(this.parseReference("derivedFrom", derivedFromArray.getJsonObject(i), i));
            }
        }
        if ((reasonCodeArray = JsonSupport.getJsonArray(jsonObject, "reasonCode")) != null) {
            for (int i = 0; i < reasonCodeArray.size(); ++i) {
                builder.reasonCode(this.parseCodeableConcept("reasonCode", reasonCodeArray.getJsonObject(i), i));
            }
        }
        if ((reasonReferenceArray = JsonSupport.getJsonArray(jsonObject, "reasonReference")) != null) {
            for (int i = 0; i < reasonReferenceArray.size(); ++i) {
                builder.reasonReference(this.parseReference("reasonReference", reasonReferenceArray.getJsonObject(i), i));
            }
        }
        if ((noteArray = JsonSupport.getJsonArray(jsonObject, "note")) != null) {
            for (int i = 0; i < noteArray.size(); ++i) {
                builder.note(this.parseAnnotation("note", noteArray.getJsonObject(i), i));
            }
        }
        if ((dosageArray = JsonSupport.getJsonArray(jsonObject, "dosage")) != null) {
            for (int i = 0; i < dosageArray.size(); ++i) {
                builder.dosage(this.parseDosage("dosage", dosageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct parseMedicinalProduct(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray specialDesignationArray;
        JsonArray manufacturingBusinessOperationArray;
        JsonArray crossReferenceArray;
        JsonArray nameArray;
        JsonArray clinicalTrialArray;
        JsonArray contactArray;
        JsonArray masterFileArray;
        JsonArray attachedDocumentArray;
        JsonArray packagedMedicinalProductArray;
        JsonArray pharmaceuticalProductArray;
        JsonArray marketingStatusArray;
        int i;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.class, jsonObject);
        }
        MedicinalProduct.Builder builder = MedicinalProduct.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i2 = 0; i2 < identifierArray.size(); ++i2) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i2), i2));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.domain(this.parseCoding("domain", JsonSupport.getJsonValue(jsonObject, "domain", JsonObject.class), -1));
        builder.combinedPharmaceuticalDoseForm(this.parseCodeableConcept("combinedPharmaceuticalDoseForm", JsonSupport.getJsonValue(jsonObject, "combinedPharmaceuticalDoseForm", JsonObject.class), -1));
        builder.legalStatusOfSupply(this.parseCodeableConcept("legalStatusOfSupply", JsonSupport.getJsonValue(jsonObject, "legalStatusOfSupply", JsonObject.class), -1));
        builder.additionalMonitoringIndicator(this.parseCodeableConcept("additionalMonitoringIndicator", JsonSupport.getJsonValue(jsonObject, "additionalMonitoringIndicator", JsonObject.class), -1));
        JsonArray specialMeasuresArray = JsonSupport.getJsonArray(jsonObject, "specialMeasures", true);
        if (specialMeasuresArray != null) {
            JsonArray _specialMeasuresArray = jsonObject.getJsonArray("_specialMeasures");
            for (i = 0; i < specialMeasuresArray.size(); ++i) {
                builder.specialMeasures(this.parseString("specialMeasures", (JsonValue)specialMeasuresArray.get(i), JsonSupport.getJsonValue(_specialMeasuresArray, i), i));
            }
        }
        builder.paediatricUseIndicator(this.parseCodeableConcept("paediatricUseIndicator", JsonSupport.getJsonValue(jsonObject, "paediatricUseIndicator", JsonObject.class), -1));
        JsonArray productClassificationArray = JsonSupport.getJsonArray(jsonObject, "productClassification");
        if (productClassificationArray != null) {
            for (i = 0; i < productClassificationArray.size(); ++i) {
                builder.productClassification(this.parseCodeableConcept("productClassification", productClassificationArray.getJsonObject(i), i));
            }
        }
        if ((marketingStatusArray = JsonSupport.getJsonArray(jsonObject, "marketingStatus")) != null) {
            for (int i3 = 0; i3 < marketingStatusArray.size(); ++i3) {
                builder.marketingStatus(this.parseMarketingStatus("marketingStatus", marketingStatusArray.getJsonObject(i3), i3));
            }
        }
        if ((pharmaceuticalProductArray = JsonSupport.getJsonArray(jsonObject, "pharmaceuticalProduct")) != null) {
            for (int i4 = 0; i4 < pharmaceuticalProductArray.size(); ++i4) {
                builder.pharmaceuticalProduct(this.parseReference("pharmaceuticalProduct", pharmaceuticalProductArray.getJsonObject(i4), i4));
            }
        }
        if ((packagedMedicinalProductArray = JsonSupport.getJsonArray(jsonObject, "packagedMedicinalProduct")) != null) {
            for (int i5 = 0; i5 < packagedMedicinalProductArray.size(); ++i5) {
                builder.packagedMedicinalProduct(this.parseReference("packagedMedicinalProduct", packagedMedicinalProductArray.getJsonObject(i5), i5));
            }
        }
        if ((attachedDocumentArray = JsonSupport.getJsonArray(jsonObject, "attachedDocument")) != null) {
            for (int i6 = 0; i6 < attachedDocumentArray.size(); ++i6) {
                builder.attachedDocument(this.parseReference("attachedDocument", attachedDocumentArray.getJsonObject(i6), i6));
            }
        }
        if ((masterFileArray = JsonSupport.getJsonArray(jsonObject, "masterFile")) != null) {
            for (int i7 = 0; i7 < masterFileArray.size(); ++i7) {
                builder.masterFile(this.parseReference("masterFile", masterFileArray.getJsonObject(i7), i7));
            }
        }
        if ((contactArray = JsonSupport.getJsonArray(jsonObject, "contact")) != null) {
            for (int i8 = 0; i8 < contactArray.size(); ++i8) {
                builder.contact(this.parseReference("contact", contactArray.getJsonObject(i8), i8));
            }
        }
        if ((clinicalTrialArray = JsonSupport.getJsonArray(jsonObject, "clinicalTrial")) != null) {
            for (int i9 = 0; i9 < clinicalTrialArray.size(); ++i9) {
                builder.clinicalTrial(this.parseReference("clinicalTrial", clinicalTrialArray.getJsonObject(i9), i9));
            }
        }
        if ((nameArray = JsonSupport.getJsonArray(jsonObject, "name")) != null) {
            for (int i10 = 0; i10 < nameArray.size(); ++i10) {
                builder.name(this.parseMedicinalProductName("name", nameArray.getJsonObject(i10), i10));
            }
        }
        if ((crossReferenceArray = JsonSupport.getJsonArray(jsonObject, "crossReference")) != null) {
            for (int i11 = 0; i11 < crossReferenceArray.size(); ++i11) {
                builder.crossReference(this.parseIdentifier("crossReference", crossReferenceArray.getJsonObject(i11), i11));
            }
        }
        if ((manufacturingBusinessOperationArray = JsonSupport.getJsonArray(jsonObject, "manufacturingBusinessOperation")) != null) {
            for (int i12 = 0; i12 < manufacturingBusinessOperationArray.size(); ++i12) {
                builder.manufacturingBusinessOperation(this.parseMedicinalProductManufacturingBusinessOperation("manufacturingBusinessOperation", manufacturingBusinessOperationArray.getJsonObject(i12), i12));
            }
        }
        if ((specialDesignationArray = JsonSupport.getJsonArray(jsonObject, "specialDesignation")) != null) {
            for (int i13 = 0; i13 < specialDesignationArray.size(); ++i13) {
                builder.specialDesignation(this.parseMedicinalProductSpecialDesignation("specialDesignation", specialDesignationArray.getJsonObject(i13), i13));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct.ManufacturingBusinessOperation parseMedicinalProductManufacturingBusinessOperation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.ManufacturingBusinessOperation.class, jsonObject);
        }
        MedicinalProduct.ManufacturingBusinessOperation.Builder builder = MedicinalProduct.ManufacturingBusinessOperation.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.operationType(this.parseCodeableConcept("operationType", JsonSupport.getJsonValue(jsonObject, "operationType", JsonObject.class), -1));
        builder.authorisationReferenceNumber(this.parseIdentifier("authorisationReferenceNumber", JsonSupport.getJsonValue(jsonObject, "authorisationReferenceNumber", JsonObject.class), -1));
        builder.effectiveDate(this.parseDateTime("effectiveDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "effectiveDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_effectiveDate"), -1));
        builder.confidentialityIndicator(this.parseCodeableConcept("confidentialityIndicator", JsonSupport.getJsonValue(jsonObject, "confidentialityIndicator", JsonObject.class), -1));
        JsonArray manufacturerArray = JsonSupport.getJsonArray(jsonObject, "manufacturer");
        if (manufacturerArray != null) {
            for (int i = 0; i < manufacturerArray.size(); ++i) {
                builder.manufacturer(this.parseReference("manufacturer", manufacturerArray.getJsonObject(i), i));
            }
        }
        builder.regulator(this.parseReference("regulator", JsonSupport.getJsonValue(jsonObject, "regulator", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct.Name parseMedicinalProductName(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray countryLanguageArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.Name.class, jsonObject);
        }
        MedicinalProduct.Name.Builder builder = MedicinalProduct.Name.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.productName(this.parseString("productName", (JsonValue)JsonSupport.getJsonValue(jsonObject, "productName", JsonString.class), (JsonValue)jsonObject.get((Object)"_productName"), -1));
        JsonArray namePartArray = JsonSupport.getJsonArray(jsonObject, "namePart");
        if (namePartArray != null) {
            for (int i = 0; i < namePartArray.size(); ++i) {
                builder.namePart(this.parseMedicinalProductNameNamePart("namePart", namePartArray.getJsonObject(i), i));
            }
        }
        if ((countryLanguageArray = JsonSupport.getJsonArray(jsonObject, "countryLanguage")) != null) {
            for (int i = 0; i < countryLanguageArray.size(); ++i) {
                builder.countryLanguage(this.parseMedicinalProductNameCountryLanguage("countryLanguage", countryLanguageArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct.Name.CountryLanguage parseMedicinalProductNameCountryLanguage(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.Name.CountryLanguage.class, jsonObject);
        }
        MedicinalProduct.Name.CountryLanguage.Builder builder = MedicinalProduct.Name.CountryLanguage.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.country(this.parseCodeableConcept("country", JsonSupport.getJsonValue(jsonObject, "country", JsonObject.class), -1));
        builder.jurisdiction(this.parseCodeableConcept("jurisdiction", JsonSupport.getJsonValue(jsonObject, "jurisdiction", JsonObject.class), -1));
        builder.language(this.parseCodeableConcept("language", JsonSupport.getJsonValue(jsonObject, "language", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct.Name.NamePart parseMedicinalProductNameNamePart(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.Name.NamePart.class, jsonObject);
        }
        MedicinalProduct.Name.NamePart.Builder builder = MedicinalProduct.Name.NamePart.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.part(this.parseString("part", (JsonValue)JsonSupport.getJsonValue(jsonObject, "part", JsonString.class), (JsonValue)jsonObject.get((Object)"_part"), -1));
        builder.type(this.parseCoding("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProduct.SpecialDesignation parseMedicinalProductSpecialDesignation(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProduct.SpecialDesignation.class, jsonObject);
        }
        MedicinalProduct.SpecialDesignation.Builder builder = MedicinalProduct.SpecialDesignation.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.intendedUse(this.parseCodeableConcept("intendedUse", JsonSupport.getJsonValue(jsonObject, "intendedUse", JsonObject.class), -1));
        builder.indication(this.parseChoiceElement("indication", jsonObject, CodeableConcept.class, Reference.class));
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.date(this.parseDateTime("date", (JsonValue)JsonSupport.getJsonValue(jsonObject, "date", JsonString.class), (JsonValue)jsonObject.get((Object)"_date"), -1));
        builder.species(this.parseCodeableConcept("species", JsonSupport.getJsonValue(jsonObject, "species", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductAuthorization parseMedicinalProductAuthorization(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray jurisdictionArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductAuthorization.class, jsonObject);
        }
        MedicinalProductAuthorization.Builder builder = MedicinalProductAuthorization.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.subject(this.parseReference("subject", JsonSupport.getJsonValue(jsonObject, "subject", JsonObject.class), -1));
        JsonArray countryArray = JsonSupport.getJsonArray(jsonObject, "country");
        if (countryArray != null) {
            for (int i = 0; i < countryArray.size(); ++i) {
                builder.country(this.parseCodeableConcept("country", countryArray.getJsonObject(i), i));
            }
        }
        if ((jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction")) != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.status(this.parseCodeableConcept("status", JsonSupport.getJsonValue(jsonObject, "status", JsonObject.class), -1));
        builder.statusDate(this.parseDateTime("statusDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "statusDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_statusDate"), -1));
        builder.restoreDate(this.parseDateTime("restoreDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "restoreDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_restoreDate"), -1));
        builder.validityPeriod(this.parsePeriod("validityPeriod", JsonSupport.getJsonValue(jsonObject, "validityPeriod", JsonObject.class), -1));
        builder.dataExclusivityPeriod(this.parsePeriod("dataExclusivityPeriod", JsonSupport.getJsonValue(jsonObject, "dataExclusivityPeriod", JsonObject.class), -1));
        builder.dateOfFirstAuthorization(this.parseDateTime("dateOfFirstAuthorization", (JsonValue)JsonSupport.getJsonValue(jsonObject, "dateOfFirstAuthorization", JsonString.class), (JsonValue)jsonObject.get((Object)"_dateOfFirstAuthorization"), -1));
        builder.internationalBirthDate(this.parseDateTime("internationalBirthDate", (JsonValue)JsonSupport.getJsonValue(jsonObject, "internationalBirthDate", JsonString.class), (JsonValue)jsonObject.get((Object)"_internationalBirthDate"), -1));
        builder.legalBasis(this.parseCodeableConcept("legalBasis", JsonSupport.getJsonValue(jsonObject, "legalBasis", JsonObject.class), -1));
        JsonArray jurisdictionalAuthorizationArray = JsonSupport.getJsonArray(jsonObject, "jurisdictionalAuthorization");
        if (jurisdictionalAuthorizationArray != null) {
            for (int i = 0; i < jurisdictionalAuthorizationArray.size(); ++i) {
                builder.jurisdictionalAuthorization(this.parseMedicinalProductAuthorizationJurisdictionalAuthorization("jurisdictionalAuthorization", jurisdictionalAuthorizationArray.getJsonObject(i), i));
            }
        }
        builder.holder(this.parseReference("holder", JsonSupport.getJsonValue(jsonObject, "holder", JsonObject.class), -1));
        builder.regulator(this.parseReference("regulator", JsonSupport.getJsonValue(jsonObject, "regulator", JsonObject.class), -1));
        builder.procedure(this.parseMedicinalProductAuthorizationProcedure("procedure", JsonSupport.getJsonValue(jsonObject, "procedure", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductAuthorization.JurisdictionalAuthorization parseMedicinalProductAuthorizationJurisdictionalAuthorization(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductAuthorization.JurisdictionalAuthorization.class, jsonObject);
        }
        MedicinalProductAuthorization.JurisdictionalAuthorization.Builder builder = MedicinalProductAuthorization.JurisdictionalAuthorization.builder();
        this.parseBackboneElement(builder, jsonObject);
        JsonArray identifierArray = JsonSupport.getJsonArray(jsonObject, "identifier");
        if (identifierArray != null) {
            for (int i = 0; i < identifierArray.size(); ++i) {
                builder.identifier(this.parseIdentifier("identifier", identifierArray.getJsonObject(i), i));
            }
        }
        builder.country(this.parseCodeableConcept("country", JsonSupport.getJsonValue(jsonObject, "country", JsonObject.class), -1));
        JsonArray jurisdictionArray = JsonSupport.getJsonArray(jsonObject, "jurisdiction");
        if (jurisdictionArray != null) {
            for (int i = 0; i < jurisdictionArray.size(); ++i) {
                builder.jurisdiction(this.parseCodeableConcept("jurisdiction", jurisdictionArray.getJsonObject(i), i));
            }
        }
        builder.legalStatusOfSupply(this.parseCodeableConcept("legalStatusOfSupply", JsonSupport.getJsonValue(jsonObject, "legalStatusOfSupply", JsonObject.class), -1));
        builder.validityPeriod(this.parsePeriod("validityPeriod", JsonSupport.getJsonValue(jsonObject, "validityPeriod", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductAuthorization.Procedure parseMedicinalProductAuthorizationProcedure(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductAuthorization.Procedure.class, jsonObject);
        }
        MedicinalProductAuthorization.Procedure.Builder builder = MedicinalProductAuthorization.Procedure.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.type(this.parseCodeableConcept("type", JsonSupport.getJsonValue(jsonObject, "type", JsonObject.class), -1));
        builder.date(this.parseChoiceElement("date", jsonObject, Period.class, DateTime.class));
        JsonArray applicationArray = JsonSupport.getJsonArray(jsonObject, "application");
        if (applicationArray != null) {
            for (int i = 0; i < applicationArray.size(); ++i) {
                builder.application(this.parseMedicinalProductAuthorizationProcedure("application", applicationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductContraindication parseMedicinalProductContraindication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray populationArray;
        JsonArray otherTherapyArray;
        JsonArray therapeuticIndicationArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductContraindication.class, jsonObject);
        }
        MedicinalProductContraindication.Builder builder = MedicinalProductContraindication.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i = 0; i < subjectArray.size(); ++i) {
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i), i));
            }
        }
        builder.disease(this.parseCodeableConcept("disease", JsonSupport.getJsonValue(jsonObject, "disease", JsonObject.class), -1));
        builder.diseaseStatus(this.parseCodeableConcept("diseaseStatus", JsonSupport.getJsonValue(jsonObject, "diseaseStatus", JsonObject.class), -1));
        JsonArray comorbidityArray = JsonSupport.getJsonArray(jsonObject, "comorbidity");
        if (comorbidityArray != null) {
            for (int i = 0; i < comorbidityArray.size(); ++i) {
                builder.comorbidity(this.parseCodeableConcept("comorbidity", comorbidityArray.getJsonObject(i), i));
            }
        }
        if ((therapeuticIndicationArray = JsonSupport.getJsonArray(jsonObject, "therapeuticIndication")) != null) {
            for (int i = 0; i < therapeuticIndicationArray.size(); ++i) {
                builder.therapeuticIndication(this.parseReference("therapeuticIndication", therapeuticIndicationArray.getJsonObject(i), i));
            }
        }
        if ((otherTherapyArray = JsonSupport.getJsonArray(jsonObject, "otherTherapy")) != null) {
            for (int i = 0; i < otherTherapyArray.size(); ++i) {
                builder.otherTherapy(this.parseMedicinalProductContraindicationOtherTherapy("otherTherapy", otherTherapyArray.getJsonObject(i), i));
            }
        }
        if ((populationArray = JsonSupport.getJsonArray(jsonObject, "population")) != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                builder.population(this.parsePopulation("population", populationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductContraindication.OtherTherapy parseMedicinalProductContraindicationOtherTherapy(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductContraindication.OtherTherapy.class, jsonObject);
        }
        MedicinalProductContraindication.OtherTherapy.Builder builder = MedicinalProductContraindication.OtherTherapy.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.therapyRelationshipType(this.parseCodeableConcept("therapyRelationshipType", JsonSupport.getJsonValue(jsonObject, "therapyRelationshipType", JsonObject.class), -1));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductIndication parseMedicinalProductIndication(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray populationArray;
        JsonArray undesirableEffectArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductIndication.class, jsonObject);
        }
        MedicinalProductIndication.Builder builder = MedicinalProductIndication.builder();
        this.parseDomainResource(builder, jsonObject);
        JsonArray subjectArray = JsonSupport.getJsonArray(jsonObject, "subject");
        if (subjectArray != null) {
            for (int i = 0; i < subjectArray.size(); ++i) {
                builder.subject(this.parseReference("subject", subjectArray.getJsonObject(i), i));
            }
        }
        builder.diseaseSymptomProcedure(this.parseCodeableConcept("diseaseSymptomProcedure", JsonSupport.getJsonValue(jsonObject, "diseaseSymptomProcedure", JsonObject.class), -1));
        builder.diseaseStatus(this.parseCodeableConcept("diseaseStatus", JsonSupport.getJsonValue(jsonObject, "diseaseStatus", JsonObject.class), -1));
        JsonArray comorbidityArray = JsonSupport.getJsonArray(jsonObject, "comorbidity");
        if (comorbidityArray != null) {
            for (int i = 0; i < comorbidityArray.size(); ++i) {
                builder.comorbidity(this.parseCodeableConcept("comorbidity", comorbidityArray.getJsonObject(i), i));
            }
        }
        builder.intendedEffect(this.parseCodeableConcept("intendedEffect", JsonSupport.getJsonValue(jsonObject, "intendedEffect", JsonObject.class), -1));
        builder.duration(this.parseQuantity("duration", JsonSupport.getJsonValue(jsonObject, "duration", JsonObject.class), -1));
        JsonArray otherTherapyArray = JsonSupport.getJsonArray(jsonObject, "otherTherapy");
        if (otherTherapyArray != null) {
            for (int i = 0; i < otherTherapyArray.size(); ++i) {
                builder.otherTherapy(this.parseMedicinalProductIndicationOtherTherapy("otherTherapy", otherTherapyArray.getJsonObject(i), i));
            }
        }
        if ((undesirableEffectArray = JsonSupport.getJsonArray(jsonObject, "undesirableEffect")) != null) {
            for (int i = 0; i < undesirableEffectArray.size(); ++i) {
                builder.undesirableEffect(this.parseReference("undesirableEffect", undesirableEffectArray.getJsonObject(i), i));
            }
        }
        if ((populationArray = JsonSupport.getJsonArray(jsonObject, "population")) != null) {
            for (int i = 0; i < populationArray.size(); ++i) {
                builder.population(this.parsePopulation("population", populationArray.getJsonObject(i), i));
            }
        }
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductIndication.OtherTherapy parseMedicinalProductIndicationOtherTherapy(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductIndication.OtherTherapy.class, jsonObject);
        }
        MedicinalProductIndication.OtherTherapy.Builder builder = MedicinalProductIndication.OtherTherapy.builder();
        this.parseBackboneElement(builder, jsonObject);
        builder.therapyRelationshipType(this.parseCodeableConcept("therapyRelationshipType", JsonSupport.getJsonValue(jsonObject, "therapyRelationshipType", JsonObject.class), -1));
        builder.medication(this.parseChoiceElement("medication", jsonObject, CodeableConcept.class, Reference.class));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductIngredient parseMedicinalProductIngredient(String elementName, JsonObject jsonObject, int elementIndex) {
        JsonArray specifiedSubstanceArray;
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductIngredient.class, jsonObject);
        }
        MedicinalProductIngredient.Builder builder = MedicinalProductIngredient.builder();
        this.parseDomainResource(builder, jsonObject);
        builder.identifier(this.parseIdentifier("identifier", JsonSupport.getJsonValue(jsonObject, "identifier", JsonObject.class), -1));
        builder.role(this.parseCodeableConcept("role", JsonSupport.getJsonValue(jsonObject, "role", JsonObject.class), -1));
        builder.allergenicIndicator(this.parseBoolean("allergenicIndicator", JsonSupport.getJsonValue(jsonObject, "allergenicIndicator", JsonValue.class), (JsonValue)jsonObject.get((Object)"_allergenicIndicator"), -1));
        JsonArray manufacturerArray = JsonSupport.getJsonArray(jsonObject, "manufacturer");
        if (manufacturerArray != null) {
            for (int i = 0; i < manufacturerArray.size(); ++i) {
                builder.manufacturer(this.parseReference("manufacturer", manufacturerArray.getJsonObject(i), i));
            }
        }
        if ((specifiedSubstanceArray = JsonSupport.getJsonArray(jsonObject, "specifiedSubstance")) != null) {
            for (int i = 0; i < specifiedSubstanceArray.size(); ++i) {
                builder.specifiedSubstance(this.parseMedicinalProductIngredientSpecifiedSubstance("specifiedSubstance", specifiedSubstanceArray.getJsonObject(i), i));
            }
        }
        builder.substance(this.parseMedicinalProductIngredientSubstance("substance", JsonSupport.getJsonValue(jsonObject, "substance", JsonObject.class), -1));
        this.stackPop();
        return builder.build();
    }

    private MedicinalProductIngredient.SpecifiedSubstance parseMedicinalProductIngredientSpecifiedSubstance(String elementName, JsonObject jsonObject, int elementIndex) {
        if (jsonObject == null) {
            return null;
        }
        this.stackPush(elementName, elementIndex);
        if (!this.getPropertyOrDefault("com.ibm.fhir.model.parser.ignoreUnrecognizedElements", java.lang.Boolean.FALSE, java.lang.Boolean.class).booleanValue()) {
            JsonSupport.checkForUnrecognizedElements(MedicinalProductIngredient.Sp