/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.patch;

import com.ibm.fhir.model.format.Format;
import com.ibm.fhir.model.generator.exception.FHIRGeneratorException;
import com.ibm.fhir.model.parser.FHIRJsonParser;
import com.ibm.fhir.model.parser.FHIRParser;
import com.ibm.fhir.model.parser.exception.FHIRParserException;
import com.ibm.fhir.model.patch.FHIRPatch;
import com.ibm.fhir.model.patch.exception.FHIRPatchException;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.util.JsonSupport;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonStructure;
import javax.json.spi.JsonProvider;

public class FHIRJsonPatch
implements FHIRPatch {
    private static final JsonProvider PROVIDER = JsonProvider.provider();
    private final JsonPatch patch;

    FHIRJsonPatch(JsonArray array) {
        this(PROVIDER.createPatch(array));
    }

    FHIRJsonPatch(JsonPatch patch) {
        this.patch = Objects.requireNonNull(patch);
    }

    public JsonPatch getJsonPatch() {
        return this.patch;
    }

    @Override
    public <T extends Resource> T apply(T resource) throws FHIRPatchException {
        try {
            JsonObject object = JsonSupport.toJsonObject(resource);
            return FHIRParser.parser(Format.JSON).as(FHIRJsonParser.class).parse((JsonObject)this.patch.apply((JsonStructure)object));
        }
        catch (JsonException e) {
            throw new FHIRPatchException(e.getMessage(), e);
        }
        catch (FHIRGeneratorException e) {
            throw new FHIRPatchException(e.getMessage(), e.getPath(), (Throwable)((Object)e));
        }
        catch (FHIRParserException e) {
            throw new FHIRPatchException(e.getMessage(), e.getPath(), (Throwable)((Object)e));
        }
    }
}

