/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.ActivityDefinitionKind;
import com.ibm.fhir.model.type.code.ActivityParticipantType;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.RequestIntent;
import com.ibm.fhir.model.type.code.RequestPriority;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="adf-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')"), @Constraint(id="activityDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", generated=true), @Constraint(id="activityDefinition-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", generated=true)})
public class ActivityDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The possible types of subjects for an activity (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.ValueSet.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<Canonical> library;
    @Summary
    @Binding(bindingName="ActivityDefinitionKind", strength=BindingStrength.ValueSet.REQUIRED, description="The kind of activity the definition is describing.", valueSet="http://hl7.org/fhir/ValueSet/request-resource-types|4.0.1")
    private final ActivityDefinitionKind kind;
    private final Canonical profile;
    @Summary
    @Binding(bindingName="ActivityDefinitionType", strength=BindingStrength.ValueSet.EXAMPLE, description="Detailed type of the activity; e.g. CBC.", valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    private final CodeableConcept code;
    @Binding(bindingName="RequestIntent", strength=BindingStrength.ValueSet.REQUIRED, description="Codes indicating the degree of authority/intentionality associated with a request.", valueSet="http://hl7.org/fhir/ValueSet/request-intent|4.0.1")
    private final RequestIntent intent;
    @Binding(bindingName="RequestPriority", strength=BindingStrength.ValueSet.REQUIRED, description="Identifies the level of importance to be assigned to actioning the request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final RequestPriority priority;
    @Summary
    private final Boolean doNotPerform;
    @Choice(value={Timing.class, DateTime.class, Age.class, Period.class, Range.class, Duration.class})
    private final Element timing;
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    private final List<Participant> participant;
    @ReferenceTarget(value={"Medication", "Substance"})
    @Choice(value={Reference.class, CodeableConcept.class})
    @Binding(bindingName="ActivityProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="Code describing the type of substance or medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    private final Element product;
    private final SimpleQuantity quantity;
    private final List<Dosage> dosage;
    @Binding(bindingName="BodySite", strength=BindingStrength.ValueSet.EXAMPLE, description="A code that identifies the anatomical location.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final List<CodeableConcept> bodySite;
    @ReferenceTarget(value={"SpecimenDefinition"})
    private final List<Reference> specimenRequirement;
    @ReferenceTarget(value={"ObservationDefinition"})
    private final List<Reference> observationRequirement;
    @ReferenceTarget(value={"ObservationDefinition"})
    private final List<Reference> observationResultRequirement;
    private final Canonical transform;
    private final List<DynamicValue> dynamicValue;
    private volatile int hashCode;

    private ActivityDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.experimental = builder.experimental;
        this.subject = ValidationSupport.choiceElement(builder.subject, "subject", CodeableConcept.class, Reference.class);
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactDetail.class));
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(ValidationSupport.checkList(builder.useContext, "useContext", UsageContext.class));
        this.jurisdiction = Collections.unmodifiableList(ValidationSupport.checkList(builder.jurisdiction, "jurisdiction", CodeableConcept.class));
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(ValidationSupport.checkList(builder.topic, "topic", CodeableConcept.class));
        this.author = Collections.unmodifiableList(ValidationSupport.checkList(builder.author, "author", ContactDetail.class));
        this.editor = Collections.unmodifiableList(ValidationSupport.checkList(builder.editor, "editor", ContactDetail.class));
        this.reviewer = Collections.unmodifiableList(ValidationSupport.checkList(builder.reviewer, "reviewer", ContactDetail.class));
        this.endorser = Collections.unmodifiableList(ValidationSupport.checkList(builder.endorser, "endorser", ContactDetail.class));
        this.relatedArtifact = Collections.unmodifiableList(ValidationSupport.checkList(builder.relatedArtifact, "relatedArtifact", RelatedArtifact.class));
        this.library = Collections.unmodifiableList(ValidationSupport.checkList(builder.library, "library", Canonical.class));
        this.kind = builder.kind;
        this.profile = builder.profile;
        this.code = builder.code;
        this.intent = builder.intent;
        this.priority = builder.priority;
        this.doNotPerform = builder.doNotPerform;
        this.timing = ValidationSupport.choiceElement(builder.timing, "timing", Timing.class, DateTime.class, Age.class, Period.class, Range.class, Duration.class);
        this.location = builder.location;
        this.participant = Collections.unmodifiableList(ValidationSupport.checkList(builder.participant, "participant", Participant.class));
        this.product = ValidationSupport.choiceElement(builder.product, "product", Reference.class, CodeableConcept.class);
        this.quantity = builder.quantity;
        this.dosage = Collections.unmodifiableList(ValidationSupport.checkList(builder.dosage, "dosage", Dosage.class));
        this.bodySite = Collections.unmodifiableList(ValidationSupport.checkList(builder.bodySite, "bodySite", CodeableConcept.class));
        this.specimenRequirement = Collections.unmodifiableList(ValidationSupport.checkList(builder.specimenRequirement, "specimenRequirement", Reference.class));
        this.observationRequirement = Collections.unmodifiableList(ValidationSupport.checkList(builder.observationRequirement, "observationRequirement", Reference.class));
        this.observationResultRequirement = Collections.unmodifiableList(ValidationSupport.checkList(builder.observationResultRequirement, "observationResultRequirement", Reference.class));
        this.transform = builder.transform;
        this.dynamicValue = Collections.unmodifiableList(ValidationSupport.checkList(builder.dynamicValue, "dynamicValue", DynamicValue.class));
        ValidationSupport.checkReferenceType(this.subject, "subject", "Group");
        ValidationSupport.checkReferenceType(this.location, "location", "Location");
        ValidationSupport.checkReferenceType(this.product, "product", "Medication", "Substance");
        ValidationSupport.checkReferenceType(this.specimenRequirement, "specimenRequirement", "SpecimenDefinition");
        ValidationSupport.checkReferenceType(this.observationRequirement, "observationRequirement", "ObservationDefinition");
        ValidationSupport.checkReferenceType(this.observationResultRequirement, "observationResultRequirement", "ObservationDefinition");
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<Canonical> getLibrary() {
        return this.library;
    }

    public ActivityDefinitionKind getKind() {
        return this.kind;
    }

    public Canonical getProfile() {
        return this.profile;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public RequestIntent getIntent() {
        return this.intent;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public Boolean getDoNotPerform() {
        return this.doNotPerform;
    }

    public Element getTiming() {
        return this.timing;
    }

    public Reference getLocation() {
        return this.location;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public Element getProduct() {
        return this.product;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public List<Dosage> getDosage() {
        return this.dosage;
    }

    public List<CodeableConcept> getBodySite() {
        return this.bodySite;
    }

    public List<Reference> getSpecimenRequirement() {
        return this.specimenRequirement;
    }

    public List<Reference> getObservationRequirement() {
        return this.observationRequirement;
    }

    public List<Reference> getObservationResultRequirement() {
        return this.observationResultRequirement;
    }

    public Canonical getTransform() {
        return this.transform;
    }

    public List<DynamicValue> getDynamicValue() {
        return this.dynamicValue;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.subtitle != null || this.status != null || this.experimental != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.library.isEmpty() || this.kind != null || this.profile != null || this.code != null || this.intent != null || this.priority != null || this.doNotPerform != null || this.timing != null || this.location != null || !this.participant.isEmpty() || this.product != null || this.quantity != null || !this.dosage.isEmpty() || !this.bodySite.isEmpty() || !this.specimenRequirement.isEmpty() || !this.observationRequirement.isEmpty() || !this.observationResultRequirement.isEmpty() || this.transform != null || !this.dynamicValue.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.library, "library", visitor, Canonical.class);
                this.accept(this.kind, "kind", visitor);
                this.accept(this.profile, "profile", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.doNotPerform, "doNotPerform", visitor);
                this.accept(this.timing, "timing", visitor);
                this.accept(this.location, "location", visitor);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.product, "product", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.dosage, "dosage", visitor, Dosage.class);
                this.accept(this.bodySite, "bodySite", visitor, CodeableConcept.class);
                this.accept(this.specimenRequirement, "specimenRequirement", visitor, Reference.class);
                this.accept(this.observationRequirement, "observationRequirement", visitor, Reference.class);
                this.accept(this.observationResultRequirement, "observationResultRequirement", visitor, Reference.class);
                this.accept(this.transform, "transform", visitor);
                this.accept(this.dynamicValue, "dynamicValue", visitor, DynamicValue.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityDefinition other = (ActivityDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.library, other.library) && Objects.equals(this.kind, other.kind) && Objects.equals(this.profile, other.profile) && Objects.equals(this.code, other.code) && Objects.equals(this.intent, other.intent) && Objects.equals(this.priority, other.priority) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.timing, other.timing) && Objects.equals(this.location, other.location) && Objects.equals(this.participant, other.participant) && Objects.equals(this.product, other.product) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.dosage, other.dosage) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.specimenRequirement, other.specimenRequirement) && Objects.equals(this.observationRequirement, other.observationRequirement) && Objects.equals(this.observationResultRequirement, other.observationResultRequirement) && Objects.equals(this.transform, other.transform) && Objects.equals(this.dynamicValue, other.dynamicValue);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.kind, this.profile, this.code, this.intent, this.priority, this.doNotPerform, this.timing, this.location, this.participant, this.product, this.quantity, this.dosage, this.bodySite, this.specimenRequirement, this.observationRequirement, this.observationResultRequirement, this.transform, this.dynamicValue);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DynamicValue
    extends BackboneElement {
        @Required
        private final String path;
        @Required
        private final Expression expression;
        private volatile int hashCode;

        private DynamicValue(Builder builder) {
            super(builder);
            this.path = ValidationSupport.requireNonNull(builder.path, "path");
            this.expression = ValidationSupport.requireNonNull(builder.expression, "expression");
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getPath() {
            return this.path;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.expression != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.expression, "expression", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DynamicValue other = (DynamicValue)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.expression, other.expression);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.expression);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private Expression expression;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder expression(Expression expression) {
                this.expression = expression;
                return this;
            }

            @Override
            public DynamicValue build() {
                return new DynamicValue(this);
            }

            protected Builder from(DynamicValue dynamicValue) {
                super.from(dynamicValue);
                this.path = dynamicValue.path;
                this.expression = dynamicValue.expression;
                return this;
            }
        }
    }

    public static class Participant
    extends BackboneElement {
        @Binding(bindingName="ActivityParticipantType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of participant in the activity.", valueSet="http://hl7.org/fhir/ValueSet/action-participant-type|4.0.1")
        @Required
        private final ActivityParticipantType type;
        @Binding(bindingName="ActivityParticipantRole", strength=BindingStrength.ValueSet.EXAMPLE, description="Defines roles played by participants for the action.", valueSet="http://hl7.org/fhir/ValueSet/action-participant-role")
        private final CodeableConcept role;
        private volatile int hashCode;

        private Participant(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.role = builder.role;
            ValidationSupport.requireValueOrChildren(this);
        }

        public ActivityParticipantType getType() {
            return this.type;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.role != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.role, "role", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.role, other.role);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.role);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ActivityParticipantType type;
            private CodeableConcept role;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(ActivityParticipantType type) {
                this.type = type;
                return this;
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            @Override
            public Participant build() {
                return new Participant(this);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.type = participant.type;
                this.role = participant.role;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private String subtitle;
        private PublicationStatus status;
        private Boolean experimental;
        private Element subject;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<Canonical> library = new ArrayList<Canonical>();
        private ActivityDefinitionKind kind;
        private Canonical profile;
        private CodeableConcept code;
        private RequestIntent intent;
        private RequestPriority priority;
        private Boolean doNotPerform;
        private Element timing;
        private Reference location;
        private List<Participant> participant = new ArrayList<Participant>();
        private Element product;
        private SimpleQuantity quantity;
        private List<Dosage> dosage = new ArrayList<Dosage>();
        private List<CodeableConcept> bodySite = new ArrayList<CodeableConcept>();
        private List<Reference> specimenRequirement = new ArrayList<Reference>();
        private List<Reference> observationRequirement = new ArrayList<Reference>();
        private List<Reference> observationResultRequirement = new ArrayList<Reference>();
        private Canonical transform;
        private List<DynamicValue> dynamicValue = new ArrayList<DynamicValue>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder library(Canonical ... library) {
            for (Canonical value : library) {
                this.library.add(value);
            }
            return this;
        }

        public Builder library(Collection<Canonical> library) {
            this.library = new ArrayList<Canonical>(library);
            return this;
        }

        public Builder kind(ActivityDefinitionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder profile(Canonical profile) {
            this.profile = profile;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder intent(RequestIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder priority(RequestPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder doNotPerform(Boolean doNotPerform) {
            this.doNotPerform = doNotPerform;
            return this;
        }

        public Builder timing(Element timing) {
            this.timing = timing;
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder product(Element product) {
            this.product = product;
            return this;
        }

        public Builder quantity(SimpleQuantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder dosage(Dosage ... dosage) {
            for (Dosage value : dosage) {
                this.dosage.add(value);
            }
            return this;
        }

        public Builder dosage(Collection<Dosage> dosage) {
            this.dosage = new ArrayList<Dosage>(dosage);
            return this;
        }

        public Builder bodySite(CodeableConcept ... bodySite) {
            for (CodeableConcept value : bodySite) {
                this.bodySite.add(value);
            }
            return this;
        }

        public Builder bodySite(Collection<CodeableConcept> bodySite) {
            this.bodySite = new ArrayList<CodeableConcept>(bodySite);
            return this;
        }

        public Builder specimenRequirement(Reference ... specimenRequirement) {
            for (Reference value : specimenRequirement) {
                this.specimenRequirement.add(value);
            }
            return this;
        }

        public Builder specimenRequirement(Collection<Reference> specimenRequirement) {
            this.specimenRequirement = new ArrayList<Reference>(specimenRequirement);
            return this;
        }

        public Builder observationRequirement(Reference ... observationRequirement) {
            for (Reference value : observationRequirement) {
                this.observationRequirement.add(value);
            }
            return this;
        }

        public Builder observationRequirement(Collection<Reference> observationRequirement) {
            this.observationRequirement = new ArrayList<Reference>(observationRequirement);
            return this;
        }

        public Builder observationResultRequirement(Reference ... observationResultRequirement) {
            for (Reference value : observationResultRequirement) {
                this.observationResultRequirement.add(value);
            }
            return this;
        }

        public Builder observationResultRequirement(Collection<Reference> observationResultRequirement) {
            this.observationResultRequirement = new ArrayList<Reference>(observationResultRequirement);
            return this;
        }

        public Builder transform(Canonical transform) {
            this.transform = transform;
            return this;
        }

        public Builder dynamicValue(DynamicValue ... dynamicValue) {
            for (DynamicValue value : dynamicValue) {
                this.dynamicValue.add(value);
            }
            return this;
        }

        public Builder dynamicValue(Collection<DynamicValue> dynamicValue) {
            this.dynamicValue = new ArrayList<DynamicValue>(dynamicValue);
            return this;
        }

        @Override
        public ActivityDefinition build() {
            return new ActivityDefinition(this);
        }

        protected Builder from(ActivityDefinition activityDefinition) {
            super.from(activityDefinition);
            this.url = activityDefinition.url;
            this.identifier.addAll(activityDefinition.identifier);
            this.version = activityDefinition.version;
            this.name = activityDefinition.name;
            this.title = activityDefinition.title;
            this.subtitle = activityDefinition.subtitle;
            this.status = activityDefinition.status;
            this.experimental = activityDefinition.experimental;
            this.subject = activityDefinition.subject;
            this.date = activityDefinition.date;
            this.publisher = activityDefinition.publisher;
            this.contact.addAll(activityDefinition.contact);
            this.description = activityDefinition.description;
            this.useContext.addAll(activityDefinition.useContext);
            this.jurisdiction.addAll(activityDefinition.jurisdiction);
            this.purpose = activityDefinition.purpose;
            this.usage = activityDefinition.usage;
            this.copyright = activityDefinition.copyright;
            this.approvalDate = activityDefinition.approvalDate;
            this.lastReviewDate = activityDefinition.lastReviewDate;
            this.effectivePeriod = activityDefinition.effectivePeriod;
            this.topic.addAll(activityDefinition.topic);
            this.author.addAll(activityDefinition.author);
            this.editor.addAll(activityDefinition.editor);
            this.reviewer.addAll(activityDefinition.reviewer);
            this.endorser.addAll(activityDefinition.endorser);
            this.relatedArtifact.addAll(activityDefinition.relatedArtifact);
            this.library.addAll(activityDefinition.library);
            this.kind = activityDefinition.kind;
            this.profile = activityDefinition.profile;
            this.code = activityDefinition.code;
            this.intent = activityDefinition.intent;
            this.priority = activityDefinition.priority;
            this.doNotPerform = activityDefinition.doNotPerform;
            this.timing = activityDefinition.timing;
            this.location = activityDefinition.location;
            this.participant.addAll(activityDefinition.participant);
            this.product = activityDefinition.product;
            this.quantity = activityDefinition.quantity;
            this.dosage.addAll(activityDefinition.dosage);
            this.bodySite.addAll(activityDefinition.bodySite);
            this.specimenRequirement.addAll(activityDefinition.specimenRequirement);
            this.observationRequirement.addAll(activityDefinition.observationRequirement);
            this.observationResultRequirement.addAll(activityDefinition.observationResultRequirement);
            this.transform = activityDefinition.transform;
            this.dynamicValue.addAll(activityDefinition.dynamicValue);
            return this;
        }
    }
}

