/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCategory;
import com.ibm.fhir.model.type.code.AllergyIntoleranceCriticality;
import com.ibm.fhir.model.type.code.AllergyIntoleranceSeverity;
import com.ibm.fhir.model.type.code.AllergyIntoleranceType;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="ait-1", level="Rule", location="(base)", description="AllergyIntolerance.clinicalStatus SHALL be present if verificationStatus is not entered-in-error.", expression="verificationStatus.coding.where(system = 'http://terminology.hl7.org/CodeSystem/allergyintolerance-verification' and code = 'entered-in-error').exists() or clinicalStatus.exists()"), @Constraint(id="ait-2", level="Rule", location="(base)", description="AllergyIntolerance.clinicalStatus SHALL NOT be present if verification Status is entered-in-error", expression="verificationStatus.coding.where(system = 'http://terminology.hl7.org/CodeSystem/allergyintolerance-verification' and code = 'entered-in-error').empty() or clinicalStatus.empty()")})
public class AllergyIntolerance
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="AllergyIntoleranceClinicalStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The clinical status of the allergy or intolerance.", valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-clinical|4.0.1")
    private final CodeableConcept clinicalStatus;
    @Summary
    @Binding(bindingName="AllergyIntoleranceVerificationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified substance.", valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-verification|4.0.1")
    private final CodeableConcept verificationStatus;
    @Summary
    @Binding(bindingName="AllergyIntoleranceType", strength=BindingStrength.ValueSet.REQUIRED, description="Identification of the underlying physiological mechanism for a Reaction Risk.", valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-type|4.0.1")
    private final AllergyIntoleranceType type;
    @Summary
    @Binding(bindingName="AllergyIntoleranceCategory", strength=BindingStrength.ValueSet.REQUIRED, description="Category of an identified substance associated with allergies or intolerances.", valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-category|4.0.1")
    private final List<AllergyIntoleranceCategory> category;
    @Summary
    @Binding(bindingName="AllergyIntoleranceCriticality", strength=BindingStrength.ValueSet.REQUIRED, description="Estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance.", valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality|4.0.1")
    private final AllergyIntoleranceCriticality criticality;
    @Summary
    @Binding(bindingName="AllergyIntoleranceCode", strength=BindingStrength.ValueSet.EXAMPLE, description="Type of the substance/product, allergy or intolerance condition, or negation/exclusion codes for reporting no known allergies.", valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-code")
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Choice(value={DateTime.class, Age.class, Period.class, Range.class, String.class})
    private final Element onset;
    private final DateTime recordedDate;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Patient", "RelatedPerson"})
    private final Reference recorder;
    @Summary
    @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole"})
    private final Reference asserter;
    private final DateTime lastOccurrence;
    private final List<Annotation> note;
    private final List<Reaction> reaction;
    private volatile int hashCode;

    private AllergyIntolerance(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.clinicalStatus = builder.clinicalStatus;
        this.verificationStatus = builder.verificationStatus;
        this.type = builder.type;
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", AllergyIntoleranceCategory.class));
        this.criticality = builder.criticality;
        this.code = builder.code;
        this.patient = ValidationSupport.requireNonNull(builder.patient, "patient");
        this.encounter = builder.encounter;
        this.onset = ValidationSupport.choiceElement(builder.onset, "onset", DateTime.class, Age.class, Period.class, Range.class, String.class);
        this.recordedDate = builder.recordedDate;
        this.recorder = builder.recorder;
        this.asserter = builder.asserter;
        this.lastOccurrence = builder.lastOccurrence;
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.reaction = Collections.unmodifiableList(ValidationSupport.checkList(builder.reaction, "reaction", Reaction.class));
        ValidationSupport.checkValueSetBinding(this.clinicalStatus, "clinicalStatus", "http://hl7.org/fhir/ValueSet/allergyintolerance-clinical", "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active", "inactive", "resolved");
        ValidationSupport.checkValueSetBinding(this.verificationStatus, "verificationStatus", "http://hl7.org/fhir/ValueSet/allergyintolerance-verification", "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "unconfirmed", "confirmed", "refuted", "entered-in-error");
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.recorder, "recorder", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson");
        ValidationSupport.checkReferenceType(this.asserter, "asserter", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getClinicalStatus() {
        return this.clinicalStatus;
    }

    public CodeableConcept getVerificationStatus() {
        return this.verificationStatus;
    }

    public AllergyIntoleranceType getType() {
        return this.type;
    }

    public List<AllergyIntoleranceCategory> getCategory() {
        return this.category;
    }

    public AllergyIntoleranceCriticality getCriticality() {
        return this.criticality;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOnset() {
        return this.onset;
    }

    public DateTime getRecordedDate() {
        return this.recordedDate;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public Reference getAsserter() {
        return this.asserter;
    }

    public DateTime getLastOccurrence() {
        return this.lastOccurrence;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reaction> getReaction() {
        return this.reaction;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.clinicalStatus != null || this.verificationStatus != null || this.type != null || !this.category.isEmpty() || this.criticality != null || this.code != null || this.patient != null || this.encounter != null || this.onset != null || this.recordedDate != null || this.recorder != null || this.asserter != null || this.lastOccurrence != null || !this.note.isEmpty() || !this.reaction.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.clinicalStatus, "clinicalStatus", visitor);
                this.accept(this.verificationStatus, "verificationStatus", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.category, "category", visitor, AllergyIntoleranceCategory.class);
                this.accept(this.criticality, "criticality", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.onset, "onset", visitor);
                this.accept(this.recordedDate, "recordedDate", visitor);
                this.accept(this.recorder, "recorder", visitor);
                this.accept(this.asserter, "asserter", visitor);
                this.accept(this.lastOccurrence, "lastOccurrence", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.reaction, "reaction", visitor, Reaction.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllergyIntolerance other = (AllergyIntolerance)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.clinicalStatus, other.clinicalStatus) && Objects.equals(this.verificationStatus, other.verificationStatus) && Objects.equals(this.type, other.type) && Objects.equals(this.category, other.category) && Objects.equals(this.criticality, other.criticality) && Objects.equals(this.code, other.code) && Objects.equals(this.patient, other.patient) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.onset, other.onset) && Objects.equals(this.recordedDate, other.recordedDate) && Objects.equals(this.recorder, other.recorder) && Objects.equals(this.asserter, other.asserter) && Objects.equals(this.lastOccurrence, other.lastOccurrence) && Objects.equals(this.note, other.note) && Objects.equals(this.reaction, other.reaction);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.clinicalStatus, this.verificationStatus, this.type, this.category, this.criticality, this.code, this.patient, this.encounter, this.onset, this.recordedDate, this.recorder, this.asserter, this.lastOccurrence, this.note, this.reaction);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Reaction
    extends BackboneElement {
        @Binding(bindingName="SubstanceCode", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes defining the type of the substance (including pharmaceutical products).", valueSet="http://hl7.org/fhir/ValueSet/substance-code")
        private final CodeableConcept substance;
        @Binding(bindingName="Manifestation", strength=BindingStrength.ValueSet.EXAMPLE, description="Clinical symptoms and/or signs that are observed or associated with an Adverse Reaction Event.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        @Required
        private final List<CodeableConcept> manifestation;
        private final String description;
        private final DateTime onset;
        @Binding(bindingName="AllergyIntoleranceSeverity", strength=BindingStrength.ValueSet.REQUIRED, description="Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.", valueSet="http://hl7.org/fhir/ValueSet/reaction-event-severity|4.0.1")
        private final AllergyIntoleranceSeverity severity;
        @Binding(bindingName="RouteOfAdministration", strength=BindingStrength.ValueSet.EXAMPLE, description="A coded concept describing the route or physiological path of administration of a therapeutic agent into or onto the body of a subject.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        private final CodeableConcept exposureRoute;
        private final List<Annotation> note;
        private volatile int hashCode;

        private Reaction(Builder builder) {
            super(builder);
            this.substance = builder.substance;
            this.manifestation = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.manifestation, "manifestation", CodeableConcept.class));
            this.description = builder.description;
            this.onset = builder.onset;
            this.severity = builder.severity;
            this.exposureRoute = builder.exposureRoute;
            this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getSubstance() {
            return this.substance;
        }

        public List<CodeableConcept> getManifestation() {
            return this.manifestation;
        }

        public String getDescription() {
            return this.description;
        }

        public DateTime getOnset() {
            return this.onset;
        }

        public AllergyIntoleranceSeverity getSeverity() {
            return this.severity;
        }

        public CodeableConcept getExposureRoute() {
            return this.exposureRoute;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.substance != null || !this.manifestation.isEmpty() || this.description != null || this.onset != null || this.severity != null || this.exposureRoute != null || !this.note.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.substance, "substance", visitor);
                    this.accept(this.manifestation, "manifestation", visitor, CodeableConcept.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.onset, "onset", visitor);
                    this.accept(this.severity, "severity", visitor);
                    this.accept(this.exposureRoute, "exposureRoute", visitor);
                    this.accept(this.note, "note", visitor, Annotation.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Reaction other = (Reaction)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substance, other.substance) && Objects.equals(this.manifestation, other.manifestation) && Objects.equals(this.description, other.description) && Objects.equals(this.onset, other.onset) && Objects.equals(this.severity, other.severity) && Objects.equals(this.exposureRoute, other.exposureRoute) && Objects.equals(this.note, other.note);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substance, this.manifestation, this.description, this.onset, this.severity, this.exposureRoute, this.note);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept substance;
            private List<CodeableConcept> manifestation = new ArrayList<CodeableConcept>();
            private String description;
            private DateTime onset;
            private AllergyIntoleranceSeverity severity;
            private CodeableConcept exposureRoute;
            private List<Annotation> note = new ArrayList<Annotation>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder substance(CodeableConcept substance) {
                this.substance = substance;
                return this;
            }

            public Builder manifestation(CodeableConcept ... manifestation) {
                for (CodeableConcept value : manifestation) {
                    this.manifestation.add(value);
                }
                return this;
            }

            public Builder manifestation(Collection<CodeableConcept> manifestation) {
                this.manifestation = new ArrayList<CodeableConcept>(manifestation);
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder onset(DateTime onset) {
                this.onset = onset;
                return this;
            }

            public Builder severity(AllergyIntoleranceSeverity severity) {
                this.severity = severity;
                return this;
            }

            public Builder exposureRoute(CodeableConcept exposureRoute) {
                this.exposureRoute = exposureRoute;
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            @Override
            public Reaction build() {
                return new Reaction(this);
            }

            protected Builder from(Reaction reaction) {
                super.from(reaction);
                this.substance = reaction.substance;
                this.manifestation.addAll(reaction.manifestation);
                this.description = reaction.description;
                this.onset = reaction.onset;
                this.severity = reaction.severity;
                this.exposureRoute = reaction.exposureRoute;
                this.note.addAll(reaction.note);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept clinicalStatus;
        private CodeableConcept verificationStatus;
        private AllergyIntoleranceType type;
        private List<AllergyIntoleranceCategory> category = new ArrayList<AllergyIntoleranceCategory>();
        private AllergyIntoleranceCriticality criticality;
        private CodeableConcept code;
        private Reference patient;
        private Reference encounter;
        private Element onset;
        private DateTime recordedDate;
        private Reference recorder;
        private Reference asserter;
        private DateTime lastOccurrence;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reaction> reaction = new ArrayList<Reaction>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder clinicalStatus(CodeableConcept clinicalStatus) {
            this.clinicalStatus = clinicalStatus;
            return this;
        }

        public Builder verificationStatus(CodeableConcept verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        public Builder type(AllergyIntoleranceType type) {
            this.type = type;
            return this;
        }

        public Builder category(AllergyIntoleranceCategory ... category) {
            for (AllergyIntoleranceCategory value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<AllergyIntoleranceCategory> category) {
            this.category = new ArrayList<AllergyIntoleranceCategory>(category);
            return this;
        }

        public Builder criticality(AllergyIntoleranceCriticality criticality) {
            this.criticality = criticality;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder onset(Element onset) {
            this.onset = onset;
            return this;
        }

        public Builder recordedDate(DateTime recordedDate) {
            this.recordedDate = recordedDate;
            return this;
        }

        public Builder recorder(Reference recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder asserter(Reference asserter) {
            this.asserter = asserter;
            return this;
        }

        public Builder lastOccurrence(DateTime lastOccurrence) {
            this.lastOccurrence = lastOccurrence;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder reaction(Reaction ... reaction) {
            for (Reaction value : reaction) {
                this.reaction.add(value);
            }
            return this;
        }

        public Builder reaction(Collection<Reaction> reaction) {
            this.reaction = new ArrayList<Reaction>(reaction);
            return this;
        }

        @Override
        public AllergyIntolerance build() {
            return new AllergyIntolerance(this);
        }

        protected Builder from(AllergyIntolerance allergyIntolerance) {
            super.from(allergyIntolerance);
            this.identifier.addAll(allergyIntolerance.identifier);
            this.clinicalStatus = allergyIntolerance.clinicalStatus;
            this.verificationStatus = allergyIntolerance.verificationStatus;
            this.type = allergyIntolerance.type;
            this.category.addAll(allergyIntolerance.category);
            this.criticality = allergyIntolerance.criticality;
            this.code = allergyIntolerance.code;
            this.patient = allergyIntolerance.patient;
            this.encounter = allergyIntolerance.encounter;
            this.onset = allergyIntolerance.onset;
            this.recordedDate = allergyIntolerance.recordedDate;
            this.recorder = allergyIntolerance.recorder;
            this.asserter = allergyIntolerance.asserter;
            this.lastOccurrence = allergyIntolerance.lastOccurrence;
            this.note.addAll(allergyIntolerance.note);
            this.reaction.addAll(allergyIntolerance.reaction);
            return this;
        }
    }
}

