/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.ValueSet.NORMATIVE)
public class Binary
extends Resource {
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.ValueSet.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    @Required
    private final Code contentType;
    @Summary
    private final Reference securityContext;
    private final Base64Binary data;
    private volatile int hashCode;

    private Binary(Builder builder) {
        super(builder);
        this.contentType = ValidationSupport.requireNonNull(builder.contentType, "contentType");
        this.securityContext = builder.securityContext;
        this.data = builder.data;
    }

    public Code getContentType() {
        return this.contentType;
    }

    public Reference getSecurityContext() {
        return this.securityContext;
    }

    public Base64Binary getData() {
        return this.data;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.contentType != null || this.securityContext != null || this.data != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.contentType, "contentType", visitor);
                this.accept(this.securityContext, "securityContext", visitor);
                this.accept(this.data, "data", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binary other = (Binary)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.securityContext, other.securityContext) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.contentType, this.securityContext, this.data);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Resource.Builder {
        private Code contentType;
        private Reference securityContext;
        private Base64Binary data;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        public Builder contentType(Code contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder securityContext(Reference securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public Builder data(Base64Binary data) {
            this.data = data;
            return this;
        }

        @Override
        public Binary build() {
            return new Binary(this);
        }

        protected Builder from(Binary binary) {
            super.from(binary);
            this.contentType = binary.contentType;
            this.securityContext = binary.securityContext;
            this.data = binary.data;
            return this;
        }
    }
}

