/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CarePlanActivityKind;
import com.ibm.fhir.model.type.code.CarePlanActivityStatus;
import com.ibm.fhir.model.type.code.CarePlanIntent;
import com.ibm.fhir.model.type.code.CarePlanStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="cpl-3", level="Rule", location="CarePlan.activity", description="Provide a reference or detail, not both", expression="detail.empty() or reference.empty()")
public class CarePlan
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Canonical> instantiatesCanonical;
    @Summary
    private final List<Uri> instantiatesUri;
    @Summary
    @ReferenceTarget(value={"CarePlan"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"CarePlan"})
    private final List<Reference> replaces;
    @Summary
    @ReferenceTarget(value={"CarePlan"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="CarePlanStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.0.1")
    @Required
    private final CarePlanStatus status;
    @Summary
    @Binding(bindingName="CarePlanIntent", strength=BindingStrength.ValueSet.REQUIRED, description="Codes indicating the degree of authority/intentionality associated with a care plan.", valueSet="http://hl7.org/fhir/ValueSet/care-plan-intent|4.0.1")
    @Required
    private final CarePlanIntent intent;
    @Summary
    @Binding(bindingName="CarePlanCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", etc.", valueSet="http://hl7.org/fhir/ValueSet/care-plan-category")
    private final List<CodeableConcept> category;
    @Summary
    private final String title;
    @Summary
    private final String description;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final Period period;
    @Summary
    private final DateTime created;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Device", "RelatedPerson", "Organization", "CareTeam"})
    private final Reference author;
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Device", "RelatedPerson", "Organization", "CareTeam"})
    private final List<Reference> contributor;
    @ReferenceTarget(value={"CareTeam"})
    private final List<Reference> careTeam;
    @Summary
    @ReferenceTarget(value={"Condition"})
    private final List<Reference> addresses;
    private final List<Reference> supportingInfo;
    @ReferenceTarget(value={"Goal"})
    private final List<Reference> goal;
    private final List<Activity> activity;
    private final List<Annotation> note;
    private volatile int hashCode;

    private CarePlan(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.instantiatesCanonical = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesCanonical, "instantiatesCanonical", Canonical.class));
        this.instantiatesUri = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesUri, "instantiatesUri", Uri.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.replaces = Collections.unmodifiableList(ValidationSupport.checkList(builder.replaces, "replaces", Reference.class));
        this.partOf = Collections.unmodifiableList(ValidationSupport.checkList(builder.partOf, "partOf", Reference.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.intent = ValidationSupport.requireNonNull(builder.intent, "intent");
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", CodeableConcept.class));
        this.title = builder.title;
        this.description = builder.description;
        this.subject = ValidationSupport.requireNonNull(builder.subject, "subject");
        this.encounter = builder.encounter;
        this.period = builder.period;
        this.created = builder.created;
        this.author = builder.author;
        this.contributor = Collections.unmodifiableList(ValidationSupport.checkList(builder.contributor, "contributor", Reference.class));
        this.careTeam = Collections.unmodifiableList(ValidationSupport.checkList(builder.careTeam, "careTeam", Reference.class));
        this.addresses = Collections.unmodifiableList(ValidationSupport.checkList(builder.addresses, "addresses", Reference.class));
        this.supportingInfo = Collections.unmodifiableList(ValidationSupport.checkList(builder.supportingInfo, "supportingInfo", Reference.class));
        this.goal = Collections.unmodifiableList(ValidationSupport.checkList(builder.goal, "goal", Reference.class));
        this.activity = Collections.unmodifiableList(ValidationSupport.checkList(builder.activity, "activity", Activity.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "CarePlan");
        ValidationSupport.checkReferenceType(this.replaces, "replaces", "CarePlan");
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "CarePlan");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.author, "author", "Patient", "Practitioner", "PractitionerRole", "Device", "RelatedPerson", "Organization", "CareTeam");
        ValidationSupport.checkReferenceType(this.contributor, "contributor", "Patient", "Practitioner", "PractitionerRole", "Device", "RelatedPerson", "Organization", "CareTeam");
        ValidationSupport.checkReferenceType(this.careTeam, "careTeam", "CareTeam");
        ValidationSupport.checkReferenceType(this.addresses, "addresses", "Condition");
        ValidationSupport.checkReferenceType(this.goal, "goal", "Goal");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Canonical> getInstantiatesCanonical() {
        return this.instantiatesCanonical;
    }

    public List<Uri> getInstantiatesUri() {
        return this.instantiatesUri;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getReplaces() {
        return this.replaces;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public CarePlanStatus getStatus() {
        return this.status;
    }

    public CarePlanIntent getIntent() {
        return this.intent;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Period getPeriod() {
        return this.period;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public List<Reference> getContributor() {
        return this.contributor;
    }

    public List<Reference> getCareTeam() {
        return this.careTeam;
    }

    public List<Reference> getAddresses() {
        return this.addresses;
    }

    public List<Reference> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Reference> getGoal() {
        return this.goal;
    }

    public List<Activity> getActivity() {
        return this.activity;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || !this.basedOn.isEmpty() || !this.replaces.isEmpty() || !this.partOf.isEmpty() || this.status != null || this.intent != null || !this.category.isEmpty() || this.title != null || this.description != null || this.subject != null || this.encounter != null || this.period != null || this.created != null || this.author != null || !this.contributor.isEmpty() || !this.careTeam.isEmpty() || !this.addresses.isEmpty() || !this.supportingInfo.isEmpty() || !this.goal.isEmpty() || !this.activity.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.replaces, "replaces", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.intent, "intent", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.title, "title", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.contributor, "contributor", visitor, Reference.class);
                this.accept(this.careTeam, "careTeam", visitor, Reference.class);
                this.accept(this.addresses, "addresses", visitor, Reference.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, Reference.class);
                this.accept(this.goal, "goal", visitor, Reference.class);
                this.accept(this.activity, "activity", visitor, Activity.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CarePlan other = (CarePlan)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.intent, other.intent) && Objects.equals(this.category, other.category) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.period, other.period) && Objects.equals(this.created, other.created) && Objects.equals(this.author, other.author) && Objects.equals(this.contributor, other.contributor) && Objects.equals(this.careTeam, other.careTeam) && Objects.equals(this.addresses, other.addresses) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.goal, other.goal) && Objects.equals(this.activity, other.activity) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.basedOn, this.replaces, this.partOf, this.status, this.intent, this.category, this.title, this.description, this.subject, this.encounter, this.period, this.created, this.author, this.contributor, this.careTeam, this.addresses, this.supportingInfo, this.goal, this.activity, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Activity
    extends BackboneElement {
        @Binding(bindingName="CarePlanActivityOutcome", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies the results of the activity.", valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-outcome")
        private final List<CodeableConcept> outcomeCodeableConcept;
        private final List<Reference> outcomeReference;
        private final List<Annotation> progress;
        @ReferenceTarget(value={"Appointment", "CommunicationRequest", "DeviceRequest", "MedicationRequest", "NutritionOrder", "Task", "ServiceRequest", "VisionPrescription", "RequestGroup"})
        private final Reference reference;
        private final Detail detail;
        private volatile int hashCode;

        private Activity(Builder builder) {
            super(builder);
            this.outcomeCodeableConcept = Collections.unmodifiableList(ValidationSupport.checkList(builder.outcomeCodeableConcept, "outcomeCodeableConcept", CodeableConcept.class));
            this.outcomeReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.outcomeReference, "outcomeReference", Reference.class));
            this.progress = Collections.unmodifiableList(ValidationSupport.checkList(builder.progress, "progress", Annotation.class));
            this.reference = builder.reference;
            this.detail = builder.detail;
            ValidationSupport.checkReferenceType(this.reference, "reference", "Appointment", "CommunicationRequest", "DeviceRequest", "MedicationRequest", "NutritionOrder", "Task", "ServiceRequest", "VisionPrescription", "RequestGroup");
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<CodeableConcept> getOutcomeCodeableConcept() {
            return this.outcomeCodeableConcept;
        }

        public List<Reference> getOutcomeReference() {
            return this.outcomeReference;
        }

        public List<Annotation> getProgress() {
            return this.progress;
        }

        public Reference getReference() {
            return this.reference;
        }

        public Detail getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.outcomeCodeableConcept.isEmpty() || !this.outcomeReference.isEmpty() || !this.progress.isEmpty() || this.reference != null || this.detail != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.outcomeCodeableConcept, "outcomeCodeableConcept", visitor, CodeableConcept.class);
                    this.accept(this.outcomeReference, "outcomeReference", visitor, Reference.class);
                    this.accept(this.progress, "progress", visitor, Annotation.class);
                    this.accept(this.reference, "reference", visitor);
                    this.accept(this.detail, "detail", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Activity other = (Activity)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.outcomeCodeableConcept, other.outcomeCodeableConcept) && Objects.equals(this.outcomeReference, other.outcomeReference) && Objects.equals(this.progress, other.progress) && Objects.equals(this.reference, other.reference) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.outcomeCodeableConcept, this.outcomeReference, this.progress, this.reference, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Detail
        extends BackboneElement {
            @Binding(bindingName="CarePlanActivityKind", strength=BindingStrength.ValueSet.REQUIRED, description="Resource types defined as part of FHIR that can be represented as in-line definitions of a care plan activity.", valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-kind|4.0.1")
            private final CarePlanActivityKind kind;
            private final List<Canonical> instantiatesCanonical;
            private final List<Uri> instantiatesUri;
            @Binding(bindingName="CarePlanActivityType", strength=BindingStrength.ValueSet.EXAMPLE, description="Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
            private final CodeableConcept code;
            @Binding(bindingName="CarePlanActivityReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Identifies why a care plan activity is needed.  Can include any health condition codes as well as such concepts as \"general wellness\", prophylaxis, surgical preparation, etc.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
            private final List<CodeableConcept> reasonCode;
            @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
            private final List<Reference> reasonReference;
            @ReferenceTarget(value={"Goal"})
            private final List<Reference> goal;
            @Binding(bindingName="CarePlanActivityStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Codes that reflect the current state of a care plan activity within its overall life cycle.", valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-status|4.0.1")
            @Required
            private final CarePlanActivityStatus status;
            private final CodeableConcept statusReason;
            private final Boolean doNotPerform;
            @Choice(value={Timing.class, Period.class, String.class})
            private final Element scheduled;
            @ReferenceTarget(value={"Location"})
            private final Reference location;
            @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "RelatedPerson", "Patient", "CareTeam", "HealthcareService", "Device"})
            private final List<Reference> performer;
            @ReferenceTarget(value={"Medication", "Substance"})
            @Choice(value={CodeableConcept.class, Reference.class})
            @Binding(bindingName="CarePlanProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="A product supplied or administered as part of a care plan activity.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
            private final Element product;
            private final SimpleQuantity dailyAmount;
            private final SimpleQuantity quantity;
            private final String description;
            private volatile int hashCode;

            private Detail(Builder builder) {
                super(builder);
                this.kind = builder.kind;
                this.instantiatesCanonical = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesCanonical, "instantiatesCanonical", Canonical.class));
                this.instantiatesUri = Collections.unmodifiableList(ValidationSupport.checkList(builder.instantiatesUri, "instantiatesUri", Uri.class));
                this.code = builder.code;
                this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
                this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
                this.goal = Collections.unmodifiableList(ValidationSupport.checkList(builder.goal, "goal", Reference.class));
                this.status = ValidationSupport.requireNonNull(builder.status, "status");
                this.statusReason = builder.statusReason;
                this.doNotPerform = builder.doNotPerform;
                this.scheduled = ValidationSupport.choiceElement(builder.scheduled, "scheduled", Timing.class, Period.class, String.class);
                this.location = builder.location;
                this.performer = Collections.unmodifiableList(ValidationSupport.checkList(builder.performer, "performer", Reference.class));
                this.product = ValidationSupport.choiceElement(builder.product, "product", CodeableConcept.class, Reference.class);
                this.dailyAmount = builder.dailyAmount;
                this.quantity = builder.quantity;
                this.description = builder.description;
                ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
                ValidationSupport.checkReferenceType(this.goal, "goal", "Goal");
                ValidationSupport.checkReferenceType(this.location, "location", "Location");
                ValidationSupport.checkReferenceType(this.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "RelatedPerson", "Patient", "CareTeam", "HealthcareService", "Device");
                ValidationSupport.checkReferenceType(this.product, "product", "Medication", "Substance");
                ValidationSupport.requireValueOrChildren(this);
            }

            public CarePlanActivityKind getKind() {
                return this.kind;
            }

            public List<Canonical> getInstantiatesCanonical() {
                return this.instantiatesCanonical;
            }

            public List<Uri> getInstantiatesUri() {
                return this.instantiatesUri;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public List<CodeableConcept> getReasonCode() {
                return this.reasonCode;
            }

            public List<Reference> getReasonReference() {
                return this.reasonReference;
            }

            public List<Reference> getGoal() {
                return this.goal;
            }

            public CarePlanActivityStatus getStatus() {
                return this.status;
            }

            public CodeableConcept getStatusReason() {
                return this.statusReason;
            }

            public Boolean getDoNotPerform() {
                return this.doNotPerform;
            }

            public Element getScheduled() {
                return this.scheduled;
            }

            public Reference getLocation() {
                return this.location;
            }

            public List<Reference> getPerformer() {
                return this.performer;
            }

            public Element getProduct() {
                return this.product;
            }

            public SimpleQuantity getDailyAmount() {
                return this.dailyAmount;
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public String getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.kind != null || !this.instantiatesCanonical.isEmpty() || !this.instantiatesUri.isEmpty() || this.code != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.goal.isEmpty() || this.status != null || this.statusReason != null || this.doNotPerform != null || this.scheduled != null || this.location != null || !this.performer.isEmpty() || this.product != null || this.dailyAmount != null || this.quantity != null || this.description != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.kind, "kind", visitor);
                        this.accept(this.instantiatesCanonical, "instantiatesCanonical", visitor, Canonical.class);
                        this.accept(this.instantiatesUri, "instantiatesUri", visitor, Uri.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                        this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                        this.accept(this.goal, "goal", visitor, Reference.class);
                        this.accept(this.status, "status", visitor);
                        this.accept(this.statusReason, "statusReason", visitor);
                        this.accept(this.doNotPerform, "doNotPerform", visitor);
                        this.accept(this.scheduled, "scheduled", visitor);
                        this.accept(this.location, "location", visitor);
                        this.accept(this.performer, "performer", visitor, Reference.class);
                        this.accept(this.product, "product", visitor);
                        this.accept(this.dailyAmount, "dailyAmount", visitor);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Detail other = (Detail)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.kind, other.kind) && Objects.equals(this.instantiatesCanonical, other.instantiatesCanonical) && Objects.equals(this.instantiatesUri, other.instantiatesUri) && Objects.equals(this.code, other.code) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.goal, other.goal) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.scheduled, other.scheduled) && Objects.equals(this.location, other.location) && Objects.equals(this.performer, other.performer) && Objects.equals(this.product, other.product) && Objects.equals(this.dailyAmount, other.dailyAmount) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.kind, this.instantiatesCanonical, this.instantiatesUri, this.code, this.reasonCode, this.reasonReference, this.goal, this.status, this.statusReason, this.doNotPerform, this.scheduled, this.location, this.performer, this.product, this.dailyAmount, this.quantity, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CarePlanActivityKind kind;
                private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
                private List<Uri> instantiatesUri = new ArrayList<Uri>();
                private CodeableConcept code;
                private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
                private List<Reference> reasonReference = new ArrayList<Reference>();
                private List<Reference> goal = new ArrayList<Reference>();
                private CarePlanActivityStatus status;
                private CodeableConcept statusReason;
                private Boolean doNotPerform;
                private Element scheduled;
                private Reference location;
                private List<Reference> performer = new ArrayList<Reference>();
                private Element product;
                private SimpleQuantity dailyAmount;
                private SimpleQuantity quantity;
                private String description;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder kind(CarePlanActivityKind kind) {
                    this.kind = kind;
                    return this;
                }

                public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
                    for (Canonical value : instantiatesCanonical) {
                        this.instantiatesCanonical.add(value);
                    }
                    return this;
                }

                public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
                    this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
                    return this;
                }

                public Builder instantiatesUri(Uri ... instantiatesUri) {
                    for (Uri value : instantiatesUri) {
                        this.instantiatesUri.add(value);
                    }
                    return this;
                }

                public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
                    this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
                    return this;
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder reasonCode(CodeableConcept ... reasonCode) {
                    for (CodeableConcept value : reasonCode) {
                        this.reasonCode.add(value);
                    }
                    return this;
                }

                public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
                    this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
                    return this;
                }

                public Builder reasonReference(Reference ... reasonReference) {
                    for (Reference value : reasonReference) {
                        this.reasonReference.add(value);
                    }
                    return this;
                }

                public Builder reasonReference(Collection<Reference> reasonReference) {
                    this.reasonReference = new ArrayList<Reference>(reasonReference);
                    return this;
                }

                public Builder goal(Reference ... goal) {
                    for (Reference value : goal) {
                        this.goal.add(value);
                    }
                    return this;
                }

                public Builder goal(Collection<Reference> goal) {
                    this.goal = new ArrayList<Reference>(goal);
                    return this;
                }

                public Builder status(CarePlanActivityStatus status) {
                    this.status = status;
                    return this;
                }

                public Builder statusReason(CodeableConcept statusReason) {
                    this.statusReason = statusReason;
                    return this;
                }

                public Builder doNotPerform(Boolean doNotPerform) {
                    this.doNotPerform = doNotPerform;
                    return this;
                }

                public Builder scheduled(Element scheduled) {
                    this.scheduled = scheduled;
                    return this;
                }

                public Builder location(Reference location) {
                    this.location = location;
                    return this;
                }

                public Builder performer(Reference ... performer) {
                    for (Reference value : performer) {
                        this.performer.add(value);
                    }
                    return this;
                }

                public Builder performer(Collection<Reference> performer) {
                    this.performer = new ArrayList<Reference>(performer);
                    return this;
                }

                public Builder product(Element product) {
                    this.product = product;
                    return this;
                }

                public Builder dailyAmount(SimpleQuantity dailyAmount) {
                    this.dailyAmount = dailyAmount;
                    return this;
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Detail build() {
                    return new Detail(this);
                }

                protected Builder from(Detail detail) {
                    super.from(detail);
                    this.kind = detail.kind;
                    this.instantiatesCanonical.addAll(detail.instantiatesCanonical);
                    this.instantiatesUri.addAll(detail.instantiatesUri);
                    this.code = detail.code;
                    this.reasonCode.addAll(detail.reasonCode);
                    this.reasonReference.addAll(detail.reasonReference);
                    this.goal.addAll(detail.goal);
                    this.status = detail.status;
                    this.statusReason = detail.statusReason;
                    this.doNotPerform = detail.doNotPerform;
                    this.scheduled = detail.scheduled;
                    this.location = detail.location;
                    this.performer.addAll(detail.performer);
                    this.product = detail.product;
                    this.dailyAmount = detail.dailyAmount;
                    this.quantity = detail.quantity;
                    this.description = detail.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> outcomeCodeableConcept = new ArrayList<CodeableConcept>();
            private List<Reference> outcomeReference = new ArrayList<Reference>();
            private List<Annotation> progress = new ArrayList<Annotation>();
            private Reference reference;
            private Detail detail;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder outcomeCodeableConcept(CodeableConcept ... outcomeCodeableConcept) {
                for (CodeableConcept value : outcomeCodeableConcept) {
                    this.outcomeCodeableConcept.add(value);
                }
                return this;
            }

            public Builder outcomeCodeableConcept(Collection<CodeableConcept> outcomeCodeableConcept) {
                this.outcomeCodeableConcept = new ArrayList<CodeableConcept>(outcomeCodeableConcept);
                return this;
            }

            public Builder outcomeReference(Reference ... outcomeReference) {
                for (Reference value : outcomeReference) {
                    this.outcomeReference.add(value);
                }
                return this;
            }

            public Builder outcomeReference(Collection<Reference> outcomeReference) {
                this.outcomeReference = new ArrayList<Reference>(outcomeReference);
                return this;
            }

            public Builder progress(Annotation ... progress) {
                for (Annotation value : progress) {
                    this.progress.add(value);
                }
                return this;
            }

            public Builder progress(Collection<Annotation> progress) {
                this.progress = new ArrayList<Annotation>(progress);
                return this;
            }

            public Builder reference(Reference reference) {
                this.reference = reference;
                return this;
            }

            public Builder detail(Detail detail) {
                this.detail = detail;
                return this;
            }

            @Override
            public Activity build() {
                return new Activity(this);
            }

            protected Builder from(Activity activity) {
                super.from(activity);
                this.outcomeCodeableConcept.addAll(activity.outcomeCodeableConcept);
                this.outcomeReference.addAll(activity.outcomeReference);
                this.progress.addAll(activity.progress);
                this.reference = activity.reference;
                this.detail = activity.detail;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Canonical> instantiatesCanonical = new ArrayList<Canonical>();
        private List<Uri> instantiatesUri = new ArrayList<Uri>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> replaces = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private CarePlanStatus status;
        private CarePlanIntent intent;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private String title;
        private String description;
        private Reference subject;
        private Reference encounter;
        private Period period;
        private DateTime created;
        private Reference author;
        private List<Reference> contributor = new ArrayList<Reference>();
        private List<Reference> careTeam = new ArrayList<Reference>();
        private List<Reference> addresses = new ArrayList<Reference>();
        private List<Reference> supportingInfo = new ArrayList<Reference>();
        private List<Reference> goal = new ArrayList<Reference>();
        private List<Activity> activity = new ArrayList<Activity>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiatesCanonical(Canonical ... instantiatesCanonical) {
            for (Canonical value : instantiatesCanonical) {
                this.instantiatesCanonical.add(value);
            }
            return this;
        }

        public Builder instantiatesCanonical(Collection<Canonical> instantiatesCanonical) {
            this.instantiatesCanonical = new ArrayList<Canonical>(instantiatesCanonical);
            return this;
        }

        public Builder instantiatesUri(Uri ... instantiatesUri) {
            for (Uri value : instantiatesUri) {
                this.instantiatesUri.add(value);
            }
            return this;
        }

        public Builder instantiatesUri(Collection<Uri> instantiatesUri) {
            this.instantiatesUri = new ArrayList<Uri>(instantiatesUri);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder replaces(Reference ... replaces) {
            for (Reference value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Reference> replaces) {
            this.replaces = new ArrayList<Reference>(replaces);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(CarePlanStatus status) {
            this.status = status;
            return this;
        }

        public Builder intent(CarePlanIntent intent) {
            this.intent = intent;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder contributor(Reference ... contributor) {
            for (Reference value : contributor) {
                this.contributor.add(value);
            }
            return this;
        }

        public Builder contributor(Collection<Reference> contributor) {
            this.contributor = new ArrayList<Reference>(contributor);
            return this;
        }

        public Builder careTeam(Reference ... careTeam) {
            for (Reference value : careTeam) {
                this.careTeam.add(value);
            }
            return this;
        }

        public Builder careTeam(Collection<Reference> careTeam) {
            this.careTeam = new ArrayList<Reference>(careTeam);
            return this;
        }

        public Builder addresses(Reference ... addresses) {
            for (Reference value : addresses) {
                this.addresses.add(value);
            }
            return this;
        }

        public Builder addresses(Collection<Reference> addresses) {
            this.addresses = new ArrayList<Reference>(addresses);
            return this;
        }

        public Builder supportingInfo(Reference ... supportingInfo) {
            for (Reference value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<Reference> supportingInfo) {
            this.supportingInfo = new ArrayList<Reference>(supportingInfo);
            return this;
        }

        public Builder goal(Reference ... goal) {
            for (Reference value : goal) {
                this.goal.add(value);
            }
            return this;
        }

        public Builder goal(Collection<Reference> goal) {
            this.goal = new ArrayList<Reference>(goal);
            return this;
        }

        public Builder activity(Activity ... activity) {
            for (Activity value : activity) {
                this.activity.add(value);
            }
            return this;
        }

        public Builder activity(Collection<Activity> activity) {
            this.activity = new ArrayList<Activity>(activity);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public CarePlan build() {
            return new CarePlan(this);
        }

        protected Builder from(CarePlan carePlan) {
            super.from(carePlan);
            this.identifier.addAll(carePlan.identifier);
            this.instantiatesCanonical.addAll(carePlan.instantiatesCanonical);
            this.instantiatesUri.addAll(carePlan.instantiatesUri);
            this.basedOn.addAll(carePlan.basedOn);
            this.replaces.addAll(carePlan.replaces);
            this.partOf.addAll(carePlan.partOf);
            this.status = carePlan.status;
            this.intent = carePlan.intent;
            this.category.addAll(carePlan.category);
            this.title = carePlan.title;
            this.description = carePlan.description;
            this.subject = carePlan.subject;
            this.encounter = carePlan.encounter;
            this.period = carePlan.period;
            this.created = carePlan.created;
            this.author = carePlan.author;
            this.contributor.addAll(carePlan.contributor);
            this.careTeam.addAll(carePlan.careTeam);
            this.addresses.addAll(carePlan.addresses);
            this.supportingInfo.addAll(carePlan.supportingInfo);
            this.goal.addAll(carePlan.goal);
            this.activity.addAll(carePlan.activity);
            this.note.addAll(carePlan.note);
            return this;
        }
    }
}

