/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CatalogEntryRelationType;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class CatalogEntry
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    private final CodeableConcept type;
    @Summary
    @Required
    private final Boolean orderable;
    @Summary
    @ReferenceTarget(value={"Medication", "Device", "Organization", "Practitioner", "PractitionerRole", "HealthcareService", "ActivityDefinition", "PlanDefinition", "SpecimenDefinition", "ObservationDefinition", "Binary"})
    @Required
    private final Reference referencedItem;
    private final List<Identifier> additionalIdentifier;
    private final List<CodeableConcept> classification;
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    private final PublicationStatus status;
    private final Period validityPeriod;
    private final DateTime validTo;
    private final DateTime lastUpdated;
    private final List<CodeableConcept> additionalCharacteristic;
    private final List<CodeableConcept> additionalClassification;
    private final List<RelatedEntry> relatedEntry;
    private volatile int hashCode;

    private CatalogEntry(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.type = builder.type;
        this.orderable = ValidationSupport.requireNonNull(builder.orderable, "orderable");
        this.referencedItem = ValidationSupport.requireNonNull(builder.referencedItem, "referencedItem");
        this.additionalIdentifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.additionalIdentifier, "additionalIdentifier", Identifier.class));
        this.classification = Collections.unmodifiableList(ValidationSupport.checkList(builder.classification, "classification", CodeableConcept.class));
        this.status = builder.status;
        this.validityPeriod = builder.validityPeriod;
        this.validTo = builder.validTo;
        this.lastUpdated = builder.lastUpdated;
        this.additionalCharacteristic = Collections.unmodifiableList(ValidationSupport.checkList(builder.additionalCharacteristic, "additionalCharacteristic", CodeableConcept.class));
        this.additionalClassification = Collections.unmodifiableList(ValidationSupport.checkList(builder.additionalClassification, "additionalClassification", CodeableConcept.class));
        this.relatedEntry = Collections.unmodifiableList(ValidationSupport.checkList(builder.relatedEntry, "relatedEntry", RelatedEntry.class));
        ValidationSupport.checkReferenceType(this.referencedItem, "referencedItem", "Medication", "Device", "Organization", "Practitioner", "PractitionerRole", "HealthcareService", "ActivityDefinition", "PlanDefinition", "SpecimenDefinition", "ObservationDefinition", "Binary");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Boolean getOrderable() {
        return this.orderable;
    }

    public Reference getReferencedItem() {
        return this.referencedItem;
    }

    public List<Identifier> getAdditionalIdentifier() {
        return this.additionalIdentifier;
    }

    public List<CodeableConcept> getClassification() {
        return this.classification;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Period getValidityPeriod() {
        return this.validityPeriod;
    }

    public DateTime getValidTo() {
        return this.validTo;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public List<CodeableConcept> getAdditionalCharacteristic() {
        return this.additionalCharacteristic;
    }

    public List<CodeableConcept> getAdditionalClassification() {
        return this.additionalClassification;
    }

    public List<RelatedEntry> getRelatedEntry() {
        return this.relatedEntry;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.orderable != null || this.referencedItem != null || !this.additionalIdentifier.isEmpty() || !this.classification.isEmpty() || this.status != null || this.validityPeriod != null || this.validTo != null || this.lastUpdated != null || !this.additionalCharacteristic.isEmpty() || !this.additionalClassification.isEmpty() || !this.relatedEntry.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.orderable, "orderable", visitor);
                this.accept(this.referencedItem, "referencedItem", visitor);
                this.accept(this.additionalIdentifier, "additionalIdentifier", visitor, Identifier.class);
                this.accept(this.classification, "classification", visitor, CodeableConcept.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.validityPeriod, "validityPeriod", visitor);
                this.accept(this.validTo, "validTo", visitor);
                this.accept(this.lastUpdated, "lastUpdated", visitor);
                this.accept(this.additionalCharacteristic, "additionalCharacteristic", visitor, CodeableConcept.class);
                this.accept(this.additionalClassification, "additionalClassification", visitor, CodeableConcept.class);
                this.accept(this.relatedEntry, "relatedEntry", visitor, RelatedEntry.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogEntry other = (CatalogEntry)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.orderable, other.orderable) && Objects.equals(this.referencedItem, other.referencedItem) && Objects.equals(this.additionalIdentifier, other.additionalIdentifier) && Objects.equals(this.classification, other.classification) && Objects.equals(this.status, other.status) && Objects.equals(this.validityPeriod, other.validityPeriod) && Objects.equals(this.validTo, other.validTo) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.additionalCharacteristic, other.additionalCharacteristic) && Objects.equals(this.additionalClassification, other.additionalClassification) && Objects.equals(this.relatedEntry, other.relatedEntry);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.orderable, this.referencedItem, this.additionalIdentifier, this.classification, this.status, this.validityPeriod, this.validTo, this.lastUpdated, this.additionalCharacteristic, this.additionalClassification, this.relatedEntry);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class RelatedEntry
    extends BackboneElement {
        @Binding(bindingName="CatalogEntryRelationType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of relations between entries.", valueSet="http://hl7.org/fhir/ValueSet/relation-type|4.0.1")
        @Required
        private final CatalogEntryRelationType relationtype;
        @ReferenceTarget(value={"CatalogEntry"})
        @Required
        private final Reference item;
        private volatile int hashCode;

        private RelatedEntry(Builder builder) {
            super(builder);
            this.relationtype = ValidationSupport.requireNonNull(builder.relationtype, "relationtype");
            this.item = ValidationSupport.requireNonNull(builder.item, "item");
            ValidationSupport.checkReferenceType(this.item, "item", "CatalogEntry");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CatalogEntryRelationType getRelationtype() {
            return this.relationtype;
        }

        public Reference getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.relationtype != null || this.item != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.relationtype, "relationtype", visitor);
                    this.accept(this.item, "item", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatedEntry other = (RelatedEntry)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relationtype, other.relationtype) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relationtype, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CatalogEntryRelationType relationtype;
            private Reference item;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder relationtype(CatalogEntryRelationType relationtype) {
                this.relationtype = relationtype;
                return this;
            }

            public Builder item(Reference item) {
                this.item = item;
                return this;
            }

            @Override
            public RelatedEntry build() {
                return new RelatedEntry(this);
            }

            protected Builder from(RelatedEntry relatedEntry) {
                super.from(relatedEntry);
                this.relationtype = relatedEntry.relationtype;
                this.item = relatedEntry.item;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept type;
        private Boolean orderable;
        private Reference referencedItem;
        private List<Identifier> additionalIdentifier = new ArrayList<Identifier>();
        private List<CodeableConcept> classification = new ArrayList<CodeableConcept>();
        private PublicationStatus status;
        private Period validityPeriod;
        private DateTime validTo;
        private DateTime lastUpdated;
        private List<CodeableConcept> additionalCharacteristic = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> additionalClassification = new ArrayList<CodeableConcept>();
        private List<RelatedEntry> relatedEntry = new ArrayList<RelatedEntry>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder orderable(Boolean orderable) {
            this.orderable = orderable;
            return this;
        }

        public Builder referencedItem(Reference referencedItem) {
            this.referencedItem = referencedItem;
            return this;
        }

        public Builder additionalIdentifier(Identifier ... additionalIdentifier) {
            for (Identifier value : additionalIdentifier) {
                this.additionalIdentifier.add(value);
            }
            return this;
        }

        public Builder additionalIdentifier(Collection<Identifier> additionalIdentifier) {
            this.additionalIdentifier = new ArrayList<Identifier>(additionalIdentifier);
            return this;
        }

        public Builder classification(CodeableConcept ... classification) {
            for (CodeableConcept value : classification) {
                this.classification.add(value);
            }
            return this;
        }

        public Builder classification(Collection<CodeableConcept> classification) {
            this.classification = new ArrayList<CodeableConcept>(classification);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder validityPeriod(Period validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Builder validTo(DateTime validTo) {
            this.validTo = validTo;
            return this;
        }

        public Builder lastUpdated(DateTime lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder additionalCharacteristic(CodeableConcept ... additionalCharacteristic) {
            for (CodeableConcept value : additionalCharacteristic) {
                this.additionalCharacteristic.add(value);
            }
            return this;
        }

        public Builder additionalCharacteristic(Collection<CodeableConcept> additionalCharacteristic) {
            this.additionalCharacteristic = new ArrayList<CodeableConcept>(additionalCharacteristic);
            return this;
        }

        public Builder additionalClassification(CodeableConcept ... additionalClassification) {
            for (CodeableConcept value : additionalClassification) {
                this.additionalClassification.add(value);
            }
            return this;
        }

        public Builder additionalClassification(Collection<CodeableConcept> additionalClassification) {
            this.additionalClassification = new ArrayList<CodeableConcept>(additionalClassification);
            return this;
        }

        public Builder relatedEntry(RelatedEntry ... relatedEntry) {
            for (RelatedEntry value : relatedEntry) {
                this.relatedEntry.add(value);
            }
            return this;
        }

        public Builder relatedEntry(Collection<RelatedEntry> relatedEntry) {
            this.relatedEntry = new ArrayList<RelatedEntry>(relatedEntry);
            return this;
        }

        @Override
        public CatalogEntry build() {
            return new CatalogEntry(this);
        }

        protected Builder from(CatalogEntry catalogEntry) {
            super.from(catalogEntry);
            this.identifier.addAll(catalogEntry.identifier);
            this.type = catalogEntry.type;
            this.orderable = catalogEntry.orderable;
            this.referencedItem = catalogEntry.referencedItem;
            this.additionalIdentifier.addAll(catalogEntry.additionalIdentifier);
            this.classification.addAll(catalogEntry.classification);
            this.status = catalogEntry.status;
            this.validityPeriod = catalogEntry.validityPeriod;
            this.validTo = catalogEntry.validTo;
            this.lastUpdated = catalogEntry.lastUpdated;
            this.additionalCharacteristic.addAll(catalogEntry.additionalCharacteristic);
            this.additionalClassification.addAll(catalogEntry.additionalClassification);
            this.relatedEntry.addAll(catalogEntry.relatedEntry);
            return this;
        }
    }
}

