/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ClaimResponseStatus;
import com.ibm.fhir.model.type.code.NoteType;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.Use;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="claimResponse-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/claim-type", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/claim-type', 'extensible')", generated=true), @Constraint(id="claimResponse-1", level="Warning", location="processNote.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", generated=true)})
public class ClaimResponse
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ClaimResponseStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final ClaimResponseStatus status;
    @Summary
    @Binding(bindingName="ClaimType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="The type or discipline-style of the claim.", valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    @Required
    private final CodeableConcept type;
    @Binding(bindingName="ClaimSubType", strength=BindingStrength.ValueSet.EXAMPLE, description="A more granular claim typecode.", valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    private final CodeableConcept subType;
    @Summary
    @Binding(bindingName="Use", strength=BindingStrength.ValueSet.REQUIRED, description="Claim, preauthorization, predetermination.", valueSet="http://hl7.org/fhir/ValueSet/claim-use|4.0.1")
    @Required
    private final Use use;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    @Required
    private final DateTime created;
    @Summary
    @ReferenceTarget(value={"Organization"})
    @Required
    private final Reference insurer;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference requestor;
    @Summary
    @ReferenceTarget(value={"Claim"})
    private final Reference request;
    @Summary
    @Binding(bindingName="RemittanceOutcome", strength=BindingStrength.ValueSet.REQUIRED, description="The result of the claim processing.", valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome|4.0.1")
    @Required
    private final RemittanceOutcome outcome;
    private final String disposition;
    private final String preAuthRef;
    private final Period preAuthPeriod;
    @Binding(bindingName="PayeeType", strength=BindingStrength.ValueSet.EXAMPLE, description="A code for the party to be reimbursed.", valueSet="http://hl7.org/fhir/ValueSet/payeetype")
    private final CodeableConcept payeeType;
    private final List<Item> item;
    private final List<AddItem> addItem;
    private final List<Item.Adjudication> adjudication;
    @Summary
    private final List<Total> total;
    private final Payment payment;
    @Binding(bindingName="FundsReserve", strength=BindingStrength.ValueSet.EXAMPLE, description="For whom funds are to be reserved: (Patient, Provider, None).", valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    private final CodeableConcept fundsReserve;
    @Binding(bindingName="Forms", strength=BindingStrength.ValueSet.EXAMPLE, description="The forms codes.", valueSet="http://hl7.org/fhir/ValueSet/forms")
    private final CodeableConcept formCode;
    private final Attachment form;
    private final List<ProcessNote> processNote;
    @ReferenceTarget(value={"CommunicationRequest"})
    private final List<Reference> communicationRequest;
    private final List<Insurance> insurance;
    private final List<Error> error;
    private volatile int hashCode;

    private ClaimResponse(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.subType = builder.subType;
        this.use = ValidationSupport.requireNonNull(builder.use, "use");
        this.patient = ValidationSupport.requireNonNull(builder.patient, "patient");
        this.created = ValidationSupport.requireNonNull(builder.created, "created");
        this.insurer = ValidationSupport.requireNonNull(builder.insurer, "insurer");
        this.requestor = builder.requestor;
        this.request = builder.request;
        this.outcome = ValidationSupport.requireNonNull(builder.outcome, "outcome");
        this.disposition = builder.disposition;
        this.preAuthRef = builder.preAuthRef;
        this.preAuthPeriod = builder.preAuthPeriod;
        this.payeeType = builder.payeeType;
        this.item = Collections.unmodifiableList(ValidationSupport.checkList(builder.item, "item", Item.class));
        this.addItem = Collections.unmodifiableList(ValidationSupport.checkList(builder.addItem, "addItem", AddItem.class));
        this.adjudication = Collections.unmodifiableList(ValidationSupport.checkList(builder.adjudication, "adjudication", Item.Adjudication.class));
        this.total = Collections.unmodifiableList(ValidationSupport.checkList(builder.total, "total", Total.class));
        this.payment = builder.payment;
        this.fundsReserve = builder.fundsReserve;
        this.formCode = builder.formCode;
        this.form = builder.form;
        this.processNote = Collections.unmodifiableList(ValidationSupport.checkList(builder.processNote, "processNote", ProcessNote.class));
        this.communicationRequest = Collections.unmodifiableList(ValidationSupport.checkList(builder.communicationRequest, "communicationRequest", Reference.class));
        this.insurance = Collections.unmodifiableList(ValidationSupport.checkList(builder.insurance, "insurance", Insurance.class));
        this.error = Collections.unmodifiableList(ValidationSupport.checkList(builder.error, "error", Error.class));
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
        ValidationSupport.checkReferenceType(this.insurer, "insurer", "Organization");
        ValidationSupport.checkReferenceType(this.requestor, "requestor", "Practitioner", "PractitionerRole", "Organization");
        ValidationSupport.checkReferenceType(this.request, "request", "Claim");
        ValidationSupport.checkReferenceType(this.communicationRequest, "communicationRequest", "CommunicationRequest");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ClaimResponseStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getSubType() {
        return this.subType;
    }

    public Use getUse() {
        return this.use;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getInsurer() {
        return this.insurer;
    }

    public Reference getRequestor() {
        return this.requestor;
    }

    public Reference getRequest() {
        return this.request;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getPreAuthRef() {
        return this.preAuthRef;
    }

    public Period getPreAuthPeriod() {
        return this.preAuthPeriod;
    }

    public CodeableConcept getPayeeType() {
        return this.payeeType;
    }

    public List<Item> getItem() {
        return this.item;
    }

    public List<AddItem> getAddItem() {
        return this.addItem;
    }

    public List<Item.Adjudication> getAdjudication() {
        return this.adjudication;
    }

    public List<Total> getTotal() {
        return this.total;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public CodeableConcept getFundsReserve() {
        return this.fundsReserve;
    }

    public CodeableConcept getFormCode() {
        return this.formCode;
    }

    public Attachment getForm() {
        return this.form;
    }

    public List<ProcessNote> getProcessNote() {
        return this.processNote;
    }

    public List<Reference> getCommunicationRequest() {
        return this.communicationRequest;
    }

    public List<Insurance> getInsurance() {
        return this.insurance;
    }

    public List<Error> getError() {
        return this.error;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.type != null || this.subType != null || this.use != null || this.patient != null || this.created != null || this.insurer != null || this.requestor != null || this.request != null || this.outcome != null || this.disposition != null || this.preAuthRef != null || this.preAuthPeriod != null || this.payeeType != null || !this.item.isEmpty() || !this.addItem.isEmpty() || !this.adjudication.isEmpty() || !this.total.isEmpty() || this.payment != null || this.fundsReserve != null || this.formCode != null || this.form != null || !this.processNote.isEmpty() || !this.communicationRequest.isEmpty() || !this.insurance.isEmpty() || !this.error.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subType, "subType", visitor);
                this.accept(this.use, "use", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.insurer, "insurer", visitor);
                this.accept(this.requestor, "requestor", visitor);
                this.accept(this.request, "request", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.disposition, "disposition", visitor);
                this.accept(this.preAuthRef, "preAuthRef", visitor);
                this.accept(this.preAuthPeriod, "preAuthPeriod", visitor);
                this.accept(this.payeeType, "payeeType", visitor);
                this.accept(this.item, "item", visitor, Item.class);
                this.accept(this.addItem, "addItem", visitor, AddItem.class);
                this.accept(this.adjudication, "adjudication", visitor, Item.Adjudication.class);
                this.accept(this.total, "total", visitor, Total.class);
                this.accept(this.payment, "payment", visitor);
                this.accept(this.fundsReserve, "fundsReserve", visitor);
                this.accept(this.formCode, "formCode", visitor);
                this.accept(this.form, "form", visitor);
                this.accept(this.processNote, "processNote", visitor, ProcessNote.class);
                this.accept(this.communicationRequest, "communicationRequest", visitor, Reference.class);
                this.accept(this.insurance, "insurance", visitor, Insurance.class);
                this.accept(this.error, "error", visitor, Error.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClaimResponse other = (ClaimResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType) && Objects.equals(this.use, other.use) && Objects.equals(this.patient, other.patient) && Objects.equals(this.created, other.created) && Objects.equals(this.insurer, other.insurer) && Objects.equals(this.requestor, other.requestor) && Objects.equals(this.request, other.request) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.disposition, other.disposition) && Objects.equals(this.preAuthRef, other.preAuthRef) && Objects.equals(this.preAuthPeriod, other.preAuthPeriod) && Objects.equals(this.payeeType, other.payeeType) && Objects.equals(this.item, other.item) && Objects.equals(this.addItem, other.addItem) && Objects.equals(this.adjudication, other.adjudication) && Objects.equals(this.total, other.total) && Objects.equals(this.payment, other.payment) && Objects.equals(this.fundsReserve, other.fundsReserve) && Objects.equals(this.formCode, other.formCode) && Objects.equals(this.form, other.form) && Objects.equals(this.processNote, other.processNote) && Objects.equals(this.communicationRequest, other.communicationRequest) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.error, other.error);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.created, this.insurer, this.requestor, this.request, this.outcome, this.disposition, this.preAuthRef, this.preAuthPeriod, this.payeeType, this.item, this.addItem, this.adjudication, this.total, this.payment, this.fundsReserve, this.formCode, this.form, this.processNote, this.communicationRequest, this.insurance, this.error);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Error
    extends BackboneElement {
        private final PositiveInt itemSequence;
        private final PositiveInt detailSequence;
        private final PositiveInt subDetailSequence;
        @Binding(bindingName="AdjudicationError", strength=BindingStrength.ValueSet.EXAMPLE, description="The adjudication error codes.", valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        @Required
        private final CodeableConcept code;
        private volatile int hashCode;

        private Error(Builder builder) {
            super(builder);
            this.itemSequence = builder.itemSequence;
            this.detailSequence = builder.detailSequence;
            this.subDetailSequence = builder.subDetailSequence;
            this.code = ValidationSupport.requireNonNull(builder.code, "code");
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getItemSequence() {
            return this.itemSequence;
        }

        public PositiveInt getDetailSequence() {
            return this.detailSequence;
        }

        public PositiveInt getSubDetailSequence() {
            return this.subDetailSequence;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.itemSequence != null || this.detailSequence != null || this.subDetailSequence != null || this.code != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.itemSequence, "itemSequence", visitor);
                    this.accept(this.detailSequence, "detailSequence", visitor);
                    this.accept(this.subDetailSequence, "subDetailSequence", visitor);
                    this.accept(this.code, "code", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.itemSequence, other.itemSequence) && Objects.equals(this.detailSequence, other.detailSequence) && Objects.equals(this.subDetailSequence, other.subDetailSequence) && Objects.equals(this.code, other.code);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.itemSequence, this.detailSequence, this.subDetailSequence, this.code);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt itemSequence;
            private PositiveInt detailSequence;
            private PositiveInt subDetailSequence;
            private CodeableConcept code;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder itemSequence(PositiveInt itemSequence) {
                this.itemSequence = itemSequence;
                return this;
            }

            public Builder detailSequence(PositiveInt detailSequence) {
                this.detailSequence = detailSequence;
                return this;
            }

            public Builder subDetailSequence(PositiveInt subDetailSequence) {
                this.subDetailSequence = subDetailSequence;
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            @Override
            public Error build() {
                return new Error(this);
            }

            protected Builder from(Error error) {
                super.from(error);
                this.itemSequence = error.itemSequence;
                this.detailSequence = error.detailSequence;
                this.subDetailSequence = error.subDetailSequence;
                this.code = error.code;
                return this;
            }
        }
    }

    public static class Insurance
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @Required
        private final Boolean focal;
        @ReferenceTarget(value={"Coverage"})
        @Required
        private final Reference coverage;
        private final String businessArrangement;
        @ReferenceTarget(value={"ClaimResponse"})
        private final Reference claimResponse;
        private volatile int hashCode;

        private Insurance(Builder builder) {
            super(builder);
            this.sequence = ValidationSupport.requireNonNull(builder.sequence, "sequence");
            this.focal = ValidationSupport.requireNonNull(builder.focal, "focal");
            this.coverage = ValidationSupport.requireNonNull(builder.coverage, "coverage");
            this.businessArrangement = builder.businessArrangement;
            this.claimResponse = builder.claimResponse;
            ValidationSupport.checkReferenceType(this.coverage, "coverage", "Coverage");
            ValidationSupport.checkReferenceType(this.claimResponse, "claimResponse", "ClaimResponse");
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Boolean getFocal() {
            return this.focal;
        }

        public Reference getCoverage() {
            return this.coverage;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement;
        }

        public Reference getClaimResponse() {
            return this.claimResponse;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.focal != null || this.coverage != null || this.businessArrangement != null || this.claimResponse != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.focal, "focal", visitor);
                    this.accept(this.coverage, "coverage", visitor);
                    this.accept(this.businessArrangement, "businessArrangement", visitor);
                    this.accept(this.claimResponse, "claimResponse", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Insurance other = (Insurance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.focal, other.focal) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.businessArrangement, other.businessArrangement) && Objects.equals(this.claimResponse, other.claimResponse);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.focal, this.coverage, this.businessArrangement, this.claimResponse);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Boolean focal;
            private Reference coverage;
            private String businessArrangement;
            private Reference claimResponse;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder focal(Boolean focal) {
                this.focal = focal;
                return this;
            }

            public Builder coverage(Reference coverage) {
                this.coverage = coverage;
                return this;
            }

            public Builder businessArrangement(String businessArrangement) {
                this.businessArrangement = businessArrangement;
                return this;
            }

            public Builder claimResponse(Reference claimResponse) {
                this.claimResponse = claimResponse;
                return this;
            }

            @Override
            public Insurance build() {
                return new Insurance(this);
            }

            protected Builder from(Insurance insurance) {
                super.from(insurance);
                this.sequence = insurance.sequence;
                this.focal = insurance.focal;
                this.coverage = insurance.coverage;
                this.businessArrangement = insurance.businessArrangement;
                this.claimResponse = insurance.claimResponse;
                return this;
            }
        }
    }

    public static class ProcessNote
    extends BackboneElement {
        private final PositiveInt number;
        @Binding(bindingName="NoteType", strength=BindingStrength.ValueSet.REQUIRED, description="The presentation types of notes.", valueSet="http://hl7.org/fhir/ValueSet/note-type|4.0.1")
        private final NoteType type;
        @Required
        private final String text;
        @Binding(bindingName="Language", strength=BindingStrength.ValueSet.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
        private final CodeableConcept language;
        private volatile int hashCode;

        private ProcessNote(Builder builder) {
            super(builder);
            this.number = builder.number;
            this.type = builder.type;
            this.text = ValidationSupport.requireNonNull(builder.text, "text");
            this.language = builder.language;
            ValidationSupport.checkValueSetBinding(this.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new java.lang.String[0]);
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getNumber() {
            return this.number;
        }

        public NoteType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public CodeableConcept getLanguage() {
            return this.language;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.number != null || this.type != null || this.text != null || this.language != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.number, "number", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.language, "language", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessNote other = (ProcessNote)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.number, other.number) && Objects.equals(this.type, other.type) && Objects.equals(this.text, other.text) && Objects.equals(this.language, other.language);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.number, this.type, this.text, this.language);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt number;
            private NoteType type;
            private String text;
            private CodeableConcept language;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder number(PositiveInt number) {
                this.number = number;
                return this;
            }

            public Builder type(NoteType type) {
                this.type = type;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder language(CodeableConcept language) {
                this.language = language;
                return this;
            }

            @Override
            public ProcessNote build() {
                return new ProcessNote(this);
            }

            protected Builder from(ProcessNote processNote) {
                super.from(processNote);
                this.number = processNote.number;
                this.type = processNote.type;
                this.text = processNote.text;
                this.language = processNote.language;
                return this;
            }
        }
    }

    public static class Payment
    extends BackboneElement {
        @Binding(bindingName="PaymentType", strength=BindingStrength.ValueSet.EXAMPLE, description="The type (partial, complete) of the payment.", valueSet="http://hl7.org/fhir/ValueSet/ex-paymenttype")
        @Required
        private final CodeableConcept type;
        private final Money adjustment;
        @Binding(bindingName="PaymentAdjustmentReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Payment Adjustment reason codes.", valueSet="http://hl7.org/fhir/ValueSet/payment-adjustment-reason")
        private final CodeableConcept adjustmentReason;
        private final Date date;
        @Required
        private final Money amount;
        private final Identifier identifier;
        private volatile int hashCode;

        private Payment(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.adjustment = builder.adjustment;
            this.adjustmentReason = builder.adjustmentReason;
            this.date = builder.date;
            this.amount = ValidationSupport.requireNonNull(builder.amount, "amount");
            this.identifier = builder.identifier;
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Money getAdjustment() {
            return this.adjustment;
        }

        public CodeableConcept getAdjustmentReason() {
            return this.adjustmentReason;
        }

        public Date getDate() {
            return this.date;
        }

        public Money getAmount() {
            return this.amount;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.adjustment != null || this.adjustmentReason != null || this.date != null || this.amount != null || this.identifier != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.adjustment, "adjustment", visitor);
                    this.accept(this.adjustmentReason, "adjustmentReason", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.amount, "amount", visitor);
                    this.accept(this.identifier, "identifier", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Payment other = (Payment)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.adjustment, other.adjustment) && Objects.equals(this.adjustmentReason, other.adjustmentReason) && Objects.equals(this.date, other.date) && Objects.equals(this.amount, other.amount) && Objects.equals(this.identifier, other.identifier);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.adjustment, this.adjustmentReason, this.date, this.amount, this.identifier);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Money adjustment;
            private CodeableConcept adjustmentReason;
            private Date date;
            private Money amount;
            private Identifier identifier;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder adjustment(Money adjustment) {
                this.adjustment = adjustment;
                return this;
            }

            public Builder adjustmentReason(CodeableConcept adjustmentReason) {
                this.adjustmentReason = adjustmentReason;
                return this;
            }

            public Builder date(Date date) {
                this.date = date;
                return this;
            }

            public Builder amount(Money amount) {
                this.amount = amount;
                return this;
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            @Override
            public Payment build() {
                return new Payment(this);
            }

            protected Builder from(Payment payment) {
                super.from(payment);
                this.type = payment.type;
                this.adjustment = payment.adjustment;
                this.adjustmentReason = payment.adjustmentReason;
                this.date = payment.date;
                this.amount = payment.amount;
                this.identifier = payment.identifier;
                return this;
            }
        }
    }

    public static class Total
    extends BackboneElement {
        @Summary
        @Binding(bindingName="Adjudication", strength=BindingStrength.ValueSet.EXAMPLE, description="The adjudication codes.", valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        @Required
        private final CodeableConcept category;
        @Summary
        @Required
        private final Money amount;
        private volatile int hashCode;

        private Total(Builder builder) {
            super(builder);
            this.category = ValidationSupport.requireNonNull(builder.category, "category");
            this.amount = ValidationSupport.requireNonNull(builder.amount, "amount");
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public Money getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.category != null || this.amount != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.amount, "amount", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Total other = (Total)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept category;
            private Money amount;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder amount(Money amount) {
                this.amount = amount;
                return this;
            }

            @Override
            public Total build() {
                return new Total(this);
            }

            protected Builder from(Total total) {
                super.from(total);
                this.category = total.category;
                this.amount = total.amount;
                return this;
            }
        }
    }

    public static class AddItem
    extends BackboneElement {
        private final List<PositiveInt> itemSequence;
        private final List<PositiveInt> detailSequence;
        private final List<PositiveInt> subdetailSequence;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final List<Reference> provider;
        @Binding(bindingName="ServiceProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        @Required
        private final CodeableConcept productOrService;
        @Binding(bindingName="Modifiers", strength=BindingStrength.ValueSet.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        private final List<CodeableConcept> modifier;
        @Binding(bindingName="ProgramCode", strength=BindingStrength.ValueSet.EXAMPLE, description="Program specific reason codes.", valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        private final List<CodeableConcept> programCode;
        @Choice(value={Date.class, Period.class})
        private final Element serviced;
        @ReferenceTarget(value={"Location"})
        @Choice(value={CodeableConcept.class, Address.class, Reference.class})
        @Binding(bindingName="ServicePlace", strength=BindingStrength.ValueSet.EXAMPLE, description="Place of service: pharmacy, school, prison, etc.", valueSet="http://hl7.org/fhir/ValueSet/service-place")
        private final Element location;
        private final SimpleQuantity quantity;
        private final Money unitPrice;
        private final Decimal factor;
        private final Money net;
        @Binding(bindingName="OralSites", strength=BindingStrength.ValueSet.EXAMPLE, description="The code for the teeth, quadrant, sextant and arch.", valueSet="http://hl7.org/fhir/ValueSet/tooth")
        private final CodeableConcept bodySite;
        @Binding(bindingName="Surface", strength=BindingStrength.ValueSet.EXAMPLE, description="The code for the tooth surface and surface combinations.", valueSet="http://hl7.org/fhir/ValueSet/surface")
        private final List<CodeableConcept> subSite;
        private final List<PositiveInt> noteNumber;
        @Required
        private final List<Item.Adjudication> adjudication;
        private final List<Detail> detail;
        private volatile int hashCode;

        private AddItem(Builder builder) {
            super(builder);
            this.itemSequence = Collections.unmodifiableList(ValidationSupport.checkList(builder.itemSequence, "itemSequence", PositiveInt.class));
            this.detailSequence = Collections.unmodifiableList(ValidationSupport.checkList(builder.detailSequence, "detailSequence", PositiveInt.class));
            this.subdetailSequence = Collections.unmodifiableList(ValidationSupport.checkList(builder.subdetailSequence, "subdetailSequence", PositiveInt.class));
            this.provider = Collections.unmodifiableList(ValidationSupport.checkList(builder.provider, "provider", Reference.class));
            this.productOrService = ValidationSupport.requireNonNull(builder.productOrService, "productOrService");
            this.modifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifier, "modifier", CodeableConcept.class));
            this.programCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.programCode, "programCode", CodeableConcept.class));
            this.serviced = ValidationSupport.choiceElement(builder.serviced, "serviced", Date.class, Period.class);
            this.location = ValidationSupport.choiceElement(builder.location, "location", CodeableConcept.class, Address.class, Reference.class);
            this.quantity = builder.quantity;
            this.unitPrice = builder.unitPrice;
            this.factor = builder.factor;
            this.net = builder.net;
            this.bodySite = builder.bodySite;
            this.subSite = Collections.unmodifiableList(ValidationSupport.checkList(builder.subSite, "subSite", CodeableConcept.class));
            this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
            this.adjudication = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.adjudication, "adjudication", Item.Adjudication.class));
            this.detail = Collections.unmodifiableList(ValidationSupport.checkList(builder.detail, "detail", Detail.class));
            ValidationSupport.checkReferenceType(this.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(this.location, "location", "Location");
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<PositiveInt> getItemSequence() {
            return this.itemSequence;
        }

        public List<PositiveInt> getDetailSequence() {
            return this.detailSequence;
        }

        public List<PositiveInt> getSubdetailSequence() {
            return this.subdetailSequence;
        }

        public List<Reference> getProvider() {
            return this.provider;
        }

        public CodeableConcept getProductOrService() {
            return this.productOrService;
        }

        public List<CodeableConcept> getModifier() {
            return this.modifier;
        }

        public List<CodeableConcept> getProgramCode() {
            return this.programCode;
        }

        public Element getServiced() {
            return this.serviced;
        }

        public Element getLocation() {
            return this.location;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public Money getUnitPrice() {
            return this.unitPrice;
        }

        public Decimal getFactor() {
            return this.factor;
        }

        public Money getNet() {
            return this.net;
        }

        public CodeableConcept getBodySite() {
            return this.bodySite;
        }

        public List<CodeableConcept> getSubSite() {
            return this.subSite;
        }

        public List<PositiveInt> getNoteNumber() {
            return this.noteNumber;
        }

        public List<Item.Adjudication> getAdjudication() {
            return this.adjudication;
        }

        public List<Detail> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.itemSequence.isEmpty() || !this.detailSequence.isEmpty() || !this.subdetailSequence.isEmpty() || !this.provider.isEmpty() || this.productOrService != null || !this.modifier.isEmpty() || !this.programCode.isEmpty() || this.serviced != null || this.location != null || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || this.bodySite != null || !this.subSite.isEmpty() || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.itemSequence, "itemSequence", visitor, PositiveInt.class);
                    this.accept(this.detailSequence, "detailSequence", visitor, PositiveInt.class);
                    this.accept(this.subdetailSequence, "subdetailSequence", visitor, PositiveInt.class);
                    this.accept(this.provider, "provider", visitor, Reference.class);
                    this.accept(this.productOrService, "productOrService", visitor);
                    this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                    this.accept(this.programCode, "programCode", visitor, CodeableConcept.class);
                    this.accept(this.serviced, "serviced", visitor);
                    this.accept(this.location, "location", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.unitPrice, "unitPrice", visitor);
                    this.accept(this.factor, "factor", visitor);
                    this.accept(this.net, "net", visitor);
                    this.accept(this.bodySite, "bodySite", visitor);
                    this.accept(this.subSite, "subSite", visitor, CodeableConcept.class);
                    this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                    this.accept(this.adjudication, "adjudication", visitor, Item.Adjudication.class);
                    this.accept(this.detail, "detail", visitor, Detail.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddItem other = (AddItem)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.itemSequence, other.itemSequence) && Objects.equals(this.detailSequence, other.detailSequence) && Objects.equals(this.subdetailSequence, other.subdetailSequence) && Objects.equals(this.provider, other.provider) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.programCode, other.programCode) && Objects.equals(this.serviced, other.serviced) && Objects.equals(this.location, other.location) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.subSite, other.subSite) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.itemSequence, this.detailSequence, this.subdetailSequence, this.provider, this.productOrService, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.bodySite, this.subSite, this.noteNumber, this.adjudication, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Detail
        extends BackboneElement {
            @Binding(bindingName="ServiceProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
            @Required
            private final CodeableConcept productOrService;
            @Binding(bindingName="Modifiers", strength=BindingStrength.ValueSet.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
            private final List<CodeableConcept> modifier;
            private final SimpleQuantity quantity;
            private final Money unitPrice;
            private final Decimal factor;
            private final Money net;
            private final List<PositiveInt> noteNumber;
            @Required
            private final List<Item.Adjudication> adjudication;
            private final List<SubDetail> subDetail;
            private volatile int hashCode;

            private Detail(Builder builder) {
                super(builder);
                this.productOrService = ValidationSupport.requireNonNull(builder.productOrService, "productOrService");
                this.modifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifier, "modifier", CodeableConcept.class));
                this.quantity = builder.quantity;
                this.unitPrice = builder.unitPrice;
                this.factor = builder.factor;
                this.net = builder.net;
                this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
                this.adjudication = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.adjudication, "adjudication", Item.Adjudication.class));
                this.subDetail = Collections.unmodifiableList(ValidationSupport.checkList(builder.subDetail, "subDetail", SubDetail.class));
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getProductOrService() {
                return this.productOrService;
            }

            public List<CodeableConcept> getModifier() {
                return this.modifier;
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public Money getUnitPrice() {
                return this.unitPrice;
            }

            public Decimal getFactor() {
                return this.factor;
            }

            public Money getNet() {
                return this.net;
            }

            public List<PositiveInt> getNoteNumber() {
                return this.noteNumber;
            }

            public List<Item.Adjudication> getAdjudication() {
                return this.adjudication;
            }

            public List<SubDetail> getSubDetail() {
                return this.subDetail;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.productOrService != null || !this.modifier.isEmpty() || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty() || !this.subDetail.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.productOrService, "productOrService", visitor);
                        this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.unitPrice, "unitPrice", visitor);
                        this.accept(this.factor, "factor", visitor);
                        this.accept(this.net, "net", visitor);
                        this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                        this.accept(this.adjudication, "adjudication", visitor, Item.Adjudication.class);
                        this.accept(this.subDetail, "subDetail", visitor, SubDetail.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Detail other = (Detail)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication) && Objects.equals(this.subDetail, other.subDetail);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.productOrService, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication, this.subDetail);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class SubDetail
            extends BackboneElement {
                @Binding(bindingName="ServiceProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
                @Required
                private final CodeableConcept productOrService;
                @Binding(bindingName="Modifiers", strength=BindingStrength.ValueSet.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
                private final List<CodeableConcept> modifier;
                private final SimpleQuantity quantity;
                private final Money unitPrice;
                private final Decimal factor;
                private final Money net;
                private final List<PositiveInt> noteNumber;
                @Required
                private final List<Item.Adjudication> adjudication;
                private volatile int hashCode;

                private SubDetail(Builder builder) {
                    super(builder);
                    this.productOrService = ValidationSupport.requireNonNull(builder.productOrService, "productOrService");
                    this.modifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifier, "modifier", CodeableConcept.class));
                    this.quantity = builder.quantity;
                    this.unitPrice = builder.unitPrice;
                    this.factor = builder.factor;
                    this.net = builder.net;
                    this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
                    this.adjudication = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.adjudication, "adjudication", Item.Adjudication.class));
                    ValidationSupport.requireValueOrChildren(this);
                }

                public CodeableConcept getProductOrService() {
                    return this.productOrService;
                }

                public List<CodeableConcept> getModifier() {
                    return this.modifier;
                }

                public SimpleQuantity getQuantity() {
                    return this.quantity;
                }

                public Money getUnitPrice() {
                    return this.unitPrice;
                }

                public Decimal getFactor() {
                    return this.factor;
                }

                public Money getNet() {
                    return this.net;
                }

                public List<PositiveInt> getNoteNumber() {
                    return this.noteNumber;
                }

                public List<Item.Adjudication> getAdjudication() {
                    return this.adjudication;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.productOrService != null || !this.modifier.isEmpty() || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.productOrService, "productOrService", visitor);
                            this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                            this.accept(this.quantity, "quantity", visitor);
                            this.accept(this.unitPrice, "unitPrice", visitor);
                            this.accept(this.factor, "factor", visitor);
                            this.accept(this.net, "net", visitor);
                            this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                            this.accept(this.adjudication, "adjudication", visitor, Item.Adjudication.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SubDetail other = (SubDetail)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.productOrService, this.modifier, this.quantity, this.unitPrice, this.factor, this.net, this.noteNumber, this.adjudication);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept productOrService;
                    private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
                    private SimpleQuantity quantity;
                    private Money unitPrice;
                    private Decimal factor;
                    private Money net;
                    private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
                    private List<Item.Adjudication> adjudication = new ArrayList<Item.Adjudication>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder productOrService(CodeableConcept productOrService) {
                        this.productOrService = productOrService;
                        return this;
                    }

                    public Builder modifier(CodeableConcept ... modifier) {
                        for (CodeableConcept value : modifier) {
                            this.modifier.add(value);
                        }
                        return this;
                    }

                    public Builder modifier(Collection<CodeableConcept> modifier) {
                        this.modifier = new ArrayList<CodeableConcept>(modifier);
                        return this;
                    }

                    public Builder quantity(SimpleQuantity quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder unitPrice(Money unitPrice) {
                        this.unitPrice = unitPrice;
                        return this;
                    }

                    public Builder factor(Decimal factor) {
                        this.factor = factor;
                        return this;
                    }

                    public Builder net(Money net) {
                        this.net = net;
                        return this;
                    }

                    public Builder noteNumber(PositiveInt ... noteNumber) {
                        for (PositiveInt value : noteNumber) {
                            this.noteNumber.add(value);
                        }
                        return this;
                    }

                    public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                        this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                        return this;
                    }

                    public Builder adjudication(Item.Adjudication ... adjudication) {
                        for (Item.Adjudication value : adjudication) {
                            this.adjudication.add(value);
                        }
                        return this;
                    }

                    public Builder adjudication(Collection<Item.Adjudication> adjudication) {
                        this.adjudication = new ArrayList<Item.Adjudication>(adjudication);
                        return this;
                    }

                    @Override
                    public SubDetail build() {
                        return new SubDetail(this);
                    }

                    protected Builder from(SubDetail subDetail) {
                        super.from(subDetail);
                        this.productOrService = subDetail.productOrService;
                        this.modifier.addAll(subDetail.modifier);
                        this.quantity = subDetail.quantity;
                        this.unitPrice = subDetail.unitPrice;
                        this.factor = subDetail.factor;
                        this.net = subDetail.net;
                        this.noteNumber.addAll(subDetail.noteNumber);
                        this.adjudication.addAll(subDetail.adjudication);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept productOrService;
                private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
                private SimpleQuantity quantity;
                private Money unitPrice;
                private Decimal factor;
                private Money net;
                private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
                private List<Item.Adjudication> adjudication = new ArrayList<Item.Adjudication>();
                private List<SubDetail> subDetail = new ArrayList<SubDetail>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder productOrService(CodeableConcept productOrService) {
                    this.productOrService = productOrService;
                    return this;
                }

                public Builder modifier(CodeableConcept ... modifier) {
                    for (CodeableConcept value : modifier) {
                        this.modifier.add(value);
                    }
                    return this;
                }

                public Builder modifier(Collection<CodeableConcept> modifier) {
                    this.modifier = new ArrayList<CodeableConcept>(modifier);
                    return this;
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder unitPrice(Money unitPrice) {
                    this.unitPrice = unitPrice;
                    return this;
                }

                public Builder factor(Decimal factor) {
                    this.factor = factor;
                    return this;
                }

                public Builder net(Money net) {
                    this.net = net;
                    return this;
                }

                public Builder noteNumber(PositiveInt ... noteNumber) {
                    for (PositiveInt value : noteNumber) {
                        this.noteNumber.add(value);
                    }
                    return this;
                }

                public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                    this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                    return this;
                }

                public Builder adjudication(Item.Adjudication ... adjudication) {
                    for (Item.Adjudication value : adjudication) {
                        this.adjudication.add(value);
                    }
                    return this;
                }

                public Builder adjudication(Collection<Item.Adjudication> adjudication) {
                    this.adjudication = new ArrayList<Item.Adjudication>(adjudication);
                    return this;
                }

                public Builder subDetail(SubDetail ... subDetail) {
                    for (SubDetail value : subDetail) {
                        this.subDetail.add(value);
                    }
                    return this;
                }

                public Builder subDetail(Collection<SubDetail> subDetail) {
                    this.subDetail = new ArrayList<SubDetail>(subDetail);
                    return this;
                }

                @Override
                public Detail build() {
                    return new Detail(this);
                }

                protected Builder from(Detail detail) {
                    super.from(detail);
                    this.productOrService = detail.productOrService;
                    this.modifier.addAll(detail.modifier);
                    this.quantity = detail.quantity;
                    this.unitPrice = detail.unitPrice;
                    this.factor = detail.factor;
                    this.net = detail.net;
                    this.noteNumber.addAll(detail.noteNumber);
                    this.adjudication.addAll(detail.adjudication);
                    this.subDetail.addAll(detail.subDetail);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<PositiveInt> itemSequence = new ArrayList<PositiveInt>();
            private List<PositiveInt> detailSequence = new ArrayList<PositiveInt>();
            private List<PositiveInt> subdetailSequence = new ArrayList<PositiveInt>();
            private List<Reference> provider = new ArrayList<Reference>();
            private CodeableConcept productOrService;
            private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> programCode = new ArrayList<CodeableConcept>();
            private Element serviced;
            private Element location;
            private SimpleQuantity quantity;
            private Money unitPrice;
            private Decimal factor;
            private Money net;
            private CodeableConcept bodySite;
            private List<CodeableConcept> subSite = new ArrayList<CodeableConcept>();
            private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
            private List<Item.Adjudication> adjudication = new ArrayList<Item.Adjudication>();
            private List<Detail> detail = new ArrayList<Detail>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder itemSequence(PositiveInt ... itemSequence) {
                for (PositiveInt value : itemSequence) {
                    this.itemSequence.add(value);
                }
                return this;
            }

            public Builder itemSequence(Collection<PositiveInt> itemSequence) {
                this.itemSequence = new ArrayList<PositiveInt>(itemSequence);
                return this;
            }

            public Builder detailSequence(PositiveInt ... detailSequence) {
                for (PositiveInt value : detailSequence) {
                    this.detailSequence.add(value);
                }
                return this;
            }

            public Builder detailSequence(Collection<PositiveInt> detailSequence) {
                this.detailSequence = new ArrayList<PositiveInt>(detailSequence);
                return this;
            }

            public Builder subdetailSequence(PositiveInt ... subdetailSequence) {
                for (PositiveInt value : subdetailSequence) {
                    this.subdetailSequence.add(value);
                }
                return this;
            }

            public Builder subdetailSequence(Collection<PositiveInt> subdetailSequence) {
                this.subdetailSequence = new ArrayList<PositiveInt>(subdetailSequence);
                return this;
            }

            public Builder provider(Reference ... provider) {
                for (Reference value : provider) {
                    this.provider.add(value);
                }
                return this;
            }

            public Builder provider(Collection<Reference> provider) {
                this.provider = new ArrayList<Reference>(provider);
                return this;
            }

            public Builder productOrService(CodeableConcept productOrService) {
                this.productOrService = productOrService;
                return this;
            }

            public Builder modifier(CodeableConcept ... modifier) {
                for (CodeableConcept value : modifier) {
                    this.modifier.add(value);
                }
                return this;
            }

            public Builder modifier(Collection<CodeableConcept> modifier) {
                this.modifier = new ArrayList<CodeableConcept>(modifier);
                return this;
            }

            public Builder programCode(CodeableConcept ... programCode) {
                for (CodeableConcept value : programCode) {
                    this.programCode.add(value);
                }
                return this;
            }

            public Builder programCode(Collection<CodeableConcept> programCode) {
                this.programCode = new ArrayList<CodeableConcept>(programCode);
                return this;
            }

            public Builder serviced(Element serviced) {
                this.serviced = serviced;
                return this;
            }

            public Builder location(Element location) {
                this.location = location;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder unitPrice(Money unitPrice) {
                this.unitPrice = unitPrice;
                return this;
            }

            public Builder factor(Decimal factor) {
                this.factor = factor;
                return this;
            }

            public Builder net(Money net) {
                this.net = net;
                return this;
            }

            public Builder bodySite(CodeableConcept bodySite) {
                this.bodySite = bodySite;
                return this;
            }

            public Builder subSite(CodeableConcept ... subSite) {
                for (CodeableConcept value : subSite) {
                    this.subSite.add(value);
                }
                return this;
            }

            public Builder subSite(Collection<CodeableConcept> subSite) {
                this.subSite = new ArrayList<CodeableConcept>(subSite);
                return this;
            }

            public Builder noteNumber(PositiveInt ... noteNumber) {
                for (PositiveInt value : noteNumber) {
                    this.noteNumber.add(value);
                }
                return this;
            }

            public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                return this;
            }

            public Builder adjudication(Item.Adjudication ... adjudication) {
                for (Item.Adjudication value : adjudication) {
                    this.adjudication.add(value);
                }
                return this;
            }

            public Builder adjudication(Collection<Item.Adjudication> adjudication) {
                this.adjudication = new ArrayList<Item.Adjudication>(adjudication);
                return this;
            }

            public Builder detail(Detail ... detail) {
                for (Detail value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Detail> detail) {
                this.detail = new ArrayList<Detail>(detail);
                return this;
            }

            @Override
            public AddItem build() {
                return new AddItem(this);
            }

            protected Builder from(AddItem addItem) {
                super.from(addItem);
                this.itemSequence.addAll(addItem.itemSequence);
                this.detailSequence.addAll(addItem.detailSequence);
                this.subdetailSequence.addAll(addItem.subdetailSequence);
                this.provider.addAll(addItem.provider);
                this.productOrService = addItem.productOrService;
                this.modifier.addAll(addItem.modifier);
                this.programCode.addAll(addItem.programCode);
                this.serviced = addItem.serviced;
                this.location = addItem.location;
                this.quantity = addItem.quantity;
                this.unitPrice = addItem.unitPrice;
                this.factor = addItem.factor;
                this.net = addItem.net;
                this.bodySite = addItem.bodySite;
                this.subSite.addAll(addItem.subSite);
                this.noteNumber.addAll(addItem.noteNumber);
                this.adjudication.addAll(addItem.adjudication);
                this.detail.addAll(addItem.detail);
                return this;
            }
        }
    }

    public static class Item
    extends BackboneElement {
        @Required
        private final PositiveInt itemSequence;
        private final List<PositiveInt> noteNumber;
        @Required
        private final List<Adjudication> adjudication;
        private final List<Detail> detail;
        private volatile int hashCode;

        private Item(Builder builder) {
            super(builder);
            this.itemSequence = ValidationSupport.requireNonNull(builder.itemSequence, "itemSequence");
            this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
            this.adjudication = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.adjudication, "adjudication", Adjudication.class));
            this.detail = Collections.unmodifiableList(ValidationSupport.checkList(builder.detail, "detail", Detail.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getItemSequence() {
            return this.itemSequence;
        }

        public List<PositiveInt> getNoteNumber() {
            return this.noteNumber;
        }

        public List<Adjudication> getAdjudication() {
            return this.adjudication;
        }

        public List<Detail> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.itemSequence != null || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.itemSequence, "itemSequence", visitor);
                    this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                    this.accept(this.adjudication, "adjudication", visitor, Adjudication.class);
                    this.accept(this.detail, "detail", visitor, Detail.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.itemSequence, other.itemSequence) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.itemSequence, this.noteNumber, this.adjudication, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Detail
        extends BackboneElement {
            @Required
            private final PositiveInt detailSequence;
            private final List<PositiveInt> noteNumber;
            @Required
            private final List<Adjudication> adjudication;
            private final List<SubDetail> subDetail;
            private volatile int hashCode;

            private Detail(Builder builder) {
                super(builder);
                this.detailSequence = ValidationSupport.requireNonNull(builder.detailSequence, "detailSequence");
                this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
                this.adjudication = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.adjudication, "adjudication", Adjudication.class));
                this.subDetail = Collections.unmodifiableList(ValidationSupport.checkList(builder.subDetail, "subDetail", SubDetail.class));
                ValidationSupport.requireValueOrChildren(this);
            }

            public PositiveInt getDetailSequence() {
                return this.detailSequence;
            }

            public List<PositiveInt> getNoteNumber() {
                return this.noteNumber;
            }

            public List<Adjudication> getAdjudication() {
                return this.adjudication;
            }

            public List<SubDetail> getSubDetail() {
                return this.subDetail;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.detailSequence != null || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty() || !this.subDetail.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.detailSequence, "detailSequence", visitor);
                        this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                        this.accept(this.adjudication, "adjudication", visitor, Adjudication.class);
                        this.accept(this.subDetail, "subDetail", visitor, SubDetail.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Detail other = (Detail)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.detailSequence, other.detailSequence) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication) && Objects.equals(this.subDetail, other.subDetail);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.detailSequence, this.noteNumber, this.adjudication, this.subDetail);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class SubDetail
            extends BackboneElement {
                @Required
                private final PositiveInt subDetailSequence;
                private final List<PositiveInt> noteNumber;
                private final List<Adjudication> adjudication;
                private volatile int hashCode;

                private SubDetail(Builder builder) {
                    super(builder);
                    this.subDetailSequence = ValidationSupport.requireNonNull(builder.subDetailSequence, "subDetailSequence");
                    this.noteNumber = Collections.unmodifiableList(ValidationSupport.checkList(builder.noteNumber, "noteNumber", PositiveInt.class));
                    this.adjudication = Collections.unmodifiableList(ValidationSupport.checkList(builder.adjudication, "adjudication", Adjudication.class));
                    ValidationSupport.requireValueOrChildren(this);
                }

                public PositiveInt getSubDetailSequence() {
                    return this.subDetailSequence;
                }

                public List<PositiveInt> getNoteNumber() {
                    return this.noteNumber;
                }

                public List<Adjudication> getAdjudication() {
                    return this.adjudication;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.subDetailSequence != null || !this.noteNumber.isEmpty() || !this.adjudication.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.subDetailSequence, "subDetailSequence", visitor);
                            this.accept(this.noteNumber, "noteNumber", visitor, PositiveInt.class);
                            this.accept(this.adjudication, "adjudication", visitor, Adjudication.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SubDetail other = (SubDetail)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subDetailSequence, other.subDetailSequence) && Objects.equals(this.noteNumber, other.noteNumber) && Objects.equals(this.adjudication, other.adjudication);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.subDetailSequence, this.noteNumber, this.adjudication);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private PositiveInt subDetailSequence;
                    private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
                    private List<Adjudication> adjudication = new ArrayList<Adjudication>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder subDetailSequence(PositiveInt subDetailSequence) {
                        this.subDetailSequence = subDetailSequence;
                        return this;
                    }

                    public Builder noteNumber(PositiveInt ... noteNumber) {
                        for (PositiveInt value : noteNumber) {
                            this.noteNumber.add(value);
                        }
                        return this;
                    }

                    public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                        this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                        return this;
                    }

                    public Builder adjudication(Adjudication ... adjudication) {
                        for (Adjudication value : adjudication) {
                            this.adjudication.add(value);
                        }
                        return this;
                    }

                    public Builder adjudication(Collection<Adjudication> adjudication) {
                        this.adjudication = new ArrayList<Adjudication>(adjudication);
                        return this;
                    }

                    @Override
                    public SubDetail build() {
                        return new SubDetail(this);
                    }

                    protected Builder from(SubDetail subDetail) {
                        super.from(subDetail);
                        this.subDetailSequence = subDetail.subDetailSequence;
                        this.noteNumber.addAll(subDetail.noteNumber);
                        this.adjudication.addAll(subDetail.adjudication);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private PositiveInt detailSequence;
                private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
                private List<Adjudication> adjudication = new ArrayList<Adjudication>();
                private List<SubDetail> subDetail = new ArrayList<SubDetail>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder detailSequence(PositiveInt detailSequence) {
                    this.detailSequence = detailSequence;
                    return this;
                }

                public Builder noteNumber(PositiveInt ... noteNumber) {
                    for (PositiveInt value : noteNumber) {
                        this.noteNumber.add(value);
                    }
                    return this;
                }

                public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                    this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                    return this;
                }

                public Builder adjudication(Adjudication ... adjudication) {
                    for (Adjudication value : adjudication) {
                        this.adjudication.add(value);
                    }
                    return this;
                }

                public Builder adjudication(Collection<Adjudication> adjudication) {
                    this.adjudication = new ArrayList<Adjudication>(adjudication);
                    return this;
                }

                public Builder subDetail(SubDetail ... subDetail) {
                    for (SubDetail value : subDetail) {
                        this.subDetail.add(value);
                    }
                    return this;
                }

                public Builder subDetail(Collection<SubDetail> subDetail) {
                    this.subDetail = new ArrayList<SubDetail>(subDetail);
                    return this;
                }

                @Override
                public Detail build() {
                    return new Detail(this);
                }

                protected Builder from(Detail detail) {
                    super.from(detail);
                    this.detailSequence = detail.detailSequence;
                    this.noteNumber.addAll(detail.noteNumber);
                    this.adjudication.addAll(detail.adjudication);
                    this.subDetail.addAll(detail.subDetail);
                    return this;
                }
            }
        }

        public static class Adjudication
        extends BackboneElement {
            @Binding(bindingName="Adjudication", strength=BindingStrength.ValueSet.EXAMPLE, description="The adjudication codes.", valueSet="http://hl7.org/fhir/ValueSet/adjudication")
            @Required
            private final CodeableConcept category;
            @Binding(bindingName="AdjudicationReason", strength=BindingStrength.ValueSet.EXAMPLE, description="The adjudication reason codes.", valueSet="http://hl7.org/fhir/ValueSet/adjudication-reason")
            private final CodeableConcept reason;
            private final Money amount;
            private final Decimal value;
            private volatile int hashCode;

            private Adjudication(Builder builder) {
                super(builder);
                this.category = ValidationSupport.requireNonNull(builder.category, "category");
                this.reason = builder.reason;
                this.amount = builder.amount;
                this.value = builder.value;
                ValidationSupport.requireValueOrChildren(this);
            }

            public CodeableConcept getCategory() {
                return this.category;
            }

            public CodeableConcept getReason() {
                return this.reason;
            }

            public Money getAmount() {
                return this.amount;
            }

            public Decimal getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.category != null || this.reason != null || this.amount != null || this.value != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.category, "category", visitor);
                        this.accept(this.reason, "reason", visitor);
                        this.accept(this.amount, "amount", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Adjudication other = (Adjudication)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.category, other.category) && Objects.equals(this.reason, other.reason) && Objects.equals(this.amount, other.amount) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.category, this.reason, this.amount, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept category;
                private CodeableConcept reason;
                private Money amount;
                private Decimal value;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder category(CodeableConcept category) {
                    this.category = category;
                    return this;
                }

                public Builder reason(CodeableConcept reason) {
                    this.reason = reason;
                    return this;
                }

                public Builder amount(Money amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder value(Decimal value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Adjudication build() {
                    return new Adjudication(this);
                }

                protected Builder from(Adjudication adjudication) {
                    super.from(adjudication);
                    this.category = adjudication.category;
                    this.reason = adjudication.reason;
                    this.amount = adjudication.amount;
                    this.value = adjudication.value;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt itemSequence;
            private List<PositiveInt> noteNumber = new ArrayList<PositiveInt>();
            private List<Adjudication> adjudication = new ArrayList<Adjudication>();
            private List<Detail> detail = new ArrayList<Detail>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder itemSequence(PositiveInt itemSequence) {
                this.itemSequence = itemSequence;
                return this;
            }

            public Builder noteNumber(PositiveInt ... noteNumber) {
                for (PositiveInt value : noteNumber) {
                    this.noteNumber.add(value);
                }
                return this;
            }

            public Builder noteNumber(Collection<PositiveInt> noteNumber) {
                this.noteNumber = new ArrayList<PositiveInt>(noteNumber);
                return this;
            }

            public Builder adjudication(Adjudication ... adjudication) {
                for (Adjudication value : adjudication) {
                    this.adjudication.add(value);
                }
                return this;
            }

            public Builder adjudication(Collection<Adjudication> adjudication) {
                this.adjudication = new ArrayList<Adjudication>(adjudication);
                return this;
            }

            public Builder detail(Detail ... detail) {
                for (Detail value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Detail> detail) {
                this.detail = new ArrayList<Detail>(detail);
                return this;
            }

            @Override
            public Item build() {
                return new Item(this);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.itemSequence = item.itemSequence;
                this.noteNumber.addAll(item.noteNumber);
                this.adjudication.addAll(item.adjudication);
                this.detail.addAll(item.detail);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ClaimResponseStatus status;
        private CodeableConcept type;
        private CodeableConcept subType;
        private Use use;
        private Reference patient;
        private DateTime created;
        private Reference insurer;
        private Reference requestor;
        private Reference request;
        private RemittanceOutcome outcome;
        private String disposition;
        private String preAuthRef;
        private Period preAuthPeriod;
        private CodeableConcept payeeType;
        private List<Item> item = new ArrayList<Item>();
        private List<AddItem> addItem = new ArrayList<AddItem>();
        private List<Item.Adjudication> adjudication = new ArrayList<Item.Adjudication>();
        private List<Total> total = new ArrayList<Total>();
        private Payment payment;
        private CodeableConcept fundsReserve;
        private CodeableConcept formCode;
        private Attachment form;
        private List<ProcessNote> processNote = new ArrayList<ProcessNote>();
        private List<Reference> communicationRequest = new ArrayList<Reference>();
        private List<Insurance> insurance = new ArrayList<Insurance>();
        private List<Error> error = new ArrayList<Error>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ClaimResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subType(CodeableConcept subType) {
            this.subType = subType;
            return this;
        }

        public Builder use(Use use) {
            this.use = use;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder insurer(Reference insurer) {
            this.insurer = insurer;
            return this;
        }

        public Builder requestor(Reference requestor) {
            this.requestor = requestor;
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder outcome(RemittanceOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder disposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder preAuthRef(String preAuthRef) {
            this.preAuthRef = preAuthRef;
            return this;
        }

        public Builder preAuthPeriod(Period preAuthPeriod) {
            this.preAuthPeriod = preAuthPeriod;
            return this;
        }

        public Builder payeeType(CodeableConcept payeeType) {
            this.payeeType = payeeType;
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        public Builder addItem(AddItem ... addItem) {
            for (AddItem value : addItem) {
                this.addItem.add(value);
            }
            return this;
        }

        public Builder addItem(Collection<AddItem> addItem) {
            this.addItem = new ArrayList<AddItem>(addItem);
            return this;
        }

        public Builder adjudication(Item.Adjudication ... adjudication) {
            for (Item.Adjudication value : adjudication) {
                this.adjudication.add(value);
            }
            return this;
        }

        public Builder adjudication(Collection<Item.Adjudication> adjudication) {
            this.adjudication = new ArrayList<Item.Adjudication>(adjudication);
            return this;
        }

        public Builder total(Total ... total) {
            for (Total value : total) {
                this.total.add(value);
            }
            return this;
        }

        public Builder total(Collection<Total> total) {
            this.total = new ArrayList<Total>(total);
            return this;
        }

        public Builder payment(Payment payment) {
            this.payment = payment;
            return this;
        }

        public Builder fundsReserve(CodeableConcept fundsReserve) {
            this.fundsReserve = fundsReserve;
            return this;
        }

        public Builder formCode(CodeableConcept formCode) {
            this.formCode = formCode;
            return this;
        }

        public Builder form(Attachment form) {
            this.form = form;
            return this;
        }

        public Builder processNote(ProcessNote ... processNote) {
            for (ProcessNote value : processNote) {
                this.processNote.add(value);
            }
            return this;
        }

        public Builder processNote(Collection<ProcessNote> processNote) {
            this.processNote = new ArrayList<ProcessNote>(processNote);
            return this;
        }

        public Builder communicationRequest(Reference ... communicationRequest) {
            for (Reference value : communicationRequest) {
                this.communicationRequest.add(value);
            }
            return this;
        }

        public Builder communicationRequest(Collection<Reference> communicationRequest) {
            this.communicationRequest = new ArrayList<Reference>(communicationRequest);
            return this;
        }

        public Builder insurance(Insurance ... insurance) {
            for (Insurance value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Insurance> insurance) {
            this.insurance = new ArrayList<Insurance>(insurance);
            return this;
        }

        public Builder error(Error ... error) {
            for (Error value : error) {
                this.error.add(value);
            }
            return this;
        }

        public Builder error(Collection<Error> error) {
            this.error = new ArrayList<Error>(error);
            return this;
        }

        @Override
        public ClaimResponse build() {
            return new ClaimResponse(this);
        }

        protected Builder from(ClaimResponse claimResponse) {
            super.from(claimResponse);
            this.identifier.addAll(claimResponse.identifier);
            this.status = claimResponse.status;
            this.type = claimResponse.type;
            this.subType = claimResponse.subType;
            this.use = claimResponse.use;
            this.patient = claimResponse.patient;
            this.created = claimResponse.created;
            this.insurer = claimResponse.insurer;
            this.requestor = claimResponse.requestor;
            this.request = claimResponse.request;
            this.outcome = claimResponse.outcome;
            this.disposition = claimResponse.disposition;
            this.preAuthRef = claimResponse.preAuthRef;
            this.preAuthPeriod = claimResponse.preAuthPeriod;
            this.payeeType = claimResponse.payeeType;
            this.item.addAll(claimResponse.item);
            this.addItem.addAll(claimResponse.addItem);
            this.adjudication.addAll(claimResponse.adjudication);
            this.total.addAll(claimResponse.total);
            this.payment = claimResponse.payment;
            this.fundsReserve = claimResponse.fundsReserve;
            this.formCode = claimResponse.formCode;
            this.form = claimResponse.form;
            this.processNote.addAll(claimResponse.processNote);
            this.communicationRequest.addAll(claimResponse.communicationRequest);
            this.insurance.addAll(claimResponse.insurance);
            this.error.addAll(claimResponse.error);
            return this;
        }
    }
}

