/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CommunicationPriority;
import com.ibm.fhir.model.type.code.CommunicationRequestStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
public class CommunicationRequest
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"CommunicationRequest"})
    private final List<Reference> replaces;
    @Summary
    private final Identifier groupIdentifier;
    @Summary
    @Binding(bindingName="CommunicationRequestStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the communication request.", valueSet="http://hl7.org/fhir/ValueSet/request-status|4.0.1")
    @Required
    private final CommunicationRequestStatus status;
    @Binding(bindingName="CommunicationRequestStatusReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes identifying the reason for the current state of a request.")
    private final CodeableConcept statusReason;
    @Binding(bindingName="CommunicationCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes for general categories of communications such as alerts, instruction, etc.", valueSet="http://hl7.org/fhir/ValueSet/communication-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="CommunicationPriority", strength=BindingStrength.ValueSet.REQUIRED, description="Codes indicating the relative importance of a communication request.", valueSet="http://hl7.org/fhir/ValueSet/request-priority|4.0.1")
    private final CommunicationPriority priority;
    @Summary
    private final Boolean doNotPerform;
    @Binding(bindingName="CommunicationMedium", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes for communication mediums such as phone, fax, email, in person, etc.", valueSet="http://terminology.hl7.org/ValueSet/v3-ParticipationMode")
    private final List<CodeableConcept> medium;
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    private final List<Reference> about;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    private final List<Payload> payload;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element occurrence;
    @Summary
    private final DateTime authoredOn;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device"})
    private final Reference requester;
    @ReferenceTarget(value={"Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Group", "CareTeam", "HealthcareService"})
    private final List<Reference> recipient;
    @Summary
    @ReferenceTarget(value={"Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "HealthcareService"})
    private final Reference sender;
    @Summary
    @Binding(bindingName="CommunicationReason", strength=BindingStrength.ValueSet.EXAMPLE, description="Codes for describing reasons for the occurrence of a communication.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActReason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport", "DocumentReference"})
    private final List<Reference> reasonReference;
    private final List<Annotation> note;
    private volatile int hashCode;

    private CommunicationRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.replaces = Collections.unmodifiableList(ValidationSupport.checkList(builder.replaces, "replaces", Reference.class));
        this.groupIdentifier = builder.groupIdentifier;
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusReason = builder.statusReason;
        this.category = Collections.unmodifiableList(ValidationSupport.checkList(builder.category, "category", CodeableConcept.class));
        this.priority = builder.priority;
        this.doNotPerform = builder.doNotPerform;
        this.medium = Collections.unmodifiableList(ValidationSupport.checkList(builder.medium, "medium", CodeableConcept.class));
        this.subject = builder.subject;
        this.about = Collections.unmodifiableList(ValidationSupport.checkList(builder.about, "about", Reference.class));
        this.encounter = builder.encounter;
        this.payload = Collections.unmodifiableList(ValidationSupport.checkList(builder.payload, "payload", Payload.class));
        this.occurrence = ValidationSupport.choiceElement(builder.occurrence, "occurrence", DateTime.class, Period.class);
        this.authoredOn = builder.authoredOn;
        this.requester = builder.requester;
        this.recipient = Collections.unmodifiableList(ValidationSupport.checkList(builder.recipient, "recipient", Reference.class));
        this.sender = builder.sender;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        ValidationSupport.checkReferenceType(this.replaces, "replaces", "CommunicationRequest");
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.encounter, "encounter", "Encounter");
        ValidationSupport.checkReferenceType(this.requester, "requester", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson", "Device");
        ValidationSupport.checkReferenceType(this.recipient, "recipient", "Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "Group", "CareTeam", "HealthcareService");
        ValidationSupport.checkReferenceType(this.sender, "sender", "Device", "Organization", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson", "HealthcareService");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport", "DocumentReference");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getReplaces() {
        return this.replaces;
    }

    public Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public CommunicationRequestStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CommunicationPriority getPriority() {
        return this.priority;
    }

    public Boolean getDoNotPerform() {
        return this.doNotPerform;
    }

    public List<CodeableConcept> getMedium() {
        return this.medium;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public List<Reference> getAbout() {
        return this.about;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public List<Payload> getPayload() {
        return this.payload;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public DateTime getAuthoredOn() {
        return this.authoredOn;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public List<Reference> getRecipient() {
        return this.recipient;
    }

    public Reference getSender() {
        return this.sender;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || !this.replaces.isEmpty() || this.groupIdentifier != null || this.status != null || this.statusReason != null || !this.category.isEmpty() || this.priority != null || this.doNotPerform != null || !this.medium.isEmpty() || this.subject != null || !this.about.isEmpty() || this.encounter != null || !this.payload.isEmpty() || this.occurrence != null || this.authoredOn != null || this.requester != null || !this.recipient.isEmpty() || this.sender != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.replaces, "replaces", visitor, Reference.class);
                this.accept(this.groupIdentifier, "groupIdentifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.doNotPerform, "doNotPerform", visitor);
                this.accept(this.medium, "medium", visitor, CodeableConcept.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.about, "about", visitor, Reference.class);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.payload, "payload", visitor, Payload.class);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.authoredOn, "authoredOn", visitor);
                this.accept(this.requester, "requester", visitor);
                this.accept(this.recipient, "recipient", visitor, Reference.class);
                this.accept(this.sender, "sender", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicationRequest other = (CommunicationRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.replaces, other.replaces) && Objects.equals(this.groupIdentifier, other.groupIdentifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.category, other.category) && Objects.equals(this.priority, other.priority) && Objects.equals(this.doNotPerform, other.doNotPerform) && Objects.equals(this.medium, other.medium) && Objects.equals(this.subject, other.subject) && Objects.equals(this.about, other.about) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.payload, other.payload) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.authoredOn, other.authoredOn) && Objects.equals(this.requester, other.requester) && Objects.equals(this.recipient, other.recipient) && Objects.equals(this.sender, other.sender) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.statusReason, this.category, this.priority, this.doNotPerform, this.medium, this.subject, this.about, this.encounter, this.payload, this.occurrence, this.authoredOn, this.requester, this.recipient, this.sender, this.reasonCode, this.reasonReference, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Payload
    extends BackboneElement {
        @Choice(value={String.class, Attachment.class, Reference.class})
        @Required
        private final Element content;
        private volatile int hashCode;

        private Payload(Builder builder) {
            super(builder);
            this.content = ValidationSupport.requireChoiceElement(builder.content, "content", String.class, Attachment.class, Reference.class);
            ValidationSupport.requireValueOrChildren(this);
        }

        public Element getContent() {
            return this.content;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.content != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.content, "content", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Payload other = (Payload)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.content, other.content);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.content);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element content;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder content(Element content) {
                this.content = content;
                return this;
            }

            @Override
            public Payload build() {
                return new Payload(this);
            }

            protected Builder from(Payload payload) {
                super.from(payload);
                this.content = payload.content;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> replaces = new ArrayList<Reference>();
        private Identifier groupIdentifier;
        private CommunicationRequestStatus status;
        private CodeableConcept statusReason;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CommunicationPriority priority;
        private Boolean doNotPerform;
        private List<CodeableConcept> medium = new ArrayList<CodeableConcept>();
        private Reference subject;
        private List<Reference> about = new ArrayList<Reference>();
        private Reference encounter;
        private List<Payload> payload = new ArrayList<Payload>();
        private Element occurrence;
        private DateTime authoredOn;
        private Reference requester;
        private List<Reference> recipient = new ArrayList<Reference>();
        private Reference sender;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder replaces(Reference ... replaces) {
            for (Reference value : replaces) {
                this.replaces.add(value);
            }
            return this;
        }

        public Builder replaces(Collection<Reference> replaces) {
            this.replaces = new ArrayList<Reference>(replaces);
            return this;
        }

        public Builder groupIdentifier(Identifier groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public Builder status(CommunicationRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder priority(CommunicationPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder doNotPerform(Boolean doNotPerform) {
            this.doNotPerform = doNotPerform;
            return this;
        }

        public Builder medium(CodeableConcept ... medium) {
            for (CodeableConcept value : medium) {
                this.medium.add(value);
            }
            return this;
        }

        public Builder medium(Collection<CodeableConcept> medium) {
            this.medium = new ArrayList<CodeableConcept>(medium);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder about(Reference ... about) {
            for (Reference value : about) {
                this.about.add(value);
            }
            return this;
        }

        public Builder about(Collection<Reference> about) {
            this.about = new ArrayList<Reference>(about);
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder payload(Payload ... payload) {
            for (Payload value : payload) {
                this.payload.add(value);
            }
            return this;
        }

        public Builder payload(Collection<Payload> payload) {
            this.payload = new ArrayList<Payload>(payload);
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder authoredOn(DateTime authoredOn) {
            this.authoredOn = authoredOn;
            return this;
        }

        public Builder requester(Reference requester) {
            this.requester = requester;
            return this;
        }

        public Builder recipient(Reference ... recipient) {
            for (Reference value : recipient) {
                this.recipient.add(value);
            }
            return this;
        }

        public Builder recipient(Collection<Reference> recipient) {
            this.recipient = new ArrayList<Reference>(recipient);
            return this;
        }

        public Builder sender(Reference sender) {
            this.sender = sender;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public CommunicationRequest build() {
            return new CommunicationRequest(this);
        }

        protected Builder from(CommunicationRequest communicationRequest) {
            super.from(communicationRequest);
            this.identifier.addAll(communicationRequest.identifier);
            this.basedOn.addAll(communicationRequest.basedOn);
            this.replaces.addAll(communicationRequest.replaces);
            this.groupIdentifier = communicationRequest.groupIdentifier;
            this.status = communicationRequest.status;
            this.statusReason = communicationRequest.statusReason;
            this.category.addAll(communicationRequest.category);
            this.priority = communicationRequest.priority;
            this.doNotPerform = communicationRequest.doNotPerform;
            this.medium.addAll(communicationRequest.medium);
            this.subject = communicationRequest.subject;
            this.about.addAll(communicationRequest.about);
            this.encounter = communicationRequest.encounter;
            this.payload.addAll(communicationRequest.payload);
            this.occurrence = communicationRequest.occurrence;
            this.authoredOn = communicationRequest.authoredOn;
            this.requester = communicationRequest.requester;
            this.recipient.addAll(communicationRequest.recipient);
            this.sender = communicationRequest.sender;
            this.reasonCode.addAll(communicationRequest.reasonCode);
            this.reasonReference.addAll(communicationRequest.reasonReference);
            this.note.addAll(communicationRequest.note);
            return this;
        }
    }
}

