/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EligibilityRequestPurpose;
import com.ibm.fhir.model.type.code.EligibilityRequestStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
public class CoverageEligibilityRequest
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EligibilityRequestStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final EligibilityRequestStatus status;
    @Binding(bindingName="ProcessPriority", strength=BindingStrength.ValueSet.EXAMPLE, description="The timeliness with which processing is required: STAT, normal, Deferred.", valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    private final CodeableConcept priority;
    @Summary
    @Binding(bindingName="EligibilityRequestPurpose", strength=BindingStrength.ValueSet.REQUIRED, description="A code specifying the types of information being requested.", valueSet="http://hl7.org/fhir/ValueSet/eligibilityrequest-purpose|4.0.1")
    @Required
    private final List<EligibilityRequestPurpose> purpose;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Choice(value={Date.class, Period.class})
    private final Element serviced;
    @Summary
    @Required
    private final DateTime created;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference enterer;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference provider;
    @Summary
    @ReferenceTarget(value={"Organization"})
    @Required
    private final Reference insurer;
    @ReferenceTarget(value={"Location"})
    private final Reference facility;
    private final List<SupportingInfo> supportingInfo;
    private final List<Insurance> insurance;
    private final List<Item> item;
    private volatile int hashCode;

    private CoverageEligibilityRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.priority = builder.priority;
        this.purpose = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.purpose, "purpose", EligibilityRequestPurpose.class));
        this.patient = ValidationSupport.requireNonNull(builder.patient, "patient");
        this.serviced = ValidationSupport.choiceElement(builder.serviced, "serviced", Date.class, Period.class);
        this.created = ValidationSupport.requireNonNull(builder.created, "created");
        this.enterer = builder.enterer;
        this.provider = builder.provider;
        this.insurer = ValidationSupport.requireNonNull(builder.insurer, "insurer");
        this.facility = builder.facility;
        this.supportingInfo = Collections.unmodifiableList(ValidationSupport.checkList(builder.supportingInfo, "supportingInfo", SupportingInfo.class));
        this.insurance = Collections.unmodifiableList(ValidationSupport.checkList(builder.insurance, "insurance", Insurance.class));
        this.item = Collections.unmodifiableList(ValidationSupport.checkList(builder.item, "item", Item.class));
        ValidationSupport.checkReferenceType(this.patient, "patient", "Patient");
        ValidationSupport.checkReferenceType(this.enterer, "enterer", "Practitioner", "PractitionerRole");
        ValidationSupport.checkReferenceType(this.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
        ValidationSupport.checkReferenceType(this.insurer, "insurer", "Organization");
        ValidationSupport.checkReferenceType(this.facility, "facility", "Location");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EligibilityRequestStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public List<EligibilityRequestPurpose> getPurpose() {
        return this.purpose;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Element getServiced() {
        return this.serviced;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public Reference getInsurer() {
        return this.insurer;
    }

    public Reference getFacility() {
        return this.facility;
    }

    public List<SupportingInfo> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Insurance> getInsurance() {
        return this.insurance;
    }

    public List<Item> getItem() {
        return this.item;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.priority != null || !this.purpose.isEmpty() || this.patient != null || this.serviced != null || this.created != null || this.enterer != null || this.provider != null || this.insurer != null || this.facility != null || !this.supportingInfo.isEmpty() || !this.insurance.isEmpty() || !this.item.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.purpose, "purpose", visitor, EligibilityRequestPurpose.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.serviced, "serviced", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.enterer, "enterer", visitor);
                this.accept(this.provider, "provider", visitor);
                this.accept(this.insurer, "insurer", visitor);
                this.accept(this.facility, "facility", visitor);
                this.accept(this.supportingInfo, "supportingInfo", visitor, SupportingInfo.class);
                this.accept(this.insurance, "insurance", visitor, Insurance.class);
                this.accept(this.item, "item", visitor, Item.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverageEligibilityRequest other = (CoverageEligibilityRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.priority, other.priority) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.patient, other.patient) && Objects.equals(this.serviced, other.serviced) && Objects.equals(this.created, other.created) && Objects.equals(this.enterer, other.enterer) && Objects.equals(this.provider, other.provider) && Objects.equals(this.insurer, other.insurer) && Objects.equals(this.facility, other.facility) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.item, other.item);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.priority, this.purpose, this.patient, this.serviced, this.created, this.enterer, this.provider, this.insurer, this.facility, this.supportingInfo, this.insurance, this.item);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Item
    extends BackboneElement {
        private final List<PositiveInt> supportingInfoSequence;
        @Binding(bindingName="BenefitCategory", strength=BindingStrength.ValueSet.EXAMPLE, description="Benefit categories such as: oral, medical, vision etc.", valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        private final CodeableConcept category;
        @Binding(bindingName="ServiceProduct", strength=BindingStrength.ValueSet.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        private final CodeableConcept productOrService;
        @Binding(bindingName="Modifiers", strength=BindingStrength.ValueSet.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        private final List<CodeableConcept> modifier;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
        private final Reference provider;
        private final SimpleQuantity quantity;
        private final Money unitPrice;
        @ReferenceTarget(value={"Location", "Organization"})
        private final Reference facility;
        private final List<Diagnosis> diagnosis;
        private final List<Reference> detail;
        private volatile int hashCode;

        private Item(Builder builder) {
            super(builder);
            this.supportingInfoSequence = Collections.unmodifiableList(ValidationSupport.checkList(builder.supportingInfoSequence, "supportingInfoSequence", PositiveInt.class));
            this.category = builder.category;
            this.productOrService = builder.productOrService;
            this.modifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.modifier, "modifier", CodeableConcept.class));
            this.provider = builder.provider;
            this.quantity = builder.quantity;
            this.unitPrice = builder.unitPrice;
            this.facility = builder.facility;
            this.diagnosis = Collections.unmodifiableList(ValidationSupport.checkList(builder.diagnosis, "diagnosis", Diagnosis.class));
            this.detail = Collections.unmodifiableList(ValidationSupport.checkList(builder.detail, "detail", Reference.class));
            ValidationSupport.checkReferenceType(this.provider, "provider", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(this.facility, "facility", "Location", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<PositiveInt> getSupportingInfoSequence() {
            return this.supportingInfoSequence;
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public CodeableConcept getProductOrService() {
            return this.productOrService;
        }

        public List<CodeableConcept> getModifier() {
            return this.modifier;
        }

        public Reference getProvider() {
            return this.provider;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public Money getUnitPrice() {
            return this.unitPrice;
        }

        public Reference getFacility() {
            return this.facility;
        }

        public List<Diagnosis> getDiagnosis() {
            return this.diagnosis;
        }

        public List<Reference> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.supportingInfoSequence.isEmpty() || this.category != null || this.productOrService != null || !this.modifier.isEmpty() || this.provider != null || this.quantity != null || this.unitPrice != null || this.facility != null || !this.diagnosis.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.supportingInfoSequence, "supportingInfoSequence", visitor, PositiveInt.class);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.productOrService, "productOrService", visitor);
                    this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                    this.accept(this.provider, "provider", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.unitPrice, "unitPrice", visitor);
                    this.accept(this.facility, "facility", visitor);
                    this.accept(this.diagnosis, "diagnosis", visitor, Diagnosis.class);
                    this.accept(this.detail, "detail", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.supportingInfoSequence, other.supportingInfoSequence) && Objects.equals(this.category, other.category) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.provider, other.provider) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.facility, other.facility) && Objects.equals(this.diagnosis, other.diagnosis) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.supportingInfoSequence, this.category, this.productOrService, this.modifier, this.provider, this.quantity, this.unitPrice, this.facility, this.diagnosis, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Diagnosis
        extends BackboneElement {
            @ReferenceTarget(value={"Condition"})
            @Choice(value={CodeableConcept.class, Reference.class})
            @Binding(bindingName="ICD10", strength=BindingStrength.ValueSet.EXAMPLE, description="ICD10 Diagnostic codes.", valueSet="http://hl7.org/fhir/ValueSet/icd-10")
            private final Element diagnosis;
            private volatile int hashCode;

            private Diagnosis(Builder builder) {
                super(builder);
                this.diagnosis = ValidationSupport.choiceElement(builder.diagnosis, "diagnosis", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(this.diagnosis, "diagnosis", "Condition");
                ValidationSupport.requireValueOrChildren(this);
            }

            public Element getDiagnosis() {
                return this.diagnosis;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.diagnosis != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.diagnosis, "diagnosis", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Diagnosis other = (Diagnosis)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.diagnosis, other.diagnosis);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.diagnosis);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element diagnosis;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder diagnosis(Element diagnosis) {
                    this.diagnosis = diagnosis;
                    return this;
                }

                @Override
                public Diagnosis build() {
                    return new Diagnosis(this);
                }

                protected Builder from(Diagnosis diagnosis) {
                    super.from(diagnosis);
                    this.diagnosis = diagnosis.diagnosis;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<PositiveInt> supportingInfoSequence = new ArrayList<PositiveInt>();
            private CodeableConcept category;
            private CodeableConcept productOrService;
            private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
            private Reference provider;
            private SimpleQuantity quantity;
            private Money unitPrice;
            private Reference facility;
            private List<Diagnosis> diagnosis = new ArrayList<Diagnosis>();
            private List<Reference> detail = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder supportingInfoSequence(PositiveInt ... supportingInfoSequence) {
                for (PositiveInt value : supportingInfoSequence) {
                    this.supportingInfoSequence.add(value);
                }
                return this;
            }

            public Builder supportingInfoSequence(Collection<PositiveInt> supportingInfoSequence) {
                this.supportingInfoSequence = new ArrayList<PositiveInt>(supportingInfoSequence);
                return this;
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder productOrService(CodeableConcept productOrService) {
                this.productOrService = productOrService;
                return this;
            }

            public Builder modifier(CodeableConcept ... modifier) {
                for (CodeableConcept value : modifier) {
                    this.modifier.add(value);
                }
                return this;
            }

            public Builder modifier(Collection<CodeableConcept> modifier) {
                this.modifier = new ArrayList<CodeableConcept>(modifier);
                return this;
            }

            public Builder provider(Reference provider) {
                this.provider = provider;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder unitPrice(Money unitPrice) {
                this.unitPrice = unitPrice;
                return this;
            }

            public Builder facility(Reference facility) {
                this.facility = facility;
                return this;
            }

            public Builder diagnosis(Diagnosis ... diagnosis) {
                for (Diagnosis value : diagnosis) {
                    this.diagnosis.add(value);
                }
                return this;
            }

            public Builder diagnosis(Collection<Diagnosis> diagnosis) {
                this.diagnosis = new ArrayList<Diagnosis>(diagnosis);
                return this;
            }

            public Builder detail(Reference ... detail) {
                for (Reference value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Reference> detail) {
                this.detail = new ArrayList<Reference>(detail);
                return this;
            }

            @Override
            public Item build() {
                return new Item(this);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.supportingInfoSequence.addAll(item.supportingInfoSequence);
                this.category = item.category;
                this.productOrService = item.productOrService;
                this.modifier.addAll(item.modifier);
                this.provider = item.provider;
                this.quantity = item.quantity;
                this.unitPrice = item.unitPrice;
                this.facility = item.facility;
                this.diagnosis.addAll(item.diagnosis);
                this.detail.addAll(item.detail);
                return this;
            }
        }
    }

    public static class Insurance
    extends BackboneElement {
        private final Boolean focal;
        @ReferenceTarget(value={"Coverage"})
        @Required
        private final Reference coverage;
        private final String businessArrangement;
        private volatile int hashCode;

        private Insurance(Builder builder) {
            super(builder);
            this.focal = builder.focal;
            this.coverage = ValidationSupport.requireNonNull(builder.coverage, "coverage");
            this.businessArrangement = builder.businessArrangement;
            ValidationSupport.checkReferenceType(this.coverage, "coverage", "Coverage");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Boolean getFocal() {
            return this.focal;
        }

        public Reference getCoverage() {
            return this.coverage;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.focal != null || this.coverage != null || this.businessArrangement != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.focal, "focal", visitor);
                    this.accept(this.coverage, "coverage", visitor);
                    this.accept(this.businessArrangement, "businessArrangement", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Insurance other = (Insurance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.focal, other.focal) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.businessArrangement, other.businessArrangement);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.focal, this.coverage, this.businessArrangement);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean focal;
            private Reference coverage;
            private String businessArrangement;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder focal(Boolean focal) {
                this.focal = focal;
                return this;
            }

            public Builder coverage(Reference coverage) {
                this.coverage = coverage;
                return this;
            }

            public Builder businessArrangement(String businessArrangement) {
                this.businessArrangement = businessArrangement;
                return this;
            }

            @Override
            public Insurance build() {
                return new Insurance(this);
            }

            protected Builder from(Insurance insurance) {
                super.from(insurance);
                this.focal = insurance.focal;
                this.coverage = insurance.coverage;
                this.businessArrangement = insurance.businessArrangement;
                return this;
            }
        }
    }

    public static class SupportingInfo
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @Required
        private final Reference information;
        private final Boolean appliesToAll;
        private volatile int hashCode;

        private SupportingInfo(Builder builder) {
            super(builder);
            this.sequence = ValidationSupport.requireNonNull(builder.sequence, "sequence");
            this.information = ValidationSupport.requireNonNull(builder.information, "information");
            this.appliesToAll = builder.appliesToAll;
            ValidationSupport.requireValueOrChildren(this);
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Reference getInformation() {
            return this.information;
        }

        public Boolean getAppliesToAll() {
            return this.appliesToAll;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.information != null || this.appliesToAll != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.information, "information", visitor);
                    this.accept(this.appliesToAll, "appliesToAll", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SupportingInfo other = (SupportingInfo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.information, other.information) && Objects.equals(this.appliesToAll, other.appliesToAll);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.information, this.appliesToAll);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Reference information;
            private Boolean appliesToAll;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder information(Reference information) {
                this.information = information;
                return this;
            }

            public Builder appliesToAll(Boolean appliesToAll) {
                this.appliesToAll = appliesToAll;
                return this;
            }

            @Override
            public SupportingInfo build() {
                return new SupportingInfo(this);
            }

            protected Builder from(SupportingInfo supportingInfo) {
                super.from(supportingInfo);
                this.sequence = supportingInfo.sequence;
                this.information = supportingInfo.information;
                this.appliesToAll = supportingInfo.appliesToAll;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EligibilityRequestStatus status;
        private CodeableConcept priority;
        private List<EligibilityRequestPurpose> purpose = new ArrayList<EligibilityRequestPurpose>();
        private Reference patient;
        private Element serviced;
        private DateTime created;
        private Reference enterer;
        private Reference provider;
        private Reference insurer;
        private Reference facility;
        private List<SupportingInfo> supportingInfo = new ArrayList<SupportingInfo>();
        private List<Insurance> insurance = new ArrayList<Insurance>();
        private List<Item> item = new ArrayList<Item>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EligibilityRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder priority(CodeableConcept priority) {
            this.priority = priority;
            return this;
        }

        public Builder purpose(EligibilityRequestPurpose ... purpose) {
            for (EligibilityRequestPurpose value : purpose) {
                this.purpose.add(value);
            }
            return this;
        }

        public Builder purpose(Collection<EligibilityRequestPurpose> purpose) {
            this.purpose = new ArrayList<EligibilityRequestPurpose>(purpose);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder serviced(Element serviced) {
            this.serviced = serviced;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder enterer(Reference enterer) {
            this.enterer = enterer;
            return this;
        }

        public Builder provider(Reference provider) {
            this.provider = provider;
            return this;
        }

        public Builder insurer(Reference insurer) {
            this.insurer = insurer;
            return this;
        }

        public Builder facility(Reference facility) {
            this.facility = facility;
            return this;
        }

        public Builder supportingInfo(SupportingInfo ... supportingInfo) {
            for (SupportingInfo value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<SupportingInfo> supportingInfo) {
            this.supportingInfo = new ArrayList<SupportingInfo>(supportingInfo);
            return this;
        }

        public Builder insurance(Insurance ... insurance) {
            for (Insurance value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Insurance> insurance) {
            this.insurance = new ArrayList<Insurance>(insurance);
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        @Override
        public CoverageEligibilityRequest build() {
            return new CoverageEligibilityRequest(this);
        }

        protected Builder from(CoverageEligibilityRequest coverageEligibilityRequest) {
            super.from(coverageEligibilityRequest);
            this.identifier.addAll(coverageEligibilityRequest.identifier);
            this.status = coverageEligibilityRequest.status;
            this.priority = coverageEligibilityRequest.priority;
            this.purpose.addAll(coverageEligibilityRequest.purpose);
            this.patient = coverageEligibilityRequest.patient;
            this.serviced = coverageEligibilityRequest.serviced;
            this.created = coverageEligibilityRequest.created;
            this.enterer = coverageEligibilityRequest.enterer;
            this.provider = coverageEligibilityRequest.provider;
            this.insurer = coverageEligibilityRequest.insurer;
            this.facility = coverageEligibilityRequest.facility;
            this.supportingInfo.addAll(coverageEligibilityRequest.supportingInfo);
            this.insurance.addAll(coverageEligibilityRequest.insurance);
            this.item.addAll(coverageEligibilityRequest.item);
            return this;
        }
    }
}

