/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DeviceNameType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class DeviceDefinition
extends DomainResource {
    private final List<Identifier> identifier;
    private final List<UdiDeviceIdentifier> udiDeviceIdentifier;
    @ReferenceTarget(value={"Organization"})
    @Choice(value={String.class, Reference.class})
    private final Element manufacturer;
    private final List<DeviceName> deviceName;
    private final String modelNumber;
    @Binding(bindingName="DeviceKind", strength=BindingStrength.ValueSet.EXAMPLE, description="Type of device e.g. according to official classification.", valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    private final CodeableConcept type;
    private final List<Specialization> specialization;
    private final List<String> version;
    @Summary
    @Binding(bindingName="Safety", strength=BindingStrength.ValueSet.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/device-safety")
    private final List<CodeableConcept> safety;
    private final List<ProductShelfLife> shelfLifeStorage;
    private final ProdCharacteristic physicalCharacteristics;
    private final List<CodeableConcept> languageCode;
    private final List<Capability> capability;
    private final List<Property> property;
    @ReferenceTarget(value={"Organization"})
    private final Reference owner;
    private final List<ContactPoint> contact;
    private final Uri url;
    private final Uri onlineInformation;
    private final List<Annotation> note;
    private final Quantity quantity;
    @Summary
    @ReferenceTarget(value={"DeviceDefinition"})
    private final Reference parentDevice;
    private final List<Material> material;
    private volatile int hashCode;

    private DeviceDefinition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.udiDeviceIdentifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.udiDeviceIdentifier, "udiDeviceIdentifier", UdiDeviceIdentifier.class));
        this.manufacturer = ValidationSupport.choiceElement(builder.manufacturer, "manufacturer", String.class, Reference.class);
        this.deviceName = Collections.unmodifiableList(ValidationSupport.checkList(builder.deviceName, "deviceName", DeviceName.class));
        this.modelNumber = builder.modelNumber;
        this.type = builder.type;
        this.specialization = Collections.unmodifiableList(ValidationSupport.checkList(builder.specialization, "specialization", Specialization.class));
        this.version = Collections.unmodifiableList(ValidationSupport.checkList(builder.version, "version", String.class));
        this.safety = Collections.unmodifiableList(ValidationSupport.checkList(builder.safety, "safety", CodeableConcept.class));
        this.shelfLifeStorage = Collections.unmodifiableList(ValidationSupport.checkList(builder.shelfLifeStorage, "shelfLifeStorage", ProductShelfLife.class));
        this.physicalCharacteristics = builder.physicalCharacteristics;
        this.languageCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.languageCode, "languageCode", CodeableConcept.class));
        this.capability = Collections.unmodifiableList(ValidationSupport.checkList(builder.capability, "capability", Capability.class));
        this.property = Collections.unmodifiableList(ValidationSupport.checkList(builder.property, "property", Property.class));
        this.owner = builder.owner;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactPoint.class));
        this.url = builder.url;
        this.onlineInformation = builder.onlineInformation;
        this.note = Collections.unmodifiableList(ValidationSupport.checkList(builder.note, "note", Annotation.class));
        this.quantity = builder.quantity;
        this.parentDevice = builder.parentDevice;
        this.material = Collections.unmodifiableList(ValidationSupport.checkList(builder.material, "material", Material.class));
        ValidationSupport.checkReferenceType(this.manufacturer, "manufacturer", "Organization");
        ValidationSupport.checkReferenceType(this.owner, "owner", "Organization");
        ValidationSupport.checkReferenceType(this.parentDevice, "parentDevice", "DeviceDefinition");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<UdiDeviceIdentifier> getUdiDeviceIdentifier() {
        return this.udiDeviceIdentifier;
    }

    public Element getManufacturer() {
        return this.manufacturer;
    }

    public List<DeviceName> getDeviceName() {
        return this.deviceName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<Specialization> getSpecialization() {
        return this.specialization;
    }

    public List<String> getVersion() {
        return this.version;
    }

    public List<CodeableConcept> getSafety() {
        return this.safety;
    }

    public List<ProductShelfLife> getShelfLifeStorage() {
        return this.shelfLifeStorage;
    }

    public ProdCharacteristic getPhysicalCharacteristics() {
        return this.physicalCharacteristics;
    }

    public List<CodeableConcept> getLanguageCode() {
        return this.languageCode;
    }

    public List<Capability> getCapability() {
        return this.capability;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public List<ContactPoint> getContact() {
        return this.contact;
    }

    public Uri getUrl() {
        return this.url;
    }

    public Uri getOnlineInformation() {
        return this.onlineInformation;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public Reference getParentDevice() {
        return this.parentDevice;
    }

    public List<Material> getMaterial() {
        return this.material;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.udiDeviceIdentifier.isEmpty() || this.manufacturer != null || !this.deviceName.isEmpty() || this.modelNumber != null || this.type != null || !this.specialization.isEmpty() || !this.version.isEmpty() || !this.safety.isEmpty() || !this.shelfLifeStorage.isEmpty() || this.physicalCharacteristics != null || !this.languageCode.isEmpty() || !this.capability.isEmpty() || !this.property.isEmpty() || this.owner != null || !this.contact.isEmpty() || this.url != null || this.onlineInformation != null || !this.note.isEmpty() || this.quantity != null || this.parentDevice != null || !this.material.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.udiDeviceIdentifier, "udiDeviceIdentifier", visitor, UdiDeviceIdentifier.class);
                this.accept(this.manufacturer, "manufacturer", visitor);
                this.accept(this.deviceName, "deviceName", visitor, DeviceName.class);
                this.accept(this.modelNumber, "modelNumber", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.specialization, "specialization", visitor, Specialization.class);
                this.accept(this.version, "version", visitor, String.class);
                this.accept(this.safety, "safety", visitor, CodeableConcept.class);
                this.accept(this.shelfLifeStorage, "shelfLifeStorage", visitor, ProductShelfLife.class);
                this.accept(this.physicalCharacteristics, "physicalCharacteristics", visitor);
                this.accept(this.languageCode, "languageCode", visitor, CodeableConcept.class);
                this.accept(this.capability, "capability", visitor, Capability.class);
                this.accept(this.property, "property", visitor, Property.class);
                this.accept(this.owner, "owner", visitor);
                this.accept(this.contact, "contact", visitor, ContactPoint.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.onlineInformation, "onlineInformation", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.parentDevice, "parentDevice", visitor);
                this.accept(this.material, "material", visitor, Material.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceDefinition other = (DeviceDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.udiDeviceIdentifier, other.udiDeviceIdentifier) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.deviceName, other.deviceName) && Objects.equals(this.modelNumber, other.modelNumber) && Objects.equals(this.type, other.type) && Objects.equals(this.specialization, other.specialization) && Objects.equals(this.version, other.version) && Objects.equals(this.safety, other.safety) && Objects.equals(this.shelfLifeStorage, other.shelfLifeStorage) && Objects.equals(this.physicalCharacteristics, other.physicalCharacteristics) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.capability, other.capability) && Objects.equals(this.property, other.property) && Objects.equals(this.owner, other.owner) && Objects.equals(this.contact, other.contact) && Objects.equals(this.url, other.url) && Objects.equals(this.onlineInformation, other.onlineInformation) && Objects.equals(this.note, other.note) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.parentDevice, other.parentDevice) && Objects.equals(this.material, other.material);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.udiDeviceIdentifier, this.manufacturer, this.deviceName, this.modelNumber, this.type, this.specialization, this.version, this.safety, this.shelfLifeStorage, this.physicalCharacteristics, this.languageCode, this.capability, this.property, this.owner, this.contact, this.url, this.onlineInformation, this.note, this.quantity, this.parentDevice, this.material);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Material
    extends BackboneElement {
        @Required
        private final CodeableConcept substance;
        private final Boolean alternate;
        private final Boolean allergenicIndicator;
        private volatile int hashCode;

        private Material(Builder builder) {
            super(builder);
            this.substance = ValidationSupport.requireNonNull(builder.substance, "substance");
            this.alternate = builder.alternate;
            this.allergenicIndicator = builder.allergenicIndicator;
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getSubstance() {
            return this.substance;
        }

        public Boolean getAlternate() {
            return this.alternate;
        }

        public Boolean getAllergenicIndicator() {
            return this.allergenicIndicator;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.substance != null || this.alternate != null || this.allergenicIndicator != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.substance, "substance", visitor);
                    this.accept(this.alternate, "alternate", visitor);
                    this.accept(this.allergenicIndicator, "allergenicIndicator", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Material other = (Material)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.substance, other.substance) && Objects.equals(this.alternate, other.alternate) && Objects.equals(this.allergenicIndicator, other.allergenicIndicator);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.substance, this.alternate, this.allergenicIndicator);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept substance;
            private Boolean alternate;
            private Boolean allergenicIndicator;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder substance(CodeableConcept substance) {
                this.substance = substance;
                return this;
            }

            public Builder alternate(Boolean alternate) {
                this.alternate = alternate;
                return this;
            }

            public Builder allergenicIndicator(Boolean allergenicIndicator) {
                this.allergenicIndicator = allergenicIndicator;
                return this;
            }

            @Override
            public Material build() {
                return new Material(this);
            }

            protected Builder from(Material material) {
                super.from(material);
                this.substance = material.substance;
                this.alternate = material.alternate;
                this.allergenicIndicator = material.allergenicIndicator;
                return this;
            }
        }
    }

    public static class Property
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        private final List<Quantity> valueQuantity;
        private final List<CodeableConcept> valueCode;
        private volatile int hashCode;

        private Property(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.valueQuantity = Collections.unmodifiableList(ValidationSupport.checkList(builder.valueQuantity, "valueQuantity", Quantity.class));
            this.valueCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.valueCode, "valueCode", CodeableConcept.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<Quantity> getValueQuantity() {
            return this.valueQuantity;
        }

        public List<CodeableConcept> getValueCode() {
            return this.valueCode;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.valueQuantity.isEmpty() || !this.valueCode.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.valueQuantity, "valueQuantity", visitor, Quantity.class);
                    this.accept(this.valueCode, "valueCode", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.valueQuantity, other.valueQuantity) && Objects.equals(this.valueCode, other.valueCode);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.valueQuantity, this.valueCode);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<Quantity> valueQuantity = new ArrayList<Quantity>();
            private List<CodeableConcept> valueCode = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder valueQuantity(Quantity ... valueQuantity) {
                for (Quantity value : valueQuantity) {
                    this.valueQuantity.add(value);
                }
                return this;
            }

            public Builder valueQuantity(Collection<Quantity> valueQuantity) {
                this.valueQuantity = new ArrayList<Quantity>(valueQuantity);
                return this;
            }

            public Builder valueCode(CodeableConcept ... valueCode) {
                for (CodeableConcept value : valueCode) {
                    this.valueCode.add(value);
                }
                return this;
            }

            public Builder valueCode(Collection<CodeableConcept> valueCode) {
                this.valueCode = new ArrayList<CodeableConcept>(valueCode);
                return this;
            }

            @Override
            public Property build() {
                return new Property(this);
            }

            protected Builder from(Property property) {
                super.from(property);
                this.type = property.type;
                this.valueQuantity.addAll(property.valueQuantity);
                this.valueCode.addAll(property.valueCode);
                return this;
            }
        }
    }

    public static class Capability
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        private final List<CodeableConcept> description;
        private volatile int hashCode;

        private Capability(Builder builder) {
            super(builder);
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            this.description = Collections.unmodifiableList(ValidationSupport.checkList(builder.description, "description", CodeableConcept.class));
            ValidationSupport.requireValueOrChildren(this);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getDescription() {
            return this.description;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.description.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.description, "description", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Capability other = (Capability)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.description, other.description);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.description);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<CodeableConcept> description = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder description(CodeableConcept ... description) {
                for (CodeableConcept value : description) {
                    this.description.add(value);
                }
                return this;
            }

            public Builder description(Collection<CodeableConcept> description) {
                this.description = new ArrayList<CodeableConcept>(description);
                return this;
            }

            @Override
            public Capability build() {
                return new Capability(this);
            }

            protected Builder from(Capability capability) {
                super.from(capability);
                this.type = capability.type;
                this.description.addAll(capability.description);
                return this;
            }
        }
    }

    public static class Specialization
    extends BackboneElement {
        @Required
        private final String systemType;
        private final String version;
        private volatile int hashCode;

        private Specialization(Builder builder) {
            super(builder);
            this.systemType = ValidationSupport.requireNonNull(builder.systemType, "systemType");
            this.version = builder.version;
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getSystemType() {
            return this.systemType;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.systemType != null || this.version != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.systemType, "systemType", visitor);
                    this.accept(this.version, "version", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Specialization other = (Specialization)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.systemType, other.systemType) && Objects.equals(this.version, other.version);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.systemType, this.version);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String systemType;
            private String version;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder systemType(String systemType) {
                this.systemType = systemType;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            @Override
            public Specialization build() {
                return new Specialization(this);
            }

            protected Builder from(Specialization specialization) {
                super.from(specialization);
                this.systemType = specialization.systemType;
                this.version = specialization.version;
                return this;
            }
        }
    }

    public static class DeviceName
    extends BackboneElement {
        @Required
        private final String name;
        @Binding(bindingName="DeviceNameType", strength=BindingStrength.ValueSet.REQUIRED, description="The type of name the device is referred by.", valueSet="http://hl7.org/fhir/ValueSet/device-nametype|4.0.1")
        @Required
        private final DeviceNameType type;
        private volatile int hashCode;

        private DeviceName(Builder builder) {
            super(builder);
            this.name = ValidationSupport.requireNonNull(builder.name, "name");
            this.type = ValidationSupport.requireNonNull(builder.type, "type");
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getName() {
            return this.name;
        }

        public DeviceNameType getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.type != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeviceName other = (DeviceName)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private DeviceNameType type;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(DeviceNameType type) {
                this.type = type;
                return this;
            }

            @Override
            public DeviceName build() {
                return new DeviceName(this);
            }

            protected Builder from(DeviceName deviceName) {
                super.from(deviceName);
                this.name = deviceName.name;
                this.type = deviceName.type;
                return this;
            }
        }
    }

    public static class UdiDeviceIdentifier
    extends BackboneElement {
        @Required
        private final String deviceIdentifier;
        @Required
        private final Uri issuer;
        @Required
        private final Uri jurisdiction;
        private volatile int hashCode;

        private UdiDeviceIdentifier(Builder builder) {
            super(builder);
            this.deviceIdentifier = ValidationSupport.requireNonNull(builder.deviceIdentifier, "deviceIdentifier");
            this.issuer = ValidationSupport.requireNonNull(builder.issuer, "issuer");
            this.jurisdiction = ValidationSupport.requireNonNull(builder.jurisdiction, "jurisdiction");
            ValidationSupport.requireValueOrChildren(this);
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier;
        }

        public Uri getIssuer() {
            return this.issuer;
        }

        public Uri getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.deviceIdentifier != null || this.issuer != null || this.jurisdiction != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.deviceIdentifier, "deviceIdentifier", visitor);
                    this.accept(this.issuer, "issuer", visitor);
                    this.accept(this.jurisdiction, "jurisdiction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UdiDeviceIdentifier other = (UdiDeviceIdentifier)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.deviceIdentifier, other.deviceIdentifier) && Objects.equals(this.issuer, other.issuer) && Objects.equals(this.jurisdiction, other.jurisdiction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.deviceIdentifier, this.issuer, this.jurisdiction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String deviceIdentifier;
            private Uri issuer;
            private Uri jurisdiction;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder deviceIdentifier(String deviceIdentifier) {
                this.deviceIdentifier = deviceIdentifier;
                return this;
            }

            public Builder issuer(Uri issuer) {
                this.issuer = issuer;
                return this;
            }

            public Builder jurisdiction(Uri jurisdiction) {
                this.jurisdiction = jurisdiction;
                return this;
            }

            @Override
            public UdiDeviceIdentifier build() {
                return new UdiDeviceIdentifier(this);
            }

            protected Builder from(UdiDeviceIdentifier udiDeviceIdentifier) {
                super.from(udiDeviceIdentifier);
                this.deviceIdentifier = udiDeviceIdentifier.deviceIdentifier;
                this.issuer = udiDeviceIdentifier.issuer;
                this.jurisdiction = udiDeviceIdentifier.jurisdiction;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<UdiDeviceIdentifier> udiDeviceIdentifier = new ArrayList<UdiDeviceIdentifier>();
        private Element manufacturer;
        private List<DeviceName> deviceName = new ArrayList<DeviceName>();
        private String modelNumber;
        private CodeableConcept type;
        private List<Specialization> specialization = new ArrayList<Specialization>();
        private List<String> version = new ArrayList<String>();
        private List<CodeableConcept> safety = new ArrayList<CodeableConcept>();
        private List<ProductShelfLife> shelfLifeStorage = new ArrayList<ProductShelfLife>();
        private ProdCharacteristic physicalCharacteristics;
        private List<CodeableConcept> languageCode = new ArrayList<CodeableConcept>();
        private List<Capability> capability = new ArrayList<Capability>();
        private List<Property> property = new ArrayList<Property>();
        private Reference owner;
        private List<ContactPoint> contact = new ArrayList<ContactPoint>();
        private Uri url;
        private Uri onlineInformation;
        private List<Annotation> note = new ArrayList<Annotation>();
        private Quantity quantity;
        private Reference parentDevice;
        private List<Material> material = new ArrayList<Material>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder udiDeviceIdentifier(UdiDeviceIdentifier ... udiDeviceIdentifier) {
            for (UdiDeviceIdentifier value : udiDeviceIdentifier) {
                this.udiDeviceIdentifier.add(value);
            }
            return this;
        }

        public Builder udiDeviceIdentifier(Collection<UdiDeviceIdentifier> udiDeviceIdentifier) {
            this.udiDeviceIdentifier = new ArrayList<UdiDeviceIdentifier>(udiDeviceIdentifier);
            return this;
        }

        public Builder manufacturer(Element manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder deviceName(DeviceName ... deviceName) {
            for (DeviceName value : deviceName) {
                this.deviceName.add(value);
            }
            return this;
        }

        public Builder deviceName(Collection<DeviceName> deviceName) {
            this.deviceName = new ArrayList<DeviceName>(deviceName);
            return this;
        }

        public Builder modelNumber(String modelNumber) {
            this.modelNumber = modelNumber;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder specialization(Specialization ... specialization) {
            for (Specialization value : specialization) {
                this.specialization.add(value);
            }
            return this;
        }

        public Builder specialization(Collection<Specialization> specialization) {
            this.specialization = new ArrayList<Specialization>(specialization);
            return this;
        }

        public Builder version(String ... version) {
            for (String value : version) {
                this.version.add(value);
            }
            return this;
        }

        public Builder version(Collection<String> version) {
            this.version = new ArrayList<String>(version);
            return this;
        }

        public Builder safety(CodeableConcept ... safety) {
            for (CodeableConcept value : safety) {
                this.safety.add(value);
            }
            return this;
        }

        public Builder safety(Collection<CodeableConcept> safety) {
            this.safety = new ArrayList<CodeableConcept>(safety);
            return this;
        }

        public Builder shelfLifeStorage(ProductShelfLife ... shelfLifeStorage) {
            for (ProductShelfLife value : shelfLifeStorage) {
                this.shelfLifeStorage.add(value);
            }
            return this;
        }

        public Builder shelfLifeStorage(Collection<ProductShelfLife> shelfLifeStorage) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>(shelfLifeStorage);
            return this;
        }

        public Builder physicalCharacteristics(ProdCharacteristic physicalCharacteristics) {
            this.physicalCharacteristics = physicalCharacteristics;
            return this;
        }

        public Builder languageCode(CodeableConcept ... languageCode) {
            for (CodeableConcept value : languageCode) {
                this.languageCode.add(value);
            }
            return this;
        }

        public Builder languageCode(Collection<CodeableConcept> languageCode) {
            this.languageCode = new ArrayList<CodeableConcept>(languageCode);
            return this;
        }

        public Builder capability(Capability ... capability) {
            for (Capability value : capability) {
                this.capability.add(value);
            }
            return this;
        }

        public Builder capability(Collection<Capability> capability) {
            this.capability = new ArrayList<Capability>(capability);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public Builder owner(Reference owner) {
            this.owner = owner;
            return this;
        }

        public Builder contact(ContactPoint ... contact) {
            for (ContactPoint value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactPoint> contact) {
            this.contact = new ArrayList<ContactPoint>(contact);
            return this;
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder onlineInformation(Uri onlineInformation) {
            this.onlineInformation = onlineInformation;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder parentDevice(Reference parentDevice) {
            this.parentDevice = parentDevice;
            return this;
        }

        public Builder material(Material ... material) {
            for (Material value : material) {
                this.material.add(value);
            }
            return this;
        }

        public Builder material(Collection<Material> material) {
            this.material = new ArrayList<Material>(material);
            return this;
        }

        @Override
        public DeviceDefinition build() {
            return new DeviceDefinition(this);
        }

        protected Builder from(DeviceDefinition deviceDefinition) {
            super.from(deviceDefinition);
            this.identifier.addAll(deviceDefinition.identifier);
            this.udiDeviceIdentifier.addAll(deviceDefinition.udiDeviceIdentifier);
            this.manufacturer = deviceDefinition.manufacturer;
            this.deviceName.addAll(deviceDefinition.deviceName);
            this.modelNumber = deviceDefinition.modelNumber;
            this.type = deviceDefinition.type;
            this.specialization.addAll(deviceDefinition.specialization);
            this.version.addAll(deviceDefinition.version);
            this.safety.addAll(deviceDefinition.safety);
            this.shelfLifeStorage.addAll(deviceDefinition.shelfLifeStorage);
            this.physicalCharacteristics = deviceDefinition.physicalCharacteristics;
            this.languageCode.addAll(deviceDefinition.languageCode);
            this.capability.addAll(deviceDefinition.capability);
            this.property.addAll(deviceDefinition.property);
            this.owner = deviceDefinition.owner;
            this.contact.addAll(deviceDefinition.contact);
            this.url = deviceDefinition.url;
            this.onlineInformation = deviceDefinition.onlineInformation;
            this.note.addAll(deviceDefinition.note);
            this.quantity = deviceDefinition.quantity;
            this.parentDevice = deviceDefinition.parentDevice;
            this.material.addAll(deviceDefinition.material);
            return this;
        }
    }
}

