/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationState;
import com.ibm.fhir.model.type.code.DeviceMetricCalibrationType;
import com.ibm.fhir.model.type.code.DeviceMetricCategory;
import com.ibm.fhir.model.type.code.DeviceMetricColor;
import com.ibm.fhir.model.type.code.DeviceMetricOperationalStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="deviceMetric-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/devicemetric-type", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/devicemetric-type', 'preferred')", generated=true), @Constraint(id="deviceMetric-1", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/devicemetric-type", expression="unit.exists() implies (unit.memberOf('http://hl7.org/fhir/ValueSet/devicemetric-type', 'preferred'))", generated=true)})
public class DeviceMetric
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="MetricType", strength=BindingStrength.ValueSet.PREFERRED, description="Describes the metric type.", valueSet="http://hl7.org/fhir/ValueSet/devicemetric-type")
    @Required
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="MetricUnit", strength=BindingStrength.ValueSet.PREFERRED, description="Describes the unit of the metric.", valueSet="http://hl7.org/fhir/ValueSet/devicemetric-type")
    private final CodeableConcept unit;
    @Summary
    @ReferenceTarget(value={"Device"})
    private final Reference source;
    @Summary
    @ReferenceTarget(value={"Device"})
    private final Reference parent;
    @Summary
    @Binding(bindingName="DeviceMetricOperationalStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Describes the operational status of the DeviceMetric.", valueSet="http://hl7.org/fhir/ValueSet/metric-operational-status|4.0.1")
    private final DeviceMetricOperationalStatus operationalStatus;
    @Summary
    @Binding(bindingName="DeviceMetricColor", strength=BindingStrength.ValueSet.REQUIRED, description="Describes the typical color of representation.", valueSet="http://hl7.org/fhir/ValueSet/metric-color|4.0.1")
    private final DeviceMetricColor color;
    @Summary
    @Binding(bindingName="DeviceMetricCategory", strength=BindingStrength.ValueSet.REQUIRED, description="Describes the category of the metric.", valueSet="http://hl7.org/fhir/ValueSet/metric-category|4.0.1")
    @Required
    private final DeviceMetricCategory category;
    @Summary
    private final Timing measurementPeriod;
    @Summary
    private final List<Calibration> calibration;
    private volatile int hashCode;

    private DeviceMetric(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.type = ValidationSupport.requireNonNull(builder.type, "type");
        this.unit = builder.unit;
        this.source = builder.source;
        this.parent = builder.parent;
        this.operationalStatus = builder.operationalStatus;
        this.color = builder.color;
        this.category = ValidationSupport.requireNonNull(builder.category, "category");
        this.measurementPeriod = builder.measurementPeriod;
        this.calibration = Collections.unmodifiableList(ValidationSupport.checkList(builder.calibration, "calibration", Calibration.class));
        ValidationSupport.checkReferenceType(this.source, "source", "Device");
        ValidationSupport.checkReferenceType(this.parent, "parent", "Device");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getUnit() {
        return this.unit;
    }

    public Reference getSource() {
        return this.source;
    }

    public Reference getParent() {
        return this.parent;
    }

    public DeviceMetricOperationalStatus getOperationalStatus() {
        return this.operationalStatus;
    }

    public DeviceMetricColor getColor() {
        return this.color;
    }

    public DeviceMetricCategory getCategory() {
        return this.category;
    }

    public Timing getMeasurementPeriod() {
        return this.measurementPeriod;
    }

    public List<Calibration> getCalibration() {
        return this.calibration;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.unit != null || this.source != null || this.parent != null || this.operationalStatus != null || this.color != null || this.category != null || this.measurementPeriod != null || !this.calibration.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.unit, "unit", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.parent, "parent", visitor);
                this.accept(this.operationalStatus, "operationalStatus", visitor);
                this.accept(this.color, "color", visitor);
                this.accept(this.category, "category", visitor);
                this.accept(this.measurementPeriod, "measurementPeriod", visitor);
                this.accept(this.calibration, "calibration", visitor, Calibration.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceMetric other = (DeviceMetric)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.unit, other.unit) && Objects.equals(this.source, other.source) && Objects.equals(this.parent, other.parent) && Objects.equals(this.operationalStatus, other.operationalStatus) && Objects.equals(this.color, other.color) && Objects.equals(this.category, other.category) && Objects.equals(this.measurementPeriod, other.measurementPeriod) && Objects.equals(this.calibration, other.calibration);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.unit, this.source, this.parent, this.operationalStatus, this.color, this.category, this.measurementPeriod, this.calibration);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Calibration
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DeviceMetricCalibrationType", strength=BindingStrength.ValueSet.REQUIRED, description="Describes the type of a metric calibration.", valueSet="http://hl7.org/fhir/ValueSet/metric-calibration-type|4.0.1")
        private final DeviceMetricCalibrationType type;
        @Summary
        @Binding(bindingName="DeviceMetricCalibrationState", strength=BindingStrength.ValueSet.REQUIRED, description="Describes the state of a metric calibration.", valueSet="http://hl7.org/fhir/ValueSet/metric-calibration-state|4.0.1")
        private final DeviceMetricCalibrationState state;
        @Summary
        private final Instant time;
        private volatile int hashCode;

        private Calibration(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.state = builder.state;
            this.time = builder.time;
            ValidationSupport.requireValueOrChildren(this);
        }

        public DeviceMetricCalibrationType getType() {
            return this.type;
        }

        public DeviceMetricCalibrationState getState() {
            return this.state;
        }

        public Instant getTime() {
            return this.time;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.state != null || this.time != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.state, "state", visitor);
                    this.accept(this.time, "time", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Calibration other = (Calibration)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.state, other.state) && Objects.equals(this.time, other.time);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.state, this.time);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private DeviceMetricCalibrationType type;
            private DeviceMetricCalibrationState state;
            private Instant time;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(DeviceMetricCalibrationType type) {
                this.type = type;
                return this;
            }

            public Builder state(DeviceMetricCalibrationState state) {
                this.state = state;
                return this;
            }

            public Builder time(Instant time) {
                this.time = time;
                return this;
            }

            @Override
            public Calibration build() {
                return new Calibration(this);
            }

            protected Builder from(Calibration calibration) {
                super.from(calibration);
                this.type = calibration.type;
                this.state = calibration.state;
                this.time = calibration.time;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept type;
        private CodeableConcept unit;
        private Reference source;
        private Reference parent;
        private DeviceMetricOperationalStatus operationalStatus;
        private DeviceMetricColor color;
        private DeviceMetricCategory category;
        private Timing measurementPeriod;
        private List<Calibration> calibration = new ArrayList<Calibration>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder unit(CodeableConcept unit) {
            this.unit = unit;
            return this;
        }

        public Builder source(Reference source) {
            this.source = source;
            return this;
        }

        public Builder parent(Reference parent) {
            this.parent = parent;
            return this;
        }

        public Builder operationalStatus(DeviceMetricOperationalStatus operationalStatus) {
            this.operationalStatus = operationalStatus;
            return this;
        }

        public Builder color(DeviceMetricColor color) {
            this.color = color;
            return this;
        }

        public Builder category(DeviceMetricCategory category) {
            this.category = category;
            return this;
        }

        public Builder measurementPeriod(Timing measurementPeriod) {
            this.measurementPeriod = measurementPeriod;
            return this;
        }

        public Builder calibration(Calibration ... calibration) {
            for (Calibration value : calibration) {
                this.calibration.add(value);
            }
            return this;
        }

        public Builder calibration(Collection<Calibration> calibration) {
            this.calibration = new ArrayList<Calibration>(calibration);
            return this;
        }

        @Override
        public DeviceMetric build() {
            return new DeviceMetric(this);
        }

        protected Builder from(DeviceMetric deviceMetric) {
            super.from(deviceMetric);
            this.identifier.addAll(deviceMetric.identifier);
            this.type = deviceMetric.type;
            this.unit = deviceMetric.unit;
            this.source = deviceMetric.source;
            this.parent = deviceMetric.parent;
            this.operationalStatus = deviceMetric.operationalStatus;
            this.color = deviceMetric.color;
            this.category = deviceMetric.category;
            this.measurementPeriod = deviceMetric.measurementPeriod;
            this.calibration.addAll(deviceMetric.calibration);
            return this;
        }
    }
}

