/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EncounterLocationStatus;
import com.ibm.fhir.model.type.code.EncounterStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraints(value={@Constraint(id="encounter-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-ActEncounterCode", expression="class.exists() and class.memberOf('http://terminology.hl7.org/ValueSet/v3-ActEncounterCode', 'extensible')", generated=true), @Constraint(id="encounter-1", level="Warning", location="classHistory.class", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-ActEncounterCode", expression="$this.memberOf('http://terminology.hl7.org/ValueSet/v3-ActEncounterCode', 'extensible')", generated=true), @Constraint(id="encounter-2", level="Warning", location="participant.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/encounter-participant-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/encounter-participant-type', 'extensible')", generated=true), @Constraint(id="encounter-3", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/encounter-reason", expression="reasonCode.exists() implies (reasonCode.all(memberOf('http://hl7.org/fhir/ValueSet/encounter-reason', 'preferred')))", generated=true), @Constraint(id="encounter-4", level="Warning", location="diagnosis.use", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/diagnosis-role", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/diagnosis-role', 'preferred')", generated=true), @Constraint(id="encounter-5", level="Warning", location="hospitalization.admitSource", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/encounter-admit-source", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/encounter-admit-source', 'preferred')", generated=true), @Constraint(id="encounter-6", level="Warning", location="hospitalization.specialCourtesy", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/encounter-special-courtesy", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/encounter-special-courtesy', 'preferred')", generated=true), @Constraint(id="encounter-7", level="Warning", location="hospitalization.specialArrangement", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/encounter-special-arrangements", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/encounter-special-arrangements', 'preferred')", generated=true)})
public class Encounter
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EncounterStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Current state of the encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-status|4.0.1")
    @Required
    private final EncounterStatus status;
    private final List<StatusHistory> statusHistory;
    @Summary
    @Binding(bindingName="EncounterClass", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Classification of the encounter.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActEncounterCode")
    @Required
    private final Coding clazz;
    private final List<ClassHistory> classHistory;
    @Summary
    @Binding(bindingName="EncounterType", strength=BindingStrength.ValueSet.EXAMPLE, description="The type of encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-type")
    private final List<CodeableConcept> type;
    @Summary
    @Binding(bindingName="EncounterServiceType", strength=BindingStrength.ValueSet.EXAMPLE, description="Broad categorization of the service that is to be provided.", valueSet="http://hl7.org/fhir/ValueSet/service-type")
    private final CodeableConcept serviceType;
    @Binding(bindingName="Priority", strength=BindingStrength.ValueSet.EXAMPLE, description="Indicates the urgency of the encounter.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActPriority")
    private final CodeableConcept priority;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"EpisodeOfCare"})
    private final List<Reference> episodeOfCare;
    @ReferenceTarget(value={"ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    private final List<Participant> participant;
    @Summary
    @ReferenceTarget(value={"Appointment"})
    private final List<Reference> appointment;
    private final Period period;
    private final Duration length;
    @Summary
    @Binding(bindingName="EncounterReason", strength=BindingStrength.ValueSet.PREFERRED, description="Reason why the encounter takes place.", valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    private final List<CodeableConcept> reasonCode;
    @Summary
    @ReferenceTarget(value={"Condition", "Procedure", "Observation", "ImmunizationRecommendation"})
    private final List<Reference> reasonReference;
    @Summary
    private final List<Diagnosis> diagnosis;
    @ReferenceTarget(value={"Account"})
    private final List<Reference> account;
    private final Hospitalization hospitalization;
    private final List<Location> location;
    @ReferenceTarget(value={"Organization"})
    private final Reference serviceProvider;
    @ReferenceTarget(value={"Encounter"})
    private final Reference partOf;
    private volatile int hashCode;

    private Encounter(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.statusHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.statusHistory, "statusHistory", StatusHistory.class));
        this.clazz = ValidationSupport.requireNonNull(builder.clazz, "class");
        this.classHistory = Collections.unmodifiableList(ValidationSupport.checkList(builder.classHistory, "classHistory", ClassHistory.class));
        this.type = Collections.unmodifiableList(ValidationSupport.checkList(builder.type, "type", CodeableConcept.class));
        this.serviceType = builder.serviceType;
        this.priority = builder.priority;
        this.subject = builder.subject;
        this.episodeOfCare = Collections.unmodifiableList(ValidationSupport.checkList(builder.episodeOfCare, "episodeOfCare", Reference.class));
        this.basedOn = Collections.unmodifiableList(ValidationSupport.checkList(builder.basedOn, "basedOn", Reference.class));
        this.participant = Collections.unmodifiableList(ValidationSupport.checkList(builder.participant, "participant", Participant.class));
        this.appointment = Collections.unmodifiableList(ValidationSupport.checkList(builder.appointment, "appointment", Reference.class));
        this.period = builder.period;
        this.length = builder.length;
        this.reasonCode = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonCode, "reasonCode", CodeableConcept.class));
        this.reasonReference = Collections.unmodifiableList(ValidationSupport.checkList(builder.reasonReference, "reasonReference", Reference.class));
        this.diagnosis = Collections.unmodifiableList(ValidationSupport.checkList(builder.diagnosis, "diagnosis", Diagnosis.class));
        this.account = Collections.unmodifiableList(ValidationSupport.checkList(builder.account, "account", Reference.class));
        this.hospitalization = builder.hospitalization;
        this.location = Collections.unmodifiableList(ValidationSupport.checkList(builder.location, "location", Location.class));
        this.serviceProvider = builder.serviceProvider;
        this.partOf = builder.partOf;
        ValidationSupport.checkReferenceType(this.subject, "subject", "Patient", "Group");
        ValidationSupport.checkReferenceType(this.episodeOfCare, "episodeOfCare", "EpisodeOfCare");
        ValidationSupport.checkReferenceType(this.basedOn, "basedOn", "ServiceRequest");
        ValidationSupport.checkReferenceType(this.appointment, "appointment", "Appointment");
        ValidationSupport.checkReferenceType(this.reasonReference, "reasonReference", "Condition", "Procedure", "Observation", "ImmunizationRecommendation");
        ValidationSupport.checkReferenceType(this.account, "account", "Account");
        ValidationSupport.checkReferenceType(this.serviceProvider, "serviceProvider", "Organization");
        ValidationSupport.checkReferenceType(this.partOf, "partOf", "Encounter");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EncounterStatus getStatus() {
        return this.status;
    }

    public List<StatusHistory> getStatusHistory() {
        return this.statusHistory;
    }

    public Coding getClazz() {
        return this.clazz;
    }

    public List<ClassHistory> getClassHistory() {
        return this.classHistory;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public CodeableConcept getServiceType() {
        return this.serviceType;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public List<Reference> getEpisodeOfCare() {
        return this.episodeOfCare;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Participant> getParticipant() {
        return this.participant;
    }

    public List<Reference> getAppointment() {
        return this.appointment;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Duration getLength() {
        return this.length;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public List<Diagnosis> getDiagnosis() {
        return this.diagnosis;
    }

    public List<Reference> getAccount() {
        return this.account;
    }

    public Hospitalization getHospitalization() {
        return this.hospitalization;
    }

    public List<Location> getLocation() {
        return this.location;
    }

    public Reference getServiceProvider() {
        return this.serviceProvider;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.statusHistory.isEmpty() || this.clazz != null || !this.classHistory.isEmpty() || !this.type.isEmpty() || this.serviceType != null || this.priority != null || this.subject != null || !this.episodeOfCare.isEmpty() || !this.basedOn.isEmpty() || !this.participant.isEmpty() || !this.appointment.isEmpty() || this.period != null || this.length != null || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || !this.diagnosis.isEmpty() || !this.account.isEmpty() || this.hospitalization != null || !this.location.isEmpty() || this.serviceProvider != null || this.partOf != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusHistory, "statusHistory", visitor, StatusHistory.class);
                this.accept(this.clazz, "class", visitor);
                this.accept(this.classHistory, "classHistory", visitor, ClassHistory.class);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.serviceType, "serviceType", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.episodeOfCare, "episodeOfCare", visitor, Reference.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.participant, "participant", visitor, Participant.class);
                this.accept(this.appointment, "appointment", visitor, Reference.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.length, "length", visitor);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.diagnosis, "diagnosis", visitor, Diagnosis.class);
                this.accept(this.account, "account", visitor, Reference.class);
                this.accept(this.hospitalization, "hospitalization", visitor);
                this.accept(this.location, "location", visitor, Location.class);
                this.accept(this.serviceProvider, "serviceProvider", visitor);
                this.accept(this.partOf, "partOf", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Encounter other = (Encounter)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.statusHistory, other.statusHistory) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.classHistory, other.classHistory) && Objects.equals(this.type, other.type) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.priority, other.priority) && Objects.equals(this.subject, other.subject) && Objects.equals(this.episodeOfCare, other.episodeOfCare) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.participant, other.participant) && Objects.equals(this.appointment, other.appointment) && Objects.equals(this.period, other.period) && Objects.equals(this.length, other.length) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.diagnosis, other.diagnosis) && Objects.equals(this.account, other.account) && Objects.equals(this.hospitalization, other.hospitalization) && Objects.equals(this.location, other.location) && Objects.equals(this.serviceProvider, other.serviceProvider) && Objects.equals(this.partOf, other.partOf);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.statusHistory, this.clazz, this.classHistory, this.type, this.serviceType, this.priority, this.subject, this.episodeOfCare, this.basedOn, this.participant, this.appointment, this.period, this.length, this.reasonCode, this.reasonReference, this.diagnosis, this.account, this.hospitalization, this.location, this.serviceProvider, this.partOf);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Location
    extends BackboneElement {
        @ReferenceTarget(value={"Location"})
        @Required
        private final Reference location;
        @Binding(bindingName="EncounterLocationStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the location.", valueSet="http://hl7.org/fhir/ValueSet/encounter-location-status|4.0.1")
        private final EncounterLocationStatus status;
        @Binding(bindingName="PhysicalType", strength=BindingStrength.ValueSet.EXAMPLE, description="Physical form of the location.", valueSet="http://hl7.org/fhir/ValueSet/location-physical-type")
        private final CodeableConcept physicalType;
        private final Period period;
        private volatile int hashCode;

        private Location(Builder builder) {
            super(builder);
            this.location = ValidationSupport.requireNonNull(builder.location, "location");
            this.status = builder.status;
            this.physicalType = builder.physicalType;
            this.period = builder.period;
            ValidationSupport.checkReferenceType(this.location, "location", "Location");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Reference getLocation() {
            return this.location;
        }

        public EncounterLocationStatus getStatus() {
            return this.status;
        }

        public CodeableConcept getPhysicalType() {
            return this.physicalType;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.location != null || this.status != null || this.physicalType != null || this.period != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.location, "location", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.physicalType, "physicalType", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.location, other.location) && Objects.equals(this.status, other.status) && Objects.equals(this.physicalType, other.physicalType) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.location, this.status, this.physicalType, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference location;
            private EncounterLocationStatus status;
            private CodeableConcept physicalType;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder location(Reference location) {
                this.location = location;
                return this;
            }

            public Builder status(EncounterLocationStatus status) {
                this.status = status;
                return this;
            }

            public Builder physicalType(CodeableConcept physicalType) {
                this.physicalType = physicalType;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Location build() {
                return new Location(this);
            }

            protected Builder from(Location location) {
                super.from(location);
                this.location = location.location;
                this.status = location.status;
                this.physicalType = location.physicalType;
                this.period = location.period;
                return this;
            }
        }
    }

    public static class Hospitalization
    extends BackboneElement {
        private final Identifier preAdmissionIdentifier;
        @ReferenceTarget(value={"Location", "Organization"})
        private final Reference origin;
        @Binding(bindingName="AdmitSource", strength=BindingStrength.ValueSet.PREFERRED, description="From where the patient was admitted.", valueSet="http://hl7.org/fhir/ValueSet/encounter-admit-source")
        private final CodeableConcept admitSource;
        @Binding(bindingName="ReAdmissionType", strength=BindingStrength.ValueSet.EXAMPLE, description="The reason for re-admission of this hospitalization encounter.", valueSet="http://terminology.hl7.org/ValueSet/v2-0092")
        private final CodeableConcept reAdmission;
        @Binding(bindingName="PatientDiet", strength=BindingStrength.ValueSet.EXAMPLE, description="Medical, cultural or ethical food preferences to help with catering requirements.", valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
        private final List<CodeableConcept> dietPreference;
        @Binding(bindingName="Courtesies", strength=BindingStrength.ValueSet.PREFERRED, description="Special courtesies.", valueSet="http://hl7.org/fhir/ValueSet/encounter-special-courtesy")
        private final List<CodeableConcept> specialCourtesy;
        @Binding(bindingName="Arrangements", strength=BindingStrength.ValueSet.PREFERRED, description="Special arrangements.", valueSet="http://hl7.org/fhir/ValueSet/encounter-special-arrangements")
        private final List<CodeableConcept> specialArrangement;
        @ReferenceTarget(value={"Location", "Organization"})
        private final Reference destination;
        @Binding(bindingName="DischargeDisp", strength=BindingStrength.ValueSet.EXAMPLE, description="Discharge Disposition.", valueSet="http://hl7.org/fhir/ValueSet/encounter-discharge-disposition")
        private final CodeableConcept dischargeDisposition;
        private volatile int hashCode;

        private Hospitalization(Builder builder) {
            super(builder);
            this.preAdmissionIdentifier = builder.preAdmissionIdentifier;
            this.origin = builder.origin;
            this.admitSource = builder.admitSource;
            this.reAdmission = builder.reAdmission;
            this.dietPreference = Collections.unmodifiableList(ValidationSupport.checkList(builder.dietPreference, "dietPreference", CodeableConcept.class));
            this.specialCourtesy = Collections.unmodifiableList(ValidationSupport.checkList(builder.specialCourtesy, "specialCourtesy", CodeableConcept.class));
            this.specialArrangement = Collections.unmodifiableList(ValidationSupport.checkList(builder.specialArrangement, "specialArrangement", CodeableConcept.class));
            this.destination = builder.destination;
            this.dischargeDisposition = builder.dischargeDisposition;
            ValidationSupport.checkReferenceType(this.origin, "origin", "Location", "Organization");
            ValidationSupport.checkReferenceType(this.destination, "destination", "Location", "Organization");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Identifier getPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier;
        }

        public Reference getOrigin() {
            return this.origin;
        }

        public CodeableConcept getAdmitSource() {
            return this.admitSource;
        }

        public CodeableConcept getReAdmission() {
            return this.reAdmission;
        }

        public List<CodeableConcept> getDietPreference() {
            return this.dietPreference;
        }

        public List<CodeableConcept> getSpecialCourtesy() {
            return this.specialCourtesy;
        }

        public List<CodeableConcept> getSpecialArrangement() {
            return this.specialArrangement;
        }

        public Reference getDestination() {
            return this.destination;
        }

        public CodeableConcept getDischargeDisposition() {
            return this.dischargeDisposition;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.preAdmissionIdentifier != null || this.origin != null || this.admitSource != null || this.reAdmission != null || !this.dietPreference.isEmpty() || !this.specialCourtesy.isEmpty() || !this.specialArrangement.isEmpty() || this.destination != null || this.dischargeDisposition != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.preAdmissionIdentifier, "preAdmissionIdentifier", visitor);
                    this.accept(this.origin, "origin", visitor);
                    this.accept(this.admitSource, "admitSource", visitor);
                    this.accept(this.reAdmission, "reAdmission", visitor);
                    this.accept(this.dietPreference, "dietPreference", visitor, CodeableConcept.class);
                    this.accept(this.specialCourtesy, "specialCourtesy", visitor, CodeableConcept.class);
                    this.accept(this.specialArrangement, "specialArrangement", visitor, CodeableConcept.class);
                    this.accept(this.destination, "destination", visitor);
                    this.accept(this.dischargeDisposition, "dischargeDisposition", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Hospitalization other = (Hospitalization)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.preAdmissionIdentifier, other.preAdmissionIdentifier) && Objects.equals(this.origin, other.origin) && Objects.equals(this.admitSource, other.admitSource) && Objects.equals(this.reAdmission, other.reAdmission) && Objects.equals(this.dietPreference, other.dietPreference) && Objects.equals(this.specialCourtesy, other.specialCourtesy) && Objects.equals(this.specialArrangement, other.specialArrangement) && Objects.equals(this.destination, other.destination) && Objects.equals(this.dischargeDisposition, other.dischargeDisposition);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.preAdmissionIdentifier, this.origin, this.admitSource, this.reAdmission, this.dietPreference, this.specialCourtesy, this.specialArrangement, this.destination, this.dischargeDisposition);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier preAdmissionIdentifier;
            private Reference origin;
            private CodeableConcept admitSource;
            private CodeableConcept reAdmission;
            private List<CodeableConcept> dietPreference = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> specialCourtesy = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> specialArrangement = new ArrayList<CodeableConcept>();
            private Reference destination;
            private CodeableConcept dischargeDisposition;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder preAdmissionIdentifier(Identifier preAdmissionIdentifier) {
                this.preAdmissionIdentifier = preAdmissionIdentifier;
                return this;
            }

            public Builder origin(Reference origin) {
                this.origin = origin;
                return this;
            }

            public Builder admitSource(CodeableConcept admitSource) {
                this.admitSource = admitSource;
                return this;
            }

            public Builder reAdmission(CodeableConcept reAdmission) {
                this.reAdmission = reAdmission;
                return this;
            }

            public Builder dietPreference(CodeableConcept ... dietPreference) {
                for (CodeableConcept value : dietPreference) {
                    this.dietPreference.add(value);
                }
                return this;
            }

            public Builder dietPreference(Collection<CodeableConcept> dietPreference) {
                this.dietPreference = new ArrayList<CodeableConcept>(dietPreference);
                return this;
            }

            public Builder specialCourtesy(CodeableConcept ... specialCourtesy) {
                for (CodeableConcept value : specialCourtesy) {
                    this.specialCourtesy.add(value);
                }
                return this;
            }

            public Builder specialCourtesy(Collection<CodeableConcept> specialCourtesy) {
                this.specialCourtesy = new ArrayList<CodeableConcept>(specialCourtesy);
                return this;
            }

            public Builder specialArrangement(CodeableConcept ... specialArrangement) {
                for (CodeableConcept value : specialArrangement) {
                    this.specialArrangement.add(value);
                }
                return this;
            }

            public Builder specialArrangement(Collection<CodeableConcept> specialArrangement) {
                this.specialArrangement = new ArrayList<CodeableConcept>(specialArrangement);
                return this;
            }

            public Builder destination(Reference destination) {
                this.destination = destination;
                return this;
            }

            public Builder dischargeDisposition(CodeableConcept dischargeDisposition) {
                this.dischargeDisposition = dischargeDisposition;
                return this;
            }

            @Override
            public Hospitalization build() {
                return new Hospitalization(this);
            }

            protected Builder from(Hospitalization hospitalization) {
                super.from(hospitalization);
                this.preAdmissionIdentifier = hospitalization.preAdmissionIdentifier;
                this.origin = hospitalization.origin;
                this.admitSource = hospitalization.admitSource;
                this.reAdmission = hospitalization.reAdmission;
                this.dietPreference.addAll(hospitalization.dietPreference);
                this.specialCourtesy.addAll(hospitalization.specialCourtesy);
                this.specialArrangement.addAll(hospitalization.specialArrangement);
                this.destination = hospitalization.destination;
                this.dischargeDisposition = hospitalization.dischargeDisposition;
                return this;
            }
        }
    }

    public static class Diagnosis
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Condition", "Procedure"})
        @Required
        private final Reference condition;
        @Binding(bindingName="DiagnosisRole", strength=BindingStrength.ValueSet.PREFERRED, description="The type of diagnosis this condition represents.", valueSet="http://hl7.org/fhir/ValueSet/diagnosis-role")
        private final CodeableConcept use;
        private final PositiveInt rank;
        private volatile int hashCode;

        private Diagnosis(Builder builder) {
            super(builder);
            this.condition = ValidationSupport.requireNonNull(builder.condition, "condition");
            this.use = builder.use;
            this.rank = builder.rank;
            ValidationSupport.checkReferenceType(this.condition, "condition", "Condition", "Procedure");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Reference getCondition() {
            return this.condition;
        }

        public CodeableConcept getUse() {
            return this.use;
        }

        public PositiveInt getRank() {
            return this.rank;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.condition != null || this.use != null || this.rank != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.condition, "condition", visitor);
                    this.accept(this.use, "use", visitor);
                    this.accept(this.rank, "rank", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diagnosis other = (Diagnosis)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.condition, other.condition) && Objects.equals(this.use, other.use) && Objects.equals(this.rank, other.rank);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.condition, this.use, this.rank);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference condition;
            private CodeableConcept use;
            private PositiveInt rank;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder condition(Reference condition) {
                this.condition = condition;
                return this;
            }

            public Builder use(CodeableConcept use) {
                this.use = use;
                return this;
            }

            public Builder rank(PositiveInt rank) {
                this.rank = rank;
                return this;
            }

            @Override
            public Diagnosis build() {
                return new Diagnosis(this);
            }

            protected Builder from(Diagnosis diagnosis) {
                super.from(diagnosis);
                this.condition = diagnosis.condition;
                this.use = diagnosis.use;
                this.rank = diagnosis.rank;
                return this;
            }
        }
    }

    public static class Participant
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ParticipantType", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Role of participant in encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        private final List<CodeableConcept> type;
        private final Period period;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson"})
        private final Reference individual;
        private volatile int hashCode;

        private Participant(Builder builder) {
            super(builder);
            this.type = Collections.unmodifiableList(ValidationSupport.checkList(builder.type, "type", CodeableConcept.class));
            this.period = builder.period;
            this.individual = builder.individual;
            ValidationSupport.checkReferenceType(this.individual, "individual", "Practitioner", "PractitionerRole", "RelatedPerson");
            ValidationSupport.requireValueOrChildren(this);
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Reference getIndividual() {
            return this.individual;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.type.isEmpty() || this.period != null || this.individual != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.individual, "individual", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Participant other = (Participant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.period, other.period) && Objects.equals(this.individual, other.individual);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.period, this.individual);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private Period period;
            private Reference individual;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder individual(Reference individual) {
                this.individual = individual;
                return this;
            }

            @Override
            public Participant build() {
                return new Participant(this);
            }

            protected Builder from(Participant participant) {
                super.from(participant);
                this.type.addAll(participant.type);
                this.period = participant.period;
                this.individual = participant.individual;
                return this;
            }
        }
    }

    public static class ClassHistory
    extends BackboneElement {
        @Binding(bindingName="EncounterClass", strength=BindingStrength.ValueSet.EXTENSIBLE, description="Classification of the encounter.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActEncounterCode")
        @Required
        private final Coding clazz;
        @Required
        private final Period period;
        private volatile int hashCode;

        private ClassHistory(Builder builder) {
            super(builder);
            this.clazz = ValidationSupport.requireNonNull(builder.clazz, "class");
            this.period = ValidationSupport.requireNonNull(builder.period, "period");
            ValidationSupport.requireValueOrChildren(this);
        }

        public Coding getClazz() {
            return this.clazz;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.clazz != null || this.period != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.clazz, "class", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassHistory other = (ClassHistory)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.clazz, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Coding clazz;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder clazz(Coding clazz) {
                this.clazz = clazz;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public ClassHistory build() {
                return new ClassHistory(this);
            }

            protected Builder from(ClassHistory classHistory) {
                super.from(classHistory);
                this.clazz = classHistory.clazz;
                this.period = classHistory.period;
                return this;
            }
        }
    }

    public static class StatusHistory
    extends BackboneElement {
        @Binding(bindingName="EncounterStatus", strength=BindingStrength.ValueSet.REQUIRED, description="Current state of the encounter.", valueSet="http://hl7.org/fhir/ValueSet/encounter-status|4.0.1")
        @Required
        private final EncounterStatus status;
        @Required
        private final Period period;
        private volatile int hashCode;

        private StatusHistory(Builder builder) {
            super(builder);
            this.status = ValidationSupport.requireNonNull(builder.status, "status");
            this.period = ValidationSupport.requireNonNull(builder.period, "period");
            ValidationSupport.requireValueOrChildren(this);
        }

        public EncounterStatus getStatus() {
            return this.status;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.status != null || this.period != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusHistory other = (StatusHistory)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.status, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private EncounterStatus status;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder status(EncounterStatus status) {
                this.status = status;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public StatusHistory build() {
                return new StatusHistory(this);
            }

            protected Builder from(StatusHistory statusHistory) {
                super.from(statusHistory);
                this.status = statusHistory.status;
                this.period = statusHistory.period;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EncounterStatus status;
        private List<StatusHistory> statusHistory = new ArrayList<StatusHistory>();
        private Coding clazz;
        private List<ClassHistory> classHistory = new ArrayList<ClassHistory>();
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private CodeableConcept serviceType;
        private CodeableConcept priority;
        private Reference subject;
        private List<Reference> episodeOfCare = new ArrayList<Reference>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Participant> participant = new ArrayList<Participant>();
        private List<Reference> appointment = new ArrayList<Reference>();
        private Period period;
        private Duration length;
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private List<Diagnosis> diagnosis = new ArrayList<Diagnosis>();
        private List<Reference> account = new ArrayList<Reference>();
        private Hospitalization hospitalization;
        private List<Location> location = new ArrayList<Location>();
        private Reference serviceProvider;
        private Reference partOf;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EncounterStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusHistory(StatusHistory ... statusHistory) {
            for (StatusHistory value : statusHistory) {
                this.statusHistory.add(value);
            }
            return this;
        }

        public Builder statusHistory(Collection<StatusHistory> statusHistory) {
            this.statusHistory = new ArrayList<StatusHistory>(statusHistory);
            return this;
        }

        public Builder clazz(Coding clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder classHistory(ClassHistory ... classHistory) {
            for (ClassHistory value : classHistory) {
                this.classHistory.add(value);
            }
            return this;
        }

        public Builder classHistory(Collection<ClassHistory> classHistory) {
            this.classHistory = new ArrayList<ClassHistory>(classHistory);
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder serviceType(CodeableConcept serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Builder priority(CodeableConcept priority) {
            this.priority = priority;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder episodeOfCare(Reference ... episodeOfCare) {
            for (Reference value : episodeOfCare) {
                this.episodeOfCare.add(value);
            }
            return this;
        }

        public Builder episodeOfCare(Collection<Reference> episodeOfCare) {
            this.episodeOfCare = new ArrayList<Reference>(episodeOfCare);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder participant(Participant ... participant) {
            for (Participant value : participant) {
                this.participant.add(value);
            }
            return this;
        }

        public Builder participant(Collection<Participant> participant) {
            this.participant = new ArrayList<Participant>(participant);
            return this;
        }

        public Builder appointment(Reference ... appointment) {
            for (Reference value : appointment) {
                this.appointment.add(value);
            }
            return this;
        }

        public Builder appointment(Collection<Reference> appointment) {
            this.appointment = new ArrayList<Reference>(appointment);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder length(Duration length) {
            this.length = length;
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder diagnosis(Diagnosis ... diagnosis) {
            for (Diagnosis value : diagnosis) {
                this.diagnosis.add(value);
            }
            return this;
        }

        public Builder diagnosis(Collection<Diagnosis> diagnosis) {
            this.diagnosis = new ArrayList<Diagnosis>(diagnosis);
            return this;
        }

        public Builder account(Reference ... account) {
            for (Reference value : account) {
                this.account.add(value);
            }
            return this;
        }

        public Builder account(Collection<Reference> account) {
            this.account = new ArrayList<Reference>(account);
            return this;
        }

        public Builder hospitalization(Hospitalization hospitalization) {
            this.hospitalization = hospitalization;
            return this;
        }

        public Builder location(Location ... location) {
            for (Location value : location) {
                this.location.add(value);
            }
            return this;
        }

        public Builder location(Collection<Location> location) {
            this.location = new ArrayList<Location>(location);
            return this;
        }

        public Builder serviceProvider(Reference serviceProvider) {
            this.serviceProvider = serviceProvider;
            return this;
        }

        public Builder partOf(Reference partOf) {
            this.partOf = partOf;
            return this;
        }

        @Override
        public Encounter build() {
            return new Encounter(this);
        }

        protected Builder from(Encounter encounter) {
            super.from(encounter);
            this.identifier.addAll(encounter.identifier);
            this.status = encounter.status;
            this.statusHistory.addAll(encounter.statusHistory);
            this.clazz = encounter.clazz;
            this.classHistory.addAll(encounter.classHistory);
            this.type.addAll(encounter.type);
            this.serviceType = encounter.serviceType;
            this.priority = encounter.priority;
            this.subject = encounter.subject;
            this.episodeOfCare.addAll(encounter.episodeOfCare);
            this.basedOn.addAll(encounter.basedOn);
            this.participant.addAll(encounter.participant);
            this.appointment.addAll(encounter.appointment);
            this.period = encounter.period;
            this.length = encounter.length;
            this.reasonCode.addAll(encounter.reasonCode);
            this.reasonReference.addAll(encounter.reasonReference);
            this.diagnosis.addAll(encounter.diagnosis);
            this.account.addAll(encounter.account);
            this.hospitalization = encounter.hospitalization;
            this.location.addAll(encounter.location);
            this.serviceProvider = encounter.serviceProvider;
            this.partOf = encounter.partOf;
            return this;
        }
    }
}

