/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EndpointStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.ValueSet.TRIAL_USE)
@Constraint(id="endpoint-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/endpoint-connection-type", expression="connectionType.exists() and connectionType.memberOf('http://hl7.org/fhir/ValueSet/endpoint-connection-type', 'extensible')", generated=true)
public class Endpoint
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EndpointStatus", strength=BindingStrength.ValueSet.REQUIRED, description="The status of the endpoint.", valueSet="http://hl7.org/fhir/ValueSet/endpoint-status|4.0.1")
    @Required
    private final EndpointStatus status;
    @Summary
    @Binding(bindingName="endpoint-contype", strength=BindingStrength.ValueSet.EXTENSIBLE, valueSet="http://hl7.org/fhir/ValueSet/endpoint-connection-type")
    @Required
    private final Coding connectionType;
    @Summary
    private final String name;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference managingOrganization;
    private final List<ContactPoint> contact;
    @Summary
    private final Period period;
    @Summary
    @Binding(bindingName="PayloadType", strength=BindingStrength.ValueSet.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/endpoint-payload-type")
    @Required
    private final List<CodeableConcept> payloadType;
    @Summary
    @Binding(bindingName="MimeType", strength=BindingStrength.ValueSet.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
    private final List<Code> payloadMimeType;
    @Summary
    @Required
    private final Url address;
    private final List<String> header;
    private volatile int hashCode;

    private Endpoint(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = ValidationSupport.requireNonNull(builder.status, "status");
        this.connectionType = ValidationSupport.requireNonNull(builder.connectionType, "connectionType");
        this.name = builder.name;
        this.managingOrganization = builder.managingOrganization;
        this.contact = Collections.unmodifiableList(ValidationSupport.checkList(builder.contact, "contact", ContactPoint.class));
        this.period = builder.period;
        this.payloadType = Collections.unmodifiableList(ValidationSupport.checkNonEmptyList(builder.payloadType, "payloadType", CodeableConcept.class));
        this.payloadMimeType = Collections.unmodifiableList(ValidationSupport.checkList(builder.payloadMimeType, "payloadMimeType", Code.class));
        this.address = ValidationSupport.requireNonNull(builder.address, "address");
        this.header = Collections.unmodifiableList(ValidationSupport.checkList(builder.header, "header", String.class));
        ValidationSupport.checkReferenceType(this.managingOrganization, "managingOrganization", "Organization");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EndpointStatus getStatus() {
        return this.status;
    }

    public Coding getConnectionType() {
        return this.connectionType;
    }

    public String getName() {
        return this.name;
    }

    public Reference getManagingOrganization() {
        return this.managingOrganization;
    }

    public List<ContactPoint> getContact() {
        return this.contact;
    }

    public Period getPeriod() {
        return this.period;
    }

    public List<CodeableConcept> getPayloadType() {
        return this.payloadType;
    }

    public List<Code> getPayloadMimeType() {
        return this.payloadMimeType;
    }

    public Url getAddress() {
        return this.address;
    }

    public List<String> getHeader() {
        return this.header;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.connectionType != null || this.name != null || this.managingOrganization != null || !this.contact.isEmpty() || this.period != null || !this.payloadType.isEmpty() || !this.payloadMimeType.isEmpty() || this.address != null || !this.header.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.connectionType, "connectionType", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.managingOrganization, "managingOrganization", visitor);
                this.accept(this.contact, "contact", visitor, ContactPoint.class);
                this.accept(this.period, "period", visitor);
                this.accept(this.payloadType, "payloadType", visitor, CodeableConcept.class);
                this.accept(this.payloadMimeType, "payloadMimeType", visitor, Code.class);
                this.accept(this.address, "address", visitor);
                this.accept(this.header, "header", visitor, String.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.connectionType, other.connectionType) && Objects.equals(this.name, other.name) && Objects.equals(this.managingOrganization, other.managingOrganization) && Objects.equals(this.contact, other.contact) && Objects.equals(this.period, other.period) && Objects.equals(this.payloadType, other.payloadType) && Objects.equals(this.payloadMimeType, other.payloadMimeType) && Objects.equals(this.address, other.address) && Objects.equals(this.header, other.header);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.connectionType, this.name, this.managingOrganization, this.contact, this.period, this.payloadType, this.payloadMimeType, this.address, this.header);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EndpointStatus status;
        private Coding connectionType;
        private String name;
        private Reference managingOrganization;
        private List<ContactPoint> contact = new ArrayList<ContactPoint>();
        private Period period;
        private List<CodeableConcept> payloadType = new ArrayList<CodeableConcept>();
        private List<Code> payloadMimeType = new ArrayList<Code>();
        private Url address;
        private List<String> header = new ArrayList<String>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EndpointStatus status) {
            this.status = status;
            return this;
        }

        public Builder connectionType(Coding connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder managingOrganization(Reference managingOrganization) {
            this.managingOrganization = managingOrganization;
            return this;
        }

        public Builder contact(ContactPoint ... contact) {
            for (ContactPoint value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactPoint> contact) {
            this.contact = new ArrayList<ContactPoint>(contact);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder payloadType(CodeableConcept ... payloadType) {
            for (CodeableConcept value : payloadType) {
                this.payloadType.add(value);
            }
            return this;
        }

        public Builder payloadType(Collection<CodeableConcept> payloadType) {
            this.payloadType = new ArrayList<CodeableConcept>(payloadType);
            return this;
        }

        public Builder payloadMimeType(Code ... payloadMimeType) {
            for (Code value : payloadMimeType) {
                this.payloadMimeType.add(value);
            }
            return this;
        }

        public Builder payloadMimeType(Collection<Code> payloadMimeType) {
            this.payloadMimeType = new ArrayList<Code>(payloadMimeType);
            return this;
        }

        public Builder address(Url address) {
            this.address = address;
            return this;
        }

        public Builder header(String ... header) {
            for (String value : header) {
                this.header.add(value);
            }
            return this;
        }

        public Builder header(Collection<String> header) {
            this.header = new ArrayList<String>(header);
            return this;
        }

        @Override
        public Endpoint build() {
            return new Endpoint(this);
        }

        protected Builder from(Endpoint endpoint) {
            super.from(endpoint);
            this.identifier.addAll(endpoint.identifier);
            this.status = endpoint.status;
            this.connectionType = endpoint.connectionType;
            this.name = endpoint.name;
            this.managingOrganization = endpoint.managingOrganization;
            this.contact.addAll(endpoint.contact);
            this.period = endpoint.period;
            this.payloadType.addAll(endpoint.payloadType);
            this.payloadMimeType.addAll(endpoint.payloadMimeType);
            this.address = endpoint.address;
            this.header.addAll(endpoint.header);
            return this;
        }
    }
}

