/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EnrollmentRequestStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.ValueSet.TRIAL_USE)
public class EnrollmentRequest
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="EnrollmentRequestStatus", strength=BindingStrength.ValueSet.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    private final EnrollmentRequestStatus status;
    private final DateTime created;
    @ReferenceTarget(value={"Organization"})
    private final Reference insurer;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference provider;
    @ReferenceTarget(value={"Patient"})
    private final Reference candidate;
    @ReferenceTarget(value={"Coverage"})
    private final Reference coverage;
    private volatile int hashCode;

    private EnrollmentRequest(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(ValidationSupport.checkList(builder.identifier, "identifier", Identifier.class));
        this.status = builder.status;
        this.created = builder.created;
        this.insurer = builder.insurer;
        this.provider = builder.provider;
        this.candidate = builder.candidate;
        this.coverage = builder.coverage;
        ValidationSupport.checkReferenceType(this.insurer, "insurer", "Organization");
        ValidationSupport.checkReferenceType(this.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
        ValidationSupport.checkReferenceType(this.candidate, "candidate", "Patient");
        ValidationSupport.checkReferenceType(this.coverage, "coverage", "Coverage");
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public EnrollmentRequestStatus getStatus() {
        return this.status;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getInsurer() {
        return this.insurer;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public Reference getCandidate() {
        return this.candidate;
    }

    public Reference getCoverage() {
        return this.coverage;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.created != null || this.insurer != null || this.provider != null || this.candidate != null || this.coverage != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.insurer, "insurer", visitor);
                this.accept(this.provider, "provider", visitor);
                this.accept(this.candidate, "candidate", visitor);
                this.accept(this.coverage, "coverage", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnrollmentRequest other = (EnrollmentRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.created, other.created) && Objects.equals(this.insurer, other.insurer) && Objects.equals(this.provider, other.provider) && Objects.equals(this.candidate, other.candidate) && Objects.equals(this.coverage, other.coverage);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.created, this.insurer, this.provider, this.candidate, this.coverage);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private EnrollmentRequestStatus status;
        private DateTime created;
        private Reference insurer;
        private Reference provider;
        private Reference candidate;
        private Reference coverage;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(EnrollmentRequestStatus status) {
            this.status = status;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder insurer(Reference insurer) {
            this.insurer = insurer;
            return this;
        }

        public Builder provider(Reference provider) {
            this.provider = provider;
            return this;
        }

        public Builder candidate(Reference candidate) {
            this.candidate = candidate;
            return this;
        }

        public Builder coverage(Reference coverage) {
            this.coverage = coverage;
            return this;
        }

        @Override
        public EnrollmentRequest build() {
            return new EnrollmentRequest(this);
        }

        protected Builder from(EnrollmentRequest enrollmentRequest) {
            super.from(enrollmentRequest);
            this.identifier.addAll(enrollmentRequest.identifier);
            this.status = enrollmentRequest.status;
            this.created = enrollmentRequest.created;
            this.insurer = enrollmentRequest.insurer;
            this.provider = enrollmentRequest.provider;
            this.candidate = enrollmentRequest.candidate;
            this.coverage = enrollmentRequest.coverage;
            return this;
        }
    }
}

